
                           A "Guided" Tour Of


                       ADVENTURE IN HUMONGOUS CAVE


                       (c) 1990 by David Malmberg


First a little history of the game.  The original Adventure was written in
FORTRAN by Will Crowther in the late 1960's.  He was working for a consulting
firm near MIT at the time.  Crowther based the game on Kentucky's Mammoth Cave
which he had mapped in the mid 60's.  Crowther put the game on APRAnet, a
pioneer telecommunications network linking many universities and private
research institutions across the country.  In 1976, the game was discovered
on APRAnet by Don Woods who was then at Stanford Artificial Intelligence
Laboratory.  Woods contacted Crowther to obtain the source code and to get
permission to enhance the game.  Crowther agreed and helped Woods to re-write
and greatly expand the game.  The combined Crowther-Woods version had about
130 locations and players attempted to score the maximum of 350 points.  It is
this version that is generally referred to as "Colossal Cave", the "Original
Adventure" or simply "Adventure."  This version and its FORTRAN source code
were freely distributed over APRAnet and become widely available on various
mainframes and minicomputers across the nation in the late 1970's.  During the
1980's, this version was translated to other computer languages, including
BASIC and C, and was adapted to run on every microcomputer known to man.

It was this game, the original Adventure, that captivated the time and
imagination of countless Adventurers.  Almost every professional Adventure
game writer (including the infamous Infocomies, Dave Lebling and Marc Blank;
Sierra On-Line's founders, Ken and Roberta Williams; and Adventure
International's Scott Adams) credit the original Adventure with both
introducing them to the genre and inspiring them to write their own games.

Some time during the late 1970's, David Platt of Honeywell's Los Angles
Development Center expanded Crowther and Woods' Adventure game to
approximately 200 locations and a maximum of 550 points.  This version became
know as the "Enhanced Adventure" or "Adventure 550."  The Platt version was
installed on most of the major time-sharing systems (CompuServe, The Source,
GEnie, etc.) during the 1980's and became very popular with users and system
operators alike.  (The amount of money spent and still being spent on
time-sharing connect charges playing either Adventure 350 or Adventure 550
must be truly staggering!)

I had developed a version of the original Adventure as a sample game for my
adventure game authoring system (the Adventure Game Toolkit or AGT --
co-developed by Mark Welch) in the late 1980's.  When I release a new version
of AGT designed to create very large adventure games, I again turned to the
original Adventure for both inspiration and a sample game.  I was able to find
the source code for David Platt's enhanced 550-point version on a bulletin
board.  Both the Crowther-Woods and the Platt versions of Adventure have
become "public domain" and the code and text of the games can be (and have
been) freely used by others.  Using Platt's code as my staring point, I have
further expanded and enhanced the Adventure to encompass 300 locations and
over 200 creatures, treasures and puzzles -- thereby creating what I believe
to be the largest text adventure game currently available on any
microcomputer.  ADVENTURE IN HUMONGOUS CAVE is the result of that effort.

Now a few words about the "walk-thru" of the game that follows.  This
walk-thru is just one way to solve this adventure.  Of course, it is also
possible to solve ADVENTURE IN HUMONGOUS CAVE using other sequences of
commands.  Similarly, the specific vocabulary shown below is not the only set
of words that work.  There are many synonyms for both verbs and nouns that
work equally well in the game.

Also, this walk-thru uses single, simple commands for increased clarity even
though the Adventure Game Toolkit (AGT) is capable of understanding more
complex, compound commands.  For example, AGT is capable of moving from
outside the building and entering the cave if the player enters the following
single command:

SOUTH, SOUTH AND SOUTH; UNLOCK THE GRATE WITH IRON KEY THEN OPEN IT, THEN DOWN

For clarity in the walk-thru, the players commands will always be shown
in their simplest form and in their smallest "pieces", i.e., the above
command will be broken in to its individual pieces and each will be
given separately as follow:

           SOUTH
           SOUTH
           SOUTH
           UNLOCK GRATE (with key or keys implied)
           OPEN IT (grate implied)
           DOWN

On last point about the walk-thru before we actually begin it.  The walk-thru
given below only visits about two thirds of the locations in the game.
Similarly, it does not attempt to be to try out every possible command or show
every possible clever answer to each potentially futile attempt to solve the
various puzzles.  Rather, the walk-thru is the "shortest" way to actually
solve the game in a logical sequence and to get a perfect score of 1000
points.  By a "logical sequence", I mean that you must discover hints, tools,
magic words, etc. before you actually use them in the walk-thru.

Throughout this walk-thru, explanations and comments will be shown after an
arrow and two dashes like the following:

<-- For convenience, here are the instructions:

During your adventure in the cave, I will be your eyes and hands.  I know of
places, actions, and things.  Most of my vocabulary describes places and is
used to move you there.  To move, try words like FOREST, BUILDING, STREAMBED,
ENTER, EAST, NORTHWEST, NORTH, SOUTH, UP or DOWN.  I know about a few special
objects, like a black rod hidden in the cave.  These objects can be
manipulated using some of the various action words I know.  The objects may
have side effects; for instance, the rod scares the bird.  Usually adventurers
having trouble moving just need to try a few more words.  Usually people
trying unsuccessfully to manipulate an object are attempting something beyond
their (or my!) capabilities and should try a completely different tack.  To
speed the game you can sometimes move long distances with a single word.  For
example, "BUILDING" usually gets you to the building from anywhere above
ground except when lost in the forest.  Also, note that cave passages turn a
lot, and that leaving a room to the NORTH does not guarantee entering the next
from the SOUTH.

      Your commands should generally be in the format:

       <verb> <(multiple) noun phrase(s)> <preposition> <noun phrase/object>

      Some (hypothetical) examples of valid commands:

         PLACE A RED ROCK IN THE SMALL BOWL
         PUT THE GREEN ROCK AND THE SMALL PEBBLE BEHIND THE OAK TREE
         READ MY POETRY BOOK
         SWIM IN THE SWIMMING POOL
         EXAMINE THE GOLD RING, THE DWARF AND THE SILVER NECKLACE
         EAT THE CELERY, THE TUNA, THE APPLE AND THE ONION
         THROW THE BATTLE AXE AND THE LARGE ROCK AT THE WEREWOLF
         SHOOT THE BURGLAR WITH THE REVOLVER
         ATTACK HIM
           ("HIM" will refer to last noun mentioned, e.g., the burglar)
         FIRE THE LASER PISTOL AT THE ALIEN MUTANT
         GET THE BOOK (also: TAKE THE BOOK)
         READ IT
           ("IT" will refer to last noun mentioned, e.g., the book)
         GET ALL (will get everything movable at the current location)
         GET THE KEYS, BOTTLE, FOOD AND THE CLOAK
         EXAMINE THE KEYS, BOTTLE, FOOD AND CLOAK
         PUSH THE RED BUTTON AND THE GREEN BUTTON
         UNLOCK THE FILE CABINET WITH THE STEEL KEY
         JUMP THROUGH THE OPENING
         JUMP OVER THE LOG
         NORTH
         SOUTHWEST
         PLACE AN AXE AND THE SHIELD NEXT TO THE BIG TREE
         PUT THE FOOD ON THE KITCHEN TABLE
         TURN ON THE FLASHLIGHT
         LIGHT THE TORCH WITH THE WOODEN MATCHES
         SCREAM AT THE UGLY TROLL
         CLIMB UP THE LADDER
         EXTINGUISH THE FIRE (or PUT OUT THE FIRE)
         DRINK THE WHITE WINE
         THROW THE FIRE WOOD IN THE STOVE
         PULL THE BELL CORD
         WEAR THE STUPID HAT (also: PUT ON THE STUPID HAT)
         TAKE OFF THE HAT (also: REMOVE THE HAT)
         NE (for NORTHEAST)
         DROP THE KEY AND THE BOTTLE
         ENTER THE CAVE
         XYZZY (i.e., a "magic" word)
         TURN THE DOORKNOB
         PLAY WITH THE DOG
         TALK TO (or TALK WITH) THE OLD MAN (ABOUT THE WEATHER)
         TELL JEFF ABOUT THE SWORD
         ASK JODIE ABOUT THE CRIME

      Compound commands can be created by connecting single commands (like
      those above) with "AND", "THEN" or the punctuation symbols "," or ";" to
      connect two or more separate commands.  However, "end-of-sentence"
      punctuation symbols like ".", "!" and "?" should not be used.  Below are
      a few examples of valid compound commands:

         TURN THE DOORKNOB THEN ENTER THE CAVE
         CLIMB DOWN THE LADDER THEN SOUTH, WEST AND NORTHWEST
         GET THE CLOAK AND THEN EXAMINE IT; READ THE LABEL
         DROP THE FOOD AND THE BOTTLE THEN UNLOCK THE DOOR AND THEN LEAVE
         GET THE TORCH, LIGHT IT WITH THE WOODEN MATCHES THEN EXAMINE IT

      If the game understands all of the words in your command, but still
      seems confused by the command -- then try to say the same thing using
      fewer words and a simpler sentence.  When in doubt, simplify your
      input commands as much as possible.  This also saves typing effort.


SPECIAL COMMANDS:

      The game uses a number of special commands for various "housekeeping"
      chores.  These are all pretty standard for most adventure games,
      specifically:

        HELP           May (or may not) give you a hint.

        SCORE          Will summarize your progress, so far.

        INVENTORY      Will display a list of the items you are carrying, and
                       those items you are wearing.

        BRIEF          Will cause location descriptions to be brief.

        VERBOSE        Will cause location descriptions to be verbose.

        LOOK           Will give you a full (verbose) description of
                       your current location.

        LIST EXITS     Will list the obvious (visible) exits from your current
                       location.  There may be other ways to exit the location
                       -- but they may not be obvious.

        OOPS           Will allow you to edit (using the cursor keys, and the
                       delete, insert and backspace keys) your previous
                       input command.  For example, if you enter THORW ROPE by
                       mistake, OOPS will enable you to edit this command and
                       correct it to THROW ROPE.

        SAVE GAME      Will save the current game status on disk.

        RESTORE GAME   Will restore a previously saved game from disk.

        SCRIPT         Causes output to go to both the screen and a printer
                       (using the LP1 port).

        UNSCRIPT       Causes output to go to the screen (only).

        QUIT           Quits the current game session.  Always exit using QUIT
                       -- so the game can erase some temporary data files and
                       save disk space!


FUNCTION AND ALT-CURSOR KEYS:

      The combination of the ALT key and the cursor keys have all been
      programmed to create an input command corresponding to their respective
      movement or compass directions, i.e., the ALT key and the up-arrow key
      causes a NORTH command to be generated, the ALT key and the home key
      causes a NORTHWEST command to be generated, etc.

      Similarly, the function keys have been predefined to stand for several
      of the most frequently used commands.  Further, by giving the command
      DEFINE, you may re-define any of the function keys to give any command
      you wish.  For example, in this game you might find it useful to
      re-define one of the function keys to give the command KILL ORC WITH AXE
      or GIVE CANDY TO BABY.

      Hitting the '?' key (during the game) will display a diagram of keys and
      their current definitions.


"POP-UP" HINTS:

      This game also has a "pop-up" hint system.  Any time you are stuck and
      need a hint, hit the <Alt> key and the <h> key together and a
      menu-driven system of hints for the game will pop-up for you to use.
      Hitting the ESC key will return you to the game when you are done with
      the hints.


"LOOK-AND-FEEL" OPTIONS:

      This particular game is using a special version of the AGT (Adventure
      Game Toolkit) called the "Master's Edition" which allows the user to
      customize the manner in which the game's general interface is defined
      and to specify the game's overall "look-and-feel."  The user may define
      color schemes, status line options, command input method, size and
      "layout" of the screen, etc.  Once the player has a set of
      "look-and-feel" options he or she likes, these options may be saved as
      the standard defaults for this game and any other AGT game the user
      plays.

      One of the options available is a unique "menu-driven" input option that
      allows the player to enter game commands by selecting words from a menu.
      This option is particularly helpful for players who are often frustrated
      by their inability to figure out an adventure game's vocabulary -- since
      the menu always displays a list of "feasible" (though not always "smart"
      or even appropriate) commands from which the player may make a
      selection.

      The "look-and-feel" options are accessed by hitting the ESC key during
      the game (i.e., not now).


SPECIAL CHALLENGE:

When first released, this game offered a special $100 prize to the first
person to discover 10 "secret words" that were hidden throughout this
adventure!!!  Sorry, but the prize has already been won.

But as a special challenge, the secret words have been left in the game.  Try
to find them!!!


<-- This "walk-thru" will be given in a number of separate "campaigns", where
    each campaign consists of a group of closely related locations and/or
    puzzles.  The specific campaigns in the walk-thru are:

        1 -- Outside The Cave
        2 -- Below The Building
        3 -- Near The Cave Entrance
        4 -- In The Heart Of The Cave
        5 -- Beyond The Oyster
        6 -- Across The Troll Bridge
        7 -- Above The Beanstalk
        8 -- The End-Game


<-- Now, let's actually begin the game with the first campaign.


< ----------------  CAMPAIGN 1 -- Outside The Cave -------------------------->

<-- You begin the adventure here at the end of the road.

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  Next to the door of the building, there is a faded sign.

What Now? NOTIFY  <-- Game will now notify player of score changes.

OK

What Now? READ SIGN

When first released, this game offered a special $100 prize to the first
person to discover 10 "secret words" that were hidden throughout this
adventure!!!  Sorry, but the prize has already been won.

But as a special challenge, the secret words have been left in the game.  Try
to find them!!!

What Now? AGAIN

This game was created using the "Master's Edition" of the Adventure Game
Toolkit (AGT).  The "Master's Edition" is the long-awaited and long-promised
version 2.0 of AGT and represents the response to over five years of AGT
user's requests for improvements and additional capabilities and features.

The MASTER'S EDITION of ADVENTURE GAME TOOLKIT is designed to allow a game
designer/writer to create and play his/her own high-quality text adventure
games with optional graphic illustrations, sound effects and music.  Once
created, these adventure games can be shared with and enjoyed by others --
even if they do not have a copy of the Adventure Game Toolkit themselves.

FEATURES OF MASTER'S EDITION OF THE ADVENTURE GAME TOOLKIT

The Master's Edition of AGT has a number of features that make it the most
comprehensive text adventure game creation product currently available.  Some
of these key features are:

   *     Default "look-and-feel" of Infocom adventure games with similar
         screen layout and standard vocabulary and routines.

   *     Large standard vocabulary with potential to define many more words
         unique to a specific adventure.  Typical games can have a vocabulary
         of 1000 words or more.

   *     Sophisticated parser that can understand (1) complex input commands
         including pronouns (IT, HIM, HER, THEM, MY and ITS), and (2) compound
         commands separated by AND or THEN or punctuation symbols, and (3)
         commands addressed to characters within the game.  Here are a few
         examples of commands AGT can handle with ease:

              GET THE FLASH LIGHT AND THEN SWITCH IT ON
              PUT ON THE CLOAK, THEN EXAMINE IT; READ ITS LABEL
              PLACE THE GREEN ROCK AND THE SMALL PEBBLE BEHIND THE TREE
              ENTER THE HOUSE; GET ALL; EXIT; SOUTH; SOUTH THEN DOWN
              SULU, SET A COURSE FOR ALPHA 14
              SCOTTY, BEAM DOWN A TRICORDER AND THE QWERTY MODULE
              DROP THE FOOD, THE KEY AND THE BOTTLE THEN UNLOCK THE DOOR WITH
                   THE BRASS KEY AND THEN LEAVE

   *     Function and cursor keys predefined to input frequently used commands
         and move directions.  Function keys may also be redefined to input
         frequently used commands like THROW AXE AT DWARF or GIVE MILK BOTTLE
         TO BABY.

   *     An OOPS feature that allows you to edit/correct your input commands.

   *     SCRIPT and UNSCRIPT commands to echo game output to printer.

   *     Optional graphic illustrations using PCX formatted pictures for
         display on CGA, EGA or VGA screens.  The PCX format is the most
         widely available of any picture format and is supported by most PAINT
         and/or DRAW programs.  Plus -- a great deal of PCX "clip-art" is
         available.

   *     Optional music and sound effects that can be played in the
         "background" during the game.  These sound effects use the PC's
         internal speaker and do not require any special "sound card."

   *     Optional user-definable "look-and-feel" interface including a
         menu-driven player input option that displays feasible commands for
         the player to pick from.

   *     Optional "pop-up" hints available when the <Alt> and <h> keys are
         pressed at the same time.

   *     Optional fonts (EGA and VGA monitors only) that can be changed to
         suit the needs of the game.  The Master's Edition comes with over
         30 sample fonts including Old English, Scrawl, Computereze.  Plus, a
         Font Editor is provided that allows you to create your own unique
         fonts.

   *     Totally "backward" compatible with all previous versions of AGT.

WHAT THE REVIEWERS HAVE SAID ABOUT THE ADVENTURE GAME TOOLKIT

     "Using the Adventure Game Toolkit, anyone with an ounce of
     imagination can create a text adventure game ... similar in layout
     and sophistication to those made by Infocom and other commercial
     developers."

        -- Donald B. Trivette in PC Magazine

     "The Adventure Game Toolkit (AGT) acts as a compiler which allows
     for creating remarkably complex and sophisticated games in a fairly
     simple way .... AGT's parser reminds me of Infocom's."

        -- Scorpia in Computer Gaming World

     "If you have ever wondered what it is like to create your own
     adventure games, but didn't have the programming knowledge to do it,
     this product is for you .... The process is easy ... and you'll have
     hours of fun doing it."

        -- Resul DeMaria in Public Domain Software & Shareware

     "The Adventure Game Toolkit from Softworks ... provides all the
     tools you need to build your own text based adventure games .... The
     Adventure Game Toolkit is an extremely powerful development
     package."

        -- Bob Napp in "Big Blue Disk"

    The Adventure & Strategy Club (of England) selected the Adventure Game
    Toolkit as the Best Utility of 1991/1992.

DIFFERENCES BETWEEN THE NORMAL EDITION AND THE MASTER'S EDITION OF AGT

The "Normal Edition" (i.e., the normal version) of AGT is very simple to use
and can be used by programming novices or even by non-programmer's to create
very professional text adventures similar to those from firms like Infocom.
Versions of the "Normal Edition" are available for IBM, Macintosh, Atari ST
and Amiga computers and games created on any of these computers can be
re-compiled and played on any of the other computers.

The Normal Edition is still supported and available from Softworks as
Shareware for only $20 (or $40 including a 223 page printed manual with lots
and lots of detailed examples).  This price covers the cost of two ZIPped
disks with over 1.5 megabytes of goodies including summary documentation on
disk, and the AGT source code to over a dozen adventure games that may be
studied for ideas or simply played for fun.

The "Master's Edition" contains all the features and capabilities of the
"Normal Edition" plus a whole lot more.  It is available only for IBM (or
compatible) computers.  The Master's Edition is aimed at the more
sophisticated and experienced programmer/game designer.  The Master's Edition
allows you to create games that are approximately twice as large as those
possible using the Normal Edition.  Plus, your games can have optional graphic
illustrations, sound effects, music, "pop-up" hints, unique fonts (EGA or VGA
screens only), and a customizeable "look-and-feel" user interface including a
menu-driven player input option.

The Master's Edition is available from Softworks for only $50.  This price
includes the cost of five ZIPped disks with over 3.5 megabytes of goodies
including complete documentation on disk, a bunch of game creation utilities,
several brand new sample games including the complete AGT source code to
HUMONGOUS CAVE (believed to be the largest text adventure game available on
any microcomputer).  The Master's Edition package also includes the complete
AGT source code to the game you are currently playing with all of its related
font, music, sound effects and pictures files.

Which version is right for you?  If you are a "power" gamer/programmer and
know that you can use (or need) the full power of the Master's Edition, then
by all means -- get the Master's Edition.  If you have less experience with
programming or game design, then you should probably start with the Normal
Edition.  If you select the Normal Edition, you can always upgrade later when
you need the full power of the Master's Edition -- for a special "registered
AGT user" upgrade price of only $35.

To order either the Normal Edition or the Master's Edition, just write or
call:

    Softworks
    43064 Via Moraga
    Mission San Jose, California  94539

    VISA or MasterCard accepted for telephone orders
    (510) 659-0533   6:00 PM to 9:00 PM -- PST only!

To get a printed order form, just enter the COMMAND: PRINT ORDER FORM

Softworks is a member of the Association of Shareware Professionals -- your
guarantee of quality in shareware software.

                            Ŀ
                      Ŀ                   (tm)
                   ĳ         O    
                         Ŀ    Association of
                                     Shareware
                      Ĵ    O         Professionals
                   ĳ        
                               MEMBER


SECRET WORD #1 -- ABRADE (v) to wear away by friction; to erode.

What Now? PRINT ORDER FORM

DIFFERENCES BETWEEN THE CLASSIC EDITION AND THE MASTER'S EDITION OF AGT

The "Classic Edition" (i.e., the normal/old/regular version) of AGT is very
simple to use and can be used by programming novices or even by
non-programmer's to create very professional text adventures similar to those
from firms like Infocom.  Versions of the "Classic Edition" are available for
IBM, Macintosh, Atari ST and Amiga computers and games created on any of these
computers can be re-compiled and played on any of the other computers.  The
Classic Edition is still supported and available from Softworks as Shareware
for only $20 (or $40 including a 223 page printed manual with lots and lots of
detailed examples).

The "Master's Edition" contains all the features and capabilities of the
"Classic Edition" plus a whole lot more.  It is totally compatible with the
Classic Edition and games originally developed for the Classic Edition can be
easily converted to and used with the Master's Edition.  The Master's Edition
is available only for IBM (or compatible) computers.  The Master's Edition is
aimed at the more sophisticated and experienced programmer/game designer.  The
Master's Edition allows you to create games that are approximately twice as
large as those possible using the Classic Edition.  Plus, your games can have
optional graphic illustrations, sound effects, music, "pop-up" hints, unique
fonts (EGA or VGA screens only), and a customizeable "look-and-feel" user
interface including a menu-driven player input option.

The Master's Edition is available from Softworks for only $50.  This price
includes the cost of six ZIPped disks with over 5 megabytes of goodies
including complete documentation on disk, a bunch of game creation utilities,
several brand new sample games including the complete AGT source code to
HUMONGOUS CAVE (believed to be the largest text adventure game available on
any microcomputer).  The Master's Edition package also includes the complete
AGT source code to the game you are currently playing with all of its related
files.

Which version is right for you?  If you are a "power" gamer/programmer and
know that you can use (or need) the full power of the Master's Edition, then
by all means -- get the Master's Edition.  If you have less experience with
programming or game design, then you should probably start with the Classic
Edition.  If you select the Classic Edition, you can always upgrade later when
you need the full power of the Master's Edition -- for a special "registered
AGT user" upgrade price of only $35.

           ADVENTURE GAME TOOLKIT (AGT) REGISTRATION/ORDER FORM

Remit to:
    Softworks
    43064 Via Moraga
    Mission San Jose, California  94539-5748

You can also order by phone using your Mastercard or VISA by dialing
(510) 659-0533, 6:00 PM to 9:00 PM., PST ONLY, Monday to Thursday
                9:00 AM to 5:00 PM., PST ONLY, Saturday and Sunday

AGT Registration (Classic Edition)........................ $ 20.00     $ ______
    includes: (1) Notice of future AGT upgrades, new AGT Adventures and
    related AGT products.  (2) Latest version of the programs, sample
    Adventure game source files (CAVE, CRUSADE, UNDERGND, ALICE and others),
    and summary documentation on disk.  Over one and half megabyte of program
    and data files -- ZIPped on two disks.  (3) Telephone support from 7 PM to
    9 PM PST (M-Th) plus Weekends.  (4) The option to upgrade to the Master's
    Edition of AGT at any time for only $ 35.

Above with printed AGT manual (Classic Edition)........... $ 40.00     $ ______
    includes: Above items plus printed manual (223 pages) with numerous
    detailed examples on how to use the Adventure Game Toolkit to create very
    professional and very clever Adventure games.  The printed AGT manual has
    approximately 300% the amount of information as contained in the summary
    disk documentation.

Printed "Classic Edition" AGT manual (Only) .............. $ 25.00     $ ______

Master's Edition AGT Purchase ............................ $ 50.00     $ ______
    The Master's Edition of AGT is for the IBM only and is aimed at
    more sophisticated programmers/game designers.  The package includes:
    (1) Notice of future AGT upgrades, new AGT Adventures and related AGT
    products.  (2) Latest version of the Master's Edition programs and
    utilities, sample Adventure game source files (HUMONGOUS CAVE, HURRY,
    PORK, SQUYNCH, PIRATE and others), and complete documentation on disk.
    Over five megabyte of program and data files -- ZIPped on six disks.
    (3) Telephone support from 7 PM to 9 PM PST (M-Th) plus Weekends.

    Orders are normally shipped by US mail at no additional charge.
    For UPS ground shipment, please add $5.00............. $ 5.00      $ ______

    Shipments outside the United States are sent via Air Mail:
      For shipments to Africa, Hong Kong, Japan, New Zealand
         or Australia add ................................ $ 14.00     $ ______
      For shipments to Canada or Mexico add............... $  6.00     $ ______
      For shipments to Great Britain and Europe add....... $ 10.00     $ ______
      For shipments elsewhere outside the USA add......... $ 12.00     $ ______

                                                    Subtotal           $ ______

    (California residents please add 8.25% sales tax)          Tax     $ ______

               ******** U.S. Dollars ONLY!!! -------------->>> Total   $ ______

Payment by:    ( ) Check    ( ) MasterCard    ( ) VISA    ( ) Cash

       ADVENTURE GAME TOOLKIT (AGT) REGISTRATION/ORDER FORM -- PAGE 2


   Name: ____________________________________________________________

Company: ____________________________________________________________

Address: ____________________________________________________________

       : ____________________________________________________________

  City : ____________________________________________________________

  State: ___________________________ Zip:____________________________

Country: ____________________________________________________________

Day Phone: _________________________ Eve: ___________________________

 Card #: _________________________________ Exp. Date: _______________

Signature of cardholder: ____________________________________________

AGT Version/Disk Size desired: ______ Macintosh  ______ Atari ST  ______ Amiga

                               ______ IBM 5 1/4  ______ IBM 3 1/2

Disk density desired: ______ High  ______ Low


------------------------ User comments ------------------------------

I heard about the Adventure Game Toolkit (AGT) from
     [ ] - Friend                      [ ] - Disk Vendor
     [ ] - Computer Club               [ ] - Computer Store
     [ ] - CompuServe                  [ ] - BIX
     [ ] - GEnie                       [ ] - Electronic Bulletin Board
     [ ] - Other - Please Specify ________________________________

We would also appreciate any input you would care to give concerning
AGT.  If you have any ideas or comments that would make AGT a better
system, then please let us know.

We value your comments and/or suggestions:

____________________________________________________________________

____________________________________________________________________

____________________________________________________________________

____________________________________________________________________

____________________________________________________________________

____________________________________________________________________

____________________________________________________________________


You just received 10 extra points for printing the order form.  <-- Good Show!

What Now? ENTER

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe door is closed.
  A huge grandfather clock stands against the wall.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  There is a shiny brass lamp nearby.  It is off.
  There is tasty food here.
  There is a small bottle of water here.
  There is cloak made from a heavy metallic fabric here.

What Now? GET LAMP AND EXAMINE IT

The grandfather loudly chimes the quarter hour.  It is 6:45.

You are now carrying the brass lantern.

The lamp runs on batteries and is currently turned off.

What Now? EXAMINE CLOCK

The grandfather clock is about eight feet tall.  It ticks very noisily.

It is 6:45 A.M.

What Now? EXIT

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  Next to the door of the building, there is a faded sign.

What Now? NORTH

<< Forest >>
You are in open forest near both a valley and a road.

What Now? NORTH

Are you trying to get into the cave?
Please answer Yes or No: NO  <-- You lose points if you accept hints.

<< Thick woods >>
You are in the midst of a thick woods.  The ground is damp with dew.  The air
is chilly and you shiver from the cold.  The only path leads south -- back the
way you came.
  There are large trees here.
  There are a lot of leaves on the ground all around you.

What Now? EXAMINE TREES AND LEAVES

The trees here are mostly large maples.  One of the trees has a heart carved
on its trunk.  Inside the heart is carved "Dave + Ann = Love" and below the
heart is the date "July 20, 1943."  Someone has also scratched the cryptic
message "Turn Right First!" on the truck below the heart.  You wonder what
that might mean.

<-- The date 7-20-43 is the combination to the safe!

The leaves are mostly from maple trees.  They are showing lots of fall colors.
Were you expecting something else, perhaps?

What Now? NO

Don't be so negative!

What Now? SOUTH

<< Forest >>
You are in open forest, with a deep valley to one side.
  There is a piece of crumpled paper here.

What Now? GET PAPER AND EXAMINE IT

You are now carrying the crumpled paper.

The paper appears to be some kind of map.  It is torn at the top of the
paper.   

What Now? READ MAP

     |    |                                                        |    |
 ____|    |____      ______________      ______________      ______|    |___
|    MAZE      |____|   MAZE       |____|    MAZE      |____|        SE     |
|             N ____             SW ____              E ____        MAZE    |
|______________|    |____  E   ____|    |______________|    |_______________|
                     ____|    |____
                    |WEST END OF   |
                    |ROYAL HALL    |
                    |____   E  ____|
                     ____|    |____
                    |EAST END OF   |
                    |ROYAL HALL    |
                    |______________|

What Now? SOUTH

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  Next to the door of the building, there is a faded sign.

What Now? ENTER

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe door is closed.
  A huge grandfather clock stands against the wall.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  There is tasty food here.
  There is a small bottle of water here.
  There is cloak made from a heavy metallic fabric here.

What Now? DROP PAPER

You drop the crumpled paper.

What Now? EXIT

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  Next to the door of the building, there is a faded sign.

What Now? WEST

<< Hill by road >>
You have walked up a hill, still in the forest.  A road slopes down the side
of the hill to the east.  There is a small brick building in the distance at
the end of the road.

A path leads down into a large valley to the west.

What Now? WEST

<< Eastern Side Of Valley >>
You are standing amidst some trees on the eastern edge of a large valley.  The
forest continues to the north, south and west, although a deep stream bars any
exit west.  There is a small path winding through the trees and up the hill to
the east.
  A small but wilted rose has been left here.

What Now? GET ROSE AND EXAMINE IT

You are now carrying the small rose.

The rose is slowly wilting away.

What Now? NORTH

<< Thick Forest >>
You are lost amidst a thick mass of trees and bushes which block direct paths
forcing you to take long and probably circular routes in your attempts to get
past them.
  A large juicy red apple lies temptingly before you.

What Now? GET APPLE AND EXAMINE IT

You are now carrying the red apple.

This is a nice big juicy red apple, not the type of apple that would be
poisoned at all.

Your score just increase by 15 to 25.  <-- All "treasures" in this game are
                                           worth 15 points each.

What Now? WEST

<< Stream Edge >>
You are on the edge of the stream, hemmed close to the water by thick bushes,
and clumps of reeds.  One or two gaps in the hedges allow you to squeeze
northward back into the main part of the forest.  Other paths allow you to
walk west or east along the stream bank.

What Now? WEST

<< Humpbacked Bridge >>
You are standing at the northern end of a small humpbacked bridge, a
picturesque stone structure, coated in moss and creepers which crosses the
stream to the south of you.  Paths seem to converge here from the north, west
and east.

What Now? WEST

<< Stream >>
You are standing beside a narrow stream, which tinkles eastward through the
trees.  You can travel through the trees in any direction save for south where
the stream has cut a deep channel too wide to ford.

What Now? WEST

<< Stream >>
You are standing beside a small silvery stream which gurgles gently from a
rocky hollow to the west, to run gently eastward between the trees which
surround you.

Tracks lead through the trees in all directions.

What Now? WEST

<< Spring >>
You are standing in a small rocky hollow on the edge of the western mountains.
A single spring trickles from the rock here, running eastward out into the
valley proper.  Apart from east back into the valley, steep rocky cliffs bar
all exits.
  A small stone pitcher has been placed here.

What Now? EXAMINE PITCHER

The pitcher has been carved out of a single piece of rock, probably granite.

What Now? PUT ROSE IN PITCHER

OK.  You put the rose in the pitcher.

What Now? PUT WATER IN PITCHER

The pitcher is now full of cool water.

As soon as water and the rose met, the rose seems to take on a whole new life.
Its petals open wider and its color gets richer.  Strangely enough, it even
smells better.

<-- The rose just needed some water to revive its beauty.

What Now? GET ROSE AND EXAMINE IT

You are now carrying the beautiful rose.

The rose is in full bloom.  It is a beautiful rich red color and smells
wonderful.

Your score just increase by 15 to 40.

What Now? SMELL ROSE

The rose smells wonderful.

Your score just increase by 10 to 50.

<-- You must stop to smell the roses -- especially since it is worth 10
    points.

What Now? EAST

<< Stream >>
You are standing beside a small silvery stream which gurgles gently from a
rocky hollow to the west, to run gently eastward between the trees which
surround you.

Tracks lead through the trees in all directions.

What Now? EAST

<< Stream >>
You are standing beside a narrow stream, which tinkles eastward through the
trees.  You can travel through the trees in any direction save for south where
the stream has cut a deep channel too wide to ford.

What Now? EAST

<< Humpbacked Bridge >>
You are standing at the northern end of a small humpbacked bridge, a
picturesque stone structure, coated in moss and creepers which crosses the
stream to the south of you.  Paths seem to converge here from the north, west
and east.

What Now? EAST

<< Stream Edge >>
You are on the edge of the stream, hemmed close to the water by thick bushes,
and clumps of reeds.  One or two gaps in the hedges allow you to squeeze
northward back into the main part of the forest.  Other paths allow you to
walk west or east along the stream bank.

What Now? NORTH

<< Forests Edge >>
You stand on the edge of the forest, which extends south east and west as far
as you can see.  To the north the trees give way to a grassy hill.  A narrow
worn path leads north up the hill.  To the south the path through the forest
is almost blocked by thick hedges, but a few gaps enable you to squeeze
through. 

What Now? NORTH

<< On Path >>
You stand on a path which leads south -- down into the valley and northward
into a churchyard of some sort, with a ruined church standing beside it.

What Now? NORTH

<< Churchyard >>
You stand in what is apparently an old and disused churchyard.  Weeds and moss
cover the crumbling gravestones and paths.  To the east is a huge ancient
church, now decaying and surrounded by bits of fallen stonework.  To the north
the graveyard continues.

What Now? EAST

<< Arched Entry >>
You stand in what must have once been a magnificent arched entrance, with huge
oak doors, and a carved doorway fit for a palace.  Now however the doors lie
in rotting pieces on the floor, and rain drips down the moss covered
stonework.

What Now? EAST

<< The Church >>
You stand in the center of the now battered and dilapidated church.  Water
runs down the walls, dripping in pools onto the rotting remains of the pews.
The church extends northward, and southward toward the altar.  To the west
is the exit.

What Now? NORTH

<< North End Of Church >>
You stand at the north end of the church, looking south down between the
silent rows of rotting pews.  Another doorway leads east into a small room.
  There are some wax candles here.

What Now? EXAMINE CANDLES

The candles are just that.  Wax candles.  Not long ones or fancy candles,
just plain old regular candles.  Every adventure game needs a light source
of some kind.  Why should this game be any different???
There are 5 candles.

What Now? INVENTORY

You are carrying the following:
  red apple
  beautiful rose
  brass lantern
You are wearing the following:
  brown knapsack

What Now? EXAMINE KNAPSACK

The knapsack is about a foot square and is brown.  It has a flap which can be
opened and closed.

What Now? OPEN KNAPSACK

The brown knapsack is now open.

What Now? EXAMINE IT

The knapsack is about a foot square and is brown.  It has a flap which can be
opened and closed.
    There are some matches here. (in the knapsack)

What Now? GET MATCHES AND EXAMINE THEM

You are now carrying the wooden matches.

The matches are just that.  Wooden matches.  Not long ones or fancy matches,
just plain old regular matches.  There are 10 matches.

What Now? LIGHT CANDLE AND EXAMINE IT

You light the candle which burns brightly.

The candle is burning brightly.  However, the wind is whistling through the
room and the candle is unlikely to burn for too much longer.

What Now? PRAY

Prayer is good for the soul.  You feel better, now.

Your score just increase by 15 to 65.  <-- Need to PRAY with a lighted candle

What Now? PRAY

<-- Only once, however.

You're going to need a lot of prayer before this adventure is over.

What Now? DROP MATCHES  <-- Wont need again.

You drop the wooden matches.

What Now? DROP KNAPSACK  <-- Wont need again.

You drop the brown knapsack.

What Now? SOUTH

<< The Church >>
You stand in the center of the now battered and dilapidated church.  Water
runs down the walls, dripping in pools onto the rotting remains of the pews.
The church extends northward, and southward toward the altar.  To the west
is the exit.

What Now? SOUTH

<< By The Altar >>
You are standing beside the altar, now barely recognizable, a smashed and aged
pile of rotten wood and fabrics, hiding mossy stonework beneath.  A set of
steps lead up to the east, probably to the church tower.  The main church hall
is north, and to the south you can go behind the altar.

What Now? SOUTH

<< Behind The Altar >>
You stand behind the altar looking northward along the length of the church
which is a very sorry sight indeed, everything wooden is rotting, the
stonework is moss covered, and gaping holes in the roof allow you to look
skyward. 
  A small silver cross on a silver chain lies sparkling before you!

What Now? GET CROSS AND EXAMINE IT

You are now carrying the silver cross.

The cross is silver and hangs in the center of the chain which is also silver.

Your score just increase by 15 to 80.

What Now? WEAR CROSS

You are now wearing the silver cross.

<-- Wearing the cross protects you against Vampire bat attacks.

What Now? NORTH

<< By The Altar >>
You are standing beside the altar, now barely recognizable, a smashed and aged
pile of rotten wood and fabrics, hiding mossy stonework beneath.  A set of
steps lead up to the east, probably to the church tower.  The main church hall
is north, and to the south you can go behind the altar.

What Now? EAST

<< Stairs >>
You stand on a set of slippery stone steps which lead both downwards and upward
from here.  Doorways lead south into a small room and west into the main
church hall.

What Now? UP

A sudden draft blows out your candle.  <-- Candle only stays lit inside Church.

<< The Stairs >>
You are climbing a set of steep, slippery stairs that lead up into the church
tower.  Water runs down the steps, collecting in mossy pools, where the cracks
and dips in the stonework allow it.  The steps turn from stone to wood up
above, and look very dodgy.

To the west a doorway leads out into the pulpit.

What Now? WEST

<< The Pulpit >>
You stand in the rotting remains of what was the pulpit, looking north along
the length of the church hall, a sorry sight indeed, and also gazing up
through the holes in the roof, skyward.

There is a large wooden sign nailed to the pulpit.  Its paint is flaked and
faded.   

A doorway leads east onto some stairs.

What Now? READ SIGN

The paint is cracked and faded and the letters are difficult to read.
However, it appears to be a long list of commandments.  There are many, many,
many more than ten.  Your eyes scan the list and fall randomly on a
commandment near the bottom of the list.

You just make it out...

COMMANDMENT #12592
Oh ye who write Adventure Games that torment the player with stupid puzzles:
Dost thou know the magnitude of thy sin before the gods?  Yea, verily, thou
shalt be ground between two stones.  Shall the angry gods cast thy body into
the whirlpool?  Surely, thy eye shall be put out with a sharp stick!  Even
unto the ends of the earth shalt thou wander and unto the land of the dead
shalt thou be sent at last.  Surely thou shalt repent of thy low cunning.

You smile and nod your head in agreement and approval.

<-- A little "foreshadowing" of things to come!

Your score just increase by 10 to 90.

What Now? EAST

<< The Stairs >>
You are climbing a set of steep, slippery stairs that lead up into the church
tower.  Water runs down the steps, collecting in mossy pools, where the cracks
and dips in the stonework allow it.  The steps turn from stone to wood up
above, and look very dodgy.

To the west a doorway leads out into the pulpit.

What Now? DOWN

<< Stairs >>
You stand on a set of slippery stone steps which lead both downwards and upward
from here.  Doorways lead south into a small room and west into the main
church hall.

What Now? SOUTH

<< Bell Ringers' Room >>
You are standing in a small stone room, which is both wet and cold.  The
wooden roof above you has holes in it through which ropes hang, presumably for
the church bells.  A single doorway leads north.

What Now? EXAMINE ROPES

The ropes are pulled to ring the church bells.

What Now? PULL ROPES

Ding! Dong!

Your score just increase by 10 to 100.<-- Ringing the bells is worth 10 points.

What Now? RING BELLS  <-- Only once, however.

Ding! Dong!

What Now? CLIMB ROPES

You climb up the rope to the room above, where you find...

<< The Bells, The Bells!! >>
You stand in a large chamber packed with bells.  There is a doorway to the
north.  The bell ropes hang down through holes in the floor.
  A golden weathercock has been left here, somewhat out of order.

What Now? GET COCK AND EXAMINE IT

You are now carrying the golden weathercock.

The weathercock is made of solid gold.  It is meant to show which way the wind
is blowing.  This one looks like it is broken.

Your score just increase by 15 to 115.

What Now? CLIMB ROPES

You climb down the rope to the room below, where you find...

<< Bell Ringers' Room >>
You are standing in a small stone room, which is both wet and cold.  The
wooden roof above you has holes in it through which ropes hang, presumably for
the church bells.  A single doorway leads north.

What Now? NORTH

<< Stairs >>
You stand on a set of slippery stone steps which lead both downwards and upward
from here.  Doorways lead south into a small room and west into the main
church hall.

What Now? DOWN

<< The Crypt >>
You stand in the crypt.  The room is damp and dismal and smells moldy.  It is
a creepy and sinister place.  You can't help but give a little shudder either
from the cold or from fear.  A staircase leads up and back out of the crypt.
  You see a very grimy, dirty urn.
  A large closed coffin sits against one wall.
  There are quite a few moldy bones scattered on the floor.
  There is a small skull nearby.
  There are cobwebs everywhere.

What Now? EXAMINE SKULL AND BONES

The skull is rather small and ugly.  The back of the skull looks like it has
been crushed.

The head bone is connected to the neck bone.
The neck bone is connected to the back bone.
The back bone is connected to the front bone.  etc. etc. ...

What Now? GET URN AND EXAMINE IT

You are now carrying the dirty urn.

The urn is encrusted with what looks like decades of grime and dirt.  There
appears to be some writing on the side.

What Now? READ URN

The urn is too dirty to make out the words.

What Now? OPEN COFFIN

You manage to slide the coffin lid off and discover a stairway inside the
coffin leading down into the darkness below.

What Now? DOWN

<< Cavern >>
You are in a cavern with iridescent glowing walls.  A stairway leads up.
There is an opening in the wall to the east.
  There is a long ladder here.

What Now? GET LADDER AND EXAMINE IT

You are now carrying the long ladder.

The ladder is made out of wood and is about 10 feet long.  It is quite heavy.

What Now? UP

You climb the stairs only to discover that someone has closed the coffin lid.
You push and push, but you can't budge it.  You are trapped!

<-- The player must throw something into the chasm in order to escape.

<< Cavern >>
You are in a cavern with iridescent glowing walls.  A stairway leads up.
There is an opening in the wall to the east.

What Now? EAST

For some reason, you can't see anything here.

What Now? LIGHT LAMP

You hear the flapping of many wings.  Bats!!  A shiver of fear shocks your
very being.

<-- Wearing the cross protects you against Vampire bats.

Your lamp is now shining brightly!

What Now? LOOK

<< Odd room >>
You are in an odd-shaped room with a strange smell.  It is dark and musty.
There are openings to the west and to the south.
  There is a brass plaque mounted on the north wall of the room.
  Several giant vampire bats are flying about the room.

What Now? EXAMINE BATS

The bats are each about a foot across.  Their wings make a real racket as they
flap around the room.

What Now? SOUTH

<< North ledge >>
You are on a ledge overlooking a deep and wide chasm.  It is too wide to jump.
Peering down into the chasm, you can just barely see the bottom far below.
There is only one exit from the room and it is an opening to the north.
  You see a narrow ledge on the other side of the chasm.

What Now? EXAMINE LEDGE

The ledge juts out over the chasm.  However, it is still too far away to jump.
You don't see how you get across to the ledge.

What Now? EXAMINE CHASM

You peer across the chasm and can just make out the other side through the
thick white mist.  The chasm is too wide to jump.  You drop a small rock over
the edge into the mist and it is quite a while before you hear it hit bottom.

What Now? HELP

Maybe you should try to throw something useful across the chasm!

What Now? THROW LADDER OVER CHASM

The ladder disappears into the chasm.

What Now? HELP

You shouldn't believe everything you read in Adventure Games -- even the HELP
messages!

Your score just increase by 10 to 125.

<-- Asking for HELP after throwing something into the chasm is worth 10 points.

What Now? NORTH

<< Odd room >>
You are in an odd-shaped room with a strange smell.  It is dark and musty.
There are openings to the west and to the south.
  There is a brass plaque mounted on the north wall of the room.
  Several giant vampire bats are flying about the room.

What Now? WEST

<< Cavern >>
You are in a cavern with iridescent glowing walls.  A stairway leads up.
There is an opening in the wall to the east.

What Now? UP

<< The Crypt >>
You stand in the crypt.  The room is damp and dismal and smells moldy.  It is
a creepy and sinister place.  You can't help but give a little shudder either
from the cold or from fear.  A staircase leads up and back out of the crypt.
  There are quite a few moldy bones scattered on the floor.
  There is a small skull nearby.
  There are cobwebs everywhere.
  The open coffin reveals a set of stairs leading down.

What Now? EXTINGUISH LIGHT

Your lamp is now off.

What Now? UP

<< Stairs >>
You stand on a set of slippery stone steps which lead both downwards and upward
from here.  Doorways lead south into a small room and west into the main
church hall.

What Now? WEST

<< By The Altar >>
You are standing beside the altar, now barely recognizable, a smashed and aged
pile of rotten wood and fabrics, hiding mossy stonework beneath.  A set of
steps lead up to the east, probably to the church tower.  The main church hall
is north, and to the south you can go behind the altar.

What Now? NORTH

<< The Church >>
You stand in the center of the now battered and dilapidated church.  Water
runs down the walls, dripping in pools onto the rotting remains of the pews.
The church extends northward, and southward toward the altar.  To the west
is the exit.

What Now? WEST

<< Arched Entry >>
You stand in what must have once been a magnificent arched entrance, with huge
oak doors, and a carved doorway fit for a palace.  Now however the doors lie
in rotting pieces on the floor, and rain drips down the moss covered
stonework.

What Now? WEST

<< Churchyard >>
You stand in what is apparently an old and disused churchyard.  Weeds and moss
cover the crumbling gravestones and paths.  To the east is a huge ancient
church, now decaying and surrounded by bits of fallen stonework.  To the north
the graveyard continues.

What Now? SOUTH

<< On Path >>
You stand on a path which leads south -- down into the valley and northward
into a churchyard of some sort, with a ruined church standing beside it.

What Now? SOUTH

<< Forests Edge >>
You stand on the edge of the forest, which extends south east and west as far
as you can see.  To the north the trees give way to a grassy hill.  A narrow
worn path leads north up the hill.  To the south the path through the forest
is almost blocked by thick hedges, but a few gaps enable you to squeeze
through. 

What Now? SOUTH

<< Stream Edge >>
You are on the edge of the stream, hemmed close to the water by thick bushes,
and clumps of reeds.  One or two gaps in the hedges allow you to squeeze
northward back into the main part of the forest.  Other paths allow you to
walk west or east along the stream bank.

What Now? EAST

<< Thick Forest >>
You are lost amidst a thick mass of trees and bushes which block direct paths
forcing you to take long and probably circular routes in your attempts to get
past them.

What Now? SOUTH

<< Eastern Side Of Valley >>
You are standing amidst some trees on the eastern edge of a large valley.  The
forest continues to the north, south and west, although a deep stream bars any
exit west.  There is a small path winding through the trees and up the hill to
the east.

What Now? EAST

<< Hill by road >>
You have walked up a hill, still in the forest.  A road slopes down the side
of the hill to the east.  There is a small brick building in the distance at
the end of the road.

A path leads down into a large valley to the west.

What Now? EAST

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  Next to the door of the building, there is a faded sign.

What Now? EXAMINE URN

The urn is encrusted with what looks like decades of grime and dirt.  There
appears to be some writing on the side.

What Now? OPEN URN

The dirty urn is now open.

What Now? EXAMINE IT

The urn is encrusted with what looks like decades of grime and dirt.  There
appears to be some writing on the side.
    You see some gray ashes. (in the urn)

What Now? GET ASHES AND EXAMINE THEM

You are now carrying the gray ashes.

The ashes are gray and you suspect they are the remains some dear departed
soul.

What Now? DROP THEM

You drop the gray ashes.  <-- Wont need again.

What Now? WASH URN

As you wash the grime and accumulated years of dirt off of the urn, you
discover that the urn is actually made of gold and encrusted with gems and
precious stones.

Your score just increase by 15 to 140.

What Now? EXAMINE IT

The urn is encrusted with gems and precious stones.  There is some writing on
the side.

What Now? READ URN

Engraved in fancy letters on the side of the urn: Last remains of an unknown
adventurer, who lost his life in Humongous Cave.

What Now? ENTER

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe door is closed.
  A huge grandfather clock stands against the wall.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  There is tasty food here.
  There is a small bottle of water here.
  There is cloak made from a heavy metallic fabric here.
  There is a piece of crumpled paper here.

What Now? INVENTORY

You are carrying the following:
  beautiful rose
  red apple
  jeweled urn
  golden weathercock
  brass lantern
You are wearing the following:
  silver cross

What Now? DROP ALL

Sorry, but you must drop things one-at-a-time, here!

<-- All "treasures" must be dropped inside the building (i.e., here) or inside
    the safe that you will find later in the cave.

What Now? DROP ROSE

As you drop the treasure, a voice booms out: "Well done!  You have collected
1 treasure(s) so far out of a total of 37."

As the rose hits the floor, it disappears in a puff of blue smoke!

What Now? DROP APPLE

As you drop the treasure, a voice booms out: "Well done!  You have collected
2 treasure(s) so far out of a total of 37."

As the apple hits the floor, it disappears in a puff of blue smoke!

What Now? DROP URN

As you drop the treasure, a voice booms out: "Well done!  You have collected
3 treasure(s) so far out of a total of 37."

As the urn hits the floor, it disappears in a puff of blue smoke!

What Now? DROP COCK

As you drop the treasure, a voice booms out: "Well done!  You have collected
4 treasure(s) so far out of a total of 37."

As the weathercock hits the floor, it disappears in a puff of blue smoke!

What Now? DROP CROSS

As you drop the treasure, a voice booms out: "Well done!  You have collected
5 treasure(s) so far out of a total of 37."

As the cross hits the floor, it disappears in a puff of blue smoke!


< ----------------  CAMPAIGN 2 -- Below The Building ------------------------>

What Now? NORTH

<< Tool room >>
You are in a small, low-ceilinged room with the words

   "Witt Company Tool Room - Melenkurion division"

carved into one of the walls.  A doorway exits to the south from here.
  There is a long-handled shovel here.
  There are a pair of suction cups here.

What Now? GET CUPS AND EXAMINE THEM

You are now carrying the suction cups.

The suction cups are connected to a metal bar with a handle to hold them.
These are the kind of suction cups that are used to hold on to something flat
such as a large glass window.  A window washer on a high-rise building might
use these to hold himself on to the glass by giving the command "ATTACH
SUCTION CUPS TO WINDOW."  These could come in handy if you have to wash some
windows. 

What Now? SOUTH

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe door is closed.
  A huge grandfather clock stands against the wall.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  There is tasty food here.
  There is a small bottle of water here.
  There is cloak made from a heavy metallic fabric here.
  There is a piece of crumpled paper here.

What Now? EXAMINE SAFE

The safe takes up most of the east wall of the room.  There is a combination
knob in the center of the safe's door, while to the left of the knob about
eight inches away, is a short handle which is pointing toward the combination
knob.    

You play with the knob and try to turn the handle, but it is no use.  The
safe is locked and you are unable to unlock it.

<-- Remember the date 7-20-43 carved in the tree!

What Now? TURN KNOB

WHICH DIRECTION (LEFT OR RIGHT) ?  RIGHT
What number (from 0 to 99) ? 7

Strange!  Nothing happened.  At least, nothing obvious happened.

What Now? TURN KNOB

WHICH DIRECTION (LEFT OR RIGHT) ?  LEFT
What number (from 0 to 99) ? 20

Strange!  Nothing happened.  At least, nothing obvious happened.

What Now? TURN KNOB

WHICH DIRECTION (LEFT OR RIGHT) ?  RIGHT
What number (from 0 to 99) ? 43

You suddenly hear a loud CLICK!

What Now? OPEN SAFE

You pull the handle with all your strength and the large door slowly swings
open revealing the contents of the vault.

You see.....
  A stone stairway leads down.

Your score just increase by 15 to 155.

<-- Opening the safe with the correct combination is worth 15 points.

What Now? DOWN

You climb down the steep stairway in the safe.

<< Southern end of long hall >>
You are at the southern end of a long hall.  A stairway leads up into the
darkness.  There is a curtain over the open doorway to the south.  The door to
the north is closed.  It is made of thick steel and looks like it could
survive a nuclear blast.
  Next to the steel door is a small slot.

What Now? SOUTH

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? NORTH

A bearded programmer steps out from the shadows and says, "Since you didn't
try to steal any of my stuff, I'll give you a special plastic card and reveal
a secret password.  Use the password wisely and enjoy your stay in HUMONGOUS
CAVE, my son."  With that, the programmer vanishes, leaving a few 0 and 1 bits
that briefly form the word:

     TURBO

<< Southern end of long hall >>
You are at the southern end of a long hall.  A stairway leads up into the
darkness.  There is a curtain over the open doorway to the south.  The door to
the north is closed.  It is made of thick steel and looks like it could
survive a nuclear blast.
  Next to the steel door is a small slot.

What Now? EXAMINE CARD

The plastic card is about 2 by 4 inches.  It has a number of holes in it at
one end.  At the other end, is printed "INSERT THIS END" and there is an arrow
pointing toward the end with the holes.  It looks like one of those electronic
access cards that hotels use rather than normal metal keys.

What Now? EXAMINE SLOT

The door is solid steel.  You must open it by using some kind of access card
-- because above the slot is a small sign that says "INSERT ACCESS CARD FOR
ADMITTANCE."

What Now? INSERT CARD IN SLOT

You insert the card into the slot.  A very loud buzzing sound comes from the
door and then the door swings open and you enter the room to find ...

<< Computer Center >>
You are in a large computer center with a raised floor and recessed lights in
the ceiling.  Large mainframes are everywhere.  There are exits to the north
and south.  There is a sign on the east wall.
  An ancient IBM PC-XT is on a small table in the corner.

What Now? EXAMINE MAINFRAMES

The mainframe computers here are all the latest and greatest, including
Cray's, CDC's, IBM's, DEC's, etc.  There is an incredible amount of computing
power in this room.

What Now? EXAMINE PC-XT

The computer is an ancient IBM PC-XT.  It has a CGA monitor, 512K of memory, a
10 meg hard drive and a floppy disk drive.

What Now? EXAMINE FLOOR

The raised floor is made from special tiles about two feet square.

What Now? ATTACH SUCTION CUPS TO FLOOR

You attach the suction cups to the floor tiles and lift up.  A tile comes up
making a hole in the floor.

Your score just increase by 15 to 170.

What Now? LOOK

<< Computer Center >>
You are in a large computer center with a raised floor and recessed lights in
the ceiling.  Large mainframes are everywhere.  There are exits to the north
and south.  There is a sign on the east wall.
  There is a hole in the floor where one of the tiles has been removed.
  An ancient IBM PC-XT is on a small table in the corner.

What Now? DOWN

For some reason, you can't see anything here.

What Now? LIGHT LAMP

Your lamp is now shining brightly!

What Now? LOOK

<< Beneath Computer Center >>
You are in a small room below the computer center.  Near the ceiling there are
all sorts of wires and cables.  There is also a small hole in the ceiling
which you can just reach.  To the west is a crawlway leading into the
darkness.

What Now? WEST

<< Small Barren Room >>
You are in a small barren room.  This room has even more wires than the room
you were just in.  There is a crawlway leading into the darkness to the east.

What Now? EXAMINE WIRES

The wires and cables are obviously used to connect the computers in the room
above.   

You discover something bright and ticking among the wires.

What Now? LOOK

<< Small Barren Room >>
You are in a small barren room.  This room has even more wires than the room
you were just in.  There is a crawlway leading into the darkness to the east.
  There is a beautiful old gold watch on a matching gold chain here.

What Now? GET WATCH

As you get the watch, you notice the time ...

The time is currently 10:37 A.M.

Your score just increase by 15 to 185.

What Now? EAST

<< Beneath Computer Center >>
You are in a small room below the computer center.  Near the ceiling there are
all sorts of wires and cables.  There is also a small hole in the ceiling
which you can just reach.  To the west is a crawlway leading into the
darkness.

What Now? UP

<< Computer Center >>
You are in a large computer center with a raised floor and recessed lights in
the ceiling.  Large mainframes are everywhere.  There are exits to the north
and south.  There is a sign on the east wall.
  There is a hole in the floor where one of the tiles has been removed.
  An ancient IBM PC-XT is on a small table in the corner.

What Now? DROP CUPS  <-- Wont need again.

You drop the suction cups.

What Now? READ SIGN

The sign reads: "Expiratory Distribution of Partially Ignited Hydrocarbons
into the Immediate Atmosphere Strictly Disallowed".  Below these words is a
picture of a burning cigarette with a red circle and a red line drawn through
it.      

What Now? NORTH

<< Air-Conditioned Room >>
You are in a small barren room.  There is an exit south to the computer
center.  The room is very, very cold because of the cold air blasting thru the
air-conditioning duct in the east wall.

What Now? EXAMINE DUCT

The air-conditioning duct is near the bottom of the east wall.  It is covered
by a metal grate.  Very COLD air is blowing through it.  You are going to
freeze if you stay here much longer.

What Now? GET DUCT

You manage to remove the grate covering the duct.  Like a true adventurer,
you then let your imagination get the better of your good sense and you crawl
into the duct.  You crawl about a hundred feet further into the duct before
you pause to rest at a place where the duct turns to the south.  The air is
still blasting away in the duct and you are very, very cold!

Your score just increase by 10 to 195. <-- Removing duct is worth 10 points.

<< At Turn In duct >>
You are at a elbow-turn in the duct.  The duct extends to the west and to the
south.  You can not see any light in either direction.  It is very cold here!

What Now? SOUTH

You crawl south along the duct for about an hour -- at least, it seems like an
hour.    

<< In The Duct >>
You are in the middle of an extremely long duct.  It extends forever to the
north and to the south.  It is very cold!  Other than being cold, this place
is pretty boring.

What Now? SOUTH

After a brief pause for rest, you set off to the south and crawl for a while
longer.  

<< In The Duct >>
You are in the middle of an extremely long duct.  It extends forever to the
north and to the south.  It is very cold!  You are going to freeze if you
don't get out of here soon.

What Now? SOUTH

After a brief pause for rest, you set off to the south and crawl for a while
longer.  

<< In The Duct >>
You are in the middle of an extremely long duct.  Cold air is blasting at you
from the south.  It is very cold!  The duct extends forever to the north.  To
the south, you can see a faint light.

What Now? SOUTH

After a brief pause for rest, you set off to the south and crawl for a while
longer.  

<< End Of The Duct >>
You at the mouth of a small opening overlooking a large windy cavern.  To the
north is a duct that extends as far as you can see.  The duct is only about
three feet high, so you will need to crawl if you go north.  You can also
climb down or go south to enter the windy cavern.  It is very cold here!

What Now? SOUTH

<< Windy cavern >>
You in a large cavern.  The cavern has a large hole in the ceiling high above
your head.  The hole is too far above you to exit that way.  An incredibly
strong wind blows through the hole in the ceiling.  The wind is very, very
cold and you will freeze if you don't leave here soon.

Passages lead off to the west and to the south.  There is a small opening
about four feet above the ground in the north end of the cavern.

What Now? WEST

<< Paneled passage >>
You in a oak-paneled hallway.  The hall extends to the east and to the west.
A strong wind is blowing from the east.  It is very cold!

What Now? WEST

<< Witt's Private Office >>
You are in the private office of Mr. Ralph Witt.  There is a hallway to the
east.  It is very cold because of the air that blows through the hallway.
There is a large heavy door in the middle of the west wall.

There are the usual office-type pieces of furniture:
  Along the wall is an old file cabinet.
  In the corner, there is a wooden coat rack.
  A nice heavy parka is here. ( on the coat rack )
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  Witt's large oak desk sits in the center of the floor.
  There is a cushy swivel chair. ( behind the desk )
  There is a pile of mail here.
  There is a Compaq 486 sitting on the desk (no office should be without one).

What Now? WEAR PARKA  <-- Needed to keep from freezing to death!

You are now wearing the heavy parka.

What Now? EXAMINE PARKA

The parka looks very warm.  It's stuffed with the finest eider down.  It has a
very heavy zipper with a large pocket on either side.  You can't be sure, but
you suspect there is no pocket lint in either pocket.  The pockets open and
close.   
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)

What Now? EXAMINE POCKET

Which "POCKET", the RIGHT POCKET or the LEFT POCKET?

THE RIGHT POCKET

Pockets are funny.  It's hard to tell whether they're left or right.  If it's
your jacket and you're wearing it, this would be the right pocket.  If it was
someone else's jacket and they were wearing it while you were examining it,
well not only would it be the left pocket but you'd probably get your face
slapped.

What Now? OPEN RIGHT POCKET

The right pocket is now open.

What Now? OPEN LEFT POCKET

The left pocket is now open.

Your score just increase by 15 to 210.

What Now? EXAMINE PARKA

The parka looks very warm.  It's stuffed with the finest eider down.  It has a
very heavy zipper with a large pocket on either side.  You can't be sure, but
you suspect there is no pocket lint in either pocket.  The pockets open and
close.   
    There is a pocket on the right side of the parka. (in the parka)
      There is a giant rabbit's foot here. (in the pocket)
    And, strangely enough, a pocket on the left side also. (in the parka)
      There is a gold key here. (in the pocket)

What Now? GET KEY AND EXAMINE IT

You are now carrying the gold key.

It's one of those old fashioned keys that looks sort of like a 'K'.  It is
made of the finest gold and has the initials R.W. engraved delicately on one
side.    

What Now? GET FOOT AND EXAMINE IT

You are now carrying the rabbit's foot.

The foot looks like it came from a mighty BIG rabbit.  I would sure hate to
run into the sucker who belongs with this foot!

What Now? GET MAIL AND EXAMINE IT

You are now carrying the mail pile.

The 'pile' of mail looks more like a man-made mountain.

What Now? READ MAIL

Every envelope is addressed to Ralph Witt.

Have you forgotten the "Adventurer's Oath" you took to be a goodie two shoes
and to not do anything illegal in this game?  Remember, it is a federal
offense to open other people's mail.

What Now? RUB RABBIT'S FOOT

You rub the rabbit's foot for a while, but nothing happens.

What Now? LOOK

<< Witt's Private Office >>
You are in the private office of Mr. Ralph Witt.  There is a hallway to the
east.  It is very cold because of the air that blows through the hallway.
There is a large heavy door in the middle of the west wall.

There are the usual office-type pieces of furniture:
  Along the wall is an old file cabinet.
  In the corner, there is a wooden coat rack.
  Witt's large oak desk sits in the center of the floor.
  There is a cushy swivel chair. ( behind the desk )
  There is a Compaq 486 sitting on the desk (no office should be without one).

What Now? EXAMINE CHAIR

It's one of those cushy swivel chairs.  Sitting in it would be hazardous to
the completion of your task.  It looks far too comfortable.

What Now? EXAMINE COMPAQ

This is one of those new 100 MegaHertz screamers with the latest in laser
storage devices.  Witt is obviously a POWER user.  The monitor actually looks
more like a hologram.  There is a 3D view of the cave with many lines running
from location to location.

What Now? READ IT

The cave is obviously a very confusing place with locations connected to other
places with little or no rhyme or reason.  Witt is deranged and so is his
cave.

What Now? EXAMINE DESK

The drawer is in the center of the desk.  It has an ornate gold lock.

What Now? UNLOCK DESK WITH KEY

You have now unlocked the oak desk, using the key.

What Now? OPEN DRAWER

The oak desk is now open.

What Now? LOOK

<< Witt's Private Office >>
You are in the private office of Mr. Ralph Witt.  There is a hallway to the
east.  It is very cold because of the air that blows through the hallway.
There is a large heavy door in the middle of the west wall.

There are the usual office-type pieces of furniture:
  Along the wall is an old file cabinet.
  In the corner, there is a wooden coat rack.
  Witt's large oak desk sits in the center of the floor.
    There is a diary here.  It is quite old. (in the desk)
  There is a cushy swivel chair. ( behind the desk )
  There is a Compaq 486 sitting on the desk (no office should be without one).

What Now? GET DIARY

You are now carrying the old diary.

What Now? EXAMINE IT

The diary is ancient.  The leather is dry and cracked and the paper is yellow
and very brittle.  It is full of pithy little insights on life and adventures.

What Now? READ DIARY

This game was created using the Adventure Game Toolkit.

A BRIEF OVERVIEW OF THE ADVENTURE GAME TOOLKIT -- etc., etc., etc...

What Now? READ DIARY

Time is just nature's way of keeping everything from happening at once.

What Now? AGAIN

Trolls like eggs!  <-- The diary has some hints.  Like this one.

What Now? AGAIN

No problem is so formidable that you can't just run away from it.

What Now? AGAIN

You've got to kiss a lot of ugly frogs before you find your handsome prince
(or princess).  <-- The diary has some hints.  Like this one.

What Now? SIT IN CHAIR

Sitting down would be hazardous to the completion of your adventure.  You have
an urgent mission to perform and you had best get on with it.

What Now? EAST

<< Paneled passage >>
You in a oak-paneled hallway.  The hall extends to the east and to the west.
A strong wind is blowing from the east.  It is very cold!

What Now? EAST

<< Windy cavern >>
You in a large cavern.  The cavern has a large hole in the ceiling high above
your head.  The hole is too far above you to exit that way.  An incredibly
strong wind blows through the hole in the ceiling.  The wind is very, very
cold and you will freeze if you don't leave here soon.

Passages lead off to the west and to the south.  There is a small opening
about four feet above the ground in the north end of the cavern.

Your score just increase by 15 to 225.

What Now? INVENTORY

You are carrying the following:
  rabbit's foot
  gold key
  old diary
  rare stamps  <-- Mail changed into rare stamps
  gold watch
  plastic card
  brass lantern
You are wearing the following:
  heavy parka
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)

What Now? EXAMINE STAMPS

The envelopes are all stamped with very rare stamps.  Specifically, the stamps
are all part of a special commemorative series honoring the "Greatest
Adventurers of All Time."  You are pleased to see your face (beaming
brightly) on a pretty blue stamp.  Under your pictures is a caption that
proclaims you as the "(Almost) Conqueror of Humongous Cave."

What Now? NORTH

<< End Of The Duct >>
You at the mouth of a small opening overlooking a large windy cavern.  To the
north is a duct that extends as far as you can see.  The duct is only about
three feet high, so you will need to crawl if you go north.  You can also
climb down or go south to enter the windy cavern.  It is very cold here!

What Now? NORTH

You crawl into the duct and continue to crawl north for a very long time.  The
cold, cold wind blows through the duct from the cavern to your south.

<< In The Duct >>
You are in the middle of an extremely long duct.  Cold air is blasting at you
from the south.  It is very cold!  The duct extends forever to the north.  To
the south, you can see a faint light.

What Now? NORTH

After a brief pause for rest, you set off to the north and crawl for a while
longer.  

<< In The Duct >>
You are in the middle of an extremely long duct.  It extends forever to the
north and to the south.  It is very cold!  You are going to freeze if you
don't get out of here soon.

What Now? NORTH

After a brief pause for rest, you set off to the north and crawl for a while
longer.  

<< In The Duct >>
You are in the middle of an extremely long duct.  It extends forever to the
north and to the south.  It is very cold!  Other than being cold, this place
is pretty boring.

What Now? NORTH

After a brief pause for rest, you set off to the north and crawl for a while
longer.  

<< At Turn In duct >>
You are at a elbow-turn in the duct.  The duct extends to the west and to the
south.  You can not see any light in either direction.  It is very cold here!

What Now? WEST

<< Air-Conditioned Room >>
You are in a small barren room.  There is an exit south to the computer
center.  The room is very, very cold because of the cold air blasting thru the
air-conditioning duct in the east wall.
  There is a metal air-conditioning grate on the floor.

What Now? EXTINGUISH LAMP <-- Conserve your lamp's batteries whenever possible!

Your lamp is now off.

What Now? SOUTH

<< Computer Center >>
You are in a large computer center with a raised floor and recessed lights in
the ceiling.  Large mainframes are everywhere.  There are exits to the north
and south.  There is a sign on the east wall.
  There are a pair of suction cups here.
  There is a hole in the floor where one of the tiles has been removed.
  An ancient IBM PC-XT is on a small table in the corner.

What Now? SOUTH

<< Southern end of long hall >>
You are at the southern end of a long hall.  A stairway leads up into the
darkness.  There is a curtain over the open doorway to the south.  The door to
the north is closed.  It is made of thick steel and looks like it could
survive a nuclear blast.
  Next to the steel door is a small slot.

What Now? UP

You climb up the stairs and enter the room above through the open safe door.
<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A huge grandfather clock stands against the wall.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  There is tasty food here.
  There is a small bottle of water here.
  There is cloak made from a heavy metallic fabric here.
  There is a piece of crumpled paper here.

What Now? INVENTORY

You are carrying the following:
  rabbit's foot
  gold key
  old diary
  rare stamps  <-- pile of mail turned into rare stamps
  gold watch
  plastic card
  brass lantern
You are wearing the following:
  heavy parka
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)

What Now? EXAMINE STAMPS

The envelopes are all stamped with very rare stamps.  Specifically, the stamps
are all part of a special commemorative series honoring the "Greatest
Adventurers of All Time."  You are pleased to see your face (beaming
brightly) on a pretty blue stamp.  Under your pictures is a caption that
proclaims you as the "(Almost) Conqueror of Humongous Cave."

What Now? DROP FOOT

You drop the rabbit's foot.

What Now? DROP PARKA  <-- Wont need again.

You drop the heavy parka.

What Now? DROP GOLD KEY

As you drop the treasure, a voice booms out: "Well done!  You have collected
6 treasure(s) so far out of a total of 37."

As the key hits the floor, it disappears in a puff of blue smoke!

What Now? DROP CARD

You drop the plastic card.

What Now? DROP STAMPS

As you drop the treasure, a voice booms out: "Well done!  You have collected
7 treasure(s) so far out of a total of 37."

As the stamps hits the floor, it disappears in a puff of blue smoke!

What Now? DROP DIARY  <-- Wont need again.

You drop the old diary.

What Now? EXAMINE WATCH

The watch is an old style pocket watch.  It has a matching gold chain.

The time is currently 11:55 A.M.

What Now? DROP IT

As you drop the treasure, a voice booms out: "Well done!  You have collected
8 treasure(s) so far out of a total of 37."

As the watch hits the floor, it disappears in a puff of blue smoke!

What Now? GET KEY

You are now carrying the iron keys.

What Now? EXAMINE CLOAK

The cloak is made from a heavy metallic fabric.  It is big enough that it
would cover your entire body from head to foot.  The manufacturer's label is
sewn to the inside of the cloak.

What Now? READ LABEL

--------------------------------
|    Made of Turbo Gore-tex    |
|      Wash in warm water      |
|------------------------------|
|  Produced by David Malmberg  |
|                              |
|   Based on original design   |
|  by Woods, Crowther & Platt  |
--------------------------------

What Now? WEAR CLOAK

You are now wearing the metallic cloak.

<-- The cloak will protect you from dwarf attacks and other unpleasant
    accidents.  You should wear it whenever you are in the cave if you
    wish to minimize your risk of accidental death.

What Now? EXIT

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  You see some gray ashes.
  Next to the door of the building, there is a faded sign.


< ----------------  CAMPAIGN 3 -- Near The Cave Entrance -------------------->

What Now? SOUTH

<< Valley >>
You are in a valley in the forest beside a stream tumbling along a rocky bed.

What Now? SOUTH

<< Slit in streambed >>
At your feet all the water of the stream splashes into a 2-inch slit in the
rock.  Downstream the streambed is bare rock.

<-- "2-inch" slit is too small to go down.  However, take note since this will
    be useful information for later.

What Now? SOUTH

<< Outside grate >>
You are in a 20-foot depression floored with bare dirt.  Set into the dirt is
a strong steel grate mounted in concrete.  A dry streambed leads into the
depression.
  An iron grate covers a hole in the pit.

What Now? EXAMINE GRATE

The grate is roughly 3 feet square and made of iron.  It has been anchored
into the ground with concrete.  There is a large lock on the outside.

What Now? UNLOCK GRATE  <-- Player needs to have iron keys to do this.

The grate is now unlocked and ready to open.

What Now? OPEN IT

The iron grate is now open.

What Now? DOWN

<< Below the grate >>
You are in a small chamber beneath a 3x3 steel grate to the surface.  A low
crawl over cobbles leads inward to the west.

What Now? WEST

<< Cobble crawlway >>
You are crawling over cobbles in a low passage.  There is a dim light at the
east end of the passage.
  There is a small wicker cage discarded nearby.

What Now? GET CAGE AND EXAMINE IT

You are now carrying the wicker cage.

The wicker cage is a fairly simple design with an opening on the top.

What Now? WEST

For some reason, you can't see anything here.

What Now? LIGHT LAMP

It is now pitch dark.  If you proceed you will likely fall into a pit.
Your lamp is now shining brightly!

What Now? LOOK

<< Debris room >>
You are in a debris room filled with stuff washed in from the surface.  A low
wide passage with cobbles becomes plugged with mud and debris here, but an
awkward canyon leads upward and west.  A note on the wall says:
       Magic Word "XYZZY"
  A three foot black rod with a rusty star on an end lies nearby.

What Now? GET ROD AND EXAMINE IT

You are now carrying the black rod.

The black rod weighs about 2 pounds and doesn't appear to be special or unique
in any manner.

What Now? WEST

<< Awkward canyon >>
You are in an awkward sloping east/west canyon.

What Now? WEST

<< Bird chamber >>
You are in a splendid chamber thirty feet high.  The walls are frozen rivers
of orange stone.  An awkward canyon and a good passage exit from east and west
sides of the chamber.
  A cheerful little bird is sitting here singing.

<-- The bird is afraid of the rod.  So, the player must not be carrying the
    rod when he/she gets the bird.

What Now? DROP ROD

You drop the black rod.

What Now? GET BIRD AND EXAMINE IT

You catch the bird and put it inside the wicker cage.

The bird is a black-bellied plover (rhymes with "lover" not "clover").  Its
Latin name is pluvialis sauatarola.  Its belly is quite black -- hence, the
name: black-bellied plover.  It also has white plumage with a white stripe
extending across its forehead, around its crown and nape and down the sides of
its breast.  Its undertail is white.  Its call is a drawn-out, mournful, three
note whistle with the second note lower pitched, like "plee - o - ee".

<-- I am a birdwatcher.  So, I couldn't resist the temptation.

The bird doesn't appear to like the cage because it has stopped singing.

What Now? GET ROD

You are now carrying the black rod.

What Now? WEST

<< Top of small pit >>
At your feet is a small pit breathing traces of white mist.  An east passage
ends here except for a small "carpal tunnel" leading on.
  Rough stone steps lead down to the pit.

What Now? WEST

<< "Carpal Tunnel" >>
You are in the middle of an East-West "Carpal Tunnel."  You can see light at
the end of tunnel.

Suddenly, you experience some pain in your wrists and it becomes difficult to
type in your game commands.

What Now? WEST

<< Circular Room >>
This is a strange circular shaped room.  There is a sign over a tunnel leading
west that says 'DEAD END'.  Another tunnel exits east -- back the way you
entered from.

At the center of the room, there is a circular staircase leading down.  Even
though you shine your lamp down the stairwell you are unable to see the
bottom.  

What Now? DOWN

A little dwarf just walked around a corner, saw you, threw a little axe at you
which missed, cursed, and ran away.

<< Circular Room >>
This is a strange circular shaped room.  There is a sign over a tunnel leading
west that says 'DEAD END'.  Another tunnel exits east -- back the way you
entered from.

At the center of the room, there is a circular staircase leading down.  Even
though you shine your lamp down the stairwell you are unable to see the
bottom.  
  There is a little axe here.

What Now? GET AXE AND EXAMINE IT

You are now carrying the dwarf's axe.

The dwarf's axe is double-bladed with razor sharp edges.  The handle is about
two feet long.  The axe is ideally balanced for throwing.

What Now? DOWN

There are faint rustling noises from the darkness behind you.

You step on to the staircase and begin to climb down.  You climb down for a
long, long time.  You are getting warmer and quite tired.  You pause to rest.

<< On the Stairs >>
You are on the stairs.  You can see a room far above you.

What Now? DOWN

You resume your climb down.  Down and down you go, round and round you go, in
a spin, lovin the spin your in, under that old black magic ... called love,
etc....  

It is quite warm here.  Once again, you pause to rest.

<< On the Stairs >>
You are on the stairs.  The stairs seems to go on endlessly both above and
below you.

What Now? DOWN

You resume your climb down.  It is really getting hot here.  Once again, you
pause to rest.

<< On the Stairs >>
You are on the stairs.  The stairs seems to go on endlessly both above and
below you.

What Now? DOWN

You resume your climb down.  It is really getting hot here.  Once again, you
pause to rest.

<< On the Stairs >>
You are on the stairs.  The stairs seems to go on endlessly above you.  Far
below, you can just make out a room where the stairs end.

What Now? DOWN

With the end in sight, you make one last effort to finish these !@#$%^&ing
stairs.  You can hardly stand the heat.  Finally, you reach the bottom.

<< Gates of Hell >>
You are outside an iron gate.  Above the gateway there is a large plaque which
is inscribed:

   Abandon every HELP all ye who enter here!

The gate is closed.  Through it you can see flames and hear cries of great
pain and agony.  It is incredibly hot!  The heat seems to be coming from
beyond the gate.  Stairs lead up.
  There is an old rusty bell here.

What Now? EXAMINE GATE

The gate extends from the floor to the ceiling of the room and is made or
iron.  You test its strength by trying to move it.  However, you give up when
it is obvious that someone will have to open it for you.

What Now? EXAMINE BELL

The bell is quite old and very rusty.  There is an inscription that reads
'RING FOR ATTENDANT'.

What Now? RING IT

A few moments after you ring the bell, you hear a voice cry out, "Hold your
horses, I'm coming........damn tourists..."  A little old man in a red velvet
suit appears on the other side of the gates.  He produces a key from a pocket
of his coat and unlocks the gate.

"Welcome to the 12592nd level of Hell.  My name is Fred and I will be your
guide for today's tour", he says.

"This level of Hell is reserved for Adventure game writers.  Here, we
specialize in giving these cruel people some of the same kind of torment that
they gave to those unfortunates that played their fiendish creations.  It
doesn't matter that the game players played willingly -- in their quest for
masochistic pleasures.  No!  No!  No!  Just because the victim is foolish
enough to think he or she is enjoying the experience, doesn't make the crime
any less heinous.  These wicked Adventure game writers were no better than
drug pushers preying on the mental weaknesses of Adventure junkies."

"Remember, as you tour this level of Hell that these people deserve their
eternal torment!  They are just being repaid for the misery they have give to
others.  Do not pity them.  Save you pity for their unfortunate victims!"

With that introduction finished, Fred begins the tour.  You follow him down a
long winding path.  You finally stop by the edge of a cliff.  In the distance
below you is a dark labyrinth of high thorny hedges.  In the middle of the
labyrinth, you can see two figures groping along the hedge walls.  As they
reach out to touch the hedges, they recoil in pain from touching the thorns.

Fred chuckles.  "Those guys are Will Crowther and Don Woods.  They started it
all by writing the first Adventure game -- called simply ADVENTURE.  They are
now doomed to search in the dark through a maze of twisty little passages.
They are trying to find the vending machine to buy some batteries for their
lantern.  They will search forever -- in vain.  A fitting punishment, don't
you agree?"

Fred chuckles again and wanders down the path to the north.  After a few
minutes you arrive at a pleasant sunny meadow.  Off to the south at the edge
of the meadow is a swampy area.  In the middle of the swamp, buried in the mud
is a very strange sight.  A bearded man is trapped under a sleeping dragon.
He alternates between trying to wake the dragon and trying to dig himself free
in the mud.  He continues to struggle, but to no avail.

Fred explains, "That is Scott Adams.  He wrote ADVENTURELAND, PIRATE ADVENTURE
and many, many others.  His Adventure games were the first written for
microcomputers.  Now, he is getting a taste of his own medicine."

"Let's move on."  Fred proceeds to walk to the east.  The ground rises gently
until you find yourself overlooking a deep chasm.  On one side of the chasm
you see a man.  Directly across from him is a woman.  Both are shouting secret
words with very hoarse voices.  They continue to shout out every silly word
imaginable.  There doesn't seem to be any result from their efforts except
their voices get hoarser.

"Ken and Roberta Williams.  They wrote THE WIZARD AND THE PRINCESS, and KING'S
QUEST I, II, III, IV, V, VI, VII, VIII, etc." explains Fred.  "After they
discover the correct secret word, Artichoke, they will get to ride in a leaky
boat with no way to fix the leak."  He chuckles again.

You follow Fred as he continues on the path to the south.  You finally come to
an old house and enter through a broken window.  Fred lifts a rug, brush aside
some leaves and you both peek into a dark room through a small grate.  Below,
you see two men trapped in a brick-walled room.  There are no doors or windows
in the room.  The only exit is the grate and it is locked on the outside.
However, even if the grate was unlocked it would do no good, as both men are
too big to fit through the grate.

"The only way out of the room is by saying the word 'Ahriman'.  Ahriman was
one of the gods of Zoroastrian mythology", Fred whispers.  "After they figure
that one out, we have some really hard puzzles for them.  They are Dave
Lebling and Marc Blank.  They wrote the ZORK series.  You know those, of
course, -- ZORK I, ZORK II, ZORK III, ZORK ZERO, BEYOND ZORK, INSIDE ZORK,
OUTSIDE ZORK, UNDER ZORK, SON OF ZORK, RETURN TO ZORK, BRIDE OF ZORK, 2ND
COUSIN OF ZORK, ZORK MINUS 47, IN SEARCH OF ZORK, ZORK'S REVENGE, ZORK -- THE
SEQUEL, THE HITCHHIKER'S GUIDE TO ZORK, NIGHT OF THE LIVING ZORK, THE
ESSENTIAL ZORK, THE NON-ESSENTIAL ZORK, ZORK TRIVIA, ZORK CONFIDENTIAL, THE
VALLEY OF ZORK, IT CAME FROM ZORK, TALES OF ZORK, THE CREATURE FROM ZORK, ZORK
UNCHAINED, ZORK OBSERVED, THE COMPLEAT ZORK, et al.  For all the pain they have
caused Adventure game players, these two deserve some really terrible
punishment, but there are some things that are even too nasty and gross for
Hell."   

Fred puts the leaves back over the grate, puts the rug over the leaves, and
then leads you outside the house.  You continue the tour for the remainder of
the afternoon.  Finally, exhausted, you return to the entrance gate.

"Well, I hope you have enjoyed the tour of level 12592 of Hell.  And remember,
those fiends deserve their fate or worse.  Don't pity them.  Instead, pity
their victims -- those poor misguided Adventure game players who can't kick
their evil habits!", Fred concludes.

He shakes your hand, says good bye, opens the gate for you to leave and then
locks it behind you.  You find yourself back outside the gate to Hell.  Fred
disappears down the path on the other side.

Your score just increase by 15 to 240.

What Now? UP

You step on to the stairs and begin to climb up.  It seems like a very easy
climb and you don't even have to pause to rest.  You notice that it seems to
get cooler as you climb.  Finally, you reach the top of the stairs almost
refreshed for your little bout of exercise.  (One of the wonders of Adventure
Games is that they need not be logical, consistent or fair.  Sometimes, this
works to the player's advantage -- like now.)

<< Circular Room >>
This is a strange circular shaped room.  There is a sign over a tunnel leading
west that says 'DEAD END'.  Another tunnel exits east -- back the way you
entered from.

At the center of the room, there is a circular staircase leading down.  Even
though you shine your lamp down the stairwell you are unable to see the
bottom.  

What Now? EAST

<< "Carpal Tunnel" >>
You are in the middle of an East-West "Carpal Tunnel."  You can see light at
the end of tunnel.

Suddenly, you experience some pain in your wrists and it becomes difficult to
type in your game commands.

What Now? EAST

<< Top of small pit >>
At your feet is a small pit breathing traces of white mist.  An east passage
ends here except for a small "carpal tunnel" leading on.
  Rough stone steps lead down to the pit.

What Now? DOWN

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

What Now? SOUTH

<< Nugget of gold room >>
This is a low room with a crude note on the wall.  The note says:
       You won't get it up the steps.
  There is a large sparkling nugget of gold here!

What Now? GET NUGGET AND EXAMINE IT

You are now carrying the gold nugget.

The nugget weighs about two pounds and is worth a lot of money.

Your score just increase by 15 to 255.

What Now? NORTH

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

What Now? WEST

<< East bank of fissure >>
You are on the east bank of a fissure slicing clear across the hall.  The mist
is quite thick here, and the fissure is too wide to jump.
  You see a book entitled "Adventure Guidebook".

What Now? EXAMINE BOOK

Out from the shadows behind you pounces a bearded pirate!  "Har, har" he
chortles, "I'll just take all this booty and hide it away with me chest deep
in the maze!".  He snatches your treasure and vanishes into the gloom.

The book is titled "Adventure Guidebook".  It has a subtitle: "The
Adventurer's Book of Wit(t), Wisdom and Hints".  It looks like it might be
helpful. 

Your score just decrease by 15 to 240.

What Now? READ IT

This game was created using the Adventure Game Toolkit.

A BRIEF OVERVIEW OF THE ADVENTURE GAME TOOLKIT, etc.

What Now? AGAIN

If rabbits feet are so lucky, what happened to the rabbit?  <-- Hint!

What Now? AGAIN

A closed mouth gathers no feet.

What Now? AGAIN

Nuke the Whales!

What Now? WAVE ROD

A crystal bridge now spans the fissure.

What Now? EXAMINE BRIDGE

The bridge is made of crystal and must have cost a fortune.  (Probably built
at tax payer expense!)

What Now? WEST

<< West side of fissure >>
You are on the west side of the fissure in the hall of mists.
  There are several diamonds here!
  A crystal bridge spans the fissure.

What Now? GET DIAMONDS AND EXAMINE THEM

You are now carrying the several diamonds.

The diamonds are about 100 carets each and are perfectly clear.

Your score just increase by 15 to 255.

What Now? EAST

<< East bank of fissure >>
You are on the east bank of a fissure slicing clear across the hall.  The mist
is quite thick here, and the fissure is too wide to jump.
  You see a book entitled "Adventure Guidebook".
  A crystal bridge now spans the fissure.

What Now? EAST

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

What Now? NORTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  A huge green fierce snake bars the way!

What Now? EXAMINE SNAKE

The snake is about 8 feet long and about 10 inches in diameter.  It has raised
its head up and is following you with its eyes.  It is hissing at you and its
forked-tongue is darting in and out of its mouth with every hiss.

What Now? RELEASE BIRD

You release the bird from the wicker cage.
The little bird attacks the green snake, and in an astounding flurry drives
the snake away.

Your score just increase by 10 to 265.

<-- Clever!  It must have actually been a road runner, not a plover.

What Now? DROP CAGE  <-- Wont need again.

You drop the wicker cage.

What Now? SOUTH

<< South side chamber >>
You are in the south side chamber.
  There is precious jewelry here!

What Now? GET JEWELRY AND EXAMINE IT

You are now carrying the precious jewelry.

There are several necklaces and bracelets made of gold and silver.  Each of
the pieces also has jewels set into the metal.  This stuff didn't come out of
a Cracker Jack box -- by any means!

Your score just increase by 15 to 280.

What Now? NORTH

There are faint rustling noises from the darkness behind you.

As you turn toward the noise, the beam of your lamp falls across a bearded
pirate.  He is carrying a large chest.  "Shiver me timbers!"  he cries, "I've
been spotted!  I'd best hide meself off to the maze and hide me chest!"  With
that, he vanished into the gloom.

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTHEAST

<< Morion room >>
You are in a small room.  The walls are composed of a dark, almost black form
of smoky quartz; they glisten like teeth in the lamp-light.  The only exit is
the passage to the south through which you entered.
  There is a gem-encrusted visorless helmet sitting on the floor!

What Now? GET HELMET AND EXAMINE IT

You are now carrying the visorless helmet.

The helmet is covered with gems of all kinds -- diamonds, sapphires, rubies,
emeralds, etc.

Your score just increase by 15 to 295.

What Now? SOUTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTHWEST

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? EAST

<< Toad's Hall >>
You are in a small, dank cubicle of rock.  A small passage leads back out to
the south; there is no other obvious exit.
  There is a small mushroom (?) growing on the wall.
  You see a horny toad hopping madly about.

What Now? EXAMINE MUSHROOM

The mushroom looks pretty ordinary.  It looks like every mushroom that you
have ever seen.  Of course, it could be a toadstool; because every toadstool
you have ever seen also looks like every mushroom you have ever seen.  This
mushroom (?) is smaller than most, however.

It is growing out of the dank wall.

What Now? GET MUSHROOM

You pluck the mushroom (?) from the wall where it was growing.

What Now? SOUTH

The toad hops along after you.

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? NORTH

The toad hops along after you.

The toad says: RIB--BIT!

<< Spherical room >>
You're in a large, completely spherical room with polished walls.  A narrow
passage leads out to the north.
  On the ground lies a small glass vial filled with an oily liquid.

What Now? GET VIAL AND EXAMINE IT

There are faint rustling noises from the darkness behind you.

You are now carrying the oily vial.

The vial is completely sealed.  To get at the oily liquid, you must break the
vial.

What Now? NORTH

The toad hops along after you.

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? SOUTH

The toad hops along after you.

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? EXAMINE TOAD

The toad is sort of brownish-green. It is about 4 inches across.  The toad
appears somewhat nervous and keeps hopping about.

What Now? KISS TOAD

You must really have a sick mind!  But -- your wish is my COMMAND and must be
obeyed -- no matter how bizarre.  Ok ...  here goes ...  You pick up the toad.
Grasping it firmly, you give it a tender little kiss on the top of the head.
Suddenly, the earth starts to tremble and the toad begins to glow with a
bright red light.  You are blinded by the light and cover your eyes with your
arm.  After a while the earth stops trembling and you remove your arm from
your eyes.

It's -- it's -- it's turning into a dwarf princess!

She -- she -- she's -- she's -- UGLY! -- VERY UGLY!!!!!!

She's 3'6" tall, and 180 lbs., with black, oily, snarly hair, and three large
warts on her nose, which separates two beady red eyes that don't track.  She
immediately starts to say, in a high-pitched nasal whine, "Trying to pick me
up, eh sweetie?  Where do you think you get off?  I'm a decent broad, and
won't have any of this.  Whatcha doing around here?  You one of those weird
explorers who rip off decent folks, taking their treasures out of the cave?
I hope you haven't found the magic wand yet . . . "

A cloud of white smoke and a wizard appear.  He is garbed in green and violet
robes, and says  "I really must apologize about this.  She has no business in
this game; she escaped from another game in the next town.  To compensate you
for this inconvenience, let me add ten points to your score.  Sorry again."
With that, he takes her hand, and they start to vanish.  As they fade out of
sight, you note that she has taken his hat, and is beating him severely about
the ears with it.

Your score just increase by 10 to 305.

What Now? EAST

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

What Now? EAST

<< Sandstone chamber >>
You are in a small chamber to the east of the Hall of Mists.  The walls are
composed of rough red sandstone.  There is a large, cubical chunk of rock in
the center of the room.
  There is a sword here with its blade plunged deep into the block of stone.

What Now? EXAMINE SWORD

The sword has its blade plunged deep into the block of stone.  You tug on it
trying to pull it out of the stone, but you are not strong enough.  The sword
is sharp and obviously has magical powers.  It is a "singing" sword and is
quietly humming excerpts from Prokofiev's "Romeo and Juliet" ballet to itself.

What Now? EAT MUSHROOM  <-- Gives you "super human" strength!

As you swallow the mushroom your mouth becomes numb, and everything seems to
swirl around you.  The effect quickly passes, and you find that your muscles
have bulged unbelievably.

What Now? GET SWORD  <-- You can get the sword only after eating the mushroom.

The singing sword slides easily out of the rock.

Your score just increase by 15 to 320.

What Now? EXAMINE SWORD

The sword is sharp and obviously has magical powers.  It is a "singing" sword
and is quietly humming a medley of the Beatles' greatest hits.

What Now? WEST

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

What Now? NORTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTH

There is a threatening little dwarf in the room with you!

The dwarf blocks your way and will not let you leave!

What Now? EXAMINE DWARF

The dwarf is about 3 feet tall, dressed in green with red hair and a bushy
handle-bar moustache.  He is quite excited and seems determined not to let you
get away.  His knife is almost and big as he is -- and it looks like it could
cause grave bodily harm.

What Now? KILL DWARF WITH AXE

A sharp, nasty knife is thrown at you!

The knife bounces harmlessly off your magic cloak.

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? NORTH

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.
  There are bars of silver here!

What Now? GET SILVER AND EXAMINE IT

You are now carrying the silver bars.

There are four silver bars -- each weighing about 5 pounds.

Your score just increase by 15 to 335.

What Now? NORTH

With a sudden gust of air, a large cave bat flutters into view, flies around
your head several times, squeaks with disgust, and flutters on out of sight.

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

A hollow voice says "Plugh".  <-- Hint -- given randomly in "Y2" room!

A hollow voice says "Plover". <-- Another hint -- given randomly in "Y2" room!

What Now? PLUGH

The sword begins singing "Witchi-Tai-To" in two-part harmony with itself.

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There is tasty food here.
  There is a small bottle of water here.
  There is a piece of crumpled paper here.

What Now? INVENTORY

You are carrying the following:
  iron keys
  shining lantern
  black rod
  dwarf's axe
  several diamonds
  silver bars
  precious jewelry
  singing sword
  visorless helmet
  oily vial
You are wearing the following:
  metallic cloak

What Now? DROP DIAMONDS

As you drop the treasure, a voice booms out: "Well done!  You have collected
9 treasure(s) so far out of a total of 37."

As the diamonds hits the floor, it disappears in a puff of blue smoke!

What Now? DROP SILVER

A strange malaise suddenly afflicts you.  You shiver with chill, and your
muscles seem to turn to putty; everything around you becomes gray and unreal.
The fit quickly passes, and you find that your body has degenerated back to
what it was like before you ate the mushroom.

<-- Your "super human" strength is only temporary.

As you drop the treasure, a voice booms out: "Well done!  You have collected
10 treasure(s) so far out of a total of 37."

As the bars hits the floor, it disappears in a puff of blue smoke!

What Now? DROP JEWELRY

As you drop the treasure, a voice booms out: "Well done!  You have collected
11 treasure(s) so far out of a total of 37."

As the jewelry hits the floor, it disappears in a puff of blue smoke!

What Now? DROP HELMET

As you drop the treasure, a voice booms out: "Well done!  You have collected
12 treasure(s) so far out of a total of 37."

As the helmet hits the floor, it disappears in a puff of blue smoke!

What Now? PLUGH

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? SOUTH

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? SOUTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? WEST

<< West side chamber >>
You are in the west side chamber of the hall of the mountain king.  A passage
continues to the west.
  There are many rare coins here!

What Now? GET COINS AND EXAMINE THEM

There are faint rustling noises from the darkness behind you.

You are now carrying the rare coins.

The coins are all quite old and made of gold and silver.

Your score just increase by 15 to 350.

What Now? EAST

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? SOUTHWEST

<< Secret E-W canyon >>
You are in a secret canyon which here runs east-west.  It crosses over a very
tight canyon 15 feet below.  If you go down you may not be able to get back
up.      

What Now? WEST

<< Secret canyon >>
You are in a secret canyon which exits to the north and east.
  There is a Persian rug spread out on the floor!
  A huge green fierce dragon bars the way!
  The dragon is sprawled out on a Persian rug!!

What Now? EXAMINE DRAGON

The dragon is HUGE!  It has a thick, rough, green skin.  (I wouldn't mess with
it -- if I were you and wanted to live long enough to finish this game!!)

What Now? KILL DRAGON

With what? Your bare hands?
Please answer Yes or No: YES  <-- This is the only way to kill dragon!

Congratulations!  You have just vanquished a dragon with your bare hands!
(Unbelievable, Isn't it?)

Your score just increase by 10 to 360.

What Now? LOOK

<< Secret canyon >>
You are in a secret canyon which exits to the north and east.
  The body of a huge green dead dragon is lying off to one side.
  There is a Persian rug spread out on the floor!
  There are several dragon's teeth scattered haphazardly about.

What Now? EXAMINE RUG AND TEETH

The rug looks quite old and very valuable.

The dragon's teeth are stained with yellow and brown!  Ugh!!  Yuck!!

What Now? GET RUG AND TEETH

You are now carrying the persian rug.

You are now carrying the dragon's teeth.

Your score just increase by 15 to 375.

What Now? EAST

<< Secret E-W canyon >>
You are in a secret canyon which here runs east-west.  It crosses over a very
tight canyon 15 feet below.  If you go down you may not be able to get back
up.      

What Now? EAST

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTH

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? NORTH

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? PLUGH

The magic sword chimes out the bell-like tones of "Khumbu Ice-fall" by ringing
its blade against the ground.

A hollow voice says "Plugh".

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There is tasty food here.
  There is a small bottle of water here.
  There is a piece of crumpled paper here.

What Now? DROP COINS

The sword begins singing "Witchi-Tai-To" in two-part harmony with itself.

As you drop the treasure, a voice booms out: "Well done!  You have collected
13 treasure(s) so far out of a total of 37."

As the coins hits the floor, it disappears in a puff of blue smoke!

What Now? DROP RUG

As you drop the treasure, a voice booms out: "Well done!  You have collected
14 treasure(s) so far out of a total of 37."

As the rug hits the floor, it disappears in a puff of blue smoke!


< ----------------  CAMPAIGN 4 -- In The Heart Of The Cave ------------------>

What Now? PLUGH

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? PLOVER

From the singing sword resound the massed voices of a two-hundred-singer
choir, filling the air with the stirring sound of the Hallelujah Chorus from
Handel's "Messiah".

A hollow voice says "Plugh".

A hollow voice says "Plover".

        >>Foof!<<

<< Plover room >>
You're in a small chamber lit by an eerie green light.  An extremely narrow
tunnel exits to the west.  A dark corridor leads northeast.
  There is an emerald here the size of a plover's egg!

What Now? NORTHEAST

There is a threatening little dwarf in the room with you!

The dwarf blocks your way and will not let you leave!
<< Plover room >>
You're in a small chamber lit by an eerie green light.  An extremely narrow
tunnel exits to the west.  A dark corridor leads northeast.
  There is an emerald here the size of a plover's egg!
  There is a threatening little dwarf in the room with you!

What Now? KILL DWARF WITH AXE

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? NORTHEAST

<< Dark-room >>
You're in the dark-room.  A corridor leading south is the only exit.
  There is a massive stone tablet imbedded in the wall.
  There is a platinum pyramid here, 8 inches on a side!

What Now? GET PYRAMID AND EXAMINE IT

You are now carrying the platinum pyramid.

The platinum pyramid is about 8 inches on a side and quite heavy.

Your score just increase by 15 to 390.

What Now? SOUTH

<< Plover room >>
You're in a small chamber lit by an eerie green light.  An extremely narrow
tunnel exits to the west.  A dark corridor leads northeast.
  There is an emerald here the size of a plover's egg!

What Now? PLOVER

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? PLUGH

A hollow voice says "Plover".

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There is tasty food here.
  There is a small bottle of water here.
  There is a piece of crumpled paper here.

What Now? DROP PYRAMID

As you drop the treasure, a voice booms out: "Well done!  You have collected
15 treasure(s) so far out of a total of 37."

As the pyramid hits the floor, it disappears in a puff of blue smoke!

What Now? EXAMINE FOOD AND BOTTLE

The food consists of two tuna sandwiches with lettuce and mayo.  It looks very
tasty.

The bottle is shaped like a wine bottle and looks like it would hold about a
quart of liquid.  It is full of water.

What Now? GET FOOD AND BOTTLE

You are now carrying the tasty food.

You are now carrying the water bottle.

What Now? PLUGH

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? SOUTH

From somewhere in the distance, there comes a musical skirl of light, elvish
laughter and the sounds of merriment.

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? DOWN

<< Dirty passage >>
You are in a dirty broken passage.  To the east is a crawl.  To the west is a
large passage.  Above you is another passage.

What Now? WEST

Suddenly, the ground quivers underfoot; a dull rumbling sound resounds from
the rock around you, and in the distance you can hear the crash of falling
rock.  The earth tremor subsides after a few seconds without causing any major
damage.  

<< Dusty rock room >>
You are in a large room full of dusty rocks.  There is a big hole in the
floor.  There are cracks everywhere, and a passage leading east.

What Now? DOWN

<< Complex junction >>
You are at a complex junction.  A low hands and knees passage from the north
joins a higher crawl from the east to make a walking passage going west.
There is also a large room above, but there are no hand or toe holds to climb
up.  The air is damp here.

What Now? EAST

The sword begins to sing "A Day in the Life" in a quiet, introspective voice.

<< Anteroom >>
You are in an anteroom leading to a large passage to the east.  Small passages
go west and up.  The remnants of recent digging are evident.  A sign in midair
here says:
       "Cave under construction beyond this point."
              "Proceed at your own risk."
              "Witt construction company"
  There is a recent issue of "Spelunker Today" magazine here.

What Now? GET MAGAZINE, EXAMINE IT AND READ IT

You aren't strong enough to carry your current load
plus the magazine.

The magazine is a slick high-gloss production with numerous cave pictures and
a variety of articles.

Unfortunately (for you), the magazine is written in Dwarvish (a language
somewhat like LISP or APL -- i.e., it is a "write-only" language and is
totally unreadable) -- so you get very little out of the articles.  However,
the pictures give you new inspiration to explore the cave further.

What Now? DROP SWORD

You drop the singing sword.

What Now? GET MAGAZINE

You are now carrying the spelunker magazine.

What Now? EAST

<< Witt's end >>
You are at Witt's end.  Passages lead off in ALL directions.

What Now? DROP MAGAZINE

There is a threatening little dwarf in the room with you!

The magazine disappears in a puff of green smoke as it hits the ground.  A
loud voice echoes through the cave, "Well done!"

Your score just increase by 1 to 391.

<-- This "puzzle" is probably the hardest in the original Adventure game.
    Many, many people who played the original game got 349 points and were
    never able to figure out that they need to drop the magazine at Witt's End
    to get that last 1 point for a perfect score of 350.  Why do you think
    Woods and Crowther named the place "Witt's End?"

What Now? KILL DWARF WITH AXE

A sharp, nasty knife is thrown at you!

The knife bounces harmlessly off your magic cloak.

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? EAST <-- Keep going EAST until you get out!

You have crawled around in some little holes and found your way blocked by a
recent cave-in.  You are now back in the main passage.

What Now? EAST <-- Keep going EAST until you get out!

You have crawled around in some little holes and found your way blocked by a
recent cave-in.  You are now back in the main passage.

What Now? EAST <-- Keep going EAST until you get out!

You have crawled around in some little holes and found your way blocked by a
recent cave-in.  You are now back in the main passage.

Finally, you discover a small tunnel leading east.  You just manage to fit
through and find yourself ...

<< Anteroom >>
You are in an anteroom leading to a large passage to the east.  Small passages
go west and up.  The remnants of recent digging are evident.  A sign in midair
here says:
       "Cave under construction beyond this point."
              "Proceed at your own risk."
              "Witt construction company"
  There is a magical singing sword here.  It is singing softly to itself.

What Now? GET SWORD

You are now carrying the singing sword.

What Now? NORTH

<< Complex junction >>
You are at a complex junction.  A low hands and knees passage from the north
joins a higher crawl from the east to make a walking passage going west.
There is also a large room above, but there are no hand or toe holds to climb
up.  The air is damp here.

What Now? WEST

<< Bedquilt room >>
You are in bedquilt, a long east/west passage with holes everywhere.  To
explore at random select north, south, up or down.

What Now? WEST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.

<-- The "Swiss cheese" room will be used as somewhat of a "repository" where
    the player can leave things until he/she needs them later in the game.

What Now? DROP ALL

You drop the iron keys.
You drop the shining lantern.
You drop the black rod.
You drop the tasty food.
You drop the water bottle.
You drop the dwarf's axe.
You drop the dragon's teeth.
You drop the singing sword.
You drop the oily vial.

What Now? GET AXE, LAMP AND BOTTLE

You are now carrying the dwarf's axe.

You are now carrying the shining lantern.

You are now carrying the water bottle.

What Now? WEST

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? WEST

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.

What Now? DOWN

<< West pit >>
You are at the bottom of the western pit in the twopit room.  There is a large
hole in the wall about 25 feet above you.
  There is a tiny little plant in the pit, murmuring "Water, Water, ..."

What Now? WATER PLANT

From somewhere nearby, there suddenly comes a sound of something mechanical in
motion.  As you turn toward it, an incredible figure rolls into the light of
your lamp.  It stands about five feet high on a wheeled metal pedestal, and
has a globular light- filled head, accordion-pleated metal arms, and a
cylindrical body the size of an oil drum with a plastic panel on the front.
It rolls past without taking any notice of you, all the while waving its arms,
flashing a light behind its front panel and bellowing "WARNING! WARNING!
DANGER!" at the top of its not inconsiderable voice.  It rolls on out of
sight, and moments later there is an immense flash of light and a tremendous
blast of sparks and smoke.  When the air clears, you find that no trace
remains of the strange apparition.

The plant spurts into furious growth for a few seconds.

Your score just increase by 5 to 396.

What Now? UP

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.
  The top of a 12-foot-tall beanstalk is poking up out of the west pit.

What Now? WEST

<< Slab room >>
You are in a large low circular chamber whose floor is an immense slab fallen
from the ceiling (slab room).  East and west there once were large passages,
but they are now filled with boulders.  Low small passages go north and south,
and the south one quickly bends west around the boulders.

What Now? UP

There is a threatening little dwarf in the room with you!

A sharp, nasty knife is thrown at you!

The knife bounces harmlessly off your magic cloak.

The dwarf blocks your way and will not let you leave!
<< Slab room >>
You are in a large low circular chamber whose floor is an immense slab fallen
from the ceiling (slab room).  East and west there once were large passages,
but they are now filled with boulders.  Low small passages go north and south,
and the south one quickly bends west around the boulders.
  There is a threatening little dwarf in the room with you!

What Now? KILL DWARF WITH AXE

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? UP

<< North-south canyon >>
You are in a secret north-south canyon above a large room.

What Now? NORTH

<< Mirror canyon >>
You are in a north/south canyon about 25 feet across.  The floor is covered by
white mist seeping in from the north.  The walls extend upward for well over
100 feet.  Suspended from some unseen point far above you, an enormous two-
sided mirror is hanging parallel to and midway between the canyon walls.  (The
mirror is obviously provided for the use of the dwarves, who as you know, are
extremely vain.)  A small window can be seen in either wall, some fifty feet
up.      
  You see a shiny mirror here.

What Now? EXAMINE MIRROR

The mirror is quite large and has a very shiny surface.  As your move, the
reflection from your lamp bounces off the mirror and causes strange light
shapes to dance around the walls of the room.

What Now? NORTH

<< Southern edge of reservoir >>
You are on the southern edge of a large underground reservoir.  A thick cloud
of white mist fills the room, rising from the surface of the water and
drifting rapidly upwards.  The lake is fed by a stream, which tumbles out of a
hole in the wall about 10 feet overhead and splashes noisily into the water
near the reservoir's northern wall.  A dimly-seen passage exits through the
northern wall, but you can't get across the water to get to it.  Another
passage leads south from here.

What Now? GET WATER

Your bottle is now full of water.

What Now? SOUTH

<< Mirror canyon >>
You are in a north/south canyon about 25 feet across.  The floor is covered by
white mist seeping in from the north.  The walls extend upward for well over
100 feet.  Suspended from some unseen point far above you, an enormous two-
sided mirror is hanging parallel to and midway between the canyon walls.  (The
mirror is obviously provided for the use of the dwarves, who as you know, are
extremely vain.)  A small window can be seen in either wall, some fifty feet
up.      
  You see a shiny mirror here.

What Now? SOUTH

<< North-south canyon >>
You are in a secret north-south canyon above a large room.

What Now? DOWN

<< Slab room >>
You are in a large low circular chamber whose floor is an immense slab fallen
from the ceiling (slab room).  East and west there once were large passages,
but they are now filled with boulders.  Low small passages go north and south,
and the south one quickly bends west around the boulders.

What Now? SOUTH

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.
  The top of a 12-foot-tall beanstalk is poking up out of the west pit.

What Now? DOWN

<< West pit >>
You are at the bottom of the western pit in the twopit room.  There is a large
hole in the wall about 25 feet above you.
  A 12-foot-tall beanstalk stretches out of the pit, bellowing "Water!!!"

What Now? WATER PLANT

The plant grows explosively, almost filling the bottom of the pit.

Your score just increase by 4 to 400.

What Now? UP

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.

What Now? EAST

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? DOWN

<< East pit >>
You are that the bottom of the eastern pit in the twopit room.  There is a
small pool of oil in one corner of the pit.

What Now? GET OIL

Your bottle is now full of oil.

What Now? UP

From somewhere nearby come the sounds of sliding, stumbling feet. As you turn
toward them, the beam of your lamp falls upon a tall, shambling figure
approaching you out of the darkness.  Standing no more than five feet tall, it
cannot possibly weigh more than fifty pounds including the shroud and bandages
in which it is wrapped; a musty reek like the scent of old, dead earth seeps
from it and fills the air.  As you cower back in disgust and horror, the
figure halts, examines you through eyes resembling wet pebbles, and whispers
"Peace, man!" in a voice like wind rustling through dead trees.  It then turns
and shambles away into the darkness.

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? EAST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  A three foot black rod with a rusty star on an end lies nearby.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.
  There is a magical singing sword here.  It is singing softly to itself.
  On the ground lies a small glass vial filled with an oily liquid.

What Now? GET SWORD AND VIAL <-- Now, we will need these.

You are now carrying the singing sword.

You are now carrying the oily vial.

What Now? WEST

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? WEST

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.

What Now? DOWN

<< West pit >>
You are at the bottom of the western pit in the twopit room.  There is a large
hole in the wall about 25 feet above you.
  There is a gigantic beanstalk stretching all the way up to the hole.

What Now? CLIMB PLANT

You climb up the beanstalk and scurry through the hole in the ceiling of the
cavern.  
<< Long narrow corridor >>
You are in a long, narrow corridor stretching out of sight to the west.  At
the eastern end is a hole through which you can see a profusion of leaves,
  There is a huge beanstalk growing out of the west pit up to the hole.

What Now? WEST

<< Giant room >>
You are in the giant room.  The ceiling is too high up for your lamp to show
it.  Cavernous passages lead east, north, and south.  On the west wall is
scrawled the inscription:
               Fee
               Fie
               Foe
               Foo  {sic}
  There is a large nest here, full of golden eggs!

What Now? NORTH

<< End of immense passage >>
You are at one end of an immense north/south passage.
  The way north is barred by a massive, rusty, iron door.

What Now? EXAMINE DOOR

The door is massive and made of iron.  It is quite rusty and doesn't appear to
have been used in a long time.  It is closed and will not budge.

What Now? OIL HINGES

The oil has freed up the hinges so that the door will now move, although it
requires some effort.

Your score just increase by 10 to 410.

What Now? DROP BOTTLE  <-- Wont need again.

You drop the empty bottle.

What Now? SOUTH

<< Giant room >>
You are in the giant room.  The ceiling is too high up for your lamp to show
it.  Cavernous passages lead east, north, and south.  On the west wall is
scrawled the inscription:
               Fee
               Fie
               Foe
               Foo  {sic}
  There is a large nest here, full of golden eggs!

What Now? EAST

<< Low tunnel >>
You are in a low tunnel with an irregular ceiling.  To the north, the tunnel
is partially blocked by a recent cave-in, but you can probably get past the
blockage without too much trouble.

What Now? NORTH

<< Room with glassy walls >>
You're standing in a very large room (which however is smaller than the Giant
room) which has smooth, glassy-looking walls.  A passage enters from the south
and exits to the north.
  There is a large, nasty-looking ogre blocking your path!

What Now? EXAMINE OGRE

The ogre is blocking your path!  It is very ugly.

What Now? THROW SWORD AT OGRE

The sword halts in mid-air, twirls like a dervish, and chants several bars of
"Dies Ire" in a rough tenor voice.  It then begins to spin like a rip-saw
blade and flies directly at the ogre, who attempts to catch it without
success; it strikes him full on the chest.  There is a brilliant flash of
light, a deafening roar and a cloud of oily gray smoke; when the smoke clears
(and your eyes begin working properly again) you see that the ogre has
vanished.  The sword is lying on the ground, sparking and flaming.  Before
your eyes it softens and melts, writhes as if in pain, and shrinks rapidly
until all that is left is a small silvery ring which cools rapidly.

Your score just increase by 15 to 425.

What Now? GET RING AND EXAMINE IT

You are now carrying the mithril ring.

The ring has been crafted of the finest mithril by incredible craftsmen.  What
a piece of art!

Your score just increase by 15 to 440.

What Now? NORTH

<< Sorcerer's Lair >>
This is the Sorcerer's Lair.  The walls are covered with exotic runes written
in strange, indecipherable scripts; the only readable phrase reads "noside
samoht".  Strange shadows flit about on the walls, but there is nothing
visible to cast them.  Iridescent blue light drips from a stalactite far
above, falls toward the floor, and evaporates before touching the ground.  A
deep, resonant chanting sound vibrates from deep in the ground beneath your
feet, and a whispering sound composed of the echoes of long-forgotten spells
and cantrips seeps from the walls and fills the air.  Passages exit to the
east and west.

<-- "noside samoht" is a secret phrase that can be used to re-new your lamp's
    batteries when they run down (but not before)!  "noside samoht" is an
    example of Ralph Witt's delight in spelling things backwards and in
    generally doing things in reverse order.

What Now? EAST

<< Brink of bottomless pit >>
You are standing on the brink of what appears to be a bottomless pit plunging
down into the bowels of the earth.  Ledges run around the pit to the east and
west, and a passage leads back to the north.

What Now? EAST

<< East side of pit >>
You are standing on the eastern side of a bottomless pit.  A narrow ledge runs
north toward a dimly-visible passage; the ledge once continued south of this
point but has been shattered by falling rock.  A narrow crack in the rock
leads northeast.

What Now? NORTHEAST

<< Narrow twisting crack >>
You are following a narrow crack in the rock which enters from the southwest,
turns and twists somewhat, and exits to the southeast.

What Now? SOUTHEAST

There are faint rustling noises from the darkness behind you.

<< North end of passage >>
You are standing at the northern end of a rather tight passage.  A narrow
crack in the rock leads west.
  The passage to the south is swathed with sheets of evil-looking green slime.

What Now? EXAMINE SLIME

The evil-looking green slime twitches and flows as if aware of your presence.

What Now? THROW VIAL

There is a threatening little dwarf in the room with you!

The vial explodes into splinters and disintegrates, releasing an oily liquid
which rapidly sublimes into a large mushroom-shaped cloud of thick yellow
vapor smelling like Cheddar cheese and bananas.

The slime filling the passage to the south blackens and shrivels away into
nothingness.

The dwarf catches a lungful of the cloud, gags audibly and stumbles out of the
room retching, sneezing, and cursing up a storm.

<-- Throwing the vial kills the slime.  In this case, we were also lucky
    enough to get a dwarf as well who just happened to be in the room at the
    same time.

What Now? SOUTH

<< South end of passage >>
You are at the southern end of a tight passage.  A hands-and-knees crawl
continues to the south.

What Now? SOUTH

From somewhere in the distance comes a heart-wrenching scream of mortal
terror!  "NO!  DON'T!  NO!  NO!  HELP!!!!" cries the voice, and then lets out
a wail of agony that is cut off abruptly.  Subdued crunching and slurping
sounds can be heard for a minute or so, and then silence falls.

<< Very small chamber >>
You are in a very small chamber.  A narrow crawl leads north.
  There is a small casket full of rare black opals here!

What Now? EXAMINE CASKET

The casket is only about a foot long by about 3 inches wide by 2 inches tall.
When you open the lid you can see it is full of rare black opals.

What Now? GET OPALS

You are now carrying the casket opals.

Your score just increase by 15 to 455.

What Now? NORTH

<< South end of passage >>
You are at the southern end of a tight passage.  A hands-and-knees crawl
continues to the south.

What Now? NORTH

<< North end of passage >>
You are standing at the northern end of a rather tight passage.  A narrow
crack in the rock leads west.

What Now? WEST

<< Narrow twisting crack >>
You are following a narrow crack in the rock which enters from the southwest,
turns and twists somewhat, and exits to the southeast.

What Now? SOUTHWEST

<< East side of pit >>
You are standing on the eastern side of a bottomless pit.  A narrow ledge runs
north toward a dimly-visible passage; the ledge once continued south of this
point but has been shattered by falling rock.  A narrow crack in the rock
leads northeast.

What Now? NORTH

<< Brink of bottomless pit >>
You are standing on the brink of what appears to be a bottomless pit plunging
down into the bowels of the earth.  Ledges run around the pit to the east and
west, and a passage leads back to the north.

What Now? WEST

<< Southern edge of pit >>
You are standing at the south end of a ledge running around the west side of a
bottomless pit.  The ledge once continued around to the east side of the pit,
but was apparently obliterated by a rock-slide years ago.  A cold wind blows
out of a tunnel leading to the southeast.

What Now? SOUTHEAST

<< Ice room >>
You are in the Ice room.  The walls and ceiling here are composed of clear
blue glacial ice; the floor is fortunately made of rock and is easy to walk
upon.  There is a passage leading to the northwest, and a slide of polished
ice leading downwards to the east - if you were to slide down it you probably
couldn't get back up.

What Now? DOWN

Wheeeeeeeeeeeeeeee.......   >oof<

That was fun!

<< Bottom of icy slide >>
You're at the entrance to an extensive and intricate network of tunnels carved
out of solid ice.  A slippery slope leads upwards and north, but you cannot
possibly climb up it.

What Now? SOUTH

<< In "maze" of ice tunnels >>
You are in an intricate network of ice tunnels.  It is another @#$%&*% maze!!

A small sign is attached to one wall of ice which reads:

   NORTH -- Ice slide
   EAST -- Ice slide
   NORTHWEST -- Icy chamber
   THURB -- ?

It is signed "Jerry Cornelius -- one who has passed this way before"
  A finely-carved crystalline sculpture is here.  You should examine it!

<-- David Platt's version (i.e., Adventure 550) had an extensive maze totally
    38 rooms here.  I cut it down to only two rooms because (1) I wanted to
    put the rooms to better use elsewhere in the game, and (2) I am sick and
    tired of mazes.

What Now? HELP

To get out of here, you'll first have to get your bearings so that you know
where you are.  I suggest that you draw a careful, accurate map of the tunnel
system; for clarity's sake, keep your lines as straight as is feasible and
draw in all of the dead ends and such. Once you've got a complete and accurate
map, examine it carefully; if your thoughts refuse to clarify, you might try
using the old Yoga trick of standing on your head, and see if that helps.

What Now? GET SCULPTURE

You are now carrying the ice sculpture.

Your score just increase by 15 to 470.

What Now? EXAMINE IT

With a sudden gust of air, a large cave bat flutters into view, flies around
your head several times, squeaks with disgust, and flutters on out of sight.

The crystal sculpture is a small delicate carving of a dwarf.
It looks as if it had been carved out of ice.

What Now? AGAIN

The crystal sculpture is a small delicate carving of an emu.
It looks as if it had been carved out of ice.

What Now? AGAIN

The crystal sculpture is a small delicate carving of a pig.
It looks as if it had been carved out of ice.

What Now? THURB

        >>Foof!<<

<< Ice room >>
You are in the Ice room.  The walls and ceiling here are composed of clear
blue glacial ice; the floor is fortunately made of rock and is easy to walk
upon.  There is a passage leading to the northwest, and a slide of polished
ice leading downwards to the east - if you were to slide down it you probably
couldn't get back up.

What Now? NORTHWEST

<< Southern edge of pit >>
You are standing at the south end of a ledge running around the west side of a
bottomless pit.  The ledge once continued around to the east side of the pit,
but was apparently obliterated by a rock-slide years ago.  A cold wind blows
out of a tunnel leading to the southeast.

What Now? NORTH

There are faint rustling noises from the darkness behind you.

<< Brink of bottomless pit >>
You are standing on the brink of what appears to be a bottomless pit plunging
down into the bowels of the earth.  Ledges run around the pit to the east and
west, and a passage leads back to the north.

What Now? WEST

There is a threatening little dwarf in the room with you!

A little dwarf with a big knife blocks your way.

What Now? KILL DWARF WITH AXE

A sharp, nasty knife is thrown at you!

The knife just misses you by inches!

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? WEST

<< Southern edge of pit >>
You are standing at the south end of a ledge running around the west side of a
bottomless pit.  The ledge once continued around to the east side of the pit,
but was apparently obliterated by a rock-slide years ago.  A cold wind blows
out of a tunnel leading to the southeast.

What Now? NORTH

<< Brink of bottomless pit >>
You are standing on the brink of what appears to be a bottomless pit plunging
down into the bowels of the earth.  Ledges run around the pit to the east and
west, and a passage leads back to the north.

What Now? NORTH

<< Sorcerer's Lair >>
This is the Sorcerer's Lair.  The walls are covered with exotic runes written
in strange, indecipherable scripts; the only readable phrase reads "noside
samoht".  Strange shadows flit about on the walls, but there is nothing
visible to cast them.  Iridescent blue light drips from a stalactite far
above, falls toward the floor, and evaporates before touching the ground.  A
deep, resonant chanting sound vibrates from deep in the ground beneath your
feet, and a whispering sound composed of the echoes of long-forgotten spells
and cantrips seeps from the walls and fills the air.  Passages exit to the
east and west.

What Now? WEST

<< Room with glassy walls >>
You're standing in a very large room (which however is smaller than the Giant
room) which has smooth, glassy-looking walls.  A passage enters from the south
and exits to the north.

What Now? SOUTH

There is a threatening little dwarf in the room with you!

A little dwarf with a big knife blocks your way.

What Now? KILL DWARF WITH AXE

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? SOUTH

From the darkness nearby comes the sound of shuffling feet.  As you turn
toward the sound, a nine-foot cyclops ambles into the light of your lamp.
The cyclops is dressed in a three-piece suit of worsted wool, and is wearing a
black silk top-hat and cowboy boots and is carrying an ebony walking-stick.
It catches sight of you and stops, seeming frozen in its tracks, with its
bloodshot eye bulging in amazement and its fang-filled jaw drooping with
shock.  After staring at you in incredulous disbelief for a few moments, it
reaches into the pocket of its vest and pulls out a small plastic bag filled
with a leafy green substance, and examines it carefully.  "It must be worth
eighty pazools an ounce after all" mumbles the cyclops, who casts one final
look at you, shudders, and staggers away out of sight.

<< Low tunnel >>
You are in a low tunnel with an irregular ceiling.  To the north, the tunnel
is partially blocked by a recent cave-in, but you can probably get past the
blockage without too much trouble.

What Now? WEST

<< Giant room >>
You are in the giant room.  The ceiling is too high up for your lamp to show
it.  Cavernous passages lead east, north, and south.  On the west wall is
scrawled the inscription:
               Fee
               Fie
               Foe
               Foo  {sic}
  There is a large nest here, full of golden eggs!

What Now? NORTH

<< End of immense passage >>
You are at one end of an immense north/south passage.
  The way north leads through an open massive, rusty, iron door.
  There is a small empty bottle here.

What Now? NORTH

<< Cavern with waterfall >>
You are in a magnificent cavern with a rushing stream, which cascades over a
sparkling waterfall into a roaring whirlpool which disappears through a hole
in the floor.  Passages exit to the south and west.
  There is a jewel-encrusted trident here!

What Now? GET TRIDENT AND EXAMINE IT

You are now carrying the jeweled trident.

The trident is jewel-encrusted and made of a gold and iron alloy.  It is about
six feet long and is quite strong.

Your score just increase by 15 to 485.

What Now? SOUTH

<< End of immense passage >>
You are at one end of an immense north/south passage.
  The way north leads through an open massive, rusty, iron door.
  There is a small empty bottle here.

What Now? SOUTH

<< Giant room >>
You are in the giant room.  The ceiling is too high up for your lamp to show
it.  Cavernous passages lead east, north, and south.  On the west wall is
scrawled the inscription:
               Fee
               Fie
               Foe
               Foo  {sic}
  There is a large nest here, full of golden eggs!

What Now? GET EGGS AND EXAMINE THEM

You are now carrying the golden eggs.

The eggs are made of solid gold and rest in a large nest of reeds.

Your score just increase by 15 to 500.

What Now? SOUTH

<< Long narrow corridor >>
You are in a long, narrow corridor stretching out of sight to the west.  At
the eastern end is a hole through which you can see a profusion of leaves,
  There is a huge beanstalk growing out of the west pit up to the hole.

What Now? DOWN

Carefully, you climb down the beanstalk to the bottom of the pit -- far below.

<< West pit >>
You are at the bottom of the western pit in the twopit room.  There is a large
hole in the wall about 25 feet above you.
  There is a gigantic beanstalk stretching all the way up to the hole.

What Now? UP

Suddenly, the ground quivers underfoot; a dull rumbling sound resounds from
the rock around you, and in the distance you can hear the crash of falling
rock.  The earth tremor subsides after a few seconds without causing any major
damage.  

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.

What Now? EAST

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? EAST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  A three foot black rod with a rusty star on an end lies nearby.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? EAST

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  A small velvet pillow lies on the floor.
  You see a carpet of moss here.

What Now? NORTH

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? TURBO

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There is a piece of crumpled paper here.

What Now? DROP OPALS

As you drop the treasure, a voice booms out: "Well done!  You have collected
16 treasure(s) so far out of a total of 37."

As the opals hits the floor, it disappears in a puff of blue smoke!

What Now? DROP SCULPTURE

As you drop the treasure, a voice booms out: "Well done!  You have collected
17 treasure(s) so far out of a total of 37."

As the sculpture hits the floor, it disappears in a puff of blue smoke!

What Now? TURBO

        >>Foof!<<

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? SOUTH

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  A small velvet pillow lies on the floor.
  You see a carpet of moss here.

What Now? WEST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  A three foot black rod with a rusty star on an end lies nearby.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? NORTHWEST

<< Oriental room >>
This is the oriental room.  A gently sloping passage leads upward to the
north, another passage leads southeast, and a hands and knees crawl leads
west.    
  Ancient oriental cave drawings cover the walls.
  There is a delicate, precious, ming vase here!

What Now? NORTH

<< Misty cavern >>
You are following a wide path around the outer edge of a large cavern.  Far
below, through a heavy white mist, strange splashing noises can be heard.  The
mist rises up through a fissure in the ceiling.  The path exits to the south
and west.

What Now? WEST

<< Alcove >>
You are in an alcove.  A small northwest path seems to widen after a short
distance.  An extremely tight tunnel leads east.  It looks like a very tight
squeeze.  An eerie light can be seen at the other end.

What Now? DROP ALL

You drop the shining lantern.
You drop the dwarf's axe.
You drop the golden eggs.
You drop the jeweled trident.
You drop the mithril ring.

Your score just decrease by 45 to 455.

What Now? DROP CLOAK  <-- Let's hope a dwarf doesn't suddenly attack!!

You drop the metallic cloak.

What Now? EAST

You just barely manage to squeeze through the tunnel into the next room.

<< Plover room >>
You're in a small chamber lit by an eerie green light.  An extremely narrow
tunnel exits to the west.  A dark corridor leads northeast.
  There is an emerald here the size of a plover's egg!

What Now? GET EMERALD AND EXAMINE IT

You are now carrying the egg-sized emerald.

The emerald is bright green and about the size of a plover's egg.

Your score just increase by 15 to 470.

What Now? WEST

You just barely manage to squeeze through the tunnel into the next room.

<< Alcove >>
You are in an alcove.  A small northwest path seems to widen after a short
distance.  An extremely tight tunnel leads east.  It looks like a very tight
squeeze.  An eerie light can be seen at the other end.
  There is a lamp shining nearby.
  There is a little axe here.
  There is a large nest here, full of golden eggs!
  There is a jewel-encrusted trident here!
  There is cloak made from a heavy metallic fabric here.
  There is a shiny ring (crafted of the finest mithril) lying here!

What Now? WEAR CLOAK  <-- Safe again!  Whew!

You are now wearing the metallic cloak.

What Now? GET ALL

You are now carrying the shining lantern.
You are now carrying the dwarf's axe.
You are now carrying the golden eggs.
You are now carrying the jeweled trident.
You are now carrying the mithril ring.

Your score just increase by 45 to 515.

What Now? NORTHWEST

<< Misty cavern >>
You are following a wide path around the outer edge of a large cavern.  Far
below, through a heavy white mist, strange splashing noises can be heard.  The
mist rises up through a fissure in the ceiling.  The path exits to the south
and west.

What Now? SOUTH

<< Oriental room >>
This is the oriental room.  A gently sloping passage leads upward to the
north, another passage leads southeast, and a hands and knees crawl leads
west.    
  Ancient oriental cave drawings cover the walls.
  There is a delicate, precious, ming vase here!

What Now? GET VASE AND EXAMINE IT

You are now carrying the ming vase.

The vase is very delicate and very old.  It looks quite fragile.

Your score just increase by 15 to 530.

What Now? SOUTHEAST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  A three foot black rod with a rusty star on an end lies nearby.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? WEST

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? EAST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  A three foot black rod with a rusty star on an end lies nearby.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? EAST

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  A small velvet pillow lies on the floor.
  You see a carpet of moss here.

What Now? GET PILLOW AND EXAMINE IT

You are now carrying the velvet pillow.

The pillow is quite soft.  It is made of red velvet.

What Now? NORTH

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? TURBO

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There is a piece of crumpled paper here.

What Now? DROP PILLOW  <-- Must drop pillow before vase or vase will break.

You drop the velvet pillow.

What Now? DROP VASE

As you drop the treasure, a voice booms out: "Well done!  You have collected
18 treasure(s) so far out of a total of 37."

As the vase hits the floor, it disappears in a puff of blue smoke!

What Now? DROP EMERALD

As you drop the treasure, a voice booms out: "Well done!  You have collected
19 treasure(s) so far out of a total of 37."

As the emerald hits the floor, it disappears in a puff of blue smoke!

What Now? TURBO

        >>Foof!<<

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? SOUTH

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  You see a carpet of moss here.

What Now? WEST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  A three foot black rod with a rusty star on an end lies nearby.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? GET ROD

You are now carrying the black rod.

What Now? NORTHWEST

<< Oriental room >>
This is the oriental room.  A gently sloping passage leads upward to the
north, another passage leads southeast, and a hands and knees crawl leads
west.    
  Ancient oriental cave drawings cover the walls.

What Now? SOUTHEAST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? NORTHEAST

<< Bedquilt room >>
You are in bedquilt, a long east/west passage with holes everywhere.  To
explore at random select north, south, up or down.

What Now? EAST

<< Complex junction >>
You are at a complex junction.  A low hands and knees passage from the north
joins a higher crawl from the east to make a walking passage going west.
There is also a large room above, but there are no hand or toe holds to climb
up.  The air is damp here.

What Now? NORTH

<< Shell room >>
You're in a large room carved out of sedimentary rock.  The floor and walls
are littered with bits of shells imbedded in the stone.  A shallow passage
proceeds downward, and a somewhat steeper one leads up.  A low hands and knees
passage enters from the south.
  There is an enormous clam here with its shell tightly closed.

What Now? EXAMINE CLAM

The clam is about 4 feet across and is quite heavy.

What Now? OPEN IT

A glistening pearl falls out of the clam and rolls away.  Goodness, this must
really be an oyster.  (I never was very good at identifying bivalves.)
Whatever it is, it has now snapped shut again.

Your score just increase by 15 to 545.

What Now? EXAMINE CLAM

Interesting.  There seems to be something written on the underside of the
oyster.

What Now? READ IT

It says, "There is something strange about this place, such that one of the
words I've always known now has a new effect."

<-- I have never been able to figure out what 'word' this clue was referring
    to.  I have included the clue so that it might help others -- even though
    it never helped me.

What Now? DOWN

<< Long sloping corridor >>
You are in a long sloping corridor with ragged sharp walls.

What Now? DOWN

<< Cul-de-sac >>
You are in a cul-de-sac about eight feet across.
  Off to one side lies a glistening pearl!

What Now? GET PEARL AND EXAMINE IT

You are now carrying the glistening pearl.

The pearl is perfectly round and about six inches in diameter.  It is quite
shiny and you can see your reflection in it.

Your score just increase by 15 to 560.

What Now? UP

<< Long sloping corridor >>
You are in a long sloping corridor with ragged sharp walls.

What Now? UP

<< Shell room >>
You're in a large room carved out of sedimentary rock.  The floor and walls
are littered with bits of shells imbedded in the stone.  A shallow passage
proceeds downward, and a somewhat steeper one leads up.  A low hands and knees
passage enters from the south.
  There is an enormous oyster here with its shell tightly closed.

What Now? SOUTH

<< Complex junction >>
You are at a complex junction.  A low hands and knees passage from the north
joins a higher crawl from the east to make a walking passage going west.
There is also a large room above, but there are no hand or toe holds to climb
up.  The air is damp here.

What Now? WEST

<< Bedquilt room >>
You are in bedquilt, a long east/west passage with holes everywhere.  To
explore at random select north, south, up or down.

What Now? WEST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? EAST

Seven men, wearing gray business suits and carrying briefcases, suddenly
appear out of the shadows and surround you.  They identify themselves as
representatives of the Internal Revenue Service!  With absolutely no show of
emotion, they report: "We understand that you have been accumulating some
un-declared income.  We wish to warn you that we are watching you closely as
you play this game, and all of this income must be properly and totally
accounted for on your next tax return.  If it isn't, you will go to jail or
worse!"

They then disappear in a >POOF< of red, white and blue smoke.

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  You see a carpet of moss here.

What Now? NORTH

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? TURBO

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  A small velvet pillow lies on the floor.
  There is a piece of crumpled paper here.

What Now? DROP PEARL

As you drop the treasure, a voice booms out: "Well done!  You have collected
20 treasure(s) so far out of a total of 37."

As the pearl hits the floor, it disappears in a puff of blue smoke!

What Now? DROP TRIDENT

As you drop the treasure, a voice booms out: "Well done!  You have collected
21 treasure(s) so far out of a total of 37."

As the trident hits the floor, it disappears in a puff of blue smoke!

What Now? LOOK

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  A small velvet pillow lies on the floor.
  There is a piece of crumpled paper here.


< ----------------  CAMPAIGN 5 -- Beyond The Oyster ------------------------->

What Now? GET COMPASS AND EXAMINE IT

You are now carrying the boy-scout compass.

It is a standard-issue Boy-Scout compass.  It is made of very sturdy plastic.

The needle of the compass is currently pointing South.

What Now? EXAMINE TENNIS SHOES

The tennis shoes are very old and quite ugly and dirty.  You would not be
caught dead in them (HINT HINT).  You can just make out the brand-name
'Non-Skid'.

What Now? WEAR THEM  <-- Tennis shoes will later keep player from slipping
                         down the "fire-pole" and dying.

You are now wearing the tennis shoes.

What Now? NORTH

<< Tool room >>
You are in a small, low-ceilinged room with the words

   "Witt Company Tool Room - Melenkurion division"

carved into one of the walls.  A doorway exits to the south from here.
  There is a long-handled shovel here.

<-- Remember the word 'Melenkurion.'  It will come in handy later.

What Now? GET SHOVEL

Your lamp is getting dim.. You'd best start wrapping this up, unless you can
find some fresh batteries.  I seem to recall there's a vending machine in the
maze.  Bring some coins with you.

You are now carrying the long-handled shovel.

What Now? SOUTH

The batteries in your lamp are growing weaker.  They will only last for 25
more turns!

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a giant rabbit's foot here.
  There is a diary here.  It is quite old.
  There is a small plastic card here!
  A small velvet pillow lies on the floor.
  There is a piece of crumpled paper here.

What Now? GET FOOT

The batteries in your lamp are growing weaker.  They will only last for 24
more turns!

You are now carrying the rabbit's foot.

What Now? TURBO

The batteries in your lamp are growing weaker.  They will only last for 23
more turns!

        >>Foof!<<

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? SOUTH

The batteries in your lamp are growing weaker.  They will only last for 22
more turns!

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  You see a carpet of moss here.

What Now? WEST

The batteries in your lamp are growing weaker.  They will only last for 21
more turns!

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  There is tasty food here.
  There are several dragon's teeth scattered haphazardly about.

What Now? INVENTORY

The batteries in your lamp are growing weaker.  They will only last for 20
more turns!

You are carrying the following:
  long-handled shovel
  rabbit's foot
  boy-scout compass
  shining lantern
  black rod
  dwarf's axe
  golden eggs
  mithril ring
You are wearing the following:
  tennis shoes
  metallic cloak

What Now? DROP EGGS

The batteries in your lamp are growing weaker.  They will only last for 19
more turns!

You drop the golden eggs.

The batteries in your lamp are growing weaker.  They will only last for 18
more turns!

Your score just decrease by 15 to 545.

What Now? NORTHEAST

The batteries in your lamp are growing weaker.  They will only last for 17
more turns!

<< Bedquilt room >>
You are in bedquilt, a long east/west passage with holes everywhere.  To
explore at random select north, south, up or down.

What Now? EAST

The batteries in your lamp are growing weaker.  They will only last for 16
more turns!

<< Complex junction >>
You are at a complex junction.  A low hands and knees passage from the north
joins a higher crawl from the east to make a walking passage going west.
There is also a large room above, but there are no hand or toe holds to climb
up.  The air is damp here.

What Now? NORTH

The batteries in your lamp are growing weaker.  They will only last for 15
more turns!

<< Shell room >>
You're in a large room carved out of sedimentary rock.  The floor and walls
are littered with bits of shells imbedded in the stone.  A shallow passage
proceeds downward, and a somewhat steeper one leads up.  A low hands and knees
passage enters from the south.
  There is an enormous oyster here with its shell tightly closed.

What Now? NOSIDE SAMOHT <-- Will "re-charge" batteries.  However, you must use
                            this magic phrase only when the batteries are weak
                            and about to run out!

The batteries in your lamp are growing weaker.  They will only last for 14
more turns!

The air fills with tension, and there is a subdued crackling sound.  A blue
aura forms about your lantern, and small sparks jump from the lantern to the
ground.  The aura fades away after several seconds, and your lamp is once
again shining brightly.

What Now? UP

<< Arched hall >>
You are in an arched hall.  A coral passage continues up and east.  Another
passage leads down.  The air smells of sea water.

What Now? UP

<< Coral passage >>
You are in an arched coral passage which enters from the west, splits, and
continues on to the east over a smooth and damp-looking patch of sand.  The
fork in the passage once led to the south, but it is now completely blocked by
debris.  

What Now? WAVE ROD

Strange!  Nothing happened.  At least, nothing obvious happened.

What Now? EAST

<< Bend in corridor >>
You are at a bend in an arched corral passage; the passage enters from the
west over a patch of damp sand, turns, and continues north.

What Now? NORTH

<< Fork in passage >>
You are at a fork in a high, arched coral passage.  The main portion of the
passage enters from the south; two smaller passages lead east and north.  The
smell of salt water is very strong here.

What Now? EAST

<< Jonah room >>
You are standing at the entrance of the Jonah room, a cavernous hall with high
ribbed walls.  The hall extends far to the south; a coral passage leads west.

What Now? SOUTH

<< South end of Jonah room >>
You are at the south end of the Jonah room.  Ahead of you, the way is barred
by a large set of immense stalactites and stalagmites which intermesh like
clenched teeth.  Nothing except blackness is visible between the stone
formations.
  There is a small spyglass carved out of whale baleen sitting here!

What Now? GET SPYGLASS AND EXAMINE IT

You are now carrying the scrimshaw spyglass.

The spyglass has lost its lens, so you can not look through it to see anything
far away.  It is totally useless as a telescope!  However, the scrimshaw
carving is very intricate and obviously done by a real artist.  A few words
have been carved in among the rest of the ornate scrimshaw drawing.

Your score just increase by 15 to 560.

What Now? READ SPYGLASS

Unfortunately the words are in a strange language which you can not understand
-- probably Dwarvish Eskimo.

What Now? NORTH

<< Jonah room >>
You are standing at the entrance of the Jonah room, a cavernous hall with high
ribbed walls.  The hall extends far to the south; a coral passage leads west.

What Now? WEST

<< Fork in passage >>
You are at a fork in a high, arched coral passage.  The main portion of the
passage enters from the south; two smaller passages lead east and north.  The
smell of salt water is very strong here.

What Now? NORTH

<< Fourier passage >>
You are in the Fourier passage.  This is a long and highly convoluted passage
composed of coral, which twists and turns like the path of an earthworm
tripping on LSD.  The passage here enters from the northwest, convulses, and
exits to the southwest (from which direction can be felt a cool and
salty-smelling breeze).

What Now? SOUTHWEST

<< Rock shelf >>
You are standing on a large shelf of sedimentary rock overlooking a lava
beach.  The shelf is an extension of an incredible cliff which extends north,
south, and upwards for as far as the eye can see.  Crudely carved steps lead
down from the shelf to the beach, and a twisting coral passage exits to the
west.    

What Now? DOWN

<< On beach >>
You are standing on a small black-sand beach.  The sand is composed of specks
of hardened black lava.  Rugged and unclimbable volcanic hills block all view
to the north and south, and a seemingly infinite cliff fills the entire
western hemisphere.  To the east, a narrow inlet of ocean water laps gently
upon the beach.  The scene is illuminated by the light of three small moons
shining through the shimmering glow of an aurora that fills the entire sky
with golden splendor.  Steps lead up the cliff to a shelf of rock.
  Lying upon the beach are the shattered remains of a dinghy.
    A bag (filled with pieces of eight) lies off to one side! (in the dinghy)
  There is a large X painted on a spot in the sand.

What Now? EXAMINE DINGHY

The dinghy's remains consist of little more than a few broken boards, upon one
of which may be seen a crude sketch of a skull and two crossed thighbones
(perhaps this dinghy was once owned by a cook?)

What Now? EXAMINE BAG

The bag is heavy and jangles when you lift it or move it.  It says "pieces of
eight" in bright gold letters on the front of the bag.

What Now? GET BAG

You are now carrying the gold bag.

Your score just increase by 15 to 575.

What Now? EXAMINE X

The X is about 3 feet square and painted white.  It shows up very well against
the black sand.

What Now? READ IT

The X says 'X'.  What did you expect?

What Now? DIG AT X

You manage to dig a small hole where the X was.

What Now? EXAMINE HOLE

The hole is circular and is about 4 feet deep and about 6 feet across.

What Now? DIG

The hole is now considerably bigger.

What Now? EXAMINE HOLE

The hole is circular and is about 8 feet deep and about 12 feet across.

What Now? DIG

The hole is now gigantic.

What Now? EXAMINE HOLE

The hole is circular and is 30 feet across.  The bottom is far below.

What Now? DIG

The sandy is very unstable and you lose your footing and tumble head over
heels to the bottom of the hole.  You will never be able to climb back up
out of the hole.

<< Bottom of Hole >>
You are at the bottom of a very deep hole.  The walls of the hole are loose
sand.  It is impossible to climb out of the hole.

What Now? DIG

You begin to dig furiously in the sand.  All of a sudden, your shovel breaks
through into empty space.  The sand crumbles around the sides of the hole and
you fall into the hole.  Fortunately, enough sand fell before you did to
cushion your fall as you land on a mound of sand.

<< Shaft Room >>
You are standing on a mound of black sand in the middle of a large cavernous
room. Far above, you can see a hole in the roof of the room, but it is too
high above you to reach.  In the middle of the room is large shaft descending
through the floor into the darkness below.  In the middle of that shaft is
another kind of shaft -- sort of like a 'Fire-house pole' -- that also
disappears into the darkness.  The shaft appears to be the only exit from the
room.    
  There is a shaft going down.

What Now? EXAMINE SHAFT

The shaft appears to made of brass.  It has been smeared with some kind of
grease.  It is the proverbial 'greased pole'.  It would be very dangerous
to slide down this pole.

Your score just increase by 10 to 585.

What Now? DROP SHOVEL  <-- Wont need again.

You drop the long-handled shovel.

What Now? DOWN <-- Must be wearing tennis shoes to go down pole.

<< Ladder Top >>
This is a very small room.  In the corner is a rickety wooden ladder, leading
downward.  It might be safe to descend.  In the other corner is a brass shaft
which disappears into the darkness above..

What Now? DOWN

<< Ladder Bottom >>
This is a rather wide room.  In the corner is a rickety wooden ladder, leading
upward.  A passage leaving the room to the west.

What Now? WEST

<< Outside Rabbit's Warren >>
You are in a small room.  There are two exits.  To the east and to the north.
Above the north exit is a sign that reads 'Rabbit's Warren'.  It sounds like
another one of those !@#$%^&*ing mazes.
  There is a very angry, gigantic rabbit blocking the exit to the north.

What Now? EXAMINE RABBIT

The rabbit is huge.  He rabbit is hobbling around using a cane, since he
appears to have lost one of his feet.  It's loss has obviously left him in a
bad mood.  He is quite angry and makes a number of very threatening gestures
to you.  

What Now? GIVE FOOT TO RABBIT

The rabbit is delighted that you have returned his foot.  He puts it back
on to his hind leg and hops off into his warren.  He leaves his cane behind.

<-- That rabbit's foot had to be good for something.  Now, you know what.

What Now? LOOK

<< Outside Rabbit's Warren >>
You are in a small room.  There are two exits.  To the east and to the north.
Above the north exit is a sign that reads 'Rabbit's Warren'.  It sounds like
another one of those !@#$%^&*ing mazes.
  There is a jeweled cane here.

What Now? GET CANE AND EXAMINE IT

You are now carrying the jeweled cane.

The cane is about 3 feet long duct and made of ebony.  It is quite sturdy.  The
head of the cane is gold with various precious jewels.

Your score just increase by 15 to 600.

What Now? NORTH

<< Inside Rabbit's Warren >>
You are in a rabbit's warren of very small rooms connected by tiny passages
leading off in all directions.

What Now? EXAMINE COMPASS <-- Only way to get out of "Rabbit's Warren" is to
                              examine or read the compass.

The needle of the compass is currently pointing East.

What Now? EAST

You have crawled around in some little holes and found your way blocked by a
recent cave-in.  You are now back in the main passage.

Finally, you discover a small tunnel leading east.  You just manage to fit
through and find yourself ...

<< Windy cavern >>
You in a large cavern.  The cavern has a large hole in the ceiling high above
your head.  The hole is too far above you to exit that way.  An incredibly
strong wind blows through the hole in the ceiling.  The wind is very, very
cold and you will freeze if you don't leave here soon.

Passages lead off to the west and to the south.  There is a small opening
about four feet above the ground in the north end of the cavern.

<-- We have been here before -- so we know what to do and where to go.

What Now? NORTH

<< End Of The Duct >>
You at the mouth of a small opening overlooking a large windy cavern.  To the
north is a duct that extends as far as you can see.  The duct is only about
three feet high, so you will need to crawl if you go north.  You can also
climb down or go south to enter the windy cavern.  It is very cold here!

What Now? NORTH

You crawl into the duct and continue to crawl north for a very long time.  The
cold, cold wind blows through the duct from the cavern to your south.

<< In The Duct >>
You are in the middle of an extremely long duct.  Cold air is blasting at you
from the south.  It is very cold!  The duct extends forever to the north.  To
the south, you can see a faint light.

What Now? NORTH

After a brief pause for rest, you set off to the north and crawl for a while
longer.  

<< In The Duct >>
You are in the middle of an extremely long duct.  It extends forever to the
north and to the south.  It is very cold!  You are going to freeze if you
don't get out of here soon.

What Now? NORTH

After a brief pause for rest, you set off to the north and crawl for a while
longer.  

<< In The Duct >>
You are in the middle of an extremely long duct.  It extends forever to the
north and to the south.  It is very cold!  Other than being cold, this place
is pretty boring.

What Now? NORTH

After a brief pause for rest, you set off to the north and crawl for a while
longer.  

<< At Turn In duct >>
You are at a elbow-turn in the duct.  The duct extends to the west and to the
south.  You can not see any light in either direction.  It is very cold here!

What Now? WEST

<< Air-Conditioned Room >>
You are in a small barren room.  There is an exit south to the computer
center.  The room is very, very cold because of the cold air blasting thru the
air-conditioning duct in the east wall.
  There is a metal air-conditioning grate on the floor.

What Now? SOUTH

<< Computer Center >>
You are in a large computer center with a raised floor and recessed lights in
the ceiling.  Large mainframes are everywhere.  There are exits to the north
and south.  There is a sign on the east wall.
  There are a pair of suction cups here.
  There is a hole in the floor where one of the tiles has been removed.
  An ancient IBM PC-XT is on a small table in the corner.

What Now? SOUTH

<< Southern end of long hall >>
You are at the southern end of a long hall.  A stairway leads up into the
darkness.  There is a curtain over the open doorway to the south.  The door to
the north is closed.  It is made of thick steel and looks like it could
survive a nuclear blast.
  Next to the steel door is a small slot.

What Now? UP

You climb up the stairs and enter the room above through the open safe door.
<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There is a small plastic card here!
  A small velvet pillow lies on the floor.
  There is a piece of crumpled paper here.

What Now? INVENTORY

You are carrying the following:
  boy-scout compass
  shining lantern
  black rod
  dwarf's axe
  mithril ring
  scrimshaw spyglass
  gold bag
  jeweled cane
You are wearing the following:
  tennis shoes
  metallic cloak

What Now? DROP BAG

As you drop the treasure, a voice booms out: "Well done!  You have collected
22 treasure(s) so far out of a total of 37."

As the bag hits the floor, it disappears in a puff of blue smoke!

What Now? DROP CANE

As you drop the treasure, a voice booms out: "Well done!  You have collected
23 treasure(s) so far out of a total of 37."

As the cane hits the floor, it disappears in a puff of blue smoke!

What Now? DROP SPYGLASS

As you drop the treasure, a voice booms out: "Well done!  You have collected
24 treasure(s) so far out of a total of 37."

As the spyglass hits the floor, it disappears in a puff of blue smoke!

What Now? DROP COMPASS  <-- Wont need again.

You drop the boy-scout compass.

What Now? DROP SHOES  <-- Wont need again.

You drop the tennis shoes.


< ----------------  CAMPAIGN 6 -- Across The Troll Bridge ------------------->

What Now? GET PAPER  <-- At last, this map will come in handy!

You are now carrying the crumpled paper.

What Now? PLUGH

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? SOUTH

A hollow voice says "Plugh".

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? SOUTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTHWEST

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? EAST

<< Toad's Hall >>
You are in a small, dank cubicle of rock.  A small passage leads back out to
the south; there is no other obvious exit.
  There is a small mushroom (?) growing on the wall.

<-- The mushroom has grown back and we can use it again.

What Now? GET MUSHROOM

You pluck the mushroom (?) from the wall where it was growing.

What Now? SOUTH

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? SOUTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTH

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? NORTH

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? PLUGH

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There are several iron keys on the ground here.
  A small velvet pillow lies on the floor.

What Now? TURBO

        >>Foof!<<

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? SOUTH

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  You see a carpet of moss here.

What Now? WEST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.
  There are several iron keys on the ground here.
  There is tasty food here.
  There is a large nest here, full of golden eggs!
  There are several dragon's teeth scattered haphazardly about.

What Now? GET ALL

You are now carrying the iron keys.
You are now carrying the tasty food.
You are now carrying the golden eggs.
You are now carrying the dragon's teeth.

Your score just increase by 15 to 615.

What Now? NORTHWEST

<< Oriental room >>
This is the oriental room.  A gently sloping passage leads upward to the
north, another passage leads southeast, and a hands and knees crawl leads
west.    
  Ancient oriental cave drawings cover the walls.

What Now? WEST

<< Large low room >>
You are in a large low room.  Crawls lead north, southeast, and southwest.

What Now? SOUTHWEST

<< Sloping corridor >>
You are in a long winding north/south corridor sloping out of sight in both
directions.

What Now? SOUTHWEST

<< SW side of chasm >>
You are on one side of a large deep chasm.  A heavy white mist rising up from
below obscures all view of the far side.  A southwest path leads away from the
chasm into a winding corridor.
  A rickety bridge extends across the chasm, vanishing into the mist.
  There is a small sign posted on the bridge.

What Now? EXAMINE BRIDGE

The bridge looks very unsafe!

What Now? READ SIGN

A sign posted on the bridge reads:
      "Stop!  Pay Troll!"

What Now? NORTHEAST

There are faint rustling noises from the darkness behind you.

A burley troll steps out from beneath the bridge and blocks your way.  "You
must give me something of great value or I won't let you cross my bridge.  Pay
up or return from whence you came!", he says grumpily.

<< SW side of chasm >>
You are on one side of a large deep chasm.  A heavy white mist rising up from
below obscures all view of the far side.  A southwest path leads away from the
chasm into a winding corridor.
  A rickety bridge extends across the chasm, vanishing into the mist.
  There is a small sign posted on the bridge.
  A troll insists you throw him a treasure before you may cross the bridge.

What Now? EXAMINE TROLL

The troll is about 4 feet high and about 4 feet wide.  It is ugly.  It seems
to be in bad temper and be very greedy.

What Now? THROW EGGS

The troll catches your treasure and scurries away out of sight.

Your score just decrease by 15 to 600.

What Now? NORTHEAST

Quickly, you scamper across the bridge -- before the troll returns.

<< NE side of chasm >>
You are on the far side of the chasm.  A northeast path leads away from the
chasm on this side.
  A rickety bridge extends across the chasm, vanishing into the mist.
  The troll is nowhere to be seen.

What Now? NORTHEAST

<< Corridor >>
You're in a long east/west corridor.  A faint rumbling noise can be heard in
the distance.

What Now? EAST

<< Fork in path >>
The path forks here.  The left fork leads northeast.  A dull rumbling seems to
get louder in that direction.  The right fork leads southeast down a gentle
slope.  The main corridor enters from the west.

What Now? NORTHEAST

<< Place with warm walls >>
The walls are quite warm here.  From the north can be heard a steady roar, so
loud that the entire cave seems to be trembling.  Another passage leads south,
and a low crawl goes east.

What Now? NORTH

<< At breath-taking view >>
You are on the edge of a breath-taking view.  Far below you is an active
volcano, from which great gouts of molten lava come surging out, cascading
back down into the depths.  The glowing rock fills the farthest reaches of the
cavern with a blood-red glare, giving every- thing an eerie, macabre
appearance.  The air is filled with flickering sparks of ash and a heavy smell
of brimstone.  The walls are hot to the touch, and the thundering of the
volcano drowns out all other sounds.  Embedded in the jagged roof far overhead
are myriad twisted formations composed of pure white alabaster, which scatter
the murky light into sinister apparitions upon the walls.  To one side is a
deep gorge, filled with a bizarre chaos of tortured rock which seems to have
been crafted by the devil himself.  An immense river of fire crashes out from
the depths of the volcano, burns its way through the gorge, and plummets into
a bottomless pit far off to your left.

Across the gorge, the entrance to a valley is dimly visible.  To the right, an
immense geyser of blistering steam erupts continuously from a barren island in
the center of a sulfurous lake, which bubbles ominously.  The far right wall
is aflame with an incandescence of its own, which lends an additional infernal
splendor to the already hellish scene.  Rising up from the volcano, the
sulfurous smoke seems to shape the letters "P L O V E R".  You wonder what it
might mean, but decide it is probably isn't important.

A dark, foreboding passage exits to the south.

What Now? INVENTORY

There are faint rustling noises from the darkness behind you.

You are carrying the following:
  iron keys
  shining lantern
  black rod
  tasty food
  dwarf's axe
  crumpled paper
  dragon's teeth
  mithril ring
  small mushroom
You are wearing the following:
  metallic cloak

What Now? DROP KEYS AND FOOD

You drop the iron keys.

You drop the tasty food.

What Now? WAVE ROD

The earth begins to shudder violently, and smoke flows up from the gorge
beneath your feet.  With a violent >glop<, the volcano belches out an immense
blast of molten lava which flies into the air above the gorge and suddenly
solidifies into a fragile-looking arch of wheat-colored stone that bridges the
gorge.   

What Now? NORTH

As you approach the center of the archway, hot vapors saturated with brimstone
drift up from the lava in the gorge beneath your feet.  The mithril ring in
your hand quivers and glows, and the fumes eddy away from the bridge without
harming you.

<-- You need the mithril ring in order to cross the wheat-stone bridge.

<< South end of valley >>
You are standing at the southern end of a long valley illuminated by
flickering red light from the volcanic gorge behind you.  Carved into the
walls of the valley is an incredible series of stone faces. Some of them look
down into the valley with expressions of benevolence that would credit a
saint; others glare with a malice that makes the heart grow faint.  All of
them are imbued with a fantastic seeming of life by the shifting and
flickering light of the volcano.  The entire far end of the valley is taken up
by an immense carving of a seated figure; its exact form cannot be seen from
here due to the uncertainty of the light.

Far to the west, there is a narrow crawlway.
  There is a wheat-colored stone bridge arching over the gorge.

What Now? WEST

<< Dead end passage >>
Dead end passage.  Scratched on a rock is the message, "Stand where the statue
gazes, and make use of the proper tool."

The only exit is east -- the way you entered.

<-- The "proper tool" may be different than you think.  You'll see.

What Now? EAST

<< South end of valley >>
You are standing at the southern end of a long valley illuminated by
flickering red light from the volcanic gorge behind you.  Carved into the
walls of the valley is an incredible series of stone faces. Some of them look
down into the valley with expressions of benevolence that would credit a
saint; others glare with a malice that makes the heart grow faint.  All of
them are imbued with a fantastic seeming of life by the shifting and
flickering light of the volcano.  The entire far end of the valley is taken up
by an immense carving of a seated figure; its exact form cannot be seen from
here due to the uncertainty of the light.

Far to the west, there is a narrow crawlway.
  There is a wheat-colored stone bridge arching over the gorge.

What Now? NORTH

<< North end of valley >>
You are standing at the north end of the Valley of the Stone Faces.  Above
you, an incredible bas-relief statue of an immense minotaur has been carved
out of the rock.  At least sixty feet high, it sits gazing down at you with a
faint but definite expression of amusement.  Between its feet and the floor is
a rock wall about ten feet high which extends across the entire north end of
the valley.

What Now? MELENKURION  <-- This is the tool the message meant!  Remember the
                           name in the tool room inside the building.

Rock silently crumbles off of the wall in front of you, revealing dark
passages leading northwest, north, and northeast.

Your score just increase by 15 to 615.

What Now? NORTHEAST

<< Winding passage >>
You are in a winding passage which enters from the northwest, loops around
several times, and exits to the north.

What Now? NORTH

<< Golden chamber >>
You are in a chamber with golden walls and a high ceiling.  Passages lead
south, northeast, and northwest.

What Now? NORTHEAST

<< Arabesque room >>
You are in a small room whose walls are covered with an elaborate pattern of
arabesque figures and designs.
  There is a small, tightly-sealed earthenware flask on the ground here.

What Now? GET FLASK AND EXAMINE IT

You are now carrying the earthenware flask.

The flask has the words, "London Dry" written on the side.  It is sealed.

What Now? SOUTH

<< Golden chamber >>
You are in a chamber with golden walls and a high ceiling.  Passages lead
south, northeast, and northwest.

What Now? NORTHWEST

<< Translucent room >>
You are in a large room whose walls are composed of some translucent whitish
mineral.  The room is illuminated by a flickering reddish glow shining through
the southern wall.  A passage leads east.
  There is an ancient Chinese jade bracelet here!

What Now? GET BRACELET AND EXAMINE IT

You are now carrying the jade bracelet.

The bracelet is carved from a solid piece of green jade.  The carving is of
intertwining snakes, fish and birds -- as if designed by M. C. Escher.

Your score just increase by 15 to 630.

What Now? EAST

Suddenly and without warning, there appears from within the very cave walls
around you a horde of vicious little goblins!  Each one stands about eight
inches high on a pair of spindly black legs, has a globular, spine-covered
body resembling a giant gooseberry, a wide mouth filled with sharp teeth, and
a pair of glittering little green eyes!  They swarm around you and try to
block your way.

<< Translucent room >>
You are in a large room whose walls are composed of some translucent whitish
mineral.  The room is illuminated by a flickering reddish glow shining through
the southern wall.  A passage leads east.
  You are surrounded by a slavering horde of gooseberry goblins!

What Now? EXAMINE GOBLINS

The goblins are jumping up and down frantically, and have worked themselves
into a real slavering frenzy!!

What Now? EAST

There are faint rustling noises from the darkness behind you.

You are being pursued by a vicious horde of little gooseberry goblins!

<< Golden chamber >>
You are in a chamber with golden walls and a high ceiling.  Passages lead
south, northeast, and northwest.

What Now? THROW TEETH  <-- Those teeth had to good for something!

The goblins are jumping up and down frantically, and have worked themselves
into a real slavering frenzy!!

As each of the dragon's teeth strikes the ground, a fully-armed human skeleton
springs up from where it struck and leaps to your defense!  The skeletal
warriors attack the vicious gooseberry goblins and drive them away in
screaming panic; they then salute you with their ancient and rusty swords, and
fade silently into nothingness.

Your score just increase by 15 to 645.

What Now? SOUTH

<< Winding passage >>
You are in a winding passage which enters from the northwest, loops around
several times, and exits to the north.

What Now? NORTHWEST

<< North end of valley >>
You are standing at the north end of the Valley of the Stone Faces.  Above
you, an incredible bas-relief statue of an immense minotaur has been carved
out of the rock.  At least sixty feet high, it sits gazing down at you with a
faint but definite expression of amusement.  Between its feet and the floor is
a rock wall about ten feet high which extends across the entire north end of
the valley.
  Dark tunnels lead northeast, north, and northwest.

What Now? NORTHWEST

<< S end of fog-filled room >>
You are standing at the southern end of what appears to be a large room filled
with multicolored fog.  The sides and far end of the room cannot be seen due
to the thickness of the fog - it's a real pea-souper (even to the color in
places!).  A passage leads back to the south; a dull rumbling sound issues
from the passage.

What Now? NORTH

<< Fog-filled room >>
You are standing, badly befuddled, in a pale purple fog.

What Now? EXTINGUISH LAMP  <-- You need to extinguish the lamp in order to see
                               the "faint glow of light."

Your lamp is now off.

What Now? LOOK

<< Fog-filled room >>
You are standing, badly befuddled, in a pale purple fog.
  A faint glow of light is visible through the fog to the east.

What Now? EXAMINE GLOW

It is a very faint light.

What Now? EAST  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are wandering around in the middle of a bright red fog.
  A glimmer of light is visible through the fog in the west.

What Now? WEST  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are lost in the midst of a thick, pea-green fog.
  A glow of light is visible through the fog to the north.

What Now? NORTH  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are trying to find your way through a dense coal-black fog.
  A faint shimmer of light is visible to the south.

What Now? SOUTH  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are lost in the heart of a strange yellow fog.
  A flickering light is visible through the fog in the northeast.

What Now? NORTHEAST  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are standing, badly bedazzled, in a day-glow orange fog.
  A dim light is visible in the southeast.

What Now? SOUTHEAST  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are hunting your way through a shimmering magenta fog.
  A dim flickering light is visible through the fog in the northwest.

What Now? NORTHWEST  <-- Follow the "faint glow of light"

<< Fog-filled room >>
You are somewhere in the center of a weird, pearly pink fog.
  A dim glow of light is visible in the southwest.

What Now? SOUTHWEST  <-- Follow the "faint glow of light"

<< Foggy room by cairn >>
You are standing in a fog-filled room next to a tall cairn of glowing rocks.
An opening in the cairn leads down to a dark passage.

What Now? DOWN

For some reason, you can't see anything here.

What Now? LIGHT LAMP

It is now pitch dark.  If you proceed you will likely fall into a pit.

Your lamp is now shining brightly!

What Now? LOOK

<< Nondescript chamber >>
You're in a small, nondescript chamber.  A dark passage leads up and to the
south, and a wide but low crawl leads north.
  There is a small toy yacht sitting on the floor.

What Now? GET YACHT

You are now carrying the toy yacht.

What Now? EXAMINE YACHT

The small toy yacht is totally covered with rubies, and has the words "Omar
Khayyam" engraved on the side!!  It must be the famous "Ruby Yacht of Omar
Khayyam!"  <-- This is a either a wonderful or a terrible pun -- depending
               upon your sense of humor!!

Your score just increase by 15 to 660.

What Now? NORTH

<< Room with pentagram >>
You're in a small room with a very smooth rock floor.  A low crawl leads out
to the west, and a crack in the rock leads north.
  A pentagram has been marked on the floor.

What Now? PUT FLASK IN PENTAGRAM

You have set the flask down in the center of the pentagram.

What Now? OPEN FLASK

The wax seal breaks away easily.  A cloud of dark smoke pours up from the
mouth of the flask and condenses into the form of a twelve-foot Djinn standing
in the pentagram.  He pushes experimentally at the magical wall of the
pentagram (which holds), and nods politely to you.  "MY THANKS, OH MORTAL," he
says in an incredibly deep bass voice.  "IT HAS BEEN THREE THOUSAND YEARS
SINCE SOLOMON SEALED ME INTO THAT BOTTLE, AND I AM GRATEFUL THAT YOU HAVE
RELEASED ME.  IF YOU WILL OPEN THIS PENTAGRAM AND LET ME GO FREE, I WILL GIVE
YOU SOME ADVICE THAT YOU MAY ONE DAY WISH TO POSSESS."

Your score just increase by 15 to 675.

What Now? EXAMINE DJINN

The djinn (or genie -- if you prefer) stands in the center of the pentagram.
He towers above you and looks down at your menacingly.

What Now? OPEN PENTAGRAM

The pentagram's magical barrier sparks fitfully and goes down.  The Djinn
stretches gratefully and smiles at you.  "AGAIN, MY THANKS," he says.  "MY
ADVICE TO YOU WILL TAKE THE FORM OF A HISTORY LESSON. WHEN RALPH WITT, THE
ARCHITECT AND CONSTRUCTOR OF THIS CAVE, WAS VERY YOUNG, HE BECAME VERY
INCENSED THAT HIS NAME WAS AT THE END OF THE ALPHABET.  HE FELT (FOR SOME
REASON) THAT THE LETTER W BELONGED NEAR THE BEGINNING OF THE ALPHABET, AND
THAT ALL OF THOSE "UPSTART LETTERS WHICH UNFAIRLY USURPED THE BEST ROOMS"
SHOULD BE FORCED INTO EXILE AT THE END OF THE ALPHABET.  HIS INSTINCT FOR
MATTERS MAGICAL AND MYSTICAL LED HIM TO APPLY THIS STRANGE BELIEF INTO THE
CAVE'S STRUCTURE WHEN HE EXCAVATED IT.  YOU HAVEN'T YET BEEN AFFECTED BY HIS
STRANGE HABITS, BUT YOU SHOULD REMEMBER THIS.  FAREWELL, AND GOOD LUCK."  With
that, the Djinn evaporates into a cloud of smoke and drifts rapidly away.

<-- The Djinn's hint will come in handy at the very end of the game!

What Now? NORTH

<< Bottom of chimney >>
The crack in the rock ends here, but a narrow chimney leads up.  You should be
able to climb it.

What Now? UP

<< In lava tube >>
You're at the top of a narrow chimney in the rock.  A cylindrical tube
composed of hardened lava leads south.

What Now? SOUTH

<< Steep slide in lava tube >>
The lava tube continues down and to the south, but it becomes very steep here
- if you go down it you probably won't be able to get back up.

What Now? DOWN

Wheeeeeeeeeeeeeeee.......   >oof<

That was fun!

<< S end of fog-filled room >>
You are standing at the southern end of what appears to be a large room filled
with multicolored fog.  The sides and far end of the room cannot be seen due
to the thickness of the fog - it's a real pea-souper (even to the color in
places!).  A passage leads back to the south; a dull rumbling sound issues
from the passage.

What Now? SOUTH

<< North end of valley >>
You are standing at the north end of the Valley of the Stone Faces.  Above
you, an incredible bas-relief statue of an immense minotaur has been carved
out of the rock.  At least sixty feet high, it sits gazing down at you with a
faint but definite expression of amusement.  Between its feet and the floor is
a rock wall about ten feet high which extends across the entire north end of
the valley.
  Dark tunnels lead northeast, north, and northwest.

What Now? NORTH

<< Rough and narrow passage >>
You are in a narrow and rough passage running north and south.  A dull
rumbling sound can be heard from the south.
  There is a basilisk lying in the corridor to the north, snoring quietly.

What Now? NORTH

The basilisk stirs restlessly and grumbles in its sleep, but it does not
awaken.  

<< North of basilisk's den >>
You're in rough passage to the north of the basilisk's den.
  There is a basilisk lying in the corridor to the south.  It is asleep.

What Now? NORTH

<< Fork in passage >>
The passage here enters from the south and divides, with a wide tunnel exiting
to the north and a set of steps leading downward.

What Now? DOWN

There is a rumbling sound deep within the earth.

<< On the steps >>
You are on a long, spiral set of steps leading down into the earth.

What Now? DOWN

<< Exit on steps >>
A small tunnel exits from the steps and leads north.  The steps continue
downwards.

What Now? NORTH

<< "Y2" room >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.
  There is a piece of torn paper here.  It is torn on the bottom.

What Now? GET PAPER

Which "PAPER", the CRUMPLED PAPER or the TORN PAPER?

THE TORN PAPER

You are now carrying the torn paper.

What Now? EXAMINE TORN PAPER

The paper appears to be some kind of map of the cave.  It has a title that
says "MAP OF CATACOMBS."  The map is torn on the bottom -- so it does not
show the entire area of the catacombs -- whatever they are.

What Now? READ TORN PAPER

 ______________      ______________
|    MAZE      |____|    MAZE      |              MAP OF CATACOMBS
|               ____ S             |
|____   D  ____|    |____      ____|
 ____|    |____      ____| NW |____         ________________________________
|    MAZE      |    |    MAZE      |       |    MAZE       ____ D   MAZE    |
|____   W  ____|    |____      ____|       |____  S   ____|    |___      ___|
 ____|    |____      ____|    |____         ____|    |____      ___|    |___
|              |    |      SW      |       |              |    |     SE     |
|    MAZE      |    |    MAZE      |       |     MAZE     |    |    MAZE    |
|____  NW  ____|    |____      ____|       |____   N  ____|    |___      ___|
 ____|    |____      ____|    |_________________|    |______    ___|    |___
|     MAZE     |    |      S        ___ W    "Y2"     S (OUT)  |      E     |
|____   N  ____|    |____MAZE  ____|   |____  E  ___________   |___ MAZE ___|
     |    |              |    |_____________|   |                  |    |
 ____|    |____          |  U     ROCKS      D,W|               ___|    |___
|     MAZE     |         |______________________|              |     NE     |
|____  S   ____|                                               |___ MAZE ___|
     |    |                                                        |    |

<-- It is the other half of the map.

What Now? INVENTORY

You are carrying the following:
  toy yacht
  shining lantern
  black rod
  dwarf's axe
  crumpled paper
  torn paper
  jade bracelet
  mithril ring
  small mushroom
You are wearing the following:
  metallic cloak

What Now? READ CRUMPLED PAPER

     |    |                                                        |    |
 ____|    |____      ______________      ______________      ______|    |___
|    MAZE      |____|   MAZE       |____|    MAZE      |____|        SE     |
|             N ____             SW ____              E ____        MAZE    |
|______________|    |____  E   ____|    |______________|    |_______________|
                     ____|    |____
                    |WEST END OF   |
                    |ROYAL HALL    |
                    |____   E  ____|
                     ____|    |____
                    |EAST END OF   |
                    |ROYAL HALL    |
                    |______________|

<-- Now you have both halves of the map, so finding your way through the
    catacombs should be a piece of cake!

What Now? WEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTH

A large phosphorescent cloud of smoke drifts into view, and a large mouth and
two dark eyes take shape on the side.  One of the eyes winks at you, and the
djinn's deep voice says "GREETINGS AGAIN, MORTAL.  I HAVE REMEMBERED A PIECE
OF ANCIENT LORE THAT I LEARNED FROM MY AUNT, AN AFREET OF GREAT KNOWLEDGE.
THERE IS ANOTHER MAGIC WORD THAT YOU MIGHT FIND OF USE IF YOU SHOULD EVER FIND
YOURSELF BEING ATTACKED BY THOSE PESTIFEROUS DWARVES.  YOU SHOULD USE IT ONLY
AS A LAST RESORT, THOUGH, SINCE IT IS A MOST POTENT WORD AND IS PRONE TO
BACKFIRE FOR NO OBVIOUS REASON; ALSO, IT SHOULD NEVER BE USED NEAR WATER OR
NEAR ANY SHARP WEAPON OR THE RESULTS MAY BE MOST UNFORTUNATE.  THE WORD IS
'phuggg'", whispers the djinn, "AND IT MUST BE PRONOUNCED CAREFULLY IF IT IS
TO HAVE THE PROPER EFFECT.  FAREWELL AGAIN, AND GOOD LUCK!"  With that, the
djinn-cloud drifts away out of sight.

<-- "PHUGGG" is a very powerful magic word.  However, you must follow the
    Djinn's advice not to say this word near water or a sharp weapon.

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTHWEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? NORTHWEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTH

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? DOWN

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? WEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? NORTHWEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? NORTH

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTH

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? NORTH

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? EAST

<< West end of Audience Hall >>
You are standing at the west end of the royal Audience Hall.  The walls here
are composed of the finest marble, and the floor is built of slabs of rare
onyx and bloodstone.  The ceiling is high and vaulted, and is supported by
pillars of rare Egyptian red granite; it gives off a nacreous glow that fills
the entire chamber with a light like moon-light shining off of polished
silver.  

What Now? EAST

<< East end of Audience Hall >>
You are at the eastern end of the Audience Hall.  There is a large dais rising
out of the floor here; resting upon the dais is a strange-looking throne
made out of interlocking bars and rods of metal.
  Sitting on the throne is an incredible skeleton.

What Now? EAT MUSHROOM  <-- Needed to "wrestle" the sceptre from the
                            skeleton's bony grasp and to get the correct
                            secret word.

As you swallow the mushroom your mouth becomes numb, and everything seems to
swirl around you.  The effect quickly passes, and you find that your muscles
have bulged unbelievably.

What Now? EXAMINE SKELETON

The skeleton is fairly humanoid from the waist up (except for its incredible
size and four extra arms); below that, it resembles the body of a giant
python, and is wrapped in and around the bars and rods of the throne.
Clutched in one bony hand is a long sceptre, ornately encrusted with
sapphires!!

What Now? EXAMINE SCEPTRE

The sceptre is about 3 feet long and ornately encrusted with sapphires!!  It
must be very valuable.

What Now? GET SCEPTRE

You pluck the sceptre from the skeleton's bony hand.  As you do, the skeleton
raises its head and whispers "Remember - ZORTON!" in a foreboding tone; it then
sags to the ground and crumbles into dust which drifts away into the still air
of the cave.

<-- ZORTON will later be used to open the sealed safe.

Your score just increase by 30 to 705.

What Now? WEST

<< West end of Audience Hall >>
You are standing at the west end of the royal Audience Hall.  The walls here
are composed of the finest marble, and the floor is built of slabs of rare
onyx and bloodstone.  The ceiling is high and vaulted, and is supported by
pillars of rare Egyptian red granite; it gives off a nacreous glow that fills
the entire chamber with a light like moon-light shining off of polished
silver.  

What Now? WEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTHWEST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? EAST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTHEAST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? NORTHEAST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? EAST

There is a threatening little dwarf in the room with you!

The dwarf blocks your way and will not let you leave!

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.
  There is a threatening little dwarf in the room with you!

What Now? KILL DWARF WITH AXE

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? EAST

A strange malaise suddenly afflicts you.  You shiver with chill, and your
muscles seem to turn to putty; everything around you becomes gray and unreal.
The fit quickly passes, and you find that your body has degenerated back to
what it was like before you ate the mushroom.

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTHEAST

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? DOWN

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? SOUTH

<< In the catacombs >>
You are in the catacombs.  Enchanted tunnels lead in all directions.

What Now? NORTH

<< "Y2" room >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? SOUTH

<< Exit on steps >>
A small tunnel exits from the steps and leads north.  The steps continue
downwards.

What Now? DOWN

<< Storage room >>
You're in what was once a storage room.  A set of steps lead up.
  A highly polished metal plate lies nearby.

What Now? GET PLATE

You are now carrying the metal plate.

Your score just increase by 15 to 720.

What Now? UP

<< Exit on steps >>
A small tunnel exits from the steps and leads north.  The steps continue
downwards.

What Now? UP

<< On the steps >>
You are on a long, spiral set of steps leading down into the earth.

What Now? UP

<< Fork in passage >>
The passage here enters from the south and divides, with a wide tunnel exiting
to the north and a set of steps leading downward.

What Now? NORTH

<< Peelgrunt room >>
You are in the Peelgrunt room.  There is a walk-in safe to the south.

What Now? EXAMINE SAFE

The massive walk-in safe takes up the entire wall.  It is tightly closed, and
has no handle, lock, nor keyhole.  It would take an Houdini to get in to or
out of this thing!  There is a small brass plate attached to the front of the
safe.    

What Now? READ PLATE

The plate proclaims that the safe was manufactured by the Turbo Safe Company
in 1973.  (This is not particularly useful information.)

What Now? ZORTON  <-- Any other magic word will release "Rover", the cave
                      security guard.  Rover is patterned after the large
                      white "blob" in the TV series "The Prisoner."

>ker-THUNK<
/            >screeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeech<

The (somewhat rusty) safe is now open.

What Now? ENTER

You duck your head as you enter the walk-in safe.

<< Inside the safe >>
You are inside the safe.
  A massive steel door is open to the north.
  There is a massive crown made of solid iridium floating in midair!

What Now? GET CROWN AND EXAMINE IT

You grab the floating crown out of the air.

The iridium crown brightly reflects the light and gives off a strange glow.
It is floating magically in midair -- with no visible means of support.

Your score just increase by 15 to 735.

What Now? DROP CROWN

There are faint rustling noises from the darkness behind you.

As you drop the treasure, a voice booms out: "Well done!  You have collected
25 treasure(s) so far out of a total of 37."

As the crown hits the floor, it disappears in a puff of blue smoke!

<-- "Treasures" can be dropped in the safe -- just like they can be dropped
    inside the building.

What Now? DROP YACHT

As you drop the treasure, a voice booms out: "Well done!  You have collected
26 treasure(s) so far out of a total of 37."

As the yacht hits the floor, it disappears in a puff of blue smoke!

What Now? DROP TORN PAPER  <-- Wont need again.

There are faint rustling noises from the darkness behind you.

You drop the torn paper.

What Now? DROP CRUMPLED PAPER  <-- Wont need again.

You drop the crumpled paper.

What Now? DROP BRACELET

As you drop the treasure, a voice booms out: "Well done!  You have collected
27 treasure(s) so far out of a total of 37."

As the bracelet hits the floor, it disappears in a puff of blue smoke!

What Now? DROP SCEPTRE

As you drop the treasure, a voice booms out: "Well done!  You have collected
28 treasure(s) so far out of a total of 37."

As the sceptre hits the floor, it disappears in a puff of blue smoke!

What Now? NORTH

<< Peelgrunt room >>
You are in the Peelgrunt room.  There is a walk-in safe to the south.
  The door of a massive walk-in safe is open and blocks the exit passage.

What Now? CLOSE DOOR  <-- Must close door in order to exit Peelgrunt room.

>Creeeeeeeeeeeeeeeeeeeeeeeeeeeek<     >ker-CHUNK!<

The safe is now closed.

What Now? SOUTH

<< Fork in passage >>
The passage here enters from the south and divides, with a wide tunnel exiting
to the north and a set of steps leading downward.

What Now? SOUTH

There is a threatening little dwarf in the room with you!

The dwarf blocks your way and will not let you leave!

What Now? KILL DWARF WITH AXE

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? SOUTH

<< North of basilisk's den >>
You're in rough passage to the north of the basilisk's den.
  There is a basilisk lying in the corridor to the south.  It is asleep.

What Now? SOUTH

There are faint rustling noises from the darkness behind you.

The basilisk stirs grumpily and awakens, peering sleepily about.  It sees its
reflection in the metal plate that you are carrying, shudders, and turns into
solid granite.  <-- Good thing you were carrying the metal plate!!!

<< Rough and narrow passage >>
You are in a narrow and rough passage running north and south.  A dull
rumbling sound can be heard from the south.
  There is a petrified basilisk in the corridor to the north.

What Now? NORTH

<< North of basilisk's den >>
You're in rough passage to the north of the basilisk's den.
  There is a petrified basilisk in the corridor to the south.

What Now? NORTH

<< Fork in passage >>
The passage here enters from the south and divides, with a wide tunnel exiting
to the north and a set of steps leading downward.

What Now? NORTH

There are faint rustling noises from the darkness behind you.

<< Peelgrunt room >>
You are in the Peelgrunt room.  There is a walk-in safe to the south.
  A massive walk-in safe takes up one entire wall.  It is tightly closed.

What Now? ZORTON

>ker-THUNK<
/            >screeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeech<

The (somewhat rusty) safe is now open.

What Now? ENTER

You duck your head as you enter the walk-in safe.

<< Inside the safe >>
You are inside the safe.
  There is a piece of crumpled paper here.
  There is a piece of torn paper here.  It is torn on the bottom.
  A massive steel door is open to the north.

What Now? DROP METAL PLATE  <-- You don't need it anymore -- now that the
                                basilisk is dead.

As you drop the treasure, a voice booms out: "Well done!  You have collected
29 treasure(s) so far out of a total of 37."

As the plate hits the floor, it disappears in a puff of blue smoke!

What Now? NORTH

<< Peelgrunt room >>
You are in the Peelgrunt room.  There is a walk-in safe to the south.
  The door of a massive walk-in safe is open and blocks the exit passage.

What Now? CLOSE DOOR

There is a threatening little dwarf in the room with you!

>Creeeeeeeeeeeeeeeeeeeeeeeeeeeek<     >ker-CHUNK!<

The safe is now closed.

What Now? SOUTH

<< Fork in passage >>
The passage here enters from the south and divides, with a wide tunnel exiting
to the north and a set of steps leading downward.

What Now? SOUTH

<< North of basilisk's den >>
You're in rough passage to the north of the basilisk's den.
  There is a petrified basilisk in the corridor to the south.

What Now? SOUTH

<< Rough and narrow passage >>
You are in a narrow and rough passage running north and south.  A dull
rumbling sound can be heard from the south.
  There is a petrified basilisk in the corridor to the north.

What Now? SOUTH

<< North end of valley >>
You are standing at the north end of the Valley of the Stone Faces.  Above
you, an incredible bas-relief statue of an immense minotaur has been carved
out of the rock.  At least sixty feet high, it sits gazing down at you with a
faint but definite expression of amusement.  Between its feet and the floor is
a rock wall about ten feet high which extends across the entire north end of
the valley.
  Dark tunnels lead northeast, north, and northwest.

What Now? SOUTH

<< South end of valley >>
You are standing at the southern end of a long valley illuminated by
flickering red light from the volcanic gorge behind you.  Carved into the
walls of the valley is an incredible series of stone faces. Some of them look
down into the valley with expressions of benevolence that would credit a
saint; others glare with a malice that makes the heart grow faint.  All of
them are imbued with a fantastic seeming of life by the shifting and
flickering light of the volcano.  The entire far end of the valley is taken up
by an immense carving of a seated figure; its exact form cannot be seen from
here due to the uncertainty of the light.

Far to the west, there is a narrow crawlway.
  There is a wheat-colored stone bridge arching over the gorge.

What Now? SOUTH

As you approach the center of the archway, hot vapors saturated with brimstone
drift up from the lava in the gorge beneath your feet.  The mithril ring in
your hand quivers and glows, and the fumes eddy away from the bridge without
harming you.

<-- You need the mithril ring in order to cross the wheat-stone bridge.

<< At breath-taking view >>
You are on the edge of a breath-taking view.  Far below you is an active
volcano, from which great gouts of molten lava come surging out, cascading
back down into the depths.  The glowing rock fills the farthest reaches of the
cavern with a blood-red glare, giving every- thing an eerie, macabre
appearance.  The air is filled with flickering sparks of ash and a heavy smell
of brimstone.  The walls are hot to the touch, and the thundering of the
volcano drowns out all other sounds.  Embedded in the jagged roof far overhead
are myriad twisted formations composed of pure white alabaster, which scatter
the murky light into sinister apparitions upon the walls.  To one side is a
deep gorge, filled with a bizarre chaos of tortured rock which seems to have
been crafted by the devil himself.  An immense river of fire crashes out from
the depths of the volcano, burns its way through the gorge, and plummets into
a bottomless pit far off to your left.

Across the gorge, the entrance to a valley is dimly visible.  To the right, an
immense geyser of blistering steam erupts continuously from a barren island in
the center of a sulfurous lake, which bubbles ominously.  The far right wall
is aflame with an incandescence of its own, which lends an additional infernal
splendor to the already hellish scene.  Rising up from the volcano, the
sulfurous smoke seems to shape the letters "P L O V E R".  You wonder what it
might mean, but decide it is probably isn't important.

A dark, foreboding passage exits to the south.
  There is a wheat-colored stone bridge arching over the gorge.
  There are several iron keys on the ground here.
  There is tasty food here.

What Now? GET ALL

You are now carrying the iron keys.
You are now carrying the tasty food.

What Now? SOUTH

There are faint rustling noises from the darkness behind you.

<< Place with warm walls >>
The walls are quite warm here.  From the north can be heard a steady roar, so
loud that the entire cave seems to be trembling.  Another passage leads south,
and a low crawl goes east.

What Now? EAST

<< Chamber of boulders >>
You are in a small chamber filled with large boulders.  The walls are very
warm, causing the air in the room to be almost stifling from the heat.  The
only exit is a crawl heading west, through which is coming a low rumbling.
  There are rare spices here!

What Now? GET SPICES AND EXAMINE THEM

You are now carrying the rare spices.

The spices are all in little bottles labeled "Shilling" or "McCormick".  They
are quite rare and worth a great deal.

Your score just increase by 15 to 750.

What Now? WEST

<< Place with warm walls >>
The walls are quite warm here.  From the north can be heard a steady roar, so
loud that the entire cave seems to be trembling.  Another passage leads south,
and a low crawl goes east.

What Now? SOUTH

<< Fork in path >>
The path forks here.  The left fork leads northeast.  A dull rumbling seems to
get louder in that direction.  The right fork leads southeast down a gentle
slope.  The main corridor enters from the west.

What Now? SOUTHEAST

<< Limestone passage >>
You are walking along a gently sloping north/south passage lined with oddly
shaped limestone formations.

What Now? SOUTH

<< Entry to barren room >>
You are standing at the entrance to a large, barren room.  A sign posted above
the entrance reads:

       "Caution!  Bear in room!"

What Now? EAST

<< Barren room >>
You are inside a barren room.  The center of the room is completely empty
except for some dust.  Marks in the dust lead away toward the far end of the
room.  The only exit is the way you came in.
  The bear is locked to the wall with a golden chain!
  There is a ferocious cave bear eyeing you from the far end of the room!

What Now? EXAMINE CHAIN

The chain is about six feet long and has a lock on each end.  One end is
locked to the bear and the other end to the wall.  The chain and locks are
both made of solid gold.

What Now? EXAMINE BEAR

The bear is quite ferocious.  It is about 6 feet tall and weighs about 900
pounds.  Its claws look very sharp and its teeth are very big.  It is snarling
at you.

What Now? FEED BEAR

The bear eagerly wolfs down your food, after which he seems to calm down
considerably, and even becomes rather friendly.

Your score just increase by 10 to 760.

What Now? EXAMINE BEAR

The bear is quite gentle.  It is about 6 feet tall and weighs about 900
pounds.  Its claws look very sharp and its teeth are very big.  It is licking
the last of the tuna fish off its paws.

What Now? UNLOCK BEAR

The bear is now unlocked and is free to roam about the cave.

What Now? EXAMINE BEAR

The bear is quite happily.  It is about 6 feet tall and weighs about 900
pounds.  Its claws look very sharp and its teeth are very big.  It rubs it
nose against your leg and nearly knocks you over.  It just licks your hand
(UGH!).

What Now? UNLOCK CHAIN

OK.  The chain is now unlocked!

What Now? GET CHAIN AND EXAMINE IT

You are now carrying the golden chain.

The chain is about six feet long and has a lock on each end.  The chain and
locks are both made of solid gold.

Your score just increase by 15 to 775.

What Now? GET BEAR

You pet the bear affectionately and tickle it under its chin and behind its
ears.  It seems very happy and licks your hand (UGH!).  The bear likes you and
will follow you anywhere.  (Lucky you!)

What Now? WEST

You are being followed by a very large, tame bear.

<< Entry to barren room >>
You are standing at the entrance to a large, barren room.  A sign posted above
the entrance reads:

       "Caution!  Bear in room!"

What Now? NORTH

You are being followed by a very large, tame bear.

<< Limestone passage >>
You are walking along a gently sloping north/south passage lined with oddly
shaped limestone formations.

What Now? NORTH

You are being followed by a very large, tame bear.

<< Fork in path >>
The path forks here.  The left fork leads northeast.  A dull rumbling seems to
get louder in that direction.  The right fork leads southeast down a gentle
slope.  The main corridor enters from the west.

What Now? WEST

You are being followed by a very large, tame bear.

<< Corridor >>
You're in a long east/west corridor.  A faint rumbling noise can be heard in
the distance.

What Now? WEST

You are being followed by a very large, tame bear.

<< NE side of chasm >>
You are on the far side of the chasm.  A northeast path leads away from the
chasm on this side.
  A rickety bridge extends across the chasm, vanishing into the mist.

What Now? SOUTHWEST

You are being followed by a very large, tame bear.

A burley troll steps out from beneath the bridge and blocks your way.  "You
must give me something of great value or I won't let you cross my bridge.  Pay
up or return from whence you came!", he says grumpily.

What Now? THROW BEAR  <-- Clever, yet rather bizarre idea!  However, it works!

The bear lumbers toward the troll, who lets out a startled shriek and scurries
away.  The bear soon gives up pursuit and wanders back.

Your score just increase by 10 to 785.

What Now? SOUTHWEST

Quickly, you scamper across the bridge -- before the troll returns.

<< SW side of chasm >>
You are on one side of a large deep chasm.  A heavy white mist rising up from
below obscures all view of the far side.  A southwest path leads away from the
chasm into a winding corridor.
  A rickety bridge extends across the chasm, vanishing into the mist.
  There is a small sign posted on the bridge.
  The troll is nowhere to be seen.

What Now? SOUTHWEST

<< Sloping corridor >>
You are in a long winding north/south corridor sloping out of sight in both
directions.

What Now? SOUTH

<< Large low room >>
You are in a large low room.  Crawls lead north, southeast, and southwest.

What Now? SOUTHEAST

<< Oriental room >>
This is the oriental room.  A gently sloping passage leads upward to the
north, another passage leads southeast, and a hands and knees crawl leads
west.    
  Ancient oriental cave drawings cover the walls.

What Now? SOUTHEAST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.

What Now? EAST

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  You see a carpet of moss here.

What Now? NORTH

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? TURBO

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  A small velvet pillow lies on the floor.

What Now? INVENTORY

You are carrying the following:
  iron keys
  shining lantern
  black rod
  dwarf's axe
  rare spices
  golden chain
  mithril ring
You are wearing the following:
  metallic cloak

What Now? DROP SPICES

As you drop the treasure, a voice booms out: "Well done!  You have collected
30 treasure(s) so far out of a total of 37."

As the spices hits the floor, it disappears in a puff of blue smoke!

What Now? DROP CHAIN

As you drop the treasure, a voice booms out: "Well done!  You have collected
31 treasure(s) so far out of a total of 37."

As the chain hits the floor, it disappears in a puff of blue smoke!

What Now? DROP RING

As you drop the treasure, a voice booms out: "Well done!  You have collected
32 treasure(s) so far out of a total of 37."

As the ring hits the floor, it disappears in a puff of blue smoke!

What Now? DROP KEYS  <-- Wont need again.

You drop the iron keys.


< ----------------  CAMPAIGN 7 -- Above The Beanstalk ----------------------->

What Now? PLUGH

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? SOUTH

A hollow voice says "Plugh".

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? SOUTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTHWEST

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? EAST

<< Toad's Hall >>
You are in a small, dank cubicle of rock.  A small passage leads back out to
the south; there is no other obvious exit.
  There is a small mushroom (?) growing on the wall.

What Now? GET MUSHROOM  <-- One last time!

You pluck the mushroom (?) from the wall where it was growing.

What Now? SOUTH

There is a threatening little dwarf in the room with you!

A sharp, nasty knife is thrown at you!

The knife just misses you by inches!

The dwarf blocks your way and will not let you leave!

What Now? KILL DWARF WITH AXE

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? SOUTH

<< At division in passage >>
You are at a division in a narrow passage.  Two spurs run east and north; the
main passage exits to the south.

What Now? SOUTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTH

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? NORTH

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? PLUGH

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There are several iron keys on the ground here.
  A small velvet pillow lies on the floor.

What Now? TURBO

        >>Foof!<<

<< Programmer's Den >>
You are in a strange room with exits to both the north and south.  Both exits
have curtains draw over them.  The floor is carpeted, the walls are rubber, the
room is strewn with papers, listings, books, and half-empty JOLT Cola bottles.
The cryptic anagram "D + A = L" is inscribed throughout the room.  The south
wall is almost covered by a large color centerfold of a naked supercomputer.
A sign on the wall says,

                "PROGRAMMER'S DEN"

The software wizard is nowhere to be seen.

There are many computers here: micros, minis, maxis and megas.

What Now? SOUTH

<< Soft room >>
You are in the soft room.  The walls are covered with heavy curtains, the
floor with a thick pile carpet.  Moss covers the ceiling.
  You see a carpet of moss here.

What Now? WEST

<< Swiss cheese room >>
You are in a room whose walls resemble swiss cheese.  Obvious passages go
west, east, northeast, and northwest.  Part of the room is occupied by a large
bedrock block.

What Now? WEST

<< E end of twopit room >>
You are at the east end of the twopit room.  The floor here is littered with
thin rock slabs, which make it easy to descend the pits.  There is a path here
bypassing the pits to connect passages from east and west.  There are holes
all over, but the only big one is on the wall directly over the west pit where
you can't get at it.

What Now? WEST

<< W end of twopit room >>
You are at the west end of the twopit room.  There is a large hole in the wall
above the pit at this end of the room.

What Now? DOWN

<< West pit >>
You are at the bottom of the western pit in the twopit room.  There is a large
hole in the wall about 25 feet above you.
  There is a gigantic beanstalk stretching all the way up to the hole.

What Now? CLIMB PLANT

You climb up the beanstalk and scurry through the hole in the ceiling of the
cavern.  
<< Long narrow corridor >>
You are in a long, narrow corridor stretching out of sight to the west.  At
the eastern end is a hole through which you can see a profusion of leaves,
  There is a huge beanstalk growing out of the west pit up to the hole.

What Now? WEST

<< Giant room >>
You are in the giant room.  The ceiling is too high up for your lamp to show
it.  Cavernous passages lead east, north, and south.  On the west wall is
scrawled the inscription:
               Fee
               Fie
               Foe
               Foo  {sic}

What Now? FEE

Nothing happens.

What Now? FIE

Nothing happens.

What Now? FOE

Nothing happens.

What Now? FOO

As you finish speaking the magic phrase, you feel a slight earth tremor.  Then
after a moment of silence, a strange voice echoes through the cave -- "They
have been returned to their rightful place!"

Your score just increase by 15 to 800.

<-- The "they" in the above message refers to the golden eggs.  So now, all
    you have to do is figure out where their rightful place is to recover
    them.

What Now? NORTH

<< End of immense passage >>
You are at one end of an immense north/south passage.
  The way north leads through an open massive, rusty, iron door.
  There is a small empty bottle here.

What Now? NORTH

<< Cavern with waterfall >>
You are in a magnificent cavern with a rushing stream, which cascades over a
sparkling waterfall into a roaring whirlpool which disappears through a hole
in the floor.  Passages exit to the south and west.

What Now? EAT MUSHROOM  <-- You will need a lot of strength to survive the
                            next move and still keep all the items you are
                            carrying and wearing.

As you swallow the mushroom your mouth becomes numb, and everything seems to
swirl around you.  The effect quickly passes, and you find that your muscles
have bulged unbelievably.

What Now? DOWN

Into the whirlpool??
Please answer Yes or No: YES

You plunge into the water and are sucked down by the whirlpool.
The swirling waters deposit you, not ungently, on solid ground.

<< Northern end of the reservoir >>
You are at the northern end of a large underground reservoir.  Across the
water to the south, a dark passage is visible.  Another passage leads north
from here.  Large, clawed tracks are visible in the damp ground, leading from
the passage into the water.
  There is a large brass gong fastened to the wall here.

Your score just increase by 15 to 815.

What Now? NORTH

<< Small, warm chamber >>
You are in a small chamber with warm walls.  Mist drifts into the chamber from
a passage entering from the south and evaporates in the heat.  Another passage
leads out to the northeast.

What Now? NORTHEAST

<< On a high balcony >>
You are in a high balcony carved out of solid rock overlooking a large, bare
chamber lit by dozens of flickering torches.  A rushing stream pours into the
chamber through a two-foot slit in the east wall and drains into a large pool
along the north side of the chamber.  A small plaque riveted to the edge of
the balcony reads, "You are looking at the Witt Company's main treasure room,
constructed by the famous architect Ralph Witt in 1965 A. D., and dedicated to
the proposition that all adventurers are created equal (although some are more
equal than others).  NO ADMITTANCE VIA THIS ENTRANCE!"  A small, dark tunnel
leads out to the west.
  You see a 5 1/4 inch floppy disk here.
  There is a string of ancient Indian turquoise beads here!

What Now? GET ALL

You are now carrying the floppy disk.
You are now carrying the turquoise beads.

Your score just increase by 30 to 845.

What Now? WEST

<< Small, warm chamber >>
You are in a small chamber with warm walls.  Mist drifts into the chamber from
a passage entering from the south and evaporates in the heat.  Another passage
leads out to the northeast.

What Now? SOUTH

<< Northern end of the reservoir >>
You are at the northern end of a large underground reservoir.  Across the
water to the south, a dark passage is visible.  Another passage leads north
from here.  Large, clawed tracks are visible in the damp ground, leading from
the passage into the water.
  There is a large brass gong fastened to the wall here.

What Now? EXAMINE GONG

The gong has a small sign on it that says "Ring Me!"

What Now? RING IT

        >BONNNNNGGGGGGGGG<

A hollow voice says, "The GallopingGhost Tortoise Express is now at your
service!"

With a swoosh and a swirl of water, a large tortoise rises to the surface of
the reservoir and paddles over to the shore near you.  The message, "I'm
Darwin - ride me!" is inscribed on his back in ornate letters.

        >BONNNNGGGGGGGGGG<

Darwin the Tortoise blinks in surprise at the noise, but does nothing.

What Now? RIDE DARWIN

You step gently on Darwin the Tortoise's back, and he carries you smoothly
over to the southern side of the reservoir.  He then blows a couple of bubbles
at you and sinks back out of sight.

<< Southern edge of reservoir >>
You are on the southern edge of a large underground reservoir.  A thick cloud
of white mist fills the room, rising from the surface of the water and
drifting rapidly upwards.  The lake is fed by a stream, which tumbles out of a
hole in the wall about 10 feet overhead and splashes noisily into the water
near the reservoir's northern wall.  A dimly-seen passage exits through the
northern wall, but you can't get across the water to get to it.  Another
passage leads south from here.

What Now? SOUTH

<< Mirror canyon >>
You are in a north/south canyon about 25 feet across.  The floor is covered by
white mist seeping in from the north.  The walls extend upward for well over
100 feet.  Suspended from some unseen point far above you, an enormous two-
sided mirror is hanging parallel to and midway between the canyon walls.  (The
mirror is obviously provided for the use of the dwarves, who as you know, are
extremely vain.)  A small window can be seen in either wall, some fifty feet
up.      
  You see a shiny mirror here.

What Now? SOUTH

<< North-south canyon >>
You are in a secret north-south canyon above a large room.

What Now? SOUTH

<< Secret canyon >>
You are in a secret canyon which exits to the north and east.
  The body of a huge green dead dragon is lying off to one side.

What Now? EAST

There are faint rustling noises from the darkness behind you.

There is a threatening little dwarf in the room with you!

A sharp, nasty knife is thrown at you!

The knife just misses you by inches!

A strange malaise suddenly afflicts you.  You shiver with chill, and your
muscles seem to turn to putty; everything around you becomes gray and unreal.
The fit quickly passes, and you find that your body has degenerated back to
what it was like before you ate the mushroom.

The dwarf blocks your way and will not let you leave!

What Now? EAST

The dwarf blocks your way and will not let you leave!

What Now? KILL DWARF WITH AXE

A sharp, nasty knife is thrown at you!

The knife bounces harmlessly off your magic cloak.

You killed a little Dwarf.  The body vanished in a cloud of greasy black
smoke.   

What Now? EAST

<< Secret E-W canyon >>
You are in a secret canyon which here runs east-west.  It crosses over a very
tight canyon 15 feet below.  If you go down you may not be able to get back
up.      

What Now? EAST

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTH

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? NORTH

There are faint rustling noises from the darkness behind you.

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? PLUGH

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There are several iron keys on the ground here.
  A small velvet pillow lies on the floor.

What Now? DROP BEADS

As you drop the treasure, a voice booms out: "Well done!  You have collected
33 treasure(s) so far out of a total of 37."

As the beads hits the floor, it disappears in a puff of blue smoke!

What Now? GET CARD

You are now carrying the plastic card.

What Now? DOWN

You climb down the steep stairway in the safe.

<< Southern end of long hall >>
You are at the southern end of a long hall.  A stairway leads up into the
darkness.  There is a curtain over the open doorway to the south.  The door to
the north is closed.  It is made of thick steel and looks like it could
survive a nuclear blast.
  Next to the steel door is a small slot.

What Now? INSERT CARD IN SLOT

You insert the card into the slot.  A very loud buzzing sound comes from the
door and then the door swings open and you enter the room to find ...

<< Computer Center >>
You are in a large computer center with a raised floor and recessed lights in
the ceiling.  Large mainframes are everywhere.  There are exits to the north
and south.  There is a sign on the east wall.
  There are a pair of suction cups here.
  There is a hole in the floor where one of the tiles has been removed.
  An ancient IBM PC-XT is on a small table in the corner.

What Now? INSERT DISK

You insert the disk in drive A: of the PC and list the directory.  You see a
file named READ.ME.  You decide to see what it says by typing the COMMAND
"TYPE READ.ME".  The screen shows...

************* CONGRATULATIONS ***************
You just got ten points added to your score!!

This game was created using the Adventure Game Toolkit.

A BRIEF OVERVIEW OF THE ADVENTURE GAME TOOLKIT, etc., etc.

Your score just increase by 10 to 855.

What Now? SOUTH

<< Southern end of long hall >>
You are at the southern end of a long hall.  A stairway leads up into the
darkness.  There is a curtain over the open doorway to the south.  The door to
the north is closed.  It is made of thick steel and looks like it could
survive a nuclear blast.
  Next to the steel door is a small slot.

What Now? UP

You climb up the stairs and enter the room above through the open safe door.

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  A small velvet pillow lies on the floor.

What Now? EXIT

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  You see some gray ashes.
  Next to the door of the building, there is a faded sign.

What Now? NORTH

It is a full moon tonight and you can see quite clearly even though it is night
time.    

<< Forest >>
You are in open forest near both a valley and a road.

What Now? NORTH

<< Thick woods >>
You are in the midst of a thick woods.  The ground is damp with dew.  The air
is chilly and you shiver from the cold.  The only path leads south -- back the
way you came.
  There are large trees here.
  There are a lot of leaves on the ground all around you.

What Now? CHOP DOWN TREE  <-- You must have the axe to do this!

Timber!  

Your score just increase by 10 to 865.

What Now? LOOK

<< Thick woods >>
You are in the midst of a thick woods.  The ground is damp with dew.  The air
is chilly and you shiver from the cold.  The only path leads south -- back the
way you came.
  There are a lot of leaves on the ground all around you.
  There is large fallen tree here.  It was cut down recently.
    There is a large nest here, full of golden eggs! (in the tree)

<-- Where else would you expect to find a nest of eggs, but in a tree???

What Now? GET EGGS

You are now carrying the golden eggs.

Your score just increase by 15 to 880.

What Now? SOUTH

<< Forest >>
You are in open forest, with a deep valley to one side.

What Now? SOUTH

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  You see some gray ashes.
  Next to the door of the building, there is a faded sign.

What Now? ENTER

It is a full moon tonight and you can see quite clearly even though it is night
time.    

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There are several iron keys on the ground here.
  A small velvet pillow lies on the floor.

What Now? DROP EGGS

As you drop the treasure, a voice booms out: "Well done!  You have collected
34 treasure(s) so far out of a total of 37."

As the eggs hits the floor, it disappears in a puff of blue smoke!

What Now? DROP DISK

As you drop the treasure, a voice booms out: "Well done!  You have collected
35 treasure(s) so far out of a total of 37."

As the disk hits the floor, it disappears in a puff of blue smoke!

What Now? DROP CARD  <-- Wont need again.

You drop the plastic card.


< ----------------  CAMPAIGN 8 -- The End-Game ------------------------------>

What Now? PLUGH

        >>Foof!<<

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? EAST

<< Jumble of rock >>
You are in a jumble of rock, with cracks everywhere.

What Now? UP

There are faint rustling noises from the darkness behind you.

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

What Now? WEST

<< East bank of fissure >>
You are on the east bank of a fissure slicing clear across the hall.  The mist
is quite thick here, and the fissure is too wide to jump.
  You see a book entitled "Adventure Guidebook".
  A crystal bridge now spans the fissure.

What Now? WEST

From somewhere in the distance, there comes a musical skirl of light, elvish
laughter and the sounds of merriment.

<< West side of fissure >>
You are on the west side of the fissure in the hall of mists.
  A crystal bridge spans the fissure.

What Now? WEST

<< W end - hall of mists >>
You are at the west end of hall of mists.  A low wide crawl continues west and
another goes north.  To the south is a little passage 6 feet off the floor.

What Now? SOUTH

<-- You are now entering the "pirate's maze."

<< Twisty little passage >>
You are in a maze of twisty little passages, all alike.

What Now? UP

<< Twisty little passage >>
You are in a maze of twisty little passages, all alike.

What Now? UP

<< Pirate's Den >>
You are in the Pirate's den.  It is very messy and smells awful.  There is a
black Jolly Rodger flag hanging from the ceiling -- too high to reach.  There
are exits leading east, west, south, north, up and down.
  There is a large sparkling nugget of gold here!
  The pirate's treasure chest is here!

What Now? GET ALL

You are now carrying the gold nugget.
You are now carrying the treasure chest.

Your score just increase by 30 to 910.

What Now? NORTH

<< Brink of pit >>
You are on the brink of a thirty foot pit with a massive orange column down
one wall.  You could climb down here but you could not get back up.  The maze
continues at this level.

What Now? DOWN

There are faint rustling noises from the darkness behind you.

<< Bird chamber >>
You are in a splendid chamber thirty feet high.  The walls are frozen rivers
of orange stone.  An awkward canyon and a good passage exit from east and west
sides of the chamber.

What Now? EAST

<< Awkward canyon >>
You are in an awkward sloping east/west canyon.

What Now? EAST

<< Debris room >>
You are in a debris room filled with stuff washed in from the surface.  A low
wide passage with cobbles becomes plugged with mud and debris here, but an
awkward canyon leads upward and west.  A note on the wall says:
       Magic Word "XYZZY"

What Now? XYZZY

        >>Foof!<<

<< Inside building >>
You are inside a small building, a well house for a large spring.  The stream
bubbles up out of the ground and flows out the side of the building through a
pair of 1 foot diameter sewer pipes.  The word "THURB" has been painted on one
of the pipes.  There is a doorway in the middle of the north wall.  A huge
steel safe has been installed into the brick wall on the east wall.
  The safe's door is wide open!
    A stone stairway leads down. (in the safe)
  A large grandfather clock stands against the wall.
  A nice heavy parka is here.
    There is a pocket on the right side of the parka. (in the parka)
    And, strangely enough, a pocket on the left side also. (in the parka)
  There is a diary here.  It is quite old.
  There are some old, ugly, dirty tennis shoes here.
  A Boy-Scout compass is lying nearby.
  There is a small plastic card here!
  There are several iron keys on the ground here.
  A small velvet pillow lies on the floor.

What Now? DROP NUGGET

As you drop the treasure, a voice booms out: "Well done!  You have collected
36 treasure(s) so far out of a total of 37."

As the nugget hits the floor, it disappears in a puff of blue smoke!

What Now? DROP CHEST  <-- This should be the last treasure!

As you drop the last treasure, a booming voice says: "You have now completed
your quest for treasure!"

However, because this voice is so amazingly loud, it starts an earthquake.
A crack opens up in the earth, and you fall down .... down ....

<< Nugget of gold room >>
This is a low room with a crude note on the wall.  The note says:
       You won't get it up the steps.

What Now? NORTH

A sepulchral voice reverberating through the cave says: "Cave closing soon.
All adventurers exit immediately through main office."

<< Hall of mists >>
You are at one end of a vast hall stretching forward out of sight to the west,
filled with wisps of white mist that sway to and fro almost as if alive.
Rough stone steps lead up to a passage at the top of a dome above you.  A wide
staircase runs downward into the darkness; a chill wind blows up from below.
There are small passages to the north and south, and a small crack leads east.
  Rough stone steps lead up to the dome.

Your score just increase by 40 to 950.

<-- You just need to wait until closing time.  Any commands will be OK now.

What Now? NORTH

<< Hall of Mt. King >>
You are in the hall of the mountain king, with passages off in all directions.
  There is a small wicker cage discarded nearby.
  A cheerful little bird is sitting here singing.

What Now? NORTH

There are faint rustling noises from the darkness behind you.

The cave will close in 8 turns!  <-- You just need to wait until closing time.

<< Low N-S passage >>
You are in a low north-south passage at a hole in the floor.  The hole goes
down to an east-west passage.

What Now? WEST <-- You just need to wait until closing time.

The cave will close in 7 turns!

You can't go west from here!

What Now? NORTH

The cave will close in 6 turns!

<< "Y2" >>
You are in a large room, with a passage to the south, a passage to the west,
and a wall of broken rock to the east.  There is a large "Y2" on a rock in the
room's center.

What Now? EAST

The cave will close in 5 turns!

<< Jumble of rock >>
You are in a jumble of rock, with cracks everywhere.

What Now? NORTH

The cave will close in 4 turns!

You can't go north from here!

What Now? SOUTH

The cave will close in 3 turns!

You can't go south from here!

What Now? EAST

The cave will close in 2 turns!

You can't go east from here!

What Now? SOUTH

The cave will close in 1 turns!

You can't go south from here!

What Now? NORTH

The sepulchral voice entones, "The cave is now closed."  As the echoes fade,
there is a blinding flash of light (and a small puff of orange smoke).  . . .

As your eyes refocus you look around and find...

<< Cylindrical chamber >>
You are in a small cylindrical room with very smooth walls and a flat floor
and ceiling -- high above your head.  There is a grate in the ceiling; but it
is out of reach.  Other than the grate, there are no exits visible anywhere.

Your score just increase by 20 to 970.

<-- Remember the Djinn's hint that Ralph Witt didn't like having a name at the
    end of the alphabet -- i.e., he wished he could reverse the alphabetical
    order of things.  OK -- the last puzzle is to say the secret words in
    reverse alphabetical order, i.e., ZORTON, XYZZY, etc.

What Now? ZORTON

Strange!  Nothing happened.  At least, nothing obvious happened.

What Now? XYZZY <-- Enough already!  I'll trust you for the rest of the words.

        >>Foof!<<

<< End of road >>
You are standing at the end of a road before a small brick building.  Around
you is a forest.  A small stream flows out of the building and down a gully to
the south.
  You see some gray ashes.
  Next to the door of the building, there is a faded sign.

What Now? SOUTH

<< Valley >>
You are in a valley in the forest beside a stream tumbling along a rocky bed.

What Now? SOUTH

<< Slit in streambed >>
At your feet all the water of the stream splashes into a 2-foot slit in the
rock.  Downstream the streambed is bare rock.

<-- Notice that it is now a "2-foot" slit, whereas it had been a "2-inch" slit
    before.  Perhaps, we can investigate further by going down.

What Now? DOWN

<< Treasure room >>
You plunge into the stream and are carried down into total blackness.

       Deeper
              and
                  deeper
                         you
                             go,
                                 down
                                      into
                                       the
                                    very
                                 bowels
                             of
                        the
                  earth,
              until
           your
               lungs
                     are
                        aching
                              with
                                   the
                                       need
                                             for
                                                fresh
                                                   air.
                                                      Suddenly,
                                                     with
                                                   a
                                                violent
                                                      >splash!!<

you find yourself sitting on the edge of a pool of water in a vast chamber lit
by dozens of flaring torches.

The floor is covered with thick layers of precious Persian rugs!

Rare coins, bars of silver, and lumps of gold and platinum are strewn
carelessly about!

There are diamonds, rubies, sapphires, emeralds, opals, pearls, and fabulous
sculptures and ornaments carved out of jade and imperishable crystal resting
on display shelves, along with rare Ming vases and ancient Indian turquoise
beads!   

A flotilla of ruby-encrusted toy boats is floating in the pool of water beside
you!     

A network of golden chains supports a fantastic Iridium crown!

There is a display case on the wall filled with a fantastic selection of
magical swords, which are singing "Hail to the Chief" in perfect pitch and
rhythm!  

There are a dozen friendly little dwarves in the room, displaying their
talents by deftly juggling hundreds of golden eggs!

A large troll, a gigantic ogre, and a bearded pirate are tossing knives, axes,
and clubs back and forth in a friendly demonstration of martial skill!

A horde of cheerful little gooseberry goblins are performing talented
acrobatics to an appreciative audience composed of a dragon, a large green
snake, a cute little bird (which is sitting, unmolested, on the snake's head),
a peaceful basilisk, and a large Arabian Djinn.

Everyone turns and sees you, and lets out a heart-warming cheer of welcome!

*** Congratulations. You have won the game. ***

You have seen 208 locations (out of 298), in 956 turns.
Your score is 1000 out of a possible 1000 points.
(This game was saved 0 times and restored 0 times.)



