#include <bios.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

char option[4], keys[5];
int numoptions;
static int htot, hstr, vtot, vstr;

main()
{
	union REGS Regs;
	int i, j, k, optionum;
	char ch, col;

	numoptions = 4;
	loadsetup();
	drawoptions();
	optionum = 0;
	while (ch != 27)
	{
		for(i=0;i<numoptions;i++)
		{
			if (i == optionum)
				col = 75;
			else
				col = 67;
			if (i == 0)
			{
				if (option[i] == 0)
					printstr(25,3,"320 * 200 * 256 resolution screen",col);
				if (option[i] == 1)
					printstr(25,3,"360 * 240 * 256 resolution screen",col);
				if (option[i] == 2)
					printstr(25,3,"640 * 400 * 256 resolution screen",col);
			}
			if (i == 1)
			{
				if (option[i] == 0)
					printstr(25,4,"PC speaker sound effects         ",col);
				if (option[i] == 1)
					printstr(25,4,"MIDI - MPU-401 + Casiotone CT-640",col);
			}
			if (i == 2)
			{
				if (option[i] == 0)
					printstr(25,5,"Keyboard controls                ",col);
				if (option[i] == 1)
					printstr(25,5,"Microsoft-compatible mouse       ",col);
			}
			if (i == 3)
			{
				if (option[i] == 0)
					printstr(25,6,"No background music              ",col);
				if (option[i] == 1)
					printstr(25,6,"Adlib background music           ",col);
			}
		}
		ch = getch();
		if (ch == 0)
		{
			ch = getch();
			if ((ch == 72) && (optionum > 0))
				optionum--;
			if ((ch == 80) && (optionum < numoptions-1))
				optionum++;
			if ((ch == 75) && (option[optionum] > 0))
				option[optionum]--;
			if ((ch == 77) && ((option[optionum] < 1) || ((optionum == 0) && (option[optionum] == 1))))
				option[optionum]++;
			ch = 0;
		}
		if ((ch == 'k') || (ch == 'K'))
		{
			printstr(20,17,"Press a key to move you LEFT. ",79);
			Regs.h.ah = 0; int86(0x16,&Regs,&Regs); keys[0] = Regs.h.ah;
			if (Regs.h.al == 0)
				keys[0]+=128;
			printstr(20,17,"Press a key to move you RIGHT.",79);
			Regs.h.ah = 0; int86(0x16,&Regs,&Regs); keys[1] = Regs.h.ah;
			if (Regs.h.al == 0)
				keys[1]+=128;
			printstr(20,17,"Press a key to make you JUMP. ",79);
			Regs.h.ah = 0; int86(0x16,&Regs,&Regs); keys[2] = Regs.h.ah;
			if (Regs.h.al == 0)
				keys[2]+=128;
			printstr(20,17,"Press a key to make you FIRE. ",79);
			Regs.h.ah = 0; int86(0x16,&Regs,&Regs); keys[3] = Regs.h.ah;
			if (Regs.h.al == 0)
				keys[3]+=128;
			printstr(20,17,"Press a key to QUIT the game. ",79);
			Regs.h.ah = 0; int86(0x16,&Regs,&Regs); keys[4] = Regs.h.ah;
			if (Regs.h.al == 0)
				keys[4]+=128;
			printstr(20,17,"                              ",79);
		}
		if (ch == 13)
			savesetup();
	}
	_asm \
	{
		mov ax, 0x3
		int 0x10
	}
}

loadsetup()
{
	int fil, i, j;

	if ((fil = open("setup.dat",O_BINARY|O_RDWR,S_IREAD)) == -1)
	{
		printf("Cannot load setup.dat");
		exit(0);
	}
	read(fil,&option[0],numoptions);
	read(fil,&keys[0],5);
	read(fil,&htot,2);
	read(fil,&hstr,2);
	read(fil,&vtot,2);
	read(fil,&vstr,2);
	close(fil);
}

savesetup()
{
	int fil, i, j;

	if ((fil = open("setup.dat",O_BINARY|O_RDWR,S_IWRITE)) == -1)
	{
		printf("Cannot save setup.dat");
		exit(0);
	}
	write(fil,&option[0],numoptions);
	write(fil,&keys[0],5);
	write(fil,&htot,2);
	write(fil,&hstr,2);
	write(fil,&vtot,2);
	write(fil,&vstr,2);
	close(fil);
}

printchr(x,y,character,attribute,len)
int x, y, len;
char character, attribute;
{
	int pos;

	pos = (y*80+x)<<1;
	_asm \
	{
		mov ax, 0xb800
		mov es, ax
		mov di, pos
		mov al, character
		mov ah, attribute
		mov cx, len
		cld
		rep stosw
	}
}

printstr(x,y,string,attribute)
int x, y;
char string[81], attribute;
{
	char character;
	int i, pos;

	pos = (y*80+x)<<1;
	i = 0;
	while (string[i] != 0)
	{
		character = string[i];
		_asm \
		{
			mov ax, 0xb800
			mov es, ax
			mov di, pos
			mov al, character
			mov ah, attribute
			stosw
		}
		i++;
		pos+=2;
	}
}

setmode360240()
{
	int i;

	outp(0x3d4,0x11); outp(0x3d5,inp(0x3d5)&127);       //Unlock indeces 0-7
	outp(0x3d4,0x3); outp(0x3d5,inp(0x3d5)|128);        //Unlock V. retraces
	outp(0x3d4,0x0); outp(0x3d5,htot&255);
	outp(0x3d4,0x1); outp(0x3d5,90);
	outp(0x3d4,0x2); outp(0x3d5,89);
	outp(0x3d4,0x3); outp(0x3d5,inp(0x3d5)|26);
	outp(0x3d4,0x4); outp(0x3d5,hstr&255);
	outp(0x3d4,0x5); outp(0x3d5,inp(0x3d5)&127);
	outp(0x3d4,0x6); outp(0x3d5,vtot&255);
	outp(0x3d4,0x7);
	i = ((inp(0x3d5)&82)|8);
	i |= ((vstr&512)>>2);
	i |= ((vstr&256)>>6);
	i |= ((vtot&512)>>4);
	i |= ((vtot&256)>>8);
	outp(0x3d5,i);
	outp(0x3d4,0x9); outp(0x3d5,inp(0x3d5)&223);
	outp(0x3d4,0x12); outp(0x3d5,224);
	outp(0x3d4,0x15); outp(0x3d5,223);
	outp(0x3d4,0x16); outp(0x3d5,inp(0x3d5)|96);
	outp(0x3d4,0x10); outp(0x3d5,vstr&255);
	outp(0x3d4,0x3); outp(0x3d5,inp(0x3d5)&127);        //Relock V. retraces
	outp(0x3d4,0x11); outp(0x3d5,inp(0x3d5)|128);       //Relock indeces 0-7
}

drawoptions()
{
	int i;

	_asm \
	{
		mov ax, 0x3
		int 0x10
	}
	outp(0x3d4,0x0e); outp(0x3d5,255);
	printchr(0,0,218,78,1);
	printchr(1,0,196,78,78);
	printchr(79,0,191,78,1);
	for(i=1;i<24;i++)
	{
		printchr(0,i,179,78,1);
		printchr(1,i,32,78,78);
		printchr(79,i,179,78,1);
	}
	printchr(0,24,192,78,1);
	printchr(1,24,196,78,78);
	printchr(79,24,217,78,1);
	printstr(29,1,"Super Silverbros Setup",79);
	printstr(2,3,"1) Graphics screen  -",77);
	printstr(2,4,"2) Sound board      -",77);
	printstr(2,5,"3) Input device     -",77);
	printstr(2,6,"4) Adlib music      -",77);
	printstr(20,19,"To define own keys, press K.",71);
	printstr(20,20,"Press UP/DOWN arrows to select option.",71);
	printstr(20,21,"Press LEFT/RIGHT arrows to change option.",71);
	printstr(20,22,"Press ENTER to save current setup.",71);
	printstr(20,23,"Press ESC to exit.",71);
}
