	//SIBROS.C was: 34,645 07-17-93 12:38p until 1999 (fixed panning code)
	//Compile like this: cl /AC sibros.c
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include <string.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>

//sprite:16384
//board:900
//pal:768
//note:16384
//inst:8192
//databuf:1024
//tempbuf:1024

union REGS Regs;
static unsigned char sprite[64][16][16], board[45][20], pal[768];
static int spotx[90], spoty[90];
static int pass[64] =
{
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
unsigned char readch, oldreadch, keystatus[256], extended;
unsigned char option[4], keys[5];
int firstx, firsty, mx, my, xvel, yvel, oldmx, oldmy;
int monstx[8],monsty[8],monstxvel[8],monstyvel[8],oldmonstx[8],oldmonsty[8];
int firex[8],firey[8],firexvel[8],fireyvel[8],oldfirex[8],oldfirey[8];
int firecount[8], countfire, waitfire, firewait;
int boardnum, canyoujump, page, lives, coins, lastxmove;
int plcx, plcy, death, numonsters, mousx, mousy, bstatus, numfire;
int videomode, midi, inputdevice;
time_t tnow;
void interrupt far keyhandler(void);
void (interrupt far *oldkeyhandler)();

unsigned long musicstatus = 0, count, countstop, nownote;
unsigned int numnotes, speed = 240, drumstat, numchans, firstime = 1;
static unsigned long note[4096], chanage[18];
static unsigned char inst[256][32], databuf[1024];
static unsigned char chanfreq[18], chantrack[18];
static unsigned char trinst[16], trquant[16], trchan[16];
static unsigned char trprio[16], trvol[16];
static unsigned int adlibfreq[63] =
{
	0,
	2390,2411,2434,2456,2480,2506,2533,2562,2592,2625,2659,2695,
	3414,3435,3458,3480,3504,3530,3557,3586,3616,3649,3683,3719,
	4438,4459,4482,4504,4528,4554,4581,4610,4640,4673,4707,4743,
	5462,5483,5506,5528,5552,5578,5605,5634,5664,5697,5731,5767,
	6486,6507,6530,6552,6576,6602,6629,6658,6688,6721,6755,6791,
	7510
};
void interrupt far ksmhandler(void);
void (interrupt far *oldhand)();


static int capturecount = 0;
static char tempbuf[1024];
static char pcxheader[128] =
{
	10,5,1,8,0,0,0,0,63,1,199,0,64,1,200,0,
	0,0,0,8,8,8,16,16,16,24,24,24,32,32,32,40,40,40,48,48,48,56,56,56,64,64,64,
	72,72,72,80,80,80,88,88,88,96,96,96,104,104,104,112,112,112,120,120,120,
	0,1,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

main(int argc,char **argv)
{
	unsigned char ch, snotbuf[16];
	int i, j, k, p[4], px[4], py[4], friction;

	time(&tnow);
	srand((unsigned)tnow);
	loadstuff();
	midi = option[1];
	if (midi == 1)
	{
		midi = 1;
		putcmd(0x3F);
	}
	inputdevice = option[2];
	if (inputdevice == 1)
		inputdevice = setupmouse();
	if (inputdevice == 0)
	{
		oldkeyhandler = _dos_getvect(0x9);
		_disable(); _dos_setvect(0x9, keyhandler); _enable();
	}
	videomode = option[0];
	if (videomode == 0)
		setmode320200();
	if (videomode == 1)
		setmode360240();
	if (videomode == 2)
		setmode640400();
	setupscreen();
	if (option[3] == 1)
	{
		loadmusic("kensong.ksm");
		musicon();
	}
	loadboard(0);
	drawboard();
	fade(1);
	lives = 3;
	coins = 0;
	firewait = -1;
	countfire = 0;
	friction = 0;
	if (midi == 0)
		outp(67,182);
	else
	{
		putdata(0xc0); putdata(14);
		putdata(0xc1); putdata(24);
		putdata(0xc2); putdata(11);
	}
	ch = 0;
	while (((inputdevice == 0) && (keystatus[keys[4]] == 0)) || ((inputdevice == 1) && (ch != 27)))
	{
		oldmx = mx; oldmy = my;
		for(i=0;i<numonsters;i++)
		{
			oldmonstx[i] = monstx[i];
			oldmonsty[i] = monsty[i];
		}
		for(i=0;i<8;i++)
		{
			oldfirex[i] = firex[i];
			oldfirey[i] = firey[i];
		}
		if (death == 1)
			die();
		if (inputdevice == 0)
		{
			bstatus = keystatus[keys[2]] + (keystatus[keys[3]]<<1);
			if (keystatus[keys[1]] == 1)
				mousx += 10+abs(xvel);
			if (keystatus[keys[0]] == 1)
				mousx -= 10+abs(xvel);
			if (keystatus[0x58])  //F12
			{
				keystatus[0x58] = 0;
				strcpy(snotbuf,"SIBR0000.PCX");
				snotbuf[4] = ((capturecount/1000)%10)+48;
				snotbuf[5] = ((capturecount/100)%10)+48;
				snotbuf[6] = ((capturecount/10)%10)+48;
				snotbuf[7] = (capturecount%10)+48;
				if (videomode == 0) { i = 320; j = 200; k = ((375+1)>>1); }
				if (videomode == 1) { i = 360; j = 240; k = ((455+1)>>1); }
				if (videomode == 2) { i = 640; j = 400; k = ((387+1)>>1); }
				if (screencapturemodex(snotbuf,(((long)plcy+44L)*720L)+((long)plcx),k,i,j,720) == 0)
					capturecount++;
			}
		}
		if (inputdevice == 1)
		{
			if (kbhit() != 0)
			{
				ch = getch();
				if (ch == 0)
				{
					ch = getch();
					if (ch == 134) //F12
					{
						strcpy(snotbuf,"SIBR0000.PCX");
						snotbuf[4] = ((capturecount/1000)%10)+48;
						snotbuf[5] = ((capturecount/100)%10)+48;
						snotbuf[6] = ((capturecount/10)%10)+48;
						snotbuf[7] = (capturecount%10)+48;
						if (videomode == 0) { i = 320; j = 200; k = ((375+1)>>1); }
						if (videomode == 1) { i = 360; j = 240; k = ((455+1)>>1); }
						if (videomode == 2) { i = 640; j = 400; k = ((387+1)>>1); }
						if (screencapturemodex(snotbuf,(((long)plcy+44L)*720L)+((long)plcx),k,i,j,720) == 0)
							capturecount++;
					}
				}
			}
			Regs.x.ax = 5; int86(0x33,&Regs,&Regs); bstatus = Regs.x.ax;
			Regs.x.ax = 11; int86(0x33,&Regs,&Regs); mousx += Regs.x.cx;
		}
		if (mousx < -16)
		{
			xvel--;
			mousx+=16;
		}
		if (mousx > 16)
		{
			xvel++;
			mousx-=16;
		}
		if (((bstatus&1) != 0) && (canyoujump == 1))
		{
			yvel-=1;
			if (yvel < -6)
				canyoujump = 0;
		}
		else
			canyoujump = 0;
		if (page == 0)
			yvel++;
		if (xvel < -7)
			xvel = -7;
		if (xvel > 7)
			xvel = 7;
		if (yvel < -15)
			yvel = -15;
		if (yvel > 15)
			yvel = 15;
		mx += xvel;
		my += yvel;
		if (xvel > 0)
			lastxmove = 1;
		if (xvel < 0)
			lastxmove = -1;
		p[0] = pass[board[mx>>4][my>>4]];
		p[1] = pass[board[(mx+8)>>4][my>>4]];
		p[2] = pass[board[mx>>4][(my+15)>>4]];
		p[3] = pass[board[(mx+8)>>4][(my+15)>>4]];
		if ((yvel<0) && (((p[0]!=0)&&(p[2]==0))||((p[1]!=0)&&(p[3]==0))))
		{
			if (midi == 1)
			{
				putdata(0x90); putdata(82); putdata(1);
			}
			my = (my ^ (my & 15)) + 16;
			yvel = (-yvel)>>2;
			canyoujump = 0;
			friction = 1;
		}
		else if ((yvel>0) && (((p[2]!=0)&&(p[0]==0))||((p[3]!=0)&&(p[1]==0))))
		{
			my = (my ^ (my & 15));
			yvel = -(yvel>>2);
			canyoujump = 1;
			friction = 1;
		}
		if (my < 0)
		{
			my = 0;
			yvel = (-yvel)>>1;
		}
		p[0] = pass[board[mx>>4][my>>4]];
		p[1] = pass[board[(mx+8)>>4][my>>4]];
		p[2] = pass[board[mx>>4][(my+15)>>4]];
		p[3] = pass[board[(mx+8)>>4][(my+15)>>4]];
		if ((xvel<=0) && (((p[0]!=0)&&(p[1]==0))||((p[2]!=0)&&(p[3]==0))))
		{
			mx = (mx ^ (mx & 15)) + 16;
			xvel = -xvel/4;
			friction = 0;
			mousx = 0;
		}
		else if ((xvel>=0) && (((p[1]!=0)&&(p[0]==0))||((p[3]!=0)&&(p[2]==0))))
		{
			mx = (mx ^ (mx & 15)) + 7;
			xvel = -xvel/4;
			friction = 0;
			mousx = 0;
		}
		if ((friction == 1) && (page == 0))
		{
			if (xvel > 0)
				xvel--;
			if (xvel < 0)
				xvel++;
			friction = 0;
		}
		for(i=0;i<numonsters;i++)
		{
			if (monstxvel[i] == 0)
			{
				if (mx < monstx[i])
					monstxvel[i]--;
				if (mx > monstx[i])
					monstxvel[i]++;
			}
			if (page == 0)
			{
				monstyvel[i]++;
				if (monstyvel[i] > 7)
					monstyvel[i] = 7;
			}
			monstx[i]+=monstxvel[i];
			monsty[i]+=monstyvel[i];
			p[0] = pass[board[monstx[i]>>4][monsty[i]>>4]];
			p[1] = pass[board[(monstx[i]+8)>>4][monsty[i]>>4]];
			p[2] = pass[board[monstx[i]>>4][(monsty[i]+15)>>4]];
			p[3] = pass[board[(monstx[i]+8)>>4][(monsty[i]+15)>>4]];
			if ((monstyvel[i]<0) && (((p[0]!=0)&&(p[2]==0))||((p[1]!=0)&&(p[3]==0))))
			{
				monsty[i] = (monsty[i] ^ (monsty[i] & 15)) + 16;
				monstyvel[i] = (-monstyvel[i])>>2;
			}
			else if ((monstyvel[i]>0) && (((p[2]!=0)&&(p[0]==0))||((p[3]!=0)&&(p[1]==0))))
			{
				monsty[i] = (monsty[i] ^ (monsty[i] & 15));
				monstyvel[i] = -(monstyvel[i]>>2);
			}
			p[0] = pass[board[monstx[i]>>4][monsty[i]>>4]];
			p[1] = pass[board[(monstx[i]+8)>>4][monsty[i]>>4]];
			p[2] = pass[board[monstx[i]>>4][(monsty[i]+15)>>4]];
			p[3] = pass[board[(monstx[i]+8)>>4][(monsty[i]+15)>>4]];
			if ((monstxvel[i]<=0) && (((p[0]!=0)&&(p[1]==0))||((p[2]!=0)&&(p[3]==0))))
			{
				monstx[i] = (monstx[i] ^ (monstx[i] & 15)) + 16;
				monstxvel[i] = -monstxvel[i];
			}
			else if ((monstxvel[i]>=0) && (((p[1]!=0)&&(p[0]==0))||((p[3]!=0)&&(p[2]==0))))
			{
				monstx[i] = (monstx[i] ^ (monstx[i] & 15)) + 7;
				monstxvel[i] = -monstxvel[i];
			}
		}
		for(i=0;i<8;i++)
			if (firexvel[i] != 0)
			{
				firex[i] += firexvel[i];
				firecount[i]--;
				if (firecount[i] == 0)
				{
					firexvel[i] = 0;
					firex[i] = spotx[73+i];
					firey[i] = spoty[73+i]-44;
				}
				if ((abs((mx>>2)-(firex[i]>>2)) < 4) && (abs(my-firey[i]) < 16))
				{
					firexvel[i] = 0;
					firex[i] = spotx[73+i];
					firey[i] = spoty[73+i]-44;
					if (midi == 0)
					{
						outp(97,inp(97)|3);
						outp(66,255);
						outp(66,255);
					}
					else
					{
						putdata(0x90); putdata(53); putdata(0x40);
					}
				}
			}
		if (waitfire > 0)
			waitfire--;
		if (((bstatus&2) != 0) && (waitfire == 0) && (firewait != -1))
		{
			numfire = -1;
			for(i=0;i<8;i++)
				if (firexvel[i] == 0)
					numfire = i;
			if (numfire != -1)
			{
				if (lastxmove == 1)
				{
					firexvel[numfire] = (xvel^(xvel&1))+5;
					firex[numfire] = mx+12;
				}
				else
				{
					firexvel[numfire] = (xvel^(xvel&1))-5;
					firex[numfire] = mx-12;
				}
				fireyvel[numfire] = 0;
				firey[numfire] = my;
				firecount[numfire] = countfire;
				waitfire = firewait;
				if (midi == 0)
				{
					outp(97,inp(97)|3);
					outp(66,0);
					outp(66,2);
				}
				else
				{
					putdata(0x90); putdata(66); putdata(0x40);
				}
			}
		}
		for(i=0;i<numonsters;i++)
		{

			if ((monstx[i] < 0) || (monstx[i] > 707) || (monsty[i] > 305))
			{
				monsty[i] = 0;
				monstx[i] = rand() % 45;
				while (board[monstx[i]][0] != 16)
					monstx[i] = rand() % 45;
				monstx[i] = monstx[i]<<4;
				monstxvel[i] = 0;
				monstyvel[i] = 0;
			}
			for(j=0;j<i;j++)
				if ((abs((monstx[i]>>2)-(monstx[j]>>2)) < 4) && (abs(monsty[i]-monsty[j]) < 16))
				{
					monsty[i] = 0;
					monstx[i] = rand() % 45;
					while (board[monstx[i]][0] != 16)
						monstx[i] = rand() % 45;
					monstx[i] = monstx[i]<<4;
					monstxvel[i] = 0;
					monstyvel[i] = 0;
				}
			for(j=0;j<8;j++)
				if (firexvel[j] != 0)
					if ((abs((monstx[i]>>2)-(firex[j]>>2)) < 4) && (abs(monsty[i]-firey[j]) < 16))
					{
						monsty[i] = 0;
						monstx[i] = rand() % 45;
						while (board[monstx[i]][0] != 16)
							monstx[i] = rand() % 45;
						monstx[i] = monstx[i]<<4;
						monstxvel[i] = 0;
						monstyvel[i] = 0;
						firexvel[j] = 0;
						firex[j] = spotx[73+j];
						firey[j] = spoty[73+j]-44;
						if (midi == 0)
						{
							outp(97,inp(97)|3);
							outp(66,0);
							outp(66,40);
						}
						else
						{
							putdata(0x90); putdata(45); putdata(0x40);
						}
					}
			if ((abs((mx>>2)-(monstx[i]>>2)) < 4) && (abs(my-monsty[i]) < 16))
			{
				copywindow(spotx[65+i],spoty[65+i],oldmonstx[i],oldmonsty[i]+44,12,16);
				if ((yvel > monstyvel[i]) || (my < monsty[i]))
				{
					if (midi == 0)
					{
						outp(97,inp(97)|3);
						outp(66,0);
						outp(66,40);
					}
					else
					{
						putdata(0x90); putdata(45); putdata(0x40);
					}
				}
				else
					death = 1;
				monsty[i] = 0;
				monstx[i] = rand() % 45;
				while (board[monstx[i]][0] != 16)
					monstx[i] = rand() % 45;
				monstx[i] = monstx[i]<<4;
				monstxvel[i] = 0;
				monstyvel[i] = 0;
			}
		}
		for(i=0;i<8;i++)
			if (firexvel[i] != 0)
			{
				if ((firexvel[i] < 0) && ((board[firex[i]>>4][(firey[i]+2)>>4] != 16) || (board[firex[i]>>4][(firey[i]+13)>>4] != 16)))
				{
					firexvel[i] = 0;
					firex[i] = spotx[73+i];
					firey[i] = spoty[73+i]-44;
					if (midi == 0)
					{
						outp(97,inp(97)|3);
						outp(66,255);
						outp(66,255);
					}
					else
					{
						putdata(0x90); putdata(53); putdata(0x40);
					}
				}
				if ((firexvel[i] > 0) && ((board[(firex[i]+11)>>4][(firey[i]+2)>>4] != 16) || (board[(firex[i]+11)>>4][(firey[i]+13)>>4] != 16)))
				{
					firexvel[i] = 0;
					firex[i] = spotx[73+i];
					firey[i] = spoty[73+i]-44;
					if (midi == 0)
					{
						outp(97,inp(97)|3);
						outp(66,255);
						outp(66,255);
					}
					else
					{
						putdata(0x90); putdata(53); putdata(0x40);
					}
				}
				for(j=0;j<i;j++)
					if ((firexvel[j] != 0) && (abs((firex[i]>>2)-(firex[j]>>2)) < 4) && (abs(firey[i]-firey[j]) < 16))
					{
						firexvel[i] = 0;
						firex[i] = spotx[73+i];
						firey[i] = spoty[73+i]-44;
						firexvel[j] = 0;
						firex[j] = spotx[73+j];
						firey[j] = spoty[73+j]-44;
						if (midi == 0)
						{
							outp(97,inp(97)|3);
							outp(66,255);
							outp(66,255);
						}
						else
						{
							putdata(0x90); putdata(53); putdata(0x40);
						}
					}
			}
		px[0] = mx>>4; py[0] = my>>4;
		px[1] = (mx+8)>>4; py[1] = my>>4;
		px[2] = mx>>4; py[2] = (my+15)>>4;
		px[3] = (mx+8)>>4; py[3] = (my+15)>>4;
		for(i=0;i<4;i++)
		{
			p[i] = board[px[i]][py[i]];
			if ((p[i] == 33) || (ch == 'C') || (ch == 'c'))
			{
				ch = 0;
				copywindow(spotx[16],spoty[16],px[i]<<4,(py[i]<<4)+44,16,16);
				board[px[i]][py[i]] = 16;
				if (midi == 0)
				{
					outp(97,inp(97)|3);
					outp(66,0);
					outp(66,10);
				}
				else
				{
					putdata(0x90);
					putdata(83); putdata(0x40);
					putdata(84); putdata(0x40);
				}
				coins++;
				if (coins == 8)
				{
					if (midi == 0)
					{
						outp(66,0);
						outp(66,5);
					}
					else
					{
						putdata(0x90); putdata(75); putdata(0x40);
					}
					lives++;
					coins = 0;
					if (videomode == 0)
						for(i=1;i<9;i++)
							copywindow(192,0,(20-i)<<4,0,16,12);
					if (videomode == 1)
						for(i=1;i<9;i++)
							copywindow(192,0,(22-i)<<4,0,16,12);
					if (videomode == 2)
						for(i=1;i<9;i++)
							copywindow(192,0,(40-i)<<4,0,16,12);
					copywindow(spotx[0],spoty[0],((lives-2)<<4),0,16,12);
				}
				else
				{
					if (videomode == 0)
						copywindow(spotx[33],spoty[33],((20-coins)<<4),0,16,12);
					if (videomode == 1)
						copywindow(spotx[33],spoty[33],((22-coins)<<4),0,16,12);
					if (videomode == 2)
						copywindow(spotx[33],spoty[33],((40-coins)<<4),0,16,12);
				}
			}
			if ((p[i] == 34) || (ch == 'B') || (ch == 'b'))
			{
				ch = 0;
				if (midi == 0)
				{
					outp(97,inp(97)|3);
					outp(66,0);
					outp(66,5);
				}
				else
				{
					putdata(0x90); putdata(73); putdata(0x40);
				}
				fade(0);
				if (midi == 0)
					outp(97,inp(97)|252);
				if (option[3] == 1)
					musicoff();
				loadboard(boardnum+1);
				if (option[3] == 1)
				{
					switch(boardnum&3)
					{
						case 0: loadmusic("kensong.ksm"); break;
						case 1: loadmusic("bassong.ksm"); break;
						case 2: loadmusic("tenosong.ksm"); break;
						case 3: loadmusic("radsong.ksm"); break;
					}
					musicon();
				}
				drawboard();
				fade(1);
				oldmx = mx; oldmy = my;
				for(i=0;i<numonsters;i++)
				{
					oldmonstx[i] = monstx[i];
					oldmonsty[i] = monsty[i];
				}
				for(i=0;i<8;i++)
				{
					oldfirex[i] = firex[i];
					oldfirey[i] = firey[i];
				}
			}
			if ((p[i] == 39) || (p[i] == 42))
				death = 1;
			if ((p[i] == 41) || (ch == 'F') || (ch == 'f'))
			{
				ch = 0;
				copywindow(spotx[16],spoty[16],px[i]<<4,(py[i]<<4)+44,16,16);
				board[px[i]][py[i]] = 16;
				if (midi == 0)
				{
					outp(97,inp(97)|3);
					outp(66,0);
					outp(66,5);
				}
				else
				{
					putdata(0x90); putdata(58); putdata(0x40);
				}
				countfire += 15;
				if (firewait > 6)
					firewait = (firewait>>1);
				if (firewait == -1)
					firewait = 96;
			}
		}
		for(i=0;i<8;i++)
			if ((firex[i] != oldfirex[i]) || (firey[i] != oldfirey[i]))
			{
				copywindow(spotx[73+i],spoty[73+i],oldfirex[i],oldfirey[i]+44,12,16);
				copywindow(firex[i],firey[i]+44,spotx[73+i],spoty[73+i],12,16);
				copywindow(spotx[(firex[i]&3)+8],spoty[(firex[i]&3)+8],firex[i],firey[i]+44,12,16);
			}
		for(i=0;i<numonsters;i++)
		{
			copywindow(spotx[65+i],spoty[65+i],oldmonstx[i],oldmonsty[i]+44,12,16);
			copywindow(monstx[i],monsty[i]+44,spotx[65+i],spoty[65+i],12,16);
			copywindow(spotx[(monstx[i]&3)+4],spoty[(monstx[i]&3)+4],monstx[i],monsty[i]+44,12,16);
		}
		copywindow(spotx[64],spoty[64],oldmx,oldmy+44,12,16);
		copywindow(mx,my+44,spotx[64],spoty[64],12,16);
		copywindow(spotx[mx&3],spoty[mx&3],mx,my+44,12,16);
		if (videomode == 0)
		{
			plcx += ((mx-plcx-160)>>3);
			if (plcx > 400)
				plcx = 400;
			plcy += ((my-plcy-70)>>3);
			if (plcy > 132)
				plcy = 132;
		}
		if (videomode == 1)
		{
			plcx += ((mx-plcx-180)>>3);
			if (plcx > 360)
				plcx = 360;
			plcy += ((my-plcy-90)>>3);
			if (plcy > 92)
				plcy = 92;
		}
		if (videomode == 2)
		{
			plcx += ((mx-plcx-320)>>3);
			if (plcx > 80)
				plcx = 80;
		}
		if (plcx < 0)
			plcx = 0;
		if (plcy < 0)
			plcy = 0;
		startaddress(plcx,plcy+44);
		page = 1 - page;
		if (midi == 0)
			outp(97,inp(97)&252);
	}
	Regs.h.ah = 0; Regs.x.ax = 0x3; int86(0x10,&Regs,&Regs);
	if ((option[3] == 1) || (musicstatus == 1))
		musicoff();
	if (inputdevice == 0)
	{
		_disable(); _dos_setvect(0x9, oldkeyhandler); _enable();
	}
	if (midi == 1)
		putcmd(0xFF);
}

setmode320200()
{
	Regs.h.ah = 0; Regs.x.ax = 0x13; int86(0x10,&Regs,&Regs);
	outp(0x3c4,0x4); outp(0x3c5,inp(0x3c5)&247);
	outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)|64);
	outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)&191);
	outp(0x3d4,0x13); outp(0x3d5,90);
	inp(0x3da); outp(0x3c0,0x30); outp(0x3c0,0x71);
}

setmode360240()
{
	Regs.h.ah = 0; Regs.x.ax = 0x13; int86(0x10,&Regs,&Regs);
	outp(0x3c4,0x4); outp(0x3c5,0x6);
	outp(0x3c4,0x0); outp(0x3c5,0x1);
	outp(0x3c2,0xe7);
	outp(0x3c4,0x0); outp(0x3c5,0x3);
	outp(0x3d4,0x11); outp(0x3d5,inp(0x3d5)&0x7f);      //Unlock indices 0-7
	outp(0x3d4,0x0); outp(0x3d5,0x6b);
	outp(0x3d4,0x1); outp(0x3d5,0x59);
	outp(0x3d4,0x2); outp(0x3d5,0x5a);
	outp(0x3d4,0x3); outp(0x3d5,0x8e);
	outp(0x3d4,0x4); outp(0x3d5,0x5e);
	outp(0x3d4,0x5); outp(0x3d5,0x8a);
	outp(0x3d4,0x6); outp(0x3d5,0xd);
	outp(0x3d4,0x7); outp(0x3d5,0x3e);
	outp(0x3d4,0x9); outp(0x3d5,0x41);
	outp(0x3d4,0x10); outp(0x3d5,0xea);
	outp(0x3d4,0x11); outp(0x3d5,0xac);
	outp(0x3d4,0x12); outp(0x3d5,0xdf);
	outp(0x3d4,0x13); outp(0x3d5,45);
	outp(0x3d4,0x14); outp(0x3d5,0x0);
	outp(0x3d4,0x15); outp(0x3d5,0xe7);
	outp(0x3d4,0x16); outp(0x3d5,0x6);
	outp(0x3d4,0x17); outp(0x3d5,0xe3);

	outp(0x3c4,0x4); outp(0x3c5,inp(0x3c5)&247);
	outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)|64);
	outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)&191);
	outp(0x3d4,0x13); outp(0x3d5,90);
	inp(0x3da); outp(0x3c0,0x30); outp(0x3c0,0x71);
}

setmode640400()
{
	Regs.h.ah = 0; Regs.x.ax = 0x13; int86(0x10,&Regs,&Regs);
	outp(0x3c4,0x4); outp(0x3c5,inp(0x3c5)&(255-8));    //Chain 4 off
	outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)|64);        //Word Mode
	outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)&(255-64));  //Double Word Mode
	outp(0x3d4,0x9); outp(0x3d5,inp(0x3d5)&(255-1));    //?
	outp(0x3d4,0x13); outp(0x3d5,90);                   //?
	outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)|32);        //?
	outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)|8);         //?
	outp(0x3d4,0x11); outp(0x3d5,inp(0x3d5)&(255-128)); //Unlock indeces 0-7
	outp(0x3d4,21); outp(0x3d5,63);                     //V. Start Blank
	outp(0x3d4,22); outp(0x3d5,131);                    //V. End Blank
	outp(0x3d4,0x11); outp(0x3d5,inp(0x3d5)|128);       //Relock indeces 0-7
	inp(0x3da); outp(0x3c0,0x30); outp(0x3c0,0x71);     //Fix for Line Compare
	inp(0x3da); outp(0x3c0,0x30); outp(0x3c0,inp(0x3c1)&(255-64));  //?
}

copywindow(x1,y1,x2,y2,xdim,ydim)
unsigned int x1,y1,x2,y2,xdim,ydim;
{
	unsigned int pos1, pos2;

	outp(0x3ce,0x5); outp(0x3cf,inp(0x3cf)&252|1);
	outp(0x3c4,0x2); outp(0x3c5,255);
	pos1 = (y1*180)+(x1>>2);
	pos2 = (y2*180)+(x2>>2);
	_asm
	{
		mov si, pos1
		mov di, pos2
		mov dx, xdim
		shr dx, 1
		shr dx, 1
		mov bx, 180
		sub bx, dx
		mov ax, ydim
		push ds
		cld
		mov cx, 0xa000
		mov ds, cx
		mov es, cx
drawloop:
		mov cx, dx
		rep movsb        ;Note: Video hardware requires this to be byte only
		add si, bx
		add di, bx
		dec ax
		jnz short drawloop
		pop ds
	}
	outp(0x3ce,0x5); outp(0x3cf,inp(0x3cf)&252);
}

linecompare(lin)
unsigned int lin;
{
	outp(0x3d4,0x18); outp(0x3d5,lin&255);
	outp(0x3d4,0x7); outp(0x3d5,(inp(0x3d5)&239)|((lin&256)>>4));
	outp(0x3d4,0x9); outp(0x3d5,(inp(0x3d5)&191)|((lin&512)>>3));
}

startaddress(x, y)
unsigned int x, y;
{
	unsigned int plc;

	plc = (y*180)+(x>>2);
	while ((inp(0x3da) & 1) != 0);
	outp(0x3d4,0xc); outp(0x3d5,(plc>>8)&255);
	outp(0x3d4,0xd); outp(0x3d5,plc&255);
	outp(0x3c0,0x33);
	if (videomode == 2)
		outp(0x3c0,x&3);
	else
		outp(0x3c0,(x&3)<<1);
	while ((inp(0x3da) & 8) == 0);
}

loadstuff()
{
	int file, i, j;

	if ((file = open("setup.dat",O_BINARY|O_RDWR,S_IREAD)) == -1)
	{
		printf("Cannot open setup.dat");
		exit(0);
	}
	read(file,&option[0],4);
	read(file,&keys[0],5);
	close(file);
	if ((file = open("sprites.dat",O_BINARY|O_RDWR,S_IREAD)) == -1)
	{
		printf("Cannot open sprites.dat");
		exit(0);
	}
	read(file,&sprite[0],16384);
	close(file);
}

loadboard(int daboardnum)
{
	int file;

	if ((file = open("boards.dat",O_BINARY|O_RDWR,S_IREAD)) == -1)
	{
		printf("Cannot open boards.dat");
		exit(0);
	}
	lseek(file,daboardnum*45*20,SEEK_SET);
	read(file,&board[0],45*20);
	boardnum = daboardnum;
	close(file);
}

setupscreen()
{
	unsigned int i, k, l, basepos, pos;
	char col;

	fade(-1);
	plcx = 0;
	plcy = 0;
	startaddress(plcx,plcy+44);
	if (videomode == 0)
		linecompare(375);
	if (videomode == 1)
		linecompare(455);
	if (videomode == 2)
		linecompare(387);
	outp(0x3c4,0x1); outp(0x3c5,inp(0x3c5)|32);
	outp(0x3c4,0x2); outp(0x3c5,255);
	_asm \
	{
		mov ax, 0xa000
		mov es, ax
		cld
		mov di, 0
		mov al, 6
		mov cx, 2160
		rep stosb
	}
	outp(0x3c4,0x1); outp(0x3c5,inp(0x3c5)&223);
	outp(0x3c4,0x2);
	for(i=0;i<90;i++)
	{
		spotx[i] = (i%45)<<4;
		if (i >= 45)
			spoty[i] = 28;
		else
			spoty[i] = 12;
	}
	for(i=0;i<63;i++)
		for(k=0;k<16;k++)
		{
			basepos = (spoty[i]+k)*180 + (spotx[i]>>2);
			for(l=0;l<16;l++)
			{
				col = sprite[i][k][l];
				pos = basepos + (l>>2);
				outp(0x3c5,1<<(l&3));
				_asm \
				{
					mov ax, 0xa000
					mov es, ax
					mov di, pos
					mov al, col
					stosb
				}
			}
		}
	for(i=0;i<2;i++)
		copywindow(spotx[0],spoty[0],(i<<4),0,16,12);
}

drawboard()
{
	unsigned int i, j;

	numonsters = 0;
	for(i=0;i<45;i++)
		for(j=0;j<20;j++)
		{
			if ((board[i][j] >= 0) && (board[i][j] <= 3))
			{
				mx = (i<<4);
				my = (j<<4);
				xvel = 0;
				yvel = 0;
				firstx = mx;
				firsty = my;
				board[i][j] = 16;
			}
			if ((board[i][j] >= 4) && (board[i][j] <= 7))
			{
				monstx[numonsters] = (i<<4);
				monsty[numonsters] = (j<<4);
				monstxvel[numonsters] = 0;
				monstyvel[numonsters] = 0;
				numonsters++;
				board[i][j] = 16;
			}
			copywindow(spotx[board[i][j]],spoty[board[i][j]],i<<4,(j<<4)+44,16,16);
		}
	copywindow(mx,my+44,spotx[64],spoty[64],16,16);
	for(i=0;i<numonsters;i++)
		copywindow(monstx[i],monsty[i]+44,spotx[65+i],spoty[65+i],16,16);
	for(i=0;i<8;i++)
	{
		firexvel[i] = 0;
		fireyvel[i] = 0;
		firex[i] = spotx[73+i];
		firey[i] = spoty[73+i]-44;
		copywindow(firex[i],firey[i]+44,spotx[73+i],spoty[73+i],16,16);
	}
	waitfire = 0;
	mousx = 0;
	page = 0;
	death = 0;
	if (videomode == 0)
	{
		plcx = mx-160;
		if (plcx > 400)
			plcx = 400;
		plcy = my-70;
		if (plcy > 132)
			plcy = 132;
	}
	if (videomode == 1)
	{
		plcx = mx-180;
		if (plcx > 360)
			plcx = 360;
		plcy = my-90;
		if (plcy > 92)
			plcy = 92;
	}
	if (videomode == 2)
	{
		plcx = mx-320;
		if (plcx > 80)
			plcx = 80;
	}
	if (plcx < 0)
		plcx = 0;
	if (plcy < 0)
		plcy = 0;
	startaddress(plcx,plcy+44);
	if (midi == 1)
	{
		putdata(0x91);
		putdata(60); putdata(1);
		putdata(64); putdata(1);
		putdata(67); putdata(1);
		putdata(72); putdata(1);
		putdata(0x92);
		putdata(48); putdata(1);
		putdata(55); putdata(1);
	}
}

die()
{
	int i;

	if (midi == 1)
	{
		putdata(0x90);
		putdata(58); putdata(1);
		putdata(61); putdata(1);
		putdata(63); putdata(1);
		putdata(0x91);
		putdata(60); putdata(1);
		putdata(63); putdata(1);
		putdata(67); putdata(1);
		putdata(69); putdata(1);
		putdata(0x92);
		putdata(51); putdata(1);
		putdata(57); putdata(1);
	}
	fade(0);
	mousx = 0;
	mousy = 0;
	bstatus = 0;
	xvel = 0;
	yvel = 0;
	mx = firstx;
	my = firsty;
	death = 0;
	if (videomode == 0)
	{
		plcx = mx-160;
		if (plcx > 400)
			plcx = 400;
		plcy = my-70;
		if (plcy > 132)
			plcy = 132;
	}
	if (videomode == 1)
	{
		plcx = mx-180;
		if (plcx > 360)
			plcx = 360;
		plcy = my-90;
		if (plcy > 92)
			plcy = 92;
	}
	if (videomode == 2)
	{
		plcx = mx-320;
		if (plcx > 80)
			plcx = 80;
	}
	if (plcx < 0)
		plcx = 0;
	if (plcy < 0)
		plcy = 0;
	startaddress(plcx,plcy+44);
	lives--;
	if (lives > 0)
		copywindow(192,0,(lives-1)<<4,0,16,12);
	else
	{
		Regs.h.ah = 0; Regs.x.ax = 0x3; int86(0x10,&Regs,&Regs);
		outp(97,inp(97)&252);
		if (inputdevice == 0)
		{
			_disable(); _dos_setvect(0x9, oldkeyhandler); _enable();
		}
		if ((option[3] == 1) || (musicstatus == 1))
			musicoff();
		exit(0);
	}
	fade(1);
}

fade(way)
int way;
{
	int i, j;
	int tempal[768];

	if (way == -1)
	{
		outp(0x3c7,0);
		for(i=0;i<768;i++)
			pal[i] = inp(0x3c9);
		outp(0x3c8,0);
		for(i=0;i<768;i++)
			outp(0x3c9,0);
	}
	if (way == 0)
		for(j=63;j>=0;j-=3)
		{
			for(i=0;i<768;i++)
				tempal[i] = (pal[i]*j)>>6;
			outp(0x3c8,0);
			while((inp(0x3da) & 8) == 0);
			for(i=0;i<768;i++)
				outp(0x3c9,tempal[i]);
			while((inp(0x3da) & 8) != 0);
		}
	if (way == 1)
		for(j=0;j<=63;j+=3)
		{
			for(i=0;i<768;i++)
				tempal[i] = (pal[i]*j)>>6;
			outp(0x3c8,0);
			while((inp(0x3da) & 8) == 0);
			for(i=0;i<768;i++)
				outp(0x3c9,tempal[i]);
			while((inp(0x3da) & 8) != 0);
		}
}

getdata()
{
	int i;

	i = 256;
	while ((i > 0) && ((inp(0x331) & 0x80) != 0))
		i--;
	if (i == 0)
		return(-1);
	else
		return(inp(0x330));
}

putdata(data)
int data;
{
	int i;

	i = 256;
	while ((i > 0) && ((inp(0x331) & 0x40) != 0))
		i--;
	if (i == 0)
		return(-1);
	else
	{
		outp(0x330,data);
		return(data);
	}
}

putcmd(data)
int data;
{
	int i;

	i = 256;
	while ((i > 0) && ((inp(0x331) & 0x40) != 0))
		i--;
	outp(0x331,data);
	i = 256;
	while ((i > 0) && ((getdata() & 0xfe) != 0))
		i--;
}

setupmouse()
{
	unsigned long address;
	unsigned char first_byte;

	union REGS inregs, outregs;
	struct SREGS segregs;

	inregs.x.ax = 0x3533;
	intdosx(&inregs,&outregs,&segregs);
	address = (((long) segregs.es) << 16) + (long) outregs.x.bx;
	first_byte = (unsigned char) * (long far *)address;
	if ((address == 0L) || (first_byte == 0xcf))
		return(0);
	else
	{
		inregs.x.ax = 0; int86(0x33,&inregs,&outregs);
		return(1);
	}
}

void interrupt far keyhandler()
{
	oldreadch = readch;
	_asm \
	{
		in al, 0x60
		mov readch, al
		in al, 0x61
		or al, 0x80
		out 0x61, al
		and al, 0x7f
		out 0x61, al
	}
	if (readch == 0xe0)
		extended = 128;
	else
	{
		if (oldreadch != readch)
			keystatus[(readch&127)+extended] = ((readch>>7)^1);
		extended = 0;
	}
	_asm \
	{
		mov al, 0x20
		out 0x20, al
	}
}

loadmusic(filename)
char filename[80];
{
	char buffer[256];
	int infile, i, j;

	if (firstime == 1)
	{
		if((infile=open("insts.dat",O_BINARY|O_RDONLY,S_IREAD))==-1)
		{
			printf("I cannot load insts.dat!");
			exit(0);
		}
		for(i=0;i<256;i++)
		{
			read(infile,&buffer,33);
			for(j=0;j<20;j++)
				inst[i][j] = buffer[j];
			inst[i][20] = 0;
			for(j=21;j<32;j++)
				inst[i][j] = buffer[j-1];
		}
		close(infile);
		numchans = 9;
		outdata(0,0x1,0);  //clear test stuff
		outdata(0,0x4,0);  //reset
		outdata(0,0x8,0);  //2-operator synthesis
		if (numchans == 6)
			drumstat = 32;
		else
			drumstat = 0;
		outdata(0,0xbd,drumstat); //set to rhythm mode
		firstime = 0;
	}
	if ((strstr(filename,".KSM") == 0) && (strstr(filename,".ksm") == 0))
		strcat(filename,".KSM");
	if((infile=open(filename,O_BINARY|O_RDONLY,S_IREAD))==-1)
	{
		printf("I cannot load %s.",filename);
		exit(0);
	}
	read(infile,&trinst[0],16);
	read(infile,&trquant[0],16);
	read(infile,&trchan[0],16);
	read(infile,&trprio[0],16);
	read(infile,&trvol[0],16);
	read(infile,&numnotes,2);
	read(infile,&note[0],numnotes<<2);
	close(infile);
	if (trchan[11] == 0)
	{
		drumstat = 0;
		numchans = 9;
		outdata(0,0xbd,drumstat);
	}
	if (trchan[11] == 1)
	{
		setinst(0,6,0,3,0xd6,0x68,0,0,10,0xd6,0x68,0,4); //bass
		setinst(0,7,0,2,0xd8,0x4f,0,0,3,0xf8,0xff,0,14); //snare & hihat
		setinst(0,8,0,63,0xf5,0xc8,0,0,0,0xd6,0x88,0,0); //topcymb & tom
		outdata(0,0xa0+6,600&255);
		outdata(0,0xb0+6,(600>>8)&223);
		outdata(0,0xa0+7,400&255);
		outdata(0,0xb0+7,(400>>8)&223);
		outdata(0,0xa0+8,5510&255);
		outdata(0,0xb0+8,(5510>>8)&223);
		drumstat = 32;
		numchans = 6;
		outdata(0,0xbd,drumstat);
	}
	note[numnotes] = (((note[numnotes-1]>>12)+480)<<12); numnotes++;
}

outdata(synth,index,data)
unsigned char synth,index,data;
{
	if (synth == 1)
		_asm mov dx, 0x38a ; get the right 3812 address
	else
		_asm mov dx, 0x388 ; get the left 3812 address
	_asm \
	{
		mov al, index    ; get the index value
		out dx, al       ; output to both chips
		in al, dx        ; slow down for the index to settle
		in al, dx
		in al, dx
		in al, dx
		in al, dx
		inc dx           ; move to the data register
		mov al, data
		out dx, al       ; write the data out
		mov cx, 33       ; load the loop count
 lbl1:in al, dx
		loop lbl1
	}
}

musicon()
{
	char ch;
	unsigned int num;
	int i, j, k, offs;
	unsigned char instbuf[11];

	for(i=0;i<numchans;i++)
	{
		chantrack[i] = 0;
		chanage[i] = 0;
	}
	j = 0;
	for(i=0;i<16;i++)
		if ((trchan[i] > 0) && (j < numchans))
		{
			k = trchan[i];
			while ((j < numchans) && (k > 0))
			{
				chantrack[j] = i;
				k--;
				j++;
			}
		}
	for(i=0;i<numchans;i++)
	{
		for(j=0;j<11;j++)
			instbuf[j] = inst[trinst[chantrack[i]]][j+21];
		instbuf[1] = ((instbuf[1]&192)|(63-trvol[chantrack[i]]));
		setinst(0,i,instbuf[0],instbuf[1],instbuf[2],instbuf[3],instbuf[4],instbuf[5],instbuf[6],instbuf[7],instbuf[8],instbuf[9],instbuf[10]);
		chanfreq[i] = 0;
	}
	k = 0;
	musicstatus = 0;
	count = (note[k]>>12)-1;
	countstop = (note[k]>>12)-1;
	nownote = note[k];
	musicstatus = 1;
	num = (unsigned)((1193181.7 / (double)speed)+.5);
	outp(0x43,54); outp(0x40,num&255); outp(0x40,num>>8);
	oldhand = _dos_getvect(0x8);
	_disable(); _dos_setvect(0x8, ksmhandler); _enable();
}

musicoff()
{
	int i;

	outp(0x43,54); outp(0x40,255); outp(0x40,255);
	_disable(); _dos_setvect(0x8, oldhand); _enable();
	for(i=0;i<numchans;i++)
	{
		outdata(0,0xa0+i,0);
		outdata(0,0xb0+i,0);
	}
	musicstatus = 0;
}

void interrupt far ksmhandler()
{
	int i, j, quanter, bufnum, chan, drumnum, freq;
	long temp;

	count++;
	if (count >= countstop)
	{
		bufnum = 0;
		while (count >= countstop)
		{
			if (((note[nownote]&255) >= 1) && ((note[nownote]&255) <= 61))
			{
				i = 0;
				while (((chanfreq[i] != (note[nownote]&63)) || (chantrack[i] != ((note[nownote]>>8)&15))) && (i < numchans))
					i++;
				if (i < numchans)
				{
					databuf[bufnum] = (unsigned char)(0xa0+i); bufnum++;
					databuf[bufnum] = (unsigned char)(adlibfreq[note[nownote]&63]&255); bufnum++;
					databuf[bufnum] = (unsigned char)(0xb0+i); bufnum++;
					databuf[bufnum] = (unsigned char)((adlibfreq[note[nownote]&63]>>8)&223); bufnum++;
					chanfreq[i] = 0;
					chanage[i] = 0;
				}
			}
			else if (((note[nownote]&255) >= 65) && ((note[nownote]&255) <= 125))
			{
				if (((note[nownote]>>8)&15) < 11)
				{
					temp = 0;
					i = numchans;
					for(j=0;j<numchans;j++)
						if ((countstop - chanage[j] >= temp) && (chantrack[j] == ((note[nownote]>>8)&15)))
						{
							temp = countstop - chanage[j];
							i = j;
						}
					if (i < numchans)
					{
						databuf[bufnum] = (unsigned char)(0xa0+i); bufnum++;
						databuf[bufnum] = (unsigned char)0; bufnum++;
						databuf[bufnum] = (unsigned char)(0xb0+i); bufnum++;
						databuf[bufnum] = (unsigned char)0; bufnum++;
						databuf[bufnum] = (unsigned char)(0xa0+i); bufnum++;
						databuf[bufnum] = (unsigned char)(adlibfreq[note[nownote]&63]&255); bufnum++;
						databuf[bufnum] = (unsigned char)(0xb0+i); bufnum++;
						databuf[bufnum] = (unsigned char)((adlibfreq[note[nownote]&63]>>8)|32); bufnum++;
						chanfreq[i] = note[nownote]&63;
						chanage[i] = countstop;
					}
				}
				else
				{
					freq = adlibfreq[note[nownote]&63];
					switch((note[nownote]>>8)&15)
					{
						case 11: drumnum = 16; chan = 6; freq -= 2048; break;
						case 12: drumnum = 8; chan = 7; freq -= 2048; break;
						case 13: drumnum = 4; chan = 8; break;
						case 14: drumnum = 2; chan = 8; break;
						case 15: drumnum = 1; chan = 7; freq -= 2048; break;
					}
					databuf[bufnum] = (unsigned char)(0xa0+chan); bufnum++;
					databuf[bufnum] = (unsigned char)(freq&255); bufnum++;
					databuf[bufnum] = (unsigned char)(0xb0+chan); bufnum++;
					databuf[bufnum] = (unsigned char)((freq>>8)&223); bufnum++;
					databuf[bufnum] = (unsigned char)(0xbd); bufnum++;
					databuf[bufnum] = (unsigned char)(drumstat&(255-drumnum)); bufnum++;
					drumstat |= drumnum;
					databuf[bufnum] = (unsigned char)(0xbd); bufnum++;
					databuf[bufnum] = (unsigned char)(drumstat); bufnum++;
				}
			}
			nownote++;
			if (nownote >= numnotes)
			{
				nownote = 0;
				count = (note[nownote]>>12)-1;
			}
			quanter = (240/trquant[(note[nownote]>>8)&15]);
			countstop = (((note[nownote]>>12)+(quanter>>1)) / quanter) * quanter;
		}
		for(i=0;i<bufnum;i+=2)
			_asm \
			{
				mov dx, 0x388             ; get the left 3812 address
				mov bx, i
				mov al, databuf[bx]       ; get the index value
				out dx, al                ; output to both chips
				in al, dx                 ; slow down for the index to settle
				in al, dx
				in al, dx
				in al, dx
				in al, dx
				inc dx                    ; move to the data register
				inc bx
				mov al, databuf[bx]
				out dx, al                ; write the data out
				mov cx, 33                ; load the loop count
		 lbl2:in al, dx
				loop lbl2
			}
	}
	outp(0x20,0x20);
}

setinst(synth,chan,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)
int chan;
unsigned char synth,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10;
{
	int offs;

	outdata(synth,0xa0+chan,0);
	outdata(synth,0xb0+chan,0);
	outdata(synth,0xc0+chan,v10);
	if (chan == 0)
		offs = 0;
	if (chan == 1)
		offs = 1;
	if (chan == 2)
		offs = 2;
	if (chan == 3)
		offs = 8;
	if (chan == 4)
		offs = 9;
	if (chan == 5)
		offs = 10;
	if (chan == 6)
		offs = 16;
	if (chan == 7)
		offs = 17;
	if (chan == 8)
		offs = 18;
	outdata(synth,0x20+offs,v5);
	outdata(synth,0x40+offs,v6);
	outdata(synth,0x60+offs,v7);
	outdata(synth,0x80+offs,v8);
	outdata(synth,0xe0+offs,v9);
	offs+=3;
	outdata(synth,0x20+offs,v0);
	outdata(synth,0x40+offs,v1);
	outdata(synth,0x60+offs,v2);
	outdata(synth,0x80+offs,v3);
	outdata(synth,0xe0+offs,v4);
}

int screencapturemodex(char *filename, long pageoffs, int linecompare, int daxdim, int daydim, int dabpl)
{
	int x, y, i, j, fil, leng;
	unsigned char col, ncol;

	if ((fil=open(filename,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY,S_IWRITE)) == -1) return(-1);
	*(short *)(&pcxheader[8]) = (short)(daxdim-1);
	*(short *)(&pcxheader[10]) = (short)(daydim-1);
	*(short *)(&pcxheader[12]) = (short)daxdim;
	*(short *)(&pcxheader[66]) = (short)daxdim;
	*(short *)(&pcxheader[14]) = (short)daydim;
	write(fil,pcxheader,128);

	outp(0x3ce,4);
	i = 0; x = 0; y = 0;
	while (y < daydim)
	{
		_asm \
		{
			mov dx, 0x3cf
			mov al, byte ptr pageoffs[0]
			and al, 3
			out dx, al
			mov di, 0xa000
			push es
			mov es, di
			mov ax, word ptr pageoffs[2]
			mov di, word ptr pageoffs[0]
			shr ax, 1
			rcr di, 1
			shr ax, 1
			rcr di, 1
			mov al, es:[di]
			pop es
			mov byte ptr [col], al
		}
		x++; pageoffs++; leng = 1;

		_asm \
		{
			mov dx, 0x3cf
			mov al, byte ptr pageoffs[0]
			and al, 3
			out dx, al
			mov di, 0xa000
			push es
			mov es, di
			mov ax, word ptr pageoffs[2]
			mov di, word ptr pageoffs[0]
			shr ax, 1
			rcr di, 1
			shr ax, 1
			rcr di, 1
			mov al, es:[di]
			pop es
			mov byte ptr [ncol], al
		}
		while ((ncol == col) && (leng < 63) && (x < daxdim))
		{
			leng++; x++; pageoffs++;
			_asm \
			{
				mov dx, 0x3cf
				mov al, byte ptr pageoffs[0]
				and al, 3
				out dx, al
				mov di, 0xa000
				push es
				mov es, di
				mov ax, word ptr pageoffs[2]
				mov di, word ptr pageoffs[0]
				shr ax, 1
				rcr di, 1
				shr ax, 1
				rcr di, 1
				mov al, es:[di]
				pop es
				mov byte ptr [ncol], al
			}
		}
		if (x >= daxdim)
		{
			x = 0; y++; pageoffs += (long)(dabpl-daxdim);
			if (y == linecompare) pageoffs = 0L;
		}
		if ((leng > 1) || (col >= (unsigned char)0xc0)) tempbuf[i++] = (unsigned char)(leng|0xc0);
		tempbuf[i++] = col;
		if (i > sizeof(tempbuf)-2)
		{
			if (write(fil,tempbuf,i) < i) { close(fil); return(-1); }
			i = 0;
		}
	}

	if (i > sizeof(tempbuf)-768-1)
	{
		if (write(fil,tempbuf,i) < i) { close(fil); return(-1); }
		i = 0;
	}

	tempbuf[i++] = 0xc;
	outp(0x3c7,0);
	for(j=0;j<256;j++)
	{
		tempbuf[i++] = (inp(0x3c9)<<2);
		tempbuf[i++] = (inp(0x3c9)<<2);
		tempbuf[i++] = (inp(0x3c9)<<2);
	}

	if (write(fil,tempbuf,i) < i) { close(fil); return(-1); }

	close(fil);
	return(0);
}
