
;                   ADVENTURE UNIQUE CODE

;        FILE = ADVCODE2/ASM   LAST MODIFIED: 10/19/84

;********************************************************************
;
;  LOOK01 - LOOK CABINET
;
;********************************************************************

LOOK01   PROC
         MOV   AL,127             ;CLOSED CABINET
         CALL  CKOBJ
         LBNE  DMSG016
         MOV   AL,116             ;OPEN CABINET
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,16+INV          ;BLANKET
         CALL  MAKVIS
         JNZ   LOOK01_A
         MOV   AL,17+INV          ;PILLOW
         CALL  MAKVIS
         JNZ   LOOK01_A
         MOV   AL,8+INV           ;SPACE SUIT
         CALL  MAKVIS
         LBEQ  DMSG022
LOOK01_A:
         CALL  CKDRAW
         JMP   DMSG011
LOOK01   ENDP

;********************************************************************
;
;  LOOK02 - LOOK POCKET
;
;********************************************************************

LOOK02   PROC
         MOV   AL,8               ;SPACE SUIT
         CALL  LOCOBJ
         JNE   LOOK02_A
         MOV   AL,9               ;WEARING SPACE SUIT
         CALL  HAVOBJ
         LBEQ  NOSEE
LOOK02_A:
         MOV   AL,10              ;ADVERTISING LEAFLET
         CALL  FNDOBJ
         LBNE  DMSG022
         MOV   AL,10              ;ADVERTISING LEAFLET
         CALL  PUTOBJ
         JMP   DMSG011
LOOK02   ENDP

;********************************************************************
;
;  LOOK03 - LOOK VIEW SCREEN
;
;********************************************************************

LOOK03   PROC
         CMP   ROOM,17            ;ON VELDBOER?
         LBNE  LOOKOB             ;  NO
         JMP   DMSG022
LOOK03   ENDP

;********************************************************************
;
;  LOOK04 - LOOK LADDER
;
;********************************************************************

LOOK04   PROC
         MOV   AL,ROOM
         CMP   AL,6               ;TREKBOER ENVIRONMENT CNTL
         JE    LOOK04_A
         CMP   AL,15              ;VELDBOER ENVIRONMENT CNTL
LOOK04_A:
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK04   ENDP

;********************************************************************
;
;  LOOK05 - LOOK DRAWER
;
;********************************************************************

LOOK05   PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    LOOK05_B
         MOV   AL,27+INV          ;YELLOW CAPSULE
         CALL  MAKVIS
         JNE   LOOK05_A
         MOV   AL,32+INV          ;ROPE
         CALL  MAKVIS
         JE    LOOK05_B
LOOK05_A:
         CALL  CKDRAW
         JMP   DMSG011
LOOK05_B:
         JMP   LOOKOB
LOOK05   ENDP

;********************************************************************
;
;  LOOK06 - LOOK WHITE BUTTON
;
;********************************************************************

LOOK06   PROC
         MOV   AL,124             ;OPEN ACCESS PANEL
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG012
LOOK06   ENDP

;********************************************************************
;
;  GET01  - GET SKELETON
;
;********************************************************************

GET01    PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG064
GET01    ENDP

;********************************************************************
;
;  GET02  - GET LIQUID
;
;********************************************************************

GET02    PROC
         MOV   AL,102             ;POOL OF ACID
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   AL,14              ;EMPTY BEAKER
         CALL  HAVOBJ
         JE    GET02_A
         MOV   AH,15              ;BEAKER OF ACID
         CALL  REPOBJ
         JMP   DMSG060
GET02_A:
         MOV   AL,24              ;CANTEEN
         CALL  HAVOBJ
         LBEQ  DMSG061
         MOV   AH,0
         CALL  REPOBJ
         JMP   DMSG062
GET02    ENDP

;********************************************************************
;
;  GET03  - GET CARTRIDGE
;
;********************************************************************

GET03    PROC
         MOV   AL,93              ;ROBOT WITH CARTRIDGE
         CALL  CKOBJ
         JNE   GET03_A
         MOV   AL,99              ;ROBOT WITH CARTRIDGE
         CALL  CKOBJ
         JE    GET03_E
GET03_A:
         MOV   AH,OBJCNT
         CMP   AH,MAXOBJ1
         JAE   GET03_F
         MOV   AH,100
         DISABLE
GET03_B:
         CALL  CHGOBJ
         MOV   AH,AL
         MOV   AL,26              ;CARTRIDGE
         CALL  PUTNRM
         CMP   AH,93              ;DISABLED ROBOT
         JE    GET03_D
         MOV   AL,163
         CALL  SHOOVL
         MOV   CL,40
         CALCX 37,17
         CALCD 37,17,72,72
GET03_C:
         CALL  SCRLFT
         DEC   CL
         JNE   GET03_C
GET03_D:
         ENABLE
GET03_E:
         JMP   VGET
GET03_F:
         JMP   DMSG009
GET03    ENDP

;********************************************************************
;
;  GET04  - GET LADDER
;
;********************************************************************

GET04    PROC
         MOV   AL,ROOM
         CMP   AL,6
         JE    GET04_A
         CMP   AL,15
         JE    GET04_A
         JMP   VGET
GET04_A:
         JMP   DMSG015
GET04    ENDP

;********************************************************************
;
;  GET05  - GET ICE
;
;********************************************************************

GET05    PROC
         MOV   AL,96              ;PILE OF ICE
         CALL  CKOBJ
         JNE   GET05_B
         MOV   AL,ROOM
         CMP   AL,8
         JB    GET05_A
         CMP   AL,10
         JA    GET05_A
         JMP   DMSG076
GET05_A:
         JMP   NOSEE
GET05_B:
         MOV   AL,16              ;EMPTY BLANKET
         CALL  HAVOBJ
         LBEQ  DMSG077
         MOV   AH,12              ;BLANKET FULL OF ICE
         CALL  REPOBJ
         JMP   DMSG078
GET05    ENDP

;********************************************************************
;
;  GET06  - GET SPIDER
;
;********************************************************************

GET06    PROC
         MOV   AL,28
         CALL  CKOBJ
         LBEQ  VGET
GET06A:
         LEA   BX,MSG097
         CALL  DISPLY
         JMP   ENDGAM
GET06    ENDP

;********************************************************************
;
;  GET07  - GET ROPE
;
;********************************************************************

GET07    PROC
         CALL  EQUOBJ
         CMP   NOUNNO,32
         LBEQ  VGET
         LEA   BX,MSG107
         CALL  DISPLY
         JMP   REPLY
GET07    ENDP

;********************************************************************
;
;  GET08  - GET WHITE BUTTON
;
;********************************************************************

GET08    PROC
         MOV   AL,124             ;OPEN ACCESS PANEL
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG015
GET08    ENDP

;********************************************************************
;
;  PUT01  - PUT SUIT
;
;********************************************************************

PUT01    PROC
         MOV   AL,9               ;WEARING SUIT
         CALL  HAVOBJ
         LBNE  DMSG043
         JMP   VPUT
PUT01    ENDP

;********************************************************************
;
;  PUT02  - PUT BEAKER
;
;********************************************************************

PUT02    PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,18              ;BROKEN GLASS
         LBEQ  VPUT
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,0
         CALL  REPOBJ
         MOV   AL,17              ;PILLOW
         CALL  CKOBJ
         JE    PUT02_A
         MOV   AL,NOUNNO
         CALL  PUTOBJ
         LEA   BX,MSG051
         JMP   SHORT PUT02_B
PUT02_A:
         MOV   AL,18              ;BROKEN GLASS
         CALL  PUTOBJ
         LEA   BX,MSG052
PUT02_B:
         CALL  CKDRAW
         CALL  DISPLY
         JMP   REPLY
PUT02    ENDP

;********************************************************************
;
;  PUT03  - PUT BLANKET
;
;********************************************************************

PUT03    PROC
         MOV   AL,126             ;EMPTY BARREL
         CALL  CKOBJ
         JE    PUT03_A
         MOV   AL,12              ;BLANKET WITH ICE
         CALL  HAVOBJ
         JE    PUT03_A
         MOV   AH,0
         CALL  REPOBJ
         MOV   AL,126             ;EMPTY BARREL
         MOV   AH,94              ;FULL BARREL
         CALL  CHGOBJ
         JMP   DMSG080
PUT03_A:
         JMP   VPUT
PUT03    ENDP

;********************************************************************
;
;  GO01   - GO LADDER
;
;********************************************************************

GO01     PROC
         MOV   AL,ROOM
         CMP   AL,17
         JE    GO01_B
         CMP   AL,15
         JE    GO01_C
         CMP   AL,6
         JE    GO01_D
         CMP   AL,1
         LBNE  NOSEE
         MOV   AL,6
GO01_A:
         JMP   EXITRM
GO01_B:
         MOV   AL,15
         JMP   SHORT GO01_A
GO01_C:
         MOV   AL,17
         JMP   SHORT GO01_A
GO01_D:
         MOV   AL,1
         JMP   SHORT GO01_A
GO01     ENDP

;********************************************************************
;
;  GO02   - GO TELEPORT WINDOW
;
;********************************************************************

GO02     PROC
         MOV   AL,120             ;TELEPORT WINDOW
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         CMP   AL,3
         JNE   GO02_B
;
;        BEGIN PROTECTION CODE
;
         MOV   AL,VALIDSW
         CMP   AL,PROTSW
         LBNE  DMSG023
;
;        END PROTECTION CODE
;
         MOV   AL,SETNX2
GO02_A:
         PUSH  AX
         MOV   AH,16
         DISABLE
         MOV   AL,54
         CALL  SHOOVL
         MOV   FLIPCT,BLUE@W
GO02_C:
         CALL  SHOBOX
         DEC   AH
         JNE   GO02_C
         POP   AX
         JMP   EXITRM
GO02_B:
         MOV   AL,3
         JMP   SHORT GO02_A
GO02     ENDP

;********************************************************************
;
;  GO03   - GO HATCH
;
;********************************************************************

GO03     PROC
         MOV   AL,105             ;OPEN HATCH
         CALL  CKOBJ
         LBEQ  DMSG023
;
;        BEGIN PROTECTION CODE
;
         MOV   AL,PROTSW
         CMP   AL,VALIDSW
         JE    GO03_A
         SUB   AH,AH
         MOV   AL,21              ;MAP
         CALL  XCHGOB
         ADD   AL,4               ;25 = AMULET
         CALL  XCHGOB
;
;        END PROTECTION CODE
;
GO03_A:
         MOV   AL,ROOM
         XOR   AL,1
         JMP   EXITRM
GO03     ENDP

;********************************************************************
;
;  GO04   - GO CENOTAPH
;
;********************************************************************

GO04     PROC
         MOV   AL,ROOM
         CMP   AL,18
         LBEQ  DMSG013
         CMP   AL,10
         LBNE  NOSEE
         MOV   AL,18
         JMP   EXITRM
GO04     ENDP

;********************************************************************
;
;  GO05   - GO BRIDGE
;
;********************************************************************

GO05     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,90              ;CRUMBLED BRIDGE
         LBEQ  DMSG083
         MOV   AL,33
         JMP   EXITRM
GO05     ENDP

;********************************************************************
;
;  GO06   - GO TREE
;
;********************************************************************

GO06     PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG087
GO06     ENDP

;********************************************************************
;
;  GO07   - GO FORCE FIELD
;
;********************************************************************

GO07     PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,25              ;AMULET
         CALL  HAVOBJ
         LBEQ  DMSG110
         MOV   AL,41
         JMP   EXITRM
GO07     ENDP

;********************************************************************
;
;  GO08   - GO DOORWAY
;
;********************************************************************

GO08     PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         XOR   AL,5
         JMP   EXITRM
GO08     ENDP

;********************************************************************
;
;  GO09   - GO GRATE
;
;********************************************************************

GO09     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,84
         LBEQ  DMSG023
         MOV   AL,28              ;SPIDER
         CALL  CKOBJ
         LBNE  DMSG096
         MOV   AL,ROOM
         CMP   AL,31
         LBEQ  DMSG109
         XOR   AL,34H
         JMP   EXITRM
GO09     ENDP

;********************************************************************
;
;  GO10   - GO STONES/RUBBLE
;
;********************************************************************

GO10     PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         XOR   AL,3
         JMP   EXITRM
GO10     ENDP

;********************************************************************
;
;  GO11   - GO ROPE
;
;********************************************************************

GO11     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  LOCOBJ
         LBEQ  NOSEE
         CMP   AL,78
         JE    GO11_A
         CMP   AL,80
         LBNE  DMSG023
GO11_A:
         MOV   AL,ROOM
         CMP   AL,29
         LBEQ  DMSG109
         XOR   AL,5
         JMP   EXITRM
GO11     ENDP

;********************************************************************
;
;  GO12   - GO LAVA
;
;********************************************************************

GO12     PROC
         MOV   AL,82
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG064
GO12     ENDP

;********************************************************************
;
;  PRES01 - PRESS BLUE BUTTON
;
;********************************************************************

PRES01   PROC
         MOV   AL,ROOM
         CMP   AL,3
         JNE   PRES01_D
         MOV   AL,120             ;TELEPORT WINDOW
         CALL  CKOBJ
         JE    PRES01_A
         MOV   AH,0
         CALL  CHGOBJ
         JMP   SHORT PRES01_B
PRES01_A:
         MOV   AL,120             ;TELEPORT WINDOW
         CALL  PUTNRM
PRES01_B:
         CALL  CKDRAW
PRES01_C:
         JMP   DMSG047
PRES01_D:
         CMP   AL,17
         JE    PRES01_C
         CMP   AL,20
         JE    PRES01_C
         CMP   AL,22
         JE    PRES01_C
         CMP   AL,4
         JE    PRES01_E
         CMP   AL,1
         LBNE  NOSEE
         LEA   BX,MSG047
         CALL  DISPLY
         LEA   BX,SAVCOR
         LEA   SI,MSG059A
         MOV   AH,4
         CALL  MOVE
         JMP   DMSG059
PRES01_E:
         MOV   AL,99              ;ROBOT WITH CART
         CALL  CKOBJ
         JE    PRES01_C
         MOV   AL,87              ;OPEN DRAWER
         CALL  CKOBJ
         JNE   PRES01_C
         MOV   AL,87              ;OPEN DRAWER
         CALL  PUTNRM
         CALL  CKDRAW
         LEA   BX,MSG047
         CALL  DISPLY
         JMP   DMSG011
PRES01   ENDP

;********************************************************************
;
;  PRES02 - PRESS RED BUTTON
;
;********************************************************************

PRES02   PROC
         MOV   AL,ROOM
         CMP   AL,34
         LBEQ  PRES02_F
         CMP   AL,17
         LBEQ  DMSG047
         CMP   AL,1
         LBNE  NOSEE
         LEA   BX,MSG047
         CALL  DISPLY
         MOV   FLIPSW,0
         MOV   AH,40
PRES02_A:
         XOR   FLIPSW,1
         JE    PRES02_B
         MOV   AL,32              ;WHITE VIEW SCREEN
         JMP   SHORT PRES02_C
PRES02_B:
         MOV   AL,12              ;VIEW SCREEN
PRES02_C:
         DISABLE
         CALL  SHOOVL
         ENABLE
         DEC   AH
         JNE   PRES02_A
         MOV   NOUNNO,107         ;VIEW SCREEN
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         MOV   AH,0
         CALL  CHGOBJ
         MOV   AH,SETNXT
         MOV   SETNX2,AH
         MOV   AL,107             ;VIEW SCREEN
         LEA   BX,PLNT_TAB        ;PLANET OVERLAY TABLE
PRES02_D:
         TEST  BYTE PTR [BX],0FFH
         JE    PRES02_E
         ADD   BX,2
         CMP   AH,[BX-2]
         JNE   PRES02_D
         MOV   AL,[BX-1]
PRES02_E:
         CALL  PUTNRM
         CALL  CKDRAW
         LEA   BX,MSG046A
         LEA   SI,SAVCOR
         MOV   AH,4
         CALL  MOVE
         MOV   AL,30              ;CHK FOR LIVE PLANT
         CALL  FNDOBJ
         JE    PRES02_H
         JS    PRES02_I
         CMP   AL,7
         JB    PRES02_I
PRES02_H:
         JMP   REPLY
PRES02_I:
         CMP   AL,5
         JNE   PRES02_J
         TEST  LITESW,0FFH
         JE    PRES02_J
         MOV   AL,94              ;BARREL FULL OF WATER
         CALL  FNDOBJ
         CMP   AL,6
         JE    PRES02_H
PRES02_J:
         MOV   AL,30              ;LIVE PLANT
         MOV   AH,31              ;DEAD PLANT
         CALL  XCHGOB
         JMP   SHORT PRES02_H
PRES02_F:
         TEST  DOORSW,0FFH
         JE    PRES02_G
         MOV   DOORSW,0
         JMP   DMSG047
PRES02_G:
         INC   DOORSW
         MOV   AL,39
         CALL  CLROBJ
         JMP   DMSG095
PRES02   ENDP

;********************************************************************
;
;  PRES03 - PRESS WHITE BUTTON
;
;********************************************************************

PRES03   PROC
         MOV   AL,124             ;OPEN ACCESS PANEL
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   ROOM,6
         JNE   PRES03_A
         XOR   LITESW,1
PRES03_A:
         JMP   DMSG047
PRES03   ENDP

;********************************************************************
;
;  DRIN01 - DRINK LIQUID
;
;********************************************************************

DRIN01   PROC
         MOV   AL,15              ;BEAKER OF ACID
         CALL  HAVOBJ
         JNE   DRIN01_A
         MOV   AL,102             ;POOL OF ACID
         CALL  CKOBJ
         LBEQ  NOSEE
DRIN01_A:
         LEA   BX,MSG067
         CALL  DISPLY
         JMP   ENDGAM
DRIN01   ENDP

;********************************************************************
;
;  UNLK01 - UNLOCK CABINET
;
;********************************************************************

UNLK01   PROC
         MOV   AL,11              ;KEY
         CALL  HAVOBJ
         LBNE  VOPEN
         JMP   DMSG023
UNLK01   ENDP

;********************************************************************
;
;  UNLK02 - UNLOCK PANEL
;
;********************************************************************

UNLK02   PROC
         MOV   AL,124             ;OPEN ACCESS PANEL
         CALL  CKOBJ
         LBNE  DMSG018
         MOV   AL,125             ;CLOSED ACCESS PANEL
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,11              ;KEY
         CALL  HAVOBJ
         LBNE  DMSG074
         JMP   DMSG023
UNLK02   ENDP

;********************************************************************
;
;  VINSRT - INSERT VERB PROCESSOR
;
;********************************************************************

VINSRT   PROC
         MOV   AL,NOUNNO
         CMP   AL,26              ;CARTRIDGE
         LBNE  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,100
         CALL  CKOBJ
         LBEQ  DMSG023
         CMP   ROOM,22
         JNE   VINSRT_A
         MOV   AH,93
         JMP   SHORT VINSRT_B
VINSRT_A:
         MOV   AH,99
VINSRT_B:
         DISABLE
         CALL  CHGOBJ
         MOV   AL,26
         SUB   AH,AH
         CALL  REPOBJ
         CMP   ROOM,22
         JE    VINSRT_D
         MOV   CL,40
         CALCX 37,17
         CALCD 37,17,72,72
VINSRT_C:
         CALL  SCRRIT
         DEC   CL
         JNE   VINSRT_C
         MOV   AL,157
         CALL  SHOOVL
VINSRT_D:
         ENABLE
         JMP   REPLY
VINSRT   ENDP

;********************************************************************
;
;  VREMOV - REMOVE VERB PROCESSOR
;
;********************************************************************

VREMOV   PROC
         MOV   AL,NOUNNO
         CMP   AL,8               ;SPACE SUIT
         LBNE  BADINP
         INC   AL
         CALL  HAVOBJ
         LBEQ  DMSG044
         MOV   AH,8               ;SPACE SUIT
         CALL  REPOBJ
         JMP   REPLY
VREMOV   ENDP

;********************************************************************
;
;  REMO01 - REMOVE CARTRIDGE
;
;********************************************************************

REMO01   PROC
         MOV   AL,93              ;ROBOT WITH CART
         CALL  CKOBJ
         JNE   REMO01_A
         MOV   AL,99              ;ROBOT WITH CART
         CALL  CKOBJ
         LBEQ  DMSG023
REMO01_A:
         JMP   GET03
REMO01   ENDP

;********************************************************************
;
;  VDIG   - DIG VERB PROCESSOR
;
;********************************************************************

VDIG     PROC
         LEA   BX,MSG075
         CALL  DISPLY
         CALL  GETLIN
         CALL  SCNKEY
         MOV   NOUNNO,0
         LEA   BX,NOUNTB
         LEA   DI,NOUNNO
         LEA   SI,VERB
         CALL  SCNTBL
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,23              ;SHOVEL
         LBNE  DMSG026
         MOV   AL,ROOM
         CMP   AL,8
         JB    VDIG_A
         CMP   AL,10
         JA    VDIG_A
         MOV   AL,96              ;PILE OF ICE
         CALL  CKOBJ
         JNE   VDIG_A
         MOV   AL,96              ;PILE OF ICE
         CALL  PUTNRM
         CALL  CKDRAW
VDIG_A:
         JMP   REPLY
VDIG     ENDP

;********************************************************************
;
;  VFEED  - FEED VERB PROCESSOR
;
;********************************************************************

VFEED    PROC
         CALL  EQUOBJ
         CMP   NOUNNO,0
         LBEQ  BADINP
         MOV   AL,28
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,0
         CALL  REPOBJ
         CMP   AL,27              ;YELLOW CAPSULE
         JNE   VFEED_A
         MOV   SPIDSW,4
VFEED_A:
         JMP   DMSG098
VFEED    ENDP

;********************************************************************
;
;  FEED01 - FEED SPIDER
;
;********************************************************************

FEED01   PROC
         MOV   AL,29
         CALL  CKOBJ
         LBNE  DMSG023
         MOV   AL,28
         CALL  CKOBJ
         LBEQ  NOSEE
         LEA   BX,MSG099
         CALL  DISPLY
         CALL  GETLIN
         CALL  SCNKEY
         LEA   BX,NOUNTB
         LEA   DI,NOUNNO
         LEA   SI,VERB
         CALL  SCNTBL
         JMP   SHORT VFEED
FEED01   ENDP

;********************************************************************
;
;  VOPEN  - OPEN VERB PROCESSOR
;
;********************************************************************

VOPEN    PROC
         CMP   NOUNNO,127         ;CABINET
         LBNE  BADINP
         MOV   AL,116             ;OPOEN CABINET
         CALL  CKOBJ
         JNE   VOPEN_A
         MOV   AL,127             ;CLOSED CABINET
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,11              ;KEY
         CALL  HAVOBJ
         LBEQ  DMSG017
         MOV   AL,127             ;CLOSED CABINET
         MOV   AH,116             ;OPEN CABINET
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
VOPEN_A:
         JMP   DMSG018
VOPEN    ENDP

;********************************************************************
;
;  OPEN01 - OPEN MANUAL
;
;********************************************************************

OPEN01   PROC
         MOV   AL,13              ;OPEN MANUAL
         CALL  HAVOBJ
         LBNE  DMSG018
         MOV   AL,19              ;CLOSED MANUAL
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,13              ;OPEN MANUAL
         CALL  REPOBJ
         MOV   AL,11              ;KEY
         CALL  PUTNRM
         CALL  CKDRAW
         JMP   DMSG038
OPEN01   ENDP

;********************************************************************
;
;  OPEN02 - OPEN HATCH
;
;********************************************************************

OPEN02   PROC
         MOV   AL,105             ;OPEN HATCH
         CALL  CKOBJ
         JNE   OPEN02_A
         MOV   AL,104             ;CLOSED HATCH
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,105             ;OPEN HATCH
         CALL  CHGOBJ
         CALL  CKDRAW
         CMP   ROOM,6             ;ON TREKBOER
         JNE   OPEN02_A
         LEA   BX,MSG053
         CALL  DELAY
         JMP   TOTRAP
OPEN02_A:
         JMP   DMSG018
OPEN02   ENDP

;********************************************************************
;
;  OPEN03 - OPEN MAP
;
;********************************************************************

OPEN03   PROC
         MOV   AL,22              ;OPEN MAP
         CALL  HAVOBJ
         JNE   OPEN02_A
         MOV   AL,21              ;FOLDED MAP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,22              ;OPEN MAP
         CALL  REPOBJ
         JMP   SHORT OPEN02_A
OPEN03   ENDP

;********************************************************************
;
;  CLOS01 - CLOSE HATCH
;
;********************************************************************

CLOS01   PROC
         MOV   AL,104             ;CLOSED HATCH
         CALL  CKOBJ
         JNE   CLOS01_A
         MOV   AL,105             ;OPEN HATCH
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,104             ;CLOSED HATCH
         CALL  CHGOBJ
         CALL  CKDRAW
CLOS01_A:
         JMP   DMSG016
CLOS01   ENDP

;********************************************************************
;
;  CLOS02 - CLOSE MAP
;
;********************************************************************

CLOS02   PROC
         MOV   AL,21              ;FOLDED MAP
         CALL  HAVOBJ
         JNE   CLOS02_A
         MOV   AL,22              ;OPEN MAP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,21              ;FOLDED MAP
         CALL  REPOBJ
CLOS02_A:
         JMP   REPLY
CLOS02   ENDP

;********************************************************************
;
;  CLOS03 - CLOSE CABINET
;
;********************************************************************

CLOS03   PROC
         MOV   AL,127             ;CLOSED CABINET
         CALL  CKOBJ
         LBNE  DMSG016
         MOV   AL,116             ;OPEN CABINET
         CALL  CKOBJ
         LBNE  DMSG021
         JMP   SHORT CLOS04_A
CLOS03   ENDP

;********************************************************************
;
;  CLOS04 - CLOSE PANEL
;
;********************************************************************

CLOS04   PROC
         MOV   AL,125             ;CLOSED PANEL
         CALL  CKOBJ
         LBNE  DMSG016
         MOV   AL,124             ;OPEN PANEL
         CALL  CKOBJ
         LBNE  DMSG021
CLOS04_A:
         JMP   NOSEE
CLOS04   ENDP

;********************************************************************
;
;  VEAT   - EAT VERB PROCESSOR
;
;********************************************************************

VEAT     PROC
         MOV   AL,NOUNNO
         CMP   AL,27              ;CAPSULE
         LBNE  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,9               ;WEARING SUIT
         CALL  HAVOBJ
         LBNE  DMSG094
         MOV   AL,27              ;CAPSULE
         MOV   AH,0
         CALL  REPOBJ
         MOV   CAPSW,6
         JMP   DMSG093
VEAT     ENDP

;********************************************************************
;
;  VTIE   - TIE VERB PROCESSOR
;
;********************************************************************

VTIE     PROC
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CMP   AL,32              ;ROPE
         LBNE  DMSG026
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,89              ;TREES
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   AL,32              ;ROPE
         MOV   AH,0
         CALL  REPOBJ
         MOV   AL,80              ;ROPE TIED TO TREE
         CMP   ROOM,27
         JE    VTIE_A
         INC   AL
VTIE_A:
         CALL  PUTNRM
         CALL  CKDRAW
         MOV   CL,ROOM
         CMP   CL,27
         JNE   VTIE_B
         DISABLE
         MOV   ROOM,29
         MOV   AL,78              ;DANGLING ROPE
         CALL  PUTNRM
         INC   ROOM
         CALL  PUTNRM
         MOV   ROOM,CL
         ENABLE
VTIE_B:
         JMP   DMSG106
VTIE     ENDP

;********************************************************************
;
;  VUNTIE - UNTIE VERB PROCESSOR
;
;********************************************************************

VUNTIE   PROC
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CMP   AL,32              ;ROPE
         LBNE  DMSG026
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,32
         LBEQ  DMSG023
         CMP   AL,78
         LBEQ  DMSG015
         MOV   AH,32
         CALL  CHGOBJ
         CALL  CKDRAW
         CMP   ROOM,27
         JNE   VUNTIE_A
         MOV   AL,78              ;DANGLING ROPE
         MOV   AH,0
         CALL  XCHGOB
VUNTIE_A:
         JMP   REPLY
VUNTIE   ENDP

;********************************************************************
;
;  VFILL  - FILL VERB PROCESSOR
;
;********************************************************************

VFILL    PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,24              ;CANTEEN
         JE    VFILL_A
         CMP   AL,14              ;EMPTY BEAKER
         JE    VFILL_A
         CMP   AL,15              ;BEAKER OF ACID
         LBNE  BADINP
VFILL_A:
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,15              ;BEAKER OF ACID
         LBEQ  DMSG063
         JMP   GET02
VFILL    ENDP

;********************************************************************
;
;  VWEAR  - WEAR VERB PROCESSOR
;
;********************************************************************

VWEAR    PROC
         CMP   NOUNNO,8           ;SPACE SUIT
         LBNE  BADINP
         MOV   AL,9               ;WEARING SUIT
         CALL  HAVOBJ
         LBNE  DMSG014
         MOV   AL,8               ;SPACE SUIT
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,9               ;WEARING SUIT
         CALL  REPOBJ
         JMP   REPLY
VWEAR    ENDP

;********************************************************************
;
;  POUR01 - POUR BEAKER/ACID
;
;********************************************************************

POUR01   PROC
         MOV   AL,15              ;BEAKER OF ACID
         CALL  HAVOBJ
         JE    POUR01_A
         MOV   AH,14              ;EMPTY BEAKER
         CALL  REPOBJ
         MOV   AL,125             ;CLOSED PANEL
         CALL  CKOBJ
         JE    POUR01_C
         MOV   AH,124             ;OPEN PANEL
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG072
POUR01_A:
         CMP   NOUNNO,102         ;ACID
         JE    POUR01_B
         MOV   AL,14              ;EMPTY BEAKER
         CALL  HAVOBJ
         LBNE  DMSG022
POUR01_B:
         JMP   NOHAVE
POUR01_C:
         CMP   ROOM,40
         JNE   POUR01_D
         MOV   AL,84              ;CLOSED GRATE
         CALL  CKOBJ
         JE    POUR01_D
         MOV   AH,86              ;OPOEN GRATE
         CALL  XCHGOB
         CALL  CKDRAW
         MOV   AL,76              ;GRATE ACROSS STREAM IN RM 31
         MOV   AH,75
         CALL  XCHGOB
POUR01_D:
         JMP   REPLY
POUR01   ENDP

;********************************************************************
;
;  VSET   - SET VERB PROCESSOR
;
;********************************************************************

VSET     PROC
         LEA   BX,NOUN
         MOV   AH,4
VSET_A:
         MOV   AL,[BX]
         INC   BX
         CMP   AL,'0'
         JB    VSET_D
         CMP   AL,'9'
         JA    VSET_D
         DEC   AH
         JNE   VSET_A
         MOV   AL,ROOM
         CMP   AL,17
         LBEQ  DMSG055
         CMP   AL,1
         LBNE  DMSG023
         LEA   BX,SETTAB
VSET_B:
         MOV   AL,[BX]
         CMP   AL,0
         JE    VSET_C
         CMP   AL,NOUNNO
         JE    VSET_C
         ADD   BX,2
         JMP   SHORT VSET_B
VSET_C:
         MOV   AL,[BX+1]
         MOV   SETNXT,AL
         LEA   BX,NOUN
         LEA   SI,MSG046A
         MOV   AH,4
         CALL  MOVE
         JMP   DMSG046
VSET_D:
         JMP   BADINP
VSET     ENDP

;********************************************************************
;
;  TOTRAP - SETUP FOR TRAP ROOM
;
;********************************************************************

TOTRAP   PROC
         MOV   AL,16
         JMP   EXITRM
TOTRAP   ENDP

;********************************************************************
;
;  INDARK - CHECK IF IN DARK ROUTINE
;
;********************************************************************

INDARK   PROC
         PUSH  AX
         PUSH  BX
         PUSH  SI
         MOV   AL,ROOM
         CMP   AL,19
         JE    INDARK_A
         CMP   AL,5
         JE    INDARK_B
INDARK_C:
         MOV   AL,1
INDARK_D:
         TEST  AL,0FFH
         POP   SI
         POP   BX
         POP   AX
         RET
INDARK_A:
         DISABLE
         MOV   SI,OFFSET SCRBLK
         CALL  SHOSCR
         CALL  CLSTXT
         LEA   BX,MSG071
         CALL  DISPLY
         ENABLE
         MOV   AL,0
         JMP   SHORT  INDARK_D
INDARK_B:
         TEST  LITESW,0FFH
         JE    INDARK_A
         JMP   SHORT INDARK_C
INDARK   ENDP

;********************************************************************
;
;  CHKPA  - PERFORMED FOR EACH OBJECT IN A "PUT ALL"
;
;********************************************************************

CHKPA    PROC
         CMP   AL,14              ;EMPTY BEAKER
         JE    CHKPA_A
         CMP   AL,15              ;BEAKER FULL OF ACID
         JE    CHKPA_A
         CMP   AL,9               ;WEARING SPACE SUIT
         JNE   CHKPA_B
CHKPA_A:
         MOV   AL,0
CHKPA_B:
         TEST  AL,0FFH
         RET
CHKPA    ENDP

;********************************************************************
;
;  CHKGA  - PERFORMED FOR EACH OBJECT IN A "GET ALL"
;
;********************************************************************

CHKGA    PROC
         TEST  AL,0FFH
         RET
CHKGA    ENDP

;********************************************************************
;
;  ECHMOV - ROUTINE PERFORMED AFTER EACH VALID MOVE
;
;********************************************************************

ECHMOV   PROC
         PUSH  AX
         PUSH  BX
         MOV   AX,SCORE
         CMP   AX,25
         JNE   ECHMOV_A
         MOV   AL,20              ;MESSAGE
         CALL  FNDOBJ
         JNE   ECHMOV_A
         DISABLE
         MOV   AH,ROOM
         MOV   ROOM,4
         MOV   AL,20              ;MESSAGE
         CALL  PUTNRM
         MOV   ROOM,AH
         ENABLE
         LEA   BX,MSG042
         CALL  DISPLY
ECHMOV_A:
         MOV   AL,ROOM
         CMP   AL,8
         JB    ECHMOV_B
         CMP   AL,22
         JA    ECHMOV_B
         MOV   AL,9               ;WEARING SUIT
         CALL  HAVOBJ
         JNE   ECHMOV_B
         LEA   BX,MSG073
         CALL  DISPLY
         JMP   ENDGAM
ECHMOV_B:
         MOV   AL,ROOM
         CMP   AL,18
         JE    ECHMOV_D
         CMP   AL,8
         JB    ECHMOV_C
         CMP   AL,11
         JB    ECHMOV_D
ECHMOV_C:
         MOV   AL,12              ;BLANKET WITH ICE
         CALL  HAVOBJ
         JE    ECHMOV_D
         MOV   AL,RANDOM
         CMP   AL,60
         JA    ECHMOV_D
         LEA   BX,MSG079
         CALL  DISPLY
ECHMOV_D:
         TEST  CAPSW,0FFH
         JE    ECHMOV_H
         DEC   CAPSW
         MOV   AL,CAPSW
         CMP   AL,0
         JE    ECHMOV_G
         CMP   AL,2
         JA    ECHMOV_H
         JE    ECHMOV_E
         LEA   BX,MSG089
         JMP   SHORT ECHMOV_F
ECHMOV_E:
         LEA   BX,MSG090
ECHMOV_F:
         CALL  DISPLY
         JMP   SHORT ECHMOV_H
ECHMOV_G:
         CALL  UNCONS
ECHMOV_H:
         TEST  SPIDSW,0FFH
         JE    ECHMOV_I
         DEC   SPIDSW
         JNE   ECHMOV_I
         MOV   AL,28
         MOV   AH,29
         CALL  XCHGOB
ECHMOV_I:
         POP   BX
         POP   AX
         RET
ECHMOV   ENDP

;********************************************************************
;
;  UNCONS - PROCESS UNCONSCIOUS
;
;********************************************************************

UNCONS   PROC
         MOV   CAPSW,3
         CALL  CLSTXT
         DISABLE
         MOV   AL,54
         CALL  SHOOVL
         MOV   AL,ROOM
         PUSH  AX
         MOV   ROOM,0
UNCONS_A:
         LEA   BX,MSG091
         CALL  DISPLY
         LEA   BX,MSG000
         CALL  DISPLY
         CALL  GETLIN
         INC   SCORE
         DEC   CAPSW
         JNE   UNCONS_A
         POP   AX
         MOV   ROOM,AL
         CALL  DRAWSC
         CALL  CLSTXT
         LEA   BX,MSG092
         CALL  DISPLY
         RET
UNCONS   ENDP

;********************************************************************
;
;  ENTR07 - SPECIAL ROOM ENTRY ROUTINE
;
;********************************************************************

ENTR07   PROC
         MOV   AL,30              ;LIVE PLANT
         CALL  HAVOBJ
         JNE   ENTR07_C
         MOV   AL,31              ;DEAD PLANT
         CALL  HAVOBJ
         JNE   ENTR07_A
         LEA   BX,MSG102
         JMP   SHORT ENTR07_B
ENTR07_A:
         LEA   BX,MSG103
ENTR07_B:
         CALL  DISPLY
         LEA   BX,MSG104
         JMP   SHORT ENTR07_D
ENTR07_C:
         LEA   BX,MSG027
ENTR07_D:
         CALL  DISPLY
         JMP   ENDGAM
ENTR07   ENDP

;********************************************************************
;
;  ENTR26 - SPECIAL ROOM ENTRY ROUTINE
;
;********************************************************************

ENTR26   PROC
         PUSH  AX
         PUSH  BX
         TEST  BRIDSW,0FFH
         JE    ENTR26_A
         MOV   BRIDSW,0
         LEA   BX,MSG086
         CALL  DISPLY
         CMP   ROOM,32
         JNE   ENTR26_A
         DISABLE
         MOV   ROOM,28
         MOV   AL,77              ;STONES IN LAVA
         CALL  PUTNRM
         MOV   ROOM,31
         CALL  PUTNRM
         MOV   ROOM,32
         ENABLE
ENTR26_A:
         POP   BX
         POP   AX
         RET
ENTR26   ENDP

;********************************************************************
;
;  ENTR33 - SPECIAL ROOM ENTRY ROUTINE
;
;********************************************************************

ENTR33   PROC
         PUSH  AX
         PUSH  BX
         CMP   OBJCNT,4
         JB    ENTR33_B
ENTR33_A:
         JMP   INRM33
ENTR33_B:
         MOV   AL,8               ;SPACE SUIT
         CALL  HAVOBJ
         JNE   ENTR33_A
         MOV   AL,9               ;WEAR SUIT
         CALL  HAVOBJ
         JNE   ENTR33_A
         LEA   BX,MSG085
         CALL  DISPLY
         POP   BX
         POP   AX
         RET
ENTR33   ENDP

;********************************************************************
;
;  ENTR39 - SPECIAL ROOM ENTRY ROUTINE
;
;********************************************************************

ENTR39   PROC
         TEST  DOORSW,0FFH
         JE    ENTR39_A
         LEA   BX,MSG101
         CALL  DISPLY
         JMP   ENDGAM
ENTR39_A:
         RET
ENTR39   ENDP

;********************************************************************
;
;  EXIT03 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT03   PROC
         PUSH  AX
         CMP   AH,5
         JA    EXIT03_A
         MOV   AL,120
         MOV   AH,0
         CALL  CHGOBJ
EXIT03_A:
         POP   AX
         RET
EXIT03   ENDP

;********************************************************************
;
;  EXIT08 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT08   PROC
         PUSH  AX
         PUSH  CX
         CMP   AH,8
         JB    EXIT08_D
         CMP   AH,10
         JA    EXIT08_D
         MOV   AL,ROOM
         CMP   AL,3
         JE    EXIT08_D
         CMP   AL,18
         JE    EXIT08_D
         DISABLE
         MOV   ROOM,AH
         MOV   AL,53
         CALL  SHOOVL
         MOV   AL,19
         CALL  SHOOVL
         MOV   AL,46
         CALL  SHOOVL
         MOV   AL,17
         CALL  SHOOVL
         INC   AL
         CALL  SHOOVL
         CALCX 60,1
         MOV   CL,64
         MOV   AL,NOUNNO
         AND   AL,1
         JNE   EXIT08_B
EXIT08_A:
         CALCD 60,1,77,128
         CALL  SCRRIT
         DEC   CL
         JNE   EXIT08_A
         JMP   SHORT EXIT08_C
EXIT08_B:
         CALCD 60,1,77,128
         CALL  SCRLFT
         DEC   CL
         JNE   EXIT08_B
EXIT08_C:
         CALL  CLSTXT
         JMP   VLOOK2
EXIT08_D:
         POP   CX
         POP   AX
         RET
EXIT08   ENDP

;********************************************************************
;
;  EXIT11 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT11   PROC
         PUSH  AX
         PUSH  CX
         CMP   AH,11
         JB    EXIT11_D
         CMP   AH,14
         JA    EXIT11_D
         CMP   ROOM,3
         JE    EXIT11_D
         DISABLE
         MOV   ROOM,AH
         MOV   AL,33
EXIT11_E:
         CALL  SHOOVL
         INC   AL
         CMP   AL,38
         JB    EXIT11_E
         CALCX 51,1
         MOV   CL,64
         MOV   AL,NOUNNO
         AND   AL,1
         JNE   EXIT11_B
EXIT11_A:
         CALCD 51,1,82,128
         CALL  SCRRIT
         DEC   CL
         JNE   EXIT11_A
         JMP   SHORT EXIT11_C
EXIT11_B:
         CALCD 51,1,82,128
         CALL  SCRLFT
         DEC   CL
         JNE   EXIT11_B
EXIT11_C:
         CALL  CLSTXT
         JMP   VLOOK2
EXIT11_D:
         POP   CX
         POP   AX
         RET
EXIT11   ENDP

;********************************************************************
;
;  EXIT33 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT33   PROC
         PUSH  AX
         INC   BRIDSW
         MOV   AL,91
         MOV   AH,90
         CALL  XCHGOB
         POP   AX
         RET
EXIT33   ENDP

;********************************************************************
;
;  EXIT35 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT35   PROC
         PUSH  AX
         CMP   AH,41
         JE    EXIT35_A
         MOV   AL,28
         CALL  CKOBJ
         LBNE  DMSG096
EXIT35_A:
         POP   AX
         RET
EXIT35   ENDP

;********************************************************************
;
;  EXIT38 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT38   PROC
         PUSH  AX
         CMP   AH,40
         JNE   EXIT38_A
         MOV   AL,29
         CALL  FNDOBJ
         LBEQ  EXIT38_A
         JNS   EXIT38_Z
         JMP   EXIT38_B
EXIT38_Z:
         MOV   AL,29
         MOV   AH,0
         CALL  XCHGOB
         MOV   ROOM,40
         MOV   AL,28
         CALL  PUTNRM
EXIT38_A:
         POP   AX
         RET
EXIT38_B:
         JMP   GET06A
EXIT38   ENDP

;********************************************************************
;
;  EXIT40 - SPECIAL ROOM EXIT ROUTINE
;
;********************************************************************

EXIT40   PROC
         PUSH  AX
         CMP   AH,28
         JNE   EXIT40_A
         MOV   AL,AH
         CALL  CKOBJ
         LBNE  DMSG096
EXIT40_A:
         POP   AX
         RET
EXIT40   ENDP

;********************************************************************
;
;  INRM33 - SPECIAL IN ROOM ROUTINE
;
;********************************************************************

INRM33   PROC
         MOV   AL,91
         MOV   AH,0
         CALL  CHGOBJ
         CALL  CLSTXT
         CALL  DRAWSC
         LEA   BX,MSG084
         CALL  DISPLY
         JMP   ENDGAM
INRM33   ENDP

;********************************************************************
;
;  INRM35 - SPECIAL IN ROOM ROUTINE
;
;********************************************************************

INRM35   PROC
         PUSH  AX
         MOV   AL,28
         CALL  CKOBJ
         JE    INRM35_A
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,15
         JA    INRM35_A
         JMP   GET06A
INRM35_A:
         POP   AX
         RET
INRM35   ENDP

;********************************************************************
;
;  ADVENTURE UNIQUE ANTIMATION ROUTINES
;
;********************************************************************

;        BLINK LIGHTS IN CONTROL ROOM

MOVLIT   PROC
         INC   FLIPSW
         MOV   AL,FLIPSW
         CMP   AL,5
         JB    MOVLIT_A
         MOV   FLIPSW,0
         MOV   AL,RANDOM
         PUSH  AX
         AND   AL,3
         MOV   COLOR1,AL
         POP   AX
         SHR   AL,1
         SHR   AL,1
         SHR   AL,1
         AND   AL,3
         CMP   AL,COLOR1
         JNE   MOVLIT_B
         INC   AL
         AND   AL,3
MOVLIT_B:
         MOV   COLOR2,AL
         CALCX 50,33
         CALCD 50,33,54,92
         CALL  FLPCLR
MOVLIT_A:
         RET
MOVLIT   ENDP

;        FLIP TELEPORT WINDOW

MOVWIN   PROC
         MOV   AL,120             ;TELEPORT WINDOW
         CALL  CKOBJ
         JE    MOVWIN_C
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,8
         JB    MOVWIN_C
         MOV   FLIPCT,0
         XOR   FLIPSW,1
         JZ    MOVWIN_A
         MOV   AL,14              ;TELEPORT WINDOW OVERLAY #1
         JMP   SHORT MOVWIN_B
MOVWIN_A:
         MOV   AL,13              ;TELEPORT WINDOW OVERLAY #2
MOVWIN_B:
         CALL  SHOOVL
MOVWIN_C:
         RET
MOVWIN   ENDP

;        MOVE TELEPORT CONTROLS

MOVTEL   PROC
         CALCX 4,49
         CALCD 4,49,12,64
         CALL  SCRRIT
         CALCX 4,65
         CALL  SCRLFT
         CALCX 10,105
         CALCD 10,105,65,112
         CALL  SCRUP
         INC   FLP2SW
         MOV   AL,FLP2SW
         CMP   AL,6
         JB    MOVWIN
         MOV   FLP2SW,0
         MOV   COLOR1,WHITE
         MOV   COLOR2,RED
         CALCX 42,61
         CALCD 42,61,43,72
         CALL  FLPCLR
         MOV   COLOR2,BLUE
         CALCX 8,49
         CALCD 8,49,8,80
         CALL  FLPCLR
         JMP   SHORT MOVWIN
MOVTEL   ENDP

;        MOVE LIGHTS IN COMMUNICATIONS ROOM

MOVCOM   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,5
         JB    MOVCOM_A
         MOV   FLIPCT,0
         MOV   COLOR1,RED
         MOV   COLOR2,BLUE
         CALCX 34,85
         CALCD 34,85,36,96
         CALL  FLPCLR
         CALCX 50,61
         MOV   AL,100             ;ROBOT WITHOUT CART.
         CALL  CKOBJ
         JE    MOVCOM_B
         CALCX 50,21
MOVCOM_B:
         CALCD 50,21,54,28
         CALL  FLPCLR
MOVCOM_A:
         RET
MOVCOM   ENDP

;        MOVE LAVA AS SEEN FROM ON BRIDGE

MOVLV1   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,4
         JB    MOVLV1_A
         MOV   FLIPCT,0
         MOV   AL,91              ;BRIDGE
         CALL  CKOBJ
         JNE   MOVLV1_B
         CALCD 32,1,54,128
         JMP   SHORT MOVLV1_C
MOVLV1_B:
         CALCX 32,73
         CALCD 32,73,54,128
         CALL  SCRLFT
         CALCD 32,1,54,48
MOVLV1_C:
         CALCX 32,1
         CALL  SCRLFT
MOVLV1_A:
         RET
MOVLV1   ENDP

;        MOVE FORCE FIELD ON GARDEN PLANET

MOVFOR   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,5
         JB    MOVFOR_C
         MOV   FLIPCT,0
         XOR   FLIPSW,1
         JZ    MOVFOR_A
         MOV   AL,127             ;FORCE FIELD OVERLAY #1
         JMP   SHORT MOVFOR_B
MOVFOR_A:
         MOV   AL,148             ;FORCE FIELD OVERLAY #2
MOVFOR_B:
         CALL  SHOOVL
MOVFOR_C:
         RET
MOVFOR   ENDP

;        MOVE SPIDERS MOUTH

MOVSPI   PROC
         MOV   AL,28              ;SPIDER
         CALL  CKOBJ
         JE    MOVSPI_E
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,5
         JB    MOVSPI_E
         MOV   FLIPCT,0
         MOV   AL,FLIPSW
         CMP   AL,0
         JE    MOVSPI_A
         DEC   AL
         JZ    MOVSPI_B
         MOV   AL,112             ;SPIDER MOUTH #1
         MOV   FLIPSW,0
         JMP   SHORT MOVSPI_D
MOVSPI_A:
         MOV   AL,108             ;SPIDER MOUTH #2
         JMP   SHORT MOVSPI_C
MOVSPI_B:
         MOV   AL,111             ;SPIDER MOUTH #3
MOVSPI_C:
         INC   FLIPSW
MOVSPI_D:
         CALL  SHOOVL
MOVSPI_E:
         RET
MOVSPI   ENDP

;        BLINK LIGHT OVER DOOR OUTSIDE PLANT ROOM

MOVDOR   PROC
         TEST  DOORSW,0FFH
         JZ    MOVDOR_A
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,3
         JB    MOVDOR_A
         MOV   FLIPCT,0
         MOV   COLOR1,RED
         MOV   COLOR2,BLACK
         CALCX 38,65
         CALCD 38,65,39,68
         CALL  FLPCLR
MOVDOR_A:
         RET
MOVDOR   ENDP

;        MOVE CLOUDS IN BOER CONTROL

MOVCLO   PROC
         INC   FLP2CT
         MOV   AX,FLP2CT
         CMP   AX,4
         JB    MOVCLO_A
         MOV   FLP2CT,0
         CALCX 17,25
         CALCD 17,25,24,44
         CALL  SCRRIT
MOVCLO_A:
         JMP   MOVWIN
MOVCLO   ENDP

;        MOVE LAVA IN CHASM

MOVLAV   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,4
         JB    MOVLAV_C
         MOV   FLIPCT,0
         MOV   AL,77              ;STONES IN LAVA
         CALL  CKOBJ
         JE    MOVLAV_A
         CALCX 71,1
         CALCD 71,1,80,40
         CALL  SCRLFT
         CALCX 71,49
         CALCD 71,49,80,128
         JMP   SHORT MOVLAV_B
MOVLAV_A:
         CALCX 71,1
         CALCD 71,1,80,128
MOVLAV_B:
         CALL  SCRLFT
MOVLAV_C:
         RET
MOVLAV   ENDP

;********************************************************************
;
;  SHOW BOXES WHEN EXIT IS THRU TELEPORT WINDOW
;
;********************************************************************

SHOBOX   PROC
         PUSH  AX
         MOV   AX,FLIPCT          ;CURRENT BOX COLOR
         MOV   BX,90              ;80 + 8 + 2
         MOV   CL,30
         MOV   CH,43
SHOBOX_A:
         CALL  DRWBOX
         ADD   BX,162
         SUB   CL,2
         JS    SHOBOX_B
         SUB   CH,4
         JS    SHOBOX_B
         JMP   SHORT SHOBOX_A
SHOBOX_B:
         CMP   AL,WHITE@B
         JNE   SHOBOX_C
         MOV   AL,BLACK@B
         JMP   SHORT SHOBOX_D
SHOBOX_C:
         ADD   AL,055H
SHOBOX_D:
         MOV   AH,AL
         MOV   FLIPCT,AX
         POP   AX
         RET
SHOBOX   ENDP

;        AX = COLOR OF BOX
;        BX = SCREEN OFFSET OF UPPER LEFT HAND CORNER
;        CH = # OF LINES DOWN OUTER BOX / 2
;        CL = # OF LINES ACROSS OUTER BOX

DRWBOX   PROC
         PUSH  AX
         PUSH  BX
         PUSH  CX
         PUSH  DX
         MOV   DX,CX
DRWBOX_B:
         MOV   GSCRN1@W [BX],AX
         DEC   CL
         JZ    DRWBOX_C
         INC   BX
         INC   BX
         JMP   SHORT DRWBOX_B
DRWBOX_C:
         AND   AL,00001111B
DRWBOX_D:
         MOV   GSCRN2+1 [BX],AL
         ADD   BX,80
         DEC   CH
         JZ    DRWBOX_E
         MOV   GSCRN1+1 [BX],AL
         JMP   SHORT DRWBOX_D
DRWBOX_E:
         MOV   CX,DX
         MOV   AL,AH
DRWBOX_F:
         MOV   GSCRN1@W [BX],AX
         DEC   CL
         JZ    DRWBOX_G
         DEC   BX
         DEC   BX
         JMP   SHORT DRWBOX_F
DRWBOX_G:
         AND   AL,11110000B
DRWBOX_H:
         SUB   BX,80
         MOV   GSCRN2 [BX],AL
         DEC   CH
         JZ    DRWBOX_I
         MOV   GSCRN1 [BX],AL
         JMP   SHORT DRWBOX_H
DRWBOX_I:
         MOV   CX,6000
DRWBOX_J:
         LOOP  DRWBOX_J
         POP   DX
         POP   CX
         POP   BX
         POP   AX
         RET
DRWBOX   ENDP

;        END FILE = ADVCODE2/ASM

