;
;        FILE: ADVDATA2.ASM
;

;        VERB TABLE

VERBTB   DB    'LOOK',1
         DB    'L   ',1
         DB    'EXAM',1
         DB    'INVE',2
         DB    'I   ',2
         DB    'G   ',3
         DB    'GET ',3
         DB    'TAKE',3
         DB    'GRAB',3
         DB    'PUT ',4
         DB    'DROP',4
         DB    'P   ',4
         DB    'THRO',4
         DB    'NORT',5
         DB    'N   ',5
         DB    'SOUT',6
         DB    'S   ',6
         DB    'EAST',7
         DB    'E   ',7
         DB    'WEST',8
         DB    'W   ',8
         DB    'UP  ',9
         DB    'U   ',9
         DB    'DOWN',10
         DB    'D   ',10
         DB    'GO  ',11
         DB    'WALK',11
         DB    'RUN ',11
         DB    'SAVE',12
         DB    'LOAD',13
         DB    'HELP',14
         DB    'SCOR',15
         DB    'QUIT',16
         DB    'CLIM',17
         DB    'OPEN',18
         DB    'WEAR',19
         DB    'READ',20
         DB    'REMO',21
         DB    'SET ',22
         DB    'PRES',23
         DB    'PUSH',23
         DB    'CLOS',24
         DB    'FOLD',25
         DB    'UNFO',26
         DB    'DRIN',27
         DB    'FILL',28
         DB    'INSE',29
         DB    'POUR',30
         DB    'EMPT',31
         DB    'UNLO',32
         DB    'DIG ',33
         DB    'CHOP',34
         DB    'CUT ',34
         DB    'PULL',35
         DB    'CROS',36
         DB    'EAT ',37
         DB    'CHEW',37
         DB    'FEED',38
         DB    'GIVE',38
         DB    'TIE ',39
         DB    'UNTI',40
         DB    0

;        NOUN TABLE

NOUNTB   DB    'NORT',1
         DB    'SOUT',2
         DB    'EAST',3
         DB    'WEST',4
         DB    'UP  ',5
         DB    'DOWN',6
         DB    'INVE',7
         DB    'SUIT',8
         DB    'AD  ',10
         DB    'ADVE',10
         DB    'LEAF',10
         DB    'KEY ',11
         DB    'MANU',13
         DB    'INST',13
         DB    'BEAK',14
         DB    'GLAS',14
         DB    'BLAN',16
         DB    'PILL',17
         DB    'COMM',20
         DB    'MESS',20
         DB    'MAP ',21
         DB    'SHOV',23
         DB    'CANT',24
         DB    'AMUL',25
         DB    'CART',26
         DB    'CAPS',27
         DB    'SPID',28
         DB    'PLAN',30
         DB    'XEND',30
         DB    'ROPE',32
         DB    'STON',77
         DB    'RUBB',77
         DB    'LAVA',82
         DB    'STRE',82
         DB    'FORC',83
         DB    'FIEL',83
         DB    'GRAT',84
         DB    'DOOR',85
         DB    'DRAW',87
         DB    'CHAS',88
         DB    'TREE',89
         DB    'BRID',91
         DB    'SHIP',95
         DB    'WREC',95
         DB    'ICE ',96
         DB    'WHIT',97
         DB    'CENO',98
         DB    'ROBO',99
         DB    'SKEL',101
         DB    'BONE',101
         DB    'LIQU',102
         DB    'ACID',102
         DB    'EMER',105
         DB    'HATC',105
         DB    'VIEW',107
         DB    'SCRE',107
         DB    '8350',108
         DB    '7112',109
         DB    '3816',110
         DB    '1042',111
         DB    'PLAQ',113
         DB    'PIPE',114
         DB    'SUNL',115
         DB    'LAMP',115
         DB    'BUTT',117
         DB    'POCK',118
         DB    'LADD',119
         DB    'WIND',120
         DB    'TELE',120
         DB    'BLUE',121
         DB    'SIGN',122
         DB    'RED ',123
         DB    'PANE',124
         DB    'BARR',126
         DB    'CABI',127
         DB    'ALL ',128
         DB    'EVER',128
         DB    0

; SPECIAL ACTION TABLE. LISTS VERB/NOUN COMBO'S THAT HAVE SPECIAL
; PROCESSING ROUTINES.
;
;  # BYTES       DESCRIPTION
;  -------   ------------------
;     1      VERB NUMBER
;     1      NOUN NUMBER
;     2      SPECIAL RTN ADDR

SPCRTN   DW    017FH,LOOK01       ;LOOK CABINET
         DW    0176H,LOOK02       ;LOOK POCKET
         DW    016BH,LOOK03       ;LOOK SCREEN
         DW    0177H,LOOK04       ;LOOK LADDER
         DW    0157H,LOOK05       ;LOOK DRAWER
         DW    0161H,LOOK06       ;LOOK WHITE
         DW    0175H,DMSG048      ;LOOK BUTTON
         DW    0307H,VINVE        ;TAKE INVENTORY
         DW    0365H,GET01        ;GET SKELETON
         DW    0366H,GET02        ;GET LIQUID
         DW    031AH,GET03        ;GET CARTRIDGE
         DW    0377H,GET04        ;GET LADDER
         DW    0360H,GET05        ;GET ICE
         DW    031CH,GET06        ;GET SPIDER
         DW    0320H,GET07        ;GET ROPE
         DW    0361H,GET08        ;GET WHITE
         DW    0375H,DMSG048      ;GET BUTTON
         DW    0376H,DMSG026      ;GET POCKET
         DW    0408H,PUT01        ;PUT SUIT
         DW    040EH,PUT02        ;PUT BEAKER
         DW    0410H,PUT03        ;PUT BLANKET
         DW    0B77H,GO01         ;GO LADDER
         DW    0B78H,GO02         ;GO WINDOW
         DW    0B69H,GO03         ;GO HATCH
         DW    0B62H,GO04         ;GO CENOTAPH
         DW    0B5BH,GO05         ;GO BRIDGE
         DW    0B59H,GO06         ;GO TREE
         DW    0B53H,GO07         ;GO FORCE
         DW    0B55H,GO08         ;GO DOORWAY
         DW    0B54H,GO09         ;GO GRATE
         DW    0B4DH,GO10         ;GO STONES
         DW    0B20H,GO11         ;GO ROPE
         DW    0B52H,GO12         ;GO LAVA
         DW    1177H,GO01         ;CLIMB LADDER
         DW    1162H,GO04         ;CLIMB CENOTAPH
         DW    1159H,GO06         ;CLIMB TREE
         DW    1120H,GO11         ;CLIMB ROPE
         DW    120DH,OPEN01       ;OPEN MANUAL
         DW    1269H,OPEN02       ;OPEN HATCH
         DW    1215H,OPEN03       ;OPEN MAP
         DW    127CH,UNLK02       ;OPEN PANEL
         DW    1415H,LOOKOB       ;READ MAP
         DW    151AH,REMO01       ;REMOVE CART
         DW    1779H,PRES01       ;PRESS BLUE
         DW    177BH,PRES02       ;PRESS RED
         DW    1761H,PRES03       ;PRESS WHITE
         DW    1775H,DMSG048      ;PRESS BUTTON
         DW    1869H,CLOS01       ;CLOSE HATCH
         DW    1815H,CLOS02       ;CLOSE MAP
         DW    187FH,CLOS03       ;CLOSE CABINET
         DW    187CH,CLOS04       ;CLOSE PANEL
         DW    1915H,CLOS02       ;FOLD MAP
         DW    1A15H,OPEN03       ;UNFOLD MAP
         DW    1B66H,DRIN01       ;DRINK LIQUID
         DW    1E0EH,POUR01       ;POUR BEAKER
         DW    1E66H,POUR01       ;POUR ACID
         DW    1F0EH,POUR01       ;EMPTY BEAKER
         DW    207FH,UNLK01       ;UNLOCK CABINET
         DW    207CH,UNLK02       ;UNLOCK PANEL
         DW    2260H,VDIG         ;CHOP ICE
         DW    231AH,REMO01       ;PULL CART
         DW    245BH,GO05         ;CROSS BRIDGE
         DW    261CH,FEED01       ;FEED SPIDER
         DW    0

; SPECIAL ACTION ON ENTRY TO A ROOM TABLE

ENTRTB   DB    07
         DW    ENTR07
         DB    26
         DW    ENTR26
         DB    32
         DW    ENTR26
         DB    33
         DW    ENTR33
         DB    39
         DW    ENTR39
         DB    0

; SPECIAL ACTION ON EXIT FROM A ROOM TABLE

EXITTB   DB    3
         DW    EXIT03
         DB    8
         DW    EXIT08
         DB    9
         DW    EXIT08
         DB    10
         DW    EXIT08
         DB    11
         DW    EXIT11
         DB    12
         DW    EXIT11
         DB    13
         DW    EXIT11
         DB    14
         DW    EXIT11
         DB    33
         DW    EXIT33
         DB    35
         DW    EXIT35
         DB    38
         DW    EXIT38
         DB    40
         DW    EXIT40
         DB    0

; SPECIAL ACTION FOR COMMANDS GIVEN IN A ROOM

INRMTB   DB    33
         DW    INRM33
         DB    35
         DW    INRM35
         DB    40
         DW    INRM35
         DB    0

; GENERAL LOOK OBJECT MESSAGE TABLE
;
; FMT:     OBJ#
;          MSG# IF CARRYING
;          MSG# IF IN ROOM

OBJMSG   DB    8,30,30            ;SPACE SUIT
         DB    9,30,0             ;WEARING SUIT
         DB    10,45,10           ;LEAFLET
         DB    12,113,113         ;BLANKET W/ICE
         DB    13,39,10           ;CLOSED MANUAL
         DB    14,22,22           ;EMPTY BEAKER
         DB    16,29,29           ;BLANKET
         DB    17,28,28           ;PILLOW
         DB    19,40,10           ;OPEN MANUAL
         DB    20,41,10           ;MESSAGE
         DB    21,56,10           ;FOLDED MAP
         DB    22,57,10           ;OPEN MAP
         DB    27,88,10           ;YELLOW CAPSULE
         DB    28,105,105         ;SPIDER
         DB    29,100,100         ;UNCON SPIDER
         DB    30,111,111         ;PLANT
         DB    31,112,112         ;DEAD PLANT
         DB    75,0,109           ;GRATE ACROSS STREAM
         DB    76,0,109           ;GRATE ACROSS STREAM
         DB    80,0,108           ;ROPE OVER CHASM
         DB    81,0,107           ;ROPE TO TREE
         DB    85,0,18            ;DOORWAY
         DB    86,0,18            ;OPEN GRATE
         DB    87,0,22            ;OPEN DRAWER
         DB    90,0,83            ;CRUMBLED BRIDGE
         DB    92,0,49            ;VIEW SCREEN
         DB    93,0,82            ;ROBOT
         DB    94,0,81            ;FULL BARREL
         DB    98,0,114           ;CENOTAPH
         DB    99,0,70            ;ROBOT
         DB    100,0,69           ;ROBOT
         DB    101,0,65           ;SKELETON
         DB    102,0,66           ;POOL OF ACID
         DB    103,0,49           ;VIEW SCREEN
         DB    104,0,16           ;CLOSED HATCH
         DB    105,0,18           ;OPEN HATCH
         DB    106,0,49           ;VIEW SCREEN
         DB    107,0,50           ;VIEW SCREEN
         DB    112,0,54           ;VELDBOER PLAQUE
         DB    113,0,37           ;TREKBOER PLAQUE
         DB    124,0,58           ;OPEN PANEL
         DB    125,0,17           ;LOCKED PANEL
         DB    126,0,68           ;EMPTY BARREL
         DB    0

; OBJECT EQUATE TABLE DEFINES
; OBJECTS THAT MAY HAVE MULTIPLE
; OBJECT NUMBERS.
;
; FORMAT:         DB    X,Y,Y,Y,Y
;  WHERE: X = PRIMARY OBJ #
;         Y = SECONDARY OBJ #
;             OR ZERO FOR NONE

EQUTAB   DB    8,9,0              ;SPACE SUIT
         DB    16,12,0            ;BLANKET
         DB    13,19,0            ;MANUAL
         DB    14,18,15,0         ;GLASS BEAKER
         DB    21,22,0            ;MAP
         DB    28,29,0            ;SPIDER
         DB    30,31,0            ;PLANT
         DB    32,80,81,78,0      ;ROPE
         DB    84,86,75,76,0      ;GRATE
         DB    91,90,0            ;BRIDGE
         DB    99,100,93,0        ;ROBOT
         DB    105,104,0          ;EMER HATCH
         DB    107,106,103,92,0   ;VIEW SCR
         DB    113,112,0          ;PLAQUE
         DB    114,126,94,0       ;PIPES
         DB    127,116,0          ;CABINET
         DB    124,125,0          ;PANEL
         DB    126,94,0           ;BARREL
         DB    0

; DEFINE OBJECTS THAT SHOULD
; BE REFERRED TO AS "THEM"
;
; FORMAT IS: OBJ#,TYPE
;      WHERE TYPE IS:
;     0 = IT    1 = THEM
;     2 = HER   3 = HIM
;     4 = ONE

THEMTB   DB    89,4
         DB    114,1
         DB    115,1
         DB    0

; LITERAL TABLE FOR IT,THEM,HIM
; HER MESSAGES.

LITTAB   DB    'it.',0
         DB    'them.',0
         DB    'her.',0
         DB    'him.',0
         DB    'one.',0

; ROOM TABLE.  DEFINES THE
; LAYOUT OF THE ADVENTURE. EACH
; ENTRY HAS THE FOLLOWING
; FORMAT:
;
; # BYTES        DESCRIPTION
; -------   -------------------
;    1      ROOM # TO NORTH
;    1      ROOM # TO SOUTH
;    1      ROOM # TO EAST
;    1      ROOM # TO WEST
;    1      ROOM # UP
;    1      ROOM # DOWN

;ROOM 1
RMTBDF   DB    0,5,3,4,0,0
;ROOM 2
         DB    0,0,3,4,0,0
;ROOM 3
         DB    2,5,0,1,0,0
;ROOM 4
         DB    2,5,1,0,0,0
;ROOM 5
         DB    1,0,3,4,0,0
;ROOM 6
         DB    0,0,0,0,0,1
;ROOM 7
         DB    0,0,0,0,0,0
;ROOM 8
         DB    9,9,8,8,0,0
;ROOM 9
         DB    9,9,9,10,0,0
;ROOM 10
         DB    8,10,10,10,0,0
;ROOM 11
         DB    11,12,11,0,0,0
;ROOM 12
         DB    11,12,14,12,0,0
;ROOM 13
         DB    0,14,12,0,0,0
;ROOM 14
         DB    13,0,0,12,0,0
;ROOM 15
         DB    0,0,0,0,0,17
;ROOM 16
         DB    0,0,0,0,0,0
;ROOM 17
         DB    0,19,20,22,0,0
;ROOM 18
         DB    0,0,0,0,0,10
;ROOM 19
         DB    17,0,20,22,0,0
;ROOM 20
         DB    21,19,0,17,0,0
;ROOM 21
         DB    0,0,20,22,0,0
;ROOM 22
         DB    21,19,17,0,0,0
;ROOM 23
         DB    26,23,23,24,0,0
;ROOM 24
         DB    25,23,23,25,0,0
;ROOM 25
         DB    25,23,24,25,0,0
;ROOM 26
         DB    0,25,27,26,0,0
;ROOM 27
         DB    0,23,27,26,0,0
;ROOM 28
         DB    0,0,29,0,0,0
;ROOM 29
         DB    0,0,0,28,0,0
;ROOM 30
         DB    0,0,0,31,0,0
;ROOM 31
         DB    0,0,30,0,0,0
;ROOM 32
         DB    0,0,0,0,0,0
;ROOM 33
         DB    32,26,0,0,0,0
;ROOM 34
         DB    41,0,0,0,0,0
;ROOM 35
         DB    0,36,41,37,0,0
;ROOM 36
         DB    35,0,0,38,0,0
;ROOM 37
         DB    0,38,35,0,0,0
;ROOM 38
         DB    37,40,36,0,0,0
;ROOM 39
         DB    0,0,0,0,0,0
;ROOM 40
         DB    38,0,0,0,0,0
;ROOM 41
         DB    0,34,0,35,0,0

; ROOM OBJECTS TABLE
; EACH VARIABLE LENGTH ENTRY
; DELIMITED BY $00

;ROOM 1
RMOBDF   DB    113,121,123,119,107,0
;ROOM 2
         DB    127,14,8+INV,16+INV,17+INV,0
;ROOM 3
         DB    121,0
;ROOM 4
         DB    19,100,121,27+INV,32+INV,0
;ROOM 5
         DB    115,114,0
;ROOM 6
         DB    126,125,104,0
;ROOM 7
         DB    120,79,0
;ROOM 8
         DB    120,0
;ROOM 9
         DB    0
;ROOM 10
         DB    98,0
;ROOM 11
         DB    120,0
;ROOM 12
         DB    0
;ROOM 13
         DB    102,101,0
;ROOM 14
         DB    95,105,24,0
;ROOM 15
         DB    126,124,105,23,0
;ROOM 16
         DB    0
;ROOM 17
         DB    112,121,123,119,21,0
;ROOM 18
         DB    25,0
;ROOM 19
         DB    0
;ROOM 20
         DB    121,0
;ROOM 21
         DB    116,0
;ROOM 22
         DB    93,121,0
;ROOM 23
         DB    89,0
;ROOM 24
         DB    89,120,0
;ROOM 25
         DB    89,0
;ROOM 26
         DB    88,89,91,0
;ROOM 27
         DB    88,89,0
;ROOM 28
         DB    82,86,0
;ROOM 29
         DB    82,0
;ROOM 30
         DB    82,0
;ROOM 31
         DB    82,76,0
;ROOM 32
         DB    88,89,90,83,0
;ROOM 33
         DB    91,0
;ROOM 34
         DB    85,123,0
;ROOM 35
         DB    28,0
;ROOM 36
         DB    0
;ROOM 37
         DB    0
;ROOM 38
         DB    0
;ROOM 39
         DB    85,30,0
;ROOM 40
         DB    84,0
;ROOM 41
         DB    0
;RESERVE AREAS
         DB    10 DUP(0)
RMTBEND  DB    0

; ROOM DIRECTION TABLE USED DURING GAME PLAY
; SOURCE IS RMTBDF

ROOMTB   DB    RMOBDF - RMTBDF DUP (?)

; ROOM OBJECT TABLE USED DURING GAME PLAY
; SOURCE IS RMOBDF

RMOBT1   DB    RMTBEND - RMOBDF DUP (?)
RMOBT2   DB    0

; TREASURE POINT TABLE
;
; FORMAT:  DB    TREASURE,POINTS

PNTTAB   DB    0

SAVCOR   DB    '4299'

RMTB_LEN DW    $ - ROOMTB

; GRAPHIC SCREEN INDICATOR
; TABLE (BY ROOM)

;ROOM 1
SCRIND   DB    6,1,2,4,5,6,7,8,9,11,15,3,10,0
;ROOM 2
         DB    6,1,56,2,55,4,5,41,57,58,0
;ROOM 3
         DB    6,1,2,4,5,40,41,42,43,45,44,0
;ROOM 4
         DB    6,1,2,4,5,40,49,50,123,124,125,0
;ROOM 5
         DB    6,1,56,2,55,4,5,65,66,67,68,0
;ROOM 6
         DB    6,1,56,2,55,73,77,40,41,70,72,0
;ROOM 7
         DB    4,146,145,139,140,141,142,143,144,0
;ROOM 8
         DB    5,46,17,18,19,0
;ROOM 9
         DB    5,46,17,18,19,0
;ROOM 10
         DB    5,46,17,18,19,24,20,21,0
;ROOM 11
         DB    7,34,35,36,37,0
;ROOM 12
         DB    7,34,35,36,37,0
;ROOM 13
         DB    7,34,35,36,37,30,31,0
;ROOM 14
         DB    7,34,35,36,37,28,29,0
;ROOM 15
         DB    6,1,56,2,55,73,77,70,72,79,80,0
;ROOM 16
         DB    5,52,0
;ROOM 17
         DB    6,1,2,4,5,6,7,8,38,9,11,15,3,10,0
;ROOM 18
         DB    5,52,25,0
;ROOM 19
         DB    1,0
;ROOM 20
         DB    6,1,2,4,5,79,80,81,43,45,44,0
;ROOM 21
         DB    6,1,56,2,55,4,5,79,57,58,0
;ROOM 22
         DB    6,1,2,4,5,80,49,50,123,124,125,0
;ROOM 23
         DB    9,83,94,95,87,89,86,0
;ROOM 24
         DB    9,83,94,95,87,85,0
;ROOM 25
         DB    9,83,94,95,87,89,86,0
;ROOM 26
         DB    9,83,94,95,87,88,91,85,84,90,122,0
;ROOM 27
         DB    9,83,94,95,91,87,88,89,86,122,0
;ROOM 28
         DB    10,96,99,100,98,118,119,120,0
;ROOM 29
         DB    10,96,99,100,98,118,119,120,0
;ROOM 30
         DB    10,96,99,100,98,118,119,120,0
;ROOM 31
         DB    10,96,99,100,98,118,119,120,0
;ROOM 32
         DB    9,83,94,95,87,88,89,86,85,127,0
;ROOM 33
         DB    8,92,113,114,115,116,117,131,132,0
;ROOM 34
         DB    3,109,103,121,110,104,105,106,128,151,0
;ROOM 35
         DB    3,109,103,121,110,104,105,128,0
;ROOM 36
         DB    3,109,103,121,110,104,105,128,0
;ROOM 37
         DB    3,109,103,121,110,104,105,128,0
;ROOM 38
         DB    3,109,103,121,110,104,105,128,0
;ROOM 39
         DB    2,138,137,136,0
;ROOM 40
         DB    3,109,103,121,110,104,105,128,0
;ROOM 41
         DB    3,109,103,121,110,104,105,128,0

; ANTIMATION ROUTINES BY ROOM
;
; FORMAT: ROOM #,RTN VECTOR

ANTTAB   DB    1
         DW    MOVLIT
         DB    3
         DW    MOVTEL
         DB    4
         DW    MOVCOM
         DB    7
         DW    MOVCLO
         DB    8
         DW    MOVWIN
         DB    11
         DW    MOVWIN
         DB    24
         DW    MOVWIN
         DB    28
         DW    MOVLAV
         DB    29
         DW    MOVLAV
         DB    30
         DW    MOVLAV
         DB    31
         DW    MOVLAV
         DB    32
         DW    MOVFOR
         DB    33
         DW    MOVLV1
         DB    34
         DW    MOVDOR
         DB    35
         DW    MOVSPI
         DB    40
         DW    MOVSPI
         DB    0

; IF OBJECT DROPPED IN ROOM
; PUT IT IN ANOTHER ROOM TABLE
;
; FORMAT: CURR ROOM,NEW ROOM

PUTTAB   DB    0

; GRAPHIC SCREEN PNTR TABLE

SCRTAB   DW    SCRBLU,SCRBLK,SCRWHT,SCRRED,SCRSPC,SCRSHP
         DW    SCRDES,SCRBRG,SCRBRC,SCRRBC

; GRAPHIC OBJECT PNTR TABLE

SCROBJ   EQU   $
         DEFOVL OVL001,1,113
         DEFOVL OVL002,1,13
         DEFOVL OVL003,1,13
         DEFOVL OVL004,18,1
         DEFOVL OVL005,18,125
         DEFOVL OVL006,11,109
         DEFOVL OVL007,6,37
         DEFOVL OVL008,46,25
         DEFOVL OVL009,59,29
         DEFOVL OVL010,1,17
         DEFOVL OVL011,18,109
         DEFOVL OVL012,7,41
         DEFOVL OVL013,29,9
         DEFOVL OVL014,29,9
         DEFOVL OVL015,24,93
         DEFOVL OVL016,19,53
         DEFOVL OVL017,60,65
         DEFOVL OVL018,78,1
         DEFOVL OVL019,27,119
         DEFOVL OVL020,26,41
         DEFOVL OVL021,78,1
         DEFOVL OVL022,82,77
         DEFOVL OVL023,88,89
         DEFOVL OVL024,25,21
         DEFOVL OVL025,81,25
         DEFOVL OVL026,48,61
         DEFOVL OVL027,82,49
         DEFOVL OVL028,65,57
         DEFOVL OVL029,74,33
         DEFOVL OVL030,79,1
         DEFOVL OVL031,81,53
         DEFOVL OVL032,7,41
         DEFOVL SCRDES,1,1        ;#033
         DEFOVL OVL034,51,1       ;#034
         DEFOVL OVL034,51,65      ;#035
         DEFOVL OVL036,71,1
         DEFOVL OVL036,71,65      ;#037
         DEFOVL OVL038,50,33
         DEFOVL OVL039,19,53
         DEFOVL OVL040,17,29
         DEFOVL OVL040,17,73      ;#041
         DEFOVL OVL042,4,49
         DEFOVL OVL043,7,105
         DEFOVL OVL044,54,57
         DEFOVL OVL045,41,53
         DEFOVL OVL017,60,1       ;#046
         DEFOVL OVL047,37,17
         DEFOVL OVL048,80,37
         DEFOVL OVL049,8,73
         DEFOVL OVL050,8,77
         DEFOVL OVL051,41,85
         DEFOVL SCRSPC,32,1       ;#052
         DEFOVL SCRSPC,1,1        ;#053
         DEFOVL SCRBLK,1,1        ;#054
         DEFOVL OVL055,1,1
         DEFOVL OVL056,1,113
         DEFOVL OVL057,15,29
         DEFOVL OVL058,15,53
         DEFOVL OVL059,70,57
         DEFOVL OVL060,77,69
         DEFOVL OVL061,67,88
         DEFOVL OVL062,69,109
         DEFOVL OVL063,16,29
         DEFOVL OVL064,15,25
         DEFOVL OVL065,12,9
         DEFOVL OVL066,15,29
         DEFOVL OVL067,33,5
         DEFOVL OVL068,59,25
         DEFOVL OVL069,32,1
         DEFOVL OVL070,63,9
         DEFOVL OVL071,36,61
         DEFOVL OVL072,55,61
         DEFOVL OVL073,48,89
         DEFOVL OVL074,32,1
         DEFOVL OVL075,34,9
         DEFOVL OVL076,36,61
         DEFOVL OVL077,72,101
         DEFOVL OVL078,36,61
         DEFOVL OVL079,17,73
         DEFOVL OVL079,17,29      ;#080
         DEFOVL OVL081,4,49
         DEFOVL OVL047,37,57      ;#082
         DEFOVL OVL083,1,1
         DEFOVL OVL084,40,61
         DEFOVL OVL085,1,105
         DEFOVL OVL086,10,13
         DEFOVL OVL087,9,81
         DEFOVL OVL088,17,33
         DEFOVL OVL089,1,1
         DEFOVL OVL090,43,21
         DEFOVL OVL091,39,1
         DEFOVL OVL092,32,113
         DEFOVL OVL093,16,49
         DEFOVL OVL094,1,45
         DEFOVL OVL095,12,117
         DEFOVL OVL096,61,1
         DEFOVL OVL097,66,41
         DEFOVL OVL098,71,1
         DEFOVL OVL099,58,89
         DEFOVL OVL100,37,105
         DEFOVL OVL101,1,57
         DEFOVL OVL102,34,77
         DEFOVL OVL103,17,1
         DEFOVL OVL104,17,29
         DEFOVL OVL105,17,89
         DEFOVL OVL106,38,61
         DEFOVL OVL107,61,57
         DEFOVL OVL108,70,61
         DEFOVL OVL109,1,1
         DEFOVL OVL110,29,41
         DEFOVL OVL111,70,61
         DEFOVL OVL112,70,61
         DEFOVL OVL092,32,97      ;#113
         DEFOVL OVL092,32,81      ;#114
         DEFOVL OVL092,32,65      ;#115
         DEFOVL OVL092,32,49      ;#116
         DEFOVL OVL092,32,33      ;#117
         DEFOVL OVL098,71,33      ;#118
         DEFOVL OVL098,71,65      ;#119
         DEFOVL OVL098,71,97      ;#120
         DEFOVL OVL103,17,101     ;#121
         DEFOVL OVL090,43,97      ;#122
         DEFOVL OVL123,34,77
         DEFOVL OVL124,34,85
         DEFOVL OVL125,26,101
         DEFOVL OVL126,47,101
         DEFOVL OVL127,25,57
         DEFOVL OVL128,90,1
         DEFOVL OVL129,57,5
         DEFOVL OVL130,57,5
         DEFOVL OVL092,32,17      ;#131
         DEFOVL OVL092,32,1       ;#132
         DEFOVL OVL133,60,57
         DEFOVL OVL134,40,53
         DEFOVL OVL135,59,57
         DEFOVL OVL136,1,45
         DEFOVL OVL137,1,93
         DEFOVL OVL138,1,25
         DEFOVL OVL139,1,13
         DEFOVL OVL140,17,21
         DEFOVL OVL141,29,29
         DEFOVL OVL142,30,77
         DEFOVL OVL143,51,61
         DEFOVL OVL144,57,65
         DEFOVL OVL145,67,1
         DEFOVL OVL146,67,1
         DEFOVL OVL147,34,77
         DEFOVL OVL148,25,57
         DEFOVL OVL149,58,57
         DEFOVL OVL150,37,93
         DEFOVL OVL151,50,101
         DEFOVL OVL152,87,85
         DEFOVL OVL153,83,89
         DEFOVL OVL154,83,53
         DEFOVL OVL155,85,57
         DEFOVL OVL156,85,29
         DEFOVL OVL157,47,69
         DEFOVL OVL158,67,13
         DEFOVL OVL159,64,17
         DEFOVL OVL160,74,105
         DEFOVL OVL161,75,97
         DEFOVL OVL162,69,17
         DEFOVL OVL163,47,69
         DEFOVL OVL164,79,105
         DEFOVL OVL165,76,89
         DEFOVL OVL166,80,13

SCROB2   EQU   $

GENHLP   DB    13,'T','r','y'+80H
         DB    'examinin','g'+80H
         DB    'things.',0

         DB    13,'N','o'+80H
         DB    'HEL','P'+80H
         DB    'available.',0

         DB    13,'U','s','e'+80H
         DB    'SAV','E'+80H
         DB    'whe','n'+80H
         DB    'enterin','g'+80H
         DB    'dangerou','s'+80H
         DB    'areas.',0

         DB    13,C$IM
         DB    'stumpe','d'+80H
         DB    'too!',0

; DIRECTION DESCRIPTIONS TABLE

DIRECT   DB    'North',0
         DB    'South',0
         DB    'East',0
         DB    'West',0
         DB    'Up',0
         DB    'Down',0

; COMPRESSED PHRASE TABLE

TXTTAB   DB    'th','e'+80H,0
         DB    'smal','l'+80H,0
         DB    'ar','e'+80H,0
         DB    'se','e'+80H,0
         DB    'can',27H,'t'+80H,0
         DB    'don',27H,'t'+80H,0
         DB    'larg','e'+80H,0
         DB    'I',27H,'m'+80H,0
         DB    'i','n'+80H,'a'+80H,0
         DB    'o','n'+80H,'a'+80H,0
         DB    'i','s'+80H,'a'+80H,0
         DB    'It',27H,'s'+80H,0
         DB    'Th','e'+80H,0
         DB    'i','s'+80H,0
         DB    'an','d'+80H,0
         DB    'a','n'+80H,0
         DB    'a','t'+80H,0
         DB    'o','f'+80H,0
         DB    'I','t'+80H,'says:',13,0
         DB    'TREKBOE','R'+80H,0
         DB    't','o'+80H,0
         DB    'm','y'+80H,0
         DB    'i','n'+80H,0

; VERB ROUTINE JUMP VECTORS

RTNTAB   DW    VLOOK,VINVE,VGET,VPUT,VNORTH,VSOUTH,VEAST,VWEST
         DW    VUP,VDOWN,VGO,VSAVE,VLOAD,VHELP,VSCORE,ENDGAM
         DW    BADINP,VOPEN,VWEAR,VLOOK,VREMOV,VSET,BADINP,BADINP
         DW    BADINP,BADINP,BADINP,VFILL,VINSRT,BADINP,BADINP
         DW    BADINP,VDIG,BADINP,BADINP,BADINP,VEAT,VFEED,VTIE
         DW    VUNTIE

; ASSORTED TEXT MESSAGES

MSG000   DB  13,13,'OK',','+80H,0

MSG001   DB  13,13,'Obviou','s'+80H,'directions',':'+80H,0

MSG002   DB  13,13,'I'+80H,C$SEE,8,':'+80H,0

MSG003   DB  13,'I'+80H,C$SEE,'n','o'+80H,'wa','y'+80H
         DB  't','o'+80H,'g','o'+80H,'i','n'+80H,'tha','t'+80H
         DB  'direction.',0

MSG004   DB  13
         DB  'I'+80H,C$DONT
         DB  'understan','d'+80H,'"',0

MSG005   DB  13,C$IM
         DB  'carryin','g'+80H
         DB  C$THE
         DB  'following:',13,0

MSG006   DB  13,'nothing.',0

MSG007   DB  13,'I'+80H,C$DONT,C$SEE,0

MSG008   DB  13,C$IM,'carryin','g'+80H,0

MSG009   DB  13,'I'+80H,C$CANT,'carr','y'+80H,'anymore.',0

MSG010   DB  13,'I'+80H,C$DONT,'hav','e'+80H,0

MSG011   DB  13,'Hey',','+80H,'I'+80H,'foun','d'+80H,'something!',0

MSG012   DB  13,'I'+80H,C$SEE,'nothin','g'+80H,'special.',0

MSG013   DB  13,C$IM,'o','n'+80H,'it!',0

MSG014   DB  13,C$IM,'i','n'+80H,'it!',0

MSG015   DB  13,C$IITS,'beyon','d'+80H,'m','y'+80H,'powe','r'+80H
         DB  't','o'+80H,'d','o'+80H,'that.',0

MSG016   DB  13,C$IITS,'closed.',0

MSG017   DB  13,C$IITS,'locked.',0

MSG018   DB  13,C$IITS,'open.',0

MSG019   DB  13,C$IITS,'unlocked.',0

MSG020   DB  13,'Won',27H,'t'+80H,'budge.',0

MSG021   DB  13,'Doesn',27H,'t'+80H,'work.',0

MSG022   DB  13,C$IITS,'empty.',0

MSG023   DB  13,'I'+80H,C$CANT,'d','o'+80H,'tha','t'+80H
         DB  '..','.'+80H,'now!',0

MSG024   DB  13
         IF  R$PNTS
MSG024B  DB  '00000 '
         DB  ' ',C$OF,'1'+80H,'treasur','e'+80H,'scored',13
         ENDIF
MSG024A  DB  '00000 '
         DB  ' move','s'+80H,'used.',0

MSG025   DB  13,13,'Thi','s'+80H,'Adventur','e'+80H,C$IS,'over.',13
         IF  R$PNTS
MSG025B  DB  '00000 '
         DB  C$OF,'1'+80H,'treasur','e'+80H,'scored',13
         ENDIF
MSG025A  DB  '00000 '
         DB  'move','s'+80H,'wer','e'+80H,'used.',13,13
         DB  'Pla','y'+80H,'agai','n'+80H,'(Y/N)','?'+80H,0

MSG026   DB  13,'Don',27H,'t'+80H,'b','e'+80H,'ridiculous.',0

MSG027   DB  13,13,'Congratulations',','+80H,'yo','u'+80H
         DB  'di','d'+80H,'it!',0

MSG028   DB  13,C$IITS,'thic','k'+80H,C$AND,'ver','y'+80H,'soft.',0

MSG029   DB  13,'Look','s'+80H,'lik','e'+80H,'wool.',0

MSG030   DB  13,'I'+80H,C$SEE,'a'+80H,'pocket.',0

MSG031   DB  13,C$IITS,'lit.',0

MSG032   DB  13,C$IITS,'off.',0

MSG033   DB  13,13,'Ligh','t'+80H,'run','s'+80H,'ou','t'+80H,'i','n'+80H
MSG033A  DB  '00'
         DB  'move(s).',0

MSG034   DB  13,C$IITS,'dangerou','s'+80H,'t','o'+80H,'mov','e'+80H
         DB  'aroun','d'+80H,'i','n'+80H,C$THE,'dark!',0

MSG035   DB  13,'I'+80H,'fel','l'+80H,'dow','n'+80H,C$AND
         DB  'cracke','d'+80H,'m','y'+80H,'head','.'+80H,C$IM,'dead!',0

MSG036   DB  13
         DB  'Wheeeee...',0

MSG037   DB  13,C$ITSA
         DB  'S.S','.'+80H
         DB  C$TREK,13
         DB  'Commissione','d'+80H
         DB  '2032',0

MSG038   DB  13
         DB  'Hey',','+80H
         DB  'somethin','g'+80H
         DB  'fel','l'+80H
         DB  'ou','t'+80H,C$OF,C$THE
         DB  'manual.',0

MSG039   DB  13,C$ITSA
         DB  'T','o'+80H
         DB  'operat','e'+80H
         DB  C$TREK
         DB  'controls:',13
         DB  '1','.'+80H
         DB  'SE','T'+80H
         DB  'XXX','X'+80H,'t','o'+80H
         DB  'se','t'+80H
         DB  'fou','r'+80H
         DB  'digi','t'+80H
         DB  'coordinates',13
         DB  '2','.'+80H
         DB  'Pres','s'+80H
         DB  'war','p'+80H
         DB  'button',0

MSG040   DB  13,C$ITSA
         DB  C$TREK
         DB  'instructio','n'+80H
         DB  'manual.',0

MSG041   DB  13
         DB  'ATTENTIO','N'+80H,C$TREK
         DB  13
         DB  'Plagu','e'+80H
         DB  'stil','l'+80H
         DB  'rampant...Xendo','s'+80H
         DB  'onl','y'+80H
         DB  'know','n'+80H
         DB  'cure...N','o'+80H
         DB  'contac','t'+80H
         DB  'VELDBOE','R'+80H
         DB  'thre','e'+80H
         DB  'months...Las','t'+80H
         DB  'know','n'+80H
         DB  'coordinate','s'+80H
         DB  '8350...Shi','p'+80H,C$AND
         DB  'cre','w'+80H
         DB  'presume','d'+80H
         DB  'lost...',C$TREK
         DB  'ordere','d'+80H
         DB  'continu','e'+80H
         DB  'mission...Goo','d'+80H
         DB  'luc','k'+80H
         DB  C$TREK,8
         DB  '...Boe','r'+80H
         DB  'Contro','l'+80H
         DB  'out.',0

MSG042   DB  13,13
         DB  '*MESSAG','E'+80H
         DB  'ALERT*',13
         DB  'Communication','s'+80H
         DB  'report','s'+80H,'a'+80H
         DB  'messag','e'+80H
         DB  'received.',0

MSG043   DB  13
         DB  'Tr','y'+80H
         DB  '"REMOV','E'+80H
         DB  'SUIT".',0

MSG044   DB  13,C$IM
         DB  'no','t'+80H
         DB  'wearin','g'+80H
         DB  'it.',0

MSG045   DB  13,C$ITSA
         DB  'Othe','r'+80H
         DB  'hi-re','s'+80H
         DB  'graphi','c'+80H
         DB  'adventure','s'+80H
         DB  'fro','m'+80H
         DB  'Mar','k'+80H
         DB  'Dat','a'+80H
         DB  'include',':'+80H
         DB  'Shenanigans',','+80H
         DB  'Se','a'+80H
         DB  'Search',','+80H
         DB  'Calixt','o'+80H
         DB  'Island',','+80H,C$AND
         DB  'Blac','k'+80H
         DB  'Sanctum.',0

MSG046   DB  13
         DB  'Coordinate','s'+80H
MSG046A  DB  '4299 '
         DB  'locke','d'+80H
         DB  'in.',0

MSG047   DB  13
         DB  'Click.',0

MSG048   DB  13
         DB  'Pleas','e'+80H
         DB  'refe','r'+80H,'t','o'+80H
         DB  'button','s'+80H,'b','y'+80H
         DB  'colo','r'+80H
         DB  'a','s'+80H,'i','n'+80H
         DB  '"PRES','S'+80H,'BLUE"',0

MSG049   DB  13,'I'+80H,C$SEE,'a'+80H
         DB  'planet!',0

MSG050   DB  13
         DB  'Nothin','g'+80H
         DB  'bu','t'+80H
         DB  'empt','y'+80H
         DB  'space.',0

MSG051   DB  13,C$TTHE
         DB  'beake','r'+80H
         DB  'land','s'+80H
         DB  'o','n'+80H,C$THE
         DB  'sof','t'+80H
         DB  'pillow.',0

MSG052   DB  13,C$TTHE
         DB  'beake','r'+80H
         DB  'drop','s'+80H,C$AND,C$IS
         DB  'smashe','d'+80H,C$TO
         DB  'bits.',0

MSG053   DB  13
         DB  'Whoosh...',0

MSG054   DB  13,C$ITSA
         DB  'S.S','.'+80H
         DB  'VELDBOER',13
         DB  'Commissione','d'+80H
         DB  '2038',0

MSG055   DB  13,C$TTHE
         DB  'control','s'+80H,C$DONT
         DB  'respond.',0

MSG056   DB  13,C$IITS
         DB  'neatl','y'+80H
         DB  'folded.',0

MSG057   DB  13,C$ITSA
         DB  'Coordinat','e'+80H
         DB  'ma','p'+80H,C$OF,C$THE
         DB  'galaxy',13
         DB  'Eart','h'+80H
         DB  '1042',13
         DB  'Breo','n'+80H
         DB  '3816',13
         DB  'Alto','n'+80H
         DB  '????',13
         DB  'Arida','k'+80H
         DB  '8350',0

MSG058   DB  13,C$TTHE
         DB  'loc','k'+80H
         DB  'appear','s'+80H,C$TO
         DB  'hav','e'+80H
         DB  'bee','n'+80H
         DB  'dissolve','d'+80H,'b','y'+80H
         DB  'som','e'+80H
         DB  'corrosiv','e'+80H
         DB  'material','.'+80H
         DB  'Ther','e'+80H,C$IS,'a'+80H
         DB  'whit','e'+80H
         DB  'butto','n'+80H
         DB  'insid','e'+80H,C$THE
         DB  'panel.',0

MSG059   DB  13
         DB  'Curren','t'+80H
         DB  'coordinate','s'+80H
         DB  'ar','e'+80H
MSG059A  DB  '4299 '
         DB  0

MSG060   DB  13,'I'+80H
         DB  'hav','e'+80H
         DB  'fille','d'+80H,C$THE
         DB  'beake','r'+80H
         DB  'wit','h'+80H
         DB  'liquid.',0

MSG061   DB  13,'I'+80H
         DB  'hav','e'+80H,'n','o'+80H
         DB  'empt','y'+80H
         DB  'container.',0

MSG062   DB  13,'I'+80H
         DB  'fil','l'+80H,C$THE
         DB  'cantee','n'+80H
         DB  'wit','h'+80H
         DB  'liqui','d'+80H
         DB  C$AND,'i','t'+80H
         DB  'dissolve','s'+80H,C$TO
         DB  'nothin','g'+80H
         DB  'righ','t'+80H
         DB  'befor','e'+80H,C$MY
         DB  'eyes!',0

MSG063   DB  13,C$IITS
         DB  'full.',0

MSG064   DB  13,'N','o'+80H
         DB  'way',','+80H,'I'+80H
         DB  'won',27H,'t'+80H,'g','o'+80H
         DB  'nea','r'+80H
         DB  'it.',0

MSG065   DB  13,C$TTHE
         DB  'bone','s'+80H,C$ARE
         DB  'corrode','d'+80H
         DB  'bu','t'+80H
         DB  'the','y'+80H
         DB  'appea','r'+80H
         DB  C$TO,'b','e'+80H
         DB  'human.',0

MSG066   DB  13,C$TTHE
         DB  'liqui','d'+80H,C$IS
         DB  'bubbling.',0

MSG067   DB  13,C$TTHE
         DB  'liqui','d'+80H
         DB  'burn','s'+80H,C$MY
         DB  'throat','.'+80H
         DB  'O','h'+80H,'my',','+80H
         DB  'it',27H,'s'+80H
         DB  'eatin','g'+80H,C$MY
         DB  'skin','.'+80H,C$IM
         DB  'dead!',0

MSG068   DB  13,C$IITS
         DB  'empty','.'+80H
         DB  'Pipe','s'+80H
         DB  'emerg','e'+80H
         DB  'fro','m'+80H,C$THE
         DB  'bas','e'+80H,C$AND
         DB  'ente','r'+80H,C$THE
         DB  'wall.',0

MSG069   DB  13,C$IITS
         DB  'disabled','.'+80H,'I'+80H
         DB  'notic','e'+80H
         DB  'tha','t'+80H,'i','t'+80H
         DB  'ha','s'+80H,C$AN
         DB  'empt','y'+80H
         DB  'slo','t'+80H
         DB  'wit','h'+80H,'a'+80H,C$SMAL
         DB  'labe','l'+80H
         DB  'sayin','g'+80H
         DB  '"INSER','T'+80H
         DB  'HERE".',0

MSG070   DB   13,C$IITS
         DB   'functioning','.'+80H
         DB   'Ther','e'+80H,C$ISA
         DB   'cartridg','e'+80H
         DB   'plugge','d'+80H
         DB   'int','o'+80H,'a'+80H
         DB   'slo','t'+80H,'o','n'+80H
         DB   'it',27H,'s'+80H
         DB   'side.',0

MSG071   DB   C$IITS,'no','w'+80H
         DB   'pitc','h'+80H
         DB   'black','.'+80H
         DB   'I'+80H,C$CANT,C$SEE
         DB   'anything!',0

MSG072   DB   13,C$TTHE
         DB   'aci','d'+80H
         DB   'burn','s'+80H,C$THE
         DB   'meta','l'+80H,C$OF,C$THE
         DB   'acces','s'+80H
         DB   'pane','l'+80H
         DB   'loc','k'+80H,C$AND,C$THE
         DB   'pane','l'+80H
         DB   'swing','s'+80H
         DB   'open.',0

MSG073   DB   13,13
         DB   'Cough',','+80H
         DB   'gasp',','+80H,'I'+80H,C$CANT
         DB   'breathe','.'+80H,C$IM
         DB   'dead.',0

MSG074   DB   13,C$TTHE
         DB   'ke','y'+80H
         DB   'doesn',27H,'t'+80H
         DB   'fit!',0

MSG075   DB   13
         DB   'Wit','h'+80H
         DB   'wha','t'+80H,'(','1'+80H
         DB   'word)','?'+80H,0

MSG076   DB   13,C$IITS
         DB   'froze','n'+80H
         DB   C$TO,C$THE
         DB   'ground.',0

MSG077   DB   13,'I'+80H
         DB   'pic','k'+80H
         DB   'u','p'+80H,'a'+80H,C$SMAL
         DB   'piec','e'+80H,C$OF
         DB   'ic','e'+80H,C$AND,'i','t'+80H
         DB   'quickl','y'+80H
         DB   'melt','s'+80H
         DB   'i','n'+80H,C$MY
         DB   'hand.',0

MSG078   DB   13,'I'+80H
         DB   'fil','l'+80H,C$THE
         DB   'blanke','t'+80H
         DB   'wit','h'+80H
         DB   'ic','e'+80H,C$AND
         DB   'slin','g'+80H,'i','t'+80H
         DB   'ove','r'+80H,C$MY
         DB   'shoulder.',0

MSG079   DB   13,13,C$TTHE
         DB   'blanke','t'+80H,C$IS
         DB   'dripping.',0

MSG080   DB   13,'I'+80H
         DB   'dro','p'+80H,C$THE
         DB   'blanke','t'+80H
         DB   'ful','l'+80H,C$OF
         DB   'ic','e'+80H
         DB   'int','o'+80H,C$THE
         DB   'barrel.',0

MSG081   DB   13,C$IITS
         DB   'ful','l'+80H,C$OF
         DB   'ic','e'+80H,C$AND
         DB   'water','.'+80H,C$TTHE
         DB   'wate','r'+80H
         DB   'seem','s'+80H
         DB   C$TO,'b','e'+80H
         DB   'drainin','g'+80H
         DB   'dow','n'+80H,C$THE
         DB   'pipes.',0

MSG082   DB   13,C$IITS
         DB   'disabled','.'+80H
         DB   'Ther','e'+80H,C$ISA
         DB   'cartridg','e'+80H
         DB   'plugge','d'+80H
         DB   'int','o'+80H,'a'+80H
         DB   'slo','t'+80H,'o','n'+80H
         DB   'it',27H,'s'+80H
         DB   'side.',0

MSG083   DB   13,C$IITS
         DB   'impassable.',0

MSG084   DB   13,13,C$TTHE
         DB   'bridg','e'+80H
         DB   'crumble','s'+80H
         DB   'unde','r'+80H
         DB   C$MY
         DB   'weigh','t'+80H,C$AND,'I'+80H
         DB   'plung','e'+80H,C$TO
         DB   C$MY
         DB   'death.',0

MSG085   DB   13,13,C$TTHE
         DB   'bridg','e'+80H,C$IS
         DB   'beginnin','g'+80H,C$TO
         DB   'crumble!',0

MSG086   DB   13,13,'A','s'+80H,'I'+80H
         DB   'exi','t'+80H,C$THE
         DB   'bridg','e'+80H,'i','t'+80H
         DB   'crumble','s'+80H
         DB   'int','o'+80H,C$THE
         DB   'chasm.',0

MSG087   DB   13,'A'+80H
         DB   'valian','t'+80H
         DB   'effor','t'+80H
         DB   'bu','t'+80H,'I'+80H
         DB   'tumbl','e'+80H
         DB   'bac','k'+80H
         DB   C$TO,C$THE
         DB   'ground.',0

MSG088   DB   13,'I','t'+80H
         DB   'appear','s'+80H
         DB   C$TO,'b','e'+80H
         DB   'som','e'+80H
         DB   'for','m'+80H,C$OF
         DB   'medication.',0

MSG089   DB   13,13
         DB   'Everythin','g'+80H,C$IS
         DB   'spinnin','g'+80H
         DB   'around.',0

MSG090   DB   13,13,'I'+80H
         DB   'fee','l'+80H
         DB   'kin','d'+80H,C$OF
         DB   'strange.',0

MSG091   DB   13
         DB   'Everythin','g'+80H,C$IS
         DB   'dark','.'+80H,'I'+80H
         DB   'thin','k'+80H,C$IM
         DB   'unconscious.',0

MSG092   DB   13,'I'+80H
         DB   'fee','l'+80H
         DB   'lik','e'+80H
         DB   'I',27H,'v','e'+80H
         DB   'jus','t'+80H
         DB   'awakened!',0

MSG093   DB   13
         DB   'Glup.',0

MSG094   DB   13
         DB   'Throug','h'+80H,'a'+80H
         DB   'spac','e'+80H
         DB   'helmet?',0

MSG095   DB   13
         DB   'Buzz.',0

MSG096   DB   13,C$TTHE
         DB   'spide','r'+80H
         DB   'won',27H,'t'+80H
         DB   'le','t'+80H
         DB   'me.',0

MSG097   DB   13,13,C$TTHE
         DB   'spide','r'+80H
         DB   'suddenl','y'+80H
         DB   'attack','s'+80H
         DB   'me','.'+80H,C$IM
         DB   'dead!',0

MSG098   DB   13,C$TTHE
         DB   'spide','r'+80H
         DB   'greedil','y'+80H
         DB   'devour','s'+80H,C$MY
         DB   'offering.',0

MSG099   DB   13
         DB   'Wha','t'+80H,'(','1'+80H
         DB   'word)','?'+80H,0

MSG100   DB   13
         DB   'Ou','t'+80H
         DB   'cold!',0

MSG101   DB   13,13
         DB   'Egads','!'+80H
         DB   'Atom','s'+80H
         DB   C$OF,C$MY
         DB   'bod','y'+80H
         DB   'hav','e'+80H
         DB   'bee','n'+80H
         DB   'scattere','d'+80H
         DB   'al','l'+80H
         DB   'ove','r'+80H,C$THE
         DB   'galaxy.',0

MSG102   DB   13,13,'I'+80H
         DB   'hav','e'+80H
         DB   'returne','d'+80H
         DB   'empty-handed','.'+80H,0

MSG103   DB   13,13,'B','y'+80H
         DB   'killin','g'+80H,C$THE
         DB   'preciou','s'+80H
         DB   'Xendo','s'+80H
         DB   'plan','t'+80H,'I'+80H
         DB   'hav','e'+80H
         DB   'seale','d'+80H,C$THE
         DB   'fat','e'+80H,C$OF,C$THE
         DB   'Earth','.'+80H,0

MSG104   DB   'I'+80H
         DB   'hav','e'+80H
         DB   'faile','d'+80H,C$MY
         DB   'missio','n'+80H
         DB   C$AND,C$IM,'a'+80H
         DB   'disgrac','e'+80H
         DB   C$TO,C$THE
         DB   'entir','e'+80H
         DB   'Boe','r'+80H
         DB   'fleet.',0

MSG105   DB   13,'A'+80H
         DB   'mea','n'+80H
         DB   'lookin','g'+80H
         DB   'dude!',0

MSG106   DB   13,'(T','o'+80H
         DB   'tree)',0

MSG107   DB   13,C$IITS
         DB   'tie','d'+80H
         DB   C$TO,'a'+80H
         DB   'tree.',0

MSG108   DB   13,C$IITS
         DB   'tie','d'+80H
         DB   C$TO,'a'+80H
         DB   'tre','e'+80H,C$AND
         DB   'hangin','g'+80H
         DB   'ove','r'+80H,C$THE
         DB   'edg','e'+80H,C$OF,C$THE
         DB   'chasm.',0

MSG109   DB   13,C$IITS
         DB   'acros','s'+80H,C$THE
         DB   'strea','m'+80H,C$OF
         DB   'lava.',0

MSG110   DB   13,'I'+80H
         DB   'jus','t'+80H
         DB   'bounc','e'+80H
         DB   'of','f'+80H
         DB   'it.',0

MSG111   DB   13,C$IITS,'a'+80H
         DB   'Xendo','s'+80H
         DB   'plant.',0

MSG112   DB   13
         DB   'Look','s'+80H
         DB   'dead.',0

MSG113   DB   13,C$IITS
         DB   'ful','l'+80H,C$OF
         DB   'ice.',0

MSG114   DB   13,C$ITSA,13
         DB   'MMMMMMMCXII',0

; OBJECT DESCRIPTIONS TABLE

OBJTAB   DB   8,'a'+80H
         DB   'spac','e'+80H
         DB   'suit',0

         DB   9
         DB   'wearin','g'+80H,'a'+80H
         DB   'spac','e'+80H
         DB   'suit',0

         DB   10,C$AN
         DB   'advertisin','g'+80H
         DB   'leaflet',0

         DB   11,'a'+80H
         DB   'key',0

         DB   12,'a'+80H
         DB   'blanke','t'+80H
         DB   'ful','l'+80H,C$OF
         DB   'ice',0

         DB   13,C$AN
         DB   'ope','n'+80H
         DB   'manual',0

         DB   14,'a'+80H
         DB   'glas','s'+80H
         DB   'beaker',0

         DB   15,'a'+80H
         DB   'beake','r'+80H
         DB   'ful','l'+80H,C$OF
         DB   'acid',0

         DB   16,'a'+80H
         DB   'blanket',0

         DB   17,'a'+80H
         DB   'pillow',0

         DB   18
         DB   'broke','n'+80H
         DB   'glass',0

         DB   19,'a'+80H
         DB   'manual',0

         DB   20,'a'+80H
         DB   'communicatio','n'+80H
         DB   'message',0

         DB   21,'a'+80H
         DB   'map',0

         DB   22,0FFH,21,0

         DB   23,'a'+80H
         DB   'shovel',0

         DB   24,'a'+80H
         DB   'stee','l'+80H
         DB   'canteen',0

         DB   25,C$AN
         DB   'amulet',0

         DB   26,'a'+80H,C$SMAL
         DB   'cartridge',0

         DB   27,'a'+80H,C$SMAL
         DB   'yello','w'+80H
         DB   'capsule',0

         DB   28,'a'+80H,C$LARG
         DB   'spider',0

         DB   29,C$AN
         DB   'unconsciou','s'+80H
         DB   'spider',0

         DB   30,C$AN
         DB   'unusua','l'+80H
         DB   'plant',0

         DB   31,'a'+80H
         DB   'dea','d'+80H
         DB   'plant',0

         DB   32,'a'+80H
         DB   'rope',0

         DB   75,'a'+80H
         DB   'grat','e'+80H
         DB   'acros','s'+80H,C$THE
         DB   'stream',0

         DB   76,0FFH,75,0

         DB   77
         DB   'stone','s'+80H,C$AND
         DB   'rubbl','e'+80H
         DB   'i','n'+80H,C$THE
         DB   'stream',0

         DB   78,'a'+80H
         DB   'danglin','g'+80H
         DB   'rope',0

         DB   79,C$THE
         DB   'commander',0

         DB   80,0FFH,81,0

         DB   81,'a'+80H
         DB   'rop','e'+80H
         DB   'tie','d'+80H
         DB   C$TO,'a'+80H
         DB   'tree',0

         DB   82,'a'+80H
         DB   'strea','m'+80H,C$OF
         DB   'lava',0

         DB   83,'a'+80H
         DB   'forc','e'+80H
         DB   'field',0

         DB   84,'a'+80H
         DB   'grate',0

         DB   85,'a'+80H
         DB   'doorway',0

         DB   86,0FFH,84,0

         DB   87,C$AN
         DB   'ope','n'+80H
         DB   'drawer',0

         DB   88,'a'+80H
         DB   'dee','p'+80H
         DB   'chasm',0

         DB   89
         DB   'strang','e'+80H
         DB   'lookin','g'+80H
         DB   'trees',0

         DB   90,'a'+80H
         DB   'crumble','d'+80H
         DB   'bridge',0

         DB   91,'a'+80H,C$SMAL
         DB   'bridge',0

         DB   92,0FFH,106,0

         DB   93,0FFH,99,0

         DB   94,0FFH,126,0

         DB   95,'a'+80H
         DB   'wrecke','d'+80H
         DB   'starship',0

         DB   96,'a'+80H
         DB   'pil','e'+80H,C$OF
         DB   'ice',0

         DB   98,'a'+80H
         DB   'cenotaph',0

         DB   99,'a'+80H
         DB   'robot',0

         DB   100,0FFH,99,0

         DB   101,'a'+80H
         DB   'skeleton',0

         DB   102,'a'+80H
         DB   'poo','l'+80H,C$OF
         DB   'liquid',0

         DB   103,0FFH,106,0

         DB   104,C$AN
         DB   'emergenc','y'+80H
         DB   'hatch',0

         DB   105,0FFH,104,0

         DB   106,'a'+80H
         DB   'vie','w'+80H
         DB   'screen',0

         DB   107,0FFH,106,0

         DB   112,0FFH,113,0

         DB   113,'a'+80H
         DB   'plaque',0

         DB   114
         DB   'pipes',0

         DB   115
         DB   'sunlamps',0

         DB   116,C$AN
         DB   'ope','n'+80H
         DB   'storag','e'+80H
         DB   'cabinet',0

         DB   119,'a'+80H
         DB   'ladder',0

         DB   120,'a'+80H
         DB   'telepor','t'+80H
         DB   'window',0

         DB   121,'a'+80H
         DB   'blu','e'+80H
         DB   'button',0

         DB   122,'a'+80H,C$SMAL
         DB   'sig','n'+80H
         DB   'o','n'+80H,C$THE
         DB   'acces','s'+80H
         DB   'panel',0

         DB   123,'a'+80H
         DB   're','d'+80H
         DB   'button',0

         DB   124,C$AN
         DB   'ope','n'+80H
         DB   'acces','s'+80H
         DB   'panel',0

         DB   125,'a'+80H,C$SMAL
         DB   'acces','s'+80H
         DB   'panel',0

         DB   126,'a'+80H,C$LARG
         DB   'meta','l'+80H
         DB   'barrel',0

         DB   127,'a'+80H
         DB   'storag','e'+80H
         DB   'cabinet',0

; ROOM DESCRIPTIONS TABLE

;ROOM 1
DESCTB   DB   C$IM,C$INA
         DB   'contro','l'+80H
         DB   'room.',0
;ROOM 2
         DB   C$IM,C$INA
         DB   'dust','y'+80H
         DB   'storag','e'+80H
         DB   'room.',0
;ROOM 3
         DB   C$IM,C$INA
         DB   'teleporte','r'+80H
         DB   'room.',0
;ROOM 4
         DB   C$IM,'i','n'+80H,C$THE
         DB   'ship',27H,'s'+80H
         DB   'communicatio','n'+80H
         DB   'room.',0
;ROOM 5
         DB   C$IM,C$INA
         DB   'cultivatio','n'+80H
         DB   'room','.'+80H
         DB   'Severa','l'+80H,C$LARG
         DB   'sunlamp','s'+80H
         DB   'ligh','t'+80H,C$THE
         DB   'entir','e'+80H
         DB   'roo','m'+80H,C$AND,'a'+80H
         DB   'networ','k'+80H,C$OF
         DB   'pip','e'+80H
         DB   'cover','s'+80H,C$THE
         DB   'ceiling.',0
;ROOM 6
         DB   C$IM,'i','n'+80H,C$THE
         DB   'environmenta','l'+80H
         DB   'contro','l'+80H
         DB   'room.',0
;ROOM 7
         DB   C$IM,'i','n'+80H
         DB   'Boe','r'+80H
         DB   'Control.',0
;ROOM 8
         DB   C$IM,C$ONA
         DB   'froze','n'+80H
         DB   'planet.',0
;ROOM 9
         DB   0FFH,8,0
;ROOM 10
         DB   0FFH,8,0
;ROOM 11
         DB   C$IM,C$ONA
         DB   'deser','t'+80H
         DB   'planet.',0
;ROOM 12
         DB   0FFH,11,0
;ROOM 13
         DB   0FFH,11,0
;ROOM 14
         DB   0FFH,11,0
;ROOM 15
         DB   0FFH,6,0
;ROOM 16
         DB   C$IM
         DB   'floatin','g'+80H,'i','n'+80H
         DB   'dee','p'+80H
         DB   'space.',0
;ROOM 17
         DB   0FFH,1,0
;ROOM 18
         DB   C$IM
         DB   'standin','g'+80H
         DB   C$ONA,C$LARG
         DB   'cenotaph.',0
;ROOM 19
         DB   0FFH,5,0
;ROOM 20
         DB   0FFH,3,0
;ROOM 21
         DB   0FFH,2,0
;ROOM 22
         DB   0FFH,4,0
;ROOM 23
         DB   C$IM,C$ONA
         DB   'beautifu','l'+80H
         DB   'garde','n'+80H
         DB   'planet.',0
;ROOM 24
         DB   0FFH,23,0
;ROOM 25
         DB   0FFH,23,0
;ROOM 26
         DB   0FFH,23,0
;ROOM 27
         DB   0FFH,23,0
;ROOM 28
         DB   C$IM,C$AT,C$THE
         DB   'botto','m'+80H,C$OF,'a'+80H
         DB   'chasm.',0
;ROOM 29
         DB   0FFH,28,0
;ROOM 30
         DB   0FFH,28,0
;ROOM 31
         DB   0FFH,28,0
;ROOM 32
         DB   0FFH,23,0
;ROOM 33
         DB   C$IM,'o','n'+80H,C$AN
         DB   'ol','d'+80H
         DB   'ston','e'+80H
         DB   'bridg','e'+80H
         DB   'abov','e'+80H,'a'+80H
         DB   'strea','m'+80H,C$OF
         DB   'molte','n'+80H
         DB   'lava.',0
;ROOM 34
         DB   C$IM,C$INA,C$LARG
         DB   'undergroun','d'+80H
         DB   'complex.',0
;ROOM 35
         DB   0FFH,34,0
;ROOM 36
         DB   0FFH,34,0
;ROOM 37
         DB   0FFH,34,0
;ROOM 38
         DB   0FFH,34,0
;ROOM 39
         DB   C$IM,C$INA
         DB   'strang','e'+80H
         DB   'chamber.',0
;ROOM 40
         DB   0FFH,34,0
;ROOM 41
         DB   0FFH,34,0

;  MOVABLE OBJECT TABLE

MOVOBJ   DB   8,61,0              ;SPACE SUIT
         DB   2,3,5,0

         DB   11,156,0            ;KEY
         DB   2,3,4,5,6,15,19,20,21,22
         DB   0

         DB   14,62,0             ;EMPTY BEAKER
         DB   2,3,4,5,8,9,10,11,12,13,19
         DB   20,21,22,0

         DB   14,164,0            ;EMPTY BEAKER
         DB   34,35,36,37,38,39,40,41,0

         DB   15,62,0             ;FULL BEAKER
         DB   2,3,4,5,8,9,10,11,12,13,19
         DB   20,21,22,0

         DB   15,164,0            ;FULL BEAKER
         DB   34,35,36,37,38,39,40,41,0

         DB   16,59,0             ;BLANKET
         DB   2,22,0

         DB   17,60,0             ;PILLOW
         DB   2,22,0

         DB   13,48,0             ;INSTRUCTION MANUAL
         DB   2,4,21,22,0

         DB   19,48,0             ;CLOSED MANUAL
         DB   2,4,21,22,0

         DB   20,51,0             ;COMMUNICATION MSG
         DB   4,0

         DB   23,154,155          ;SHOVEL
         DB   2,3,4,5,6,8,9,10,11,12,14
         DB   15,19,20,21,22,23,24,25
         DB   26,27,28,29,30,31,32,34
         DB   35,36,37,38,39,40,41,0

         DB   25,166,0            ;AMULET ON RED
         DB   1,2,4,5,6,15,17,19,20,22,0

         DB   25,27,0             ;AMULET ON CENOTAPH
         DB   18,0

         DB   25,165,0            ;AMULET ON WHITE
         DB   34,35,36,37,38,40,41,0

         DB   28,107,112          ;LIVE SPIDER
         DB   35,40,0

         DB   29,107,112          ;SPIDER OUT COLD
         DB   34,35,36,37,38,40,41,0

         DB   29,150,0            ;SPIDER OUT COLD
         DB   39,0

         DB   30,133,134          ;LIVE PLANT
         DB   5,0

         DB   30,134,135          ;LIVE PLANT
         DB   39,0

         DB   31,149,0            ;DEAD PLANT
         DB   5,0

         DB   32,152,153          ;ROPE ON GROUND
         DB   2,3,4,5,6,8,9,10,11,12
         DB   13,14,15,19,20,21,22,23
         DB   24,25,26,27,32,0

         DB   78,101,0            ;ROPE DANGLING
         DB   29,0

         DB   80,158,159          ;DROP OVER CHASM
         DB   27,0

         DB   81,158,162          ;TIED ROPE
         DB   23,25,32,0

         DB   81,160,161          ;TIED ROPE
         DB   24,26,0

         DB   77,97,0             ;STONES IN LAVA
         DB   28,31,0

         DB   84,129,0            ;CLOSED GRATE
         DB   40,0

         DB   76,102,0            ;CLOSED GRATE
         DB   31,0

         DB   86,130,0            ;OPEN GRATE
         DB   40,0

         DB   75,147,0            ;OPEN GRATE
         DB   31,0

         DB   87,126,0            ;DRAWER
         DB   4,0

         DB   90,26,0             ;BRIDGE
         DB   26,0

         DB   91,93,0             ;BRIDGE
         DB   33,0

         DB   96,22,23            ;PILE OF ICE
         DB   8,9,10,0

         DB   93,47,0             ;ROBOT
         DB   22,0

         DB   99,82,157           ;ROBOT
         DB   4,0

         DB   100,47,0            ;ROBOT
         DB   4,22,0

         DB   92,12,39            ;VIEW SCREEN
         DB   1,0

         DB   103,12,39           ;VIEW SCREEN
         DB   1,0

         DB   106,12,16           ;VIEW SCREEN
         DB   1,0

         DB   107,12,0            ;VIEW SCREEN
         DB   1,0

         DB   104,71,0            ;EMERGENCY HATCH
         DB   6,15,0

         DB   105,78,0            ;EMERGENCY HATCH
         DB   6,0

         DB   105,76,0            ;EMERGENCY HATCH
         DB   15,0

         DB   116,64,63           ;STORAGE CABINET
         DB   2,21,0

         DB   120,13,0            ;TELEPORT WINDOW
         DB   3,7,8,11,0

         DB   124,74,75           ;ACCESS PANEL
         DB   6,15,0

         DB   125,69,0            ;ACCESS PANEL
         DB   6,0

         DB   0                   ;END OF TABLE

;
;        FILE: ADVDATA2.ASM
;
