   DECLARE SUB BestHand (Work%(), Discard%(), Rank%(), Value%(), Suit%())
   DECLARE SUB ButtonStatus ()
   DECLARE SUB CardBack (TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
   DECLARE SUB CheckScore (Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%)
   DECLARE SUB ClearScreen (EndLine%)
   DECLARE SUB Clicks (Points%)
   DECLARE SUB CountScore (Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
   DECLARE SUB CribBoard (RedPeg%(), BluePeg%())
   DECLARE SUB CribCut ()
   DECLARE SUB Delay (Seconds!)
   DECLARE SUB DisplayCard (TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
   DECLARE SUB DisplayMeld (CurrentCrib%, CurrentMeld%)
   DECLARE SUB DrawBluePeg (BluePeg%(), Temp1%)
   DECLARE SUB DrawBlueHole (BluePeg%(), Temp1%)
   DECLARE SUB DrawRedPeg (RedPeg%(), Temp1%)
   DECLARE SUB DrawRedHole (RedPeg%(), Temp1%)
   DECLARE SUB EraseCard (TopCol%, TopRow%)
   DECLARE SUB EraseLine ()
   DECLARE SUB Initialize (CB%(), BluePeg%(), RedPeg%())
   DECLARE SUB Instructions ()
   DECLARE SUB Logo ()
   DECLARE SUB Mouse (M1%, M2%, M3%, M4%)
   DECLARE SUB MoveBlue (BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
   DECLARE SUB MoveRed (RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
   DECLARE SUB NewGame ()
   DECLARE SUB PlayGame ()
   DECLARE SUB PressKey (Answer$)
   DECLARE SUB ShuffleCards (Deck%(), Suit%(), Rank%(), Value%())
   DECLARE SUB ShuffleDisplay ()
   DECLARE SUB YesNo (Answer$)
   DECLARE SUB Hint1 (Work%(), Discard%(), Rank%(), Value%(), Suit%())
   DECLARE SUB Hint2 (Work%(), Discard%(), Rank%(), Value%(), Suit%())
   DECLARE SUB Quit ()
   DECLARE SUB SaveGame ()
   DECLARE SUB Continue ()
   DECLARE SUB ContPlay (Answer$)
   DECLARE SUB BottomLine (Parm1%,Parm2%)
   DECLARE SUB StarBurst ()

   DEFINT A-Z
   COMMON SHARED TopCol%, TopRow%, CurrentCard%, CurrentCrib%
   COMMON SHARED CurrentMeld%, PlayCount%, ComputerGo%, PlayerGo%
   COMMON SHARED RedScore%, BlueScore%, RedBackPeg%, BlueBackPeg%
   COMMON SHARED M1%, M2%, M3%, M4%, Answer$
   COMMON SHARED Points%, CurrentPlayer%
   COMMON SHARED A%, B%, C%, D%, E%, FirstGame%
   COMMON SHARED PlayFlag$

   DIM SHARED CB%(2301)
   DIM SHARED RedPeg%(123, 2)
   DIM SHARED BluePeg%(123, 2)
   DIM SHARED Deck%(52), Suit%(52), Rank%(52), Value%(52)
   DIM SHARED Discard%(4), Work%(8), Array%(8), Message$(10)

   CLS
   KEY OFF
   ON ERROR GOTO ErrorRoutine

   PlayFlag$ = "Deal"

10 SCREEN 12: REM 640 x 480 (16 foreground colors) (VGA)
              REM  80 x  30 lines of text (Color Fgnd only)
   PALETTE 14, 11565: REM Make Yellow a light yellow
                    : REM (65536*0)+(256*45)+45 (Blue/Green/Red)
   PALETTE 12, 65793: REM Make Light Red a Dark Black
                    : REM (65536* 1)+(256*1)+1  (Blue/Green/Red)
   CONST Computer = 1
   CONST Player   = 0
   CONST True  = 1
   CONST False = 0
   CONST Black = 0
   CONST Green = 2
   CONST Cyan  = 3
   CONST Red   = 4
   CONST White = 7
   CONST Yellow = 14
   CONST BrightWhite = 15

   Message$(1) = "Finally, a decent cut."
   Message$(2) = "Not a bad cut, but not great either."
   Message$(3) = "I knew I shouldn't have thrown that card..."
   Message$(4) = "Hope it helps you, as it does nothing for me."
   Message$(5) = "Yahoo...."
   Message$(6) = "Awww, just a so-so starter card."
   Message$(7) = " "
   Message$(8) = " "
   Message$(9) = " "
   Message$(10) = " "

   SHELL "MOUSE ON >NUL:"
   CLS
   M1% = 0
   CALL Mouse(M1%, M2%, M3%, M4%): REM Initialize mouse
   IF (M1% = 0) THEN
     CLS
     Keyboard = True
     COLOR Green
     PRINT "Mouse not detected or software driver not available."
     PRINT "        Program will use keyboard input only."
     PRINT
     PRINT "To select a card during play, use the numbers 1 through 6."
     PRINT "To select GO during play, press the letter ";CHR$(34);"G";CHR$(34);"."
     PRINT
     PRINT "To abort game, press the Esc key any time keyboard input is required."
     LOCATE 27,1
     COLOR Yellow
     PRINT TAB (16); "Press any key to continue.";
     COLOR Green
     CALL PressKey(Answer$)
     CLS
   ELSE
     Keyboard = False
     M1% = 7: M3% = 0: M4% = 479
     CALL Mouse(M1%, M2%, M3%, M4%): REM Set mouse min/max horiz.
     M1% = 8: M3% = 0: M4% = 465
     CALL Mouse(M1%, M2%, M3%, M4%): REM Set mouse min/max vert.
   END IF

   CALL Initialize(CB%(), BluePeg%(), RedPeg%())
   CALL CribBoard(RedPeg%(), BluePeg%())
   CALL Logo
   CALL NewGame
   END

ErrorRoutine:
  IF ERL = 10 THEN
    SCREEN 0
    PRINT "Sorry, this program requires VGA."
    END
  END IF
PRINT "QuickBASIC Error ";ERR;" has occurred."
END

DATA 1,2,3,4,5,6
DATA 1,2,3,5,4,6
DATA 1,2,3,6,4,5
DATA 1,2,4,5,3,6
DATA 1,2,4,6,3,5
DATA 1,2,5,6,3,4
DATA 1,3,4,5,2,6
DATA 1,3,4,6,2,5
DATA 1,3,5,6,2,4
DATA 1,4,5,6,2,3
DATA 3,4,5,6,1,2
DATA 2,4,5,6,1,3
DATA 2,3,5,6,1,4
DATA 2,3,4,6,1,5
DATA 2,3,4,5,1,6

SUB BestHand (Work%(), Discard%(), Rank%(), Value%(), Suit%()) STATIC

RESTORE
BestScore! = 0
BestWeighted! = 0
Weighted! = 0

FOR Temp1% = 1 TO 15
  FOR Temp2% = 1 TO 4
    READ Work%(Temp2%)
  NEXT Temp2%
    READ Discard%(1), Discard%(2)

Score! = 0
Weighted! = 0

REM Count up Pairs first (includes 3 and 4 of a kind)
IF Rank%(Work%(1)) = Rank%(Work%(2)) THEN Score! = Score! + 2
IF Rank%(Work%(1)) = Rank%(Work%(3)) THEN Score! = Score! + 2
IF Rank%(Work%(1)) = Rank%(Work%(4)) THEN Score! = Score! + 2
IF Rank%(Work%(2)) = Rank%(Work%(3)) THEN Score! = Score! + 2
IF Rank%(Work%(2)) = Rank%(Work%(4)) THEN Score! = Score! + 2
IF Rank%(Work%(3)) = Rank%(Work%(4)) THEN Score! = Score! + 2

REM Count up 15's next
IF Value%(Work%(1)) + Value%(Work%(2)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(3)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(2)) + Value%(Work%(3)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(2)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(2)) + Value%(Work%(3)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(2)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(2)) + Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(2)) + Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2

REM Count up 4 of same suit
IF Suit%(Work%(1)) = Suit%(Work%(2)) AND Suit%(Work%(2)) = Suit%(Work%(3)) AND Suit%(Work%(3)) = Suit%(Work%(4)) THEN Score! = Score! + 4

REM Count up Runs of 4
  A% = Rank%(Work%(1))
  B% = Rank%(Work%(2))
  C% = Rank%(Work%(3))
  D% = Rank%(Work%(4))
  IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) THEN
    Score! = Score! + 4
    GOTO WeightedValues
  END IF

REM Count up Runs of 3
  A% = Rank%(Work%(1))
  B% = Rank%(Work%(2))
  C% = Rank%(Work%(3))
  D% = Rank%(Work%(4))
  IF (A% = B% - 1) AND (B% = C% - 1) THEN Score! = Score! + 3
  IF (A% = B% - 1) AND (B% = D% - 1) THEN Score! = Score! + 3
  IF (A% = C% - 1) AND (C% = D% - 1) THEN Score! = Score! + 3
  IF (B% = C% - 1) AND (C% = D% - 1) THEN Score! = Score! + 3

REM ******** Weighted Values ****************

WeightedValues:

IF Rank%(Work%(2)) = Rank%(Work%(1)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(3)) = Rank%(Work%(1)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(4)) = Rank%(Work%(1)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(3)) = Rank%(Work%(2)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(4)) = Rank%(Work%(2)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(4)) = Rank%(Work%(3)) + 1 THEN Weighted! = Weighted! + .01

IF Rank%(Discard%(1)) = Rank%(Discard%(2)) THEN
  IF CurrentCrib% = Player THEN
     Weighted! = Weighted! - 1.9
  ELSE
     Weighted! = Weighted! + 2
  END IF
END IF

IF Value%(Discard%(1)) + Value%(Discard%(2)) = 15 THEN
  IF CurrentCrib% = Player THEN
     Weighted! = Weighted! - 1.9
  ELSE
     Weighted! = Weighted! + 2
  END IF
END IF

IF Value%(Discard%(1)) = 5 OR Value%(Discard%(2)) = 5 THEN
  IF CurrentCrib% = Computer THEN
     Weighted! = Weighted! + .5
  ELSE
     Weighted! = Weighted! - .5
  END IF
END IF

IF Rank%(Discard%(1)) = Rank%(Discard%(2)) + 1 THEN
  IF CurrentCrib% = Computer THEN
     Weighted! = Weighted! + .25
  ELSE
     Weighted! = Weighted! - .25
  END IF
END IF

REM *****End Weighted Values ****************

IF (Score! > BestScore!) OR ((Score! >= BestScore!) AND (Weighted! >= BestWeighted!)) THEN
  BestScore! = Score!
  BestWeighted! = Weighted!
  Discard1% = Discard%(1)
  Discard2% = Discard%(2)
END IF

NEXT Temp1%

Discard%(1) = Discard1%
Discard%(2) = Discard2%
END SUB

SUB ButtonStatus STATIC
    Answer$ = INKEY$
ReadStatus:
    M1% = 1
    CALL Mouse(M1%, M2%, M3%, M4%): REM Show mouse cursor
    M1% = 3
    CALL Mouse(M1%, M2%, M3%, M4%): REM Get button status

    IF M2% AND 1 THEN
      REM Left button down
    ELSE
      Answer$ = INKEY$: Answer$ = UCASE$(Answer$)
      IF Answer$ = "1" THEN GOTO HideMouse
      IF Answer$ = "2" THEN GOTO HideMouse
      IF Answer$ = "3" THEN GOTO HideMouse
      IF Answer$ = "4" THEN GOTO HideMouse
      IF Answer$ = "5" THEN GOTO HideMouse
      IF Answer$ = "6" THEN GOTO HideMouse
      IF Answer$ = "G" THEN GOTO HideMouse
      IF Answer$ = "H" THEN GOTO HideMouse
      IF Answer$ = "Q" THEN GOTO HideMouse
      IF Answer$ = "S" THEN GOTO HideMouse
      IF Answer$ = "R" THEN GOTO HideMouse
      IF Answer$ = CHR$(27) THEN CLS : END
      GOTO ReadStatus
    END IF

IF     (M3% => 326 AND M3% <= 359) AND  _
       (M4% => 364 AND M4% <= 385) THEN
       Answer$ = "G"
       GOTO HideMouse
ELSEIF (M3% =>  27 AND M3% <= 77) AND _
       (M4% => 445 AND M4% <=466) THEN
       Answer$ = "H"
       GOTO HideMouse
ELSEIF (M3% => 142 AND M3% <=197) AND _
       (M4% => 445 AND M4% <=466) THEN
       Answer$ = "Q"
       GOTO HideMouse
ELSEIF (M3% => 262 AND M3% <=317) AND _
       (M4% => 445 AND M4% <=466) THEN
       Answer$ = "S"
       GOTO HideMouse
ELSEIF (M3% => 382 AND M3% <=437) AND _
       (M4% => 445 AND M4% <=466) THEN
       Answer$ = "R"
       GOTO HideMouse
ELSEIF (M3% =>   5 AND M3% <= 77) AND _
       (M4% => 250 AND M4% <=360) THEN
       Answer$ = "1"
       GOTO HideMouse
ELSEIF (M3% =>  83 AND M3% <=155) AND _
       (M4% => 250 AND M4% <=360) THEN
       Answer$ = "2"
       GOTO HideMouse
ELSEIF (M3% => 161 AND M3% <=233) AND _
       (M4% => 250 AND M4% <=360) THEN
       Answer$ = "3"
       GOTO HideMouse
ELSEIF (M3% => 239 AND M3% <=311) AND _
       (M4% => 250 AND M4% <=360) THEN
       Answer$ = "4"
       GOTO HideMouse
ELSEIF (M3% => 317 AND M3% <=389) AND _
       (M4% => 250 AND M4% <=360) THEN
       Answer$ = "5"
       GOTO HideMouse
ELSEIF (M3% => 395 AND M3% <=467) AND _
       (M4% => 250 AND M4% <=360) THEN
       Answer$ = "6"
       GOTO HideMouse
ELSE   GOTO ReadStatus
       REM Not on any user playing card so ignore button press
END IF

HideMouse:
    M1% = 2
    CALL Mouse(M1%, M2%, M3%, M4%): REM Hide mouse cursor

    IF Answer$ = "H" AND PlayFlag$ = "Deal" THEN
       CALL Hint1 (Work%(), Discard%(), Rank%(), Value%(), Suit%())
    END IF

    IF Answer$ = "H" AND PlayFlag$ = "Meld" THEN
       CALL Hint2 (Work%(), Discard%(), Rank%(), Value%(), Suit%())
    END IF

    IF Answer$ = "Q" THEN CALL Quit
    IF Answer$ = "S" THEN CALL SaveGame
END SUB

SUB CardBack (TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%()) STATIC
 PUT (TopCol%, TopRow%), CB%, PSET
END SUB

SUB CheckScore (Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%) STATIC

  REM First card in meld so no point in checking further
  IF PlayCount% = MeldCount% THEN EXIT SUB

  REM See if this rates a 15 for 2
  IF CurrentMeld% = 15 THEN
    CALL EraseLine
    PRINT "Fifteen for two";
    CALL Delay(2)
    Points% = 2
    IF CurrentPlayer% = Computer THEN
      CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
    ELSE
      CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
    END IF
  END IF

  REM See if this is four of a kind
  IF PlayCount% >= MeldCount% + 3 THEN
    IF Rank%(Work%(PlayCount%)) = Rank%(Work%(PlayCount% - 1)) AND Rank%(Work%(PlayCount%)) = Rank%(Work%(PlayCount% - 2)) AND Rank%(Work%(PlayCount%)) = Rank%(Work%(PlayCount% - 3)) THEN
       CALL EraseLine
       PRINT "Four of a kind for 12";
       CALL Delay(2)
       Points% = 12
         IF CurrentPlayer% = Computer THEN
           CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
         ELSE
           CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
         END IF
       EXIT SUB
    END IF
  END IF

  REM See if this is three of a kind
  IF PlayCount% >= MeldCount% + 2 THEN
    IF Rank%(Work%(PlayCount%)) = Rank%(Work%(PlayCount% - 1)) AND Rank%(Work%(PlayCount%)) = Rank%(Work%(PlayCount% - 2)) THEN
       CALL EraseLine
       PRINT "Three of a kind for 6";
       CALL Delay(2)
       Points% = 6
       IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
       ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
       END IF
       EXIT SUB
    END IF
  END IF

  REM See if this is a pair
    IF Rank%(Work%(PlayCount%)) = Rank%(Work%(PlayCount% - 1)) THEN
      CALL EraseLine
      PRINT "A Pair for two";
      CALL Delay(2)
      Points% = 2
        IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
        ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
        END IF
      EXIT SUB
    END IF

 REM See if this causes a run of 7
 IF PlayCount% >= MeldCount% + 6 THEN
   A% = Rank%(Work%(PlayCount%))
   B% = Rank%(Work%(PlayCount% - 1))
   C% = Rank%(Work%(PlayCount% - 2))
   D% = Rank%(Work%(PlayCount% - 3))
   E% = Rank%(Work%(PlayCount% - 4))
   F% = Rank%(Work%(PlayCount% - 5))
   G% = Rank%(Work%(PlayCount% - 6))
     FOR Temp2% = 1 TO 7
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
       IF E% > F% THEN SWAP E%, F%
       IF F% > G% THEN SWAP F%, G%
     NEXT Temp2%
   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) AND (E% = F% - 1) AND (F% = G% - 1) THEN
       CALL EraseLine
       PRINT "A run of seven for 7";
       CALL Delay(2)
       Points% = 7
       IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
       ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
       END IF
       EXIT SUB
  END IF
 END IF

 REM See if this causes a run of 6
 IF PlayCount% >= MeldCount% + 5 THEN
   A% = Rank%(Work%(PlayCount%))
   B% = Rank%(Work%(PlayCount% - 1))
   C% = Rank%(Work%(PlayCount% - 2))
   D% = Rank%(Work%(PlayCount% - 3))
   E% = Rank%(Work%(PlayCount% - 4))
   F% = Rank%(Work%(PlayCount% - 5))
     FOR Temp2% = 1 TO 6
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
       IF E% > F% THEN SWAP E%, F%
     NEXT Temp2%
   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) AND (E% = F% - 1) THEN
       CALL EraseLine
       PRINT "A run of six for 6";
       CALL Delay(2)
       Points% = 6
       IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
       ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
       END IF
       EXIT SUB
  END IF
 END IF

 REM See if this causes a run of 5
 IF PlayCount% >= MeldCount% + 4 THEN
   A% = Rank%(Work%(PlayCount%))
   B% = Rank%(Work%(PlayCount% - 1))
   C% = Rank%(Work%(PlayCount% - 2))
   D% = Rank%(Work%(PlayCount% - 3))
   E% = Rank%(Work%(PlayCount% - 4))
     FOR Temp2% = 1 TO 5
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
     NEXT Temp2%
   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) THEN
       CALL EraseLine
       PRINT "A run of five for 5";
       CALL Delay(2)
       Points% = 5
       IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
       ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
       END IF
       EXIT SUB
  END IF
 END IF

 REM See if this causes a run of 4
 IF PlayCount% >= MeldCount% + 3 THEN
   A% = Rank%(Work%(PlayCount%))
   B% = Rank%(Work%(PlayCount% - 1))
   C% = Rank%(Work%(PlayCount% - 2))
   D% = Rank%(Work%(PlayCount% - 3))
     FOR Temp2% = 1 TO 4
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
     NEXT Temp2%
  IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) THEN
       CALL EraseLine
       PRINT "A run of four for 4";
       CALL Delay(2)
       Points% = 4
       IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
       ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
       END IF
       EXIT SUB
  END IF
 END IF

 REM See if this causes a run of 3
 IF PlayCount% >= MeldCount% + 2 THEN
   A% = Rank%(Work%(PlayCount%))
   B% = Rank%(Work%(PlayCount% - 1))
   C% = Rank%(Work%(PlayCount% - 2))
     FOR Temp2% = 1 TO 3
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
     NEXT Temp2%
  IF (A% = B% - 1) AND (B% = C% - 1) THEN
       CALL EraseLine
       PRINT "A run of three for 3";
       CALL Delay(2)
       Points% = 3
       IF CurrentPlayer% = Computer THEN
         CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
       ELSE
         CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
       END IF
       EXIT SUB
  END IF
 END IF

EXIT SUB
END SUB

SUB ClearScreen (EndLine%) STATIC
  LOCATE 1, 1
  FOR Temp1% = 1 TO EndLine%
     PRINT STRING$(59, " ");
  NEXT Temp1%
END SUB

SUB Clicks (Points%) STATIC

 IF Points% > 5 THEN
   Seconds! = .05
   Duration! = .4
 ELSE
   Seconds! = .25
   Duration! = 1
 END IF

SOUND 37, Duration!
CALL Delay(Seconds!)
END SUB

SUB CountScore (Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%) STATIC

  Points% = 0
  LOCATE 27, 1
  PRINT STRING$(59, " ");
  REM Count up 15's for two
  IF Value%(A%) + Value%(B%) + Value%(C%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen

  IF Value%(A%) + Value%(B%) + Value%(C%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(B%) + Value%(C%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(B%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(C%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(C%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen

  IF Value%(A%) + Value%(B%) + Value%(C%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(B%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(B%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(C%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(C%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(C%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(C%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(C%) + Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen

  IF Value%(A%) + Value%(B%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(C%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(A%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(C%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(B%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(C%) + Value%(D%) = 15 THEN GOSUB Fifteen
  IF Value%(C%) + Value%(E%) = 15 THEN GOSUB Fifteen
  IF Value%(D%) + Value%(E%) = 15 THEN GOSUB Fifteen

  REM Count up 5 of the same suit
  IF (Suit%(A%) = Suit%(B%)) AND (Suit%(B%) = Suit%(C%)) AND (Suit%(C%) = Suit%(D%)) AND (Suit%(D%) = Suit%(E%)) THEN
    GOSUB Suit5
    GOTO SameKind
  END IF

  REM Count up 4 of the same suit (except crib)
  IF (Suit%(A%) = Suit%(B%)) AND (Suit%(B%) = Suit%(C%)) AND (Suit%(C%) = Suit%(D%)) AND (A% <> 9) THEN
    GOSUB Suit4
  END IF

SameKind:
  REM Count up four of a kind's
  IF (Rank%(A%) = Rank%(B%)) AND (Rank%(B%) = Rank%(C%)) AND (Rank%(C%) = Rank%(D%)) THEN
       GOSUB FourKind
       GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(B%)) AND (Rank%(B%) = Rank%(C%)) AND (Rank%(C%) = Rank%(E%)) THEN
       GOSUB FourKind
       GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(B%)) AND (Rank%(B%) = Rank%(D%)) AND (Rank%(D%) = Rank%(E%)) THEN
       GOSUB FourKind
       GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(C%)) AND (Rank%(C%) = Rank%(D%)) AND (Rank%(D%) = Rank%(E%)) THEN
       GOSUB FourKind
       GOTO Runs
  END IF

  IF (Rank%(B%) = Rank%(C%)) AND (Rank%(C%) = Rank%(D%)) AND (Rank%(D%) = Rank%(E%)) THEN
       GOSUB FourKind
       GOTO Runs
  END IF

  REM Count up three of a kind's

  IF (Rank%(A%) = Rank%(B%)) AND (Rank%(B%) = Rank%(C%)) THEN
    GOSUB ThreeKind
    IF Rank%(D%) = Rank%(E%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(B%)) AND (Rank%(B%) = Rank%(E%)) THEN
    GOSUB ThreeKind
    IF Rank%(C%) = Rank%(D%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(C%)) AND (Rank%(C%) = Rank%(D%)) THEN
    GOSUB ThreeKind
    IF Rank%(B%) = Rank%(E%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(C%)) AND (Rank%(C%) = Rank%(E%)) THEN
    GOSUB ThreeKind
    IF Rank%(B%) = Rank%(D%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(A%) = Rank%(D%)) AND (Rank%(D%) = Rank%(E%)) THEN
    GOSUB ThreeKind
    IF Rank%(B%) = Rank%(C%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(B%) = Rank%(C%)) AND (Rank%(C%) = Rank%(D%)) THEN
    GOSUB ThreeKind
    IF Rank%(A%) = Rank%(E%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(B%) = Rank%(C%)) AND (Rank%(C%) = Rank%(E%)) THEN
    GOSUB ThreeKind
    IF Rank%(A%) = Rank%(D%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  IF (Rank%(C%) = Rank%(D%)) AND (Rank%(D%) = Rank%(E%)) THEN
    GOSUB ThreeKind
    IF Rank%(A%) = Rank%(B%) THEN GOSUB TwoKind
    GOTO Runs
  END IF

  REM Count up pair's
  IF Rank%(A%) = Rank%(B%) THEN GOSUB TwoKind
  IF Rank%(A%) = Rank%(C%) THEN GOSUB TwoKind
  IF Rank%(A%) = Rank%(D%) THEN GOSUB TwoKind
  IF Rank%(A%) = Rank%(E%) THEN GOSUB TwoKind
  IF Rank%(B%) = Rank%(C%) THEN GOSUB TwoKind
  IF Rank%(B%) = Rank%(D%) THEN GOSUB TwoKind
  IF Rank%(B%) = Rank%(E%) THEN GOSUB TwoKind
  IF Rank%(C%) = Rank%(D%) THEN GOSUB TwoKind
  IF Rank%(C%) = Rank%(E%) THEN GOSUB TwoKind
  IF Rank%(D%) = Rank%(E%) THEN GOSUB TwoKind

Runs:
  REM Sort into rank order
  Work%(1) = Rank%(A%)
  Work%(2) = Rank%(B%)
  Work%(3) = Rank%(C%)
  Work%(4) = Rank%(D%)
  Work%(5) = Rank%(E%)
    FOR Temp1% = 1 TO 5
    FOR Temp2% = 1 TO 4
      IF Work%(Temp2%) > Work%(Temp2% + 1) THEN
        SWAP Work%(Temp2%), Work%(Temp2% + 1)
      END IF
    NEXT Temp2%
    NEXT Temp1%

 REM See if "his heels"  Jack same suit as Cut card
 IF (Rank%(A%) = 11) AND (Suit%(E%) = Suit%(A%)) THEN GOSUB HisHeels
 IF (Rank%(B%) = 11) AND (Suit%(E%) = Suit%(B%)) THEN GOSUB HisHeels
 IF (Rank%(C%) = 11) AND (Suit%(E%) = Suit%(C%)) THEN GOSUB HisHeels
 IF (Rank%(D%) = 11) AND (Suit%(E%) = Suit%(D%)) THEN GOSUB HisHeels

 REM See if this causes a run of 5
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(3) - 1 AND Work%(3) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN
     GOSUB Run5
     EXIT SUB
   END IF

 REM See if this causes a run of 4
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(3) - 1 AND Work%(3) = Work%(4) - 1 THEN GOSUB Run4
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(3) - 1 AND Work%(3) = Work%(5) - 1 THEN GOSUB Run4
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN GOSUB Run4
   IF Work%(2) = Work%(3) - 1 AND Work%(3) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN GOSUB Run4
   IF Work%(1) = Work%(3) - 1 AND Work%(3) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN GOSUB Run4

       IF EarlyExit = True THEN
         EarlyExit = False
         EXIT SUB
       END IF

 REM See if this causes a run of 3
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(3) - 1 THEN GOSUB Run3
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(4) - 1 THEN GOSUB Run3
   IF Work%(1) = Work%(2) - 1 AND Work%(2) = Work%(5) - 1 THEN GOSUB Run3
   IF Work%(1) = Work%(3) - 1 AND Work%(3) = Work%(4) - 1 THEN GOSUB Run3
   IF Work%(1) = Work%(3) - 1 AND Work%(3) = Work%(5) - 1 THEN GOSUB Run3
   IF Work%(1) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN GOSUB Run3
   IF Work%(2) = Work%(3) - 1 AND Work%(3) = Work%(4) - 1 THEN GOSUB Run3
   IF Work%(2) = Work%(3) - 1 AND Work%(3) = Work%(5) - 1 THEN GOSUB Run3
   IF Work%(2) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN GOSUB Run3
   IF Work%(3) = Work%(4) - 1 AND Work%(4) = Work%(5) - 1 THEN GOSUB Run3

   IF Points% = 0 THEN
     LOCATE 27, 1
     PRINT "Sorry, this hand counts nothing...";
     CALL Delay(2)
     LOCATE 27, 1
     PRINT "                                  ";
   END IF
EXIT SUB

Fifteen:
Points% = Points% + 2
LOCATE 27, 1
PRINT "Fifteen for"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

FourKind:
Points% = Points% + 12
LOCATE 27, 1
PRINT "Four of a kind for"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

ThreeKind:
Points% = Points% + 6
LOCATE 27, 1
PRINT "Three of a kind for"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

TwoKind:
Points% = Points% + 2
LOCATE 27, 1
PRINT "A pair for"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

Run5:
Points% = Points% + 5
LOCATE 27, 1
PRINT "A run of 5 for"; Points%, "  ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

Run4:
Points% = Points% + 4
EarlyExit = True
LOCATE 27, 1
PRINT "A run of 4 for"; Points%, "  ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

Run3:
Points% = Points% + 3
LOCATE 27, 1
PRINT "A run of 3 for"; Points%, "  ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

Suit5:
Points% = Points% + 5
LOCATE 27, 1
PRINT "Five of the same suit for"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

Suit4:
Points% = Points% + 4
LOCATE 27, 1
PRINT "Four of the same suit for"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

HisHeels:
Points% = Points% + 1
LOCATE 27, 1
PRINT "One for his heels makes"; Points%, " ";
CALL PressKey(Answer$)
LOCATE 27, 1
PRINT "                           ";
RETURN

END SUB

SUB CribBoard (RedPeg%(), BluePeg%()) STATIC
  REM Draw Crib board
  LINE (480, 0)-(639, 479), White, BF
  LINE (482, 1)-(637, 477), Black, B

  REM Draw 8 boxes as starting point for crib board
  FOR Temp1% = 496 TO 608 STEP 16
    LINE (Temp1%, 111)-(Temp1% + 16, 363), Black, B
  NEXT Temp1%

  REM Top three arcs
  FOR Temp1% = 32 TO 64 STEP 16
    CIRCLE (560, 111), Temp1%, Black, -.0001, -3.14
  NEXT Temp1%

  REM Remove these 2 top lines permanently to cause the "S" shape
  LINE (529, 111)-(543, 111), White
  LINE (577, 111)-(591, 111), White

  REM Bottom three arcs
  FOR Temp1% = 8 TO 40 STEP 16
    CIRCLE (584, 363), Temp1%, Black, -3.14, -.0001
  NEXT Temp1%

  REM Remove these 2 bottom lines permanently to cause the "S" shape
  LINE (529, 363)-(543, 363), White
  LINE (577, 363)-(591, 363), White

  REM The two "starting" boxes for pegs
  LINE (496, 368)-(512, 404), Black, B
  LINE (512, 368)-(528, 404), Black, B

  REM Remove these 8 lines so we can "fill" it with color
  LINE (497, 111)-(511, 111), White
  LINE (513, 111)-(527, 111), White
  LINE (593, 111)-(607, 111), White
  LINE (609, 111)-(623, 111), White

  LINE (545, 363)-(559, 363), White
  LINE (561, 363)-(575, 363), White
  LINE (593, 363)-(607, 363), White
  LINE (609, 363)-(623, 363), White

  REM Fill in the Red (4) and Cyan (3) for the main board
  PAINT (497, 111), Red, Black
  PAINT (513, 111), Cyan, Black

  REM Fill in the Red (4) and Cyan (3) for the starting block
  PAINT (497, 403), Red, Black
  PAINT (513, 403), Cyan, Black

  REM The black lines seperating pegs into 5 point sections
  FOR Temp1% = 111 TO 363 STEP 36
    LINE (496, Temp1%)-(528, Temp1%), Black
    LINE (544, Temp1%)-(576, Temp1%), Black
    LINE (592, Temp1%)-(624, Temp1%), Black
  NEXT Temp1%

  REM The black vertical line seperating top arc into 5 point sections
  LINE (560, 78)-(560, 47), Black

  REM Now draw the winning "hole"
  PSET (559, 99), Black
  DRAW "C0 BR3 R3 D3 L3 D3 L3 U3 L3 U3 R3 U3 R3 D3 BF1 P0,0"

  REM Now to draw the home peg "holes"
  Temp2% = 403
  FOR Temp1% = 1 TO 5
    Temp2% = Temp2% - 6
    PSET (502, Temp2%), Black
    DRAW "C0 R3 D3 L3 U3 BF1 P0,0": REM Draw a Hole
    PSET (519, Temp2%), Black
    DRAW "C0 R3 D3 L3 U3 BF1 P0,0": REM Draw a Hole
  NEXT Temp1%

  FOR Temp1% = 1 TO 121
    PSET (RedPeg%(Temp1%, 1), RedPeg%(Temp1%, 2)), Black
    DRAW "C0 R3 D3 L3 U3 BF1 P0,0": REM Draw a Hole
  NEXT Temp1%

  FOR Temp1% = 1 TO 121
    PSET (BluePeg%(Temp1%, 1), BluePeg%(Temp1%, 2)), 0
    DRAW "C0 R3 D3 L3 U3 BF1 P0,0": REM Draw a Hole
  NEXT Temp1%

  REM - Draw Skunk line with "S"
  LINE (541, 327)-(579, 327), Black
  LINE (541, 328)-(579, 328), Black
  PSET (540, 323), Black
  DRAW "C5 D2 L1 U2 L3 D1 L1 D3 R1 D1 R3 D1 R1 D3 L1 D1 L3 U2 L1 D1"
  PSET (585, 323), Black
  DRAW "C5 D2 L1 U2 L3 D1 L1 D3 R1 D1 R3 D1 R1 D3 L1 D1 L3 U2 L1 D1"

  REM Draw CRIBBAGE logo
  REM Letter "C"
  PSET (495, 450), White
  DRAW "C0 R8 F1 D1 R1 F1 D3 G1 L3 H1 U3 L3 D13 R3 U3 E1 R3 F1 D3 G1"
  DRAW "L1 D1 G1 L7 H1 U1 L1 H1 U13 E1 R1 U1 E1"
  DRAW "BF1 P4,0"
  REM Letter "R"
  PSET (511, 450), White
  DRAW "C0 R10 F1 D1 R1 F1 D5 G1 L1 D3 R1 F1 D5 G1 L3 H1 U5 L1 H1"
  DRAW "U1 L1 D7 G1 L3 H1 U17 E1 BR4 BD3 R3 D5 L3 U5 BU3 BL4"
  DRAW "BF1 P4,0"
  REM Letter "I"
  PSET (527, 450), White
  DRAW "C0 BR2 R8 F1 D1 G1 L1 D13 R1 F1 D1 G1 L7 H1 U1 E1 R1 U13 L1"
  DRAW "H1 U1 E1"
  DRAW "BF1 P4,0"
  REM Letter "B"
  PSET (542, 450), White
  DRAW "C0 R10 F1 D1 R1 F1 D5 G1 L1 D1 R1 F1 D5 G1 L1 D1 G1"
  DRAW "L9 H1 U17 E1 BR5 BD3 R3 D5 L3 U5 BD8 R3 D5 L3 U5"
  DRAW "BH1 P4,0"
  REM Letter "B"
  PSET (559, 450), White
  DRAW "C0 R10 F1 D1 R1 F1 D5 G1 L1 D1 R1 F1 D5 G1 L1 D1 G1"
  DRAW "L9 H1 U17 E1 BR5 BD3 R3 D5 L3 U5 BD8 R3 D5 L3 U5"
  DRAW "BH1 P4,0"
  REM Letter "A"
  PSET (575, 450), White
  DRAW "C0 BR4 R4 F1 D1 R1 F1 D1 R1 F1 D13 G1 L3 H1 U5 L3 D5 G1"
  DRAW "L3 H1 U13 E1 R1 U1 E1 U1 R1 BR1 BD4 R3 D5 L3 U5"
  DRAW "BH1 P4,0"
  REM Letter "G"
  PSET (591, 450), White
  DRAW "C0 BR2 R8 F1 D1 R1 F1 D3 G1 L3 H1 U3 L3 D13 R3 U3 L1 H1"
  DRAW "U1 E1 R5 F1 D7 G1 L9 H1 U1 L1 H1 U13 E1 R1 U1"
  DRAW "BF1 P4,0"
  REM Letter "E"
  PSET (607, 450), White
  DRAW "C0 R12 F1 D1 G1 L7 D5 R5 F1 D1 G1 L5 D5 R7 F1 D1 G1 L11"
  DRAW "H1 U17"
  DRAW "BF1 P4,0"

  REM - Draw Starting "pegs"
  CALL DrawRedPeg(RedPeg%(), 122)
  CALL DrawRedPeg(RedPeg%(), 123)

  CALL DrawBluePeg(BluePeg%(), 122)
  CALL DrawBluePeg(BluePeg%(), 123)

END SUB

SUB CribCut STATIC
ReCut:
   CALL ShuffleCards(Deck%(), Suit%(), Rank%(), Value%())
   CALL ShuffleDisplay

 CALL Delay(1)
 CALL EraseLine
 LOCATE 19, 5
 COLOR Green
 PRINT "Lowest card drawn determines who gets the first CRIB.";

 CALL Delay(1)
 LOCATE 21, 5: PRINT "Now cutting for first crib....";
 CALL Delay(1)

 COLOR Red
 LOCATE 17, 23: PRINT "Yours";
 TopCol% = 159: TopRow% = 125: CurrentCard% = 14
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
 CALL Delay(1)

 COLOR Cyan
 LOCATE 17, 44: PRINT "Mine";
 TopCol% = 315: TopRow% = 125: CurrentCard% = 13
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
 CALL Delay(1)
 COLOR Green

 IF Rank%(13) = Rank%(14) THEN
   LOCATE 21, 1
   PRINT STRING$(59, " ");
   LOCATE 21, 5
   COLOR White
   PRINT "Tie in cut!!        ";
   CALL Delay(3)

   LOCATE 21, 1
   PRINT STRING$(59, " ");
   LOCATE 17, 23: PRINT "     ";
   TopCol% = 159: TopRow% = 125: CurrentCard% = 13
   CALL EraseCard(TopCol%, TopRow%)
   LOCATE 17, 44: PRINT "    ";
   TopCol% = 315: TopRow% = 125: CurrentCard% = 14
   CALL EraseCard(TopCol%, TopRow%)

   GOTO ReCut
 END IF
   LOCATE 21, 1
   PRINT STRING$(59, " ");

 IF Rank%(13) < Rank%(14) THEN
   LOCATE 21, 5
   COLOR Cyan
   PRINT "I have first CRIB.";
   CurrentCrib% = Computer
 ELSE
   LOCATE 21, 5
   COLOR Red
   PRINT "You have first CRIB.";
   CurrentCrib% = Player
 END IF

 CALL Continue

 TopCol% = 159: TopRow% = 125: CurrentCard% = 1
 CALL EraseCard(TopCol%, TopRow%)
 TopCol% = 315: TopRow% = 125: CurrentCard% = 2
 CALL EraseCard(TopCol%, TopRow%)

 FOR Temp1% = 17 TO 29
   LOCATE Temp1%, 1
   PRINT STRING$(59, " ");
 NEXT Temp1%
END SUB

SUB Delay (Seconds!) STATIC
Finish! = TIMER + Seconds!
ReadTime:
 Start! = TIMER
   IF Start! < Finish! THEN GOTO ReadTime
END SUB

SUB DisplayMeld (CurrentCrib%, CurrentMeld%) STATIC
  CONST Computer = 1
  CONST Player   = 0

  COLOR Green
    IF CurrentCrib% = Computer THEN
      LOCATE 20, 45
      PRINT "Current Meld";
      LOCATE 21, 49
      PRINT CurrentMeld%;
    ELSE
      LOCATE 4, 45
      PRINT "Current Meld";
      LOCATE 5, 49
      PRINT CurrentMeld%;
    END IF
END SUB

SUB DrawBlueHole (BluePeg%(), Temp1%) STATIC
  PSET (BluePeg%(Temp1%, 1), BluePeg%(Temp1%, 2)), 0
  DRAW "C0 R3 D3 L3 U3 BF1 P0,0 BH2 C3 R6 D5 L1 U5 D5 L5 U5"
END SUB

SUB DrawBluePeg (BluePeg%(), Temp1%) STATIC
  PSET (BluePeg%(Temp1%, 1), BluePeg%(Temp1%, 2)), 0
  DRAW "BU1 C1 R4 D1 R1 D2 L1 D1 L4 U1 L1 U2 R1 U1 BF1 P7,1"
END SUB

SUB DrawRedHole (RedPeg%(), Temp1%) STATIC
  PSET (RedPeg%(Temp1%, 1), RedPeg%(Temp1%, 2)), 0
  DRAW "C0 R3 D3 L3 U3 BF1 P0,0 BH2 C4 R6 D5 L1 U5 D5 L5 U5"
END SUB

SUB DrawRedPeg (RedPeg%(), Temp1%) STATIC
  PSET (RedPeg%(Temp1%, 1), RedPeg%(Temp1%, 2)), 0
  DRAW "BU1 C12 R4 D1 R1 D2 L1 D1 L4 U1 L1 U2 R1 U1 BF1 P7,12"
END SUB

SUB EraseCard (TopCol%, TopRow%) STATIC
  FOR Temp1% = TopCol% + 76 TO TopCol% STEP -1
    LINE (Temp1%, TopRow%)-(Temp1%, TopRow% + 114), 0
  NEXT Temp1%
END SUB

SUB EraseLine STATIC
  LOCATE 27, 1
  PRINT STRING$(59, " ")
  LOCATE 27, 1
END SUB

SUB Instructions STATIC

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "Cribbage is a strategy game for two players.               "
  PRINT
  PRINT "It is believed to have been invented and christened by     "
  PRINT "the English poet Sir John Suckling, who lived 1609-1642.   "
  PRINT "Some of its features were taken from an older game, Noddy, "
  PRINT "of which little is known.  Early colonists brought Cribbage"
  PRINT "to America, where it flourishes.  In New England there are "
  PRINT "clubs devoted to Cribbage, conducting intra- and intercity "
  PRINT "tournaments."
  PRINT
  PRINT "PLAYERS:  Two.  Adaptation can be made for three or four.  "
  PRINT
  PRINT "CARDS:  A regular pack of 52.  The cards rank: K (high),   "
  PRINT "Q, J, 10, 9, 8, 7, 6, 5, 4, 3, 2, A.  The suits play       "
  PRINT "little part; the cards are used chiefly as numbers.  Each  "
  PRINT "face card represents 10, each ace 1, each other card its   "
  PRINT "index value.  Face cards and tens are called tenth cards.  "
  PRINT
  PRINT "First the cards are shuffled and randomly cut, and each    "
  PRINT "opponent is dealt a card face up.  The lowest card gets    "
  PRINT "the privilege of getting the first crib hand.  Note, the   "
  PRINT "Duce (2) is low and the Ace (1) considered high.           "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "THE DEAL:                                                  "
  PRINT "Next, the cards are again shuffled and each player is      "
  PRINT "dealt 6 cards, one at a time.  The turn to deal alternates "
  PRINT "each hand.  Each player must decide which 4 cards to retain"
  PRINT "and which 2 cards to discard to the CRIB (or extra) hand.  "
  PRINT "                                                           "
  PRINT "This is where a large part of the strategy comes into play."
  PRINT "                                                           "
  PRINT "Position the pointer over the first card you wish to       "
  PRINT "discard and click the left mouse button once.  Then        "
  PRINT "position the pointer over the second card to discard,      "
  PRINT "and again click the left mouse button once.                "
  PRINT "                                                           "
  PRINT "Keyboard users select the cards to discard by pressing     "
  PRINT "the numbers 1 to 6, as are shown underneath each playing   "
  PRINT "card (mouse users may also press a number key).            "
  PRINT "                                                           "
  PRINT "Be careful..  Once you have selected a discard you may     "
  PRINT "not change your mind.  Hence the phrase:                   "
  COLOR BrightWhite
  PRINT "                                                           "
  PRINT "               A CARD LAID IS A CARD PLAYED                "
  PRINT "                                                           "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "THE CRIB:                                                  "
  PRINT "The two cards that each play discards are placed face      "
  PRINT "down near the dealer.  They form the crib, an extra hand   "
  PRINT "that belongs to the dealer.                                "
  PRINT "                                                           "
  PRINT "THE STARTER:                                               "
  PRINT "                                                           "
  PRINT "After the crib is laid away, the rest of the pack is cut   "
  PRINT "and the top card of the lower portion is turned up.        "
  PRINT "                                                           "
  PRINT "This card is the starter.  If it is a jack the dealer      "
  PRINT "pegs (scores) 2 points.                                    "
  PRINT "                                                           "
  PRINT "THE CRIBBAGE BOARD:                                        "
  PRINT "                                                           "
  PRINT "Scores accrue so rapidly that a special scoring device is  "
  PRINT "used, a cribbage board.  As shown on the right, the board  "
  PRINT "is an S-shaped panel having two rows of 120 holes each,    "
  PRINT "plus some extra game holes at one end.  Each player uses   "
  PRINT "two pegs, which at the outset are placed in the end        "
  PRINT "starter holes.  The last hole (the 121st) is the final     "
  PRINT "game hole.  The first player to reach it wins the game.    "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "Each item of score is marked by jumping the rearward peg   "
  PRINT "ahead of the other by a corresponding number of holes.     "
  PRINT "                                                           "
  PRINT "In this electronic version, the score is maintained by the "
  PRINT "computer.  The red line of holes is for you, the blue      "
  PRINT "line of holes is used by your computer opponent.           "
  PRINT "                                                           "
  PRINT "THE PLAY:                                                  "
  PRINT "                                                           "
  PRINT "The nondealer begins by playing any card, announcing its   "
  PRINT "point value, as ";CHR$(34);"Ten";CHR$(34);" if he leads a face card or ten. "
  PRINT "This is called the meld count, and is shown on the screen  "
  PRINT "numerically (as the computer cannot vocalize the count).   "
  PRINT "                                                           "
  PRINT "The dealer then plays a card, announcing the total of the  "
  PRINT "two cards, as ";CHR$(34);"Seventeen";CHR$(34);" if he plays a seven.  "
  PRINT "                                                           "
  PRINT "Play continues alternately, the new total being announced  "
  PRINT "(or displayed) each time, until the player in turn is      "
  PRINT "unable to play without carrying the total over thirty-one. "
  PRINT "                                                           "
  PRINT "He must then GO.  (Explained in more detail next)          "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "If you cannot play without exceeding the meld count of     "
  PRINT "thirty-one (31) then you must position the pointer over    "
  PRINT "the word GO and click the left mouse button once.          "
  PRINT "                                                           "
  PRINT "Keyboard users press the letter G, to indicate a GO.       "
  PRINT "                                                           "
  PRINT "After a go is called, the other must play additional cards "
  PRINT "if he can do so without exceeding thirty-one.  Thus the    "
  PRINT "same player may play two or three times in succession.     "
  PRINT "                                                           "
  PRINT "For making EXACTLY thirty-one the player pegs 2; for a     "
  PRINT "go at less than thirty-one he pegs 1.                      "
  PRINT "                                                           "
  PRINT "Playing the last card of all (of the eight in play) counts "
  PRINT "1 for LAST CARD, or 2 if it makes exactly thirty-one.      "
  PRINT "                                                           "
  PRINT "SCORING IN PLAY:                                           "
  PRINT "                                                           "
  PRINT "Other points may be scored in play besides the go's.       "
  PRINT "                                                           "
  PRINT "The program will count them for you in this computer       "
  PRINT "version of cribbage, and they are as follows:              "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "FIFTEEN.  For making the meld count fifteen, peg 2.        "
  PRINT "                                                           "
  PRINT "PAIRS.    For playing a card of the same rank as that      "
  PRINT "  just played by an opponent, peg 2.  (Pairing goes by     "
  PRINT "  rank, e.g., a King with a King, not with a Queen,        "
  PRINT "  though both have the point value of 10.)  For playing    "
  PRINT "  the third card of a rank peg 6, and for playing the      "
  PRINT "  fourth (or four-of-a-kind) peg 12.                       "
  PRINT "                                                           "
  PRINT "RUNS.     For playing a card that is in sequence of rank   "
  PRINT "  with two or more played just previously, peg the number  "
  PRINT "  of cards in the run (sequence).  For example, if the     "
  PRINT "  cards played are 4, 6, 5, the last player pegs 3 for the "
  PRINT "  run PLUS 2 for fifteen.  The cards need not be played    "
  PRINT "  in sequential order to score for run, so long as no      "
  PRINT "  foreign cards intervene.  For example, if the cards      "
  PRINT "  played are 4, K, 6, 5 there is no run.                   "
  PRINT "                                                           "
  PRINT "SHOWING:                                                   "
  PRINT "                                                           "
  PRINT "Showing means counting and scoring a hand.  The hands are  "
  PRINT "shown in strict order:  Nondealer, Dealer's hand & Crib.   "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "SHOWING (COUNTING) continued....                           "
  PRINT "                                                           "
  PRINT "The starter is treated as a fifth card belonging to each   "
  PRINT "of the three hands (Nondealer, Dealer and Crib).           "
  PRINT "                                                           "
  PRINT "Combinations that score are as follows:                    "
  PRINT "                                                           "
  PRINT "FIFTEEN.  For each combination of cards that total fifteen,"
  PRINT "  score 2.  Combination here is meant in the strict sense. "
  PRINT "  Thus, a hand (with starter) of 9, 8, 7, 7, 6 has three   "
  PRINT "  combinations of fifteen:  9 and 6, 8 with one 7, 8 with  "
  PRINT "  the other 7.  A hand of J, 5, 5, 5, 5 has no less than   "
  PRINT "  eight combinations of fifteen:  four of J and 5, and     "
  PRINT "  four of three 5's.                                       "
  PRINT "                                                           "
  PRINT "  This hand, when the Jack also scores as his nobs, makes  "
  PRINT "  29, the largest possible score.                          "
  PRINT "                                                           "
  PRINT "PAIRS.  For a pair, score 2; for three of a kind score 6;  "
  PRINT "  for four of a kind (double pair royal) score 12.         "
  PRINT "                                                           "
  PRINT "                                                           "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "SHOWING (COUNTING) continued....                           "
  PRINT "                                                           "
  PRINT "RUNS.      For each combination that makes a run of three  "
  PRINT "  or more, peg the number of cards in the run.  In the hand"
  PRINT "  9, 8, 7, 7, 6 there are 8 points for two runs of four,   "
  PRINT "  using the seven's in turn.                               "
  PRINT "                                                           "
  PRINT "FLUSH.     For four cards in hand (not crib, and excluding "
  PRINT "  the starter) of the same suit, score 4 or 5 if the       "
  PRINT "  starter is also of the same suit.  For crib and starter  "
  PRINT "  all of the same suit, score 5.  (There is no score       "
  PRINT "  for a four-flush in the crib.)                           "
  PRINT "                                                           "
  PRINT "HIS NOBS.  For a Jack in hand, of the same suit as the     "
  PRINT "  starter, score 1.  The Jack scored as starter by the     "
  PRINT "  dealer is called HIS HEELS.                              "
  PRINT "                                                           "
  PRINT "NINETEEN.  Since no combination of cards will score        "
  PRINT "  exactly nineteen, this is a term sometimes used in       "
  PRINT "  place of * no score *, when counting.                    "
  PRINT "                                                           "
  PRINT "The program will count the hands, as explained next.       "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "During the scoring of the hands, each combination that     "
  PRINT "results in a score (Fifteens, Pairs, Runs, Flush and       "
  PRINT "His Nobs) are shown, along with the accumulated total for  "
  PRINT "that hand.                                                 "
  PRINT "                                                           "
  PRINT "Press the left mouse button (or any key on the keyboard)   "
  PRINT "to continue the count.  This gives you a chance to         "
  PRINT "practice counting along with the computer, just to keep    "
  PRINT "it honest.                                                 "
  PRINT "                                                           "
  PRINT "GAME.                                                      "
  PRINT "                                                           "
  PRINT "When a player pegs into the game hole that gives him 121   "
  PRINT "points, he wins the game forthwith -- nothing more is      "
  PRINT "scored.  If the loser has not reached the halfway mark     "
  PRINT "(61 points) he is SKUNKED or lurched and considered to     "
  PRINT "lose a double game.  The Skunk line is marked with the     "
  PRINT "letter S on the cribbage board.                            "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "STRATEGY OF CRIBBAGE:                                      "
  PRINT "                                                           "
  PRINT "The choice of cards to give the crib is often easy.  Count "
  PRINT "all the points in the six cards, then lay away the two     "
  PRINT "picked to leave the maximum possible score in the          "
  PRINT "remaining four.  But sometimes this course would put       "
  PRINT "points or valuable cards in the crib, so that if the crib  "
  PRINT "is not yours you may do better to deplete your hand        "
  PRINT "somewhat in order to BALK the crib.                        "
  PRINT "                                                           "
  PRINT "Dangerous cards to put in the adverse crib are fives,      "
  PRINT "sevens and eights and NEAR cards -- two in sequence or in  "
  PRINT "sequence-but-one.  The best balking cards are very high,   "
  PRINT "very low, and wide cards generally  -- separated in rank   "
  PRINT "by two or more.                                            "
  PRINT "                                                           "
  PRINT "Sometimes you are forced to split combinations, even when  "
  PRINT "the crib is yours.  As a rule, keep a run of three or      "
  PRINT "more, splitting a pair instead, if necessary.  Holding a   "
  PRINT "run gives you maximum chance of increasing your count by   "
  PRINT "help of the starter.                                       "
  PRINT "                                                           "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "STRATEGY OF CRIBBAGE (continued):                          "
  PRINT "                                                           "
  PRINT "I have included a Hint facility to help novices learn      "
  PRINT "what cards the computer would discard, had it been dealt   "
  PRINT "the same hand.  Please note, the computer plays VERY       "
  PRINT "conservatively and does not weigh all the options of       "
  PRINT "chance.  You may see an even better choice than it's HINT. "
  PRINT "                                                           "
  PRINT "Once play has begun, the hint will suggest the best valid  "
  PRINT "card to play.  However, the human brain is far better at   "
  PRINT "examining all the myriad of possible play combinations,    "
  PRINT "and you will most often disagree with what the computer    "
  PRINT "suggests.                                                  "
  PRINT "                                                           "
  PRINT "The save game facility creates a file called CRIB.SAV.     "
  PRINT "This is intended for a future release that will allow a    "
  PRINT "restore of a previously saved game.                        "
  PRINT "                                                           "
  PRINT "The Quit option exits the game immediately, as will the Esc"
  PRINT "(Escape) key at any time keyboard/mouse input is expected. "

  CALL ContPlay (Answer$)
  IF Answer$ = "P" THEN EXIT SUB

  CALL ClearScreen(29)
  COLOR BrightWhite
  LOCATE 1, 1
  PRINT "CRIBBAGE";
  LOCATE 3, 1
  PRINT "The classic two-hand card game.";
  COLOR Cyan
  LOCATE 5, 1
  PRINT "                                                           "
  PRINT "For those who are interested, this program was completely  "
  PRINT "written and compiled with Microsoft QuickBASIC version     "
  PRINT "4.00.  Source code and a compiler batch file are included  "
  PRINT "for the technically oriented.                              "
  PRINT "                                                           "
  PRINT "It was produced on an IBM PS/2 Model 30-286 with 1 Meg.    "
  PRINT "of memory and a 40 Meg fixed disk.  A Microsoft mouse was  "
  PRINT "the pointing device, and an IBM 8513 VGA color monitor was "
  PRINT "the video display.                                         "
  PRINT "                                                           "
  PRINT "Many friends at Westech Information Systems tried it out   "
  PRINT "on quite a variety of equipment combinations, and offered  "
  PRINT "valuable feedback and beta-testing.                        "
  PRINT "                                                           "
  PRINT "In the interest of promoting free public domain software   "
  PRINT "I sincerely hope that no one commercially benefits from    "
  PRINT "my efforts.  I make no copyright or claim other than to    "
  PRINT "hope you enjoy it.                                         "
  PRINT "                                                           "
  PRINT "      NOW, ON TO PLAYING THE GAME...                       "
  CALL Continue

END SUB

SUB Logo STATIC
 COLOR BrightWhite
 LOCATE 1, 1
 PRINT "CRIBBAGE";
 COLOR Yellow
 LOCATE 1, 40
 PRINT "Release 1.07";
 COLOR BrightWhite
 LOCATE 3, 1
 PRINT "The classic two-hand card game.";
 Suit%(1) = 4: Rank%(1) = 5
 Suit%(2) = 3: Rank%(2) = 5
 Suit%(3) = 2: Rank%(3) = 5
 Suit%(4) = 1: Rank%(4) = 11
 Suit%(5) = 1: Rank%(5) = 5

 COLOR Cyan
 LOCATE 5,25
 PRINT "Programmed by Don Hanson";
 LOCATE 6,26
 PRINT "7362 Brandywine Place";
 LOCATE 7,29
 PRINT "Vancouver, B.C.";
 LOCATE 8,33
 PRINT "Canada";

 LOCATE 10,1:PRINT "ShareWare..";
 COLOR Green
 LOCATE 12,1:PRINT "Please feel  free";
 LOCATE 13,1:PRINT "to copy or upload";
 LOCATE 14,1:PRINT "to your  favorite";
 LOCATE 15,1:PRINT "Bulletin Board.  ";

 LOCATE 17,1:PRINT "I hope  you enjoy";
 LOCATE 18,1:PRINT "playing  as  much";
 LOCATE 19,1:PRINT "as I  did writing";
 LOCATE 20,1:PRINT "it.";

 TopCol% = 155: TopRow% = 152: CurrentCard% = 1
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
 TopCol% = 180: TopRow% = 162: CurrentCard% = 2
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
 TopCol% = 205: TopRow% = 172: CurrentCard% = 3
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
 TopCol% = 230: TopRow% = 182: CurrentCard% = 4
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
 TopCol% = 330: TopRow% = 182: CurrentCard% = 5
 CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

 COLOR Yellow
 LOCATE 23, 3
 PRINT "Do you wish instructions? ";
 COLOR Green
 CALL YesNo(Answer$)

 FOR Temp1% = 4 TO 28
   LOCATE Temp1%,1
   PRINT STRING$(59," ");
 NEXT Temp1%

 IF Answer$ = "Y" THEN
   CALL Instructions
   CALL ClearScreen(29)
 END IF

END SUB

SUB MoveBlue (BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%) STATIC
   IF Points% = 0 THEN EXIT SUB

   IF BlueBackPeg% = 123 THEN
     CALL DrawBlueHole(BluePeg%(), 123)
     BlueBackPeg% = 122
   ELSEIF BlueBackPeg% = 122 THEN
     CALL DrawBlueHole(BluePeg%(), 122)
     BlueBackPeg% = BlueScore%
   ELSE
     CALL DrawBlueHole(BluePeg%(), BlueBackPeg%)
     BlueBackPeg% = BlueScore%
   END IF

   IF BlueScore% + Points% > 121 THEN
     Points% = 121 - BlueScore%
   END IF

   IF Points% > 1 THEN
     FOR Temp2% = BlueScore% + 1 TO BlueScore% + Points%
       IF Temp2% <> 121 THEN
         CALL DrawBluePeg(BluePeg%(), Temp2%)
         CALL Clicks(Points%)
         CALL DrawBlueHole(BluePeg%(), Temp2%)
       END IF
     NEXT Temp2%
   ELSE
       CALL Clicks(Points%)
   END IF

   BlueScore% = BlueScore% + Points%
   IF BlueScore% <> 121 THEN
     CALL DrawBluePeg(BluePeg%(), BlueScore%)
   END IF

   IF BlueScore% = 121 THEN
     PSET (BluePeg%(121, 1), BluePeg%(121, 2)), 0
     DRAW "BU1 C12 R4 D1 R1 D2 L1 D1 L4 U1 L1 U2 R1 U1 BF1 P3,12"
     CALL ClearScreen(29)
     CALL BottomLine (Black,Black)
     CALL StarBurst
     COLOR Green
     LOCATE 10,25 :PRINT "          ";
     LOCATE 11,25 :PRINT "  I won.  ";
     LOCATE 12,25 :PRINT "          ";
     IF RedScore% < 91 THEN
       LOCATE 13,16 :PRINT "                           ";
       LOCATE 14,16 :PRINT " In fact, I skunked you... ";
       LOCATE 15,16 :PRINT "                           ";
     END IF

     FOR Temp1% = 22 TO 27
       LOCATE Temp1%,3
       PRINT STRING$(24," ");
     NEXT Temp1%

     COLOR White
     LOCATE 23, 3
     PRINT "   Want to play again?  ";
     CALL YesNo(Answer$)
     CLS

     IF Answer$ = "Y" THEN
       CALL NewGame
     ELSE
       LOCATE 13, 1
       PRINT "Thanks for playing with me.."
       CALL Delay(3)
       END
     END IF
   END IF
END SUB

SUB MoveRed (RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%) STATIC
   IF Points% = 0 THEN EXIT SUB

   IF RedBackPeg% = 123 THEN
     CALL DrawRedHole(RedPeg%(), 123)
     RedBackPeg% = 122
   ELSEIF RedBackPeg% = 122 THEN
     CALL DrawRedHole(RedPeg%(), 122)
     RedBackPeg% = RedScore%
   ELSE
     CALL DrawRedHole(RedPeg%(), RedBackPeg%)
     RedBackPeg% = RedScore%
   END IF

   IF RedScore% + Points% > 121 THEN
     Points% = 121 - RedScore%
   END IF

   IF Points% > 1 THEN
     FOR Temp2% = RedScore% + 1 TO RedScore% + Points%
       IF Temp2% <> 121 THEN
         CALL DrawRedPeg(RedPeg%(), Temp2%)
         CALL Clicks(Points%)
         CALL DrawRedHole(RedPeg%(), Temp2%)
       END IF
     NEXT Temp2%
   ELSE
       CALL Clicks(Points%)
   END IF

   RedScore% = RedScore% + Points%
   IF RedScore% <> 121 THEN
     CALL DrawRedPeg(RedPeg%(), RedScore%)
   END IF

   IF RedScore% = 121 THEN
     PSET (RedPeg%(121, 1), RedPeg%(121, 2)), 0
     DRAW "BU1 C12 R4 D1 R1 D2 L1 D1 L4 U1 L1 U2 R1 U1 BF1 P4,12"
     CALL ClearScreen(29)
     CALL BottomLine (Black,Black)
     CALL StarBurst
     COLOR Green
     LOCATE 10,25 :PRINT "          ";
     LOCATE 11,25 :PRINT " You won. ";
     LOCATE 12,25 :PRINT "          ";
     IF BlueScore% < 91 THEN
       LOCATE 13,16 :PRINT "                           ";
       LOCATE 14,16 :PRINT " In fact, you skunked me.. ";
       LOCATE 15,16 :PRINT "                           ";
     END IF

     FOR Temp1% = 22 TO 27
       LOCATE Temp1%,3
       PRINT STRING$(24," ");
     NEXT Temp1%

     COLOR White
     LOCATE 23, 3
     PRINT "   Want to play again?  ";
     CALL YesNo(Answer$)
     CLS

     IF Answer$ = "Y" THEN
       CALL NewGame
     ELSE
       LOCATE 13, 1
       PRINT "Thanks for playing with me.."
       CALL Delay(3)
       END
     END IF
   END IF
END SUB

SUB NewGame STATIC
   FirstGame% = FirstGame% + 1
   ComputerGo% = False
   PlayerGo%   = False
   RedScore%  = 0: RedBackPeg%  = 123
   BlueScore% = 0: BlueBackPeg% = 123

   IF FirstGame% <> 1 THEN CALL CribBoard(RedPeg%(), BluePeg%())
   CALL CribCut
NextHand:
   CALL PlayGame
   CALL ShuffleCards(Deck%(), Suit%(), Rank%(), Value%())
   CALL ShuffleDisplay

   GOTO NextHand
END SUB

SUB PlayGame STATIC
   COLOR Green
   CALL ClearScreen(27)
   PlayCount% = 0
   MeldCount% = 1
   CurrentMeld% = 0

  REM * Sort Players initial cards (1-6) in Rank% order *
  REM * This helps in counting runs of 3/4              *
  FOR Temp1% = 1 TO 6
  FOR Temp2% = 1 TO 5
    IF Rank%(Temp2%) > Rank%(Temp2% + 1) THEN
      SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      SWAP Suit%(Temp2%), Suit%(Temp2% + 1)
      SWAP Rank%(Temp2%), Rank%(Temp2% + 1)
      SWAP Value%(Temp2%), Value%(Temp2% + 1)
    END IF
  NEXT Temp2%
  NEXT Temp1%

    TopCol% = 3: TopRow% = 3: CurrentCard% = 1
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 3: TopRow% = 248: CurrentCard% = 7
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 81: TopRow% = 3: CurrentCard% = 2
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 81: TopRow% = 248: CurrentCard% = 8
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 159: TopRow% = 3: CurrentCard% = 3
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 159: TopRow% = 248: CurrentCard% = 9
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 237: TopRow% = 3: CurrentCard% = 4
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 237: TopRow% = 248: CurrentCard% = 10
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 315: TopRow% = 3: CurrentCard% = 5
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 315: TopRow% = 248: CurrentCard% = 11
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 393: TopRow% = 3: CurrentCard% = 6
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)
    TopCol% = 393: TopRow% = 248: CurrentCard% = 12
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    CALL Delay(.25)

    CALL Delay(1)
    TopCol% = 3: TopRow% = 248: CurrentCard% = 7
    CALL EraseCard(TopCol%, TopRow%)
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 81: TopRow% = 248: CurrentCard% = 8
    CALL EraseCard(TopCol%, TopRow%)
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 159: TopRow% = 248: CurrentCard% = 9
    CALL EraseCard(TopCol%, TopRow%)
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 237: TopRow% = 248: CurrentCard% = 10
    CALL EraseCard(TopCol%, TopRow%)
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 315: TopRow% = 248: CurrentCard% = 11
    CALL EraseCard(TopCol%, TopRow%)
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 393: TopRow% = 248: CurrentCard% = 12
    CALL EraseCard(TopCol%, TopRow%)
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

CardsShown:

    LINE (  0, 376)-( 28, 376)
    LINE ( 43, 376)-(106, 376)
    LINE (124, 376)-(187, 376)
    LINE (205, 376)-(268, 376)
    LINE (282, 376)-(347, 376)
    LINE (363, 376)-(427, 376)
    LINE (444, 376)-(470, 376)
    LOCATE 24,  5: PRINT "1";
    LOCATE 24, 15: PRINT "2";
    LOCATE 24, 25: PRINT "3";
    LOCATE 24, 35: PRINT "4";
    LOCATE 24, 45: PRINT "5";
    LOCATE 24, 55: PRINT "6";

    CALL BottomLine (Green,White)
ReadButton1:
    CALL EraseLine
    COLOR Green
    PRINT "What card do you wish to discard first to ";
    IF CurrentCrib = Computer THEN
      COLOR Cyan
      PRINT "my";
    ELSE
      COLOR Red
      PRINT "your";
    END IF
    COLOR Green
    PRINT " crib? ";

    CALL ButtonStatus
    SELECT CASE Answer$
     CASE "1"
       REM Card #7 is pointed to
       Answer = VAL(Answer$)
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(3) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 393
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "2"
       REM Card #8 is pointed to
       Answer = VAL(Answer$)
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(3) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 393
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "3"
       REM Card #9 is pointed to
       Answer = VAL(Answer$)
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(3) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 393
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "4"
       REM Card #10 is pointed to
       Answer = VAL(Answer$)
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(3) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 393
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "5"
       REM Card #11 is pointed to
       Answer = VAL(Answer$)
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(3) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 393
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "6"
       REM Card #12 is pointed to
       Answer = VAL(Answer$)
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(3) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 393
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE ELSE
       REM Mouse not on any user card
       GOTO ReadButton1
     END SELECT

ReadButton2:
    CALL EraseLine
    COLOR Green
    PRINT "What other card do you wish to discard to ";
    IF CurrentCrib = Computer THEN
      COLOR Cyan
      PRINT "my";
    ELSE
      COLOR Red
      PRINT "your";
    END IF
    COLOR Green
    PRINT " crib? ";

    CALL ButtonStatus
    SELECT CASE Answer$
     CASE "1"
       REM Card #7 is pointed to
       Answer = VAL(Answer$)
       IF Deck%(Answer + 6) = 99 THEN GOTO ReadButton2
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(4) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 378
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "2"
       REM Card #8 is pointed to
       Answer = VAL(Answer$)
       IF Deck%(Answer + 6) = 99 THEN GOTO ReadButton2
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(4) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 378
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "3"
       REM Card #9 is pointed to
       Answer = VAL(Answer$)
       IF Deck%(Answer + 6) = 99 THEN GOTO ReadButton2
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(4) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 378
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "4"
       REM Card #10 is pointed to
       Answer = VAL(Answer$)
       IF Deck%(Answer + 6) = 99 THEN GOTO ReadButton2
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(4) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 378
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "5"
       REM Card #11 is pointed to
       Answer = VAL(Answer$)
       IF Deck%(Answer + 6) = 99 THEN GOTO ReadButton2
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(4) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 378
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE "6"
       REM Card #12 is pointed to
       Answer = VAL(Answer$)
       IF Deck%(Answer + 6) = 99 THEN GOTO ReadButton2
       PRINT Answer$;
       TopCol% = ((Answer-1)*78) + 3
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(4) = Deck%(Answer + 6)
       Deck%(Answer + 6) = 99
       TopCol% = 378
       TopRow% = 125
       CurrentCard% = Answer + 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     CASE ELSE
       REM Mouse not on any user card
       GOTO ReadButton2
     END SELECT

    CALL EraseLine
    CALL Delay(1)
    CALL BestHand(Work%(), Discard%(), Rank%(), Value%(), Suit%())

    CALL EraseLine
    PRINT "OK, I will discard this one";
    IF CurrentCrib = Computer THEN
      PRINT " to my crib...";
    ELSE
      PRINT " to your crib...";
    END IF
    Temp1% = Discard%(1)
    Temp2% = Discard%(2)

    IF Temp1% = 1 THEN
       TopCol% = 3
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(1) = Deck%(1)
       Deck%(1) = 99
       TopCol% = 363
       TopRow% = 125
       CurrentCard% = 1
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp1% = 2 THEN
       TopCol% = 81
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(1) = Deck%(2)
       Deck%(2) = 99
       TopCol% = 363
       TopRow% = 125
       CurrentCard% = 2
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp1% = 3 THEN
       TopCol% = 159
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(1) = Deck%(3)
       Deck%(3) = 99
       TopCol% = 363
       TopRow% = 125
       CurrentCard% = 3
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp1% = 4 THEN
       TopCol% = 237
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(1) = Deck%(4)
       Deck%(4) = 99
       TopCol% = 363
       TopRow% = 125
       CurrentCard% = 4
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp1% = 5 THEN
       TopCol% = 315
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(1) = Deck%(5)
       Deck%(5) = 99
       TopCol% = 363
       TopRow% = 125
       CurrentCard% = 5
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp1% = 6 THEN
       TopCol% = 393
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(1) = Deck%(6)
       Deck%(6) = 99
       TopCol% = 363
       TopRow% = 125
       CurrentCard% = 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF

    CALL Delay(2)

    CALL EraseLine
    PRINT "and this one";
    IF CurrentCrib = Computer THEN
      PRINT " to my crib...";
    ELSE
      PRINT " to your crib...";
    END IF

    IF Temp2% = 1 THEN
       TopCol% = 3
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(2) = Deck%(1)
       Deck%(1) = 99
       TopCol% = 348
       TopRow% = 125
       CurrentCard% = 1
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp2% = 2 THEN
       TopCol% = 81
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(2) = Deck%(2)
       Deck%(2) = 99
       TopCol% = 348
       TopRow% = 125
       CurrentCard% = 2
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp2% = 3 THEN
       TopCol% = 159
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(2) = Deck%(3)
       Deck%(3) = 99
       TopCol% = 348
       TopRow% = 125
       CurrentCard% = 3
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp2% = 4 THEN
       TopCol% = 237
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(2) = Deck%(4)
       Deck%(4) = 99
       TopCol% = 348
       TopRow% = 125
       CurrentCard% = 4
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp2% = 5 THEN
       TopCol% = 315
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(2) = Deck%(5)
       Deck%(5) = 99
       TopCol% = 348
       TopRow% = 125
       CurrentCard% = 5
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF
    IF Temp2% = 6 THEN
       TopCol% = 393
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
       Discard%(2) = Deck%(6)
       Deck%(6) = 99
       TopCol% = 348
       TopRow% = 125
       CurrentCard% = 6
       CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
     END IF

    PlayFlag$ = "Meld"

    CALL Delay(2)
    LOCATE 24, 1
    PRINT STRING$(59, " ");
    COLOR Green
    LINE (  0, 376)-( 28, 376)
    LINE ( 43, 376)-(106, 376)
    LINE (124, 376)-(187, 376)
    LINE (205, 376)-(268, 376)
    LINE (282, 376)-(321, 376)
    LINE (364, 376)-(470, 376)

    LOCATE 24,  5: PRINT "1";
    LOCATE 24, 15: PRINT "2";
    LOCATE 24, 25: PRINT "3";
    LOCATE 24, 35: PRINT "4";
    CALL EraseLine

    PSET (330, 364), Red
    DRAW "C4 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R26"
    DRAW "   U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L26"
    DRAW "BM -1,+1"
    DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R28 "
    DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L27"
    COLOR Red
    LOCATE 24, 43: PRINT "GO";
    COLOR Green

     FOR TopCol% = 3 TO 393 STEP 78
       TopRow% = 3
       CALL EraseCard(TopCol%, TopRow%)
     NEXT TopCol%

     FOR TopCol% = 3 TO 393 STEP 78
       TopRow% = 248
       CALL EraseCard(TopCol%, TopRow%)
     NEXT TopCol%

     FOR Temp1% = 469 TO 348 STEP -1
       TopRow% = 125
       LINE (Temp1%, TopRow%)-(Temp1%, TopRow% + 114), 0
     NEXT Temp1%

REM * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
REM * Sort cards so that cards 1-4 are the players cards          *
REM *                    cards 5-8 are the computers cards        *
REM *                    cards 9-12 are the crib cards            *
REM *                    card  13   is the meld card              *
REM * Also, sort so that each set is in low-high rank (Ace-King)  *
REM * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    FOR Temp1% = 1 TO 6
    FOR Temp2% = 1 TO 5
      IF Deck%(Temp2%) >= Deck%(Temp2% + 1) THEN
        SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      END IF
    NEXT Temp2%
    NEXT Temp1%

    FOR Temp1% = 5 TO 12
    FOR Temp2% = 5 TO 11
      IF Deck%(Temp2%) >= Deck%(Temp2% + 1) THEN
        SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      END IF
    NEXT Temp2%
    NEXT Temp1%

    FOR Temp1% = 1 TO 4
      Deck%(Temp1% + 8) = Discard%(Temp1%)
    NEXT Temp1%

    FOR Temp1% = 9 TO 12
    FOR Temp2% = 9 TO 11
      IF Deck%(Temp2%) >= Deck%(Temp2% + 1) THEN
        SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      END IF
    NEXT Temp2%
    NEXT Temp1%

  FOR Temp1% = 1 TO 13
    IF Deck%(Temp1%) >= 1 AND Deck%(Temp1%) <= 13 THEN Suit%(Temp1%) = 1
    IF Deck%(Temp1%) >= 14 AND Deck%(Temp1%) <= 26 THEN Suit%(Temp1%) = 2
    IF Deck%(Temp1%) >= 27 AND Deck%(Temp1%) <= 39 THEN Suit%(Temp1%) = 3
    IF Deck%(Temp1%) >= 40 AND Deck%(Temp1%) <= 52 THEN Suit%(Temp1%) = 4
  NEXT Temp1%

  FOR Temp1% = 1 TO 13
    IF Deck%(Temp1%) >= 1 AND Deck%(Temp1%) <= 13 THEN Rank%(Temp1%) = Deck%(Temp1%)
    IF Deck%(Temp1%) >= 14 AND Deck%(Temp1%) <= 26 THEN Rank%(Temp1%) = Deck%(Temp1%) - 13
    IF Deck%(Temp1%) >= 27 AND Deck%(Temp1%) <= 39 THEN Rank%(Temp1%) = Deck%(Temp1%) - 26
    IF Deck%(Temp1%) >= 40 AND Deck%(Temp1%) <= 52 THEN Rank%(Temp1%) = Deck%(Temp1%) - 39
    Value%(Temp1%) = Rank%(Temp1%)
  NEXT Temp1%

  FOR Temp1% = 1 TO 13
    IF Value%(Temp1%) >= 10 THEN Value%(Temp1%) = 10
  NEXT Temp1%

  FOR Temp1% = 1 TO 4
  FOR Temp2% = 1 TO 3
    IF Rank%(Temp2%) > Rank%(Temp2% + 1) THEN
      SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      SWAP Suit%(Temp2%), Suit%(Temp2% + 1)
      SWAP Rank%(Temp2%), Rank%(Temp2% + 1)
      SWAP Value%(Temp2%), Value%(Temp2% + 1)
    END IF
  NEXT Temp2%
  NEXT Temp1%

  FOR Temp1% = 1 TO 4
  FOR Temp2% = 5 TO 7
    IF Rank%(Temp2%) > Rank%(Temp2% + 1) THEN
      SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      SWAP Suit%(Temp2%), Suit%(Temp2% + 1)
      SWAP Rank%(Temp2%), Rank%(Temp2% + 1)
      SWAP Value%(Temp2%), Value%(Temp2% + 1)
    END IF
  NEXT Temp2%
  NEXT Temp1%

  FOR Temp1% = 1 TO 4
  FOR Temp2% = 9 TO 11
    IF Rank%(Temp2%) > Rank%(Temp2% + 1) THEN
      SWAP Deck%(Temp2%), Deck%(Temp2% + 1)
      SWAP Suit%(Temp2%), Suit%(Temp2% + 1)
      SWAP Rank%(Temp2%), Rank%(Temp2% + 1)
      SWAP Value%(Temp2%), Value%(Temp2% + 1)
    END IF
  NEXT Temp2%
  NEXT Temp1%
REM * * * * END OF SORT * * * * * * * * * * * * * * * * * * * * * *
    REM Save 1-13 into 14-26 so it can be restored
    FOR Temp1% = 1 TO 13
      Deck%(Temp1% + 13) = Deck%(Temp1%)
    NEXT Temp1%

    TopCol% = 3: TopRow% = 3: CurrentCard% = 1
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 81: TopRow% = 3: CurrentCard% = 2
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 159: TopRow% = 3: CurrentCard% = 3
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 237: TopRow% = 3: CurrentCard% = 4
    CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

    TopCol% = 3: TopRow% = 248: CurrentCard% = 5
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 81: TopRow% = 248: CurrentCard% = 6
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 159: TopRow% = 248: CurrentCard% = 7
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 237: TopRow% = 248: CurrentCard% = 8
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

    TopCol% = 393: TopRow% = 125: CurrentCard% = 13
    PUT (TopCol%, TopRow%), CB%, PSET

    CurrentCard% = 8
    FOR TopCol% = 348 TO 393 STEP 15
      IF CurrentCrib = Computer THEN
        TopRow% = 3
      ELSE
        TopRow% = 248
      END IF
      CurrentCard% = CurrentCard% + 1
      CALL CardBack(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    NEXT TopCol%

    CALL EraseLine
    PRINT "OK, now cutting for the crib card...";
    CALL Delay(1.5)
    TopCol% = 390: TopRow% = 122: CurrentCard% = 13
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

    IF Rank%(13) = 11 THEN
      IF CurrentCrib = Computer THEN
        CALL EraseLine
        PRINT "I peg 2 points for the Jack.";
        CALL Delay(2)
        Points% = 2
        CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
      ELSE
        CALL EraseLine
        PRINT "You peg 2 points for the Jack.";
        CALL Delay(2)
        Points% = 2
        CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
      END IF
    ELSE
      RANDOMIZE TIMER
      Temp1% = INT(RND * 10) + 1
      IF BlueScore% < 10 OR RedScore% < 10 AND Temp1% = 1 THEN Temp1% = 2
      COLOR Green
      CALL EraseLine
      PRINT Message$(Temp1%);
      CALL Delay(2.5)
    END IF

    IF CurrentCrib = Computer THEN
      LOCATE 26, 1
      PRINT "Since it is my crib, you lead off..";
      GOTO ReadButton4
    ELSE
      GOTO ComputerPlay
    END IF

ReadButton4:
          CurrentPlayer% = Player
          IF PlayCount% = 8 THEN
            CALL EraseLine
            PRINT "I peg 1 for last card.";
            CALL Delay(2)
            Points% = 1
            CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
            GOTO CountUp
          END IF

          IF Deck%(5) = 99 AND Deck%(6) = 99 AND Deck%(7) = 99 AND Deck%(8) = 99 THEN
            IF ComputerGo% = True THEN
              CALL EraseLine
              PRINT "You peg 1 for the GO.";
              CALL Delay(2)
              Points% = 1
              CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
              GOTO StartNewMeld
            ELSE
              GOTO ComputerPlay
            END IF
          END IF

          CALL EraseLine
          COLOR Green
          PRINT "What card do you want to play? ";
          CALL ButtonStatus
          SELECT CASE Answer$
           CASE "G"
              FOR Temp1% = 5 TO 8
                IF Deck%(Temp1%) <> 99 AND Value%(Temp1%) + CurrentMeld% <= 31 THEN
                  CALL EraseLine
                  COLOR Green
                  PRINT "You have a valid play!";
                  SOUND 1000, 1
                  CALL Delay(2)
                  GOTO ReadButton4
                END IF
              NEXT Temp1%

             IF ComputerGo% = True THEN
               CALL EraseLine
               PRINT "You peg 1 for the GO.";
               CALL Delay(2)
               Points% = 1
               CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
               GOTO StartNewMeld
             END IF

             CALL EraseLine
             COLOR Red
             PRINT "GO ...(from player)";
             COLOR Green
             CALL Delay(2)
             PlayerGo% = True
             GOTO ComputerPlay

           CASE "1"
             REM Card #5 is pointed to
             IF Deck%(5) = 99 THEN GOTO ReadButton4
             IF Value%(5) + CurrentMeld% > 31 THEN GOTO ReadButton4
             PRINT Answer$;
             PlayCount% = PlayCount% + 1
             TopCol% = 3
             TopRow% = 248
             CALL EraseCard(TopCol%, TopRow%)
             Work%(PlayCount%) = 5
             Deck%(5) = 99
             CurrentMeld% = CurrentMeld% + Value%(5)
             CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
             TopCol% = ((PlayCount% - 1) * 12) + 3
             TopRow% = 125
             CurrentCard% = 5
             CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
             CALL CheckScore(Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%)
             GOSUB RedMeld31
           CASE "2"
             REM Card #6 is pointed to
             IF Deck%(6) = 99 THEN GOTO ReadButton4
             IF Value%(6) + CurrentMeld% > 31 THEN GOTO ReadButton4
             PRINT Answer$;
             PlayCount% = PlayCount% + 1
             TopCol% = 81
             TopRow% = 248
             CALL EraseCard(TopCol%, TopRow%)
             Work%(PlayCount%) = 6
             Deck%(6) = 99
             CurrentMeld% = CurrentMeld% + Value%(6)
             CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
             TopCol% = ((PlayCount% - 1) * 12) + 3
             TopRow% = 125
             CurrentCard% = 6
             CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
             CALL CheckScore(Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%)
             GOSUB RedMeld31
           CASE "3"
             REM Card #7 is pointed to
             IF Deck%(7) = 99 THEN GOTO ReadButton4
             IF Value%(7) + CurrentMeld% > 31 THEN GOTO ReadButton4
             PRINT Answer$;
             PlayCount% = PlayCount% + 1
             TopCol% = 159
             TopRow% = 248
             CALL EraseCard(TopCol%, TopRow%)
             Work%(PlayCount%) = 7
             Deck%(7) = 99
             CurrentMeld% = CurrentMeld% + Value%(7)
             CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
             TopCol% = ((PlayCount% - 1) * 12) + 3
             TopRow% = 125
             CurrentCard% = 7
             CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
             CALL CheckScore(Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%)
             GOSUB RedMeld31
           CASE "4"
             REM Card #8 is pointed to
             IF Deck%(8) = 99 THEN GOTO ReadButton4
             IF Value%(8) + CurrentMeld% > 31 THEN GOTO ReadButton4
             PRINT Answer$;
             PlayCount% = PlayCount% + 1
             TopCol% = 237
             TopRow% = 248
             CALL EraseCard(TopCol%, TopRow%)
             Work%(PlayCount%) = 8
             Deck%(8) = 99
             CurrentMeld% = CurrentMeld% + Value%(8)
             CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
             LOCATE 26, 1
             TopCol% = ((PlayCount% - 1) * 12) + 3
             TopRow% = 125
             CurrentCard% = 8
             CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
             CALL CheckScore(Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%)
             GOSUB RedMeld31
           CASE ELSE
             REM Mouse not on any user card
             GOTO ReadButton4
           END SELECT

          IF PlayCount% = 1 THEN
            LOCATE 26, 1
            PRINT STRING$(59, " ");
          END IF

ComputerPlay:
      Discard1% = 0
      CurrentPlayer% = Computer
      IF PlayCount% = 8 THEN
        CALL EraseLine
        PRINT "You peg 1 for the last card.";
        CALL Delay(2)
        Points% = 1
        CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
        GOTO CountUp
      END IF

      Choices = 0
      FOR Temp1% = 1 TO 4
       Array%(Temp1%) = 0
       IF Deck%(Temp1%) <> 99 AND Value%(Temp1%) + CurrentMeld% <= 31 THEN
         Choices = Choices + 1
         Array%(Choices) = Temp1%
       END IF
      NEXT Temp1%

      IF Choices = 0 THEN
        GOTO NoChoice: REM "Go (if not already done so)"
      END IF

      IF Choices = 1 THEN
        Discard1% = Array%(1)
        GOTO ValidPlay
      END IF

      REM First card in current Meld, no real preference yet
      IF (PlayCount% < MeldCount%) OR (PlayCount% = 0) THEN
        FOR Temp1% = 1 TO Choices
          IF Rank%(Array%(Temp1%)) <> 5 THEN
            Discard1% = Array%(Temp1%)
            GOTO ValidPlay
          END IF
        NEXT Temp1%
      REM They must ALL be five's
      Discard1% = Array%(1)
      GOTO ValidPlay
      END IF

 REM See if this causes a run of 7
 IF PlayCount% >= MeldCount% + 5 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
   E% = Rank%(Work%(PlayCount% - 3))
   F% = Rank%(Work%(PlayCount% - 4))
   G% = Rank%(Work%(PlayCount% - 5))
     FOR Temp2% = 1 TO 7
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
       IF E% > F% THEN SWAP E%, F%
       IF F% > G% THEN SWAP F%, G%
     NEXT Temp2%
   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) AND (E% = F% - 1) AND (F% = G% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF
 NEXT Temp1%
 END IF

 REM See if this causes a run of 6
 IF PlayCount% >= MeldCount% + 4 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
   E% = Rank%(Work%(PlayCount% - 3))
   F% = Rank%(Work%(PlayCount% - 4))
     FOR Temp2% = 1 TO 6
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
       IF E% > F% THEN SWAP E%, F%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) AND (E% = F% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF
 NEXT Temp1%
 END IF

 REM See if this causes a run of 5
 IF PlayCount% >= MeldCount% + 3 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
   E% = Rank%(Work%(PlayCount% - 3))
     FOR Temp2% = 1 TO 5
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF

 NEXT Temp1%
 END IF

 REM See if this causes a run of 4
 IF PlayCount% >= MeldCount% + 2 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
     FOR Temp2% = 1 TO 4
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF

 NEXT Temp1%
 END IF

 REM See if this causes a run of 3
 IF PlayCount% >= MeldCount% + 1 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
     FOR Temp2% = 1 TO 3
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF

 NEXT Temp1%
 END IF

 REM See if this causes a 15
 FOR Temp1% = 1 TO Choices
   IF Value%(Array%(Temp1%)) + CurrentMeld% = 15 THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF
 NEXT Temp1%

 REM See if this causes a pair (also covers 3/4 of a kind)
 FOR Temp1% = 1 TO Choices
   IF Rank%(Array%(Temp1%)) = Rank%(Work%(PlayCount%)) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay
   END IF
 NEXT Temp1%

 REM Nothing, so just play the first valid card
 Discard1% = Array%(1)
 GOTO ValidPlay

NoChoice:
      IF PlayerGo% = True THEN
        CALL EraseLine
        COLOR Cyan
        PRINT "I peg 1 for the GO.";
        COLOR Green
        CALL Delay(2)
        Points% = 1
        CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
        GOTO StartNewMeld
      END IF

      CALL EraseLine
      COLOR Cyan
      PRINT "GO ...(from computer)";
      COLOR Green
      CALL Delay(2)
      ComputerGo% = True
      GOTO ReadButton4

ValidPlay:
        CurrentPlayer% = Computer
        PlayCount% = PlayCount% + 1
        CALL EraseLine
        COLOR Cyan
        PRINT "I will play card"; Discard1%;
        COLOR Green
        CALL Delay(2)
        TopCol% = ((Discard1% - 1) * 78) + 3
        TopRow% = 3
        CALL EraseCard(TopCol%, TopRow%)
        Work%(PlayCount%) = Discard1%
        Deck%(Discard1%) = 99
        CurrentMeld% = CurrentMeld% + Value%(Discard1%)
        CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
        TopCol% = ((PlayCount% - 1) * 12) + 3
        TopRow% = 125
        CurrentCard% = Discard1%
        CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
        CALL CheckScore(Rank%(), Work%(), PlayCount%, MeldCount%, CurrentMeld%)

        IF CurrentMeld% = 31 THEN
          CALL EraseLine
          PRINT "Thirty-One for two points.";
          CALL Delay(2)
          Points% = 2
          CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
          PlayerGo% = True
          GOTO StartNewMeld
        END IF

    GOTO ReadButton4

CountUp:
    CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
    CALL EraseLine
    PRINT "Time to count up our hands.";
    CALL Delay(2)

    IF CurrentCrib% = Player THEN
      LOCATE 4, 45
      PRINT "            ";
      LOCATE 5, 49
      PRINT "    ";
    ELSE
      LOCATE 20, 45
      PRINT "            ";
      LOCATE 21, 49
      PRINT "    ";
    END IF

     FOR TopCol% = 255 TO 3 STEP -12
       TopRow% = 125
       CALL EraseCard(TopCol%, TopRow%)
     NEXT TopCol%

    REM Restore 1-13 from 14-26
    FOR Temp1% = 1 TO 13
      Deck%(Temp1%) = Deck%(Temp1% + 13)
    NEXT Temp1%

    TopCol% = 3: TopRow% = 3: CurrentCard% = 1
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 81: TopRow% = 3: CurrentCard% = 2
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 159: TopRow% = 3: CurrentCard% = 3
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 237: TopRow% = 3: CurrentCard% = 4
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

    TopCol% = 3: TopRow% = 248: CurrentCard% = 5
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 81: TopRow% = 248: CurrentCard% = 6
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 159: TopRow% = 248: CurrentCard% = 7
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    TopCol% = 237: TopRow% = 248: CurrentCard% = 8
    CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())

    CurrentCard% = 8
    FOR TopCol% = 349 TO 394 STEP 15
      IF CurrentCrib = Computer THEN
        TopRow% = 4
      ELSE
        TopRow% = 249
      END IF
      CurrentCard% = CurrentCard% + 1
      CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    NEXT TopCol%

    IF CurrentCrib% = Player THEN
      COLOR Green
      LOCATE 26, 1: PRINT STRING$(59, " ");
      LOCATE 26, 1
      PRINT "Since it is your crib, I count up first.";
      A% = 1: B% = 2: C% = 3: D% = 4: E% = 13
      CALL CountScore(Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
      LOCATE 27, 1: PRINT STRING$(59, " ");
      LOCATE 27, 1: PRINT "Computers Score ="; Points%
      CALL PressKey(Answer$)
      CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
      LOCATE 26, 1: PRINT STRING$(59, " ");
      LOCATE 26, 1
      PRINT "And in your hand you count up...";
      A% = 5: B% = 6: C% = 7: D% = 8: E% = 13
      CALL CountScore(Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
      LOCATE 27, 1: PRINT "Players Score ="; Points%
      CALL PressKey(Answer$)
      CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
      LOCATE 26, 1: PRINT STRING$(59, " ");
      LOCATE 26, 1
      PRINT "And in your crib you count up...";
      A% = 9: B% = 10: C% = 11: D% = 12: E% = 13
      CALL CountScore(Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
      LOCATE 27, 1: PRINT STRING$(59, " ");
      LOCATE 27, 1: PRINT "Crib Score ="; Points%; "        ";
      CALL PressKey(Answer$)
      CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
      CurrentCrib% = Computer
    ELSE
      LOCATE 26, 1
      PRINT STRING$(59, " ")
      LOCATE 26, 1
      PRINT "Since it is my crib, you count up first.";
      A% = 5: B% = 6: C% = 7: D% = 8: E% = 13
      CALL CountScore(Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
      LOCATE 27, 1: PRINT STRING$(59, " ");
      LOCATE 27, 1: PRINT "Players Score ="; Points%
      CALL PressKey(Answer$)
      CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
      LOCATE 26, 1: PRINT STRING$(59, " ");
      LOCATE 26, 1
      PRINT "And in my hand I count up...";
      A% = 1: B% = 2: C% = 3: D% = 4: E% = 13
      CALL CountScore(Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
      LOCATE 27, 1: PRINT STRING$(59, " ");
      LOCATE 27, 1: PRINT "Computers Score ="; Points%
      CALL PressKey(Answer$)
      CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
      LOCATE 26, 1: PRINT STRING$(59, " ");
      LOCATE 26, 1
      PRINT "And in my crib I count up...";
      A% = 9: B% = 10: C% = 11: D% = 12: E% = 13
      CALL CountScore(Rank%(), Suit%(), Work%(), Value%(), Points%, A%, B%, C%, D%, E%)
      LOCATE 27, 1: PRINT STRING$(59, " ");
      LOCATE 27, 1: PRINT "Crib Score ="; Points%; "       ";
      CALL PressKey(Answer$)
      CALL MoveBlue(BlueBackPeg%, BluePeg%(), BlueScore%, RedScore%, Points%)
      CurrentCrib% = Player
    END IF

    CALL Delay(2)
    CALL ClearScreen(27)
    EXIT SUB

StartNewMeld:
    IF PlayCount% = 8 THEN GOTO CountUp
    CurrentMeld% = 0
    CALL DisplayMeld(CurrentCrib%, CurrentMeld%)
    CALL EraseLine
    PRINT "Start of a new meld.";
    CALL Delay(1)
      TopCol% = ((MeldCount% - 1) * 12) - 9
    FOR Temp1% = MeldCount% TO PlayCount%
      TopCol% = TopCol% + 12
      TopRow% = 125
      PUT (TopCol%, TopRow%), CB%, PSET
      CALL Delay(.25)
    NEXT Temp1%
    MeldCount% = PlayCount% + 1

    IF ComputerGo% = True THEN
      ComputerGo% = False
      PlayerGo% = False
      GOTO ComputerPlay
    ELSE
      PlayerGo% = False
      ComputerGo% = False
      GOTO ReadButton4
    END IF

RedMeld31:
   IF CurrentMeld% = 31 THEN
     CALL EraseLine
     PRINT "Thirty-One for two points";
     CALL Delay(2)
     Points% = 2
     CALL MoveRed(RedBackPeg%, RedPeg%(), BlueScore%, RedScore%, Points%)
     ComputerGo% = True
     GOTO StartNewMeld
   END IF
RETURN

END SUB

SUB PressKey (Answer$) STATIC
  Answer$ = INKEY$
  M1% = 5: M2% = 0
  CALL Mouse(M1%, M2%, M3%, M4%):REM Button Press for left button
  TimesPressed = M2%
  CurrentPress = M2%
Loop1:
  M1% = 5: M2% = 0
  CALL Mouse(M1%, M2%, M3%, M4%):REM Button Press for left button
  CurrentPress = CurrentPress + M2%
  IF CurrentPress > TimesPressed THEN
    EXIT SUB
  END IF

  Answer$ = INKEY$: IF Answer$ = "" THEN GOTO Loop1
  IF Answer$ = CHR$(27) THEN CLS : END
END SUB

SUB ShuffleCards (Deck%(), Suit%(), Rank%(), Value%()) STATIC
  PlayFlag$ = "Deal"

  FOR Temp1% = 1 TO 52
    Deck%(Temp1%) = Temp1%
  NEXT Temp1%

  RANDOMIZE TIMER
  FOR Temp1% = 1 TO 52
  Index% = INT(RND * 52) + 1
    SWAP Deck%(Temp1%), Deck%(Index%)
  NEXT Temp1%

  FOR Temp1% = 1 TO 52
    SELECT CASE Deck%(Temp1%)
      CASE 1 TO 13
        Suit%(Temp1%) = 1: REM Hearts
      CASE 14 TO 26
        Suit%(Temp1%) = 2: REM Diamonds
      CASE 27 TO 39
        Suit%(Temp1%) = 3: REM Clubs
      CASE 40 TO 52
        Suit%(Temp1%) = 4: REM Spades
    END SELECT

    SELECT CASE Deck%(Temp1%)
      CASE 1 TO 13
        Rank%(Temp1%) = Deck%(Temp1%)
      CASE 14 TO 26
        Rank%(Temp1%) = Deck%(Temp1%) - 13
      CASE 27 TO 39
        Rank%(Temp1%) = Deck%(Temp1%) - 26
      CASE 40 TO 52
        Rank%(Temp1%) = Deck%(Temp1%) - 39
    END SELECT

    SELECT CASE Deck%(Temp1%)
      CASE 1 TO 9
        Value%(Temp1%) = Deck%(Temp1%)
      CASE 14 TO 22
        Value%(Temp1%) = Deck%(Temp1%) - 13
      CASE 27 TO 35
        Value%(Temp1%) = Deck%(Temp1%) - 26
      CASE 40 TO 48
        Value%(Temp1%) = Deck%(Temp1%) - 39
      CASE ELSE
        Value%(Temp1%) = 10
    END SELECT
  NEXT Temp1%

END SUB

SUB ShuffleDisplay STATIC
   COLOR Green
   CALL EraseLine
   PRINT "     Shuffling Cards...";

    FOR TopCol% = 3 TO 233 STEP 10
      TopRow% = 125
      CurrentCard% = CurrentCard% + 1
     CALL DisplayCard(TopRow%, TopCol%, CurrentCard%, Suit%(), Rank%())
    NEXT TopCol%

    FOR TopCol% = 233 TO 3 STEP -10
      TopRow% = 125
      PUT (TopCol%, TopRow%), CB%, PSET
    NEXT TopCol%

    TopCol% = 310
    TopRow% = 125
    CALL EraseCard(TopCol%, TopRow%)

    FOR Temp1% = 320 TO 90 STEP -10
      FOR TopCol% = Temp1% TO Temp1% - 10 STEP -1
      LINE (TopCol%, 125)-(TopCol%, 239), 0
      NEXT TopCol%
      CALL Delay(.07)
    NEXT Temp1%

END SUB

SUB YesNo (Answer$) STATIC

 COLOR White
 Row = 25: Col = 6
 LOCATE Row, Col: PRINT "  Y";
 COLOR Green
 PRINT "es ";
 TopRow% = ((Row - 1) * 16) - 4
 TopCol% = ((Col - 1) * 8) - 4
 COLOR White

 DRAW "BM=" + VARPTR$(TopCol%) + ",=" + VARPTR$(TopRow%)
 DRAW "BM +5,+0 C2 G1 L1 G3 D16 F3 R1 F1 R52 E1 R1 E3 U16 H3 L1 H1 L52"

 COLOR White
 Row = 25: Col = 17
 LOCATE Row, Col: PRINT "  N";
 COLOR Green
 PRINT "o  ";
 TopRow% = ((Row - 1) * 16) - 4
 TopCol% = ((Col - 1) * 8) - 4
 COLOR White

 DRAW "BM=" + VARPTR$(TopCol%) + ",=" + VARPTR$(TopRow%)
 DRAW "BM +5,+0 C2 G1 L1 G3 D16 F3 R1 F1 R52 E1 R1 E3 U16 H3 L1 H1 L52"

  M1% = 1
  CALL Mouse(M1%, M2%, M3%, M4%): REM Show mouse cursor
  M1% = 4: M3% = 175: M4% = 390
  CALL Mouse(M1%, M2%, M3%, M4%): REM Position mouse cursor
  Answer$ = INKEY$

YesOrNo:
  M1% = 3
  CALL Mouse(M1%, M2%, M3%, M4%): REM Get button status

  IF M2% AND 1 THEN
    REM Left button down
  ELSE
    Answer$ = INKEY$: Answer$ = UCASE$(Answer$)
    IF Answer$ = "Y" THEN M3% =  38: GOTO HideMouse2
    IF Answer$ = "N" THEN M3% = 126: GOTO HideMouse2
    IF Answer$ = CHR$(27) THEN CLS : END
    GOTO YesOrNo
  END IF

  REM Not on either Yes or No so ignore button press
  IF M4% < 379 OR  M4% > 403 THEN GOTO YesOrNo
  IF M3% <  36 OR  M3% > 184 THEN GOTO YesOrNo
  IF M3% >  96 AND M3% < 125 THEN GOTO YesOrNo

HideMouse2:
    M1% = 2
    CALL Mouse(M1%, M2%, M3%, M4%): REM Hide mouse cursor

    SELECT CASE M3%
     CASE 36 TO 96
       REM "Yes" is pointed to
       Answer$ = "Y"
     CASE 125 TO 184
       REM "No" is pointed to
       Answer$ = "N"
     CASE ELSE
       REM Neither Yes or No
        GOTO YesOrNo
     END SELECT

 Row = 25: Col = 6
 LOCATE Row, Col: PRINT "      ";
 TopRow% = ((Row - 1) * 16) - 4
 TopCol% = ((Col - 1) * 8) - 4

 DRAW "BM=" + VARPTR$(TopCol%) + ",=" + VARPTR$(TopRow%)
 DRAW "BM +5,+0 C0 G1 L1 G3 D16 F3 R1 F1 R52 E1 R1 E3 U16 H3 L1 H1 L52"

 Row = 25: Col = 17
 LOCATE Row, Col: PRINT "      ";
 TopRow% = ((Row - 1) * 16) - 4
 TopCol% = ((Col - 1) * 8) - 4

 DRAW "BM=" + VARPTR$(TopCol%) + ",=" + VARPTR$(TopRow%)
 DRAW "BM +5,+0 C0 G1 L1 G3 D16 F3 R1 F1 R52 E1 R1 E3 U16 H3 L1 H1 L52"

 COLOR White
END SUB

SUB Hint1 (Work%(), Discard%(), Rank%(), Value%(), Suit%()) STATIC

CALL BottomLine (Black,Black)
RESTORE
BestScore! = 0
BestWeighted! = 0
Weighted! = 0

FOR Temp1% = 1 TO 15
  FOR Temp2% = 1 TO 4
    READ Work%(Temp2%)
    Work%(Temp2%) = Work%(Temp2%) + 6
  NEXT Temp2%
    READ Discard%(1), Discard%(2)
    Discard%(1) = Discard%(1) + 6
    Discard%(2) = Discard%(2) + 6

Score! = 0
Weighted! = 0

REM Count up Pairs first (includes 3 and 4 of a kind)
IF Rank%(Work%(1)) = Rank%(Work%(2)) THEN Score! = Score! + 2
IF Rank%(Work%(1)) = Rank%(Work%(3)) THEN Score! = Score! + 2
IF Rank%(Work%(1)) = Rank%(Work%(4)) THEN Score! = Score! + 2
IF Rank%(Work%(2)) = Rank%(Work%(3)) THEN Score! = Score! + 2
IF Rank%(Work%(2)) = Rank%(Work%(4)) THEN Score! = Score! + 2
IF Rank%(Work%(3)) = Rank%(Work%(4)) THEN Score! = Score! + 2

REM Count up 15's next
IF Value%(Work%(1)) + Value%(Work%(2)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(3)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(2)) + Value%(Work%(3)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(2)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(2)) + Value%(Work%(3)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(2)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(2)) + Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2
IF Value%(Work%(1)) + Value%(Work%(2)) + Value%(Work%(3)) + Value%(Work%(4)) = 15 THEN Score! = Score! + 2

REM Count up 4 of same suit
IF Suit%(Work%(1)) = Suit%(Work%(2)) AND Suit%(Work%(2)) = Suit%(Work%(3)) AND Suit%(Work%(3)) = Suit%(Work%(4)) THEN Score! = Score! + 4

REM Count up Runs of 4
  A% = Rank%(Work%(1))
  B% = Rank%(Work%(2))
  C% = Rank%(Work%(3))
  D% = Rank%(Work%(4))
  IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) THEN
    Score! = Score! + 4
    GOTO WeightedValues2
  END IF

REM Count up Runs of 3
  A% = Rank%(Work%(1))
  B% = Rank%(Work%(2))
  C% = Rank%(Work%(3))
  D% = Rank%(Work%(4))
  IF (A% = B% - 1) AND (B% = C% - 1) THEN Score! = Score! + 3
  IF (A% = B% - 1) AND (B% = D% - 1) THEN Score! = Score! + 3
  IF (A% = C% - 1) AND (C% = D% - 1) THEN Score! = Score! + 3
  IF (B% = C% - 1) AND (C% = D% - 1) THEN Score! = Score! + 3

REM ******** Weighted Values ****************

WeightedValues2:

IF Rank%(Work%(2)) = Rank%(Work%(1)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(3)) = Rank%(Work%(1)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(4)) = Rank%(Work%(1)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(3)) = Rank%(Work%(2)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(4)) = Rank%(Work%(2)) + 1 THEN Weighted! = Weighted! + .01
IF Rank%(Work%(4)) = Rank%(Work%(3)) + 1 THEN Weighted! = Weighted! + .01

IF Rank%(Discard%(1)) = Rank%(Discard%(2)) THEN
  IF CurrentCrib% = Computer THEN
     Weighted! = Weighted! - 1.9
  ELSE
     Weighted! = Weighted! + 2
  END IF
END IF

IF Value%(Discard%(1)) + Value%(Discard%(2)) = 15 THEN
  IF CurrentCrib% = Computer THEN
     Weighted! = Weighted! - 1.9
  ELSE
     Weighted! = Weighted! + 2
  END IF
END IF

IF Value%(Discard%(1)) = 5 OR Value%(Discard%(2)) = 5 THEN
  IF CurrentCrib% = Player THEN
     Weighted! = Weighted! + .5
  ELSE
     Weighted! = Weighted! - .5
  END IF
END IF

IF Rank%(Discard%(1)) = Rank%(Discard%(2)) + 1 THEN
  IF CurrentCrib% = Player THEN
     Weighted! = Weighted! + .25
  ELSE
     Weighted! = Weighted! - .25
  END IF
END IF

REM *****End Weighted Values ****************

IF (Score! > BestScore!) OR ((Score! >= BestScore!) AND (Weighted! >= BestWeighted!)) THEN
  BestScore! = Score!
  BestWeighted! = Weighted!
  Discard1% = Discard%(1) - 6
  Discard2% = Discard%(2) - 6
END IF

NEXT Temp1%

  CALL EraseLine
  COLOR Green
  PRINT "I suggest discarding";Discard1%;"and";Discard2%;
  CALL Continue
  M1% = 4 :M3% = 237 :M4% = 399
  CALL Mouse(M1%, M2%, M3%, M4%): REM Position mouse
  CALL BottomLine (Green, White)
END SUB

SUB Hint2 (Work%(), Discard%(), Rank%(), Value%(), Suit%()) STATIC

CALL BottomLine (Black,Black)

      NoChoice = False
      Discard1% = 0
      Choices = 0
      FOR Temp1% = 5 TO 8
       Array%(Temp1%) = 0
       IF Deck%(Temp1%) <> 99 AND Value%(Temp1%) + CurrentMeld% <= 31 THEN
         Choices = Choices + 1
         Array%(Choices) = Temp1%
       END IF
      NEXT Temp1%

      IF Choices = 0 THEN GOTO ValidPlay2

      IF Choices = 1 THEN
        Discard1% = Array%(1)
        GOTO ValidPlay2
      END IF

      REM First card in current Meld, no real preference yet
      IF (PlayCount% < MeldCount%) OR (PlayCount% = 0) THEN
        FOR Temp1% = 1 TO Choices
          IF Rank%(Array%(Temp1%)) <> 5 THEN
            Discard1% = Array%(Temp1%)
            GOTO ValidPlay2
          END IF
        NEXT Temp1%
      REM They must ALL be five's
      Discard1% = Array%(1)
      GOTO ValidPlay2
      END IF

 REM See if this causes a run of 7
 IF PlayCount% >= MeldCount% + 5 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
   E% = Rank%(Work%(PlayCount% - 3))
   F% = Rank%(Work%(PlayCount% - 4))
   G% = Rank%(Work%(PlayCount% - 5))
     FOR Temp2% = 1 TO 7
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
       IF E% > F% THEN SWAP E%, F%
       IF F% > G% THEN SWAP F%, G%
     NEXT Temp2%
   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) AND (E% = F% - 1) AND (F% = G% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF
 NEXT Temp1%
 END IF

 REM See if this causes a run of 6
 IF PlayCount% >= MeldCount% + 4 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
   E% = Rank%(Work%(PlayCount% - 3))
   F% = Rank%(Work%(PlayCount% - 4))
     FOR Temp2% = 1 TO 6
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
       IF E% > F% THEN SWAP E%, F%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) AND (E% = F% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF
 NEXT Temp1%
 END IF

 REM See if this causes a run of 5
 IF PlayCount% >= MeldCount% + 3 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
   E% = Rank%(Work%(PlayCount% - 3))
     FOR Temp2% = 1 TO 5
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
       IF D% > E% THEN SWAP D%, E%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) AND (D% = E% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF

 NEXT Temp1%
 END IF

 REM See if this causes a run of 4
 IF PlayCount% >= MeldCount% + 2 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
   D% = Rank%(Work%(PlayCount% - 2))
     FOR Temp2% = 1 TO 4
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
       IF C% > D% THEN SWAP C%, D%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) AND (C% = D% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF

 NEXT Temp1%
 END IF

 REM See if this causes a run of 3
 IF PlayCount% >= MeldCount% + 1 THEN
 FOR Temp1% = 1 TO Choices
   A% = Rank%(Array%(Temp1%))
   B% = Rank%(Work%(PlayCount%))
   C% = Rank%(Work%(PlayCount% - 1))
     FOR Temp2% = 1 TO 3
       IF A% > B% THEN SWAP A%, B%
       IF B% > C% THEN SWAP B%, C%
     NEXT Temp2%

   IF (A% = B% - 1) AND (B% = C% - 1) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF

 NEXT Temp1%
 END IF

 REM See if this causes a 15
 FOR Temp1% = 1 TO Choices
   IF Value%(Array%(Temp1%)) + CurrentMeld% = 15 THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF
 NEXT Temp1%

 REM See if this causes a pair (also covers 3/4 of a kind)
 FOR Temp1% = 1 TO Choices
   IF Rank%(Array%(Temp1%)) = Rank%(Work%(PlayCount%)) THEN
     Discard1% = Array%(Temp1%)
     GOTO ValidPlay2
   END IF
 NEXT Temp1%

 REM Nothing, so just play the first valid card
 Discard1% = Array%(1)
 GOTO ValidPlay2

ValidPlay2:

  CALL EraseLine
  COLOR Green
  IF Choices = 0 THEN PRINT "You have no choice but to GO";
  IF Choices = 1 THEN PRINT "You have no choice but to play card";Discard1%-4;
  IF Choices > 1 THEN PRINT "I suggest playing card";Discard1%-4;
  CALL Continue
  M1% = 4 :M3% = 237 :M4% = 399
  CALL Mouse(M1%, M2%, M3%, M4%): REM Position mouse
  CALL BottomLine (Green, White)
END SUB

SUB Quit STATIC
  CLS
  COLOR Green
  LOCATE 13, 1
  PRINT "Thanks for playing with me.."
  CALL Delay(3)
  END
END SUB

SUB SaveGame STATIC
  CALL BottomLine (Black,Black)
  CALL EraseLine
  COLOR Green
  PRINT "Game position saved.";
  OPEN "O",1,"CRIB.SAV"

  PRINT #1,USING "###";CurrentCard%;
  PRINT #1,",";
  PRINT #1,USING "###";CurrentCrib%;
  PRINT #1,",";
  PRINT #1,USING "###";CurrentMeld%;
  PRINT #1,",";
  PRINT #1,USING "###";PlayCount%;
  PRINT #1,",";
  PRINT #1,USING "###";ComputerGo%;
  PRINT #1,",";
  PRINT #1,USING "###";PlayerGo%

  PRINT #1,USING "###";RedScore%;
  PRINT #1,",";
  PRINT #1,USING "###";BlueScore%;
  PRINT #1,",";
  PRINT #1,USING "###";RedBackPeg%;
  PRINT #1,",";
  PRINT #1,USING "###";BlueBackPeg%;
  PRINT #1,",";
  PRINT #1,USING "###";CurrentPlayer%;
  PRINT #1,",";
  PRINT #1,USING "###";FirstGame%

  FOR Temp1% = 1 TO 12
    PRINT #1,USING "###";Deck%(Temp1%);
    PRINT #1,",";
  NEXT Temp1%
    PRINT #1,USING "###";Deck%(13)

  FOR Temp1% = 14 TO 25
    PRINT #1,USING "###";Deck%(Temp1%);
    PRINT #1,",";
  NEXT Temp1%
    PRINT #1,USING "###";Deck%(26)

  FOR Temp1% = 1 TO 12
    PRINT #1,USING "###";Suit%(Temp1%);
    PRINT #1,",";
  NEXT Temp1%
    PRINT #1,USING "###";Suit%(13)

  FOR Temp1% = 1 TO 12
    PRINT #1,USING "###";Rank%(Temp1%);
    PRINT #1,",";
  NEXT Temp1%
    PRINT #1,USING "###";Rank%(13)

  FOR Temp1% = 1 TO 12
    PRINT #1,USING "###";Value%(Temp1%);
    PRINT #1,",";
  NEXT Temp1%
    PRINT #1,USING "###";Value%(13)

  CLOSE #1
  CALL Continue
  M1% = 4 :M3% = 237 :M4% = 399
  CALL Mouse(M1%, M2%, M3%, M4%): REM Position mouse
  CALL BottomLine (Green,White)
END SUB

SUB Continue STATIC
  PSET (26, 444), Green
  DRAW "C2 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R80"
  DRAW "   U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L80"
  DRAW "BM -1,+1"
  DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R82 "
  DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L81"
  COLOR White
  LOCATE 29, 5: PRINT "C";
  COLOR Green
  PRINT "ontinue";

  M1% = 1
  CALL Mouse(M1%, M2%, M3%, M4%): REM Show mouse cursor
  Answer$ = INKEY$

Loop6:
  M1% = 3
  CALL Mouse(M1%, M2%, M3%, M4%)
  IF M2% AND 1 AND _
     (M3% => 27  AND M3% <= 109) AND  _
     (M4% => 445 AND M4% <= 466) THEN
     Answer$ = "C"
     GOTO HideMouse3
  END IF

  Answer$ = INKEY$: Answer$ = UCASE$(Answer$)
  IF Answer$ = CHR$(27) THEN CLS : END
  IF Answer$ <> "C" THEN GOTO Loop6

HideMouse3:
  M1% = 2
  CALL Mouse(M1%, M2%, M3%, M4%): REM Hide mouse cursor

  PSET (26, 444), Black
  DRAW "C0 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R80"
  DRAW "   U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L80"
  DRAW "BM -1,+1"
  DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R82 "
  DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L81"
  LOCATE 29, 5: PRINT "        ";
  COLOR Green
END SUB

SUB BottomLine (Parm1%,Parm2%) STATIC
    PSET (26, 444), Parm1%
    DRAW "C=" + VARPTR$(Parm1%)
    DRAW "D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R48"
    DRAW "U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L48"
    DRAW "BM -1,+1"
    DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R50 "
    DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L49"
    COLOR Parm2%
    LOCATE 29, 5: PRINT "H";
    COLOR Parm1%
    PRINT "int";

    PSET (146, 444), Parm1%
    DRAW "C=" + VARPTR$(Parm1%)
    DRAW "D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R48"
    DRAW "U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L48"
    DRAW "BM -1,+1"
    DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R50 "
    DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L49"
    COLOR Parm2%
    LOCATE 29, 20: PRINT "Q";
    COLOR Parm1%
    PRINT "uit";

    PSET (266, 444), Parm1%
    DRAW "C=" + VARPTR$(Parm1%)
    DRAW "D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R48"
    DRAW "U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L48"
    DRAW "BM -1,+1"
    DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R50 "
    DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L49"
    COLOR Parm2%
    LOCATE 29, 35: PRINT "S";
    COLOR Parm1%
    PRINT "ave";
END SUB

SUB StarBurst STATIC
  FOR B = 1 TO 200
  RANDOMIZE TIMER
  X = INT(RND * 425) + 1
  Y = INT(RND * 480) + 1
  Z = Z + 1
  IF Z > 15 THEN Z = 1
      PSET (X, Y), Z
      DRAW "C=" + VARPTR$(Z)

      FOR D = 0 TO 360 STEP 10
       DRAW "TA=" + VARPTR$(D) + "NU50"
      NEXT D
      A$ = INKEY$
      IF A$ <> "" THEN EXIT SUB
  NEXT B
END SUB

SUB ContPlay (Answer$) STATIC
  Answer$ = ""
  PSET (26, 444), Green
  DRAW "C2 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R80"
  DRAW "   U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L80"
  DRAW "BM -1,+1"
  DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R82 "
  DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L81"
  COLOR White
  LOCATE 29, 5: PRINT "C";
  COLOR Green
  PRINT "ontinue";

  PSET (146, 444), Green
  DRAW "C2 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R80"
  DRAW "U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L80"
  DRAW "BM -1,+1"
  DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R82 "
  DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L81"
  COLOR White
  LOCATE 29, 20: PRINT "P";
  COLOR Green
  PRINT "lay Game";

  M1% = 1
  CALL Mouse(M1%, M2%, M3%, M4%): REM Show mouse cursor
  Answer$ = INKEY$

Loop99:
  M1% = 3
  CALL Mouse(M1%, M2%, M3%, M4%)

  IF M2% AND 1 AND _
     (M3% => 27  AND M3% <= 109) AND  _
     (M4% => 445 AND M4% <= 466) THEN
     Answer$ = "C"
     GOTO HideMouse99
  END IF

  IF M2% AND 1 AND _
     (M3% => 147 AND M3% <= 229) AND  _
     (M4% => 445 AND M4% <= 466) THEN
     Answer$ = "P"
     GOTO HideMouse99
  END IF

  Answer$ = INKEY$: Answer$ = UCASE$(Answer$)
  IF Answer$ = CHR$(27) THEN CLS : END
  IF Answer$ = "C" THEN GOTO HideMouse99
  IF Answer$ = "P" THEN GOTO HideMouse99
  GOTO Loop99

HideMouse99:
  M1% = 2
  CALL Mouse(M1%, M2%, M3%, M4%): REM Hide mouse cursor

  PSET (26, 444), Black
  DRAW "C0 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R80"
  DRAW "   U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L80"
  DRAW "BM -1,+1"
  DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R82 "
  DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L81"
  LOCATE 29,  5: PRINT "        ";
  COLOR Green

  PSET (146, 444), Black
  DRAW "C0 D1 L2 D1 L1 D1 L1 D15 R1 D1 R1 D1 R2 D1 R80"
  DRAW "U1 R2 U1 R1 U1 R1 U15 L1 U1 L1 U1 L2 U1 L80"
  DRAW "BM -1,+1"
  DRAW "D1 L1 D1 L1 D15 R1 D1 R1 D1 R82 "
  DRAW "U1 R1 U1 R1 U15 L1 U1 L1 U1 L81"
  LOCATE 29, 20: PRINT "         ";
  COLOR Green

END SUB
