{ MUZIEKV.PAS : Muzikaal geheugenspel

  Titel   : MUZIEKV
  Taal    : Borland Pascal v7.0 + Turbo Vision v2.0
  Versie  : 1.7
  Datum   : 27 feb 2000
  Auteur  : J R Ferguson, Amsterdam
  Gebruik : MS-DOS real mode programma
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

  Dit programma, alsmede de broncode ervan, mag  zonder  vergoeding  worden
  gekopieerd  en  gebruikt, maar uitsluitend zonder winstoogmerk. De auteur
  kan op geen enkele manier aansprakelijk worden  gesteld  voor  vergoeding
  van  schade of verlies van gegevens dat door het gebruik ervan zou kunnen
  zijn veroorzaakt.

  Het programma maakt gebruik van unit MsgBoxN. Dit is een Nederlandstalige 
  versie van MsgBox. Indien men hier niet over beschikt kan men deze rustig
  vervangen door MsgBox.
}


PROGRAM MUZIEKV;

uses Objects, App, Menus, Drivers, Views, Dialogs, MsgBoxN, Crt, Dos;

{$I OBJTYPE.INC}

const
  C_MinToetsAantal =  3;
  C_StdToetsAantal =  8;
  C_MaxToetsAantal = 10;

  C_StdVastBegin   = true;
  C_StdSpeelTune   = true;

  C_MinSnelheid    =  1;
  C_StdSnelheid    = 12;
  C_MaxSnelheid    = 23;

  C_ProgIdent      = 'MUZIEKV v1.7';
  C_ProgTitle      = 'Muzikaal geheugenspel';
  C_Copyright      = '(c) 1996-2000 J.R. Ferguson';
  C_Email          = 'j.r.ferguson@iname.com';
  C_URL            = 'http://hello.to/ferguson';
  C_InstelFileNaam = 'MUZIEKV.SET';

  cm_HoofdMenu  = cmMenu;
  cm_SpelBegin  = 100;
  cm_SpelInstel = 101;
  cm_SpelEinde  = cmQuit;
  cm_HelpUitleg = 110;
  cm_HelpInfo   = 111;
  cm_InstelStnd = 120;
  cm_ToetsBase  = 200;

type
  PTitleStr     = ^TTitleStr;
  P_FramedText  = ^T_FramedText;
  P_Frame       = ^T_Frame;
  P_Noot        = ^T_Noot;
  P_Melodie     = ^T_Melodie;
  P_Toets       = ^T_Toets;
  P_Toetsenbord = ^T_Toetsenbord;
  P_PromptText  = ^T_PromptText;
  P_StatusText  = ^T_StatusText;
  P_Instelling  = ^T_Instelling;
  P_SpelWindow  = ^T_SpelWindow;
  P_MessageDlg  = ^T_MessageDlg;
  P_EditDialog  = ^T_EditDialog;
  P_InstelBuf   = ^T_InstelBuf;
  P_InstelDlg   = ^T_InstelDlg;
  P_MenuBar     = ^T_MenuBar;
  P_StatusLine  = ^T_StatusLine;
  P_Application = ^T_Application;

  T_Toon        = 1..C_MaxToetsAantal;
  T_Duur        = Word;
  T_ToetsLabel  = String[4];

  T_FramedText  = Object(TStaticText)
    Constructor Init(var V_Bounds: TRect; V_Title: TTitleStr);
  end;

  T_Frame       = Object(T_FramedText)
    Constructor Init(var V_Bounds: TRect);
  end;

  T_Noot        = Object(TObject)
    Toon        : T_Toon;
    Duur        : T_Duur;
    Constructor Init(V_Toon: T_Toon; V_Duur: T_Duur);
  end;

  T_Melodie     = Object(TCollection) { of P_Noot }
    Constructor Init;
    procedure   Reset;
    procedure   VoegToe(V_Toon: T_Toon; V_Duur: T_Duur);
  end;

  T_Toets       = Object(TButton)
    Toon        : T_Toon;
    Constructor Init(var V_Bounds: TRect; V_Toon: T_Toon);
  end;

  T_Toetsenbord = Object(TGroup)
    Toetsen     : PCollection;
    ToetsStatus : integer;
    Constructor Init(var V_Bounds: TRect; V_ToetsAantal: T_Toon);
    Destructor  Done; virtual;
    function    ZoekToets(V_Toon: T_Toon): P_Toets;
    procedure   Reset;
    procedure   ActiveerToetsen;
    procedure   DeactiveerToetsen;
    function    ToetsenActief: boolean;
  end;

  T_PromptText  = Object(TParamText)
    ParmRec     : PTitleStr;
    Prompt      : TTitleStr;
    Constructor Init(V_Bounds: TRect);
    procedure   Display(V_Prompt: TTitleStr);
    procedure   DisplayOff;
  end;

  T_StatusText  = Object(TParamText)
    ParmRec     : PTitleStr;
    StatusStr   : TTitleStr;
    Constructor Init(V_Bounds: TRect);
    procedure   Display(V_Count: integer);
    procedure   DisplayOff;
  end;

  T_Instelling  = Object(TObject)
    ToetsAantal : integer;
    VastBegin   : boolean;
    SpeelTune   : boolean;
    Snelheid    : integer;
    Constructor Init(V_ToetsAantal: integer;
                     V_VastBegin  : boolean;
                     V_SpeelTune  : boolean;
                     V_Snelheid   : integer);
    Constructor Load (var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
  end;

  T_SpelWindow  = Object(TDialog)
    Instelling  : P_Instelling;
    PromptText  : P_PromptText;
    StatusText  : P_StatusText;
    Toetsenbord : P_Toetsenbord;
    Melodie     : P_Melodie;
    SpelActief  : boolean;
    ToetsStatus : integer;
    AantalNoten : integer;
    Constructor Init(var V_Bounds: TRect; V_Title: TTitleStr);
    Destructor  Done; virtual;
    procedure   SpelInit;
    procedure   SpelTerm;
    procedure   SpelReset;
    procedure   SpelReInit;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   ClearPendingEvents;
    procedure   ActiveerToetsen;
    procedure   DeactiveerToetsen;
    function    ToetsenActief: boolean;
    procedure   DoeToets(V_Toon: T_Toon);
    procedure   DoeSpelBegin;
    procedure   DoeSpelInstel;
    procedure   NieuweMelodie;
    procedure   NieuweNoot;
    procedure   Wacht(V_Duur: T_Duur);
    procedure   SpeelNoot(V_Toon: T_Toon; V_Duur: T_Duur);
    procedure   SpeelMelodie(V_Melodie: P_Melodie);
    procedure   BeginMelodie;
    procedure   EindMelodie;
    procedure   DoeEindeSpel;
  end;

  T_MessageDlg  = Object(TDialog)
    Constructor Init(V_Title: TTitleStr; V_MsgRows: integer; V_Msg: String);
  end;


  T_EditDialog  = Object(TDialog)
    IOBuffer    : Pointer;
    SpelWindow  : P_SpelWindow;
    Constructor Init(V_Cols, V_Rows: integer; V_Title: TTitleStr;
                     V_SpelWindow: P_SpelWindow);
    Destructor  Done;                virtual;
    function    Valid(V_Command: Word): boolean; virtual;
    procedure   InitBuffer;          virtual;
    procedure   InitControls;        virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
  end;

  T_InstelBuf   = record
                    IO_ToetsAantal: Word;
                    IO_VastBegin  : Word;
                    IO_SpeelTune  : Word;
                  end;

  T_InstelDlg   = Object(T_EditDialog)
    ScrollBar   : PScrollbar;
    Instelling  : P_Instelling;
    Constructor Init(V_SpelWindow: P_SpelWindow);
    Destructor  Done;                virtual;
    procedure   InitBuffer;          virtual;
    procedure   InitControls;        virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
    function    Valid(V_Command: Word): boolean; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoReset;
  end;

  T_MenuBar     = Object(TMenuBar)
    procedure   Draw; virtual;
  end;

  T_StatusLine  = Object(TStatusLine)
    procedure   Draw; virtual;
  end;

  T_Application = Object(TApplication)
    SpelWindow  : P_SpelWindow;
    Constructor Init;
    Destructor  Done;           virtual;
    procedure   InitMenuBar;    virtual;
    procedure   InitStatusLine; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoHelpUitleg;
    procedure   DoHelpInfo;
  end;

const
  Hz        : array[T_Toon] of Word =
    (523,587,659,698,784,880,988,1047,1175,1319);

  R_Instelling : TStreamRec = (
    ObjType : OT_MUZIEKV_Instelling;
    VmtLink : Ofs(TypeOf(T_Instelling)^);
    Load    : @T_Instelling.Load;
    Store   : @T_Instelling.Store);

var
  GV_HomeDir: PathStr;


{ --- Algemeen --- }

function ToetsLabel(V_Toon: T_Toon): T_ToetsLabel;
var s: String[2];
begin Str(V_Toon:2,s); ToetsLabel:= s[1]+'~'+s[2]+'~'; end;

procedure StreamRegistration;
begin
  RegisterType(R_Instelling);
end;

function GetHomeDir: PathStr;
var ExePath: PathStr; Dir: DirStr; Name: NameStr; Ext: ExtStr;
begin
  ExePath:= FExpand(ParamStr(0));
  FSplit(ExePath,Dir,Name,Ext);
  GetHomeDir:= Dir;
end;

procedure LeesInstelling(var V_Instelling: P_Instelling);
var DosStream: TDosStream;
begin
  DosStream.Init(GV_HomeDir+C_InstelFileNaam,stOpenRead);
  V_Instelling:= P_Instelling(DosStream.Get);
  DosStream.Done;
  if DosStream.Status <> StOK then
    New(V_Instelling,Init(C_StdToetsAantal,C_StdVastBegin,C_StdSpeelTune,C_StdSnelheid));
end;

function BewaarInstelling(V_Instelling: P_Instelling): boolean;
var DosStream: TDosStream;
begin
  DosStream.Init(GV_HomeDir+C_InstelFileNaam,stCreate);
  DosStream.Put(V_Instelling);
  DosStream.Done;
  if DosStream.Status <> StOK then begin
    MessageBox(#3'Unable to save settings'#13#13 +
               #3+GV_HomeDir+C_InstelFileNaam,nil,
    mfError or mfOKButton);
    BewaarInstelling:= false;
  end
  else BewaarInstelling:= true;
end;


{ --- T_FramedText --- }

Constructor T_FramedText.Init(var V_Bounds: TRect; V_Title: TTitleStr);
begin
  Inherited Init(V_Bounds,V_Title);
  Options:= Options or ofFramed;
end;


{ --- T_Frame --- }

Constructor T_Frame.Init(var V_Bounds: TRect);
begin Inherited Init(V_Bounds,''); end;


{ --- T_Noot --- }

Constructor T_Noot.Init(V_Toon: T_Toon; V_Duur: T_Duur);
begin
  Inherited Init;
  Toon:= V_Toon;
  Duur:= V_Duur;
end;


{ --- T_Melodie --- }

Constructor T_Melodie.Init;
begin Inherited Init(20,20); end;

procedure   T_Melodie.Reset;
begin FreeAll; end;

procedure   T_Melodie.VoegToe(V_Toon: T_Toon; V_Duur: T_Duur);
begin Insert(New(P_Noot,Init(V_Toon,V_Duur))); end;


{ --- T_Toets --- }

Constructor T_Toets.Init(var V_Bounds: TRect; V_Toon: T_Toon);
begin
  Inherited Init(V_Bounds,ToetsLabel(V_Toon),cm_ToetsBase+V_Toon,bfNormal);
  Options:= Options and not ofSelectable;
  Toon:= V_Toon;
end;


{ --- T_Toetsenbord --- }

Constructor T_Toetsenbord.Init(var V_Bounds: TRect; V_ToetsAantal: T_Toon);
var i: T_Toon; p: P_Toets; R0,R: TRect; dx: integer;
begin
  Inherited Init(V_Bounds);
  ToetsStatus:= 0;
  New(Toetsen,Init(V_ToetsAantal,0));

  GetExtent(R); Insert(New(PStaticText,Init(R,'')));

  GetExtent(R0); dx:= R0.B.X div V_Toetsaantal;
  R0.Grow(-((R0.B.X - (V_ToetsAantal * dx)) div 2),0);

  R.Copy(R0);
  Dec(R.B.Y,3); R.B.X:= R.A.X + dx;
  for i:= 1 to V_ToetsAantal do begin
    New(p,Init(R,i));
    Toetsen^.Insert(p);
    Insert(p);
    R.Move(dx,0);
  end;

  R.Copy(R0); R.A.Y:= R.B.Y-2;
  Insert(New(PButton,Init(R,'Begin spel',cm_SpelBegin,bfDefault)));
  SelectNext(false);
end;

Destructor T_ToetsenBord.Done;
begin
  Toetsen^.DeleteAll; Dispose(Toetsen,Done);
  Inherited Done;
end;

function   T_ToetsenBord.ZoekToets(V_Toon: T_Toon): P_Toets;
begin
  if V_Toon > Toetsen^.Count then ZoekToets:= nil
  else ZoekToets:= Toetsen^.At(V_Toon-1);
end;

procedure  T_Toetsenbord.Reset;
begin ToetsStatus:= 0; end;

procedure   T_ToetsenBord.ActiveerToetsen;
begin
  if ToetsStatus = 1 then begin
    ToetsStatus:= 0;
  end
  else if ToetsStatus > 0 then Dec(ToetsStatus);
end;

procedure   T_ToetsenBord.DeactiveerToetsen;
begin
  if ToetsStatus = 0 then begin
    ToetsStatus:= 1;
  end
  else if ToetsStatus < MaxInt then Inc(ToetsStatus);
end;

function    T_ToetsenBord.ToetsenActief: boolean;
begin ToetsenActief:= ToetsStatus = 0; end;


{ --- T_PromptText --- }

Constructor T_PromptText.Init(V_Bounds: TRect);
begin
  Inherited Init(V_Bounds,#3'%s',1);
  Prompt:=''; ParmRec:= @Prompt; SetData(ParmRec);
end;

procedure   T_PromptText.Display(V_Prompt: TTitleStr);
begin Prompt:= V_Prompt; Draw; end;

procedure   T_PromptText.DisplayOff;
begin Display(''); end;


{ --- T_StatusText --- }

Constructor T_StatusText.Init(V_Bounds: TRect);
begin
  Inherited Init(V_Bounds,#3'%s',1);
  StatusStr:= ''; ParmRec:= @StatusStr; SetData(ParmRec);
end;

procedure   T_StatusText.Display(V_Count: integer);
var SCnt: string[3];
begin
  Str(V_Count:3,SCnt); StatusStr:= 'Aantal noten:'+SCnt;
  Draw;
end;

procedure   T_StatusText.DisplayOff;
begin StatusStr:= ''; Draw; end;


{ --- T_Instelling --- }

Constructor T_Instelling.Init(V_ToetsAantal: integer;
                              V_VastBegin  : boolean;
                              V_SpeelTune  : boolean;
                              V_Snelheid   : integer);
begin
  ToetsAantal := V_ToetsAantal;
  VastBegin   := V_VastBegin;
  SpeelTune   := V_SpeelTune;
  Snelheid    := V_Snelheid;
end;

Constructor T_Instelling.Load (var V_Stream: TStream);
begin with V_Stream do begin
  Read(ToetsAantal,SizeOf(ToetsAantal));
  Read(VastBegin  ,SizeOf(VastBegin  ));
  Read(SpeelTune  ,SizeOf(SpeelTune  ));
  Read(Snelheid   ,SizeOf(Snelheid   ));
end; end;

procedure   T_Instelling.Store(var V_Stream: TStream);
begin with V_Stream do begin
  Write(ToetsAantal,SizeOf(ToetsAantal));
  Write(VastBegin  ,SizeOf(VastBegin  ));
  Write(SpeelTune  ,SizeOf(SpeelTune  ));
  Write(Snelheid   ,SizeOf(Snelheid   ));
end; end;


{ --- T_SpelWindow --- }

Constructor T_SpelWindow.Init(var V_Bounds: TRect; V_Title: TTitleStr);
var R: TRect;
  procedure   InitInstelling;
  var DosStream: TDosStream;
  begin
    DosStream.Init(GV_HomeDir+C_InstelFileNaam,stOpenRead);
    Instelling:= P_Instelling(DosStream.Get);
    DosStream.Done;
    if DosStream.Status <> StOK then
      New(Instelling,Init(C_StdToetsAantal,C_StdVastBegin,C_StdSpeelTune,C_StdSnelheid));
  end;
begin {T_SpelWindow.init}
  Inherited Init(V_Bounds,V_Title);
  Flags       := Flags and not (wfMove or wfClose);
  Palette     := wpBlueWindow;
  LeesInstelling(Instelling);
  GetExtent(R); R.A.Y:= 2; R.B.Y:= 3; R.Grow(-4,0);
  New(PromptText,Init(R)); Insert(PromptText);
  R.Move(0,1);
  New(StatusText,Init(R)); Insert(StatusText);
  New(Melodie,Init);
  SpelInit;
end;

Destructor  T_SpelWindow.Done;
begin
  PromptText^.DisplayOff;
  StatusText^.DisplayOff;
  DeactiveerToetsen;
  Dispose(Melodie,Done);
  EindMelodie;
  Spelterm;
  BewaarInstelling(Instelling);
  Dispose(Instelling,Done);
  Inherited Done;
end;

procedure   T_SpelWindow.SpelInit;
var R: TRect;
begin
  SpelReset;
  GetExtent(R); R.Grow(-4,-1); Inc(R.A.Y,4);
  New(Toetsenbord,Init(R,Instelling^.ToetsAantal)); Insert(ToetsenBord);
end;

procedure   T_SpelWindow.SpelTerm;
begin
  Delete(ToetsenBord);
  Dispose(Toetsenbord,Done);
end;

procedure   T_SpelWindow.SpelReSet;
begin
  PromptText^.Display('');
  StatusText^.DisplayOff;
  SpelActief  := false;
  AantalNoten := 0;
  ToetsenBord^.Reset; Melodie^.Reset;
end;

procedure   T_SpelWindow.SpelReInit;
begin
  DeactiveerToetsen;
  SpelTerm; SpelInit;
  ActiveerToetsen;
end;

procedure   T_SpelWindow.ActiveerToetsen;
begin
  ClearPendingEvents;
  ToetsenBord^.ActiveerToetsen;
end;

procedure   T_SpelWindow.DeactiveerToetsen;
begin ToetsenBord^.DeactiveerToetsen; end;

function    T_SpelWindow.ToetsenActief: boolean;
begin ToetsenActief:= ToetsenBord^.ToetsenActief; end;

procedure   T_SpelWindow.HandleEvent(var V_Event: TEvent);
begin with V_Event do begin
  Inherited HandleEvent(V_Event);
  case What of
    evCommand: case Command of
      cm_SpelBegin  : begin DoeSpelBegin ; ClearEvent(V_Event); end;
      cm_SpelInstel : begin DoeSpelInstel; ClearEvent(V_Event); end;
    end;
  end;
  if ToetsenActief then case What of
    evCommand: if (Command >= cm_ToetsBase + 1                      ) and
                  (Command <= cm_ToetsBase + Instelling^.ToetsAantal)
               then begin
                 DoeToets(Command - cm_ToetsBase);
                 ClearEvent(V_Event);
               end;
  end;
end; end;

procedure   T_SpelWindow.ClearPendingEvents;
var Event: TEvent;
begin while EventAvail do GetEvent(Event); end;

procedure   T_SpelWindow.DoeToets(V_Toon: T_Toon);
begin
  SpeelNoot(V_Toon,3);
  if SpelActief then begin
    Inc(AantalNoten);
    if (AantalNoten <= Melodie^.Count) then begin
      if P_Noot(Melodie^.At(AantalNoten-1))^.Toon = V_Toon then begin
        if AantalNoten = Melodie^.Count then begin {goed nagespeeld}
          DeactiveerToetsen;
          Wacht(3);
          NieuweNoot;
          ActiveerToetsen;
        end;
      end
      else begin {verkeerde toon}
        DeactiveerToetsen;
        DoeEindeSpel;
        ActiveerToetsen;
      end;
    end;
  end;
end;

procedure   T_SpelWindow.DoeSpelBegin;
begin NieuweMelodie; SpelActief:= true; end;

procedure   T_SpelWindow.DoeSpelInstel;
begin
  if Application^.ExecuteDialog(New(P_InstelDlg,Init(@Self)),nil) = cmOK
    then SpelReInit
    else SpelReset;
end;

procedure   T_SpelWindow.NieuweNoot;
var i,n: integer;
begin with Instelling^ do begin
  DeactiveerToetsen;
  if VastBegin then Melodie^.VoegToe(1+Random(ToetsAantal),3)
  else begin
    n:= Melodie^.Count + 1; Melodie^.Reset;
    for i:= 1 to n do Melodie^.VoegToe(1+Random(ToetsAantal),3);
  end;
  PromptText^.Display('Luister goed ...');
  StatusText^.Display(Melodie^.Count);
  AantalNoten:= 0;
  SpeelMelodie(Melodie);
  PromptText^.Display('Speel het na ...');
  ActiveerToetsen;
end; end;

procedure   T_SpelWindow.NieuweMelodie;
begin
  DeactiveerToetsen;
  Melodie^.Reset;
  NieuweNoot;
  ActiveerToetsen;
end;


procedure   T_SpelWindow.Wacht(V_Duur: T_Duur);
var t0,t: LongInt;
const C_cSecPerDag = 24 * 60 * 60 * 100;
  function KlokTijd: LongInt;
  var u,m,s,c: Word;
  begin
    GetTime(u,m,s,c);
    KlokTijd:= ((LongInt(u)*60+LongInt(m))*60+LongInt(s))*100+LongInt(c);
  end;
begin {Wacht}
  t0:= KlokTijd;
  repeat
    t:= KlokTijd; if t<t0 then Inc(t,C_cSecPerDag);
  until (t-t0) > (2+C_MaxSnelheid-Instelling^.Snelheid) * V_Duur;
end;


procedure   T_SpelWindow.SpeelNoot(V_Toon: T_Toon; V_Duur: T_Duur);
var Toets: P_Toets;
begin
  Toets:= Toetsenbord^.ZoekToets(V_Toon);
  if Toets <> nil then Toets^.DrawState(true);
  Sound(Hz[V_Toon]); Wacht(V_Duur); NoSound;
  if Toets <> nil then Toets^.DrawState(false);
end;

procedure   T_SpelWindow.SpeelMelodie(V_Melodie: P_Melodie);
  procedure Speel(V_Noot: Pointer); far;
  begin with P_Noot(V_Noot)^ do SpeelNoot(Toon,Duur); end;
begin
  V_Melodie^.ForEach(@Speel);
end;

procedure   T_SpelWindow.BeginMelodie;
var Toon: T_Toon; OudeSnelheid: integer;
begin with Instelling^ do if SpeelTune then begin
  DeactiveerToetsen;
  OudeSnelheid:= Snelheid; Snelheid:= C_StdSnelheid;
  SpeelNoot(1,2);
  for Toon:= 2 to 7 do SpeelNoot(Toon,1);
  SpeelNoot(8,3);
  Snelheid:= OudeSnelheid;
  ActiveerToetsen;
end; end;

procedure   T_SpelWindow.EindMelodie;
var Toon: T_Toon; OudeSnelheid: integer;
begin with Instelling^ do if SpeelTune then begin
  DeactiveerToetsen;
  OudeSnelheid:= Snelheid; Snelheid:= C_StdSnelheid;
  SpeelNoot(8,2);
  for Toon:= 7 downto 2 do SpeelNoot(Toon,1);
  SpeelNoot(1,3);
  Snelheid:= OudeSnelheid;
  ActiveerToetsen;
end; end;

procedure   T_SpelWindow.DoeEindeSpel;
var s: String;
begin
  SpelActief:= false; PromptText^.Display('');
  if Melodie^.Count = 1 then
    s:= 'Het ging al fout bij de eerste noot.'
  else begin
    Str(Melodie^.Count,s);
    s:= 'Het ging fout bij '+s+' noten.';
  end;
  Application^.ExecuteDialog(New(P_MessageDlg,Init('Jammer !',1,#3+s)),nil);
  StatusText^.DisplayOff;
end;


{ --- T_MessageDlg --- }

Constructor T_MessageDlg.Init(V_Title: TTitleStr;
                              V_MsgRows: integer; V_Msg: String);
var R: TRect; X: integer;
begin
  DeskTop^.GetExtent(R); X:= (R.B.X-R.A.X) div 2;
  R.Assign(X-20,07,X+20,07 + V_MsgRows + 6);
  Inherited Init(R,V_Title);

  R.Assign(02,02,38,02 + V_MsgRows);
  Insert(New(PStaticText,Init(R, V_Msg)));

  R.Assign(15,02 + V_MsgRows + 1, 25,02 + V_MsgRows + 3);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));
end;


{ --- T_EditDialog --- }

Constructor T_EditDialog.Init(V_Cols, V_Rows: integer; V_Title: TTitleStr;
                              V_SpelWindow: P_SpelWindow);
var R: TRect;
begin
  R.Assign(0,0,V_Cols,V_Rows);
  Inherited Init(R,V_Title);
  SpelWindow:= V_SpelWindow;
  Options:= Options or ofCentered;
  InitBuffer;
  InitControls;
  if IOBuffer <> nil then ImportData;
end;

Destructor  T_EditDialog.Done;
begin
  if IOBuffer <> nil then begin
    Dispose(IOBuffer);
    IOBuffer:= nil;
  end;
  Inherited Done;
end;

function    T_EditDialog.Valid(V_Command: Word): boolean;
var IsOK: boolean;
begin
  if V_Command = cmCancel then IsOK:= true else IsOK:= ExportData;
  Valid:= IsOK and Inherited Valid(V_Command);
end;

procedure   T_EditDialog.InitBuffer;          begin IOBuffer:= nil; end;
procedure   T_EditDialog.InitControls;        begin end;
procedure   T_EditDialog.ImportData;          begin end;
function    T_EditDialog.ExportData: boolean; begin ExportData:= true; end;


{ --- T_InstelDlg --- }

Constructor T_InstelDlg.Init(V_SpelWindow: P_SpelWindow);
begin
  Inherited Init(42,15,'Instelling',V_SpelWindow);
end;

Destructor  T_InstelDlg.Done;
begin
  Dispose(Instelling,Done);
  Inherited Done;
end;

procedure   T_InstelDlg.InitBuffer;
begin
  IOBuffer  := new(P_InstelBuf);
  New(Instelling,Init(
    SpelWindow^.Instelling^.ToetsAantal,
    SpelWindow^.Instelling^.VastBegin  ,
    SpelWindow^.Instelling^.SpeelTune  ,
    SpelWindow^.Instelling^.Snelheid    ));
end;

procedure   T_InstelDlg.InitControls;
var R: TRect; StringList: PSItem; i: integer; p: PView;
begin
  R.Assign(03,02,11,13); Insert(New(P_FramedText,Init(R,'Aantal toetsen')));
  StringList:= nil;
  for i:= C_MaxToetsAantal downto C_MinToetsAantal do begin
    StringList:= NewSItem(ToetsLabel(i),StringList);
  end;
  R.Assign(03,05,11,13); Insert(New(PRadioButtons,Init(R,StringList)));

  R.Assign(14,02,39,04); Insert(New(P_Frame,Init(R)));
  R.Assign(14,02,39,03); Insert(New(PCheckBoxes,Init(R,NewSItem('~V~aste beginmelodie',nil))));
  R.Assign(14,03,39,04); Insert(New(PCheckBoxes,Init(R,NewSItem('~H~erkenningsmelodie',nil))));

  R.Assign(14,05,39,07); Insert(New(P_Frame,Init(R)));
  R.Assign(14,05,39,06); Insert(New(PLabel,Init(R,'langzaam           snel',ScrollBar)));
  R.Assign(14,06,39,07); ScrollBar:= New(PScrollBar,Init(R));
  with ScrollBar^ do begin
    SetParams(C_StdSnelheid,C_MinSnelheid,C_MaxSnelheid,4,1);
    Options:= Options or ofSelectable or ofFirstClick;
  end;
  Insert(ScrollBar);

  R.Assign(27,08,40,10); Insert(New(PButton,Init(R,'~S~tandaard',cm_InstelStnd,bfNormal)));
  R.Assign(27,10,40,12);Insert(New(PButton,Init(R,'~A~nnuleren',cmCancel     ,bfNormal )));
  R.Assign(27,12,40,14);Insert(New(PButton,Init(R,'O~K~'       ,cmOK         ,bfDefault)));

  SelectNext(false);
end;

procedure   T_InstelDlg.ImportData;
begin with Instelling^, P_InstelBuf(IOBuffer)^ do begin
  IO_ToetsAantal:= ToetsAantal - C_MinToetsAantal;
  if VastBegin then IO_VastBegin:= 1 else IO_VastBegin:= 0;
  if SpeelTune then IO_SpeelTune:= 1 else IO_SpeelTune:= 0;
  SetData(IOBuffer^);
  ScrollBar^.SetValue(Snelheid);
  Redraw;
end; end;

function    T_InstelDlg.ExportData: boolean;
begin with Instelling^, P_InstelBuf(IOBuffer)^ do begin
  GetData(IOBuffer^);
  ToetsAantal:= C_MinToetsAantal + IO_ToetsAantal;
  VastBegin  := IO_VastBegin = 1;
  SpeelTune  := IO_SpeelTune = 1;
  Snelheid   := ScrollBar^.value;
  ExportData := true;
end; end;

function    T_InstelDlg.Valid(V_Command: Word): boolean;
begin
  if Inherited Valid(V_Command) then begin
    if V_Command <> cmCancel then begin
      SpelWindow^.Instelling^.ToetsAantal:= Instelling^.ToetsAantal;
      SpelWindow^.Instelling^.VastBegin  := Instelling^.VastBegin  ;
      SpelWindow^.Instelling^.SpeelTune  := Instelling^.SpeelTune  ;
      SpelWindow^.Instelling^.Snelheid   := Instelling^.Snelheid   ;
    end;
    Valid:= true;
  end
  else Valid:= false;
end;

procedure   T_InstelDlg.HandleEvent(var V_Event: TEvent);
begin with V_Event do begin
  Inherited HandleEvent(V_Event);
  case What of
    evCommand: case Command of
      cm_InstelStnd : begin DoReset; ClearEvent(V_Event); end;
    end;
  end;
end; end;

procedure   T_InstelDlg.DoReset;
begin
  Dispose(Instelling,Done);
  New(Instelling,Init(C_StdToetsAantal,C_StdVastBegin,C_StdSpeelTune,C_StdSnelheid));
  ImportData;
end;


{ --- T_MenuBar --- }

procedure   T_MenuBar.Draw;
var R: TRect;
begin
  Inherited Draw;
  GetExtent(R);
end;


{ --- T_StatusLine --- }

procedure   T_StatusLine.Draw;
var R: TRect;
begin
  Inherited Draw;
  GetExtent(R);
  WriteStr(R.B.X-13, R.A.Y, C_ProgIdent, 2);
end;


{ --- T_Application --- }

Constructor T_Application.Init;
var R: TRect;
begin
  Inherited Init;
  DeskTop^.GetExtent(R);
  New(SpelWindow,Init(R,C_ProgTitle)); InsertWindow(SpelWindow);
  SpelWindow^.BeginMelodie;
end;

Destructor T_Application.Done;
begin
  Dispose(SpelWindow,Done);
  Inherited Done;
end;

procedure   T_Application.InitMenuBar;
const hc0=hcNoContext; kb0=kbNoKey;
var R: TRect;
begin
  GetExtent(R); R.B.Y:= R.A.Y + 1;
  MenuBar:= New(P_MenuBar,Init(R,NewMenu(
    NewSubMenu('~S~pel', hc0,NewMenu(
      NewItem('~B~egin spel','F2'   ,kbF2  ,cm_SpelBegin ,hc0,
      NewItem('~I~nstelling','F3'   ,kbF3  ,cm_SpelInstel,hc0,
      NewLine(
      NewItem('~E~inde'     ,'Alt+X',kbAltX,cm_SpelEinde ,hc0,
    nil))))),
    NewSubMenu('~H~elp', hc0,NewMenu(
      NewItem('~U~itleg'    ,'F1'   ,kbF1  ,cm_HelpUitleg, hc0,
      NewItem('~I~nfo'      ,''     ,kb0   ,cm_HelpInfo  , hc0,
    nil))),
  nil)))));
end;


procedure   T_Application.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y:= R.B.Y-1;
  StatusLine:= New(P_StatusLine,Init(R,NewStatusDef($0000,$FFFF,
    NewStatusKey('~F1~ Uitleg'    ,kbF1   ,cm_HelpUitleg,
    NewStatusKey('~F2~ Begin spel',kbF2   ,cm_SpelBegin,
    NewStatusKey('~F3~ Instelling',kbF3   ,cm_SpelInstel,
    NewStatusKey('~F10~ Menu'     ,kbF10  ,cm_HoofdMenu,
    NewStatusKey('~Alt+X~ Einde'  ,kbAltX ,cm_SpelEinde,
    StdStatusKeys(nil)))))),
  nil)));
end;


procedure   T_Application.HandleEvent(var V_Event: TEvent);
begin with V_Event do begin
  Inherited HandleEvent(V_Event);
  case What of
    evCommand: case Command of
      cm_HelpUitleg : begin DoHelpUitleg   ; ClearEvent(V_Event); end;
      cm_HelpInfo   : begin DoHelpInfo     ; ClearEvent(V_Event); end;
    end;
  end;
end; end;

procedure   T_Application.DoHelpUitleg;
begin
  ExecuteDialog(New(P_MessageDlg,Init('Uitleg',3,
    'Kies "Begin spel". Gebruik dan de muis of de aangegeven ' +
    'cijfertoetsen om de melodie na te spelen.')),nil);
end;

procedure   T_Application.DoHelpInfo;
begin
  ExecuteDialog(New(P_MessageDlg,Init('Informatie',6,
    #3+C_ProgIdent+#13 +
    #3'Borland Pascal + Turbo Vision'#13#13 +
    #3+C_Copyright+#13 +
    #3+C_Email+#13 +
    #3+C_URL)),nil);
end;


{ --- Hoofdprogramma --- }

begin
  Randomize;
  GV_HomeDir:= GetHomeDir;
  StreamRegistration;
  Application:= New(P_Application,Init);
  Application^.Run;
  Dispose(Application,Done);
end.
