{ 4OP1RIJW.PAS - Vier op een rij (Windows versie)

  titel    : 4OP1RIJW
  versie   : 1.2
  datum    : 10 feb 2000
  taal     : Borland Pascal v7.0 with Object Windows
  gebruik  : Windows v3.1 toepassing
  auteur   : J R Ferguson
  e-mail   : j.r.ferguson@iname.com
  download : http://hello.to/ferguson

  Dit programma,  alsmede  de  broncode  ervan,  mag  zonder  vergoeding
  gebruikt  en  gekopieerd  worden,  maar alleen zonder winstoogmerk. De
  auteur is niet aansprakelijk voor enige schade of verlies aan gegevens
  die door het gebruik ervan kan zijn veroorzaakt.
}

{$B-}  { short circuit Boolean expression evaluation }
{$V-}  { relaxed var-string checking }
{$X+}  { extended syntax }

{$UNDEF  DEBUG}  { add debug code }

program VIERRIJW;

uses WinTypes, WinProcs, Objects, OWindows, ODialogs, Strings;

{$R 4OP1RIJW.RES}
{$I 4OP1RIJW.INC}

type
  T_Speler      = (Spl_Rood,          { wie speelt (computer tegen rood of twee spelers) }
                   Spl_Twee);
  T_WieBegint   = (Beg_Rood,          { wie begint er }
                   Beg_Blauw,
                   Beg_Random);
  T_Figuur      = (Fig_Tafel,         { figuren met verschillende tekenpen en -kwast}
                   Fig_Bord,
                   Fig_Veld,
                   Fig_Rood,
                   Fig_Blauw,
                   Fig_Marker);
  T_ScanResult  = (Scn_Normaal,
                   Scn_BordVol,
                   Scn_VorigeWint,
                   Scn_VolgendeWint);

const
{ Vaste instellingen }
  C_WinLen      = 4;                  { lengte van winnende rij }
  C_MinAantal   = 5;                  { minimum aantal velden }
  C_MaxAantal   = 9;                  { maximum aantal velden }
  C_MaxRij      = 6;                  { maximum aantal rijen vertikaal }
  C_RoodZetStr  = ' - rood aan zet';
  C_BlauwZetStr = ' - blauw aan zet';
  C_EindeStr    = ' - einde spel';
  C_Weging      : array[boolean,1..C_WinLen-1] of integer =
                  ( (1, 50,6666),     { volgende zet (eigen spel) }
                    (1,100,9999) );   { huidige zet (tegenspeler) }

{ Default waarden }
  C_DflAantal   = 7;                  { aantal velden (C_MinAantal..C_MaxAantal) }
  C_DflSpeler   = Spl_Rood;           { wie speelt er (T_Speler) }
  C_DflWieBegint= Beg_Rood;           { wie begint er (T_WieBegint) }

type
  P_TekenSet    = ^T_TekenSet;        { pen en kwast om een bepaalde figuur te tekenen }
  P_TekenDoos   = ^T_TekenDoos;       { verzameling van alle benodigde tekensets }
  P_SpelObject  = ^T_SpelObject;      { basisobject voor beeldelementen }
  P_Markering   = ^T_Markering;       { markering van schijf in een rij }
  P_Schijf      = ^T_Schijf;          { speelschijf (rood of blauw) }
  P_Veld        = ^T_Veld;            { potentiele plaats voor een speelschijf }
  P_Bord        = ^T_Bord;            { bord met velden waarop het spel zich afspeelt }
  P_InstelBuf   = ^T_InstelBuf;       { instel dialoog doorgeefbuffer }
  P_InstelDlg   = ^T_InstelDlg;       { instel dialoog }
  P_EindeBuf    = ^T_EindeBuf;        { einde spel dialoog doorgeefbuffer }
  P_EindeDlg    = ^T_EindeDlg;        { einde spel dialoog }
  P_Spel        = ^T_Spel;            { applicatie venster }
  P_Applicatie  = ^T_Applicatie;      { opgestarte Windows applicatie }

  T_TekenSet    = object(TObject)
    Pen         : HPen;
    Kwast       : HBrush;
    constructor Init(V_Lijndikte: integer; V_PenKleur, V_KwastKleur: longint);
    destructor  Done; virtual;
  end;

  T_TekenDoos   = object(TObject)
    TekenSet    : array[T_Figuur] of P_TekenSet;
    constructor Init;
    destructor  Done; virtual;
    procedure   Kies(V_Context: HDC; V_Figuur: T_Figuur);
  end;

  T_SpelObject  = object(TObject)
    X, Y        : integer;             { pixelpositie middelpunt }
    Ax, Ay      : integer;             { afmetigen (halve zijde) horizontaal/vertikaal }
    Figuur      : T_Figuur;            { soort figuur }
    constructor Init(V_Figuur: T_Figuur);
    procedure   Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer); virtual;
  end;

  T_Markering   = object(T_SpelObject)
  end;

  T_Schijf      = object(T_SpelObject)
    Markering   : P_Markering;
    constructor Init(V_Figuur: T_Figuur);
    destructor  Done; virtual;
    procedure   Markeer;
    procedure   Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer); virtual;
  end;

  T_Veld        = object(T_SpelObject)
    Rij, Kolom  : integer;            { rij en kolom op het SpeelBord }
    Schijf      : P_Schijf;           { eventuale schijf, anders nil }
    constructor Init(V_Rij: integer; V_Kol: integer);
    destructor  Done; virtual;
    procedure   Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer); virtual;
    function    Bevat(V_X, V_Y: integer): boolean;
    procedure   PlaatsSchijf(V_Rood: boolean);
    procedure   Markeer;
  end;

  T_Bord        = object(T_SpelObject)
    MaxKol      : integer;            { aantal velden horizontaal }
    MaxRij      : integer;            { aantal velden vertikaal   }
    Veld        : array[1..C_MaxAantal,1..C_MaxAantal] of P_Veld;
    constructor Init(V_MaxKol: integer);
    destructor  Done; virtual;
    procedure   Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer); virtual;
    function    BordVol: boolean;
    function    VrijVeld(V_X, V_Y: Integer; var V_Kol: integer): boolean;
    function    VrijeRij(V_Kol: integer; var V_Rij: integer): boolean;
    procedure   DoeZet(V_Kol: integer; V_Rood: boolean);
    function    Scan(V_Speler: T_Speler; V_RoodAanZet: boolean): T_ScanResult;
  end;

  T_InstelBuf   = record
    Aantal      : array[C_MinAantal..C_MaxAantal] of word;
    Speler      : array[Spl_Rood..Spl_Twee] of word;
    WieBegint   : array[Beg_Rood..Beg_Random] of word;
  end;

  T_InstelDlg   = object(TDialog)
    constructor Init(V_Spel: PWindowsObject; V_Naam: PChar; V_InstelBuf: P_InstelBuf);
  end;

  T_EindeBuf    = record
    Winnaar     : array[0..12] of char;
  end;

  T_EindeDlg    = object(TDialog)
    constructor Init(V_Spel: PWindowsObject; V_Naam: PChar; V_EindeBuf: P_EindeBuf);
  end;

  T_Spel        = object(TWindow)
    Aantal      : integer;          { aantal speelvelden horizontaal }
    Speler      : T_Speler;         { computer tegen rood, of twee spelers }
    WieBegint   : T_WieBegint;      { rood eerst, blauw eerst, of willekeurig }
    Bord        : P_Bord;           { SpeelBord }
    RoodAanZet  : boolean;          { rood aan zet (ja/nee) }
    BasisTitel  : PChar;            { vaste deel van bovenschrift spel venster }
    EindeSpel   : boolean;          { einde spel bereikt (ja/nee) }
{$IFDEF DEBUG}
    DebugMode   : boolean;          { Debug mode }
{$ENDIF}
    constructor Init(V_Parent: PWindowsObject; V_Title: PChar);
    destructor  Done; virtual;
    procedure   BouwOp;
    procedure   BreekAf;
    procedure   NieuwSpel;
    procedure   SetUpWindow; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    procedure   Paint(V_Context: HDC; var V_PaintInfo: TPaintStruct); virtual;
    procedure   EindBericht(V_Winnaar: boolean);
    procedure   GeefZetAan;
    procedure   EersteZet;
    procedure   WisselZet;
    procedure   DoeZet(V_Kol: integer);
    procedure   WMLButtonDown (var V_Msg: TMessage); virtual wm_First + wm_LButtonDown;
    procedure   CMSpelInstel  (var V_Msg: TMessage); virtual cm_First + cm_SpelInstel ;
    procedure   CMSpelBegin   (var V_Msg: TMessage); virtual cm_First + cm_SpelBegin  ;
    procedure   CMHelpInfo    (var V_Msg: TMessage); virtual cm_First + cm_HelpInfo   ;
    procedure   CMHelpUitleg  (var V_Msg: TMessage); virtual cm_First + cm_HelpUitleg ;
{$IFDEF DEBUG}
    procedure   CMDebug       (var V_Msg: TMessage); virtual cm_First + cm_Debug      ;
{$ENDIF}
  end;

  T_Applicatie  = object(TApplication)
    Tekendoos   : P_Tekendoos;
    constructor Init(V_Naam: PChar);
    destructor  Done; virtual;
    procedure   InitMainWindow; virtual;
    procedure   InitInstance; virtual;
  end;

{ --- Algemeen gereedschap --- }

function Imin(i,j: integer): integer;
begin if i<j then Imin:= i else Imin:= j; end;


{ --- T_TekenSet --- }

constructor T_TekenSet.Init(V_LijnDikte: integer; V_PenKleur, V_KwastKleur: longint);
begin
  inherited Init;
  Pen  := CreatePen(ps_Solid, V_LijnDikte, V_PenKleur);
  Kwast:= CreateSolidBrush(V_KwastKleur);
end;

destructor  T_TekenSet.Done;
begin
  DeleteObject(Pen);
  DeleteObject(Kwast);
  inherited Done;
end;


{ --- T_TekenDoos --- }


constructor T_TekenDoos.Init;
begin
  inherited Init;
  New(TekenSet[Fig_Tafel ],Init(0,RGB(255,255,255),RGB(255,255,255)));
  New(TekenSet[Fig_Bord  ],Init(0,RGB(  0,  0,  0),RGB(127, 64,  0))); {niet gebruikt}
  New(TekenSet[Fig_Veld  ],Init(0,RGB(  0,  0,  0),RGB(192,192,192)));
  New(TekenSet[Fig_Rood  ],Init(0,RGB(255,  0,  0),RGB(255,  0,  0)));
  New(TekenSet[Fig_Blauw ],Init(0,RGB(  0,  0,255),RGB(  0,  0,255)));
  New(TekenSet[Fig_Marker],Init(2,RGB(255,255,  0),RGB(  0,  0,  0)));
end;

destructor  T_TekenDoos.Done;
begin
  Dispose(TekenSet[Fig_Tafel ],Done);
  Dispose(TekenSet[Fig_Bord  ],Done);
  Dispose(TekenSet[Fig_Veld  ],Done);
  Dispose(TekenSet[Fig_Rood  ],Done);
  Dispose(TekenSet[Fig_Blauw ],Done);
  Dispose(Tekenset[Fig_Marker],Done);
  inherited Done;
end;

procedure   T_TekenDoos.Kies(V_Context: HDC; V_Figuur: T_Figuur);
begin
  SelectObject(V_Context, TekenSet[V_Figuur]^.Pen);
  SelectObject(V_Context, TekenSet[V_Figuur]^.Kwast);
end;


{ --- T_SpelObject --- }

constructor T_SpelObject.Init(V_Figuur: T_Figuur);
begin
  inherited Init;
  X:= 0; Y:= 0; Ax:= 0; Ay:= 0;
  Figuur:= V_Figuur;
end;

procedure   T_SpelObject.Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer);
begin
  X:= V_X; Y:= V_Y; Ax:= V_Ax; Ay:= V_Ay;
  P_Applicatie(Application)^.Tekendoos^.Kies(V_Context,Figuur);
  case Figuur of
    Fig_Tafel  : { niets };
    Fig_Bord   : { niets };
    Fig_Veld   : Rectangle(V_Context, X-Ax,Y-Ay, X+Ax,Y+Ay);
    Fig_Rood,
    Fig_Blauw  : Ellipse  (V_Context, X-Ax,Y-Ay, X+Ax,Y+Ay);
    Fig_Marker : Arc(V_Context, X-Ax,Y-Ay, X+Ax, Y+Ay, X-Ax, Y-Ay, X-Ax, Y-Ay);
  end;
end;


{ --- T_Markering --- }



{ --- T_Schijf --- }


constructor T_Schijf.Init(V_Figuur: T_Figuur);
begin inherited Init(V_Figuur); Markering:= nil; end;

destructor T_Schijf.Done;
begin
  if Markering <> nil then Dispose(Markering,Done);
  inherited Done;
end;

procedure   T_Schijf.Markeer;
var Gebied: TRect;
begin if Markering = nil then begin
  New(Markering,Init(Fig_Marker));
  with Gebied do begin Left:= X-Ax; Top:= Y-Ay; Right:= X+Ax; Bottom:= Y+Ay; end;
  InvalidateRect(Application^.MainWindow^.HWindow,@Gebied,false);
end end;

procedure   T_Schijf.Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer);
begin
  inherited Teken(V_Context, V_X, V_Y, V_Ax, V_Ay);
  if Markering <> nil then Markering^.Teken(V_Context, V_X, V_Y, V_Ax, V_Ay);
end;


{ --- T_Veld --- }

constructor T_Veld.Init(V_Rij: integer; V_Kol: integer);
begin
  inherited Init(Fig_Veld);
  Rij    := V_Rij;
  Kolom  := V_Kol;
  Schijf := nil;
end;

destructor  T_Veld.Done;
begin
  if Schijf <> nil then Dispose(Schijf,Done);
  inherited Done;
end;

procedure   T_Veld.Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer);
var R: integer;
begin
  inherited Teken(V_Context, V_X, V_Y, V_Ax, V_Ay);
  if Schijf <> nil then begin
    R:= Imin(Ax,Ay); R:= R - R div 5;
    Schijf^.Teken(V_Context, V_X, V_Y, R, R);
  end;
end;

function    T_Veld.Bevat(V_X, V_Y: integer): boolean;
begin Bevat:= (Abs(V_X - X) <= Ax) and (Abs(V_Y - Y) <= Ay); end;

procedure   T_Veld.PlaatsSchijf(V_Rood: boolean);
var Gebied: TRect;
begin if Schijf = nil then begin
  if V_Rood then New(Schijf,Init(Fig_Rood))
            else New(Schijf,Init(Fig_Blauw));
  with Gebied do begin Left:= X-Ax; Top:= Y-Ay; Right:= X+Ax; Bottom:= Y+Ay; end;
  InvalidateRect(Application^.MainWindow^.HWindow,@Gebied,false);
end end;

procedure   T_Veld.Markeer;
begin if Schijf <> nil then Schijf^.Markeer; end;


{ --- T_Bord --- }

constructor T_Bord.Init(V_MaxKol: integer);
var r,k: integer;
begin
  inherited Init(Fig_Bord);
  MaxKol:= V_MaxKol;
  MaxRij:= Imin(C_MaxRij,MaxKol - 1);
  for r:= 1 to MaxRij do for k:= 1 to MaxKol do New(Veld[r,k], Init(r,k));
end;

destructor  T_Bord.Done;
var r,k: integer;
begin
  for r:= 1 to MaxRij do for k:= 1 to MaxKol do Dispose(Veld[r,k],Done);
  inherited Done;
end;

procedure   T_Bord.Teken(V_Context: HDC; V_X, V_Y, V_Ax, V_Ay: integer);
var X0, X1, Y0, Y1, Ax0, Ay0: integer; r,k: integer;
begin
  inherited Teken(V_Context, V_X, V_Y, V_Ax, V_Ay);
  Ax0:= Ax div MaxKol;
  Ay0:= Ay div MaxRij;
  X0 := X - Ax - Ax0;
  Y0 := Y + Ay + Ay0;
  for r:= 1 to MaxRij do for k:= 1 to MaxKol do begin
    X1:= X0 + 2 * Ax0 * k;
    Y1:= Y0 - 2 * Ay0 * r;
    Veld[r,k]^.Teken(V_Context, X1, Y1, Ax0, Ay0);
  end;
end;

function    T_Bord.BordVol: boolean;
var vol: boolean; k: integer;
begin
  vol:= true; for k:= 1 to MaxKol do if Veld[MaxRij,k]^.Schijf = nil then vol:= false;
  BordVol:= vol;
end;

function    T_Bord.VrijVeld(V_X, V_Y: Integer; var V_Kol: integer): boolean;
var Rij: integer; found: boolean;
begin
  V_Kol:= 0; found:= false;
  while (V_Kol < MaxKol) and not found do begin
    Inc(V_Kol); Rij:= 0;
    while (Rij < MaxRij) and not found do begin
      inc(Rij); found:= Veld[Rij,V_Kol]^.Bevat(V_X,V_Y)
    end;
  end;
  VrijVeld:= found and (Veld[Rij,V_Kol]^.Schijf = nil);
end;

function    T_Bord.VrijeRij(V_Kol: integer; var V_Rij: integer): boolean;
begin
  V_Rij:= MaxRij;
  while (V_Rij > 1) and (Veld[V_Rij-1,V_Kol]^.Schijf = nil) do Dec(V_Rij);
  VrijeRij:= Veld[V_Rij,V_Kol]^.Schijf = nil;
end;

procedure   T_Bord.DoeZet(V_Kol: integer; V_Rood: boolean);
var Rij: integer;
begin
  if VrijeRij(V_Kol,Rij) then
     Veld[Rij,V_Kol]^.PlaatsSchijf(V_Rood);
end;


function    T_Bord.Scan(V_Speler: T_Speler; V_RoodAanZet: boolean): T_ScanResult;
 var
   Resultaat : T_ScanResult;
   Kol, k    : integer;
   ScanLen   : array[boolean] of integer;
   Waarde    : array[1..C_MaxAantal] of integer;
   WinKol    : integer;
   WinReeks  : array[1..C_WinLen] of record rij,kol: integer end;

  procedure MarkeerReeks;
  var i: integer;
  begin for i:= 1 to C_WinLen do with WinReeks[i] do Veld[rij,kol]^.Markeer; end;

  function ScanRichting(VanRij,TotRij, VanKol,TotKol, dRij,dKol: integer): boolean;
  var Rij,Kol: integer; checking: boolean;

    function ScanReeks: boolean;
    var i: integer; StopScan: boolean;

      procedure OnthoudtReeks;
      var i: integer;
      begin
        for i:= 1 to C_WinLen do begin
          WinReeks[i].rij:= Rij+(i-1)*dRij;
          WinReeks[i].kol:= Kol+(i-1)*dKol;
        end;
      end;

      procedure ScanZet(ZetKleur: boolean);
      var i: integer; r: integer;
      begin if ScanLen[ZetKleur] > 0 then begin {ScanZet}
        i:= 0;
        repeat
          if VrijeRij(Kol+i*dKol,r) and (Rij+i*dRij = r) then begin
            inc(Waarde[Kol+i*dKol],C_Weging[ZetKleur,ScanLen[ZetKleur]]);
            if (WinKol=0) and (not ZetKleur) and (ScanLen[ZetKleur]=C_WinLen-1) then begin
              WinKol:= Kol + i*dKol; OnthoudtReeks; Resultaat:= Scn_VolgendeWint;
            end;
          end;
          inc(i);
        until (i = C_WinLen);
      end end;

    begin {ScanReeks}
      ScanLen[false]:= 0; ScanLen[true]:= 0; StopScan:= false;
      for i:= 0 to C_WinLen - 1 do
        with Veld[Rij+i*dRij,Kol+i*dKol]^ do if Schijf <> nil then
          Inc(ScanLen[(Schijf^.Figuur = Fig_Rood) = V_RoodAanZet]);
      if ScanLen[true]=C_WinLen then begin
        WinKol:= Kol + i*dKol; OnthoudtReeks; Resultaat:= Scn_VorigeWint; StopScan:= true;
      end
      else if V_Speler <> Spl_Twee then begin ScanZet(true); ScanZet(false); end;
      ScanReeks:= StopScan;
    end;

  begin {ScanRichting}
    checking:= true; Rij:= VanRij-1;
    while checking and (Rij < TotRij) do begin
      Inc(Rij); Kol:= VanKol-1;
      while checking and (Kol < TotKol) do begin
        Inc(Kol); if ScanReeks then checking:= false;
      end;
    end;
    ScanRichting:= not checking;
  end;

begin {T_Bord.Scan}
  Resultaat:= Scn_Normaal; WinKol:= 0;
  for k:= 1 to MaxKol do Waarde[k]:= 0;
            {VanRij,TotRij           , VanKol  ,TotKol           , dr,dk}
  if ScanRichting(1,MaxRij           , 1       ,MaxKol-C_WinLen+1,  0,+1) {horizontaal}
  or ScanRichting(1,MaxRij-C_WinLen+1, 1       ,MaxKol           , +1, 0) {vertikaal}
  or ScanRichting(1,MaxRij-C_WinLen+1, 1       ,MaxKol-C_WinLen+1, +1,+1) {diag L-R}
  or ScanRichting(1,MaxRij-C_WinLen+1, C_WinLen,MaxKol           , +1,-1) {diag R-L}
  then;

  if      Resultaat = Scn_VorigeWint   then MarkeerReeks
  else if Resultaat = Scn_VolgendeWint then begin {doe winnende zet}
    DoeZet(WinKol,not V_RoodAanZet); MarkeerReeks;
  end
  else begin
    if V_Speler <> Spl_Twee then begin {doe beste zet}
      Kol:= 1 + Random(MaxKol);
      if Random(2)=1 then begin
        for k:= 1 to MaxKol do if Waarde[k] > Waarde[Kol] then Kol:= k;
      end
      else begin
        for k:= MaxKol downto 1 do if Waarde[k] > Waarde[Kol] then Kol:= k;
      end;
      DoeZet(Kol,not V_RoodAanZet);
    end;
    if BordVol then Resultaat:= Scn_BordVol;
  end;
  Scan:= Resultaat;
end;



{ --- T_InstelDlg --- }

constructor T_InstelDlg.Init(V_Spel: PWindowsObject; V_Naam: PChar;
                             V_InstelBuf: P_InstelBuf);
var p: PControl; i: integer; s: T_Speler; w: T_WieBegint;
begin
  inherited Init(V_Spel, V_Naam);
  for i:= C_MinAantal to C_MaxAantal do
    p:= New(PRadioButton, InitResource(@Self, id_InstelAantal + i - C_MinAantal));
  for s:= Spl_Rood to Spl_Twee do
    p:= New(PRadioButton, InitResource(@Self, id_InstelSpeler + Ord(s)));
  for w:= Beg_Rood to Beg_Random do
    p:= New(PRadioButton, InitResource(@Self, id_InstelWieBegint + Ord(w)));
  TransferBuffer:= V_InstelBuf;
end;


{ --- T_EindeDlg --- }

constructor T_EindeDlg.Init(V_Spel: PWindowsObject; V_Naam: PChar;
                            V_EindeBuf: P_EindeBuf);
var p: PControl;
begin
  inherited Init(V_Spel, V_Naam);
  p:= New(PStatic, InitResource(@Self, id_Winnaar,12));
  TransferBuffer:= V_EindeBuf;
end;


{ --- T_Spel --- }

constructor T_Spel.Init(V_Parent: PWindowsObject; V_Title: PChar);
begin
  inherited Init(V_Parent, V_Title);
  Attr.Menu  := LoadMenu(HInstance, MakeIntResource(MNU_MAIN));
  Aantal     := C_DflAantal;
  Speler     := C_DflSpeler;
  WieBegint  := C_DflWieBegint;
  BasisTitel := StrNew(Attr.Title);
{$IFDEF DEBUG}
  DebugMode  := false;
{$ENDIF}
  BouwOp;
end;

destructor  T_Spel.Done;
begin
  BreekAf;
  StrDispose(BasisTitel);
  inherited Done;
end;

procedure   T_Spel.BouwOp;
begin
  case WieBegint of
    Beg_Rood   : RoodAanZet:= true;
    Beg_Blauw  : RoodAanZet:= false;
    Beg_Random : RoodAanZet:= Random(2) = 1;
  end;
  EindeSpel  := false;
  New(Bord,Init(Aantal));
end;

procedure   T_Spel.BreekAf;
begin Dispose(Bord,Done); end;

procedure   T_Spel.NieuwSpel;
begin
  Breekaf; Bouwop; EersteZet;
  InvalidateRect(Application^.MainWindow^.HWindow,nil,false);
end;

procedure   T_Spel.SetupWindow;
begin EersteZet; end;

function    T_Spel.GetClassName: PChar;
begin GetClassName:= '4OP1RIJW'; end;

procedure   T_Spel.GetWindowClass(var V_Class: TWndClass);
begin
  inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(ICO_MAIN));
end;

procedure   T_Spel.Paint(V_Context: HDC; var V_PaintInfo: TPaintStruct);
var X,Y,Ax,Ay: integer; ClientRect: TRect;
begin
  GetClientRect(HWindow,ClientRect);
  with ClientRect do begin
    X := (Right - Left) div 2;
    Y := (Bottom - Top) div 2;
    Ax:= Aantal * (Imin(Right - Left, Bottom - Top) div (2 * Aantal + 1));
    Ay:= (Ax div Bord^.MaxKol) * Bord^.MaxRij;
    P_Applicatie(Application)^.TekenDoos^.Kies(V_Context, Fig_Tafel);
    Rectangle(V_Context, Left, Top , X-Ax , Bottom);
    Rectangle(V_Context, X+Ax, Top , Right, Bottom);
    Rectangle(V_Context, X-Ax, Top , X+Ax , Y-Ay  );
    Rectangle(V_Context, X-Ax, Y+Ay, X+Ax , Bottom);
    Bord^.Teken(V_Context,X,Y,Ax,Ay);
  end;
end;

procedure   T_Spel.Eindbericht(V_Winnaar: boolean);
var Buf: T_EindeBuf;
begin
  EindeSpel:= true; GeefZetAan;
  if V_Winnaar then begin
    if RoodAanZet then StrCopy(Buf.Winnaar,'rood wint')
                  else StrCopy(Buf.Winnaar,'blauw wint');
  end
  else StrCopy(Buf.Winnaar,'onbeslist');
  Application^.ExecDialog(new(P_EindeDlg,Init(@Self,MakeIntResource(DLG_EINDE),@Buf)));
  NieuwSpel;
end;

procedure   T_Spel.GeefZetAan;
var Titel: array[0..127] of char;
begin
  if EindeSpel  then StrCat(StrECopy(Titel,BasisTitel),C_EindeStr)     else
  if RoodAanZet then StrCat(StrECopy(Titel,BasisTitel),C_RoodZetStr)   else
                     StrCat(StrECopy(Titel,BasisTitel),C_BlauwZetStr);
  SetCaption(Titel);
end;

procedure   T_Spel.EersteZet;
begin
  if (Speler = Spl_Twee) or RoodAanZet then GeefZetAan
  else begin
    DoeZet(1 + Random(Aantal));
    WisselZet;
  end;
end;

procedure T_Spel.WisselZet;
begin
  RoodAanzet:= not RoodAanZet;
  GeefZetAan;
end;

procedure T_Spel.DoeZet(V_Kol: integer);
begin Bord^.DoeZet(V_Kol,RoodAanZet); end;

procedure   T_Spel.WMLButtonDown (var V_Msg: TMessage);
var Kol: integer;
begin if Bord^.VrijVeld(V_Msg.LParamLo,V_Msg.LParamHi,Kol) then begin
  DoeZet(Kol);
  case Bord^.Scan(Speler,RoodAanZet) of
    Scn_Normaal      : if Speler = Spl_Twee then WisselZet;
    Scn_BordVol      : EindBericht(false);
    Scn_VorigeWint   : EindBericht(true);
    Scn_VolgendeWint : begin
                         WisselZet;
                         if Speler <> Spl_Twee then EindBericht(true);
                       end;
  end;
end end;

procedure   T_Spel.CMSpelInstel  (var V_Msg: TMessage);
var i,n: integer; j,s: T_Speler; k,w: T_WieBegint; Buf: T_InstelBuf;
begin
  n:= Aantal; s:= Speler; w:= WieBegint;
  for i:= C_MinAantal to C_MaxAantal do Buf.Aantal[i]:= bf_UnChecked;
  Buf.Aantal[n]:= bf_Checked;
  for j:= Spl_Rood to Spl_Twee do Buf.Speler[j]:= bf_UnChecked;
  Buf.Speler[s]:= bf_Checked;
  for k:= Beg_Rood to Beg_Random do Buf.WieBegint[k]:= bf_UnChecked;
  Buf.WieBegint[w]:= bf_Checked;
  if Application^.ExecDialog(New(P_InstelDlg,
    Init(@Self,MakeIntResource(DLG_INSTEL),@Buf))) = id_OK
  then begin
    for i:= C_MinAantal to C_MaxAantal do if Buf.Aantal[i] = bf_Checked then n:= i;
    for j:= Spl_Rood to Spl_Twee do if Buf.Speler[j] = bf_Checked then s:= j;
    for k:= Beg_Rood to Beg_Random do if Buf.WieBegint[k] = bf_Checked then w:= k;
    if (n <> Aantal) or (s <> Speler) or (w <> WieBegint) then begin
      Aantal:= n; Speler:= s; WieBegint:= w;
{$IFDEF DEBUG}
      if not DebugMode then
{$ENDIF}
        NieuwSpel;
    end;
  end;
end;

procedure   T_Spel.CMSpelBegin   (var V_Msg: TMessage);
begin NieuwSpel; end;

procedure   T_Spel.CMHelpInfo    (var V_Msg: TMessage);
begin
  MessageBox(HWindow,
    'Vier op een rij  (Windows versie)'#13#13 +
{$IFDEF DEBUG}
    '<Alt+D> = Debug mode'#13#13 +
{$ENDIF}
    '4OP1RIJW v1.2 (MS-Windows)'#13 +
    '(c) J.R. Ferguson, 1993-2000'#13 +
    'j.r.ferguson@iname.com'#13 +
    'http://hello.to/ferguson',
    'Informatie',
    mb_IconInformation or mb_OK);
end;

procedure   T_Spel.CMHelpUitleg  (var V_Msg: TMessage);
begin
  MessageBox(HWindow,
    'Rood en blauw laten om de beurt een schijf in een zelf gekozen kolom vallen.  ' +
    'Wie het eerst vier schijven op een rij heeft,  wint het spel.  ' +
    'De rijen mogen horizontaal, vertikaal of diagonaal lopen.',
    'Spelregels',
    mb_OK);
end;

{$IFDEF DEBUG}
procedure   T_Spel.CMDebug       (var V_Msg: TMessage);
begin
  DebugMode:= MessageBox(HWindow,
              'Spel voortzetten na wijzigen instelling',
              'Debug mode',
              mb_IconQuestion or mb_YesNo)
              = id_Yes;
end;
{$ENDIF}

{ --- T_Applicatie --- }

constructor T_Applicatie.Init(V_Naam: PChar);
begin
  inherited Init(V_Naam);
  Randomize;
  New(Tekendoos,Init);
end;

destructor  T_Applicatie.Done;
begin
  Dispose(TekenDoos,Done);
  inherited Done;
end;

procedure   T_Applicatie.InitMainWindow;
begin MainWindow:= New(P_Spel, Init(nil,'Vier op een rij')); end;

procedure   T_Applicatie.InitInstance;
begin
  inherited InitInstance;
  HAccTable:= LoadAccelerators(HInstance,MakeIntResource(ACC_KEYS));
end;


{ --- Hoofdprogramma --- }

begin
  Application:= New(P_Applicatie,Init('4OP1RIJW'));
  Application^.Run;
  Dispose(Application,Done);
end.
