; Zelda auto-map Patch
; 0.2
;
; By snarfblam
; ----------------------------
; Includes:
;   -Auto-map
;   -Faster potion/fairy refill


;========================================================
; Map image
;========================================================

; the low byte is dual purposed so must land at $xxx10
; the address must also match line 629 ($17Cxx == #$BC)
.PATCH $17C10  ;16D10
.incbin "map_tiles.gfx"

;========================================================
; Variable declarations
;========================================================


; Game variables
; --------------
LevelNumber         := $10
SaveSlot            := $16
PendingPpuMacro     := $14
CurrentMapLocation  := $EB
NewMapLocation      := $EC
OAM_MapBlipY        := $0254


; Game routines
; -------------
BankSwap        := $FFAC
SendPpuMacro    := $A0F6


; Our addresses
;----------------------
MapTiles    = $BD50 ; AD00 06:AD00
VRAM_MapTiles = $1300


; Our variables
; -----------------
.enum $6C00
    tileFlag:   .dsb 1  ; Used to indicate that there is a pending PPU macro for the map
    mapVar:     .dsb 1  ; Temporary storage variable
    mapVar_X:   .dsb 1
    mapVar_Y:   .dsb 1
    mapLoop_X:  .dsb 1
    mapLoop_Y:  .dsb 1
.endenum
.enum $7F10
    SecondPpuStringIndex: .DSB 1    ;

    MapBits_Left:   .DSB 1      ; Stores flags for whether the two screens in the left/right side
    MapBits_Right:  .DSB 1      ; of the current map tile have been visited, in lower 2 bits

    MapFilter_Top:    .DSB 1    ; Stores a value to be ANDed with the bytes of a map tile to black out unvisited screens
    MapFilter_Bottom: .DSB 1

    MapTileMacro:   .DSB $14    ; 10 bytes of tile data, 2 byte pointer, 1 byte len specifier, 1 byte FF terminator

;    TempAddress:    .DW 1

    MapBlipY:       .DSB $1     ; Stores the y-coordinate of the map blip
.ende
.enum $7F50
    MapRam:     .DSB $10
    MapSaveRam: .DSB $30
.ende


; Registers
; ---------
PpuControl1     := $2000
PpuControl2     := $2001
PpuStatus       := $2002
OamAddress      := $2003
OamData         := $2004
PpuScroll       := $2005
PpuAddress      := $2006
PpuData         := $2007



;========================================================
; Map blip blinking
;========================================================

; New blip pattern
;.PATCH $846F
;.HEX e0 e0 e0 00 00 00 00 00 e0 a0 e0 00 00 00 00 00

; Corrects positioning of map blip
;   :71F7:     LDA #$11       ; A = left edge of map

; Blip update routine
; -------------------
.PATCH 05:BF12 ;BC00
BlipUpdate:
    PHA

    ; Exit if in a dungeon
    LDA LevelNumber
    BNE exitHijack

    ; Grab the current blip position if it is on-screen
    LDA OAM_MapBlipY
    CMP #$FF
    BEQ +
        STA MapBlipY
    *

OW_BlipUpdate:
    LDA $15 ; Get frame counter

    ; Blink every 32 frames
    LSR
    LSR
    LSR
    LSR
    LSR
    BCC +

    ; Show blip
    LDA MapBlipY
    STA OAM_MApBlipY
    BNE exitHijack

    ; Hide blip
*   LDA #$FF
    STA OAM_MapBlipY

exitHijack:
    PLA
    JMP $77E7


; Hijack
; ------
.PATCH 07:F322 ; Per-frame update hijack
    JSR SafeBlipUpdate


; SafeBlipUpdate
; --------------

;This routine is placed after DoWholeMapHijack (under "Draw whole map -HIJACK-") below
;because these two functions must be placed in the fixed bank, together in the small available space.


; ===========================================================
;  Map PPU macros
; ===========================================================
; New tilemap for the map to allow each tile to be unique.

.PATCH $1935F
; Whole overworld map
.db $20, $62
.db $08
;.db $30,$30,$30,$30,$30,$30,$30,$30
.db $30, $31, $32, $33, $34, $35, $36, $37

.db $20, $82
.db $08
;.db $30,$30,$30,$30,$30,$30,$30,$30
.db $38, $39, $3A, $3B, $3C, $3D, $3E, $3F

.db $20, $A2
.db $08
;.db $30,$30,$30,$30,$30,$30,$30,$30
.db $40, $41, $42, $43, $44, $45, $46, $47

.db $20, $C2
.db $08
;.db $30,$30,$30,$30,$30,$30,$30,$30
.db $48, $49, $4A, $4B, $4C, $4D, $4E, $4F

.db $FF


; ===========================================================
;  New Map Attribute
; ===========================================================
; Used to apply the proper palette for the overworld map.

; This is the original routine that queues the PPU macro that sets HUD palettes
;05:B005:A9 18     LDA #$18
;05:B007:D0 0F     BNE $B018
;05:B009:A9 D0     LDA #$D0
;05:B00B:A0 17     LDY #$17
;05:B00D:4C 01 85  JMP $8501
;05:B010:A9 E8     LDA #$E8
;05:B012:A0 2F     LDY #$2F
;05:B014:D0 F7     BNE $B00D
;05:B016:A9 0E     LDA #$0E
;05:B018:85 14     STA $0014 = #$00
;05:B01A:E6 13     INC $0013 = #$05
;05:B01C:60        RTS

OriginalHudAttributeMacro = $A2D3

.PATCH 05:B01A
    ; Hijack the routine that queues the attribute macro
    JMP NewHudMacroSelector


.PATCH 05:AD30 ;AF20

; Map palette selection routine
; -----------------------------
; If the overworld map attribute macro is queued in a level, we swap in the
; dungeon map attribute macro (since we've changed the overworld map macro)

NewHudMacroSelector:
; Skip this routine for overworld
    LDA LevelNumber
    BEQ +

    ; Only run this routine if the pending macro is the HUD attribute macro
    LDA PendingPpuMacro
    CMP #$0E
    BNE +

    ; Change 0E to 7E to load dungeon hud attributes
    LDA #$7E
    STA PendingPpuMacro

*   INC $13
    RTS

; Modifications to PPU macro pointer table
; ----------------------------------------
; Pointer to below attributes (new overworld attribute macro)
.PATCH 06:A00E
    .DW OverworldAttributeData      ; New overworld map attribute macro
.PATCH 06:A07E
    .DW OriginalHudAttributeMacro   ; Original attribute macro to be used for dungeons



; New attribute data
; ------------------
.PATCH 06:BEF0
OverworldAttributeData:

    ; New data to change map colors
    .DB $23, $C0
    .DB $10
    .DB $C0, $FF, $70, $00, $00, $44, $55, $55, $FF, $FF, $37, $00, $00, $44, $55, $55

    ; This is additional macros from the original data. It needs to be part of the same PPU macro string.
    .DB $20, $6F, $0E, $69, $0B, $6B, $69, $0A, $6B, $24, $24, $2F, $15, $12, $0F, $0E
    .DB $2F, $20, $CF, $06, $6E, $6A, $6D, $6E, $6A, $6D, $20, $8F, $C2, $6C, $20, $91
    .DB $C2, $6C, $20, $92, $C2, $6C, $20, $94, $C2, $6C, $20, $6B, $84, $F7, $24, $F9
    .DB $61, $FF, $29, $84, $09, $12, $17, $1F, $0E, $17, $1D, $18, $1B, $22

    ; Terminator
    .DB $FF


;========================================================
; Save/Load/Delete Hijacks
;========================================================

; Save Hijack
; -----------
;   02:A77A:    JSR $9D2A
.PATCH 02:A77A
    JSR SaveMapData
    SaveHijackReturn = $9D2A


; Load Hijack
; -----------
;   02:A5FE:    JSR $E625
.PATCH 02:A5FE
    JSR LoadMapData
    LoadHijackReturn = $E625


; Delete Map Hijack - Register Name
; ------------------------------------
   ;02:A2C7:  JSR $A764 = File creation hijack
.PATCH 02:A2C7
    JSR DeleteMap_RegisterName


; Delete Map Hijack 2 - Second Quest
; ----------------------------------
   ;02:ABB5:  JMP $AF5A = Second quest hijack
.PATCH 02:ABB5
    JMP DeleteMap_SecondQuest



;========================================================
; Save/Load/Delete routines
;========================================================

; Save map data
; -------------
.PATCH 02:B000
SaveMapData:

    JSR PrepLoadSaveIndexers

*   LDA MapRam,X
    STA MapSaveRam,Y

    DEY
    DEX
    BPL -

    JMP SaveHijackReturn


; Load map data
; -------------
LoadMapData:
    JSR PrepLoadSaveIndexers

*   LDA MapSaveRam,Y
    STA MapRam,X

    DEY
    DEX
    BPL -

    JMP LoadHijackReturn


    ; Delete routines
; ---------------
DeleteMap_RegisterName:
    JSR DeleteMap
    JMP $A764       ; Return from hijack

DeleteMap_SecondQuest:
    JSR DeleteMap
    JMP $AF5A       ; Return from hijack


; Delete map data
; ---------------
DeleteMap:

    LDX #$0F
    LDA #$00

*   STA MapRam,X
    DEX
    BPL -

    RTS


; Common routines
; ---------------
PrepLoadSaveIndexers:
; Sets the Y register to point to the end of the player's map save data (MapSaveRam,Y),
; and sets X to point to the end of map data ram.

    LDY #$0F

    LDX SaveSlot    ; Save slot 1
    BEQ +

    LDY #$1F        ; Save slot 2
    DEX
    BEQ +

    LDY #$2F        ; Save slot 3

*   LDX #$0F

    RTS



;========================================================
; Updating map spot
;========================================================
; Updates a single tile on the map as the player walks around


; Hijack
; ------
.PATCH 05:A8BE
    ;05:A8BE:20 F4 A9  JSR $A9F4
    UpdateMapSpotReturn = $A9F4
    JSR UpdateMapSpot ;$85A0


; Update routine
; --------------
.PATCH 05:85A0 ; 145B0
UpdateMapSpot:
    ;JSR $752F           ; Displaced code

    ; Update map data
    LDA CurrentMapLocation
    AND #$0F            ; Get X-coordinate
    TAX                 ; Used to index into map data

    LSR                 ; Push tile-X onto stack
    PHA

    LDA CurrentMapLocation
    LSR                 ; A /= 16 (get map Y)
    LSR
    LSR
    LSR
    TAY

    LSR
    PHA                 ; Push Tile-Y onto stack

    ; Set bit for y location
    LDA #$01
    CPY #$00
    BEQ ++

*   ASL
    DEY
    BNE -
    *

    ORA MapRam,X
    STA MapRam,X

    ; Pull tile index into registers
    PLA
    TAY
    PLA
    TAX

    JSR UpdateMapTile

    ;RTS
    JMP UpdateMapSpotReturn



; ===========================================================
;  Update map tile
; ===========================================================
;  Processes map data and invokes the rendering routine.
;  Used by "Update map spot" and "draw whole map" code

;PlayerMapData = $7F50
PpuMapMacroBase = $6BCD     ; Map macros
SingleTileMacro = $6BFA     ; Single map tile macro
SingleTileMacroByte = $6BFD

PpuMapMacroLen = $B     ; 11 Bytes: 8 tiles + 3-byte header

MapTiles = $30

.PATCH 05:BE00 ;BC30

UpdateMapTile:
;-------------------------
; A - Unused
; X - Tile X
; Y - Tile Y

    STX mapVar_X
    STY mapVar_Y

    TXA                     ; X = X * 2
    ASL
    TAX

    ; We need to extract four bits out of the player's "explored map data"
    ; and use them as a tile index
    LDA MapRam,X     ; Load map byte
    JSR ProcessMapByte      ; Get relevant two bits
    STA mapVar              ; Store semi-calculated tile value
    STA MapBits_Left

    LDY mapVar_Y

    LDA MapRam + 1,X ; Get next map byte
    JSR ProcessMapByte      ; Get relevant two bits
    STA MapBits_Right


    ; Set flag to update single tile on screen
    LDA #$01
    STA tileFlag

    JSR RenderMapTile

    RTS


ProcessMapByte:
    ; Takes a player-map data byte and gets the relevant two bits out of it

    ; A - Map byte
    ; Y - Map Tile Y
    ; Return via A

    ; A = A >> (Y * 2) | 3
    CPY #$00                ; While Y != 0
    BEQ ++
*   LSR                     ;   A >> 2
    LSR
    DEY                     ;   Y--
    BNE -

*   AND #$03                ; A

    RTS




; ===========================================================
;  Draw whole map
; ===========================================================

DrawWholeMap:

    ; Prepare PPU to write map data
    LDA $2002
    LDA #>VRAM_MapTiles ; Set PPU address
    STA $2006
    LDA #<VRAM_MapTiles
    STA $2006


    LDA #$00                    ; Loop over Y
    STA mapLoop_Y
    *   LDA #$00                ;   Loop over X
        STA mapLoop_X

        *   LDX mapLoop_X       ;       Render one map tile
            LDY mapLoop_Y
            JSR UpdateMapTile

            ;TYA
            ;PHA
            TXA                 ;       Send to PPU (preserve registers)
            PHA
            JSR SendTileToPPU
            PLA
            TAX
            ;PLA
            ;TAY


            INC mapLoop_X
            LDA mapLoop_X
            CMP #$08
        BNE -

        INC mapLoop_Y
        LDA mapLoop_Y
        CMP #$04
    BNE --

    RTS

    SendTileToPPU:
    LDX #$00
*   LDA MapTileMacro+3,X    ; Load tile data byte
    STA $2007               ; Write to PPU
    INX
    CPX #$10
    BNE -

    RTS


; ===========================================================
;  Map tile rendering
; ===========================================================

RenderMapTile:
; Parameters
;   - mapVar_X :     Tile X
;   - mapVar_Y :     Tile Y
;   - mapBits_Left:  Bit-0 = TL screen discovered, Bit-1 = BL screen discovered
;   - mapBits_Right: Bit-0 = TR screen discovered, Bit-1 = BR  screen discovered


    ; Preserve zp variables
    LDA $00
    PHA
    LDA $01
    PHA

    ; Calculate the source address of tile data, to copy to macro
    ; and the PPU dest address to write to the macro.
    ;
    ; Address = BaseAddress + tileX * $10 + tileY * $80

    ; Y = tileY / 2
    ; Set x to low byte of pointer (will be 00 or 80)
    LDX #$00        ; Low byte of src/dest pointers
    LDA mapVar_Y
    LSR
    TAY
    BCC +           ; If carry was set (Y was odd), add 80 to low byte of pointers
    LDX #$80

*   STX $00         ; Write low byte of pointer

    LDA mapVar_X    ; Add mapVar_X * #$10 to $00
    ASL
    ASL
    ASL
    ASL
    CLC
    ADC $00

    ; Write low byte of ROM source and PPU dest (low byte will be same on both)
    STA $00
    STA MapTileMacro + 1

    ; Calculate high byte of src pointer
    TYA
    ADC #$BC
    STA $01

    ; Calculate high byte of dest pointer
    TYA
    ADC #$13
    STA MapTileMacro

    ; Write macro-length
    LDA #$10
    STA MapTileMacro + 2



    ; Run this code twice to create two bit filters (to be ANDed) for tile data, one for top half, one for bottom
    ; This "blacks out" map areas that have not been visited.
    LDY #$00
MapBitLoop:
        LDA #$FF
        LSR MapBits_Left    ; Grab low bit (for top-left or bottom-left)
        BCS +
        AND #$0F            ; If clear, AND out high nibble

    *   LSR MapBits_Right   ; Grab low bit (for top-right or bottom-right)
        BCS +
        AND #$F0            ; If clear, AND out low nibble
    *   STA MapFilter_Top,Y
    INY
    CPY #$02
    BNE MapBitLoop



    ; Copy 10 bytes of tile data
    ; We use four loops:
    ;   -Top half, first plane
    ;   -Bottom half, first plane
    ;   -Top half, second plane
    ;   -Bottom half, second plane
    LDY #$03
    *   LDA ($00),Y
        AND MapFilter_Top
        STA MapTileMacro + 3,Y

        DEY
        BPL -
    LDY #$07
    *   LDA ($00),Y
        AND MapFilter_Bottom
        STA MapTileMacro + 3,Y

        DEY
        CPY #$03
        BNE -
    LDY #$0B
    *   LDA ($00),Y
        AND MapFilter_Top
        STA MapTileMacro + 3,Y

        DEY
        CPY #$07
        BNE -
    LDY #$0F
    *   LDA ($00),Y
        AND MapFilter_Bottom
        STA MapTileMacro + 3,Y

        DEY
        CPY #$0B
        BNE -

    ; Write terminator to end of macro
    LDA #$FF
    STA MapTileMacro + $13

    ; Restore zero-page
    PLA
    STA $01
    PLA
    STA $00

    RTS


; ===========================================================
;  Draw whole map -HIJACK-
; ===========================================================

; Original code
; -------------
;       Displaced code is called at end of DoWholeMapHijack routine
;        -06:8089:E6 11     INC $0011 = #$00
;         06:808B:60        RTS


; Hijack
; ------
.PATCH 06:8089
;    JMP DoWholeMapHijack
    JMP SetupMapHijack

.PATCH 06:9380
SetupMapHijack:

    LDA LevelNumber ; Only run this routine for the overworld
    BEQ DoJump
    INC $11
    RTS

DoJump:
    JMP DoWholeMapHijack

; Hijack code
; -----------
; This routine must go in the fixed bank because bank-swapping is
; needed to run the desired code.

.PATCH  07:FFC0
DoWholeMapHijack:

;    LDA LevelNumber ; Only run this routine for the overworld
;    BNE Exit

    ; Load bank 5
    LDA #$05        ; The code we want to run is in a different bank than is currently loaded
    JSR BankSwap

    JSR DrawWholeMap

    ; Load bank 6
    LDA #$06        ; This is the bank that was previously loaded
    JSR BankSwap

Exit:
    ; Displaced code
    INC $11
    RTS


; Safe blip update
; ----------------
;
; This code really  belongs under the "Map blip blinking" section, but is placed with DoWholeMapHijack, because
; they need to be placed together in the tiny bit of free space in the fixed bank.

.PATCH 07:FFD0
SafeBlipUpdate:
; Only runs the blip-flashing code when it is banked in.

    PHA         ; Need to preserve A
    LDA $8000
    CMP #$20    ; Is this bank 5? (checking for a known value)

    BNE +

    PLA
    JMP BlipUpdate

*   PLA
    JMP $77E7


; ===========================================================
;  PPU Transfers
; ===========================================================
;WholeMapMacro = $6BCD


; PPU update hijack
; -----------------
;       07:E4C1:      JSR $A080
.Patch 07:E4C1
    JSR $9D70

; PPU Trasnfer
; ------------
.PATCH 06:9D70

    ; Call displaced code
    JSR $A080

    lda LevelNumber         ; If we aren't in overworld, clear flag and return
    bne ClearAndReturn

    ; this bit is from the old automap (without an actual image of overworld)
    ldx tileFlag
    beq return              ; If there is no pending tile, return
;    dex
;    beq UpdateOneTile       ; A value of 1 indicates one tile will be updated
;    dex
;    beq UpdateAllTiles      ; A value of 2 indicates whole map will be updated
;    rts                     ; Invalid value

UpdateOneTile:
    lda #<MapTileMacro
    sta $00
    lda #>MapTileMacro
    sta $01
    JSR SendPpuMacro

ClearAndReturn:
    ;lda #$00        ; Clear tile flag
    ;sta TileFlag

    return:
    RTS

; from old map
;UpdateAllTiles:
;    lda #<WholeMapMacro
;    sta $00
;    lda #>WholeMapMacro
;    sta $01
;    JSR SendPpuMacro
;
;    JMP ClearAndReturn



; ===========================================================
;  Fast life fill
; ===========================================================
; Causes life to fill faster with potion/fairy

; ORIGINAL CODE
;   05:B1EF   LDA $0670             ; If current heart > #$F8 (out of #$100):
;   05:B1F2   CMP #$F8              ;
;   05:B1F4   BCS $B1FD             ;   Jump to routine to set current heart to 0 and increment full-heart count
;
;   05:B1F6   CLC                   ; Add #$06 to current heart value (out of #$100), and return
;   05:B1F7   ADC #$06              ;
;   05:B1F9   STA $0670             ;
;   05:B1FC   RTS                   ;


;.ORG $B1EF
;.PATCH $171FF
.PATCH 05:B1EF
    LDA $0670
    CMP #$D7              ;
    BCS $B1FD             ;   Jump to routine to set current heart to 0 and increment full-heart count

    CLC                   ; Add #$06 to current heart value (out of #$100), and return
    ADC #$18              ;
    STA $0670             ;
    RTS                   ;
