#include <string.h>
#include <dos.h>

#define rgb(r,g,b) ((b) + (g)*6 + (r)*36)
static const int origmap256[16] =
{
    rgb(0,0,0),  rgb(0,0,3),  rgb(0,3,0),  rgb(0,3,3),
    rgb(3,0,0),  rgb(3,0,3),  rgb(3,2,0),  rgb(3,3,3),
    rgb(2,2,2),  rgb(2,2,5),  rgb(2,5,2),  rgb(2,5,5),
    rgb(5,2,2),  rgb(5,2,5),  rgb(5,5,2),  rgb(5,5,5)
};
static int map256[16];
int Find256Color(int color)
{
    if(color < 16)
    {
        if(!(map256[color] & 0x8000U)) return color;
        color = origmap256[color];
    }
    else
    {
        color -= 16;
    }
    int b = color % 6;
    int g = (color / 6) % 6;
    int r = (color / 36) % 6;

    int bestindex = 15, bestscore = 32767;
    for(int c=0; c<16; ++c)
    {
        int m = map256[c] & 0x7FFF;
        if(m == color) return c;
        int bdiff = b - (m % 6);
        int gdiff = g - ((m/6) % 6);
        int rdiff = r - ((m/36) % 6);
        int score = bdiff*bdiff + gdiff*gdiff + rdiff*rdiff;
        if(!(map256[c] & 0x8000)) { int tmp = 16-c; if(score > tmp) score = tmp; }
        if(score < bestscore) { bestscore = score; bestindex = c; }
    }
    outportb(0x3C8, bestindex + (bestindex&8)*6);
    outportb(0x3C9, r*63/5);
    outportb(0x3C9, g*63/5);
    outportb(0x3C9, b*63/5);
    map256[bestindex] = color | 0x8000u;
    return bestindex;
}
void Reset256Color()
{
    memcpy(map256, origmap256, sizeof(map256));
    for(int c=0; c<16; ++c)
    {
        int m = origmap256[c];
        map256[c] = m;
        int b = m % 6, g = (m/6) % 6, r = (m/36) % 6;
        outportb(0x3C8, c + (c&8)*6);
        outportb(0x3C9, r*63/5);
        outportb(0x3C9, g*63/5);
        outportb(0x3C9, b*63/5);
    }
}
#undef rgb
