#include "defs.h"
#include "forkpty.h"

void ForkPTY::Open()
{
    //fd=1; return;
    _asm {
      mov ax, 0x5300
      mov cx, Rows
      mov dx, Columns
      int 0x21
      les bp, this     /* Note: BC will push&pop BP around this function */
      mov es:[bp], bx    /* Save fd */
      mov es:[bp+2], cx  /* Save pid */
    }
}
void ForkPTY::Close()
{
    //fd=-1; return;
    _asm {
        les bx, this
        push bx
         mov ax, 0x5301
         mov cx, es:[bx+2] /* pid */
         mov bx, es:[bx]   /* fd */
         int 0x21
        pop bx
        mov ax,-1 ; mov es:[bx], ax
    }
}
void ForkPTY::Send(const void _far* buffer, unsigned _far& nwrite, unsigned _far& error)
{
    //error=0; return;
    _asm {
       les bx, nwrite ; mov cx, es:[bx] /* nwrite */
       les bx, this   ; mov bx, es:[bx] /* fd */
       push ds
        mov ax, 0x5302
        lds dx, buffer
        int 0x21
       pop ds
       les bx, nwrite ; mov es:[bx], cx /* store to nwrite */
       les bx, error  ; mov es:[bx], dx /* store to error */
    }
}
void ForkPTY::Recv(void _far* buffer, unsigned _far& nread, unsigned _far& error)
{
    //nread=0;error=0; return;
    _asm {
       les bx, nread  ; mov cx, es:[bx] /* nread */
       les bx, this   ; mov bx, es:[bx] /* fd    */
       push ds
        mov ax, 0x5303
        lds dx, buffer
        int 0x21
       pop ds
       les bx, nread  ; mov es:[bx], cx /* store to nread */
       les bx, error  ; mov es:[bx], dx /* store to error */
    }
}
