/*
INT 21
 OPEN A NEW TERMINAL
     in:
      AX = 5300
      CX = rows
      DX = columns
     out:
      BX = fd
      CX = pid
 CLOSE TERMINAL
     in:
      AX = 5301
      BX = fd
      CX = pid
 WRITE STRING (NON-BLOCKING)
     in:
      AX = 5302
      BX = fd
      DS:DX = string address
      CX = string length
     out:
      CX = number of bytes written
 READ STRING (NON-BLOCKING)
     in:
      AX = 5303
      BX = fd
      DS:DX = target address
      CX = buffer capacity
     out:
      CX = number of bytes read
      DX = error code (or zero if CX != 0xFFFF)
 SEND A RESIZE EVENT
     in:
      AX = 5304
      BX = fd
      CX = rows
      DX = columns
*/
class ForkPTY
{
public:
    ForkPTY()  { Open(); }
    ~ForkPTY() { if(Active()) Close(); }
    void Open();
    void Close();
    inline int Active() const { return fd >= 0; }
    void Send(const void _far* buffer, unsigned _far& nwrite, unsigned _far& error);
    void Recv(void _far* buffer, unsigned _far& nread, unsigned _far& error);
private:
    int fd, pid;
};
