#include <dos.h>
#include <string.h>

#include "keyboard.h"
#include "defs.h"

extern void BeepOn();

const unsigned char _near Translate[8][256] =
{
    { // LATIN1
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0xFF,0xAD,0xBD,0x9C,0xCF,0xBE,0xDD,0xF5,0xF9,0xB8,0xA6,0xAE,0xAA,0xF0,0xA9,0xEE,
0xF8,0xF1,0xFD,0xFC,0xEF,0xE6,0xF4,0xFA,0xF7,0xFB,0xA7,0xAF,0xAC,0xAB,0xF3,0xA8,
0xB7,0xB5,0xB6,0xC7,0x8E,0x8F,0x92,0x80,0xD4,0x90,0xD2,0xD3,0xDE,0xD6,0xD7,0xD8,
0xD1,0xA5,0xE3,0xE0,0xE2,0xE5,0x99,0x9E,0x9D,0xEB,0xE9,0xEA,0x9A,0xED,0xE8,0xE1,
0x85,0xA0,0x83,0xC6,0x84,0x86,0x91,0x87,0x8A,0x82,0x88,0x89,0x8D,0xA1,0x8C,0x8B,
0xD0,0xA4,0x95,0xA2,0x93,0xE4,0x94,0xF6,0x9B,0x97,0xA3,0x96,0x81,0xEC,0xE7,0x98
    },

    { // GRAF
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  255,4,177, 9,12,13,10,248,241,10,11, 217,191,218,192,197, 238,238,196,95,95,
  195,180,193,194,179, 243, 242, 227, 156, 250,                            0x7F,
0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0xFF,0xAD,0xBD,0x9C,0xCF,0xBE,0xDD,0xF5,0xF9,0xB8,0xA6,0xAE,0xAA,0xF0,0xA9,0xEE,
0xF8,0xF1,0xFD,0xFC,0xEF,0xE6,0xF4,0xFA,0xF7,0xFB,0xA7,0xAF,0xAC,0xAB,0xF3,0xA8,
0xB7,0xB5,0xB6,0xC7,0x8E,0x8F,0x92,0x80,0xD4,0x90,0xD2,0xD3,0xDE,0xD6,0xD7,0xD8,
0xD1,0xA5,0xE3,0xE0,0xE2,0xE5,0x99,0x9E,0x9D,0xEB,0xE9,0xEA,0x9A,0xED,0xE8,0xE1,
0x85,0xA0,0x83,0xC6,0x84,0x86,0x91,0x87,0x8A,0x82,0x88,0x89,0x8D,0xA1,0x8C,0x8B,
0xD0,0xA4,0x95,0xA2,0x93,0xE4,0x94,0xF6,0x9B,0x97,0xA3,0x96,0x81,0xEC,0xE7,0x98
    },

    { // CP437
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF
    },

    { // USER
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0xBD,0x9C,0xBE,0x3F,0x9F,
0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0x3F,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
0xB0,0xB1,0xB2,0xB3,0xB4,0x3F,0x3F,0x3F,0x3F,0xB9,0xBA,0xBB,0xBC,0x3F,0x3F,0xBF,
0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0x3F,0x3F,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0x3F,
0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD9,0xDA,0xDB,0xDC,0x3F,0x3F,0xDF,
0x3F,0xE1,0x3F,0x3F,0x3F,0x3F,0xE6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0x3F,0xF1,0x3E,0x3C,0x3F,0x3F,0xF6,0x3F,0xF8,0xFA,0xFA,0x3F,0x3F,0xFD,0xFE,0xFF
    }
};

unsigned char HeldKeys[128] = { 0 };
int HeldShifts[NR_SHIFT]    = { 0 };
int ShiftMap = 0, CapsLock = 0, NumLock = 0, HitAltTab = 0, ExtendedKey = 0;

static IntVecType OldI09;

/* Keyboard IRQ handler -- receive information about console user's keyboard actions */
static void _far interrupt NewI09()
{
    inportb(0x60);
    int c = inportb(0x60);
    if(c == 0xE0) ExtendedKey = 1;
    else if(c == 0xFD) BeepOn(); // error
    else if(c == 0xFF) BeepOn(); // illegal combination
    else if(c == 0xE1) AddBuffer("\33[P"); // pause
    else if(c == 0xFA) {} // ack
    else if(c == 0xFE) {} // resend request
    else
    {
        int scancode = c & 127, hold = !(c & 0x80), once = hold;
        if(hold && HeldKeys[scancode]) once = 0; // hold&&!once = autorepeat
        HeldKeys[scancode] = hold;

        if(hold && scancode == 0x0F && (ShiftMap & 12))
        {
            HitAltTab = 1;
            scancode = 0;
        }

        /* This state machine converts the keypresses into Linux console input
         * bytestream. For the most part it comes straight from Linux kernel sources.
         */
        const u_short* map = key_maps[ShiftMap];
        u_short item = map[scancode];
        if(KTYP(item) == KT_LATIN && CapsLock)
            item = key_maps[ShiftMap^1][scancode];

        switch(KTYP(item))
        {
            case KT_SHIFT:
            {
                int val = KVAL(item);
                if(val == KG_ALT && ExtendedKey) val = KG_ALTGR;
                HeldShifts[val] = hold;
                ShiftMap = 0;
                if(HeldShifts[KG_SHIFT]
                || HeldShifts[KG_SHIFTL] || HeldShifts[KG_SHIFTR]) ShiftMap += 1;
                if(HeldShifts[KG_ALTGR]) ShiftMap += 2;
                if(HeldShifts[KG_CTRL]
                || HeldShifts[KG_CTRLL] || HeldShifts[KG_CTRLR]) ShiftMap += 4;
                if(HeldShifts[KG_ALT]) ShiftMap += 8;
                break;
            }
            case KT_LETTER: case KT_LATIN: case KT_META:
                if(hold)
                {
                    if(KTYP(item) == KT_META)
                        AddBuffer( '\x1B' ); // esc
                    AddBuffer( (char) KVAL(item) );
                }
                break;
            case KT_FN:
                if(hold) AddBuffer(func_table[ KVAL(item) ]);
                break;
            case KT_SPEC:
                switch(KVAL(item))
                {
                    case 1: if(hold) AddBuffer( '\x0D' ); break; // enter
                    case 7: if(once) CapsLock = !CapsLock; break; // caps
                    case 8: if(once) NumLock = !NumLock; break; // num
                    case 9: break; // scroll
                }
                break;
            case KT_PAD:
                if(hold) switch(KVAL(item))
                {
                    case 0: if(NumLock && !ExtendedKey) AddBuffer('0'); else AddBuffer("[2~"); break;
                    case 1: if(NumLock && !ExtendedKey) AddBuffer('1'); else AddBuffer("[F"); break;
                    case 2: if(NumLock && !ExtendedKey) AddBuffer('2'); else AddBuffer("[B"); break;
                    case 3: if(NumLock && !ExtendedKey) AddBuffer('3'); else AddBuffer("[6~"); break;
                    case 4: if(NumLock && !ExtendedKey) AddBuffer('4'); else AddBuffer("[D"); break;
                    case 5: if(NumLock && !ExtendedKey) AddBuffer('5'); else AddBuffer("[E"); break;
                    case 6: if(NumLock && !ExtendedKey) AddBuffer('6'); else AddBuffer("[C"); break;
                    case 7: if(NumLock && !ExtendedKey) AddBuffer('7'); else AddBuffer("[H"); break;
                    case 8: if(NumLock && !ExtendedKey) AddBuffer('8'); else AddBuffer("[A"); break;
                    case 9: if(NumLock && !ExtendedKey) AddBuffer('9'); else AddBuffer("[5~"); break;
                    case 10: AddBuffer('+'); break;
                    case 11: AddBuffer('-'); break;
                    case 12: AddBuffer('*'); break;
                    case 13: AddBuffer('/'); break;
                    case 14: AddBuffer('\x0D'); break;
                    case 15:
                    case 16: if(NumLock) AddBuffer(','); else AddBuffer("[3~"); break;
                }
                break;
        }
        ExtendedKey = 0;
    }
    outportb(0x20, 0x20);
}

Keyboard keyboard;

void Keyboard::Install()
{
    NoIRQcontext ctx;
    OldI09 = ((IntVecType _far*)0)[9];
    ((IntVecType _far*)0)[9] = NewI09;
    memset(HeldKeys, 0, sizeof(HeldKeys));
    memset(HeldShifts, 0, sizeof(HeldShifts));
    ShiftMap = CapsLock = NumLock = HitAltTab = ExtendedKey = 0;
}

void Keyboard::Uninstall()
{
    NoIRQcontext ctx;
    ((IntVecType _far*)0)[9] = OldI09;
    *(short _far*)0x00400017UL = 0; // Clear capslock&shift etc. status
}
