#include "keymap.h"

static const u_short plain_map[] = {
	0x200,	0x01b,	0x031,	0x032,	0x033,	0x034,	0x035,	0x036,
	0x037,	0x038,	0x039,	0x030,	0x02b,	0x401,	0x07f,	0x009,
	0xb71,	0xb77,	0xb65,	0xb72,	0xb74,	0xb79,	0xb75,	0xb69,
	0xb6f,	0xb70,	0xbe5,	0x404,	0x201,	0x702,	0xb61,	0xb73,
	0xb64,	0xb66,	0xb67,	0xb68,	0xb6a,	0xb6b,	0xb6c,	0xbf6,
	0xbe4,	0x0a7,	0x700,	0x027,	0xb7a,	0xb78,	0xb63,	0xb76,
	0xb62,	0xb6e,	0xb6d,	0x02c,	0x02e,	0x02d,	0x700,	0x30c,
	0x703,	0x020,	0x207,	0x100,	0x101,	0x102,	0x103,	0x104,
	0x105,	0x106,	0x107,	0x108,	0x109,	0x208,	0x209,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x03c,	0x10a,
	0x10b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short shift_map[] = {
	0x200,	0x01b,	0x021,	0x022,	0x023,	0x024,	0x025,	0x026,
	0x02f,	0x028,	0x029,	0x03d,	0x03f,	0x400,	0x07f,	0x009,
	0xb51,	0xb57,	0xb45,	0xb52,	0xb54,	0xb59,	0xb55,	0xb49,
	0xb4f,	0xb50,	0xbc5,	0x402,	0x201,	0x702,	0xb41,	0xb53,
	0xb44,	0xb46,	0xb47,	0xb48,	0xb4a,	0xb4b,	0xb4c,	0xbd6,
	0xbc4,	0x0bd,	0x700,	0x02a,	0xb5a,	0xb58,	0xb43,	0xb56,
	0xb42,	0xb4e,	0xb4d,	0x03b,	0x03a,	0x05f,	0x700,	0x30c,
	0x703,	0x020,	0x207,	0x10c,	0x10d,	0x10e,	0x10f,	0x110,
	0x111,	0x112,	0x113,	0x11e,	0x11f,	0x208,	0x203,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x03e,	0x120,
	0x121,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x20b,	0x601,	0x602,	0x117,	0x600,	0x20a,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short altgr_map[] = {
	0x200,	0x01b,	0x200,	0x040,	0x0a3,	0x024,	0x200,	0x200,
	0x07b,	0x05b,	0x05d,	0x07d,	0x05c,	0x200,	0x07f,	0x009,
	0xb71,	0xb77,	0x0a4,	0xb72,	0xb74,	0xb79,	0xb75,	0xb69,
	0xb6f,	0xb70,	0x200,	0x403,	0x201,	0x702,	0x914,	0xb73,
	0x917,	0x919,	0xb67,	0xb68,	0xb6a,	0xb6b,	0xb6c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0xb7a,	0xb78,	0x0a2,	0xb76,
	0x915,	0xb6e,	0xb6d,	0x200,	0x200,	0x200,	0x700,	0x916,
	0x703,	0x020,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x914,	0x202,	0x911,
	0x912,	0x913,	0x917,	0x90e,	0x90f,	0x910,	0x918,	0x90b,
	0x90c,	0x90d,	0x90a,	0x30f,	0x206,	0x200,	0x07c,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x919,	0x702,	0x915,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short ctrl_map[] = {
	0x200,	0x01b,	0x200,	0x000,	0x01b,	0x01c,	0x01d,	0x01e,
	0x01f,	0x07f,	0x200,	0x200,	0x01f,	0x200,	0x07f,	0x009,
	0x011,	0x017,	0x005,	0x012,	0x014,	0x019,	0x015,	0x009,
	0x00f,	0x010,	0x01b,	0x01d,	0x201,	0x702,	0x001,	0x013,
	0x004,	0x006,	0x007,	0x008,	0x00a,	0x00b,	0x00c,	0x200,
	0x200,	0x000,	0x700,	0x01c,	0x01a,	0x018,	0x003,	0x016,
	0x002,	0x00e,	0x00d,	0x200,	0x200,	0x01f,	0x700,	0x30c,
	0x703,	0x000,	0x207,	0x122,	0x123,	0x124,	0x125,	0x126,
	0x127,	0x128,	0x129,	0x12a,	0x12b,	0x208,	0x204,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x200,	0x12c,
	0x12d,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x01c,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short shift_ctrl_map[] = {
	0x200,	0x01b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x07f,	0x009,
	0x011,	0x017,	0x005,	0x012,	0x014,	0x019,	0x015,	0x009,
	0x00f,	0x010,	0x200,	0x01e,	0x201,	0x702,	0x001,	0x013,
	0x004,	0x006,	0x007,	0x008,	0x00a,	0x00b,	0x00c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0x01a,	0x018,	0x003,	0x016,
	0x002,	0x00e,	0x00d,	0x200,	0x200,	0x01f,	0x700,	0x30c,
	0x703,	0x020,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short altgr_ctrl_map[] = {
	0x200,	0x01b,	0x200,	0x000,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x01b,	0x01d,	0x200,	0x01c,	0x200,	0x07f,	0x009,
	0x011,	0x017,	0x005,	0x012,	0x014,	0x019,	0x015,	0x009,
	0x00f,	0x010,	0x200,	0x200,	0x201,	0x702,	0x001,	0x013,
	0x004,	0x006,	0x007,	0x008,	0x00a,	0x00b,	0x00c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0x01a,	0x018,	0x003,	0x016,
	0x002,	0x00e,	0x00d,	0x200,	0x200,	0x200,	0x700,	0x30c,
	0x703,	0x020,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x20c,	0x206,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x20c,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short alt_map[] = {
	0x200,	0x81b,	0x831,	0x832,	0x833,	0x834,	0x835,	0x836,
	0x837,	0x838,	0x839,	0x830,	0x82b,	0x83d,	0x87f,	0x809,
	0x871,	0x877,	0x865,	0x872,	0x874,	0x879,	0x875,	0x869,
	0x86f,	0x870,	0x85b,	0x85d,	0x80d,	0x702,	0x861,	0x873,
	0x864,	0x866,	0x867,	0x868,	0x86a,	0x86b,	0x86c,	0x83b,
	0x827,	0x860,	0x700,	0x827,	0x87a,	0x878,	0x863,	0x876,
	0x862,	0x86e,	0x86d,	0x82c,	0x82e,	0x82d,	0x700,	0x30c,
	0x703,	0x820,	0x207,	0x500,	0x501,	0x502,	0x503,	0x504,
	0x505,	0x506,	0x507,	0x508,	0x509,	0x208,	0x209,	0x907,
	0x908,	0x909,	0x30b,	0x904,	0x905,	0x906,	0x30a,	0x901,
	0x902,	0x903,	0x900,	0x30f,	0x206,	0x200,	0x83c,	0x50a,
	0x50b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x01c,	0x701,	0x205,	0x114,	0x212,
	0x118,	0x210,	0x211,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short shift_alt_map[] = {
	0x200,	0x81b,	0x821,	0x822,	0x823,	0x824,	0x825,	0x826,
	0x82f,	0x828,	0x829,	0x83d,	0x83f,	0x860,	0x87f,	0x809,
	0x851,	0x857,	0x845,	0x852,	0x854,	0x859,	0x855,	0x849,
	0x84f,	0x850,	0x200,	0x85e,	0x201,	0x702,	0x841,	0x853,
	0x844,	0x846,	0x847,	0x848,	0x84a,	0x84b,	0x84c,	0x200,
	0x200,	0x200,	0x700,	0x82a,	0x85a,	0x858,	0x843,	0x856,
	0x842,	0x84e,	0x84d,	0x83b,	0x83a,	0x85f,	0x700,	0x30c,
	0x703,	0x820,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x83e,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short altgr_alt_map[] = {
	0x200,	0x81b,	0x200,	0x840,	0x200,	0x824,	0x200,	0x200,
	0x87b,	0x85b,	0x85d,	0x87d,	0x85c,	0x200,	0x87f,	0x809,
	0x871,	0x877,	0x865,	0x872,	0x874,	0x879,	0x875,	0x869,
	0x86f,	0x870,	0x200,	0x87e,	0x201,	0x702,	0x861,	0x873,
	0x864,	0x866,	0x867,	0x868,	0x86a,	0x86b,	0x86c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0x87a,	0x878,	0x863,	0x876,
	0x862,	0x86e,	0x86d,	0x200,	0x200,	0x200,	0x700,	0x30c,
	0x703,	0x820,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x87c,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short ctrl_alt_map[] = {
	0x200,	0x81b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x87f,	0x809,
	0x811,	0x817,	0x805,	0x812,	0x814,	0x819,	0x815,	0x809,
	0x80f,	0x810,	0x200,	0x200,	0x201,	0x702,	0x801,	0x813,
	0x804,	0x806,	0x807,	0x808,	0x80a,	0x80b,	0x80c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0x81a,	0x818,	0x803,	0x816,
	0x802,	0x80e,	0x80d,	0x200,	0x200,	0x200,	0x700,	0x30c,
	0x703,	0x800,	0x207,	0x500,	0x501,	0x502,	0x503,	0x504,
	0x505,	0x506,	0x507,	0x508,	0x509,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x20c,	0x206,	0x200,	0x200,	0x50a,
	0x50b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x81c,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x20c,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short shift_ctrl_alt_map[] = {
	0x200,	0x81b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x87f,	0x809,
	0x811,	0x817,	0x805,	0x812,	0x814,	0x819,	0x815,	0x809,
	0x80f,	0x810,	0x200,	0x200,	0x201,	0x702,	0x801,	0x813,
	0x804,	0x806,	0x807,	0x808,	0x80a,	0x80b,	0x80c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0x81a,	0x818,	0x803,	0x816,
	0x802,	0x80e,	0x80d,	0x200,	0x200,	0x81f,	0x700,	0x30c,
	0x703,	0x820,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

static const u_short altgr_ctrl_alt_map[] = {
	0x200,	0x81b,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x87f,	0x809,
	0x811,	0x817,	0x805,	0x812,	0x814,	0x819,	0x815,	0x809,
	0x80f,	0x810,	0x200,	0x200,	0x201,	0x702,	0x801,	0x813,
	0x804,	0x806,	0x807,	0x808,	0x80a,	0x80b,	0x80c,	0x200,
	0x200,	0x200,	0x700,	0x200,	0x81a,	0x818,	0x803,	0x816,
	0x802,	0x80e,	0x80d,	0x200,	0x200,	0x200,	0x700,	0x30c,
	0x703,	0x820,	0x207,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x208,	0x200,	0x307,
	0x308,	0x309,	0x30b,	0x304,	0x305,	0x306,	0x30a,	0x301,
	0x302,	0x303,	0x300,	0x30f,	0x206,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x30e,	0x702,	0x30d,	0x200,	0x701,	0x205,	0x114,	0x603,
	0x118,	0x601,	0x602,	0x117,	0x600,	0x119,	0x115,	0x116,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x11d,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,	0x200,
};

const u_short *key_maps[4*4] = {
	plain_map, shift_map, altgr_map, altgr_map,
	ctrl_map, shift_ctrl_map, altgr_ctrl_map, altgr_ctrl_map,
	alt_map, shift_alt_map, altgr_alt_map, altgr_alt_map,
	ctrl_alt_map, shift_ctrl_alt_map, altgr_ctrl_alt_map, altgr_ctrl_alt_map
};

//static const unsigned int keymap_count = 12;

/*
 * Philosophy: most people do not define more strings, but they who do
 * often want quite a lot of string space. So, we statically allocate
 * the default and allocate dynamically in chunks of 512 bytes.
 */

static const char func_buf[] = {
	'\033', '[', '[', 'A', 0,
	'\033', '[', '[', 'B', 0,
	'\033', '[', '[', 'C', 0,
	'\033', '[', '[', 'D', 0,
	'\033', '[', '[', 'E', 0,
	'\033', '[', '1', '7', '~', 0,
	'\033', '[', '1', '8', '~', 0,
	'\033', '[', '1', '9', '~', 0,
	'\033', '[', '2', '0', '~', 0,
	'\033', '[', '2', '1', '~', 0,
	'\033', '[', '2', '3', '~', 0,
	'\033', '[', '2', '4', '~', 0,
	'\033', '[', '2', '5', '~', 0,
	'\033', '[', '2', '6', '~', 0,
	'\033', '[', '2', '8', '~', 0,
	'\033', '[', '2', '9', '~', 0,
	'\033', '[', '3', '1', '~', 0,
	'\033', '[', '3', '2', '~', 0,
	'\033', '[', '3', '3', '~', 0,
	'\033', '[', '3', '4', '~', 0,
	'\033', '[', '1', '~', 0,
	'\033', '[', '2', '~', 0,
	'\033', '[', '3', '~', 0,
	'\033', '[', '4', '~', 0,
	'\033', '[', '5', '~', 0,
	'\033', '[', '6', '~', 0,
	'\033', '[', 'M', 0,
	'\033', '[', 'P', 0
};

//static const char *funcbufptr = func_buf;
//static const int funcbufsize = sizeof(func_buf);
//static const int funcbufleft = 0;          /* space left */

const char *func_table[] = {
	func_buf + 0,
	func_buf + 5,
	func_buf + 10,
	func_buf + 15,
	func_buf + 20,
	func_buf + 25,
	func_buf + 31,
	func_buf + 37,
	func_buf + 43,
	func_buf + 49,
	func_buf + 55,
	func_buf + 61,
	func_buf + 67,
	func_buf + 73,
	func_buf + 79,
	func_buf + 85,
	func_buf + 91,
	func_buf + 97,
	func_buf + 103,
	func_buf + 109,
	func_buf + 115,
	func_buf + 120,
	func_buf + 125,
	func_buf + 130,
	func_buf + 135,
	func_buf + 140,
	func_buf + 145,
	0,
	0,
	func_buf + 149,
	0
};
