#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <math.h>

#include "forkpty.h"
#include "cpu.h"

#include "terminal.h"
#include "keyboard.h"
#include "beeper.h"

static termwindow* cur_terminal = NULL;

void AddBuffer(char value)
{
    if(cur_terminal)
        cur_terminal->EchoBack((const char*)&value, 1);
}
void AddBuffer(const char* zstring)
{
    if(cur_terminal)
        cur_terminal->EchoBack(zstring, strlen(zstring));
}

static void SetScanlineCount(unsigned n)
{
    /**/
    unsigned hibit = ((n-1) & 0xFF) << 8;
    outport(0x3D4, 0x2E11);
    //outport(0x3D4, hibit | 0x06);
    outport(0x3D4, hibit | 0x12);
    outport(0x3D4, hibit | 0x15);
    outport(0x3D4, 0xAE11);
    //Default parameters for 80x50 mode listed below:
    // 6 = vertical total          -- 0xBF (8 bits, 9th is at @7 bit 5)
    // 9 = maximum scan line       -- 0x47 (5 bits = per row)
    //10 = vertical retrace start  -- 0x9C (8 bits; 9th is at @7 bit 7)
    //11 = vertical retrace end    -- 0x8E (low 4 bits)
    //12 = vertical display end    -- 0x8F (8 bits, 9th is at @7 bit 6)
    //15 = start vertical blank    -- 0x8F (8 bits, 9th is at @7 bit 3)
    //16 = end vertical blank      -- 0x8E (7 bits)
    /*
    outportb(0x3D4, 6); int val6 = inportb(0x3D5);
    outportb(0x3D4, 9); int val9 =inportb(0x3D5);
    outportb(0x3D4,0x10); int val10= inportb(0x3D5);
    outportb(0x3D4,0x11); int val11 = inportb(0x3D5);
    outportb(0x3D4,0x12); int val12 = inportb(0x3D5);
    outportb(0x3D4,0x15); int val15 = inportb(0x3D5);
    outportb(0x3D4,0x16); int val16 = inportb(0x3D5);
    fprintf(stderr, "6=%X, 9=%X, 10=%X, 11=%X, 12=%X, 15=%X, 16=%X\n",
                    val6,val9,val10,val11,val12);
    exit(0);
    */
}

static void ReprogramVideo()
{
    const unsigned n_extralines = 1;
    _asm { mov ax,3; int 0x10 }                 // set text mode
    _asm { mov ax,0x1112; xor bx,bx; int 0x10 } // select 8x8 rom font
    _asm { mov ah,1; mov cx,0x0607; int 0x10 }  // set cursor type
    *(unsigned short* _far) 0x0040004CUL = (Rows+n_extralines)*Columns*2u; // set video page size
    SetScanlineCount(400+8*n_extralines); // ADD AN EXTRA LINE OF TEXT (increase scanlines for 400 to 408)
    // This implementation is simple enough for it to work in DOSBox.
    // A 80x51 mode is still small enough that we can fit
    // four pages to 32k of VRAM. 80*51*2*4 = 32640. 80*52*2*4 = 33280.
}


char InBuffer[4096u];
int main()
{
    setcbrk(0);

    enum { npages = 4 };

    double cpuspeed = CPUinfo() / 1e6;

    ReprogramVideo();

    ForkPTY   * tasks = new ForkPTY[npages];
    termwindow* terms = new termwindow[npages];

    {for(int task=0; task < npages; ++task)
    {
        terms[task].SetVideoPage(task);
        char Buf[512];
        sqrt(1.0);// make borland c++ link floating point formats
        sprintf(Buf, "\33c"
            "\33[1;1H\33[0;40;37m\33[2J"
            "\33[51;1H\33[1;37;44m\33[Ktty%d\33[21;30m|\33[51;72H"
                    "|\33[1;37mDos\33[21;30m"
                "|\33[1;37meXit"
            "\33[1;1H"
            "\33[1;33mLaunching Linux simulation with %d virtual terminals.\33[K\r\n"
            "\33[21;33mRunning on %.1f MHz CPU (measured), in 16-bit real mode on DOS 5.00\33[K\r\n"
            "\33[0;37m\r\n", task+1, npages,
            cpuspeed);
        terms[task].Write(Buf);
    }}

    /*{ char Buf[128];
      sprintf(Buf, "fd=%d, pid=%d\r\n", fd,pid);
      term.Write(Buf); }*/

    int which = 0;
    int done = 0;
    while(done < npages)
    {
        termwindow& term = terms[which];
        cur_terminal = &term;

        if(HeldShifts[KG_ALT] && HeldKeys[0x2D])
            done = npages; // alt+x
        if(HeldShifts[KG_ALT] && HeldKeys[0x20]) // alt+d
        {
            const unsigned SwapSize = 0x8000u;
            char* videobackup = new char[SwapSize];
            if(!videobackup)
            {
                cur_terminal->Write("\33[0mUNABLE TO ALLOCATE MEMORY FOR VIDEO SWAP\n");
                HeldKeys[0x20] = 0;
                continue;
            }
            memcpy(videobackup, (const void _far*)0xB8000000UL, SwapSize);
            Reset256Color();
            BeepOff();

            int c = 0x1E00;
            short buf[10] = {'D'|c,'O'|c,'S'|c,c,'s'|c,'h'|c,'e'|c,'l'|c,'l'|c,0x107C};
            cur_terminal->myputtext_line(0,50, 10, buf);

            keyboard.Uninstall();

            _asm { mov ax,0x500; int 010 } // switch to page 0
            printf("\33[50;1H\33[0mLaunching DOS Shell. Type EXIT to return to Linux.\r\n");
            spawnl(P_WAIT, getenv("COMSPEC"), "command", NULL);

            keyboard.Install();

            ReprogramVideo();

            memcpy((void _far*)0xB8000000UL, videobackup, SwapSize);
            delete[] videobackup;
            for(int t=0; t<npages; ++t) terms[t].Write("",0); // reposition cursor on each page
            _asm { mov ax,which;mov ah,5; int 010 } // reselect the page we were on

            continue;
        }

        if(HitAltTab)
        {
            int offset = 1;
            if(HeldShifts[KG_SHIFT]) offset = npages-1;
            which = (which+offset) % npages;
            HitAltTab = 0;
            _asm {
                mov ax,which
                mov ah,5
                int 0x10
            }
            continue;
        }

        if(cur_terminal)
        {
            const unsigned n=56;
            short Buffer[n];
            static int a=30, ad=-1, b=40, bd=1, counter=0;
            for(unsigned c=0; c<n; ++c)
                Buffer[c] =  (HeldKeys[c]||HeldKeys[c+n]) ? 0x1F23 :
                             (c==a ? 0x1E01
                             :c==b ? 0x1F01
                             :0x1100);
            if(++counter>=3) { counter=0; a+=ad; b+=bd;
                               if(a==0||a==n-1)ad=-ad;
                               if(b==0||b==n-1)bd=-bd; }
            cur_terminal->myputtext_line(6,50, n, Buffer);
        }

        int activity = 0;
        for(int task=0; task<npages; ++task)
        {
            if(!tasks[task].Active()) continue;

            termwindow& term = terms[task];
            if(term.OutBufferLength > 0)
            {
                unsigned tail = term.OutBufferHead - term.OutBufferLength;
                if(term.OutBufferHead < term.OutBufferLength) tail += OutBufferCapacity;
                unsigned nwrite = term.OutBufferLength;
                if(term.OutBufferHead + nwrite > OutBufferCapacity)
                    nwrite = OutBufferCapacity - term.OutBufferHead;

                unsigned error=0;
                tasks[task].Send(term.OutBuffer + tail, nwrite, error);

                if(nwrite > 0 && nwrite != 0xFFFF)
                {
                    if(nwrite > term.OutBufferLength) nwrite = term.OutBufferLength;
                    term.OutBufferLength -= nwrite;
                    term.OutBufferHead   += nwrite;
                    if(term.OutBufferHead >= OutBufferCapacity)
                        term.OutBufferHead -= OutBufferCapacity;
                    if(term.OutBufferLength == 0)
                        { term.OutBufferHead = 0; }
                    ++activity;
                }
            }

            unsigned nread = sizeof(InBuffer), error=0;
            //memcpy(InBuffer, "kupo", 4);
            tasks[task].Recv(InBuffer, nread, error);

            if(nread > 0 && nread != 0xFFFF)
            {
                term.Write( InBuffer, nread );
                ++activity;
            }
            if(error != 0)
            {
                done += 1;
                char Buf[128];
                sprintf(Buf,  "\33[0m\r\nSimulation ended in tty%d [nread=%d,errno=%u]\r\n",
                    task+1, nread, error);
                term.Write(Buf);

                tasks[task].Close();
            }
        }

        if(activity) continue;

        wait();

        CheckBeepOff();

        if(cur_terminal)
        {
            cpuspeed = CPUinfo() / 1e6;
            char Buf[16] = {0};
            if(cpuspeed < 10.0)
                sprintf(Buf, "%8.3f MHz", cpuspeed);
            else if(cpuspeed < 100.0)
                sprintf(Buf, "%8.2f MHz", cpuspeed);
            else if(cpuspeed < 1000.0)
                sprintf(Buf, "%8.1f MHz", cpuspeed);
            else if(cpuspeed < 3000.0)
                sprintf(Buf, "%8.0f MHz", cpuspeed);
            else if(cpuspeed < 10000.0)
                sprintf(Buf, "%8.3f GHz", cpuspeed/1e3);
            else if(cpuspeed < 100000.0)
                sprintf(Buf, "%8.2f GHz", cpuspeed/1e3);
            else if(cpuspeed < 1000000.0)
                sprintf(Buf, "%8.1f GHz", cpuspeed/1e3);
            else
                sprintf(Buf, "%8.0f GHz", cpuspeed/1e3);

            short Buf2[16];
            const unsigned n = 12;
            for(unsigned c=0; c<n; ++c)
                Buf2[c] = ((unsigned char)Buf[c]) | 0x1300;
            cur_terminal->myputtext_line(59,50,n, Buf2);
        }
    }

    delete[] tasks;
    delete[] terms;

    setcbrk(1);

    BeepOff();

    SetScanlineCount(400);

    return 0;
}
