#include <string.h>
#include <stdio.h>
#include <conio.h>

#include "defs.h"
#include "256color.h"
#include "vidmem.h"

class Vec /* Borland C++ does not have std::vector, and really we only need this much. */
{
    enum { MaxSize = 16 };
    int buffer[MaxSize], length;
public:
    Vec() : length(0) { clear(); }
    void _fastcall clear() { length=0; memset(buffer,0,sizeof(buffer)); }
    void _fastcall push_back(int value) { if(length < MaxSize) buffer[length++] = value; }
    void _fastcall resize(int n)
        { if(n < length) length=n;
          else while(length < n && length < MaxSize) push_back(0);
          memset(&buffer[length], 0, sizeof(int)*(MaxSize-length)); }
    int _fastcall size() const { return length; }
    int& _fastcall operator[] (int pos) { return buffer[pos]; }
};

enum { OutBufferCapacity = 2000u };

class termwindow
{
private:
    unsigned char _far* VidMem;
    short _far* Cursor;
    int page;
public:
    unsigned char* OutBuffer;
    unsigned OutBufferHead, OutBufferLength;
    int cx, cy;

private:
    int top, bottom;
    signed char intensity, underline, blink, reverse, fgc, bgc;
    char g0set, g1set, activeset, utfmode;
    unsigned utflength; unsigned long utfvalue;

    const unsigned char _near* translate;
    unsigned char attr;
    unsigned short filler;
    enum { ESnormal, ESesc, ESsquare, ESgetpars, ESgotpars,
           EShash, ESignore, ESescnext, ESnonstd, ESsetG0,
           ESsetG1, ESpercent } state;
    Vec par;
    int ques;

    struct backup
    {
        int cx,cy, i,u,b,r,f,g, top,bottom;
    } backup;

private:
    void ResetAttr();
    void BuildAttr();
    void Reset();

    void FixCoord()
    {
        if(bottom>=Rows)bottom=Rows-1;
        if(top>bottom-2)top=bottom-2;
        if(top<0)top=0;
        if(bottom<top+2)bottom=top+2;
        if(cx<0)cx=0; if(cx>=Columns)cx=Columns-1;
        if(cy<0)cy=0; if(cy>=bottom)cy=bottom;
        RecalculateCursor();
    }
    void RecalculateCursor()
    {
        Cursor = VidMemPtr(VidMem, cx, cy);
    }
    void ScrollFix()
    {
        if(cx >= Columns) { Cursor -= cx; cx = 0; Lf(); }
    }
    void yscroll_down(unsigned y1, unsigned y2, int amount) const;
    void yscroll_up(unsigned y1, unsigned y2, int amount) const;

    void csi_at(register unsigned c) const;
    inline void csi_X(register unsigned c) const;
    inline void csi_P(register unsigned c) const;
    inline void csi_J(register unsigned c) const;
    void csi_K(register unsigned c) const;
    void csi_L(register int c) const
    {
        // scroll the rest of window c lines down,
        // including where cursor is. Don't move cursor.
        yscroll_down(cy, bottom, c);
    }
    inline void csi_M(register int c) const
    {
        yscroll_up(cy, bottom, c);
    }
    void Lf();
    void Ri();
    void save_cur();
    void restore_cur();
public:
    inline void myputtext_line
        (unsigned x,unsigned y, unsigned count, const void* source) const
    {
        myputtext(FP_OFF(VidMem)+VidMemBytePos(x,y), count, source);
    }

    void SetVideoPage(int p)
    {
        page = p;
        Reset();
    }
    void Write(const char* s)
    {
        Write(s, strlen(s));
    }
    void Write(const char* const s, const unsigned length);

    termwindow() : page(0)
    {
        OutBuffer = new unsigned char[OutBufferCapacity],
        OutBufferHead = 0;
        OutBufferLength = 0;
        Reset();
        save_cur();
    }
    void EchoBack(const char* buffer, unsigned size);
};
