model compact
.386c
.code
jumps
locals @@

public _VidMemBytePos
_VidMemBytePos:
        xchg ax, dx
        lea ax, [eax+eax*4]   ; This requires compilation through tasm
        shl ax, 4
        add ax, dx
        add ax, ax
        ret
	
public _mygotoxy
_mygotoxy:
        mov bh, al  ; page
        mov dh, bl  ; y
        mov ah, 2
        ;mov dl, x   -- already there
        int 10h
        ret

public _mymovetext
_mymovetext:
	; vidmem_begin_offs  (AX)
	; y1                 (DX)
	; y2                 (BX)
	; toy                ([SP])

	; n_words <= (160/4) * (y2-y1+1)
	; di <= offs + 160 * toy(di)
	; si <= offs + 160 * y1 (dx)

	movzx ecx, bx
	sub cx, dx

	push si
	push di
	
	lea cx, [ecx + ecx*4 + 5]
	
	shr ax, 4      ; this assumes page offsets are divisible with 16
	add ax, 0B800h
	shl cx, 3                ; cx = 40 * (y2-y1+1)
	
	;movzx edi, word[esp+4]
	mov di, word[esp+4]
	lea di, [edi + edi*4]
	;xor esi,esi
	shl di, 5

	lea si, [edx + edx*4]
	shl si, 5

	push ds
	 mov ds, ax
	 mov es, ax
	 cmp di, si
	 ja short @@backwards
	 cld
	 rep movsd
	 jmp short @@done
@@backwards:
	 lea si, [esi+ecx*4-4]
	 lea di, [edi+ecx*4-4]
	 std
	 rep movsd
	 cld
@@done:
	pop ds
	pop di
	pop si
	ret 2



public _mygettext
_mygettext:
	; AX = offs
	; DX = size (NUMBER OF WORDS)
	; [SP+4] = data
	push bp
	mov bp,sp
	push si
	push di
	push ds
	 mov si, ax
	 les di, [bp+4]
	 mov ax, 0B800h
	 mov ds, ax
	 jmp wordcopycommon


public _myputtext
_myputtext:
	; AX = offs
	; DX = size (NUMBER OF WORDS)
	; [SP+4] = data
	push bp
	mov bp, sp
	push si
	push di
	push ds
	 mov di, ax
	 lds si, [bp+4]
	 mov ax, 0B800h
	 mov es, ax
wordcopycommon:
	 cld
	 mov cx, dx
	 shr cx, 1
	 jnc @@buttwo
	 movsw
@@buttwo:
	 jz @@butnone
	 rep movsd
@@butnone:
	pop ds
	pop di
	pop si
	pop bp
	ret 4


public _myfilltext
_myfilltext:
	; AX = pagebegin+pos
	; DX = size (NUMBER OF WORDS)
	; BX = model
	push di
	 mov di, ax
	 mov ax, 0B800h
	 mov es, ax
	 mov cx, dx
	 movzx eax, bx
	 cld
	 shr cx, 1
	 jnc @@buttwo
	 stosw
@@buttwo:
	 jz @@butnone
	 shl eax, 16
	 mov ax, bx
	 rep stosd
@@butnone:
	pop di
	ret

public _myfilltext_lines
_myfilltext_lines:
	; AX = pagebegin  --> ES = B800h + ax/16
	; DX = y          --> DI = dx*160                           = (dx*5)*32
	; BX = size (rows). bytes = bx*80*2, dwords=bx*80*2/4=bx*40 = (bx*5)*8
	; [SP+2] = model
	push di
	 shr ax, 4
	 lea di, [edx + edx*4]
	 add ax, 0B800h
	 shl di, 5
	 mov es, ax
	 lea cx, [ebx + ebx*4]
	 mov bx, word[esp+2]
	 mov ax, bx
	 shl eax, 16
	 mov ax, bx
	 shl cx, 3
	 cld
	 rep stosd
	pop di
	ret 2


END
