{$O+,F+}   (* overlay *)
Unit Missions;

  INTERFACE
   uses
      Graph,Missiona,Crt;
    const
     NumofBuildings = 12;

    type
     buildingtype = array [1..NumofBuildings] of boolean;
     DeadHelitype = array [1..10] of boolean;
     stattype = string[10];

     pilottype = record
       name          : string [20];
       totalmissions : integer;
       totalscore    : integer;
       dmg           : real;
       status        : stattype;
       rank          : string [10];
      end;

   Procedure StatsScreen (var pilot        : pilottype;
                          score,hittotal    : integer;
                          damage,time      : real);
   Procedure ExtraPoints (var score       : integer;
                          var damage      : real;
                          tank            : boolean;
                          building        : buildingtype;
                          deheli          : deadhelitype);
   Procedure MissionResults (var pilot      : pilottype;
                          onscreen          : integer;
                          timedif             : real;
                          cond, mis,time2,time    : integer;
                          var ArrType1;
                          var ArrType2;
                          cruisealive,tank,pl : boolean;
                          cruisexv,step     : integer;
                          damage            : real;
                          totalejects       : integer;
                          level             : char;
                          hittotal           : integer);


  IMPLEMENTATION

 Procedure StatsScreen (var pilot        : pilottype;
                        score,hittotal   : integer;
                        damage,time      : real);
   var
    ftime  : string; { flight time }
    damge  : string;
    x      : string; { for converting numbers }
    dummy  : string;
 begin
  setgraphmode (3);
  setbkcolor (0);
  settextstyle (2,0,6);
  setcolor (2);
  outtextxy (10,10,'Mission Stats');
  setcolor (3);
  rectangle (5,5,280,195);
  settextstyle (2,0,4);
  outtextxy (30,25,'mission score ');
  str (score,dummy);
  outtextxy (200,25,dummy);
  outtextxy (30,35,'time in flight (sec.)');
  str (time:4:2,ftime);
  outtextxy (200,35,ftime);
  outtextxy (30,45,'damage on enemy (mil.)');
  str (damage:4:1,damge);
  damge := '$' + damge;
  outtextxy (200,45,damge);
  outtextxy (30,55,'status ');
  outtextxy (200,55,pilot.status);
  outtextxy (30,65,'hits taken');
  str (hittotal,dummy);
  outtextxy (200,65,dummy);
  setcolor (2);
  settextstyle (2,0,6);
  with pilot do
   begin
    dmg := dmg + damage;
    outtextxy (10,100,'Life Time Stats');
    setcolor (3);
    settextstyle (2,0,4);
    outtextxy (30,115,'total missions');
    str (totalmissions,x);
    outtextxy (200,115,x);
    outtextxy (30,125,'total score ');
    str (totalscore,x);
    outtextxy (200,125,x);
    outtextxy (30,135,'average score ');
    str (totalscore/totalmissions:4:2,x);
    outtextxy (200,135,x);
    outtextxy (30,145,'rank ');
    outtextxy (200,145,rank);
    outtextxy (30,155,'total damage in (mil.)');
    str (dmg:4:1,damge);
    damge := '$' + damge;
    outtextxy (200,155,damge);
   end;
  wait (95,180);
 end;

Procedure ExtraPoints (var score  : integer;
                       var damage : real;
                       tank       : boolean;
                       building   : buildingtype;
                       deheli     : deadhelitype);
  var  loop : integer;
 begin
  for loop := 1 to NumofBuildings do
   if building[loop] = false then
    case loop of
      1 : begin
           score := score - 25;
          end;
      2 : begin
           score := score + 5; { tower }
           damage := damage + 1;
          end;
      3 : begin
           score := score + 7;   { e i building }
           damage := damage + 2.2;
          end;
      4 : begin
           score := score + 9; { radar }
           damage := damage + 2;
          end;
      5 : begin
           score := score + 7;
           damage := damage + 2.5;
          end;
      6 : begin
           score := score + 13; { radar building }
           damage := damage + 6;
          end;
      7 : begin
           score := score + 10;  { ICBM building }
           damage := damage + 7;
          end;
      8 : begin
           score := score + 7;
           damage := damage + 2;
          end;
      9 : begin { tower }
           score := score + 5;
           damage := damage + 1;
          end;
      10 : score := score - 25; { base }
      11 : score := score - 15; { good gun }
      12 : begin    { gun }
            score := score + 5;
            damage := damage + 0.5;
           end;
     end; { of case }
   for loop := 1 to 10 do
    if deheli[loop] = true then
     begin
      score := score + 5;
      damage := damage + 1.9;
     end;
   if tank = false then
    begin
     damage := damage + 2;
     score := score + 3;
    end;
 end;

Procedure General (hate,mis :integer;var status : stattype);
   var time  : integer;
 begin
  cleardevice;
  setcolor(0);
  setfillstyle(1,3);
  bar (50,20,285,114);
  settextstyle(2,0,5);
  outtextxy (60,20,'IN THE OFFICE :');
  setcolor(2);
  settextstyle (2,0,4);
  randomize;
  time := random (65);
   case hate of
      -3 : outtextxy (65,37,'  . . .');
      -2 : begin  { base blown up }
              outtextxy (65,35,' Back in Washington they are');
              outtextxy (65,43,'investigating the incedent.');
              delay (1500);
              outtextxy (65,51,'The conclusion has been reached:');
              if (mis = 3) or (mis = 1) then
               begin
                outtextxy (65,59,' They believe the enemy heli-');
                outtextxy (65,67,' copter destroyed the base. Your');
                outtextxy (65,75,' name is cleared.');
               end;
              if (mis > 3) and (mis < 14) then
               begin
                outtextxy (65,59,' They believe that you intention-');
                outtextxy (65,67,' ally destroyed the base and killed');
                outtextxy (65,75,' 32 people. You will be put in the');
                outtextxy (65,83,' chair.  Good bye.');
                status := 'dead';
               end;
              if mis = 2 then
               begin
                outtextxy (65,59,' They believe the cruise missile');
                outtextxy (65,67,' destroyed the base. Your name is');
                outtextxy (65,75,' cleared. Washington is disapointed');
                outtextxy (65,83,' in your performance.');
               end;
              if mis > 13 then
               begin
                outtextxy (65,59,' They believe the enemy plane');
                outtextxy (65,67,' bombed the base. Your name is');
                outtextxy (65,75,' cleared. Washington is disapointed');
                outtextxy (65,83,' in your performance.');
               end;
            end;  { base blown up }
      -1 : begin  { dead }
            if (time < 25) and (time >= 0 ) then
             begin
              outtextxy (65,35,'"Ah darn, we lost another one."');
              outtextxy (65,43,'"It''s O.K. General life goes');
              outtextxy (65,51,'on. For most of us anyways."');
             end;
            if (time < 30) and (time >= 25 ) then
             begin
              outtextxy (65,35,'"I am sorry to say that your');
              outtextxy (65,43,'husband has been killed in action"');
              outtextxy (65,51,'"It''s O.K. General he wasn''t that');
              outtextxy (65,59,'good of a husband either. Are you');
              outtextxy (65,67,'doing anything tonight?"');
             end;
            if (time >= 30) and (time < 35) then
             begin
              outtextxy (65,35,'"I can''t believe that he crashed!"');
              outtextxy (65,43,'"You can''t predict things like this');
              outtextxy (65,51,'General."');
              outtextxy (65,59,'"I know, but that helicopter cost');
              outtextxy (65,67,'4 million dollars!"');
             end;
            if (time >= 35) and (time < 40) then
             begin
              outtextxy (65,35,'"I can''t believe that he crashed!"');
              outtextxy (65,43,'"Well General you remember our bet."');
              outtextxy (65,51,'"I know, here''s your 5 bucks."');
             end;
            if (time >= 40) and (time < 55) then
              begin
               outtextxy (65,35,'"Sure gonna miss old top gun."');
               outtextxy (65,43,'"Yeah, you can say that again."');
              end;
            if (time >= 55) and (time < 60) then
              begin
               outtextxy (65,35,'"I kind of liked that guy."');
               outtextxy (65,43,'"Yeh."');
              end;
            if (time >= 60) and (time < 65) then
              begin
               outtextxy (65,35,'"Man, that guy owed my $10."');
               outtextxy (65,43,'"Guess you''ll never see');
               outtextxy (65,51,'that again."');
              end;
           end;
       0 : begin  (* mission complete *)
            if (time >= 0) and (time < 9) then
             begin
              outtextxy (65,35,'"Good work son!"');
              outtextxy (65,43,'"Why thank you General."');
              outtextxy (65,51,'"Tell me son, do you like Cuban');
              outtextxy (65,59,'cigars?"');
             end;
            if (time >= 9) and (time < 18) then
             begin
              outtextxy (65,35,'"Good work son!"');
              outtextxy (65,43,'"Thank you, General."');
              outtextxy (65,51,'"You know I used to be a pilot');
              outtextxy (65,59,'like you. Back in 1943 I was..."');
             end;
            if (time >= 18) and (time < 27) then
             begin
              outtextxy (65,35,'"Good work pilot!"');
              outtextxy (65,43,'"Thank you, General."');
              outtextxy (65,51,'"I actually didn''t think you');
              outtextxy (65,59,'could pull it off."');
             end;
            if (time >= 27) and (time < 40) then
             begin
              outtextxy (65,35,'"Good work son,');
              outtextxy (65,43,'You''re a regular Top Gun."');
              outtextxy (65,51,'"Thank you, General."');
             end;
            if (time >= 40) and (time < 48) then
             begin
              outtextxy (65,35,'"Well, well, well,');
              outtextxy (65,43,'You are a great pilot!"');
              outtextxy (65,51,'"Thank you, General."');
             end;
            if (time >= 48) and (time < 56) then
             begin
              outtextxy (65,35,'"I never had a doubt');
              outtextxy (65,43,'that would come through."');
              outtextxy (65,51,'"I know, General."');
             end;
            if (time >= 56) and (time < 65) then
             begin
              outtextxy (65,35,'"Well you sure lucked');
              outtextxy (65,43,'out this time."');
              outtextxy (65,51,'"No General, I''m Good."');
             end;
           end;
       1 : begin
            if time < 30 then
             begin
              outtextxy (65,35,'"I expected more from you. Next');
              outtextxy (65,43,'time DO BETTER!"');
              outtextxy (65,51,'"Sorry sir."');
             end;
            if time > 29 then
             begin
              outtextxy (65,35,'"We both know you can');
              outtextxy (65,43,'do better than that."');
              outtextxy (65,51,'"Sorry sir."');
             end;
           end;
       2 : begin
             outtextxy (65,35,'"I CAN''T BE LEAVE WHAT YOU''VE');
             outtextxy (65,43,'DONE!! You call yourself an Air');
             outtextxy (65,51,'Force pilot. Get out of my office!"');
           end;
   end; { of case }
   delay (1000);
   wait (115,101);
  end; { of general }

Procedure CheckRank (var pilot : pilottype);
  var
   aver : real;
   miss : integer;
   new  : boolean;
 begin
  new := false;
  aver := pilot.totalscore/pilot.totalmissions;
  miss := pilot.totalmissions;
  with pilot do
   begin
     if rank ='Private' then
                 begin
                  if (aver > 100) and (miss > 1) then rank := '2nd Liut.';
                  if miss > 3 then
                   begin
                    if aver > 55 then rank := '2nd Liut.';
                    if (miss > 6) and (aver > 30) then rank := '2nd Liut.';
                   end;
                  if rank = '2nd Liut.' then new := true;
                 end;
     if rank = '2nd Liut.' then
                 begin
                  if (aver > 120) and (miss > 2) then rank := '1st Liut.';
                  if miss > 4 then
                   begin
                    if aver > 70 then rank := '1st Liut.';
                    if (miss > 9) and (aver > 50) then rank := '1st Liut.';
                   end;
                  if rank = '1st Liut.' then new := true;
                 end;
     if rank = '1st Liut.' then
                 begin
                  if (aver > 130) and (miss > 3) then rank := 'Captain';
                  if miss > 6 then
                   if aver > 80 then rank := 'Captain';
                  if miss > 10 then
                   if aver > 60 then rank := 'Captain';
                  if rank = 'Captain' then new := true;
                 end;
     if rank = 'Captain' then
                 begin
                  if (aver > 140) and (miss > 4) then rank := 'Major';
                  if miss > 7 then
                   if aver > 95 then rank := 'Major';
                  if miss > 11 then
                   if aver > 65 then rank := 'Major';
                  if rank = 'Major' then new := true;
                 end;
     if rank = 'Major' then
                 begin
                  if (aver > 150) and (miss > 5) then rank := 'Colonel';
                  if miss > 8 then
                   if aver > 105 then rank := 'Colonel';
                  if miss > 12 then
                   if aver > 75 then rank := 'Colonel';
                  if rank = 'Colonel' then new := true;
                 end;
     if rank = 'Colonel' then
                 begin
                  if (aver > 150) and (miss > 6) then rank := 'Commando';
                  if miss > 9 then
                   if aver > 110 then rank := 'Commando';
                  if miss > 13 then
                   if aver > 80 then rank := 'Commando';
                  if rank = 'Commando' then new := true;
                 end;
     if rank = 'Commando' then
                 begin
                  if (aver > 250) and (miss > 7) then rank := 'General';
                  if miss > 10 then
                   if aver > 180 then rank := 'General';
                  if miss > 15 then
                   if aver > 100 then rank := 'General';
                  if rank = 'General' then
                   begin
                    new := true;
                    if status = 'alive' then status := 'retired';
                   end;
                 end;
   end; { of with }
  if new = true then
   begin
    cleardevice;
    setcolor(0);
    setfillstyle(1,3);
    bar (50,20,300,100);
    settextstyle(2,0,5);
    outtextxy (60,20,'CONGRATULATIONS :');
    setcolor(2);
    settextstyle (2,0,4);
    outtextxy (65,35,' You have been promoted to the rank of:');
    if (aver > 140) and (miss < 4) then
     outtextxy (68,44,pilot.rank+', for high mission scores.')
      else if (miss > 5) and (aver < 100) then outtextxy (66,44,pilot.rank+', for completing many missions.')
       else outtextxy (70,44,pilot.rank+', for overall performance.');
    if (pilot.status = 'alive') and (pilot.rank <> 'General') then outtextxy (65,53,'  Keep up the good work!');
    if pilot.rank = 'General' then outtextxy (65,62,'PS,go past the mountains! (east of NorthCape)');
    wait (115,80);
   end;
 end;        {  CheckRank  }

Procedure MissionResults (var pilot      : pilottype;
                          onscreen       : integer;
                          timedif          : real;
                          cond, mis,time2,time : integer;
                          var ArrType1;
                          var ArrType2;
                          cruisealive,tank,pl:boolean;
                          cruisexv,step  : integer;
                          damage         : real;
                          totalejects    : integer;
                          level          : char;
                          hittotal       : integer);

   var  hate       : integer; { 0 to 3 (how mad the general is) }
        score      : integer;
        dummy      : string;
        loop       : integer;
        counter    : integer;
        WorkArray1 : Buildingtype absolute ArrType1;
        WorkArray2 : Deadhelitype absolute ArrType2;
        building   : array [1..NumOfBuildings] of boolean;
        deheli     : array [1..10] of boolean;

 begin
  for loop := 1 to NumofBuildings do
    building[loop] := WorkArray1[loop];
  for loop := 1 to 10 do
    deheli[loop]   := WorkArray2[loop];
  setgraphmode(1);
  cleardevice;
  setcolor(0);
  setfillstyle(1,3);
  bar (50,20,285,180);
  settextstyle(2,0,5);
  outtextxy (60,20,'MISSION  RESULTS :');
  setcolor(2);
  settextstyle (2,0,4);
  if (building[1] = true) and (onscreen < 9) or (building[10] = true) and (onscreen > 9) then
   case mis of
    1 : begin
        if (cond > 0) and (timedif <= 60) and (deheli[1] = true) then
         begin
          outtextxy (65,35,' You destoryed the "P-77" helicopter');
          outtextxy (65,43,'in less than 1 minute. Good job!');
          outtextxy (65,51,'The General would like to congratulate');
          outtextxy (65,59,'you.');
          score := 75;
          hate := 0;
         end;
        if (cond > 0) and (timedif > 60) and (deheli[1] = true) then
         begin
          outtextxy (65,35,' You destroyed the "P-77" helicopter.');
          outtextxy (65,43,'But not in 1 minute! Are forces were');
          outtextxy (65,51,'massively delayed! The General wants ');
          outtextxy (65,59,'to see you in his office!');
          hate := 1;
          score := 45;
         end;
        if (deheli[1] = false) and (cond > 0) then
         begin
          outtextxy (65,35,'   The "P-77" helicopter was not');
          outtextxy (65,43,'destroyed! Next time do your mission');
          outtextxy (65,51,'before returning home! The General');
          outtextxy (65,59,'wants to see you in his office!');
          hate := 2;
          score := 0;
         end;
        if (deheli[1] = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The "P-77" helicopter was not');
          outtextxy (65,43,'destroyed and you tragicly killed');
          outtextxy (65,51,'in action. You will be remembered.');
          hate := -1;
          score := onscreen;
         end;
        if (deheli[1] = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The "P-77" helicopter was destroyed');
          outtextxy (65,43,'but you were tragicly killed in');
          outtextxy (65,51,'action. You will be remembered.');
          hate := -1;
          score := 40;
         end;
       end;   { mis 1 }
    2 : begin
        if (building[1] = false) or (cond < 1) or (cruisealive = true) or (cruisexv = -32) then
         begin
          outtextxy (65,35,' You failed in completing your');
          outtextxy (65,43,'mission.');
          if (cruisealive = true) then
            outtextxy (65,51,'The missile wasn''t destroyed.')
             else if (cond < 1) then outtextxy (65,51, 'You & the missile were destroyed.');
          hate := 2;
          score := 2;
          if building[1] = false then hate := -2;
          if cond < 1 then hate := -3;
         end
        else
          begin
           outtextxy (65,35,' You destroyed the cruise missile');
           outtextxy (65,43,'and returned safely. Good Job.');
           hate := 0;
           score := 100;
          end;
       end; { mis 2 }
    3 : begin
        if (cond > 0) and (deheli[1] = true) then
         begin
          outtextxy (65,35,' You destoryed the "P-79" helicopter.');
          outtextxy (65,43,'Good job!  You are ready for more.');
          outtextxy (65,51,'The General would like to congratulate');
          outtextxy (65,59,'you.');
          score := 50;
          hate := 0;
         end;
        if (deheli[1] = false) and (cond > 0) then
         begin
          outtextxy (65,35,'   The "P-79" helicopter was not');
          outtextxy (65,43,'destroyed! Next time do your mission');
          outtextxy (65,51,'before returning home! The General');
          outtextxy (65,59,'wants to see you in his office!');
          hate := 2;
          score := 1;
         end;
        if (deheli[1] = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The "P-79" helicopter was not');
          outtextxy (65,43,'destroyed and you tragicly killed');
          outtextxy (65,51,'in action. You will be remembered.');
          hate := -1;
          score := 2
         end;
        if (deheli[1] = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The "P-79" helicopter was destroyed');
          outtextxy (65,43,'but you were tragicly killed in');
          outtextxy (65,51,'action. You will be remembered.');
          hate := -1;
          score := 35;
         end;
       end;   { mis 3 }
    4 : begin
        if (cond > 0) and (building[3] = false) then
         begin
          outtextxy (65,35,' You destoryed the E. I. building.');
          outtextxy (65,43,'Kuremee has been killed. Good job.');
          outtextxy (65,51,'The General would like to congratulate');
          outtextxy (65,59,'you.');
          score := 60;
          hate := 0;
         end;
        if (building[3] = true) and (cond > 0) then
         begin
          outtextxy (65,35,'   The Kuremee was not killed!');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home! The General wants');
          outtextxy (65,59,'to see you in his office! Now!');
          hate := 2;
          score := 1;
         end;
        if (building[3] = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The E. I. Building was destroyed.');
          outtextxy (65,43,'Kuremee was creamed, but so were you.');
          outtextxy (65,51,'You will be remembered.');
          hate := -1;
          score := 45;
         end;
        if (building[3] = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The E.I.Building was not destroyed,');
          outtextxy (65,43,'and you were tragicly killed in');
          outtextxy (65,51,'action. You will be remembered.');
          hate := -1;
          score := 2;
         end;
       end;   { mis 4 }
    5 : begin
        if (cond > 0) and (building[4] = false) then
         begin
          outtextxy (65,35,' You destoryed the radar. It will');
          outtextxy (65,43,'take at least 7 days for them to');
          outtextxy (65,51,'replace it. Now we can initiate');
          outtextxy (65,59,'our surprise attack. Good work!');
          score := 70;
          hate := 0;
         end;
        if (building[4] = true) and (cond > 0) then
         begin
          outtextxy (65,35,'   The radar wasn''t destroyed!');
          outtextxy (65,43,'Always do your mission before');
          outtextxy (65,51,'returning home. I guess will have');
          outtextxy (65,59,'to get a real pilot to do the job.');
          outtextxy (65,67,'The General would like to say some-');
          outtextxy (65,75,'thing to you in. He''s in his office.');
          hate := 2;
          score := 1;
         end;
        if (building[4] = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The radar was destroyed but you');
          outtextxy (65,43,'were tragicly killed. You will be');
          outtextxy (65,51,'remembered.');
          hate := -1;
          score := 45;
         end;
        if (building[4] = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The radar was not destroyed,');
          outtextxy (65,43,'and you were tragicly killed in');
          outtextxy (65,51,'action. You will be remembered.');
          hate := -1;
          score := 2;
         end;
       end;   { mis 5 }
    6 : begin
        if (cond > 0) and (step = 2) then
         begin
          outtextxy (65,35,' You transfered the top secret');
          outtextxy (65,43,'device within two minutes and');
          outtextxy (65,51,'returned safely. Good work!');
          score := 105;
          hate := 0;
         end;
        if (cond > 0) and (step = 1) then
         begin
          outtextxy (65,35,' You transfered the top secret');
          outtextxy (65,43,'device. But not in two minutes!');
          outtextxy (65,51,'The timing was critical, and');
          outtextxy (65,59,'you mess up!');
          score := 65;
          hate := 1;
         end;
        if (step = 0) and (cond > 0) then
         begin
          outtextxy (65,35,'   The device wasn''t transfered!');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home. I guess will have');
          outtextxy (65,59,'to get a real pilot to do the job.');
          outtextxy (65,67,'The General wants you in his');
          outtextxy (65,75,'office pronto!');
          hate := 2;
          score := 0;
         end;
        if (step > 0) and (cond < 1) then
         begin
          outtextxy (65,35,'   The device was sent, but you');
          outtextxy (65,43,'were tragicly killed. You will be');
          outtextxy (65,51,'remembered for your valor.');
          hate := -1;
          score := 55;
         end;
        if (step = 0) and (cond < 1) then
         begin
          outtextxy (65,35,' You were killed before getting');
          outtextxy (65,43,'a chance to transfer to secret');
          outtextxy (65,51,'device. You will be remebered.');
          hate := -1;
          score := 2;
         end;
       end;   { mis 6 }
    7 : begin
        if (cond > 0) and (onscreen = 15) then
         begin
          outtextxy (65,35,' You transfered the top secret');
          outtextxy (65,43,'papers successfully. Good job.');
          score := 65;
          hate := 0;
         end;
        if (onscreen = 3) and (cond > 0) then
         begin
          outtextxy (65,35,'   The papers weren''t transfered!');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home. I guess will have');
          outtextxy (65,59,'to get a REAL pilot to do the job.');
          outtextxy (65,67,'The General wants you in his');
          outtextxy (65,75,'office right now!');
          hate := 2;
          score := 0;
         end;
        if (cond < 1) then
         begin
          outtextxy (65,35,'   The papers weren''t sent and you');
          outtextxy (65,43,'were tragicly killed. You will be');
          outtextxy (65,51,'remembered.');
          hate := -1;
          score := 1;
         end;
       end;   { mis 7 }
    8 : begin
        if (cond > 0) and (step = 1) and (onscreen = 15) then
         begin
          outtextxy (65,35,' You picked up the top secret');
          outtextxy (65,43,'capsule and returned it to');
          outtextxy (65,51,'NorthCape Base. The General');
          outtextxy (65,59,'is very pleased.');
          if (pilot.rank = 'Private') or (pilot.rank = '2nd Luit.') or
             (pilot.rank = '1st Luit.') then
          outtextxy (65,67,'This could mean a promotion.');
          score := 130;
          hate := 0;
         end;
        if (cond > 0) and (step = 1) and (onscreen = 3) then
         begin
          outtextxy (65,35,' You picked up the top secret');
          outtextxy (65,43,'capsule but, you returned it');
          outtextxy (65,51,'to the wrong base! You were');
          outtextxy (65,59,'supposed to return it to');
          outtextxy (65,67,'NorthCape Base.');
          score := 133;
          hate := 1;
         end;
        if (step = 0) and (cond > 0) then
         begin
          outtextxy (65,35,'   The capsule wasn''t retrieved!');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home. I guess will have');
          outtextxy (65,59,'to get some other pilot to do the');
          outtextxy (65,67,'job. The General wants you in his');
          outtextxy (65,75,'office.');
          hate := 2;
          score := 0;
         end;
        if (step = 1) and (cond < 1) then
         begin
          outtextxy (65,35,' The capsule was retrieved but you');
          outtextxy (65,43,'were tragicly killed. You will be');
          outtextxy (65,51,'remembered for your courage.');
          hate := -1;
          score := 75;
         end;
        if (step = 0) and (cond < 1) then
         begin
          outtextxy (65,35,' You were killed before getting');
          outtextxy (65,43,'a chance to retrieve the secret');
          outtextxy (65,51,'capsule. You will be remebered.');
          hate := -1;
          score := 3;
         end;
       end;   { mis 8 }
    9 : begin
        if (cond > 0) and (building[9] = false) then
         begin
          outtextxy (65,35,' You destroyed the tower.');
          outtextxy (65,43,'Now we can initiate our');
          outtextxy (65,51,'attack on the enemy terr-');
          outtextxy (65,59,'itory. Good job.');
          score := 35;
          hate := 0;
         end;
        if (cond > 0) and (building[9] = true) then
         begin
          outtextxy (65,35,' You didn''t do your mission!');
          outtextxy (65,43,'You were supposed to destroy');
          outtextxy (65,51,'the tower!  Now we can''t');
          outtextxy (65,59,'attack the enemy territory');
          outtextxy (65,67,'because the tower is guarding');
          outtextxy (65,75,'it.');
          score := 1;
          hate := 1;
         end;
        if (cond < 1) and (building[9] = true) then
         begin
          outtextxy (65,35,'   The tower wasn''t destroyed.');
          outtextxy (65,43,'You were killed in action. You');
          outtextxy (65,51,'will be remembered.');
          hate := -1;
          score := 1;
         end;
        if (cond < 1) and (building[9] = false) then
         begin
          outtextxy (65,35,' The tower was destroyed but so');
          outtextxy (65,43,'were you. You will be remembered.');
          hate := -1;
          score := 20;
         end;
       end;   { mis 9 }
    10 : begin
        if (cond > 0) and (building[8] = false) then
         begin
          outtextxy (65,35,' You destroyed the lab.');
          outtextxy (65,43,'No more worry of that');
          outtextxy (65,51,'weapon now.  Good job.');
          score := 40;
          hate := 0;
         end;
        if (cond > 0) and (building[8] = true) then
         begin
          outtextxy (65,35,' You didn''t do your mission!');
          outtextxy (65,43,'You were supposed to destroy');
          outtextxy (65,51,'the lab!  They might you the');
          outtextxy (65,59,'the weapon on us now!  Hope-');
          outtextxy (65,67,'fully you.');
          score := 1;
          hate := 1;
         end;
        if (cond < 1) and (building[8] = true) then
         begin
          outtextxy (65,35,'   The lab wasn''t destroyed.');
          outtextxy (65,43,'You were killed in action. You');
          outtextxy (65,51,'will be remembered.');
          hate := -1;
          score := 1;
         end;
        if (cond < 1) and (building[8] = false) then
         begin
          outtextxy (65,35,' The lab was destroyed but so');
          outtextxy (65,43,'were you. You will be remembered.');
          hate := -1;
          score := 25;
         end;
       end;   { mis 10 }
    11 : begin
        counter := 0;
        for loop := 2 to NumOfBuildings do
         if building[loop] = false then counter := counter + 1;
        if building[11] = false then counter := counter - 1;
        if (cond > 0) and (counter = 9) then
         begin
          outtextxy (65,35,' All of the enemy buildings');
          outtextxy (65,43,'have been destroyed. It will');
          outtextxy (65,51,'take them at least a year for');
          outtextxy (65,59,'them to recover. You are a');
          outtextxy (65,67,'true Commando. Great work.');
          score := 160;
          hate := 0;
         end;
        if (cond > 0) and (counter > 5) and (counter < 9) then
         begin
          outtextxy (65,35,' You destroyed most of the');
          outtextxy (65,43,'buildings, but not all of');
          outtextxy (65,51,'them. The enemy is working');
          outtextxy (65,59,'on repair. We might get some');
          outtextxy (65,67,'attacks because the enemy');
          outtextxy (65,75,'wasn''t totally destroyed.');
          score := 90;
          hate := 1;
         end;
        if (cond > 0) and (counter < 6) and (counter > 0) then
         begin
          outtextxy (65,35,' You did not complete your');
          outtextxy (65,43,'mission. The General isn''t');
          outtextxy (65,51,'pleased.');
          score := 30;
          hate := 1;
         end;
        if (cond < 1) and (counter > 2) and (counter < 6) then
         begin
          outtextxy (65,35,'   You destroyed some buildings,');
          outtextxy (65,43,'but you are unfortunately apart');
          outtextxy (65,51,'of the rubble. You will be remem-');
          outtextxy (65,59,'bered for your effort.');
          hate := -1;
          score := 50;
         end;
        if (cond < 1) and (counter < 3) then
         begin
          outtextxy (65,35,'   You were killed before');
          outtextxy (65,43,'completing your mission.');
          outtextxy (65,51,'You will be remembered for');
          outtextxy (65,59,'your bravery.');
          hate := -1;
          score := 5;
         end;
        if (cond < 1) and (counter > 5) and (counter < 9) then
         begin
          outtextxy (65,35,'   You destroyed most of the build-');
          outtextxy (65,43,'ings, but you were killed in action.');
          outtextxy (65,51,'You will be remembered for your skill.');
          hate := -1;
          score := 80;
         end;
        if (cond < 1) and (counter = 9) then
         begin
          outtextxy (65,35,'   You destroyed all of the buildings,');
          outtextxy (65,43,'but you were tragicly killed in action.');
          outtextxy (65,51,'You will be remembered for your great');
          outtextxy (65,59,'skill.');
          hate := -1;
          score := 140;
         end;
        if (cond > 0) and (counter = 0) then
         begin
          outtextxy (65,35,' You failed to destroy any buildings.');
          outtextxy (65,43,'Do your mission before returning home!');
          hate := 2;
          score := 1;
         end;
       end;   { mis 11 }
    12 : begin
        if (cond > 0) and (building[9] = false) then
         begin
          outtextxy (65,35,' You destroyed the enemy guard tower');
          outtextxy (65,43,'and returned home alive. Good Job!');
          outtextxy (65,51,'The General would like to congratulate');
          outtextxy (65,59,'you.');
          score := 45;
          hate := 0;
         end;
        if (building[9] = true) and (cond > 0) then
         begin
          outtextxy (65,35,'   The tower wasn''t destroyed!');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home! I guess we''ll have');
          outtextxy (65,59,'to get REAL pilot to do the job.');
          hate := 2;
          score := 1;
         end;
        if (building[9] = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The tower was destroyed, but you');
          outtextxy (65,43,'were taken out too.  Good Try.  You');
          outtextxy (65,51,'will be remembered for trying.');
          hate := -1;
          score := 25;
         end;
        if (building[9] = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The tower was not destroyed,');
          outtextxy (65,43,'and you were tragicly killed in');
          outtextxy (65,51,'action. You will be remembered.');
          hate := -1;
          score := 2;
         end;
       end;   { mis 12 }
    13 : begin
        if (cond > 0) and (tank = false) then
         begin
          outtextxy (65,35,' You destroyed the enemy tank and');
          outtextxy (65,43,'returned home alive. Good Job! The');
          outtextxy (65,51,'General would like to congratulate');
          outtextxy (65,59,'you.');
          score := 65;
          hate := 0;
         end;
        if (tank = true) and (cond > 0) then
         begin
          outtextxy (65,35,'   The Tank wasn''t destroyed!');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home! I guess we''ll have');
          outtextxy (65,59,'to get REAL pilot to do the job.');
          hate := 2;
          score := 0;
         end;
        if (tank = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The tank was destroyed, but so');
          outtextxy (65,43,'were you.  You will be remembered.');
          hate := -1;
          score := 30;
         end;
        if (tank = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The tank was not destroyed,');
          outtextxy (65,43,'and you were tragicly killed in');
          outtextxy (65,51,'action.');
          hate := -1;
          score := 1;
         end;
       end;   { mis 13 }
   15 : begin
        if (cond > 0) and (pl = false) then
         begin
          if building[1] = true then
           begin
          outtextxy (65,35,' You destroyed the enemy transport');
          outtextxy (65,43,'plane returned home alive. The');
          outtextxy (65,51,'General is very happy about it.');
          if (pilot.rank = 'Private') or (pilot.rank = '2nd Luit.') or
             (pilot.rank = '1st Luit.') then
          outtextxy (65,67,'This could mean a promotion.');
          score := 115;
          hate := 0;
           end
            else
             begin
          outtextxy (65,35,' You destroyed the enemy transport');
          outtextxy (65,43,'plane returned home alive. But');
          outtextxy (65,51,'Ocale Base was destroyed.');
          score := 35;
          hate := 1;
             end;
         end;
        if (pl = true) and (cond > 0) then
         begin
          outtextxy (65,35,'   The plane wasn''t destroyed.');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home. I guess we''ll have');
          outtextxy (65,59,'to get a better pilot next time.');
          hate := 2;
          score := 5;
         end;
        if (pl = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The plane was destroyed, but so');
          outtextxy (65,43,'were you.  You will be remembered.');
          hate := -1;
          score := 50;
         end;
        if (pl = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The plane was not destroyed,');
          outtextxy (65,43,'and you were tragicly killed in');
          outtextxy (65,51,'action.');
          hate := -1;
          score := 5;
         end;
       end;   { mis 15 }
   14 : begin
        if (cond > 0) and (pl = false) then
         begin
          if building[1] = true then
           begin
          outtextxy (65,35,' You destroyed the enemy transport');
          outtextxy (65,43,'plane returned home alive. The');
          outtextxy (65,51,'General is very happy about it.');
          score := 90;
          hate := 0;
           end
            else
             begin
          outtextxy (65,35,' You destroyed the enemy transport');
          outtextxy (65,43,'plane returned home alive. But');
          outtextxy (65,51,'Ocale Base was destroyed.');
          score := 35;
          hate := 1;
             end;
         end;
        if (pl = true) and (cond > 0) then
         begin
          outtextxy (65,35,'   The plane wasn''t destroyed.');
          outtextxy (65,43,'Next time do your mission before');
          outtextxy (65,51,'returning home. I guess we''ll have');
          outtextxy (65,59,'to get a better pilot next time.');
          hate := 2;
          score := 5;
         end;
        if (pl = false) and (cond < 1) then
         begin
          outtextxy (65,35,'   The plane was destroyed, but so');
          outtextxy (65,43,'were you.  You will be remembered.');
          hate := -1;
          score := 45;
         end;
        if (pl = true) and (cond < 1) then
         begin
          outtextxy (65,35,' The plane was not destroyed,');
          outtextxy (65,43,'and you were tragicly killed in');
          outtextxy (65,51,'action.');
          hate := -1;
          score := 5;
         end;
       end;   { mis 14 }
   16 : begin
        if (building[1] = false) then
         begin
          outtextxy (65,35,'  Ocale base was destroyed.');
          outtextxy (65,43,'  You have failed.');
          hate := 2;
          score := 2;
         end
        else { building[1] = true }
        begin
        hate := 1;
        if (pl = false) then
         begin
          outtextxy (65,35,'  The enemy plane was destroyed,');
          if (deheli[1] = true) then
           outtextxy (65,43,'  and so was the enemy helicopter.')
            else
             outtextxy (65,43,'  but not the enemy helicopter.');
         end
        else { if pl is false }
         begin
          outtextxy (65,35,'  The enemy plane was not destroyed,');
          if (deheli[1] = true) then
           outtextxy (65,43,'  but the enemy helicopter was.')
            else
             outtextxy (65,43,'  and neither was the enemy helicopter.');
         end;
        if (pl = false) then score := 65
         else score := 0;
        if (deheli[1] = true) then score := score + 25;
        if (cond > 0) and (score > 25) then score := score + 40
         else if cond < 1 then hate := -1
          else
           begin
            hate := 2;
            outtextxy (65,51,'Do the mission before returning home!');
           end;
        if cond < 1 then outtextxy (65,51,'  You were killed in action.');
        if score = 130 then
         begin
          outtextxy (65,51,'  Good work.');
          hate := 0;
         end;
        end; { else }
       end;   { mis 16 }
   17 : begin
        if (building[1] = false) then
         begin
          outtextxy (65,35,'  Ocale base was destroyed.');
          outtextxy (65,43,'  You have failed.');
          hate := 2;
          score := 2;
         end
        else { building[1] = true }
          begin
           if cruisealive = false then
            begin
             outtextxy (65,35,' You destroyed the cruise missile');
             score := 150;
             hate := 0;
             if cond > 0 then outtextxy (65,43,' and returned safely. Good Job.')
              else
               begin
                outtextxy (65,43,' but were killed in action.');
                score := 40;
                hate := -1;
               end;
            end
             else  { cruisealive = true }
              begin
               if cond > 0 then
                begin
                 outtextxy (65,35,' You didn''t finish your mission!!');
                 outtextxy (65,43,' You were supposed to destroy the');
                 outtextxy (65,51,' cruise missile, it will be here');
                 outtextxy (65,59,' any time now.');
                 hate := 2;
                 score := 0;
                end
                 else
                  begin
                   outtextxy (65,35,' You didn''t destroy the cruise');
                   outtextxy (65,43,' and were killed. You will be');
                   outtextxy (65,51,' remembered.');
                   score := 2;
                   hate := -1;
                  end;
              end;
          end;
       end; { mis 17 }
   18 : begin
        if (building[1] = false) then
         begin
          outtextxy (65,35,'  Ocale base was destroyed.');
          outtextxy (65,43,'  You have failed.');
          hate := 2;
          score := 2;
         end
        else { building[1] = true }
          begin
           if cruisealive = false then
            begin
             outtextxy (65,35,' You destroyed the cruise missile');
             score := 150;
             hate := 0;
             if cond > 0 then
              begin
               outtextxy (65,43,' and returned home safely.');
               if step = 0 then outtextxy (65,51,' Great Job!');
               if step = 1 then
                 begin
                  outtextxy (65,51,' Though the explosion of the');
                  outtextxy (65,59,' missile was far enough away');
                  outtextxy (65,67,' from our base,  your chopper');
                  outtextxy (65,75,' wasn''t.  You are contaminated.');
                  score := score - 35;
                  pilot.status := 'C';
                 end;
               if step = 2 then
                 begin
                  outtextxy (65,51,' The explosion of the missile');
                  outtextxy (65,59,' wasn''t far enough away from');
                  outtextxy (65,67,' our base. You and the rest of');
                  outtextxy (65,75,' us are contaminated.');
                  pilot.status := 'C';
                  hate := -3;
                 end;
              end
              else
               begin
                outtextxy (65,43,' but were killed in action.');
                score := 40;
                hate := -1;
               end;
            end
             else  { cruisealive = true }
              begin
               if cond > 0 then
                begin
                 outtextxy (65,35,' You didn''t finish your mission!!');
                 outtextxy (65,43,' You were supposed to destroy the');
                 outtextxy (65,51,' cruise missile, it will be here');
                 outtextxy (65,59,' any time now.');
                 hate := 2;
                 score := 0;
                end
                 else
                  begin
                   outtextxy (65,35,' You didn''t destroy the cruise');
                   outtextxy (65,43,' and were killed. You will be');
                   outtextxy (65,51,' remembered.');
                   score := 2;
                   hate := -1;
                  end;
              end;
          end;
       end; { mis 18 }
   19 : begin
        if (building[1] = false) then
         begin
          outtextxy (65,35,'  Ocale base was destroyed.');
          outtextxy (65,43,'  You have failed.');
          hate := 2;
          score := 2;
         end
        else { building[1] = true }
          begin
           if (pl = false) then
            begin
             outtextxy (65,35,' You destroyed the enemy plane,');
             score := 135;
             hate := 0;
             if cond > 0 then
              begin
               outtextxy (65,43,' and returned home safely.');
               if tank = false then
                 begin
                  outtextxy (65,51,' The "object" turned out to be');
                  outtextxy (65,59,' a tank. It was also destroyed.');
                  outtextxy (65,67,' Great Job!');
                  score := score + 15;
                 end
                else
                 begin
                  outtextxy (65,51,' The "object" turned out to be');
                  outtextxy (65,59,' a tank. It wasn''t destroyed.');
                 end;
              end
              else { cond =< 0 }
               begin
                outtextxy (65,43,' but were killed in action.');
                score := 40;
                hate := -1;
               end;
            end
             else  { pl = true }
              begin
               if cond > 0 then
                begin
                 outtextxy (65,35,' You didn''t finish your mission!!');
                 outtextxy (65,43,' You were supposed to destroy the');
                 outtextxy (65,51,' plane! Maybe we can find some one');
                 outtextxy (65,59,' more qualified.');
                 hate := 2;
                 score := 1;
                end
                 else
                  begin
                   outtextxy (65,35,' You didn''t destroy the plane');
                   outtextxy (65,43,' and were killed. You might be');
                   outtextxy (65,51,' remembered.');
                   score := 2;
                   hate := -1;
                  end;
              end;
          end;
       end; { mis 19 }
   20 : begin
       if (building[1] = false) then
         begin
          outtextxy (65,35,'  Ocale base was destroyed.');
          outtextxy (65,43,'  You have failed.');
          hate := 2;
          score := 2;
         end
        else { building[1] = true }
        begin
        hate := 1;
        if (cruisealive = false) then
         begin
          outtextxy (65,35,' The cruise missile was destroyed,');
          if (deheli[1] = true) then
           outtextxy (65,43,' and so was the enemy helicopter.')
            else
             outtextxy (65,43,' but not the enemy helicopter.');
         end
        else { if pl is false }
         begin
          outtextxy (65,35,' The cruise missile was not destroyed,');
          if (deheli[1] = true) then
           outtextxy (65,43,' but the enemy helicopter was.')
            else
             outtextxy (65,43,' and neither was the enemy helicopter.');
         end;
        if (cruisealive = false) then score := 85
         else score := 0;
        if (deheli[1] = true) then score := score + 25;
        if (cond > 0) and (score > 25) then score := score + 20
         else if cond < 1 then hate := -1
          else
           begin
            hate := 2;
            outtextxy (65,51,'Do the mission before returning home!');
           end;
        if cond < 1 then outtextxy (65,51,' You were killed in action.');
        if score = 130 then
         begin
          outtextxy (65,51,' Good work.');
          hate := 0;
         end;
         end; { else }
       end;   { mis 20 }
    end { of case }
     else begin
           score := 0;
           outtextxy (65,35,' The base has been destoryed.');
           outtextxy (65,43,'Nobody is left from the explosion.');
           if cond > 0 then
            begin
             outtextxy (65,51,'Everyone is dead except you.');
             hate := -2;
            end;
           if cond <= 0 then hate := -3;
          end;
  ExtraPoints (score,damage,tank,WorkArray1,WorkArray2);
  score := score - totalejects * (5 * (integer(level)-48));  (* subtract score for wasting helicopters through ejecting *)
  case level of
    '1' : score := round (score * 0.8);
    '2' : score := round (score * 1.1);
    '3' : score := round (score * 1.3);
   end;  { of case }
  if (score < 0) then score := score div 3;
  outtextxy (75,130,'MISSION SCORE :');
  str (score,dummy);
  outtextxy (175,130,dummy);
  pilot.totalscore := pilot.totalscore + score;
  delay (500);
  wait (115,157);
  General (hate,mis,pilot.status); { conservation in his office }
  if (cond < 1) and (onscreen < 7) or (onscreen > 8) and (cond < 1) then pilot.status := 'dead'
   else if (cond < 1) then pilot.status := 'missing';
  CheckRank (pilot);
  StatsScreen (pilot,score,hittotal,damage,timedif);
  setgraphmode (0);
 end;     { of mission results }

End.