{$O+,F+}
Unit Title;
 INTERFACE
  uses Graph,crt,Missiona,Mouse,Missions;

Type

 arraypilot = array [1..6] of pilottype; { pilottype in missions }
 persontype = record
   x     : real;
   y     : real;
   xv    : real;
   yv    : real;
   screen: integer; { screen person is on (for sold. only) }
   cond  : integer; { 3 to 0 }
   time  : integer; { timing parachute }
   eject : integer; { 2 in air no chute, 1 in air chute, 0 on ground ** not used by man. He has his own global }
 end;

Var
 loop  : integer;
 pilot : arraypilot;
 keyhit: char;
 infile : file of arraypilot;
 firstgo : integer;  { this equals zero at first title screen, after "S" is pressed this equals 13.  }

Procedure TitleScreen (var level : char; var pilnum : integer; var pil : pilottype; var free : boolean);
Procedure Mission (var scene : string; var mis : integer);
Procedure Save (pi:pilottype; pilnum : integer);
Procedure OpenUpfile;
Procedure CloseDownFile;

 IMPLEMENTATION

Procedure OpenUpfile;
 begin
  assign (infile,'PILOTS.DAT');
 end;

Procedure CloseDownFile;
 begin
  close (infile);
 end;

Procedure Mission (var scene : string; var mis : integer);
  var dif  : char;
      rand : integer;
 begin
  randomize;
  rand := random (5);
  setbkcolor(8);
  cleardevice;
  setcolor (2);
  settextstyle(2,0,6);
  outtextxy (50,55,'SELECT MISSION:');
  outtextxy (60,70,' 1) easy');
  outtextxy (60,85,' 2) regular');
  outtextxy (60,100,' 3) hard');
  outtextxy (60,115,' 4) very hard');
  scene := 'day';
  repeat
   dif := readkey;
  until (dif = '1') or (dif = '2') or (dif = '3') or (dif = '4');
  MissionSetUp;  { draw box on screen }
  if dif= '1' then
  case rand of
   0 : mis := 3;
   1 : mis := 12;
   2 : mis := 9;
   3 : mis := 10;
   4 : mis := 7;
   end;

  if dif = '2' then
  case rand of
   0 : mis := 1;
   1 : mis := 4;
   2 : mis := 5;
   3 : mis := 13;
   4 : mis := 14;
   end;

  if dif = '3' then
  case rand of
   0 : mis := 2;
   1 : mis := 6;
   2 : mis := 8;
   3 : mis := 11;
   4 : mis := 15;
   end;

  if dif = '4' then
   case rand of
   0 : mis := 16;
   1 : mis := 17;
   2 : mis := 18;
   3 : mis := 19;
   4 : mis := 20;
   end;

  case mis of
   1  : mission1;
   2  : mission2;
   3  : mission3;
   4  : mission4;
   5  : mission5;
   6  : mission6;
   7  : mission7;
   8  : mission8;
   9  : mission9;
   10 : mission10;
   11 : mission11;
   12 : mission12;
   13 : mission13;
   14 : mission14;
   15 : mission15;
   16 : mission16;
   17 : mission17;
   18 : mission18;
   19 : mission19;
   20 : mission20;
   end;
 end;     { of mission }

Procedure TitleScreen (var level : char; var pilnum : integer; var pil : pilottype; var free : boolean);
  var   counter : integer;
        dummy   : string;

 Procedure easywait;
   var key : char;
  begin
   outtextxy (100,185,'press any key');
   repeat until keypressed;
   key := readkey;
   if (key = #27) then halt;
  end;

 Procedure other;
  begin
   cleardevice;
   settextstyle (2,0,4);
   setcolor (2);
   setbkcolor (0);
   outtextxy (5,10, '  Chopper Commando version 2.56 was written by Mark');
   outtextxy (5,20, 'Currie in Turbo Pascal 5. I hope you enjoy the game.');
   outtextxy (5,30, 'This game may not be duplicated in any way or form.');
   outtextxy (5,40, 'I am currently working towards a degree in    ');
   outtextxy (5,50, 'Computer Science.                             ');
   outtextxy (5,60, '                                              ');
   outtextxy (5,70, '                                                ');
   outtextxy (5,80, '                           ');
   outtextxy (5,90, '                                        ');
   outtextxy (5,105, '    Send comments to :');

   outtextxy (5,123,'      Mark Currie,');
   outtextxy (5,133,'      4250 Grove Park Lane,');
   outtextxy (5,143,'      Lantana, FL   33462');
   outtextxy (5,158,'                                                 ');
   outtextxy (5,168,'              ');
   easywait;
  end;

 Procedure instruct;
  begin
   cleardevice;
   settextstyle (2,0,4);
   setcolor (2);
   setbkcolor (0);
   outtextxy (5,10, '   Keys:       (nothing new from 2.0) ');
   outtextxy (5,20, '                 Up - up arrow');
   outtextxy (5,30, ' Left - left arrow      Right - right arrow');
   outtextxy (5,40, '               Down - down arrow');
   outtextxy (5,57, '  F1 or "G"        -  toggle landing gear ');
   outtextxy (5,67, '  F2 or "E"        -  eject/exit craft');
   outtextxy (5,77, '  "B" or ins key   -  drop bomb');
   outtextxy (5,87, '  space key        -  launch bomb');
   outtextxy (5,97,'  "N"              -  drop mega bomb');
   outtextxy (5,107,'  "M"              -  launch missile');
   outtextxy (5,117,'  "T"              -  toggle mouse');
   outtextxy (5,127,'  "P"              -  pause');
   outtextxy (5,137,'  "S"              -  toggle game speed');
   outtextxy (5,147,'  "X"              -  toggle sound');
   outtextxy (5,157,'  Esc              -  quit game');
   outtextxy (5,167,'  "A"              -  toggle auto-eject');
   outtextxy (5,177,'  home , PgUp keys -  throws grenades (when ejected)');
   easywait;
   cleardevice;
   settextstyle (2,0,4);
   setcolor (2);
   setbkcolor (0);
   outtextxy (5,10, ' Objectives :');
   outtextxy (5,20, '  - complete missions');
   outtextxy (5,30, '  - destroy the enemy');
   outtextxy (5,40, '  - protect the good guys');
   outtextxy (5,50, '  - stay alive');
   outtextxy (5,70, '  Once ejected wait for a backup helicopter.');
   outtextxy (5,80, ' To land : make sure gear is down, lower');
   outtextxy (5,90, ' slowly, make contact with leveled land. ');
   outtextxy (5,100,'  Once you complete your mission return');
   outtextxy (5,110,' back to base. Try to stay alive to build');
   outtextxy (5,120,' up your pilot''s stats.');
   outtextxy (5,138,'  Scoring :');
   outtextxy (5,148,'   - completing missions');
   outtextxy (5,158,'   - destorying the enemy');
   outtextxy (5,168,'   - high difficulty');
   outtextxy (5,178,'   - staying alive');
   easywait;
   cleardevice;
   settextstyle (2,0,4);
   setcolor (2);
   setbkcolor (0);
   outtextxy (5,10, '        Tips...');
   outtextxy (5,20, '  This is not an easy game.  Beginners should');
   outtextxy (5,30, 'start off on an easy difficultly. Adjust game');
   outtextxy (5,40, 'speed to skill, slower the easier.');
   outtextxy (5,50, ' Using the mouse makes landings a little harder');
   outtextxy (5,60, 'but make air-to-air combat much easier. You');
   outtextxy (5,70, 'can always toggle your mouse on/off during the');
   outtextxy (5,80, 'game. (press "T")');
   outtextxy (5,90,'  The unavoidable bug that temporarily froze');
   outtextxy (5,100,'the game when explosions off screen occured');
   outtextxy (5,110,'was corrected.');
   outtextxy (5,130,' To exit helicopter without ejecting : land');
   outtextxy (5,140,'then press "E". To enter the helicopter : walk');
   outtextxy (5,150,'into it.');
   outtextxy (5,170,' Caps-Lock should be off.  Good Luck!');
   outtextxy (5,160,' Gear must be UP for auto-eject to work.');
   easywait;
  end;

 Procedure SelectDifficulty;
  begin
   repeat
    setgraphmode (2);
    cleardevice;
    setcolor (2);
    settextstyle(2,0,6);
    setbkcolor (8);
    gotoxy(1,8);
    outtextxy (50,70,' Select Game Difficulty:');
    outtextxy (50,85,'  1) WIMP (150 bombs)');
    outtextxy (50,100,'  2) AVERAGE (75 bombs)');
    outtextxy (50,115,'  3) COMMANDO (50 bombs)');
    level := readkey;
    if (level = #27) then halt;
   until (level = '1') or (level = '2') or (level = '3');
  end;  { select mission }

 Procedure roster;
    var
     dummy  : string;
     clr    : integer;
     x      : real; { for error trapping (div by zero) }

  procedure donames;
   var
    loop2 : integer;
   begin
    for loop := 1 to 6 do
    begin
     settextstyle (2,0,4);
     outtextxy (20,30,'1)');
     outtextxy (20,55,'2)');
     outtextxy (20,80,'3)');
     outtextxy (20,105,'4)');
     outtextxy (20,130,'5)');
     outtextxy (20,155,'6)');
     setcolor (1);
     for loop2 := 1 to 15 do
       outtextxy (25+(loop2*6),5+loop*25,pilot[loop].name[loop2]);
     if pilot[loop].status = 'dead' then outtextxy (140,5+loop*25,'D');
     if pilot[loop].status = 'missing' then outtextxy (140,5+loop*25,'M');
     if pilot[loop].status = 'retired' then outtextxy (140,5+loop*25,'R');
     if pilot[loop].status = 'C' then outtextxy (140,5+loop*25,'C');
     outtextxy (160,5+loop*25,pilot[loop].rank);
     str (pilot[loop].totalmissions,dummy);
     outtextxy (220,5+loop*25,dummy);
     if pilot[loop].totalmissions = 0 then x := 0.01
      else x := 0;
     str (pilot[loop].totalscore / (pilot[loop].totalmissions-x):4:2,dummy);
     outtextxy (255,5+loop*25,dummy);
     setfillstyle (1,0);
    end;
   bar (14,178,298,192); { erase old junk }
   outtextxy (20,180,'press ENTER to confirm, F1 to create a new pilot');
  end;   { of donames }

 begin                     { roster }
   reset (infile);
   seek (infile,1);
   read (infile,pilot);
   setgraphmode (3);
   cleardevice;
   setcolor (3);
   rectangle (8,8,300,195);
   setcolor (2);
   outtextxy (10,10,'ROSTER name,rank,missions,aver.score');
   donames;
   pilnum := 1;
   repeat
    keyhit := 'w';  { dummy letter }
    if keypressed then
     begin
      keyhit := readkey;
      setcolor (0);
      rectangle (15,pilnum*25,291,25+pilnum*25); { erase old one }
     end;
    if keyhit = #72 then pilnum := pilnum - 1;
    if keyhit = #80 then pilnum := pilnum + 1;
    if keyhit = #27 then halt;
    if keyhit = #59 then      {  enter name  }
     begin
      with pilot[pilnum] do
       begin
        setcolor (3);
        setfillstyle (1,0);
        bar (15,pilnum*25,291,25+pilnum*25);
        rectangle (15,pilnum*25,291,25+pilnum*25);
        name := '                 ';
        rank := 'Private';
        totalmissions := 0;
        totalscore := 0;
        dmg := 0;
        status := 'alive';
        donames;
        bar (14,178,298,192);
        outtextxy (20,180,'Type name of pilot, then enter.(max 15 letters)');
        counter := 1;
        repeat
         keyhit := readkey;
         if (keyhit = #83) or (keyhit = #75) or (keyhit = #27) or (keyhit = #8) then
          if counter > 1 then
          begin
           setcolor (0);
           counter := counter - 1;
           outtextxy (25+counter*6,pilnum*25+5,name[counter]);
           name[counter] := ' ';
           setcolor (1);
          end;
         if not((keyhit = #83) or (keyhit = #75) or (keyhit = #27) or (keyhit = #8)) then
          begin
           name[counter] := keyhit;
           outtextxy (25+counter*6,pilnum*25+5,keyhit);
           counter := counter + 1;
          end;
        until (keyhit = #13) or (counter = 15);
        keyhit := 'w';
       end;
      setfillstyle (1,0);
      bar (14,178,298,192); { erase old junk }
      outtextxy (20,180,'press ENTER to confirm, F1 to create a new pilot');
     end; { enter name }
    if (keyhit = '1') or (keyhit = '2') or (keyhit = '3') or (keyhit ='4') or (keyhit = '5') or (keyhit = '6') then
     val (keyhit,pilnum,pilnum);
    if pilnum < 1 then pilnum := 1;
    if pilnum > 6 then pilnum := 6;
    if clr = 1 then clr := 2
     else clr := 1;
    setcolor (clr);
    rectangle (15,pilnum*25,291,25+pilnum*25);
    if keyhit = #13 then
     begin
      bar (14,178,298,192);
      if pilot[pilnum].status = 'dead' then outtextxy (20,180,' Sorry he''s dead. Select a living pilot');
      if pilot[pilnum].status = 'missing' then outtextxy (20,180,' Sorry he''s missing in action. Select another');
      if pilot[pilnum].status = 'retired' then outtextxy (20,180,' Sorry he''s retired. Select a different pilot');
      if pilot[pilnum].status = 'C' then outtextxy (20,180,' Sorry he''s contaminated. Select another.');
     end;
   until (keyhit = #13) and (pilot[pilnum].status = 'alive'); { #13 is enter }
   setgraphmode (1);
   pilot[pilnum].totalmissions := pilot[pilnum].totalmissions + 1;
   pil := pilot[pilnum];
   pil.status := 'missing';
   save (pil,pilnum);
   pil.status := 'alive';
 end;

 begin  { of title screen }
  if not (firstgo = 13) then
  repeat
  firstgo := 13;
  cleardevice;
  setgraphmode (2);
  setbkcolor(8);
  setcolor (3);
  settextstyle (2,0,5);
  outtextxy (110,73,'v 2.56');
  outtextxy (100,86,'by Mark Currie');
  outtextxy (90,108,'S)tart');
  outtextxy (90,123,'I)nstructions');
  outtextxy (90,139,'O)ther Info');
  outtextxy (90,153,'P)ractice Mission');
  outtextxy (90,167,'Q)uit');
  settextstyle (2,0,4);
  if MousePresent then
   begin
    outtextxy (90,190,'Mouse Detected.');
    HideMouse;
   end
   else outtextxy (90,190,'No Mouse Detected.');
  setcolor (2);
  settextstyle (2,0,10);
  outtextxy (75,5,'CHOPPER');
  outtextxy (67,40,'COMMANDO'); delay (100);
  outtextxy (76,5,'CHOPPER');
  setcolor (3);
  outtextxy (68,40,'COMMANDO'); delay (100);
  outtextxy (77,5,'CHOPPER');
  setcolor (2);
  outtextxy (69,40,'COMMANDO'); delay (100);
  outtextxy (78,5,'CHOPPER');
  outtextxy (70,40,'COMMANDO'); delay (100);
  keyhit := readkey;
  free := false;
  case keyhit of
   'i','I' : instruct;
   'o','O' : other;
   's','S' : { start } ;
   'q','Q',#27 : begin
             CloseGraph;
             RestoreCrtMode;
             writeln ('Good Bye. Hope you had fun!');
             halt;
             end;
   'p','P' : free := true;
   else keyhit := '~';
  end; { of case }
  until (Upcase(keyhit) = 'S') or (Upcase(keyhit) = 'P');
  if free = false then
   begin
    roster;
    selectdifficulty;
   end;
 end;

Procedure Save(pi:pilottype;pilnum : integer);
 var
  loop   : integer;
 begin
  pilot[pilnum] := pi;
  seek (infile,1);
  write (infile,pilot);
 end;
End.
