// Inventory Room                                                    Version .36   
//******************************************************************************
// In general adding inventory items is a pain in the ass, simply because of the
// necesary steps. The process of adding an item requires edit of multiple files
//   => game.sh 
//      - Add item to inventory list ex. (define INV_CASH 1)
//   => Text 500 
//      - Place description used for look item in same number as defined
//   => Text 501 
//      - Place any miscellaneous interaction responses as needed for item
//   => main.sc
//      - quarter of the way down add the item to inventory list ex. {Cash}
//      - bottom of the script add instance for item ex. (instance {Cash} of Iitem(properties))
//   => This file
//      .1 - Insert if statement to check if item should init
//      .2 - Create the Instance that holds views display information
//      .3 - Unload the item cursors in doit method to preserve memory space
//      .4 - Add click on information for each item depending on cursor
//      .5 - Decide if item is droppable and declare it in the droppable switch
//      .6 - add call in click on trash to switch cel to 0 when item is dropped
//   => Create cursor image, numbered the same as item number
//   => View 500 (4 images) in the inventories view sets, => icon width = 25, height = 20
//      - Add item menu unhighlighted view to loop 0 where cel the same as item number
//      - Add item menu highlighted view to loop 1 where cel the same as item number
//      - Add item icon view to loop 8 where cel the same as item number
//      - Add item look view to loop 9 where cel the same as item number
//******************************************************************************
(include "sci.sh")(include "game.sh")                               (script 500)
//******************************************************************************
(use "main")(use "controls")(use "game")(use "feature")(use "obj")
//******************************************************************************
(local
    allowTalk = FALSE     // Can your players talk to items if they want
    allowTrash = FALSE    // Can your players drop items if they want
    allowHelp = TRUE     // Is the help button available
    allowInvblock = TRUE // Do you want the selected item block
     
    placeMenuX = 99      // the x position of first menu button
    placeMenuY = 52      // the y position of menu buttons   
    spacerMenuX = 28     // the width of your standard buttons
    sizeMenublock = 38   // the width of your menu block button
	                         
    firstItemX = 52      // the x position of first row of items
	firstItemY = 81      // the y position of first row of items
    spacerItemX = 30     // the amount the x position changes from item to item
    spacerItemY = 25     // the amount the y position changes from row to row
    maxItemX = 240       // the maximum x position before starting new row of items
    newItemX = 0         // the x variable that changes to place our items, sets itsef
    newItemY = 0         // the y variable that changes to place our items, sets itsef

    inv_mode = TRUE      // keeps our doit method from dumping us from room yet
    started_up = FALSE   // used solely to change cursor upon loading - see doit method
    spacerMenublock = 0  // extra space needed to place menu block button, it will set itself later
    txtstring[50]        // used to display and update any amount variables
    dropAble = 0         // Is an Item droppable - set in droppable section (5,6)    
    )
(instance public rm500 of Rm
(properties)


  (method (init)
  DrawPic(500 dpOPEN_INSTANTLY dpNO_CLEAR) 	
  (super:init())
      = spacerMenublock (/ (- sizeMenublock spacerMenuX) 2)// actually decides space needed
      = newItemX firstItemX // prepares our first x position
      = newItemY firstItemY // prepares our first y position
	  
        // init and place menu buttons you want based off local variables
        (lookInv:setPri(15)init())                 // start off screen
     	(lookInv: x (placeMenuX) y (placeMenuY))    // move it onscreen
      	+= placeMenuX spacerMenuX                  // prepare next position

        (useInv:setPri(15)init())
      	(useInv: x (placeMenuX) y (placeMenuY))
      	+= placeMenuX spacerMenuX 

        (if(== allowTalk TRUE)
          (talkInv:setPri(15)init())
          (talkInv: x (placeMenuX) y (placeMenuY))
          += placeMenuX spacerMenuX 	  
        )
	    	
        (if(== allowInvblock TRUE)
          += placeMenuX spacerMenublock // needs a hair more space if used	
          (if(== itemIcon 900)          // nothing yet, got used, or dumped
            (itemInv:setPri(15)cel(0)init())
            (itemInv: x (placeMenuX) y (placeMenuY))
            += placeMenuX spacerMenuX)
          (else                         // display selected item
            (itemInv:setPri(15)cel(itemIcon)init())
            (itemInv: x (placeMenuX) y (placeMenuY))
            += placeMenuX spacerMenuX)
          += placeMenuX spacerMenublock // and some more space here too
        )
	        
        (if(== allowTrash TRUE)          
          (dumpInv:setPri(15)init())
          (dumpInv: x (placeMenuX) y (placeMenuY))
          += placeMenuX spacerMenuX
        )
	    
        (if(== allowHelp TRUE)
          (helpInv:setPri(15)init())
          (helpInv: x (placeMenuX) y (placeMenuY))
          += placeMenuX spacerMenuX
        )
	    	  
        (okInv:setPri(15)init())
        (okInv: x (placeMenuX) y (placeMenuY))
        += placeMenuX spacerMenuX
   
//******************************************************************************
// 1.                                      Check for all inventory items to init
//******************************************************************************
/* To add new item, copy and paste this, Then change the ### to the item's number
********************************************************************************
    (if(send gEgo:has(###))(inventory###:init())
      (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
  	  (inventory###: x (newItemX) y (newItemY))   += newItemX spacerItemX)	  
*******************************************************************************/

  (if(> totalcash 0)(inventory1:setPri(15)init())         // we only have cash if its more than 0
  	(if(>= newItemX maxItemX)               // checks our x position, if at the end of row 
  	 += newItemY spacerItemY                // drop down to the next one by changing y
  	 = newItemX firstItemX                  // and start over at first x position
	)                                       // do this check in each & every items init
	(inventory1: x (newItemX) y (newItemY)) // now, place the thumbnail 
	+= newItemX spacerItemX                 // ready next x position
  )// ends cash item

  (if(send gEgo:has(2))(inventory2:setPri(15)init())
    (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
	  (inventory2: x (newItemX) y (newItemY))   += newItemX spacerItemX)

  (if(send gEgo:has(3))(inventory3:setPri(15)init())
    (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
	  (inventory3: x (newItemX) y (newItemY))   += newItemX spacerItemX)

  (if(send gEgo:has(4))(inventory4:setPri(15)init())
    (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
	  (inventory4: x (newItemX) y (newItemY))   += newItemX spacerItemX)

  (if(send gEgo:has(5))(inventory5:setPri(15)init())
    (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
	  (inventory5: x (newItemX) y (newItemY))   += newItemX spacerItemX)
	  
  (if(send gEgo:has(6))(inventory6:setPri(15)init())
    (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
	  (inventory6: x (newItemX) y (newItemY))   += newItemX spacerItemX)
	  
  (if(send gEgo:has(7))(inventory7:setPri(15)init())
    (if(>= newItemX maxItemX) += newItemY spacerItemY = newItemX firstItemX)
	  (inventory7: x (newItemX) y (newItemY))   += newItemX spacerItemX)	  	  
//******************************************************************************
  (self:setScript(RoomScript))
  )// ends method (init)
)// ends instance public

//******************************************************************************
// 2.                              Create Instances for all inventory items here
//******************************************************************************
/* To add new item, copy and paste this, Then change the ### to the item's number
********************************************************************************
(instance inventory### of Prop(properties view 500 loop 9 cel ### x 400 y 400))
*******************************************************************************/
(instance inventory1 of Prop(properties view 500 loop 9 cel 1 x 400 y 400))// cash
(instance inventory2 of Prop(properties view 500 loop 9 cel 2 x 400 y 400))// balloon
(instance inventory3 of Prop(properties view 500 loop 9 cel 3 x 400 y 400))// string
(instance inventory4 of Prop(properties view 500 loop 9 cel 4 x 400 y 400))// balloon on a string
(instance inventory5 of Prop(properties view 500 loop 9 cel 5 x 400 y 400))// poster
(instance inventory6 of Prop(properties view 500 loop 9 cel 6 x 400 y 400))// cotton candy
(instance inventory7 of Prop(properties view 500 loop 9 cel 7 x 400 y 400))// peanuts

//******************************************************************************
(instance RoomScript of Script
(properties)
  (method (doit)
  (super:doit())  
    (if(== started_up FALSE)           // When we first get here, we want to switch cursors
    	(if(== gCurrentCursor itemIcon)// Unless its an item
    	= started_up TRUE              // let em keep that cursor
		)
		(else	
        = gCurrentCursor 995      // Change our global variable first
        SetCursor(995 HaveMouse())// Now change cursor to the hand, Sierra does the arrow
        = started_up TRUE         // Now we change started_up so this doesnt keep happening
		)
    )   
    (if(== started_up TRUE)   // Depending on which cursor, highlight button
     (switch(gCurrentCursor)  // look, get, talk, or selected item
        (case itemIcon        // check our item selected
        	 (if(== itemIcon 900) // if no item selected
			 )	                  // do nothing
        	 (else	
        	 	(talkInv:cel(0)) (lookInv:cel(0)) (useInv:cel(0)) (itemInv:loop(1) cel(itemIcon)) 
        	 )
		)	
        (case 995  (talkInv:cel(0)) (lookInv:cel(0)) (useInv:cel(1)) (itemInv:loop(0)) )// hand
        (case 998  (talkInv:cel(0)) (lookInv:cel(1)) (useInv:cel(0)) (itemInv:loop(0)) )// look
        (case 996  (talkInv:cel(1)) (lookInv:cel(0)) (useInv:cel(0)) (itemInv:loop(0)) )// talk
       ) // ends switch         
    )
(if(== inv_mode FALSE)                  // Decides When to switch back to last room
      (if(not(== gCurrentCursor itemIcon))  // If no item selected
      SetCursor(gPreviousCursor HaveMouse())// revert back to previous cursor
      = gCurrentCursor gPreviousCursor      // make it happen
      )
    UnLoad(rsPIC scriptNumber)              // In order to get all our memory back that we
    UnLoad(rsSCRIPT scriptNumber)           // used by coming here, lets go ahead and UnLoad
    UnLoad(rsTEXT scriptNumber)             // all of the resources we utilised
    UnLoad(rsVIEW scriptNumber)            // All Inventory views 
    UnLoad(rsTEXT scriptNumber)            // Inventory Descriptions
    UnLoad(rsTEXT 501)            // Inventory Instructions, help and other misc.
    UnLoad(rsCURSOR 998)          // look cursor
    UnLoad(rsCURSOR 997)          // loading cursor
    UnLoad(rsCURSOR 996)          // talk cursor    
    UnLoad(rsCURSOR 995)          // get cursor
//******************************************************************************
// 3.                                 Unload all possible Inventory Cursors here
//******************************************************************************
    UnLoad(rsCURSOR 001)          // the number corresponds to item #
    UnLoad(rsCURSOR 002)
    UnLoad(rsCURSOR 003)
    UnLoad(rsCURSOR 004)
    UnLoad(rsCURSOR 005)
    UnLoad(rsCURSOR 006)
    UnLoad(rsCURSOR 007)
    
//******************************************************************************
    (send gRoom:newRoom(gPreviousRoomNumber)) // go back to room we came from
    ) // ends if inv_mode FALSE
  ) // end method (doit)
  
(method (handleEvent pEvent)
  (super:handleEvent(pEvent))
    (if(==(send pEvent:type())evMOUSEBUTTON)
     (if(& (send pEvent:modifiers) emRIGHT_BUTTON)// handles the mouses right clicks
       (send pEvent:claimed(TRUE))                // used solely to cycle through cursor
       (switch(gCurrentCursor)                    // options mainly look, get, last item
        (case itemIcon  SetCursor(998 HaveMouse()) = gCurrentCursor 998)    // change item to eye
        (case 998 SetCursor(995 HaveMouse()) = gCurrentCursor 995)          // change eye to hand
        (case 995 
          (if(== allowTalk TRUE)
		  SetCursor(996 HaveMouse()) = gCurrentCursor 996 // change hand to mouth
		  )	
		  (else
		      (if(== itemIcon 900) // no item selected
			  SetCursor(998 HaveMouse()) = gCurrentCursor 998 // change hand to eye
			  )
			  (else
			  SetCursor(itemIcon HaveMouse()) = gCurrentCursor itemIcon // change hand to item
        	  )
		  )	  
		)
		(case 996
			(if(== itemIcon 900) // no item selected
			  SetCursor(998 HaveMouse()) = gCurrentCursor 998 // change mouth to eye
			  )
			  (else
			  SetCursor(itemIcon HaveMouse()) = gCurrentCursor itemIcon // change mouth to item
        	  )
		)
       ) // ends switch
     ) // ends if right buton

      (if(not(& (send pEvent:modifiers) emRIGHT_BUTTON))// handles the mouses left clicks
//******************************************************************************
// 4.                           Create Interactions for all inventory items here
//******************************************************************************
   (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
   //  *****************************************  item 1 - Cash 
   (if((> (send pEvent:x)(inventory1:nsLeft))and
      (< (send pEvent:x) (inventory1:nsRight))and
      (> (send pEvent:y) (inventory1:nsTop))and
      (< (send pEvent:y) (inventory1:nsBottom)))
      (switch(inventory1:cel)
      	(case 0 )// cel 0 means its been dropped, do nothing
        (case 1 // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Format(@txtstring 500 1 totalcash)
                Print(@txtstring totalcash #title "Money" #icon 500 8 1 #time 15 ))
            (case 995 // get
                SetCursor(001 HaveMouse())
                = gCurrentCursor 001
                = itemIcon 1)
            (case 996  // talk
            	Print(501 15))
            (case 1 // cash
                Print(501 7)
                Print(501 8))
            (default  Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case  
     )// end inventory cel switch
   )// ends click on cash view

   // ****************************************  item 2 - balloon
   (if((> (send pEvent:x)(inventory2:nsLeft))and
      (< (send pEvent:x) (inventory2:nsRight))and
      (> (send pEvent:y) (inventory2:nsTop))and
      (< (send pEvent:y) (inventory2:nsBottom)))
      (switch(inventory2:cel)
      	(case 0 )// cel 0 means its been dropped
      	(case 2  // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 2 #title "Balloon" #icon 500 8 2 #time 15 ))
            (case 995 // get
                SetCursor(002 HaveMouse())
                = itemIcon 002
                = gCurrentCursor 002)
            (case 996 // talk
            	Print(501 15))
            (case 003 // string
                Print(501 14)
                SetCursor(004 HaveMouse())
                = itemIcon 004
                = gCurrentCursor 004
                (inventory3:cel(0))// remove string from thumbs
                (inventory2:cel(4))// change ballon thumb to balloon on a sring
                (send gEgo:put(2))// drop balloon
                (send gEgo:put(3))// drop string
                (send gEgo:get(4))// get balloon on a string
                (send gGame:changeScore(1))
                )
            (case 002  Print(500 0)) // itself                
            (default  Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case
		(case 4 // its already been turned into a balloon with a string this visit 
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 4 #title "Balloon on a String" #icon 500 8 4 #time 15 ))
            (case 995 // get
                SetCursor(004 HaveMouse())
                = itemIcon 004
                = gCurrentCursor 004)
            (case 996  // talk
            	Print(501 15))
            (case 004 Print(500 0)) // itself                
            (default  Print(501 10)) // other items               
		  )// end current cursor switch
		)// end its a ballon on a string case 
     )// end inventory cel switch
   )// ends click on view

   // ****************************************  item 3 - string
   (if((> (send pEvent:x)(inventory3:nsLeft))and
      (< (send pEvent:x) (inventory3:nsRight))and
      (> (send pEvent:y) (inventory3:nsTop))and
      (< (send pEvent:y) (inventory3:nsBottom)))
      (switch(inventory3:cel)
      	(case 0 )// cel 0 means its been dropped
      	(case 3  // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 3 #title "String" #icon 500 8 3 #time 15 ))
            (case 995 // get
                SetCursor(003 HaveMouse())
                = itemIcon 003
                = gCurrentCursor 003)
            (case 996 // talk
            	Print(501 15))
            (case 002 // balloon
                Print(501 14)
                SetCursor(004 HaveMouse())
                = itemIcon 004
                = gCurrentCursor 004
                (inventory3:cel(4))// change string thumb to balloon on a sring
                (inventory2:cel(0))// reove balloon from thumbs 
                (send gEgo:put(2))// drop balloon
                (send gEgo:put(3))// drop string
                (send gEgo:get(4))// get balloon on a string
                (send gGame:changeScore(1))
                )
            (case 003 Print(500 0)) // itself                
            (default Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case
		(case 4 // its already been turned into a balloon with a string this visit 
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 4 #title "Balloon on a String" #icon 500 8 4 #time 15 ))
            (case 995 // get
                SetCursor(004 HaveMouse())
                = itemIcon 004
                = gCurrentCursor 004)
            (case 996 // talk
            	Print(501 15))
            (case 004 Print(500 0)) // itself                
            (default Print(501 10)) // other items               
		  )// end current cursor switch
		)// end its a ballon on a string case 
     )// end inventory cel switch
   )// ends click on view
   
   // ****************************************  item 4 - string on a balloon
   (if((> (send pEvent:x)(inventory4:nsLeft))and
      (< (send pEvent:x) (inventory4:nsRight))and
      (> (send pEvent:y) (inventory4:nsTop))and
      (< (send pEvent:y) (inventory4:nsBottom)))
      (switch(inventory4:cel)
      	(case 0 )// cel 0 means its been dropped
      	(case 4  // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 4 #title "String on a Balloon" #icon 500 8 4 #time 15 ))
            (case 995 // get
                SetCursor(004 HaveMouse())
                = itemIcon 004
                = gCurrentCursor 004)
            (case 996 // talk
            	Print(501 15))
            (case 004 Print(500 0)) // itself                
            (default Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case
     )// end inventory cel switch
   )// ends click on view   
   // ****************************************  item 5 - poster
   (if((> (send pEvent:x)(inventory5:nsLeft))and
      (< (send pEvent:x) (inventory5:nsRight))and
      (> (send pEvent:y) (inventory5:nsTop))and
      (< (send pEvent:y) (inventory5:nsBottom)))
      (switch(inventory5:cel)
      	(case 0 )// cel 0 means its been dropped
      	(case 5  // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 5 #title "Circus Poster" #icon 500 8 5 #time 15 ))
            (case 995 // get
                SetCursor(005 HaveMouse())
                = itemIcon 005
                = gCurrentCursor 005)
            (case 996 // talk
            	Print(501 15))
            (case 005 Print(500 0)) // itself                
            (default Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case
     )// end inventory cel switch
   )// ends click on view   
   // ****************************************  item 6 - cotton candy
   (if((> (send pEvent:x)(inventory6:nsLeft))and
      (< (send pEvent:x) (inventory6:nsRight))and
      (> (send pEvent:y) (inventory6:nsTop))and
      (< (send pEvent:y) (inventory6:nsBottom)))
      (switch(inventory6:cel)
      	(case 0 )// cel 0 means its been dropped
      	(case 6  // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 6 #title "Cotton Candy" #icon 500 8 6 #time 15 ))
            (case 995 // get
                SetCursor(006 HaveMouse())
                = itemIcon 006
                = gCurrentCursor 006)
            (case 996 // talk
            	Print(501 15))
            (case 006 Print(500 0)) // itself                
            (default Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case
     )// end inventory cel switch
   )// ends click on view 
   // ****************************************  item 7 - Nuts
   (if((> (send pEvent:x)(inventory7:nsLeft))and
      (< (send pEvent:x) (inventory7:nsRight))and
      (> (send pEvent:y) (inventory7:nsTop))and
      (< (send pEvent:y) (inventory7:nsBottom)))
      (switch(inventory7:cel)
      	(case 0 )// cel 0 means its been dropped
      	(case 7  // its there and waiting
          (switch(gCurrentCursor)
            (case 998 // look
                Print(500 7 #title "Peanuts" #icon 500 8 7 #time 15 ))
            (case 995 // get
                SetCursor(007 HaveMouse())
                = itemIcon 007
                = gCurrentCursor 007)
            (case 996 // talk
            	Print(501 16))
            (case 007 Print(500 0)) // itself                
            (default Print(501 10)) // other items
          )// end current cursor switch
		)// end itself case
     )// end inventory cel switch
   )// ends click on view 
   
   
   
//******************************************************************
// Clicks on the look button
   (if((> (send pEvent:x) (lookInv:nsLeft))and
      (< (send pEvent:x) (lookInv:nsRight))and
      (> (send pEvent:y) (lookInv:nsTop))and
      (< (send pEvent:y) (lookInv:nsBottom)))
     SetCursor(998 HaveMouse())
     = gCurrentCursor 998
   ) // ends if look
   
// clicks on use button
   (if((> (send pEvent:x) (useInv:nsLeft))and
      (< (send pEvent:x) (useInv:nsRight))and
      (> (send pEvent:y) (useInv:nsTop))and
      (< (send pEvent:y) (useInv:nsBottom)))
      SetCursor(995 HaveMouse())
      = gCurrentCursor 995
   ) // ends if use
   
// clicks on talk button
   (if((> (send pEvent:x) (talkInv:nsLeft))and
      (< (send pEvent:x) (talkInv:nsRight))and
      (> (send pEvent:y) (talkInv:nsTop))and
      (< (send pEvent:y) (talkInv:nsBottom)))
      SetCursor(996 HaveMouse())
      = gCurrentCursor 996
   ) // ends if talk
   
// clicks on item button in menu
   (if((> (send pEvent:x) (itemInv:nsLeft))and
      (< (send pEvent:x) (itemInv:nsRight))and
      (> (send pEvent:y) (itemInv:nsTop))and
      (< (send pEvent:y) (itemInv:nsBottom)))
      (if(== itemIcon 900)Print(501 0)) // no item selected
   	  (else	// item is in menu 
       (switch(gCurrentCursor)
        (case 998 // look
                (if(== itemIcon 1) // cash is special because of the variable
                Format(@txtstring 500 1 totalcash)
                Print(@txtstring totalcash #title "Money" #icon 500 8 1 #time 15 )
                )
                (else Print(500 itemIcon #icon 500 8 itemIcon #time 15 ))
        )
        (case 995 // get
                SetCursor(itemIcon HaveMouse())
                = gCurrentCursor itemIcon
        )
        (case 996 Print(501 15))// talk
                
	   )// end swith
	  )// end else item is in menu     
   ) // ends if click on item in menu 
// clicks on trash button
  (if((> (send pEvent:x) (dumpInv:nsLeft))and
       (< (send pEvent:x) (dumpInv:nsRight))and
       (> (send pEvent:y) (dumpInv:nsTop))and
       (< (send pEvent:y) (dumpInv:nsBottom)))
     (switch(gCurrentCursor)
        (case itemIcon
         (switch(itemIcon)
//******************************************************************************
// 5.                            Decide here if items can be dropped 0=no  1=yes
//******************************************************************************
  (case 1 = dropAble 0 ) // not droppable -- cash
  (case 2 = dropAble 1 ) // droppable -- balloon 
  (case 3 = dropAble 1 ) // droppable -- string
  (case 4 = dropAble 1 ) // droppable -- balloon on a string
  (case 5 = dropAble 1 ) // droppable -- poster
  (case 6 = dropAble 1 ) // droppable -- cotton candy
  (case 7 = dropAble 1 ) // droppable -- nuts




       )// end switch
       (switch(dropAble)
         (case 0 Print(501 9)) // not dropable
         (case 1
             (if(Print(501 1 #title "Dump" #font gDefaultFont #button "Positive" 1 #button "No Way" 0))
               (switch(itemIcon)
//******************************************************************************
// 6.                                         Change to cel 0 if item is dropped
//******************************************************************************
  (case 1 (inventory1: cel(0))(send gEgo:put(1)))	
  (case 2 (inventory2: cel(0))(send gEgo:put(2)))
  (case 3 (inventory3: cel(0))(send gEgo:put(3)))             	
  (case 4 (inventory2: cel(0))(send gEgo:put(2))// this might be same visit they made item 4
  	      (inventory3: cel(0))(send gEgo:put(3))// out of item 2 and 3 so lets just drop all 
  	      (inventory4: cel(0))(send gEgo:put(4)))// of those items needed to make item 4 too
  (case 5 (inventory5: cel(0))(send gEgo:put(5))) 
  (case 6 (inventory6: cel(0))(send gEgo:put(6))) 
  (case 7 (inventory7: cel(0))(send gEgo:put(7))) 

 
 
//*****************************************************************************
// Nothing else needs edited -- You are all done!!!!             	
//*****************************************************************************
			   )// end switch
			   // is item they dropped the cursor they brought in
               (if(== gPreviousCursor gCurrentCursor)
                  = gPreviousCursor 999 // if so change old cursor to walking
			   )                        // in case they leave empty handed   
               (send gEgo:put(itemIcon))// dropped it
               SetCursor(995 HaveMouse())
               = gCurrentCursor 995
               = itemIcon 900 // no item selected now               
               (itemInv:cel(0))// change menu block to blank
       		 )// ends click yes, wow they realy dropped something?
             (else )// no, do nothing 
         )
       )// end switch
	)// ends clicks with items
	(case 998 Print(501 11 #title "Trash"))// look
    (case 995 Print(501 12 #title "Trash"))// hand
    (case 996 Print(501 15 #title "Trash"))// talk
   )// ends switch
 )// ends click on trash
 
// clicks on help button
   (if((> (send pEvent:x) (helpInv:nsLeft))and
      (< (send pEvent:x) (helpInv:nsRight))and
      (> (send pEvent:y) (helpInv:nsTop))and
      (< (send pEvent:y) (helpInv:nsBottom)))
      Print(501 2 #title "Inventory Help")  //describes look 
      Print(501 3 #title "Inventory Help")  //describes selecting item
      Print(501 4 #title "Inventory Help")  //describes mixing items
      (if(== allowTrash TRUE)Print(501 5 #title "Inventory Help"))// describes trash
      Print(501 6 #title "Inventory Help")// click on ok to return to game
   )// ends click on help

// clicks on ok button
   (if((> (send pEvent:x) (okInv:nsLeft))and
      (< (send pEvent:x) (okInv:nsRight))and
      (> (send pEvent:y) (okInv:nsTop))and
      (< (send pEvent:y) (okInv:nsBottom)))
      (if(== gCurrentCursor 998)// look cursor
  	      Print(501 13 #title "OK")
      )
      (else  = inv_mode FALSE)) // any other cursor let doit boot us   
   ) // ends click on ok
   
  ) // ends mousebutton
 ) // ends method
) // end instance
//*****************************************************************************
(instance talkInv of Prop(properties x 400 y 400 view 500 loop 4 cel 0))
(instance itemInv of Prop(properties x 400 y 400 view 500 loop 0 cel 0))
(instance lookInv of Prop(properties x 400 y 400 view 500 loop 2 cel 0))
(instance useInv of Prop(properties x 400 y 400 view 500 loop 3 cel 0))
(instance dumpInv of Prop(properties x 400 y 400 view 500 loop 5 cel 0))
(instance helpInv of Prop(properties x 400 y 400 view 500 loop 6 cel 0))
(instance okInv of Prop(properties x 400 y 400 view 500 loop 7 cel 0))
