//******************************************************************************
// PnCMenu.sc
// Contains the script which runs our point and click menu. 
//******************************************************************************
(include "sci.sh")(include "game.sh")                               (script 950)
//******************************************************************************
(use "main")(use "controls")(use "cycle")(use "game")(use "feature")
(use "obj")(use "gauge")
//******************************************************************************
(local
       txtstring[50]        // used to display and update any printed variables
)
//******************************************************************************	
(instance public PnCMenu of Rgn
(properties)
  (method (init)
  (super:init())

  (self:setScript(PnCMenuScript))

  (menuTop:setPri(15)ignoreActors()init())
  (menuBot:setPri(15)ignoreActors()init())
  (helpbutton:setPri(15)ignoreActors()init())
    (switch(menuOption) // depending on which menu was last visible, repeat it 
      (case 0 (menuZero:setPri(15)ignoreActors()cel(1)init())       // action menu button highlight
      	      (menuOne:setPri(15)ignoreActors()cel(2)init())        // system menu button unhighlight
      	      (walkIcon:loop(0)cel(0)setPri(15)ignoreActors()init())//walk
      	      (talkIcon:setPri(15)ignoreActors()init()loop(0))      // talk
      	      (getIcon:loop(0)setPri(15)ignoreActors()init())       // hand
      	      (lookIcon:loop(0)setPri(15)ignoreActors()init())      // look
      	      (actionIcon:loop(0)setPri(15)ignoreActors()init())    // inventory
      	      )// end case 0
      (case 1 (menuZero:setPri(15)ignoreActors()cel(0)init())
      	      (menuOne:setPri(15)ignoreActors()cel(3)init())
      	      (walkIcon:loop(1)cel(0)setPri(15)ignoreActors()init()) // speed/ volume controls
      	      (talkIcon:loop(1)cel(1)setPri(15)ignoreActors()init())       // restart
      	      (getIcon:loop(1)cel(2)setPri(15)ignoreActors()init())        // load game
      	      (lookIcon:loop(1)cel(3)setPri(15)ignoreActors()init())       // save game
      	      (actionIcon:loop(1)cel(4)setPri(15)ignoreActors()init())     // quit
      	      )// end case 1
    )// end menuOption switch
    
  // Now that all of our menu buttons have been inited, 
  // we had better place them in the right spot...
    (switch(pnc_menu_location)
    	(case 0 // left side of screen
    	(menuTop:posn(24 16))
    	(menuZero:posn(14 14))
    	(menuOne:posn(24 14))
    	(helpbutton:posn(34 14))
    	(menuBot:posn(24 182))
        (lookIcon:posn(24 46))
        (getIcon:posn(24 76))
        (talkIcon:posn(24 106))
        (walkIcon:posn(24 136))
        (actionIcon:posn(24 166))
		)
		(case 1 // right side of screen
    	(menuTop:posn(296 16))
    	(menuZero:posn(286 14))
    	(menuOne:posn(296 14))
    	(helpbutton:posn(306 14))
    	(menuBot:posn(296 182))
        (lookIcon:posn(296 46))
        (getIcon:posn(296 76))
        (talkIcon:posn(296 106))
        (walkIcon:posn(296 136))
        (actionIcon:posn(296 166))			
		)   
	)// end menu location switch
  )// end init method
)// end public Instance

(instance PnCMenuScript of Script
(properties)
  (method (doit)
  (super:doit())
    (switch(menuOption)
    (case 0 (menuZero:cel(1))
    	    (menuOne:cel(2))
    	     (if(== gCurrentCursor 999)(walkIcon:loop(0)cel(1)))
    	     (else (walkIcon:loop(0)cel(0)))
    	     (if(== gCurrentCursor 996)(talkIcon:loop(0)cel(3)))
    	     (else (talkIcon:loop(0)cel(2)))
    	     (if(== gCurrentCursor 995)(getIcon:loop(0)cel(5)))
    	     (else (getIcon:loop(0)cel(4)))
    	     (if(== gCurrentCursor 998)(lookIcon:loop(0)cel(7)))
    	     (else (lookIcon:loop(0)cel(6)))
    	     (if(== gCurrentCursor itemIcon)(actionIcon:loop(0)cel(9)))
    	     (else (actionIcon:loop(0)cel(8))))
    (case 1 (menuZero:cel(0))
    	    (menuOne:cel(3))
    	    (walkIcon:loop(1)cel(0))
    	    (talkIcon:loop(1)cel(1))
    	    (getIcon:loop(1)cel(2))
    	    (lookIcon:loop(1)cel(3))
    	    (actionIcon:loop(1)cel(4)))
    )// end switch
  )// end method

  (method (handleEvent pEvent)
  (super:handleEvent(pEvent))
    (if(==(send pEvent:type())evMOUSEBUTTON)
      // handles the mouses right clicks
      (if(& (send pEvent:modifiers) emRIGHT_BUTTON)
       (if(== gProgramControl TRUE)(send pEvent:claimed(TRUE)))// do nuthin
       (else (send pEvent:claimed(TRUE))
        (switch(gCurrentCursor)
         (case itemIcon  SetCursor(999 HaveMouse()) = gCurrentCursor 999)// item to walk
         (case 999 SetCursor(996 HaveMouse()) = gCurrentCursor 996)// walk to talk
         (case 996 SetCursor(995 HaveMouse()) = gCurrentCursor 995)// talk to touch
         (case 995 SetCursor(998 HaveMouse()) = gCurrentCursor 998)// touch to look
         (case 998 (if (== itemIcon 900)
       		     SetCursor(999 HaveMouse()) = gCurrentCursor 999)// look to walk if no item
       		     (else
       		     SetCursor(itemIcon HaveMouse()) = gCurrentCursor itemIcon)// look to item
	     )// end case
        )// end switch
       )// end else
      )// end right button
      // handles the mouses left clicks
      (if(not(& (send pEvent:modifiers) emRIGHT_BUTTON))
       (if(== gProgramControl TRUE)(send pEvent:claimed(TRUE)))// do nuthin
       (else                       // handle the clicks on our menu buttons
       	 (if((>(send pEvent:x) (getIcon:nsLeft))and // hand or restore button
             (< (send pEvent:x) (getIcon:nsRight))and
             (> (send pEvent:y) (getIcon:nsTop))and
             (< (send pEvent:y) (getIcon:nsBottom)))
               (switch(menuOption)
       	         (case 0 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       	                 SetCursor(995 HaveMouse()) = gCurrentCursor 995)
                 (case 1 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
                         (send gGame:restore()))
               )// end switch
       	 )// end click on view
       (else
         (if((>(send pEvent:x) (lookIcon:nsLeft))and
             (< (send pEvent:x) (lookIcon:nsRight))and
       			(> (send pEvent:y) (lookIcon:nsTop))and
       			(< (send pEvent:y) (lookIcon:nsBottom)))
       			(switch(menuOption)
       				(case 0 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       					    SetCursor(998 HaveMouse()) = gCurrentCursor 998)
       			    (case 1 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       			    	    (send gGame:save()))
       			 )// end switch
       		  )// end click on view
       		  
       		  
       (else
         (if((>(send pEvent:x) (talkIcon:nsLeft))and
             (< (send pEvent:x) (talkIcon:nsRight))and
             (> (send pEvent:y) (talkIcon:nsTop))and
             (< (send pEvent:y) (talkIcon:nsBottom)))
       			            (switch(menuOption)
       			              (case 0 // action menu - Talk
       			              	(send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       			              	SetCursor(996 HaveMouse())
       			              	= gCurrentCursor 996
       			              )// end case 0
       			              (case 1  // system menu - restart
       			              	(send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       			              	 (if(Print(950 25 #title "Restart" #font gDefaultFont #button "Restart" 1 #button " Oops " 0))
       			              	 	(send gGame:restart())
       			              	 )// end if
       			              )// end case 1
       			            )// end switch
       			)// end click on view
       (else
         (if((>(send pEvent:x) (walkIcon:nsLeft))and
             (< (send pEvent:x) (walkIcon:nsRight))and
             (> (send pEvent:y) (walkIcon:nsTop))and
             (< (send pEvent:y) (walkIcon:nsBottom)))
       			             (switch(menuOption)
       			               (case 0 // action menu - Walk
       			               	(send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       			               	SetCursor(999 HaveMouse()) 
       			               	= gCurrentCursor 999
       			               )// end case 0
       			               (case 1 // system menu - speed/volume
       			               	(send pEvent:type(evMOUSEBUTTON) claimed(TRUE))  
       			               	= sGauge (Gauge:new()) 
       			               	= vGauge (Gauge:new())  
       			               	= pncSpeed (send sGauge:text("Game Speed")
       			               		     description("Use the mouse or the left and right arrow keys to select the game speed.")
       			               		                    higher(" + ")
       			               		                    lower(" - ")
       			               		                    normal(NORMAL_SPEED)
       			               		                    doit(- 15 gSpeed)
       			               		       )// end sgauge info
       			               	(send gGame:setSpeed(- 15 pncSpeed))
       			               	Wait(30)  
       			               	= pncVolume (send vGauge:text("Sound Volume")
       			                                         description("Use the mouse or the left and right arrow keys to adjust the volume.")
       			                                         higher(" + ")
       			                                         lower(" - ")
       			                                         normal(15)
       			                                         doit(DoSound(sndVOLUME pncVolume))
       			                            )// end vgauge info 
       			               	DoSound(sndVOLUME pncVolume)
       			               )// end case 1
       			             )// end switch
       			)// end click on view
       (else
         (if((>(send pEvent:x) (actionIcon:nsLeft))and
             (< (send pEvent:x) (actionIcon:nsRight))and
             (> (send pEvent:y) (actionIcon:nsTop))and
             (< (send pEvent:y) (actionIcon:nsBottom)))
       		                 (switch(menuOption)
       		                   (case 0 // action menu - Inventory
       		                   	(send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       				             (if(== canTab TRUE)
                                    = gPreviousCursor gCurrentCursor
                                    (send gRoom:newRoom(500))
                                 )
                                 (else Print(950 6))
                               )// end case 0
                               (case 1 // system menu - quit
                               	(send pEvent:type(evMOUSEBUTTON) claimed(TRUE)) 
                               	(if(Print(950 26 #title "Quit"  #font gDefaultFont #button " Quit " 1 #button " Oops " 0))
                               		= gQuitGame TRUE
                               	)
                               )// end case 1
                              )// end switch
            )// end click on view
       (else
         (if((>(send pEvent:x) (menuZero:nsLeft))and // clicks on menu selection - action
             (< (send pEvent:x) (menuZero:nsRight))and
             (> (send pEvent:y) (menuZero:nsTop))and
             (< (send pEvent:y) (menuZero:nsBottom))) 
             = menuOption 0
             (send pEvent:type(evMOUSEBUTTON) claimed(TRUE)) 
       	 )// end click on view
       (else(if((>(send pEvent:x) (menuOne:nsLeft))and // clicks on menu selection - system
       			(< (send pEvent:x) (menuOne:nsRight))and
       			(> (send pEvent:y) (menuOne:nsTop))and
       			(< (send pEvent:y) (menuOne:nsBottom))) 
       			   = menuOption 1 
       			   (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       	    )// end click on view
       (else
       	 (if((>(send pEvent:x) (helpbutton:nsLeft))and
       	 	 (< (send pEvent:x) (helpbutton:nsRight))and
       	 	 (> (send pEvent:y) (helpbutton:nsTop))and
       	 	 (< (send pEvent:y) (helpbutton:nsBottom)))
       	 	 Format(@txtstring 950 0 gGameTitle)
       	 	 Print(@txtstring gGameTitle #title "Help")
       	 	 Print(950 1 #title "Help")
       	 	 Print(950 2 #title "Help")
       	 	 Print(950 3 #title "Help")
       	 	 Print(950 4 #title "Help")
       	 	 Format(@txtstring 950 5 gGameTitle)
       	 	 Print(@txtstring gGameTitle #title "Help")
       	 	 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))
       	 )
//****************************************************************************
//                        Default Action Clicks                                 
//****************************************************************************
// View                                                       // clicks on ego
(else
(if((> (send pEvent:x) (send gEgo:nsLeft))and
	(< (send pEvent:x) (send gEgo:nsRight))and
	(> (send pEvent:y) (send gEgo:nsTop))and
	(< (send pEvent:y) (send gEgo:nsBottom)))
  (switch(gCurrentCursor)
    (case 999 (send pEvent:type(evMOUSEBUTTON) claimed(FALSE))) // walk
    (case 998 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))   // look
    	  (switch(Random(0 2))
    	  	(case 0 Print(950 10))
    	  	(case 1 Print(950 11))
    	  	(case 2 Print(950 12))
    	  )// end random switch
    )// end case look
    (case 996 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))   // talk
    	  (switch(Random(0 2))
    	  	(case 0 Print(950 13))
    	  	(case 1 Print(950 14))
    	  	(case 2 Print(950 15))
    	  )// end random switch
    )// end case talk
    (case 995 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))  // get
    	  (switch(Random(0 2))
    	  	(case 0 Print(950 16))
    	  	(case 1 Print(950 17))
    	  	(case 2 Print(950 18))
    	  )// end random switch
    )// end case get
    (case 004 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))  // balloon on string
    (if (== gRoomNumber 1)
    	(if(== gkidsPresent TRUE) Print(950 7))
    	(else = doBalloon TRUE)
    )
    (else Print(950 7))
    )
    (case 006 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))  // cotton candy
    (if (== eatcandy FALSE)
      Print(950 8)
               = eatcandy TRUE
               (send gEgo:put(6))
      	       SetCursor(995 HaveMouse())
               = gCurrentCursor 995
               = itemIcon 900
      	       (send gGame:changeScore(2))
    )
    (else
     Print(950 9)
     )
    )
    (case 7 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))   // nuts
    	  Print(950 27)
    )// end case nuts
    (default  (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))  // item
    	  (switch(Random(0 2))
    	  	(case 0 Print(950 19))
    	  	(case 1 Print(950 20))
    	  	(case 2 Print(950 21))
    	  )// end random switch
    )// end case item
  ) // end switch
) // end if ego
//****************************************************************************
//                                                            // Room defaults
(else
  (switch(gCurrentCursor)
    (case 999 (send pEvent:type(evMOUSEBUTTON) claimed(FALSE))) // walk
    (case 998 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))Print(gRoomNumber 0))// look
    (case 996 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))Print(gRoomNumber 1))// talk
    (case 995 (send pEvent:type(evMOUSEBUTTON) claimed(TRUE))Print(gRoomNumber 2))// get
    (default  (send pEvent:type(evMOUSEBUTTON) claimed(TRUE)) // items
    	      (switch(Random(0 2))
    	      	(case 0 Print(950 22))
    	      	(case 1 Print(950 23))
    	      	(case 2 Print(950 24))
    	      )// end random switch
    )// end default case
  )// end cursor switch
)// end else room default
//******************************************************************************
                      )// end else ego default 
                    )// end else help button
                  ) // end menuone
                ) // end menuzero
              ) // end action
            ) // end walk
          ) // end talk
        ) // end look
      ) // end get
      )
  ) // end if mousebutton
 )// end method
)// end instance
/******************************************************************************/
(instance menuTop of Prop(properties x 400 y 16 view 950 loop 2 cel 0))
(instance menuZero of Prop(properties x 400 y 14 view 950 loop 4 cel 0))
(instance menuOne of Prop(properties x 400 y 14 view 950 loop 4 cel 1))
(instance helpbutton of Prop(properties x 400 y 14 view 950 loop 4 cel 4))
(instance lookIcon of Prop(properties x 400 y 46 view 950 loop 0 cel 6))
(instance getIcon of Prop(properties x 400 y 76 view 950 loop 0 cel 4))
(instance talkIcon of Prop(properties x 400 y 106 view 950 loop 0 cel 2))
(instance walkIcon of Prop(properties x 400 y 136 view 950 loop 0 cel 1))
(instance actionIcon of Prop(properties x 400 y 166 view 950 loop 0 cel 8))
(instance menuBot of Prop(properties x 400 y 182 view 950 loop 3 cel 0))
//****************************************************************************//
