/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")

(local
gameStart = 0
)
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
        // Set up the title screen
		ProgramControl() 
		= gProgramControl FALSE
		(send gGame:setSpeed(3))
		(SL:disable())
		(TheMenuBar:hide())
		
		(super:init())
		(self:setScript(RoomScript))
		
		(send gEgo:init()hide())
        (logo:init()setCycle(Fwd)cycleSpeed(2))
        (characters:init())

        (send gTheMusic:prevSignal(0)stop()number(20)loop(0)play())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState intro)
        = state intro
        (switch(state)
            (case 0 = cycles 1
            )(case 1 =cycles 30
            )(case 2 = cycles 20
                Display(
                "Presents:"
                dsCOORD 40 85
                dsCOLOUR clMAROON
                dsBACKGROUND clTRANSPARENT
                )
            )(case 3 = cycles 20
                Display(
                "  New Year's"
                dsCOORD 40 120
                dsCOLOUR clBLUE
                dsBACKGROUND clTRANSPARENT
                )
                Display(
                "Mystery"
                dsCOORD 70 135
                dsCOLOUR clBLUE
                dsBACKGROUND clTRANSPARENT
                )
            )(case 4 = cycles 5
            )(case 5 = cycles 1
                = gameStart 1
            )
        )
    )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                (if(gameStart)
				    (send gTheMusic:fade())
                    // End the title screen, start the game
                    (send gRoom:newRoom(INITROOMS_SCRIPT))
                )
		    )
		)
	)
)
(instance logo of Prop
    (properties
    y 75
    x 108
    view 999
    )
)
(instance characters of Prop
    (properties
    y 160
    x 220
    view 998
    )
)
/******************************************************************************/
