/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "jump")
(use "dpath")
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		// same in every script, starts things up
  		(super:init())
        (send gGame:setSpeed(4))
  		(self:setScript(RoomScript))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(default
  				(send gEgo:posn(150 130)loop(1))
  			)
  		)
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:init()hide())

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:prevSignal(0)stop()number(scriptNumber)loop(-1)play())*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState intro)
        = state intro
        (switch(state)
            (case 0 = cycles 1
            )(case 1 = cycles 15
                (ProgramControl)
            )(case 2 = cycles 20
                Print("It's a new year.\n\n"+
                "2007 already! How the years of law school just flew by.")
                Print("At least Gwen invited me to a New Year's party.")
            )(case 3 = cycles 10
                Print("Hmm...")
                Print("Hope the place is nicer on the inside.")
            )(case 4
                (PlayerControl)
                (send gGame:changeScore(1))
                (send gRoom:newRoom(10))
            )
        )
    )
 
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
        //GAME TESTING PURPOSES
        /*(if(Said('jump/1'))
            = roomTenOpening 0
            = roomNineOpening 0
            = chased 0
            = firstKill 1
            = secondKill 1
            = thirdKill 1
            = fourthKill 1
            = finalKills 1
            = gameComplete 1
            (send gRoom:newRoom(100))
        )*/
 	)
)
/******************************************************************************/
