/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 9)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "follow")

(local
tripped = 0
message = 0
bandaged = 0
)
/******************************************************************************/
(instance public rm009 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:posn(212 67)loop(1))
			)(case 5
                (send gEgo:posn(212 67)loop(2))
            )(case 10
                (send gEgo:posn(40 130)loop(0))
            )(case 13
                (send gEgo:posn(90 67)loop(2))
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (doorA:init())
        (doorB:init())
        (plateA:init())
        (plateB:init())
        (glassA:init()loop(1))
        (glassB:init()loop(1))
        (if(not(fourthKill))
            (pitcher:init()setPri(17))
            (skillet:init()setPri(17))
        )
        (if(chased)
            (oven:init()cel(1))
        )(else
            (oven:init()cel(0))
            (if(thirdKill)
                (table:init())
                (send gEgo:observeControl(ctlBLUE))
            )
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
 
    (method (changeState intro)
        (var dyingScript)
        = state intro
        (switch(state)
            (case 0 = cycles 1
            )(case 1 = cycles 7
                (if(roomNineOpening)
                    (gwen:init()setCycle(Walk)setMotion(MoveTo 115 95))
                    (ProgramControl)
                )(else
                    (if(chased)
                        (ProgramControl)
                        (send gEgo:setMotion(MoveTo 200 80))
                    )(else
                        (if(thirdKill)
                            (if(not(fourthKill))
                                (gwen:init()posn(90 75))
                            )(else
                                (if(finalKills)
                                    (RoomScript:changeState(16))
                                )
                            )
                        )
                    )
                )
            )(case 2 = cycles 7
                (if(roomNineOpening)
                    (send gEgo:setMotion(MoveTo 115 120))
                    Print("How about that doctor!"#title "Gwen says")
                    Print("You know he's got to be rich! I mean what could he possibly spend all his money on?"#title "Gwen says")
                )(else
                    (if(firstKill)
                        (if(not(secondKill))
                            Print("Where did Gwen go?")
                        )(else
                            (if(chased)
                                (doctor:init()setCycle(Walk)setMotion(MoveTo 150 80))
                            )(else
                                (if(thirdKill)
                                    (if(not(fourthKill))
                                        Print("You killed the doctor!")
                                    )
                                )
                            )
                        )
                    )
                )
            )(case 3 = cycles 5
                (if(roomNineOpening)
                    Print("I can only guess he should be spending on you, Gwen."#title "You say")
                )(else
                    (if(firstKill)
                        (if(not(secondKill))
                            Print("Sounds like everyone's gathered in the main room.")
                            (send gEgo:setMotion(MoveTo 30 180))
                        )(else
                            (if(thirdKill)
                                (if(not(fourthKill))
                                    (ProgramControl)
                                    Print("You were so jealous of me you killed him!")
                                    (gwen:setCycle(Walk)setMotion(MoveTo 220 85))
                                    (send gEgo:setMotion(MoveTo 330 160))
                                    (RoomScript:changeState(8))
                                    (send gGame:changeScore(1))
                                )
                            )
                        )
                    )
                )
            )(case 4 = cycles 30
                (if(roomNineOpening)
                    Print("Of course. I am exactly what he needs!"#title "Gwen says")
                    (gwen:setCycle(Walk)setMotion(MoveTo 120 100 RoomScript))
                )(else
                    (if(firstKill)
                        (if(not(secondKill))
                            (send gRoom:newRoom(100))
                        )
                    )
                )
            )(case 5 = cycles 5
                (if(roomNineOpening)
                    (gwen:view(320)loop(2)cel(0)setCycle(End))
                    (send gEgo:loop(3))
                )(else
                    (if(chased)
                        (send gRoom:newRoom(5))
                    )
                )
            )(case 6 = cycles 5
                (if(roomNineOpening)
                    (ShakeScreen(2))
                )
            )(case 7
                (if(roomNineOpening)
                    Print("Are you alright Gwen?"#title "You ask")
                    Print("Yeah. When this floor is wet, I have a hard time not slipping."#title "Gwen says")
                    Print("Could you do me a favor and get me the first aid kit from the bathroom? I think I cut my hand. It's the door on the right."#title "Gwen says")
                    = tripped 1
                    = roomNineOpening 0
                    (PlayerControl)
                )
            )(case 8 = cycles 35
                (send gEgo:setMotion(MoveTo 330 160))
            )(case 9 = cycles 30
                (PlayerControl)
                Print("Man, Gwen's gone nuts! She is going to kill me. I need to stop her.")
                (gwen:setMotion(MoveTo 280 110)ignoreControl(ctlWHITE))
            )(case 10 = cycles 25
                (gwen:setMotion(MoveTo 270 145))
            )(case 11
                (gwen:setMotion(Follow gEgo))
            )(case 12 = cycles 10
                (gwen:setMotion(MoveTo 225 157))
                (send gEgo:setMotion(MoveTo 170 147))
            )(case 13 = cycles 3
                (gwen:view(320)loop(3)cel(0)setCycle(End))
                (send gEgo:loop(0))
            )(case 14 = cycles 6
                (skillet:setMotion(MoveTo 236 200)ignoreControl(ctlWHITE))
                (ShakeScreen(2))
            )(case 15
                (ShakeScreen(2))
                (skillet:hide())
                (gwen:loop(4)cel(0)setCycle(End)cycleSpeed(2))
                (send gGame:changeScore(3))
            )(case 16 = cycles 25
                (if(shot)
                    (if(not(bandaged))
                        Print("You've been shot in the arm, you better do something quick.")
                    )
                )
            )(case 17
                (if(not(bandaged))
                    ProgramControl()
                    = dyingScript ScriptID(DYING_SCRIPT)
                    (send dyingScript:caller()register("Too much blood loss and you fainted. Whoever's out there killed ya."))
                    (send gGame:setScript(dyingScript))
                )(else
                    Print("You hear the voices in the main room.")
                    (send gRoom:newRoom(100))
                    
                )
            )
        )
    )
 
    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        (if(Said('look>'))
            (if(Said('/cabinet'))
                Print("It's a cabinet all right. Some nice china in there, but not anything I care too much about.")
            )(if(Said('/cupboard,pantry'))
                Print("Look like they are loaded with food. I think may have just gained five pounds by looking at all that food!")
            )(if(Said('/painting'))
                Print("I think the only fruit here is in the painting.")
            )(if(Said('/woman,gwen'))
                (if(not(firstKill))
                    Print("Gwen is on the floor. I should really teach her one day how to walk in stilettos.")
                )
            )(if(Said('/rug,carpet'))
                Print("What do you want me to do, vacuum?")
            )(if(Said('/floor'))
                Print("Someone must have cleaned this floor with butter if it's that slick.")
            )(if(Said('/oven'))
                Print("Smells like Gwen is cooking some apple pie. She may be bad with men, but she is good with food.")
                Print("How that's possible only God knows!")
            )(if(Said('/desk,paper,table'))
                Print("On the table there is a piece of paper.")
                Print("It is actually the butler's resume!")
                Print("Alfred T. Butler. No surprises about this guys line of work.")
            )(if(Said('/stove,skillet,pan'))
                Print("Looks like a pretty large stove with those insanely heavy cast-iron skillets on it. Last time I tried to clean one of those, I think my arm broke!")
            )(if(Said('/counter, water, pitcher'))
                Print("On the counter there is a cutting board and a pitcher of water.")
            )(if(Said('around'))
                Print("Definately the kitchen. Very clean too! Floor tiles are obviously slippery when wet. They might think of investing in some of those orange 'piso majado' cones.")
            )(if(Said('/anyword'))
                Print("Nah, I have no interest in stuff like that.")
            )(if(Said('[ /* , !* ]'))
                Print("Definately the kitchen. Very clean too! Floor tiles are obviously slippery when wet. They might think of investing in some of those orange 'piso majado' cones.")
            )
        )

        (if(Said('open/door'))
            (if(<=(send gEgo:distanceTo(doorA))25)
                (if(not(tripped))
                    (if(thirdKill)
                        (if(not(send gEgo:has(4)))
                            Print("I don't feel safe at all. I should find the gun before I go in here.")
                        )(else
                            (doorA:setCycle(End)cycleSpeed(2)ignoreActors())
                        )
                    )(else
                        (doorA:setCycle(End)cycleSpeed(2)ignoreActors())
                    )
                )(else
                    Print("You should get Gwen her bandages before walking off.")
                )
            )(else
                (if(<=(send gEgo:distanceTo(doorB))25)
                    (doorB:setCycle(End)cycleSpeed(2)ignoreActors())
                )(else
                    Print("You're not close enough.")
                )
            )
        )
        
        (if(Said('take,pick>'))
            (if(Said('/food'))
                Print("No thanks. Just looking at it make me feel fat.")
            )(if(Said('/pan,skillet'))
                Print("It's too heavy to use for anything.")
            )(if(Said('/water'))
                Print("What do you want to do with it?")
            )
        )
        (if(Said('open/cabinet'))
            Print("That stuff is nice, but I can see it through the glass. No need to open it.")
        )
        (if(Said('break/glass'))
            Print("I really don't need to break through the glass to see in. Glass is transparent, remember?")
        )
        (if(Said('turn/stove'))
            Print("Nah. I would rather pick up a burger at 'Le Burger', the best french burgers in town.")
        )
        
        (if(Said('spill,drop,use,throw,pour/water,pitcher'))
            (if(thirdKill)
                (if(<=(send gEgo:distanceTo(pitcher))50)
                    Print("You spill the water on the ground just as Gwen comes near.")
                    = fourthKill 1
                    (pitcher:hide())
                    (RoomScript:changeState(12))
                )(else
                    (PrintNotCloseEnough)
                )
            )(else
                Print("Why would you do that?")
            )
        )
        
        (if(Said('use,wrap/arm,bandage,kit'))
            (if(shot)
                (if(not(gameComplete))
                    Print("You bandage your arm and save yourself from dying.")
                    = bandaged 1
                    = gameComplete 1
                    (send gGame:changeScore(4))
                )(else
                    Print("You did that already.")
                )
            )(else
                Print("Why bother?")
            )
        )
    )
    (method (doit)
        (var dyingScript)
        (super:doit)
        (if(<=(send gEgo:distanceTo(gwen))25)
            (if(thirdKill)
                (if(not(fourthKill))
                    ProgramControl()
                    = dyingScript ScriptID(DYING_SCRIPT)
                    (send dyingScript:caller()register("She's a slick one with that table. Mayne next time you can be just as slick as she is."))
                    (send gGame:setScript(dyingScript))
                )
            )
        )
        (if(== (send gEgo: onControl()) ctlSILVER)
            (send gRoom:newRoom(5))
        )
        (if(== (send gEgo: onControl()) ctlGREY)
            (send gRoom:newRoom(13))
        )
        (if(== (send gEgo: onControl()) ctlMAROON)
            (if(gameComplete)
                (send gRoom:newRoom(100))
            )(else
                (if(not(tripped))
                    (send gRoom:newRoom(10))
                )(else
                    (if(not(message))
                        Print("You should get Gwen her bandages before walking off.")
                        = message 1
                    )
                )
            )
        )
    )
)

(instance doctor of Act
    (properties
    y 120
    x 20
    view 306
    )
)
(instance gwen of Act
    (properties
    y 120
    x 50
    view 302
    )
)
(instance oven of Prop
    (properties
    y 49
    x 262
    view 6
    )
)
(instance doorA of Prop
    (properties
    y 59
    x 92
    view 202
    )
)
(instance doorB of Prop
    (properties
    y 59
    x 211
    view 202
    )
)
(instance plateA of Prop
    (properties
    y 48
    x 128
    view 7
    )
)
(instance plateB of Prop
    (properties
    y 48
    x 142
    view 7
    )
)
(instance glassA of Prop
    (properties
    y 37
    x 128
    view 7
    )
)(instance glassB of Prop
    (properties
    y 37
    x 142
    view 7
    )
)(instance pitcher of Prop
    (properties
    y 151
    x 181
    view 15
    )
)(instance skillet of Act
    (properties
    y 122
    x 236
    view 16
    )
)(instance table of Prop
    (properties
    y 160
    x 125
    view 17
    )
)
/******************************************************************************/
