/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 13)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "follow")

(local
candleLit = 0
talkToPops = 0
dontLeave = 0
message = 0
)
/******************************************************************************/
(instance public rm013 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:posn(220 150)loop(1))
			)(case 9
                (send gEgo:posn(243 163)loop(3))
            )(case 10
                (send gEgo:posn(55 150)loop(0))
            )
		)

		SetUpEgo()
        (if(send gEgo:has(4))
            (send gEgo:init())
            (candleA:init()loop(0)setCycle(Fwd)cycleSpeed(1))
            (candleB:init()loop(0)setCycle(Fwd)cycleSpeed(1))
            (chair:init()setPri(4)loop(1))
            (jennifer:init()view(131)posn(220 160))
        )(else
            (send gEgo:init())
            (candleA:init()loop(2)setCycle(Fwd)cycleSpeed(1))
            (candleB:init()loop(1))
            (if(not(thirdKill))
                (if(firstKill)
                    (gwen:init()loop(1))
                    (doctor:init()loop(0))
                    (pops:init()loop(2))
                    (jennifer:init()loop(1))
                    (chair:init()setPri(4))
                )
            )
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState intro)
        = state intro
        (switch(state)
            (case 0 = cycles 1
            )(case 1 = cycles 12
                (if(send gEgo:has(4))
                    (RoomScript:changeState(12))
                )
            )(case 2 = cycles 8
                (if(firstKill)
                    Print("This is really, really, bad. My pistol is not in the drawer."#title"Mr Vince says")
                    = dontLeave 1
                )(else
                    (RoomScript:changeState(50))
                )
            )(case 3
                Print("If we all just stick together, we will be okay until the police come."#title"Mr Vince says")
            )(case 5 = cycles 30
                (ProgramControl)
            )(case 6 = cycles 10
                Print("Oh my gosh! Do you smell something burning? I left my pies in the oven!"#title"Gwen says")
            )(case 7 = cycles 10
                (gwen:setCycle(Walk)setMotion(MoveTo 235 180))
                (pops:setCycle(Walk)setMotion(MoveTo 240 70)ignoreControl(ctlWHITE))
                (jennifer:setCycle(Walk)setMotion(MoveTo 235 60)ignoreControl(ctlWHITE))
                (doctor:setCycle(Walk)setMotion(MoveTo 205 165)ignoreControl(ctlWHITE))
                (send gEgo:setMotion(MoveTo 60 150))
            )(case 8 = cycles 15
                (pops:setCycle(Walk)setMotion(MoveTo 240 180)ignoreControl(ctlWHITE))
                (jennifer:setCycle(Walk)setMotion(MoveTo 235 180)ignoreControl(ctlWHITE))
            )(case 9 = cycles 23
                (gwen:setCycle(Walk)setMotion(MoveTo 235 180)hide())
                (doctor:loop(3))
            )(case 10 = cycles 12
                (pops:hide())
                (jennifer:hide())
                (doctor:loop(1))
                (send gEgo:loop(0))
            )(case 11
                (PlayerControl)
                (send gGame:changeScore(1))
                Print("Looks like just you and me honey!"#title"Doc says")
                (send gTheMusic:prevSignal(0)stop()number(20)loop(0)play())
                (doctor:setMotion(Follow gEgo)observeControl(ctlWHITE))
                = chased 1
            )(case 12 = cycles 10
            )(case 13 = cycles 20
                (if(not(finalKills))
                    (ProgramControl)
                    Print("Oh my God! They're all dead!")
                    Print("But who killed these two?")
                    Print("Is there someone still here?")
                    = finalKills 1
                )
            )(case 14 = cycles 6
                (ShakeScreen(2))
            )(case 15 = cycles 7
                Print("Someone is hiding in the room and shot you in the arm!")
                = shot 1
                (send gGame:changeScore(2))
            )(case 16
                (send gRoom:newRoom(9))
            )

        )
    )
    
    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        (if(Said('look>'))
            (if(Said('/man'))
                Print("Mr Vince is staring blankly at his desk in disbelief and the doctor is talking to Gwen.")
                Print("Well, he's probably not the one talking though.")
            )(if(Said('/book,shelf'))
                Print("There are many volumes of books, but I am way too distracted even to think about reading.")
            )(if(Said('/desk'))
                Print("A huge desk with a monthly planner on it. Turns out Mr Vince's new year's resolution is to lose that gut.")
            )(if(Said('/woman'))
                Print("Jennifer is very silent. I don't blame her.")
            )(if(Said('/rug'))
                Print("What do you want me to do, vacuum?")
            )(if(Said('/painting,wall'))
                Print("There's nothing too interesting about them.")
            )(if(Said('/candle,table'))
                (if(send gEgo:has(2))
                    (if(candleLit)
                        Print("both candles are lit.")
                    )(else
                        Print("There is an unlit candle on the table.")
                    )
                )(else
                    Print("There is a candle-lighter on one table and an unlit candle on another.")
                )
            )(if(Said('around'))
                Print("This is the study of Mr Vince. He has a good number of books, a nice desk, but unfortunately someone stole his gun.")
            )(if(Said('/anyword'))
                Print("Maybe you want to look at that, but I don't.")
            )(if(Said('[ /* , !* ]'))
                Print("This is the study of Mr Vince. He has a good number of books, a nice desk, but unfortunately someone stole his gun.")
            )
        )
            
        (if(Said('take,pick>'))
            (if(Said('/lighter'))
                (if(firstKill)
                    (if(send gEgo:has(2))
                        Print("You already have it.")
                    )(else
                        (if(<=(send gEgo:distanceTo(candleA))25)
                            (send gEgo:get(2))
                            (send gGame:changeScore(2))
                            (candleA:loop(0))
                            Print("You take the candle-lighter.")
                        )(else
                            Print("You can't take what you can't reach.")
                        )
                    )
                )(else
                    Print("I'm not that interested right now.")
                )
            )(if(Said('/book'))
                Print("After law school, I've had enough reading. Plus, I don't think this is a good time.")
            )(if(Said('[ /* , !* ]'))
                Print("You really have no use for that.")
            )
        )
        
        (if(Said('talk>'))
            (if(Said('/man,doctor'))
                (if(< (send gEgo:distanceTo(doctor)) 25)
                    Print("I think the killer drugged the butler. But why?"#title "Doc says")
                )(else
                    (if(< (send gEgo:distanceTo(pops)) 25)
                        = talkToPops 1
                        Print("Only my daughter and the butler could've gotten into my desk."#title "Mr Vince says")
                    )(else
                        (PrintNotCloseEnough)
                    )
                )
            )
            (if(Said('/woman,gwen,jennifer'))
                (if(< (send gEgo:distanceTo(gwen)) 25)
                    (if(talkToPops)
                        Print("I certainly didn't take the gun. Maybe the murderer knew the butler had it?"#title"Gwen says")
                    )(else
                        Print("I hope the police show up soon."#title"Gwen says")
                    )
                )(else
                    (if(< (send gEgo:distanceTo(jennifer)) 25)
                        Print("Who would kill Jeff and the doctor? What do they have in common?")
                    )(else
                        (PrintNotCloseEnough)
                    )
                )
            )
        )
            
        (if(Said('light,ignite,use/candle,lighter'))
            (if(<=(send gEgo:distanceTo(candleB))25)
                (if(not(candleLit))
                    Print("No problem.")
                    (candleB:loop(0)setCycle(Fwd)cycleSpeed(1))
                    (RoomScript:changeState(5))
                )(else
                    Print("Been there, done that.")
                )
            )(else
                Print("You don't have a flame-thrower here. Go closer!")
            )
        )
        
        (if(Said('open/door'))
            (if(not(secondKill))
                (send gRoom:newRoom(10))
            )(else
                (if(chased)
                    (send gRoom:newRoom(10))
                )(else
                    Print("You are all supposed to stay together remember?")
                )
            )
        )
        
        (if(Said('sit'))
            Print("Looks comfortable enough...but I'm busy playing a game.")
        )
        //GameTestingPurposes
        //(if(Said('throw/knife'))
            //(RoomScript:changeState(5))
        //)
    )
 
    (method (doit)
        (var dyingScript)
        (super:doit)
        (if(== (send gEgo: onControl()) ctlGREY)
            (if(dontLeave)
                (if(not(message))
                    Print("I shouldn't leave the group right now.")
                    = message 1
                )
            )(else
                (send gRoom:newRoom(9))
            )
        )
        (if(< (send gEgo:distanceTo(doctor)) 25)
            (if(chased)
                ProgramControl()
                = dyingScript ScriptID(DYING_SCRIPT)
                (send dyingScript:caller()register("People are dropping like flies in this place, and you let his guy near you?"))
                (send gGame:setScript(dyingScript))
            )
        )
    )
)
//CharACTERS
(instance jennifer of Act
    (properties
    y 105
    x 170
    view 309
    )
)
(instance gwen of Act
    (properties
    y 120
    x 235
    view 302
    )
)
(instance pops of Act
    (properties
    y 105
    x 140
    view 301
    )
)
(instance doctor of Act
    (properties
    y 120
    x 205
    view 306
    )
)
//Props
(instance candleA of Prop
    (properties
    y 90
    x 270
    view 11
    )
)(instance candleB of Prop
    (properties
    y 80
    x 80
    view 11
    )
)
(instance chair of Prop
    (properties
    y 98
    x 124
    view 13
    )
)
(instance water of Prop
    (properties
    y 98
    x 124
    view 15
    )
)

/******************************************************************************/
