#include <stdio.h>
#include <allegro.h>
#include <string.h>

#include "wandat.h"

extern DATAFILE *data;           /* sprites */
extern DATAFILE *datafonts;      /* font    */
extern BITMAP *screen;
extern int fontsel;              /* from display.c */
extern int vga;

#define LEFT 50
#define TOP  30

FILE *help_handle;

char * name[17] = {"explorer", "diamonds","exit","boulder",
  "arrow","deflector","rock","dust","mine","time capsule",
  "teleport","balloon","monster","baby monster",
  "cage","bomb","thingy"};

 char icon[17] = {'@','*','X','O','<','/','#',':',
   '!','C','T','^','M','S','+','B','~'};


void draw_object_help (x,y, glyph)
     int x, y;  /*x and y are now in display units */ 
     char glyph;
{
  int spr;
  int i,j,k;


  switch (glyph)
    {
    case 'A':
      spr = ARRIVE;
      break;
    case '>':
      spr = ARROWR;
      break;
    case '<':
      spr = ARROWL;
      break;
    case 'S':
      spr = BABY_MONSTER;
      break;
    case '\\':
      spr = BACKSLASH;
      break;
    case '^':
      spr = BALLOON;
      break;
    case 'O':
      spr = BOULDER;
      break;
    case '+':
      spr = CAGE;
      break;
    case '*':
      spr = DIAMOND;
      break;
    case ':':
      spr = DUST;
      break;
    case 'X':
      spr = EXIT;
      break;
    case '@':
      spr = EXPLORER;
      break;
    case '!':
      spr = MINE;
      break;
    case 'M':
      spr = MONSTER;
      break;
    case '#':
      spr = ROCK1;
      break;
    case '=':
      spr = ROCK2;
      break;
    case '/':
      spr = SLASH;
      break;
    case 'T':
      spr = TELEPORT;
      break;
    case ' ':
      spr = BLANK;
      break;
    case 'C':
      spr = TIMECAPSULE;
      break;
    case 'B':
      spr = BOMB;
      break;
    case '~':
      spr = THINGY;
      break;
    default:
      spr = BLANK;
    }
  draw_sprite (screen, data[spr].dat, x , y );
}

draw_legend()
{
int i,x,y;
rectfill(screen,LEFT/vga,TOP/vga,540/vga+(vga-1)*30,420/vga,26);
text_mode(-1);
for(i=0;i<17;i++)
  {
  x= (LEFT+40+150*(i/6))/vga;
  y= (TOP +10+18*(i%6))/vga;
  textout(screen,datafonts[fontsel].dat,name[i],x,y,4);
  draw_object_help(x-30+20*(vga-1),y,icon[i]);
  }
}

display_help_page(ystart,nlines)
{
char buffer[120];
int i;
for (i=0;i<nlines;i++)
  {
  fgets(buffer,100,help_handle);
  textout_right_justify(screen,datafonts[fontsel].dat,buffer,(LEFT + 10)/vga
    ,500/vga+50*(vga-1),100/vga+(vga-1)*50,(TOP + ystart + i*15)/vga, 4);
  }

textout(screen,datafonts[fontsel].dat,
"Hit any key to continue or ESC to exit.",(LEFT + 10)/vga,(TOP+360)/vga,5);
text_mode(-1);
}

show_help()
{
help_handle = fopen("help.txt","rt");
text_mode(-1);
draw_legend();
display_help_page(120,15);
if(getch() == 27) goto clean_up;  /* ascii code for ESC */
rectfill(screen,LEFT/vga,TOP/vga,540/vga+(vga-1)*30,420/vga,26);
display_help_page(20,21);
if(getch() == 27) goto clean_up;
rectfill(screen,LEFT/vga,TOP/vga,540/vga+(vga-1)*30,420/vga,26);
display_help_page(20,21);
if(getch() == 27) goto clean_up;
rectfill(screen,LEFT/vga,TOP/vga,540/vga+(vga-1)*30,420/vga,26);
display_help_page(20,21);
if(getch() == 27) goto clean_up; 
rectfill(screen,LEFT/vga,TOP/vga,540/vga+(vga-1)*30,420/vga,26);
display_help_page(20,21);
if(getch() == 27) goto clean_up; 
rectfill(screen,LEFT/vga,TOP/vga,540/vga+(vga-1)*30,420/vga,26);
display_help_page(20,10);
getch();

clean_up:
fclose(help_handle);
rectfill(screen,LEFT/vga,TOP/vga,600/vga,420/vga,0);
text_mode(1);
make_control_bar();
}

char * about_text[] = {"     Wanderer by S. Shipway 1988.",
  " ","Adapted for VGA graphics using the",
  "DJGPP compiler and ALLEGRO game",
  "development package, Nov. 1997.", " "
  ,"The game and sources are public"
  ,"domain.", " ","seymour@dgbt.doc.ca"};


draw_about_window()
{
int i;
rectfill(screen,(LEFT+100)/vga,(TOP+90)/vga,450/vga+(vga-1)*30,290/vga,26);
text_mode(-1);
for (i=0;i<10;i++)
  textout(screen,datafonts[fontsel].dat,about_text[i],(LEFT + 110)/vga
    ,(TOP + 100 + i*15)/vga, 4);
text_mode(1);
rest(300);
while (kbhit()) getch(); /* clear keyboard buffer */
getch();
rectfill(screen,(LEFT+100)/vga,(TOP+90)/vga,450/vga,290/vga,0);
}


textout_right_justify(BITMAP *screen,FONT *font,char *string,int left,
int right, int discrep, int top,int col)
/* This function prints out text and tries to left justify it by */
/* adding more space between words. It gives up for short lines. */
/* Same input parameters as textout but you also need to specify */
/* the right margin, right and the maximum discrepancy between   */
/* the end of text and right margin to correct.                  */ 
{
char *tok[50];
char *msg;
char strbuf[100];
int i;
int length,minlen,dlength,last,space;
int incr;
float fleft,finc;
length = text_length(font,string);
minlen = 0;
strcpy(strbuf, string);
last = 0;
for (tok[last] = strtok(strbuf," ");
     tok[last];
     tok[last] = strtok(0," ")) 
  {
  minlen += text_length(font,tok[last]);
  last++ ; 
  }
space = right - left - minlen;
if((space <= 0) || (space>discrep) || last <3)
   {
   textout(screen,font,string,left,top,col);
   return;  /* can't justify */
   }
fleft = (float) left;
finc = (float) space / (float) (last-1);
for (i=0;i<last;i++)
  {
  textout(screen,font,tok[i],(int) fleft,top,col);
  fleft += (float) text_length(font,tok[i]) + finc;
  }
}
 
