10 REM *INTRO & INSTRUCTIONS*
20 CLS:CLEAR:GOSUB 1000

100 REM *INITIALIZE METRICS*
105 CLS:CLEAR:TNEW=TIMER:TOLD=TIMER:THOUR=0:TMIN=0:TSEC=0:TIME=0
110 DIST=0:TOTALDIST=5:STEPS=0:TOTALSTEPS=100:SIGN=-1:PACE=0:PACEMIN=0:PACESEC=0:HR=0
115 DIM PACERANGE(TOTALSTEPS+1):DIM HRRANGE(TOTALSTEPS+1):PACEAVE=0:HRAVE=0
120 GOSUB 3000

140 REM *INITIALIZE GRAPHICS*
145 Z$="1":DIM M(80):S=0:RUNROLD=12:RUNR=12:RUNCOLD=35:RUNC=35
150 GOSUB 4000:GOSUB 5000:GOSUB 6000

160 REM *INITIALIZE RANDOM VARIABLES*
165 RANDOMIZE TIMER:NRAND=3:PROBW=5:PROBP=5:DIM SW(NRAND):DIM SP(NRAND):DIM CW(NRAND):DIM CP(NRAND)
170 FOR IR=1 TO NRAND:SW(IR)=0:SP(IR)=0:CW(IR)=0:CP(IR)=0:NEXT IR

180 REM *INITIALIZE METERS*
185 MW=100:MP=100:GOSUB 12000:GOSUB 12500

200 REM *BEGIN GAME*

210 WHILE STEPS<=TOTALSTEPS

300 REM *GENERATE RANDOM WATER & POWER ELEMENTS IF THEY AREN'T ALREADY THERE*
310 FOR I=1 TO NRAND
320 IF SW(I)=0 THEN GOSUB 10000
330 IF SP(I)=0 THEN GOSUB 10500
340 NEXT I

400 REM *CHECK FOR ALTERNATING L AND R KEYS, UPDATE METRICS, MOVING OBJECTS, L & R GRAPHICS, RANDOM ELEMENTS, METERS*
410 Z$=INPUT$(1)
420 IF (SIGN=1) AND (ASC(Z$)=44) THEN S=S+1:GOSUB 3000:GOSUB 5000:GOSUB 6000:GOSUB 11000:GOSUB 11500:GOSUB 12000:GOSUB 12500:GOTO 500
430 IF (SIGN=1) AND (ASC(Z$)=46) THEN COLOR 7,0:LOCATE RUNR+2,RUNC+12:PRINT "FOOT FAULT!":FOR IS=1 TO 5:PLAY "MF":SOUND 100-2*IS,1:NEXT IS:LOCATE RUNR+2,RUNC+12:PRINT "           ":GOTO 500
440 IF (SIGN=-1) AND (ASC(Z$)=46) THEN S=S+1:GOSUB 3000:GOSUB 5000:GOSUB 7000:GOSUB 11000:GOSUB 11500:GOSUB 12000:GOSUB 12500:GOTO 500
450 IF (SIGN=-1) AND (ASC(Z$)=44) THEN COLOR 7,0:LOCATE RUNR+2,RUNC+12:PRINT "FOOT FAULT!":FOR IS=1 TO 5:PLAY "MF":SOUND 100-2*IS,1:NEXT IS:LOCATE RUNR+2,RUNC+12:PRINT "           ":GOTO 500

500 REM *CHECK FOR SPACE BAR, DO JUMP GRAPHICS, UPDATE STATIONARY & MOVING OBJECTS*
510 IF ASC(Z$)=32 THEN FOR J=1 TO 3:RUNROLD=RUNR:RUNR=RUNR-1:GOSUB 8000:NEXT J:FOR J=1 TO 3:RUNROLD=RUNR:RUNR=RUNR+1:GOSUB 8000:NEXT J:RUNROLD=RUNR:GOSUB 6000:GOSUB 5000:GOTO 600:ELSE GOTO 700

600 REM *CHECK IF JUMP HITS AN ELEMENT AND UPDATE ELEMENTS & METERS* *SWITCH=0 IF NO ELEMENT, 1 IF ELEMENT, 2 IF ELEMENT HIT*
610 FOR IW=1 TO NRAND
620 IF (SW(IW)=1) AND (M(CW(IW))<=RUNC+6 AND M(CW(IW))>=RUNC+3) THEN SW(IW)=2:PLAY "T140"+"MN"+"MB":PLAY "O3 C16 G16 A16 F16 G16 O4 C16":GOSUB 12000:SW(IW)=0:GOSUB 11000:GOTO 650
630 NEXT IW
640 GOSUB 11000:GOSUB 12000:REM *IF ELEMENT NOT HIT*
650 FOR IP=1 TO NRAND
660 IF (SP(IP)=1) AND (M(CP(IP))<=RUNC+6 AND M(CP(IP))>=RUNC+3) THEN SP(IP)=2:PLAY "T140"+"MN"+"MB":PLAY "O2 G16 O3 C16 E16 G8 E16 G8":  GOSUB 12500:SP(IP)=0:GOSUB 11500:GOTO 700
670 NEXT IP
680 GOSUB 11500:GOSUB 12500:REM *IF ELEMENT NOT HIT*

700 REM *GAME FAIL IF EITHER METER HITS ZERO*
710 IF (MW<=0) OR (MP<=0) THEN GOSUB 15000

720 REM *FINISH LINE PRINTS WHEN YOU GET TO 10 STEPS BEFORE THE END AND PLAY SOUND*
730 IF STEPS=TOTALSTEPS-10 THEN FOR IS=1 TO 5:SOUND IS*50+800,1:NEXT IS:FOR IS=1 TO 5:PLAY "MF":SOUND IS*40+800,1:NEXT IS

890 WEND

900 REM *GAME SUCCESS IF STEPS=TOTALSTEPS WHICH CORRESPONDS TO DIST=TOTALDIST*
910 GOSUB 16000
920 REM *PRINT STRAVA PAGE AND ASK IF USER WANTS TO PLAY AGAIN*
930 GOSUB 17000

990 END

1000 REM *INTRO*
1010 REM CLS
1020 COLOR 3:LOCATE 10,30:PRINT "RUNNING SIMULATOR V1.0":
1030 COLOR 4:LOCATE 12,30:PRINT "(C) 1981 WALTER KIEFER"
1040 FOR R=1 TO 22:COLOR 2:LOCATE R,1:PRINT CHR$(177):LOCATE R,80:PRINT CHR$(177):NEXT
1050 LOCATE 1,1:PRINT STRING$(80,177):LOCATE 22,1:PRINT STRING$(80,177)
1060 FOR C=28 TO 53:COLOR 6:LOCATE 8,C:PRINT CHR$(001):NEXT
1070 FOR C=28 TO 53:COLOR 6:LOCATE 14,C:PRINT CHR$(001):NEXT
1080 FOR R=8 TO 14:COLOR 6:LOCATE R,28:PRINT CHR$(001):NEXT
1090 FOR R=8 TO 14:COLOR 6:LOCATE R,53:PRINT CHR$(001):NEXT

1100 REM *MUSIC*
1110 PLAY "T140"+"MN"+"MB": PLAY "O3 E16 G8. A2. A16 B8. E2."

1200 REM *USER INPUTS NAME*
1210 COLOR 7:LOCATE 16,10
1220 INPUT "WHAT'S YOUR NAME, RUNNER";U$

1300 REM *HIT I FOR INSTRUCTIONS OR ENTER TO START*
1310 COLOR 7:LOCATE 18,10:PRINT "HIT I FOR INSTRUCTIONS OR JUST MASH ENTER TO START THIS THING!"
1320 Z$=INPUT$(1):IF (Z$="I") OR (Z$="i") THEN GOSUB 2000 ELSE IF ASC(Z$)=13 THEN RETURN ELSE LOCATE 19,28:PRINT "NOT AN OPTION, FOOL!":GOTO 1320

1990 RETURN

2000 REM *INSTRUCTIONS*
2010 CLS
2020 PRINT "Strike COMMA to step with your left foot and PERIOD to step with your right.";CHR$(13);"Strike SPACEBAR to jump."
2030 PRINT "Finish the race and you win the prize!"
2040 PRINT "Don't go too fast or you'll wear yourself out.";CHR$(13);"Look for water and power boosts to get more energy.";CHR$(13);"It's just like the real thing!"
2050 COLOR 11,7:LOCATE 10,20:PRINT "W":LOCATE 10,25:PRINT "This is water"
2060 COLOR 4,7:LOCATE 12,20:PRINT "P":LOCATE 12,25:PRINT "This is power"
2070 COLOR 6,0:LOCATE 15,20:PRINT" <- These are your racefans":COLOR 20:LOCATE 17,20:PRINT"GOOD LUCK!":COLOR 6:LOCATE 19,20:PRINT" <- So are these, deal with it!"
2080 COLOR 7:LOCATE 21,20:PRINT "MASH ENTER TO START THIS THING!"
2090 Z$=INPUT$(1):IF ASC(Z$)=13 THEN RETURN ELSE LOCATE 22,20:PRINT "I SAID ENTER, FOOL!":GOTO 2090

2990 RETURN

3000 REM *COMPUTE METRICS*

3100 REM *PRINT METRICS*
3110 COLOR 7:LOCATE 2,32:PRINT "GARMIN       GPS":COLOR 2:LOCATE 2,49:PRINT CHR$(1)
3120 COLOR 7:LOCATE 3,32:PRINT "TIME";THOUR;":";TMIN;":";TSEC
3130 COLOR 7:LOCATE 4,32:PRINT "DIST";INT(DIST):LOCATE 4,38:PRINT ".":LOCATE 4,39:PRINT INT(10*(DIST-INT(DIST)))
3140 COLOR 7:LOCATE 5,32:PRINT "PACE";PACEMIN;":";PACESEC
3150 COLOR 7:LOCATE 6,32:PRINT "HR  ";HR
3160 LOCATE 7,32:PRINT U$

3200 REM *INCREMENT AND ALTERNATE STEPS, COMPUTE DISTANCE IN MILES*
3210 STEPS=STEPS+1:SIGN=SIGN*-1
3220 DIST=(STEPS/TOTALSTEPS)*TOTALDIST

3300 REM *COMPUTE TIME* *DT IS SCALED SO EACH STEP IS 1 METER * TOTALDIST/TOTALSTEPS*
3310 TNEW=TIMER:DT=(TNEW-TOLD)/2:TOLD=TNEW:TIME=TIME+DT*(TOTALDIST/TOTALSTEPS)/0.000621371
3320 TSEC=INT(TIME)-60*INT(TIME/60):TMIN=INT(TIME/60)-60*INT(TIME/3600):THOUR=INT(TIME/3600)

3400 REM *COMPUTE PACE* *EACH STEP = 1 METER, PACE = MIN/MI*
3410 PACE=(DT/60)/(0.000621371):IF PACE>=100 THEN PACE=99
3420 PACEMIN=INT(PACE):PACESEC=INT((PACE-INT(PACE))*60)

3500 REM *COMPUTE HEART RATE FROM PACE*
3510 HR=INT((100-200)*(PACE/100)^.5+200)

3600 REM *UPDATE PACE AND HR RANGES*
3610 PACERANGE(STEPS)=PACE
3620 HRRANGE(STEPS)=HR

3700 REM *UPDATE AVERAGE PACE AND AVERAGE HR*
3710 PACEAVG=(TIME/60)/DIST
3720 PACEAVGMIN=INT(PACEAVG):PACEAVGSEC=INT((PACEAVG-INT(PACEAVG))*60)
3730 HRAVG=HRAVG*(1-1/DIST)+HR/DIST

3990 RETURN

4000 REM *STATIONARY OBJECTS*

4100 REM *STATIONARY OBJECTS* *WATCH & POWER/WATER LABELS*
4110 COLOR 8:LOCATE 1,30:PRINT STRING$(21,220):FOR R=3 TO 5:LOCATE R,15:PRINT STRING$(15,186):LOCATE R,51:PRINT STRING$(15,186):NEXT:LOCATE 7,30:PRINT STRING$(21,223):FOR R=2 TO 6:LOCATE R,30:PRINT CHR$(219):LOCATE R,50:PRINT CHR$(219):NEXT:COLOR 7
4120 LOCATE 3,20:COLOR 11,7:PRINT "WATER":LOCATE 3,56:COLOR 4,7:PRINT "POWER":COLOR 7,0

4200 REM *STATIONARY OBJECTS* *ROAD*
4210 COLOR 8:LOCATE 22,1:PRINT STRING$(80,205):LOCATE 11,1:PRINT STRING$(80,205)

4990 RETURN

5000 REM *MOVING OBJECTS*

5005 REM *ROW OF COLUMN INDICES THAT MOVE LEFT WITH INCREASING S WHERE 1<M(C)<80*
5010 FOR C=1 TO 80:M(C)=-S+C-80*INT((-S+C)/80)+1:NEXT

5015 REM *CLEAR EXISTING OBJECTS IF NOT JUMPING*
5020 IF ASC(Z$)<>32 THEN FOR R=8 TO 10:LOCATE R,1:PRINT STRING$(80,255):NEXT

5025 REM *REPRINT TOP ROAD*
5030 COLOR 8:LOCATE 11,1:PRINT STRING$(80,205)

5100 REM *MOVING OBJECTS* *TREES*
5110 COLOR 6:LOCATE 10,M(2):PRINT "":COLOR 2:FOR R=8 TO 9:FOR C=1 TO 3:LOCATE R,M(C):PRINT "":NEXT:NEXT:COLOR 7
5120 COLOR 6:LOCATE 10,M(35):PRINT "":COLOR 2:FOR C=34 TO 36:LOCATE 9,M(C):PRINT "":NEXT:LOCATE 8,M(35):PRINT "":COLOR 7
5180 COLOR 6:LOCATE 10,M(32):PRINT "":COLOR 2:LOCATE 9,M(32):PRINT "":COLOR 7

5200 REM *MOVING OBJECTS* *DOG*
5210 COLOR 6:LOCATE 10,M(9):PRINT CHR$(200):LOCATE 10,M(10):PRINT CHR$(201):LOCATE 10,M(11):PRINT CHR$(203):LOCATE 10,M(12):PRINT CHR$(223):LOCATE 9,M(12):PRINT CHR$(187):COLOR 8:LOCATE 9,M(9):PRINT CHR$(196):LOCATE 9,M(10):PRINT CHR$(191)

5300 REM *MOVING OBJECTS* *PERSON*
5310 COLOR 7:LOCATE 10,M(8):PRINT "A":LOCATE 9,M(8):PRINT CHR$(197):LOCATE 8,M(8):PRINT CHR$(001):COLOR 7

5400 REM *MOVING OBJECTS* *BUILDINGS*
5410 FOR B=0 TO 10 STEP 5:COLOR 7:LOCATE 10,M(42+B):PRINT "":LOCATE 10,M(43+B):PRINT "_":LOCATE 10,M(44+B):PRINT "_":LOCATE 10,M(45+B):PRINT "_":LOCATE 10,M(46+B):PRINT ""
5420 COLOR 7:LOCATE 9,M(42+B):PRINT "":LOCATE 9,M(43+B):PRINT " ":LOCATE 9,M(44+B):PRINT "":LOCATE 9,M(45+B):PRINT " ":LOCATE 9,M(46+B):PRINT ""
5430 COLOR 7:LOCATE 8,M(42+B):PRINT " ":LOCATE 8,M(43+B):PRINT "/":LOCATE 8,M(44+B):PRINT "":LOCATE 8,M(45+B):PRINT "\":LOCATE 8,M(46+B):PRINT " ":NEXT B

5500 REM *MOVING OBJECTS* *BIKE*
5510 COLOR 7:LOCATE 10,M(18):PRINT "":LOCATE 10,M(19):PRINT "":LOCATE 10,M(20):PRINT "":LOCATE 10,M(21):PRINT ""
5520 COLOR 7:LOCATE 9,M(18):PRINT " ":LOCATE 9,M(19):PRINT "":LOCATE 9,M(20):PRINT "_":LOCATE 9,M(21):PRINT ""

5600 REM *MOVING OBJECTS* *FINISH LINE*
5610 IF (TOTALSTEPS-STEPS)<=(79-(RUNC+11)) THEN CFIN=(RUNC+11)+(TOTALSTEPS-STEPS):GOTO 5620 ELSE GOTO 5990
5620 COLOR 15:FOR R=12 TO 21:LOCATE R,CFIN+1:PRINT " ":LOCATE R,CFIN:PRINT "":NEXT R
5630 COLOR 15:LOCATE 14,CFIN:PRINT "F":LOCATE 15,CFIN:PRINT "I":LOCATE 16,CFIN:PRINT "N":LOCATE 17,CFIN:PRINT "I":LOCATE 18,CFIN:PRINT "S":LOCATE 19,CFIN:PRINT "H"

5990 RETURN

6000 REM *LEFT RUNNER* *SPECIFY LOCATION RUNR & RUNC*
6010 FOR R=RUNROLD TO RUNROLD+9:LOCATE R,RUNCOLD:PRINT STRING$(10,255):NEXT
6012 COLOR 6:LOCATE RUNR+0,RUNC:PRINT "      "
6013 COLOR 7:LOCATE RUNR+1,RUNC:PRINT "    >  "
6014 COLOR 7:LOCATE RUNR+2,RUNC:PRINT "   _   "
6015 COLOR 7:LOCATE RUNR+3,RUNC:PRINT "         "
6016 COLOR 9:LOCATE RUNR+4,RUNC:PRINT "   ":COLOR 7:LOCATE RUNR+4,RUNC+9:PRINT ""
6017 COLOR 7:LOCATE RUNR+5,RUNC:PRINT "   ":COLOR 9:LOCATE RUNR+5,RUNC+6:PRINT ""
6018 COLOR 9:LOCATE RUNR+6,RUNC:PRINT "      "
6019 COLOR 5:LOCATE RUNR+7,RUNC:PRINT "   "
6020 COLOR 7:LOCATE RUNR+8,RUNC:PRINT "      "
6021 COLOR 8:LOCATE RUNR+9,RUNC:PRINT "       "
6100 COLOR 7:SOUND (12-RUNR)*20+(RUNC-35)*4+60,1
6900 RETURN

7000 REM *RIGHT RUNNER* *SPECIFY LOCATION RUNR & RUNC*
7010 FOR R=RUNROLD TO RUNROLD+9:LOCATE R,RUNCOLD:PRINT STRING$(10,255):NEXT
7012 COLOR 6:LOCATE RUNR+0,RUNC:PRINT "      "
7013 COLOR 7:LOCATE RUNR+1,RUNC:PRINT "    >  "
7014 COLOR 7:LOCATE RUNR+2,RUNC:PRINT "   _   "
7015 COLOR 7:LOCATE RUNR+3,RUNC:PRINT "         "
7016 COLOR 9:LOCATE RUNR+4,RUNC:PRINT "    "
7017 COLOR 7:LOCATE RUNR+5,RUNC:PRINT "  "
7018 COLOR 9:LOCATE RUNR+6,RUNC:PRINT "      "
7019 COLOR 5:LOCATE RUNR+7,RUNC:PRINT "    "
7020 COLOR 7:LOCATE RUNR+8,RUNC:PRINT "      ":COLOR 8:LOCATE RUNR+8,RUNC:PRINT ""
7021 COLOR 8:LOCATE RUNR+9,RUNC:PRINT "       "
7100 COLOR 7:SOUND (12-RUNR)*20+(RUNC-35)*4+80,1
7900 RETURN

8000 REM *RUNNER ARMS UP* *SPECIFY LOCATION RUNR & RUNC*
8010 FOR R=RUNROLD TO RUNROLD+9:LOCATE R,RUNCOLD:PRINT STRING$(10,255):NEXT
8012 COLOR 6:LOCATE RUNR+0,RUNC:PRINT "      "
8013 COLOR 7:LOCATE RUNR+1,RUNC:PRINT "    >  ":COLOR 7:LOCATE RUNR+1,RUNC+1:PRINT "":COLOR 7:LOCATE RUNR+1,RUNC+8:PRINT ""
8014 COLOR 7:LOCATE RUNR+2,RUNC:PRINT "   _   ":COLOR 7:LOCATE RUNR+2,RUNC+1:PRINT "":COLOR 7:LOCATE RUNR+2,RUNC+8:PRINT ""
8015 COLOR 7:LOCATE RUNR+3,RUNC:PRINT "         ":COLOR 7:LOCATE RUNR+3,RUNC+1:PRINT "":COLOR 7:LOCATE RUNR+3,RUNC+8:PRINT ""
8016 COLOR 9:LOCATE RUNR+4,RUNC:PRINT "    ":COLOR 7:LOCATE RUNR+4,RUNC+1:PRINT "":COLOR 7:LOCATE RUNR+4,RUNC+8:PRINT ""
8017 COLOR 9:LOCATE RUNR+5,RUNC:PRINT "      "
8018 COLOR 9:LOCATE RUNR+6,RUNC:PRINT "      "
8019 COLOR 5:LOCATE RUNR+7,RUNC:PRINT "    "
8020 COLOR 7:LOCATE RUNR+8,RUNC:PRINT "     ":COLOR 8:LOCATE RUNR+8,RUNC:PRINT "":COLOR 8:LOCATE RUNR+8,RUNC+9:PRINT ""
8021 COLOR 8:LOCATE RUNR+9,RUNC:PRINT "        "
8100 COLOR 7:SOUND (12-RUNR)*20+(RUNC-35)*4+100,1
8900 RETURN

8900 RETURN

10000 REM *GENERATE RANDOM ELEMENTS*

10000 REM *GENERATE WATER WITH PROBABILITY RANDW AT A RANDOM LOCATION AND SET SWITCH TO 1*
10100 RANDW=INT(RND*101)
10200 IF RANDW<PROBW THEN SW(I)=1:CW(I)=INT(RND*80)+1
10400 RETURN

10500 REM *GENERATE POWER WITH PROBABILITY RANDP AT A RANDOM LOCATION AND SET SWITCH TO 1* 
10600 RANDP=INT(RND*101)
10700 IF RANDP<PROBP THEN SP(I)=1:CP(I)=INT(RND*80)+1
10900 RETURN

11000 REM *PRINT RANDOM ELEMENTS IF SWITCH=1*

11000 REM *WATER*
11100 FOR KW=1 TO NRAND:IF SW(KW)=1 THEN LOCATE 11,M(CW(KW)):COLOR 11,7:PRINT "W":COLOR 7,0
11200 NEXT KW
11400 RETURN

11500 REM *POWER*
11600 FOR KP=1 TO NRAND:IF SP(KP)=1 THEN LOCATE 11,M(CP(KP)):COLOR 4,7:PRINT "P":COLOR 7,0
11700 NEXT KP
11900 RETURN

12000 REM *METERS*

12000 REM *WATER METER*
12010 REM *IF SWITCH = 2, THEN ELEMENT HIT, INCREASE METER* *IF SWITCH = 0 OR 1, NO ELEMENT OR WASN'T HIT, DECREASE METER*
12020 FOR K=1 TO NRAND:IF SW(K)=2 THEN MW=MW+10:GOTO 12100
12030 NEXT K
12040 IF PACE>0 THEN MW = MW+((1.25-.25)*(PACE/100)^.5-1.25)

12100 REM *SET METER BETWEEN 0 AND 100*
12110 IF MW>100 THEN MW=100
12120 IF MW<0 THEN MW=0 
12200 REM *PRINT METER GRAPHICS*
12210 MWL=INT(MW*(15/100))
12220 COLOR 11:LOCATE 5,15:PRINT STRING$(MWL,176)
12230 COLOR 8:LOCATE 5,15+MWL:PRINT STRING$(15-MWL,186)
12400 RETURN

12500 REM *POWER METER*
12510 REM *IF SWITCH = 2, THEN ELEMENT HIT, INCREASE METER* *IF SWITCH = 0 OR 1, NO ELEMENT OR WASN'T HIT, DECREASE METER*
12520 FOR K=1 TO NRAND:IF SP(K)=2 THEN MP=MP+10:GOTO 12600
12530 NEXT K
12540 IF PACE>0 THEN MP = MP+((1.25-.25)*(PACE/100)^.5-1.25)

12600 REM *SET METER BETWEEN 0 AND 100*
12610 IF MP>100 THEN MP=100
12620 IF MP<0 THEN MP=0
12700 REM *PRINT METER GRAPHICS*
12710 MPL=INT(MP*(15/100))
12720 COLOR 4:LOCATE 5,51:PRINT STRING$(MPL,176)
12730 COLOR 8:LOCATE 5,51+MPL:PRINT STRING$(15-MPL,186)
12900 RETURN

15000 REM *GAME FAIL IF METERS HIT ZERO*
15100 COLOR 7:LOCATE RUNR+2,RUNC:PRINT "   _   "
15110 COLOR 20:LOCATE RUNR+2,RUNC+12:PRINT "YOU HIT THE WALL!"
15120 COLOR 7:LOCATE RUNR+3,RUNC+12:PRINT "PLAY AGAIN? (Y/N)"
15130 PLAY "T110"+"MN"+"MF":PLAY "O1 G4 F#4 F4 E32 F32 E32 F32 E32 F32 E32 F32 E32 F32 E32 F32 E2"
15200 Z$=INPUT$(1):IF (Z$="Y") OR (Z$="y") THEN GOTO 100 ELSE IF (Z$="N") OR (Z$="n") THEN GOTO 15300 ELSE GOTO 15200
15300 COLOR 4:LOCATE RUNR+4,RUNC+12:PRINT "QUITTERS NEVER WIN!":PLAY "T120"+"MN"+"MF":PLAY "O1 G4 E8. A8 G4 E2":COLOR 7,0:END
15900 RETURN 

16000 REM *GAME SUCCESS IF DISTANCE=TOTALDIST*
16100 COLOR 19:LOCATE RUNR+2,RUNC+12:PRINT "YOU MADE IT! CONGRATURATION!"
16110 COLOR 7:LOCATE RUNR+2,RUNC:PRINT "   _   "
16120 PLAY "T140"+"MN"+"MF":PLAY "O4 C8 F8 G8 A8 G4. C2":PLAY "O4 C8 F8 G8 A8 G2"
16130 FOR J=1 TO 8:RUNROLD=RUNR:RUNR=RUNR-1:GOSUB 8000:RUNROLD=RUNR:RUNR=RUNR+1:GOSUB 8000:NEXT J:RUNROLD=RUNR:GOSUB 5000:GOSUB 11000:GOSUB 11500

16200 COLOR 7:LOCATE RUNR+4,RUNC+12:PRINT "HIT U TO UPLOAD TO STRAVA":LOCATE RUNR+5,RUNC+12:PRINT "AND GET THAT SWEET KUDOS!"
16300 Z$=INPUT$(1):IF (Z$="U") OR (Z$="u") THEN GOTO 16400 ELSE GOTO 16300
16400 PLAY "T120"+"MS"+"MF":PLAY "O4 G16 G8 G8 D#16 E8 C4 O5 C2":COLOR 7,0:FOR C=35 TO 70:RUNCOLD=RUNC:RUNC=RUNC+1:GOSUB 8000:NEXT C

16900 RETURN

17000 REM *STRAVA PAGE*
17100 CLS
17110 COLOR 4,7:LOCATE 2,1:PRINT "STRAVA.COM"
17120 COLOR 8,7:LOCATE 2,20:PRINT DATE$:LOCATE 4,20:PRINT "DATE"
17130 LOCATE 2,35:PRINT TOTALDIST;" MI ":LOCATE 4,35:PRINT "DISTANCE"
17140 LOCATE 2,45:PRINT THOUR;":";TMIN;":";TSEC:LOCATE 4,45:PRINT "TIME"
17150 LOCATE 2,60:PRINT PACEAVGMIN;":";PACEAVGSEC;"/";"MI":LOCATE 4,60:PRINT "PACE"
17160 LOCATE 2,74:PRINT "  ":LOCATE 3,74:PRINT "";INT(RND*25)+1:LOCATE 4,74:PRINT "KUDOS  "

17200 COLOR 7,0:LOCATE 9,13:PRINT "5:00/MI":LOCATE 14,12:PRINT "10:00/MI":LOCATE 18,16:COLOR 1,0:PRINT "PACE"
17210 COLOR 7,0:LOCATE 19,20:PRINT "0":LOCATE 19,71:PRINT "100":LOCATE 20,20:PRINT "DISTANCE"
17220 LOCATE 9,71:PRINT "200":LOCATE 14,71:PRINT "100":LOCATE 18,71:COLOR 4,0:PRINT "HEART RATE"

17300 COLOR 7,0:LOCATE 18,20:PRINT STRING$(51,220)
17310 FOR R=9 TO 18:LOCATE R,20:PRINT CHR$(221):NEXT R

17400 FOR IP=2 TO TOTALSTEPS STEP 2
17410 CP=IP/2+20
17420 IF PACERANGE(IP)>12 THEN COLOR 1:LOCATE 17,CP:PRINT "" ELSE IF PACERANGE(IP)<5 THEN COLOR 1:LOCATE 9,CP:PRINT "" ELSE COLOR 1:LOCATE INT(PACERANGE(IP))+4,CP:PRINT ""
17430 HRROW=INT((9-14)/(200-100)*(HRRANGE(IP)-100)+14)
17440 COLOR 4:LOCATE HRROW,CP:PRINT ""
17490 NEXT IP

17500 COLOR 7,0:LOCATE 22,1:PRINT "PLAY AGAIN? (Y/N)"
17600 Z$=INPUT$(1):IF (Z$="Y") OR (Z$="y") THEN GOTO 100 ELSE IF (Z$="N") OR (Z$="n") THEN GOTO 17700 ELSE GOTO 17600
17700 COLOR 3:LOCATE 22,20:PRINT "YEAH, IT'S BRUNCH O'CLOCK ANYWAYS!":COLOR 7
17800 END

17900 RETURN

20000 REM *ENDSUB*
20100 PRINT "THE END"
20900 RETURN
