(include "sci.sh")
(include "game.sh")

(script MAIN_SCRIPT)

(use "controls")
(use "sound")
(use "syswindow")
(use "cycle")
(use "game")
(use "inv")
(use "user")
(use "menubar")
(use "feature")
(use "obj")
(use "disposeload")

(local
	gEgo					/* points to the ego's class */
	gGame					/* points to the game instance */
	gRoom					/* points to the current room instance */
	gSpeed 					/* the game speed (delay each interpreter cycle) */
	gQuitGame = FALSE		/* if set to TRUE, the game will exit */

	gCast					/* points to the cast class (list of actors) */
	gRegions				/* points to the regions class (list of regions) */
	gLocales 				/* points to the locales class (list of locales) */
	gTimers					/* points to the timers class (list of timers) */
	gSounds					/* points to the sounds class (list of sounds) */
	gInv					/* points to the inventory class */
	gAddToPics				/* points to the add to pics class */
	gFeatures				/* points to the add to features class */
	gSFeatures				/* points to the add to sfeatures class */

	gRoomNumberExit			/* room number exit */
	gPreviousRoomNumber		/* the number of the previous room */
	gRoomNumber				/* the number of the current room */
	gDebugOnExit = FALSE	/* enter debug mode on room exit */

	gScore = 0				/* the game score */
	gMaxScore = 73   	    /* the maximum game score */
	gOldScore				/* previous score */

	gCurrentCursor 			/* the number of the current cursor */
	gNormalCursor = 999		/* the number of the normal cursor (ie. arrow) */
	gLoadingCursor = 997	/* the number of the loading cursor (ie. hand) */


	gDefaultFont = 1		/* the number of the default font */
	gSaveRestoreFont = 0	/* the number of the font for the save/restore dialogs*/
	gDeadFont = 0			/* the number of the font for the dialog when ego dies */

	gUserEvent				/* points to the user's event object */
	gPrintDlg				/* points to the current Print() window */
	gVolume					/* the sound volume */
	gVersion				/* the version string */
	gSaveDirPtr				/* points to the save directory string */
	gCheckAniWait			/* the checkAni delay */
	gSetRegions				/* a flag -- see User:doit() */

	gPicAngle				/* the room's pic angle */
	gOverlay = -1			/* whether to overlay the picture when drawing */
	gDefaultPicAni			/* the default pic animation */
	gDefaultPalette			/* the default palette to use for the pictures (0-3) */
	gCastMotionCue			/* if set, the cast's motionCue() is called */

	gTheWindow				/* points to the window class */
	gWndColor				/* the colour of the game's windows foreground (ie. text) */
	gWndBack				/* the colour of the game's windows background */

	gOldPort				/* the previous port */

	gEgoView				/* ego's current view number */

	/* hh:mm:ss | gTimeHours:gTimeMinutes:gTimeSeconds */
	/* the time elapsed since the game started */
	gTimeSeconds			/* the seconds */
	gTimeMinutes			/* the minutes */
	gTimeHours				/* the hours */

	gCurrentTime				/* the current time in seconds */

	gTheMusic				/* points to the music class */
	gTheSoundFX				/* points to the sound fx class */
	gProgramControl 		/* states whether the program has control or the user */
    talkedToWoman = FALSE
    message2 = FALSE
    drawer = FALSE
    washed = FALSE
    sit = FALSE
    talkedToMan = FALSE
    openDoor = FALSE
    talkedToMan2 = FALSE
    payed = FALSE
    talkedGuard = FALSE
    talkedGuard2 = FALSE
    port = FALSE
    talkedToWoman2 = FALSE
    deskGuy = FALSE
    credit = FALSE
    gaveSculpture = FALSE
    guitar = FALSE
    aboutGuitar = FALSE
    credit2 = FALSE
    talkedToSaler = FALSE
    storeOpen = FALSE
    request = FALSE
    theCode
    locker = FALSE
    talkedBob = FALSE
    talkedChief = FALSE
    jungle = FALSE

    inWater = FALSE
    joke1 = FALSE
    joke2 = FALSE
    joke3 = FALSE
    joke4 = FALSE
    joke5 = FALSE
    joke6 = FALSE
    joke7 = FALSE
    joke8 = FALSE
    joke9 = FALSE
    joke10 = FALSE
    joke11 = FALSE
    joke12 = FALSE
    joke13 = FALSE
    joke14 = FALSE
    joke15 = FALSE
    joke17 = FALSE
    joke18 = FALSE
    drawerClosed = FALSE
    drawerOpened = FALSE
    talkedWitch = FALSE
    onSea = FALSE
    needRope = FALSE
    climb = FALSE
    ropeup = FALSE
    opened = FALSE
    read2 = FALSE
    town = FALSE
    town2 = FALSE
    chiefTalk = FALSE
    time
    warn1 = FALSE
    track
    action[0]
    note = FALSE
    car = FALSE
    help = FALSE
    shake = FALSE
    GuitarSee = FALSE

)
/******************************************************************************/
(instance public Template of Game
	(properties)
	(method (init)

        // Set up the base window
		= gTheWindow theWindow
		= gWndColor clBLACK
		= gWndBack clWHITE
		(send gTheWindow:
			color(gWndColor)
		    back(gWndBack)
		)

        // Initialize
		(super:init())

        /******************************
         * Set your game version here *
         ******************************/
		= gVersion "1.0"

		// General initialization stuff
	    = gVolume 15
	    DoSound(sndVOLUME gVolume)

	    (SL:code(statusCode))
	    (TheMenuBar:init())

	    (scoreSound:
	    	owner(self)
	    	init()
	    )
	    = gTheMusic theMusic
	    (send gTheMusic:
	    	owner(self)
	    	init()
	    )
		= gTheSoundFX theSoundFX
	    (send gTheSoundFX:
	    	owner(self)
	    	init()
	    )

	    = gEgo ego
	    (User:
	    	alterEgo(gEgo)
	    	blocks(0)
	    	y(150)
	    )

		Load(rsFONT		gDeadFont)
		Load(rsFONT		gDefaultFont)
		Load(rsFONT		gSaveRestoreFont)

		Load(rsCURSOR	gNormalCursor)
		Load(rsCURSOR	gLoadingCursor)

	    (if(HaveMouse())
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE))
		)(else
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE 304 174))
		)

        /*************************************************
         * Initialize the inventory with it's items here *
         *************************************************/
		(Inv:
			add(
				{Nothing}
                {Key}
                {Card}
                {Cash}
                {Soap}
                {Boatkey}
                {Credit card}
                {Guitar}
                {Wood sculpture}
                {Rope}
                {Paper}
                {Wire}

			)
		)

		// Start the room
		(if(GameIsRestarting())
	    	(self:newRoom(INITROOMS_SCRIPT))
	    )(else
	    	(self:newRoom(TITLESCREEN_SCRIPT))
		)
	)
	(method (doit)
		(super:doit())
		(if(gProgramControl)
			(User:
				canControl(FALSE)
				canInput(FALSE)
			)
		)
		(if(<> gCurrentTime (= gCurrentTime GetTime(gtTIME_OF_DAY)))
		    (if(>= ++gTimeSeconds 60)
		    	= gTimeSeconds 0
		    	++ gTimeMinutes
		    	(if(>= gTimeMinutes 60)
		    		= gTimeMinutes 0
		    		++ gTimeHours
		    	)
			)
		)
  		(if(> gOldScore gScore)
		    	= gOldScore gScore
				(SL:doit())
		)
		(if(< gOldScore gScore)
		    = gOldScore gScore
			(SL:doit())
		)
	)
	(method (replay)
  		(TheMenuBar:draw())
  		(SL:enable())

  		(if(DoSound(sndSET_SOUND))
		    SetMenu(MENU_TOGGLESOUND #text "Turn Off")
		)(else
		    SetMenu(MENU_TOGGLESOUND #text "Turn On")
		)
		(super:replay())
	)
	(method (newRoom roomNum picAni)
  			DisposePrintDlg()
  			Load(rsFONT		gDeadFont)
  			Load(rsFONT		gDefaultFont)
  			Load(rsFONT		gSaveRestoreFont)

  			Load(rsCURSOR	gNormalCursor)
  			Load(rsCURSOR	gLoadingCursor)

			(super:newRoom(roomNum))
			(if(< paramTotal 2)
				= gDefaultPicAni Random(0 5)
			)(else
				= gDefaultPicAni picAni
			)
	)
	(method (startRoom roomNum)
		DisposeLoad(
			NULL
			FILEIO_SCRIPT JUMP_SCRIPT EXTRA_SCRIPT WINDOW_SCRIPT
		        TIMER_SCRIPT FOLLOW_SCRIPT REV_SCRIPT DCICON_SCRIPT
		        DOOR_SCRIPT AUTODOOR_SCRIPT
		)
		DisposeScript(DISPOSELOAD_SCRIPT)
		(if(gDebugOnExit)
			= gDebugOnExit FALSE
			SetDebug()
		)
		(send gTheSoundFX:
			stop()
			number(1)
		)
		(super:startRoom(roomNum))
		(if(== gTheSoundFX 11)
		 	(send gEgo:baseSetter(NormalBase))
		)
	)
	(method (changeScore addScore)
		= gScore + gScore addScore
		(if(> addScore 0)
			(scoreSound:playMaybe())
		)
	)
  	(method (handleEvent pEvent)
		(super:handleEvent(pEvent))

		(if((<> (send pEvent:type) evSAID) or (send pEvent:claimed))
		    return(TRUE)
		)

        /***********************************/
        /* Add global said statements here */
        /***********************************/

(if(Said('hi'))
Print("Hello! Do I know you?")
)
(if(Said('open/door'))
Print("I don't need to!")
)

        (if(Said('[tell,make]/joke'))
        (if(GuitarSee)
        (if(joke1)
        (if(joke2)
        (if(joke3)
        (if(joke4)
        (if(joke5)
        (if(joke6)
        (if(joke7)
        (if(joke8)
        (if(joke9)
        (if(joke10)
        (if(joke11)
        (if(joke12)
        (if(joke13)
        (if(joke14)
Print("I don't have any more jokes to tell at the moment. But you can mail me some jokes that you know.")
return
)
Print("QUESTION: What's heavy and when it's falls into your eye you're dead meat?")
Print("ANSWER: An airplane.")
= joke14 TRUE
(send gGame:changeScore(1))
return
)
Print("QUESTION: It's heavy and when it falls from a tree, your refridgerator will be broke?")
Print("ANSWER: The refridgerator")
= joke13 TRUE
return
)
Print("So, a skeleton walks into a bar and asks for a beer and a mop.")
= joke12 TRUE
return
)
Print("Do you smoke a lot?")
Print("60 sigarettes.")
Print("Per day?")
Print("No, only per evening.")
Print("But what are you doing in the morning.")
Print("Cough!")
= joke11 TRUE
return
)
Print("\"There are two things that I can be very proud of.\" says the proffesor.")
Print("One is my good memory and another is... wait a minute.. what was that another one..")
= joke10 TRUE
return
)
Print("There are only two things that this football player doesn't have to be a great player.")
Print("What's that?")
Print("Legs.")
= joke9 TRUE
return
)
Print("Composer: \"It took me 15 years to finish this cradle song!\"")
Print("Publisher: \"Why's that?\"")
Print("Composer: \"I was always falling asleep while writing it.\"")
= joke8 TRUE
return
)
Print("President was first time on a fighter plane with the emergency jet seat.")
Print("He was concerned: \"What if this mechanism doesn't work?\"")
Print("Nothing special! We'll just have the new election.")
= joke7 TRUE
return
)
Print("In a flight school young pilot was tought how to handle the emergency landing.")
Print("At the end of the lecture instructor asked pilot:")
Print("Against what we need to protect ourselves after the landing?")
Print("Pilot answered: \"Against the passangers\"")
= joke6 TRUE
return

)
Print("'John did you put new water into the aquarium?'")
Print("'No. The fishes haven't drink the old water yet.'")
= joke5 TRUE
return
)
Print("One day bear was driving with the bus. When he was sitting rabbit took his wallet. Bear screamed:")
Print("'If you don't give my wallet back, same thing that happened yesterday will happen today.'")
Print("Then the fox asked: 'What happened yesterday?'")
Print("'Yesterday I didn't got my wallet back'")
= joke4 TRUE
return
)
Print("What's bigger than a lighter?")
Print("Mick Jagger's lips.")
= joke3 TRUE
return
)
Print("Do you know what's three yellow things flying in the air?")
Print("Three chinese walked on a bomb.")
= joke2 TRUE
return
)
Print("Do you know what's yellow and sitting in the grass?")
Print("Chinese guy.")
= joke1 TRUE
return
)
Print("I don't want to tell these yet.")
return
)
(if(Said('fuck,ass'))
(if(warn1)
Print("Don't say I didn't warn you!")
= gQuitGame TRUE
return
)
Print("I'm warning you!")
= warn1 TRUE

        )
        (if(Said('watch/tv'))
            Print("You have a TV???")
        )
        (if(Said('look/dick'))
            Print("Are you a pervert?")
        )
        (if(Said('read/book'))
            Print("Which one?"))

    (if(Said('masturbate'))
            Print("Could you do that elsewhere?")
        )
        (if(Said('sleep'))
            Print("I just woke.")
            )
        (if(Said('lie'))
            Print("About what or with who?")
                 )
             (if(Said('about'))
            Print("About what about?")
                 )
        (if(Said('lefty'))
            Print("There are two Leftys. One in a bar in LSL1 and one in Oliver's game 'Lefty: Goes on a vacation \(Not in the right place\)")
                  )
        (if(Said('sci'))
            Print("SCI means Sierra Creative Interpreter. Created by Brian Provinciano. It rules!!!!")
                )
        (if(Said('me'))
            Print("I'm Eigen Lenk \(eigen@hot.ee\)")
             )
              (if(Said('new'))
            Print("There aren't any news.")
            )
        (if(Said('credit'))
            Print("Can't you find it yourself?")
            )
        (if(Said('fungame,stuff'))
            Print("Al Pond (tm) is a registred trademark of Fungame (c). Eigen Lenk 2002.\n\n\ http://www.hot.ee/alpond"#title"Legal stuff.")
             )
        (if(Said('clap'))
            Print("Why should I clap?")
            )
        (if(Said('scream'))
            Print("JIIPPPYYYYYY!!!!!.")
                 )
        (if(Said('hint'))
            Print("Need hint! Mail to me or left a message to the forum at http://www.\n\mega-tokyo.com/forum")
        )
        (if(Said('talk>'))
        (if(Said('/man'))
            Print("Why should I?")
        )(else
        (if(Said('/woman'))
            Print("Hello! My name is Pond, Al Pond!"#title"Al: ")
            Print("There's no answer because there's no woman nearby."))
         )
         (if(Said('[ /* , !* ]'))
         Print("Hello out there! How's it going?"))
           )
         (if(Said('fart'))
         Print("Could you open the window. It stinks in here.")
             )
         (if(Said('undress'))
         Print("Not when you're looking.")
               )
         (if(Said('kill'))
         Print("It's not a killing game.")
               )
         (if(Said('run'))
         Print("I can't I'm tired.")
             )
         (if(Said('pee'))
         Print("I just did that.")
         

         






return(FALSE)
)
)
)

/******************************************************************************/
(class Iitem of InvI
	(properties
		said 0
		description 0
		owner 0
		view 0
		loop 0
		cel 0
		script 0
	)
	(method (showSelf)
		Print(
            description
			#title objectName
			#icon view 0 0
		)
	)
)
/******************************************************************************/
(instance statusCode  of Code
	(properties)
 	(method (doit param1)
  		Format(param1 " Score: %d of %-3d           Al Pond 2: Island Quest" gScore gMaxScore)
 	)
)
/******************************************************************************/
(instance ego of Ego
	(properties
		y 1111
		x 0
		z 0
		heading 0
		yStep 2
		view 0
		loop 0
		cel 0
		priority 0
		underBits 0
		signal $2000
		nsTop 0
		nsLeft 0
		nsBottom 0
		nsRight 0
		lsTop 0
		lsLeft 0
		lsBottom 0
		lsRight 0
		brTop 0
		brLeft 0
		brBottom 0
		brRight 0
		cycleSpeed 0
		script 0
		cycler 0
		timer 0
		illegalBits $8000
		xLast 0
		yLast 0
		xStep 3
		moveSpeed 0
		blocks 0
		baseSetter 0
		mover 0
		looper 0
		viewer 0
		avoider 0
		edgeHit 0
	)
)
/******************************************************************************/
(instance scoreSound of Sound
	(properties
		state 0
		number SCORE_SOUND
		priority 10
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theMusic  of Sound
	(properties
		state 0
		number 1
		priority 0
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theSoundFX  of Sound
	(properties
		state 0
		number 1
		priority 5
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theWindow  of SysWindow
	(properties)
	(method (open)
		(if(< Graph(grGET_COLOURS) 9)
			(if( (< color 7) or (== color 8) )
				= color 0
				= back  15
			)(else
				= color 15
				= back  0
			)
  		)
  		(super:open())
	)
)
/******************************************************************************/
(instance NormalBase of Code
	(properties)
	(method (doit)
		(var temp0)
		(if(== gRoomNumberExit 253)
		    = temp0 22
		)(else
  			= temp0 10
		)
		(send gEgo:
			brBottom(
				(+ (send gEgo:y) 1)
			)
		)
		(send gEgo:
			brTop(
				(- (send gEgo:brBottom) (send gEgo:yStep))
			)
		)
		(send gEgo:
			brLeft(
				(- (send gEgo:x) temp0)
			)
		)
		(send gEgo:
			brRight(
				(+ (send gEgo:x) temp0)
			)
		)
	)
)

/******************************************************************************
 * THE PUBLIC PROCEDURES
 ******************************************************************************/
(procedure public (SetUpEgo theLoop theView)
	PlayerControl()
	(send gEgo:edgeHit(EDGE_NONE))
	(switch(paramTotal)
		(case 0
			SetUpActor(gEgo (send gEgo:loop) gEgoView)
		)
  		(case 1
			SetUpActor(gEgo theLoop gEgoView)
		)
  		(case 2
		    SetUpActor(gEgo theLoop theView)
  		)
	)
)
/******************************************************************************/
(procedure public (SetUpActor pActor theLoop theView)
	(if(> paramTotal 1)
		(send pActor:loop(theLoop))
	)
	(if(> paramTotal 2)
		(send pActor:view(theView))
	)
	(send pActor:
		setLoop(-1)
		setPri(-1)
		setStep(3 2)
		setCycle(Walk)
		illegalBits($8000)
		cycleSpeed(0)
		moveSpeed(0)
		ignoreActors(0)
	)
)
/******************************************************************************/
(procedure public (ProgramControl)
	(User:
		canControl(FALSE)
		canInput(FALSE)
	)
	(send gEgo:setMotion(NULL))
)
/******************************************************************************/
(procedure public (PlayerControl)
	(User:
		canControl(TRUE)
		canInput(TRUE)
	)
	(send gEgo:setMotion(NULL))
)
/******************************************************************************/
(procedure public (DisposePrintDlg)
	(if(gPrintDlg)
		(send gPrintDlg:dispose())
	)
)
/******************************************************************************/
(procedure public (PrintOK)
	Print("OK")
)
/******************************************************************************/
(procedure public (PrintItIs)
	Print("It's already opened.")
)
/******************************************************************************/
(procedure public (PrintYouAre)
	Print("You are.")
)
/******************************************************************************/
(procedure public (PrintGoodIdea)
	Print("Good idea. You might try that again later.")
)
/******************************************************************************/
(procedure public (PrintNotCloseEnough)
	Print("You're not close enough.")
)
/******************************************************************************/
(procedure public (PrintAlreadyTookIt)
	Print("You already took it.")
)
/******************************************************************************/
(procedure public (PrintDontHaveIt)
	Print("You don't have it.")
)
/******************************************************************************/
(procedure public (PrintCantDoThat mem)
	(if(> MemoryInfo(miLARGESTPTR) mem)
		return(TRUE)
	)(else
		Print("You can't do that here; at least, not now.")
		return(FALSE)
	)
)
/******************************************************************************/
(procedure public (AddViewToPic pView)
	(var hView)
	(if(pView)
		= hView (View:new())
		(send hView:
		  	view(send pView:view)
			loop(send pView:loop)
			cel(send pView:cel)
			priority(send pView:priority)
			posn( (send pView:x) (send pView:y) )
			addToPic()
		)
		(send pView:
			posn( (send pView:x) (+ 1000 (send pView:y)) )
		)
	)
)
/******************************************************************************/
(procedure public (SetInvIOwner index owner)
	(var hInvI)
	= hInvI (send gInv:at(index))
	(if(< paramTotal 2)
		(send hInvI:owner(gRoomNumberExit))
	)(else
		(send hInvI:owner(owner))
	)
)


/******************************************************************************
 * THE INVENTORY ITEMS                                                        *
 ******************************************************************************/
(instance Nothing  of Iitem
	(properties)
)
/******************************************************************************/
(instance {Cash} of Iitem
	(properties
		said 'cash'
		description
              "You have 45 nabys. This supposed to make you the happyest man on island."
		owner 0
		view 802
		loop 0
		cel 0
		script 0
	)
  )
(instance {Key} of Iitem
	(properties
		said 'key'
		description
             "This is the key for your room door. It's made of gold."
		owner 0
		view 800
		loop 0
		cel 0
		script 0
	)
)
(instance {Soap} of Iitem
	(properties
		said 'soap'
		description
             "This is the Soap-O-Rope you found from casino."
		owner 0
		view 800
		loop 0
		cel 0
		script 0
	)
)

(instance {Card} of Iitem
	(properties
		said 'card'
		description
             "This is your membership card in Diet Center."
		owner 0
		view 801
		loop 0
        script 0
	)
   )
   (instance {Boatkey} of Iitem
	(properties
		said 'boat'
		description
             "This is a boat key and some boat owner ID."
		owner 0
		view 806
		loop 0
        script 0
	)
   )
   (instance {Credit card} of Iitem
	(properties
		said 'credit'
		description
             "This is your credit card. With this NBI can always know where you are."
		owner 0
		view 803
		loop 0
        script 0
	)
   )
    (instance {Guitar} of Iitem
	(properties
		said 'guitar'
		description
             "This guitar cost you 70 nabys. But what you're gonna do with it."
		owner 0
		view 804
		loop 0
        script 0
	)
   )
   (instance {Wood sculpture} of Iitem
	(properties
		said 'sculpture'
		description
             "This is the wood sculpture that Jessica wanted."
		owner 0
		view 41
		loop 0
        script 0
	)
   )
   (instance {Rope} of Iitem
	(properties
		said 'rope'
		description
             "You have 5m of this rope. Now you can climb up places."
		owner 0
		view 810
		loop 0
        script 0
	)
   )
    (instance {Paper} of Iitem
	(properties
		said 'paper'
		description
             "It says:\n\Hi Al! I'm Chief. I'm sure you'll think why I kidnapped
Chief Nakimuga. Simple! Because this island is becoming a great tourist trap
and I wan't to get all the profit from it. And Chief Nakimuga was disturbing us."
		owner 0
		view 805
		loop 0
        script 0
	)
   )
     (instance {Wire} of Iitem
	(properties
		said 'wire'
		description
             "This is a wire you found from a drawer."
		owner 0
		view 809
		loop 0
        script 0
	)
   )

/******************************************************************************/

