/******************************************************************************
 Al Pond 2: Island Quest
 By Eigen Lenk
 ******************************************************************************
 menubar.sc
 Contains the customized Menubar class. This is the script you modify if you 
 want to customize the menu.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MENUBAR_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "gauge")
(use "sound")
(use "user")

/******************************************************************************/

(class TheMenuBar of MenuBar
	(properties
		state 0

	)
	(method (init)
		AddMenu(
			" Fungame "
				"About Al Pond 2`^a:"+
				"Help`#1"

		)
		AddMenu(
			" File "
				"Restart Game`#9:"+
				"Save Game`#5:"+
				"Restore Game`#7:"+
				"--! :"+
				"Quit`^q"
		)
		AddMenu(
			" Action "
				"Pause Game`^p:"+
				"Inventory`^I:"+
				"Retype`#3:"+
                "Tell Joke`#4:"
         )
		AddMenu(
			" Speed "
				"Change...`^s:"+
				"--!:"+
				"Faster`+:"+
				"Normal`=:"+
				"Slower`-"
		)
		(if(DoSound(sndSET_SOUND))
			AddMenu(
				" Sound "
					"Volume...`^v:"+
					"Turn Off`#2=1"
			)
		)(else
			AddMenu(
				" Sound "
					"Volume...`^v:"+
					"Turn On`#2=1"
			)
		)
		(if(< Graph(grGET_COLOURS) 9)
			SetMenu(MENU_COLOURS 32 0)
		)(else
			SetMenu(MENU_COLOURS smMENU_SAID '/color')
		)
		SetMenu(MENU_SAVE		smMENU_SAID 'save[/game]')
		SetMenu(MENU_RESTORE	smMENU_SAID 'restore[/game]')
		SetMenu(MENU_RESTART	smMENU_SAID 'restart[/game]')
		SetMenu(MENU_QUIT		smMENU_SAID 'done[/game]')
		SetMenu(MENU_PAUSE		smMENU_SAID 'delay[/game]')
		SetMenu(MENU_INVENTORY	smMENU_SAID 'all')
	)

	(method (handleEvent pEvent)

		(var menuItem, hGauge, newSpeed, newVolume, wndCol, wndBack, hPause)

		= menuItem (super:handleEvent(pEvent))
		(switch(menuItem)




			(case MENU_ABOUT
      Print(
  "Written by\n\   Eigen Lenk"
  #title "About Al Pond 2"
  #icon 12 0 0
				)
    Print(
  "Programmed by\n\    Eigen Lenk"
  #title "About Al Pond 2"
  #icon 9 0 0
				)

      Print(
  "Animations and \n\   sounds from\n\n\Leisure Suit Larry\n\and Police Quest 2"
  #title "About Al Pond 2"
  #icon 10 0 0
				)

             Print(
  "Web: http://www.hot.ee/alpond\n\Or mail to: fungame@hot.ee"
  #title "About Al Pond 2"
  #icon 777 0 0
				)
             )
//this is the joke feature
(case MENU_TRACK
       (if(GuitarSee)
        (if(joke1)
        (if(joke2)
        (if(joke3)
        (if(joke4)
        (if(joke5)
        (if(joke6)
        (if(joke7)
        (if(joke8)
        (if(joke9)
        (if(joke10)
        (if(joke11)
        (if(joke12)
        (if(joke13)
        (if(joke14)
Print("I don't have any more jokes to tell at the moment. But you can mail me some jokes that you know.")
return
)
Print("QUESTION: What's heavy and when it's falls into your eye you're dead meat?")
Print("ANSWER: An airplane.")
= joke14 TRUE
(send gGame:changeScore(1))
return
)
Print("QUESTION: It's heavy and when it falls from a tree, your refridgerator will be broke?")
Print("ANSWER: The refridgerator")
= joke13 TRUE
return
)
Print("So, a skeleton walks into a bar and asks for a beer and a mop.")
= joke12 TRUE
return
)
Print("Do you smoke a lot?")
Print("60 sigarettes.")
Print("Per day?")
Print("No, only per evening.")
Print("But what are you doing in the morning.")
Print("Cough!")
= joke11 TRUE
return
)
Print("\"There are two things that I can be very proud of.\" says the proffesor.")
Print("One is my good memory and another is... wait a minute.. what was that another one..")
= joke10 TRUE
return
)
Print("There are only two things that this football player doesn't have to be a great player.")
Print("What's that?")
Print("Legs.")
= joke9 TRUE
return
)
Print("Composer: \"It took me 15 years to finish this cradle song!\"")
Print("Publisher: \"Why's that?\"")
Print("Composer: \"I was always falling asleep while writing it.\"")
= joke8 TRUE
return
)
Print("President was first time on a fighter plane with the emergency jet seat.")
Print("He was concerned: \"What if this mechanism doesn't work?\"")
Print("Nothing special! We'll just have the new election.")
= joke7 TRUE
return
)
Print("In a flight school young pilot was tought how to handle the emergency landing.")
Print("At the end of the lecture instructor asked pilot:")
Print("Against what we need to protect ourselves after the landing?")
Print("Pilot answered: \"Against the passangers\"")
= joke6 TRUE
return

)
Print("'John did you put new water into the aquarium?'")
Print("'No. The fishes haven't drink the old water yet.'")
= joke5 TRUE
return
)
Print("One day bear was driving with the bus. When he was sitting rabbit took his wallet. Bear screamed:")
Print("'If you don't give my wallet back, same thing that happened yesterday will happen today.'")
Print("Then the fox asked: 'What happened yesterday?'")
Print("'Yesterday I didn't got my wallet back'")
= joke4 TRUE
return
)
Print("What's bigger than a lighter?")
Print("Mick Jagger's lips.")
= joke3 TRUE
return
)
Print("Do you know what's three yellow things flying in the air?")
Print("Three chinese walked on a bomb.")
= joke2 TRUE
return
)
Print("Do you know what's yellow and sitting in the grass?")
Print("Chinese guy.")
= joke1 TRUE
return
)
Print("I don't want to tell these yet.")
return
)



			(case MENU_HELP
             SetCursor(998 HaveMouse())
				(if(Print(

					"If you haven't figure it out yourself then you have chosen a wrong game. I'll give you a clue.
You have to type in comands such as 'look at tree', 'open door' or 'talk to woman'. If you're looking at somebody and wan't to return then type 'back'
The game itself is very easy but if you're stuck somewhere then just mail me."
					#title "Help me!!!!"
                   #button " More " 1
	               #button " Enough " 0

)
)
time = gTimeSeconds
FormatPrint(
"So you wan't more? I'm not sure there's anything more to say.
Oops! I almost forgot that your score is %d out of %-3d. And one more thing.
Use mouse to move around. And also check out some jokes by pressing F4. Now that is all...I think. "
gScore gMaxScore gTimeSeconds
)


 )

SetCursor(999 HaveMouse())
)
(case MENU_RESTART
				(if(Print(
					  "Are you serious? Do you really want to start all the work way back at the beginning again?"
					  #title "Oh my god!"
					  #font gDefaultFont
					  #button " Of course " 1
					  #button " No way " 0
                      #icon 44 0 0
					)
				   )

					(send gGame:restart())						
				)
			)
			(case MENU_RESTORE   
				(send gGame:restore())
			)
			(case MENU_SAVE		  		    
				(send gGame:save())
			)
			(case MENU_QUIT		  	
				(if(Print(
					  "You're a wuzzy when you quit!"
					  #title "You are a wuzzy!"
					  #font gDefaultFont
					  #button " Yes " 1
					  #button " No " 0
                      #button " Totally " 1
                      #icon 7 0 0
					)
				   )
						= gQuitGame TRUE					
				)
			)
			(case MENU_PAUSE
     ToggleSound()
	(if(Print("Why did you pause the game. Isn't it interesting enough to play?"
     #title"Question?"
     #button"Back To Action" 1)
     )
      ToggleSound()
     return
     )




			)
			(case MENU_INVENTORY
				(if(PrintCantDoThat($400))
					(send gInv:showSelf(gEgo))
		    	)
			)


			(case MENU_RETYPE
				(send pEvent:
					claimed(FALSE)
					type(evKEYBOARD)
					message( (User:echo) )
				)
			)



			(case MENU_CHANGESPEED
				= hGauge (Gauge:new())
				= newSpeed
					(send hGauge:
						text("Game Speed")
						description("Use the mouse or the left and right arrow keys to select the game speed.")
						higher("Faster")
						lower("Slower")
						normal(NORMAL_SPEED)
						doit(- 15 gSpeed)
					)
				(send gGame:setSpeed(- 15 newSpeed))
				DisposeScript(GAUGE_SCRIPT)
			)
			(case MENU_FASTERSPEED
				(if(gSpeed)
					(send gGame:setSpeed(--gSpeed))
				)
			)
			(case MENU_NORMALSPEED
				(if(gSpeed)
					(send gGame:setSpeed(12))



				)
			)
			(case MENU_SLOWERSPEED
				(if(< gSpeed 15)
					(send gGame:setSpeed(++gSpeed))
				)
			)
			(case MENU_VOLUME
				= hGauge (Gauge:new())
				= newVolume
					(send hGauge:
						text("Sound Volume")
						description("Use the mouse or the left and right arrow keys to adjust the volume.")

                        higher("Louder")
						lower("Softer")
						normal(15)
						doit(DoSound(sndVOLUME newVolume))
					)
				DoSound(sndVOLUME newVolume)
				DisposeScript(GAUGE_SCRIPT)
			)


			(case MENU_TOGGLESOUND
    ToggleSound()
			))
   )
   )

/******************************************************************************/
(procedure public (ToggleSound)
	(var SOUND_OFF)
	= SOUND_OFF DoSound(sndSET_SOUND)
	= SOUND_OFF DoSound( sndSET_SOUND not(SOUND_OFF) )
	(if(SOUND_OFF)
		SetMenu(MENU_TOGGLESOUND smMENU_TEXT "Turn On")
	)(else
		SetMenu(MENU_TOGGLESOUND smMENU_TEXT "Turn Off")
	)
)
/******************************************************************************/
