/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture 80
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
		)


		(send gTheMusic:
			prevSignal(0)

			stop()
			number(scriptNumber)
			loop(2)
			play()
		)

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
         = talkedBob FALSE
         = GuitarSee FALSE


)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState newState)
    = state newState
     (switch (state)
    (case 0
     (AlPond: init()setCycle(Walk))
        (Iq: init()setCycle(Walk))
        (AlPond:setMotion(MoveTo 180 80 RoomScript))
        (Iq:setMotion(MoveTo 160 120 RoomScript))

     )
     (case 1
     (Eigen:init()setCycle(End))
     )
     (case 2
     )
     )
     )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())

                // End the title screen, start the game
				(send gRoom:newRoom(976))

		    )
		)
	)
)
(instance AlPond of Act
  (properties
    y 30
    x 180
    loop 0
    view 300
    cycleSpeed 3
    moveSpeed 3
  )
)
(instance AlPond2 of Act
  (properties
    y 80
    x 180
    cel 0
    view 302
    cycleSpeed 3
    moveSpeed 3
  )
)
(instance Iq of Act
  (properties
    y 180
    x 160
    loop 0
    view 301
    cycleSpeed 3
    moveSpeed 3
  )
)
(instance Eigen of Act
  (properties
    y 160
    x 162
    loop 0
    view 303
    cycleSpeed 3
    moveSpeed 3
  )
)
/*
*****************************************************************************/
