/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "wander")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 2
		east 0
		south 0
		west 0
	)
	(method (init)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))
        (aDoor:init())
        (aPhone:init())
        (aDrawer:init())
        (aPic:init())
        (if(chiefTalk)
        (Note: init())


)

  		// Check which room ego came from and position it
      (switch(gPreviousRoomNumber)
  (case 2
  = drawerOpened FALSE
    (send gEgo:
      posn(200 105)
      loop(2)
    )

    (switch(gPreviousRoomNumber)
  (case 3
    (send gEgo:
      posn(180 155)
      loop(3)
    )
  )
  )
)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(default
  				(send gEgo:
  					posn(150 130)
  					loop(1)
  				)
  			)
  		)

      
    

		// Set up the ego

		SetUpEgo()
		(send gEgo:init())

   (send gTheMusic:
			prevSignal(0)
            stop()
			number(scriptNumber)
			loop(3)
			play()
		)


        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  )
)

/******************************************************************************/
(instance RoomScript of Script
	(properties)
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
(if(Said('take,look/note,paper'))
(if(chiefTalk)
(if(== (send gEgo:onControl()) ctlGREY)
= note TRUE
Print("It says: ")
Print("We knew you'd come back here. We'll give you a clue. Go to the souvenir salesman and ask him to bring you to us.\n\n Good luck, Al!")
return
)
Print("Move closer to that note.")
return
)
Print("I can't see any note! You're crazy!")
return

)
(if(Said('use,take,answer,call/phone'))
(if(== (send gEgo:onControl()) ctlRED)
(if(message2)
      Print("You check the phone but you don't have anymore messages.")


      return
 )(else
      = message2 TRUE
Print("You have got one new message.")
Print
(
"Hi Al. This is NBI calling. We wan't you to come here right away. We wanna talk to you.
Go to the casino. Our agent 12345 is waiting for you there. Come quick!"
#title "It says: "
)
(send gGame:changeScore(2))
return
)
)

Print("You're not close enough.")
)
(if(Said('open/drawer'))
(if(send gEgo:inRect(120 85 150 120))
if(drawerOpened)
Print("It's already opened.")
return
)(else
(if(send gEgo:has(INV_KEY))
Print("You open the drawer.")
(aDrawer: setCycle(End)y(110))
= drawerOpened TRUE
return
)
Print("You open the drawer and see a key in there.")
(aDrawer: setCycle(End)y(110))
= drawerOpened TRUE
return
)
Print("You're not close enough.")
)
(if(Said('close/drawer'))
(if(send gEgo:inRect(120 85 150 120))
Print("I don't want.")
return
)
Print("You're not close enough.")
)
(if(Said('open/door'))
  (if(send gEgo:has(INV_KEY))
    (aDoor:locked(FALSE))
  )(else
    (aDoor:locked(TRUE))
  )
(aDoor:open())
)
(if(Said('sit'))
(if(== (send gEgo:onControl()) ctlSILVER)
(if(sit)
Print("You're already sitting.")
return
)(else
Print("Ok")
= sit TRUE
(send gEgo:hide())
(aSit:show())
(aSit:init()
setCycle(End))
return
)
)
Print("Move closer to the sofa. By the way you can only sit on the left side because the right side of the sofa is too uncomfortable.")
)
(if(Said('stand'))
(if(sit)
= sit FALSE
SetUpEgo()
(send gEgo:init()
loop(2))
(send gEgo:show())
(aSit:hide()
cel(0))
)(else
Print("You're already standing.")
)
)
(if(Said('take/key'))
(if(drawerOpened)
  (if(send gEgo:has(INV_KEY))
    Print("You already have it!")
  )(else
    (if(send gEgo:inRect(120 85 150 120))
      Print("O.K.")
      = sit FALSE
      (send gGame:changeScore(3))
      (send gEgo:get(INV_KEY))
      (theKey:hide())
      return
    )(else
    Print("You're not close enough.")
 return
)
)
)
Print("From where?")
)
(if(Said('look>'))
(if(Said('/phone'))
(if(message2)
Print("This is a phone with answering machine.")
return
)
Print("This is a phone with answering machine. You have one new message.")
)(else
(if(Said('/desk'))
Print("It's just a desk with drawer.")
return
)(else
(if(Said('/drawer'))
(if(drawerOpened)
(if(send gEgo:has(INV_KEY))
Print("You look inside drawer and don't see anything.")
return
)
Print("You look inside drawer and see a key in there.")
return
)
Print("I can see a drawer.")
return
)(else
(if(Said('/picture'))
Print("There supposed to be tree and sea on picture.")
)(else
(if(Said('/floor'))
Print("You're standind on it. That's all you need to know.")
)(else
(if(Said('/wall'))
Print("Phone and picture are on wall. The color of these walls is horrible.")
)(else
(if(Said('/door'))
Print("This door leads to the hall. It needs key to open.")
)(else
(if(Said('/sofa,couch'))
Print("This is your own 'comfort' sofa.")
)(else
(if(Said('[ /* , !* ]'))
(if(chiefTalk)
Print("You're in your room. You got it from island goverment for saving the island. There's a phone and picture on wall. There's a note under the picture.")
return
)(else
Print("You're in your room. You got it from island goverment for saving the island. There's a phone and picture on wall.")
)))))))))))))
/******************************************************************************/

(instance theKey of Prop
  (properties
    x 140
    y 89
    view 400
  )
)
(instance sEgo of Prop
  (properties
    x 90
    y 172
    view 15
  )
)

(instance aDoor of Door
  (properties
    y 100
    x 195
    view 2
    entranceTo 2
    locked TRUE
  )
)

(instance aPic of Prop
  (properties
    y 60
    x 100
    view 4

  )
  
)
(instance Note of Prop
  (properties
    y 78
    x 94
    view 100

  )
)
(instance aPhone of Prop
  (properties
    y 76
    x 230
    view 6
  )
)
(instance aDrawer of Act
  (properties
    y 105
    x 130
    view 8
  )
)
(instance aSit of Act
  (properties
    y 172
    x 85
    loop 0
    view 15
  )
)
