/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 main.sc
 Contains  game's main instance and inventory items.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MAIN_SCRIPT)
/******************************************************************************/
(use "controls")
(use "sound")
(use "syswindow")
(use "cycle")
(use "game")
(use "inv")
(use "user")
(use "menubar")
(use "feature")
(use "obj")
(use "disposeload")
/******************************************************************************
 * These are the global variables. You can access them from any script as long
 * as it "use"es this script
 ******************************************************************************/
(local
	gEgo					/* points to the ego's class */
	gGame					/* points to the game instance */
	gRoom					/* points to the current room instance */
	gSpeed 					/* the game speed (delay each interpreter cycle) */
	gQuitGame = FALSE		/* if set to TRUE, the game will exit */

	gCast					/* points to the cast class (list of actors) */
	gRegions				/* points to the regions class (list of regions) */
	gLocales 				/* points to the locales class (list of locales) */
	gTimers					/* points to the timers class (list of timers) */
	gSounds					/* points to the sounds class (list of sounds) */
	gInv					/* points to the inventory class */
	gAddToPics				/* points to the add to pics class */
	gFeatures				/* points to the add to features class */
	gSFeatures				/* points to the add to sfeatures class */

	gRoomNumberExit			/* room number exit */
	gPreviousRoomNumber		/* the number of the previous room */
	gRoomNumber				/* the number of the current room */
	gDebugOnExit = FALSE	/* enter debug mode on room exit */

	gScore = 0				/* the game score */
	gMaxScore = 100			/* the maximum game score */
	gOldScore				/* previous score */

	gCurrentCursor			/* the number of the current cursor */
	gNormalCursor = 152		/* the number of the normal cursor (ie. arrow) */
	gLoadingCursor = 152	/* the number of the loading cursor (ie. hand) */

	gDefaultFont = 1		/* the number of the default font */
	gSaveRestoreFont = 0	/* the number of the font for the save/restore dialogs*/
	gDeadFont = 0			/* the number of the font for the dialog when ego dies */

	gUserEvent				/* points to the user's event object */
	gPrintDlg				/* points to the current Print() window */
	gVolume					/* the sound volume */
	gVersion				/* the version string */
	gSaveDirPtr				/* points to the save directory string */
	gCheckAniWait			/* the checkAni delay */
	gSetRegions				/* a flag -- see User:doit() */

	gPicAngle				/* the room's pic angle */
	gOverlay = -1			/* whether to overlay the picture when drawing */
	gDefaultPicAni			/* the default pic animation */
	gDefaultPalette			/* the default palette to use for the pictures (0-3) */
	gCastMotionCue			/* if set, the cast's motionCue() is called */

	gTheWindow				/* points to the window class */
	gWndColor				/* the colour of the game's windows foreground (ie. text) */
	gWndBack				/* the colour of the game's windows background */

	gOldPort				/* the previous port */

	gEgoView				/* ego's current view number */

	/* hh:mm:ss | gTimeHours:gTimeMinutes:gTimeSeconds */
	/* the time elapsed since the game started */
	gTimeSeconds			/* the seconds */
	gTimeMinutes			/* the minutes */
	gTimeHours				/* the hours */

	gCurrentTime				/* the current time in seconds */

	gTheMusic				/* points to the music class */
	gTheSoundFX				/* points to the sound fx class */
	gProgramControl 		/* states whether the program has control or the user */
	cheese
	cheesum
	contactsin
	sleeper
	 hEvent
	 taxer
	 standyn
	 sliphav
	 wearmitts
	 Praiseone
	 demonone
	 pandafeet
	 buffer[40]
	 firstname[40]
	 lastname[40]
	 lastspouse[40]
	 SSN
	 SSNspouse
	 address[40]
	 city[40]
	 wages[40]
	 interest[40]
	 unemployment[40]
	 linefour[40]
	 linesix[40]
	 withheld[40]
	 eic[40]
	 combat[40]
	 linenine[40]
	 plaintax[40]
	 lineeleven[40]
	 taxcurse
	 clotheson
	 duntaxes
	 takepic
	 picspot
	 katspot
	 plantspot
	 click
	 clickx
	 clicky
	 picres
	 opencab
	 opendrawer
	 lookmuch
	 maskon
	 satancount = 550
	 praisetwo
	 cancer
	 srion

)

/******************************************************************************/
(instance public Template of Game
	(properties)
	(method (init)
        // Set up the base window
		= gTheWindow theWindow
		= gWndColor clBLACK
		= gWndBack clWHITE
		(send gTheWindow:
			color(gWndColor)
		    back(gWndBack)
		)

        // Initialize
		(super:init())

        /******************************
         * Set your game version here *
         ******************************/
		= gVersion "1.0"

		// General initialization stuff
	    = gVolume 15
	    DoSound(sndVOLUME gVolume)

	    (SL:code(statusCode))
	    (TheMenuBar:init())

	    (scoreSound:
	    	owner(self)
	    	init()
	    )
	    = gTheMusic theMusic
	    (send gTheMusic:
	    	owner(self)
	    	init()
	    )
		= gTheSoundFX theSoundFX
	    (send gTheSoundFX:
	    	owner(self)
	    	init()
	    )

	    = gEgo ego
	    (User:
	    	alterEgo(gEgo)
	    	blocks(0)
	    	y(150)
	    )

		Load(rsFONT		gDeadFont)
		Load(rsFONT		gDefaultFont)
		Load(rsFONT		gSaveRestoreFont)

		Load(rsCURSOR	gNormalCursor)
		Load(rsCURSOR	gLoadingCursor)

	    (if(HaveMouse(0))

	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE))
		)
		(else
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE 304 174))
		)

        /*************************************************
         * Initialize the inventory with it's items here *
         *************************************************/
		(Inv:
			add(
				{Nothing}
				CONTACTS
				{Test Object}
				CONTACTSEMPTY
				Slippers
			    {Oven Mitts}
				SriSri
				Envelope
				{Coral Snake}
				Catheter
				{Surgical Mask}
				SriSriOff

			)
		)

		// Start the room
		(if(GameIsRestarting())
	    	(self:newRoom(INITROOMS_SCRIPT))
	    )(else
	    	(self:newRoom(TITLESCREEN_SCRIPT))
		)
	)
	(method (doit)
		(super:doit())



		(if(gProgramControl)
			(User:
				canControl(FALSE)
				canInput(FALSE)
			)
		)
		(if(<> gCurrentTime (= gCurrentTime GetTime(gtTIME_OF_DAY)))
		    (if(>= ++gTimeSeconds 60)
		    	= gTimeSeconds 0
		    	++ gTimeMinutes
		    	(if(>= gTimeMinutes 60)
		    		= gTimeMinutes 0
		    		++ gTimeHours
		    	)
			)
		)
  		(if(> gOldScore gScore)
		    	= gOldScore gScore
				(SL:doit())
		)
		(if(< gOldScore gScore)
		    = gOldScore gScore
			(SL:doit())
		)
	)
	(method (replay)
  		(TheMenuBar:draw())
  		(SL:enable())

  		(if(DoSound(sndSET_SOUND))
		    SetMenu(MENU_TOGGLESOUND #text "Turn Off")
		)(else
		    SetMenu(MENU_TOGGLESOUND #text "Turn On")
		)
		(super:replay())
	)
	(method (newRoom roomNum picAni)
  			DisposePrintDlg()
  			Load(rsFONT		gDeadFont)
  			Load(rsFONT		gDefaultFont)
  			Load(rsFONT		gSaveRestoreFont)

  			Load(rsCURSOR	gNormalCursor)
  			Load(rsCURSOR	gLoadingCursor)

			(super:newRoom(roomNum))
			(if(< paramTotal 2)
				= gDefaultPicAni Random(0 5)
			)(else
				= gDefaultPicAni picAni
			)
	)
	(method (startRoom roomNum)
		DisposeLoad(
			NULL
			FILEIO_SCRIPT JUMP_SCRIPT EXTRA_SCRIPT WINDOW_SCRIPT
		        TIMER_SCRIPT FOLLOW_SCRIPT REV_SCRIPT DCICON_SCRIPT
		        DOOR_SCRIPT AUTODOOR_SCRIPT WANDER_SCRIPT AVOID_SCRIPT
		)
		DisposeScript(DISPOSELOAD_SCRIPT)
		(if(gDebugOnExit)
			= gDebugOnExit FALSE
			SetDebug()
		)
		(send gTheSoundFX:
			stop()
			number(1)
		)
		(super:startRoom(roomNum))
		(if(== gTheSoundFX 11)
		 	(send gEgo:baseSetter(NormalBase))
		)
	)
	(method (changeScore addScore)
		= gScore + gScore addScore
		(if(> addScore 0)
				(send gTheMusic:
							prevSignal(0)
			stop()
						number(44)
						loop(-1)
						play()
				    )
		)
	)
  	(method (handleEvent pEvent)

      	//////////////////////////////////////////////////////////////////////
		// ** This is debug functionality                                   //
		// ** Comment it out if you don't want people to cheat in your game //
            //////////////////////////////////////////////////////////////////////
             (if((== picres 1) and (== evKEYBOARD (send pEvent:type)))
             	  = picspot Display("                                                                                        "
                    dsCOORD clickx clicky
                    dsALIGN alCENTER
                    dsCOLOUR clCYAN
                    dsBACKGROUND -1
                    dsWIDTH 80
                    dsSAVEPIXELS
								 )
             	  = picres Print(
  						"Want do you desire for\nyour beautiful picture?"
  						#title "SriSri Viewmaster:"
  						#font gDeadFont
  						#button "Cherish"  1
  						#button "Let Go"  2

								 )
  					(switch(picres)
  						(case 1
  							(if(< GetDistance(280 85 clickx clicky) 30)
  								(send gGame:changeScore(3))


							)
							DrawPic(gRoomNumber dpOPEN_INSTANTLY dpCLEAR )
							(send gEgo:show())
								= picres 0
  								return
						)

		    			(case 2
  							DrawPic(gRoomNumber dpOPEN_INSTANTLY dpCLEAR )
  							(send gEgo:show())
  								= clickx 0
  								= clicky 0
  								= picres 0
  								= picspot 0
  							return

						)

					)
			 )



	      (if (== evKEYBOARD (send pEvent:type))
	         // Check for ALT keys
	         (switch (send pEvent:message)
	            (case $2f00 // alt-v
	               Show(1) // Show visual
	            )
	            (case $2e00 // alt-c
	               Show(4) // Show control
	            )
	            (case $1900 // alt-p
	               Show(2) // Show priority
	            )
	            (case $3200 // alt-m
	               // Show memory usage
	                  ShowFree()
	                  FormatPrint(
	                      "Free Heap: %u Bytes\nLargest ptr: %u Bytes\nFreeHunk: %u KBytes\nLargest hunk: %u Bytes"
	                      MemoryInfo(miFREEHEAP)
	                      MemoryInfo(miLARGESTPTR)
	                      (>> MemoryInfo(miFREEHUNK) 6)
	                      MemoryInfo(miLARGESTHUNK)
								 )
	            )
	            (case $1400 // alt-t
	               // teleport to room
	                    (send gRoom:newRoom(GetNumber("Which Room Number?")))
	            )
	            (case $1700 // alt-i
	               // get inventory
	               (send gEgo:get(GetNumber("Which inventory#?")))
	            )
	            (case $1f00 // alt-s
	               // Show cast
	               (send gCast:eachElementDo(#showSelf))
	            )
			 )
	      )



	      ////////////////////////////////////////////////////
	      // End of debug functionality                     //
	      ////////////////////////////////////////////////////

		(super:handleEvent(pEvent))
		(if((<> (send pEvent:type) evSAID) or (send pEvent:claimed))
		    return(TRUE)
		)

        /***********************************/
        /* Add global said statements here */
        /***********************************/
        (if(Said('srisri / picture') and (send gEgo:has(INV_SRISRI)))
			  		= gNormalCursor 153
			(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE 304 174))
			= takepic 1

		)
		(if(Said('remove/mask') and (== (send gEgo:view) 6))
			(if(<> gRoomNumber 6)
= maskon 0
			(send gEgo:view(0))
			)
			(else
				Print(1 0)

			)
		)

		(if(Said('praise/satan') and (== Praiseone 1))
			Print(1 1)
			= praisetwo 1
		)
	(if(Said('press/button'))
	
		(if(send gEgo:has(INV_SRISRIOFF))
(send gEgo:put(INV_SRISRIOFF))
(send gEgo:get(INV_SRISRI))
Print(1 2)




		)
		(else
			(if(send gEgo:has(INV_SRISRI))
				(send gEgo:get(INV_SRISRIOFF))
(send gEgo:put(INV_SRISRI))
Print(
  "When I return, my fist will be one with your face!"
  #title "SriSri"
  #font LARGE_FONT
  #icon 97 3 0
) 
			)
				
		)
	)
	
	(if((Said('srisri / returntoinnocence')) and (send gEgo:has(INV_SRISRI)))
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(47) 
			loop(-1)
			play()
		)
	)
		(if(Said('wear,don / mask'))
			(if(send gEgo:has(INV_MASK))
			(if(== (send gEgo:view) 6)
				Print(1 3)
			)
			(if(== (send gEgo:view) 0)
				(if(== gRoomNumber 6)
					Print(1 4)
				)
				(else
				(send gEgo:view(6))
				= maskon 1
				Print(1 5)
				)
			)
			(if((<> (send gEgo:view) 0) and (<> (send gEgo:view) 6))
				Print(1 6)
			)
			)
		(else
			Print(1 7)
		)
		)

		(if(Said('show / picture') and (<> picspot 0))


			Display(""
				dsRESTOREPIXELS picspot
				   )
				   DrawCel(90 0 0 (- clickx 10) (- clicky 3) 15)
				 = picres 1
					(send gEgo:hide())
		)
		(else
			(if(Said('show / picture'))
			Print(1 8)
		)
		)

        (if(Said('hi'))
            Print(1 9)
        )


 (if(Said('look >') and (== contactsin 0) and (not (send gEgo:has(INV_CONTACTS))) and (not (send gEgo:has(INV_CONTACTSEMPTY))) and (== lookmuch 3))
  	Print(1 10)
  	Print(1 11)
  	Print(1 12)
						= lookmuch 0
						(send pEvent:claimed(TRUE))

 )
 (if(Said('look >') and (== contactsin 0) and (not (send gEgo:has(INV_CONTACTS))) and (not (send gEgo:has(INV_CONTACTSEMPTY))) and (<> lookmuch 3))
  	Print(1 10)
  	++lookmuch
						(send pEvent:claimed(TRUE))
 )
 (if(Said('look >') and (== contactsin 0))
  	Print(1 10)
  							(send pEvent:claimed(TRUE))
 )

		return(FALSE)
  	)
)
/******************************************************************************/
(class Iitem of InvI
	(properties
		said 0
		description 0
		owner 0
		view 0
		loop 0
		cel 0
		script 0
	)
	(method (showSelf)
		Print(
            description
			#title objectName
			#icon view loop cel
		)
	)
)

/******************************************************************************/
(instance statusCode  of Code
	(properties)
 	(method (doit param1)
  		Format(param1 " Score: %d of %-3d     The Cave of Whistling Skulls " gScore gMaxScore)
 	)
)
/******************************************************************************/
(instance ego of Ego
	(properties
		y 1111
		x 0
		z 0
		heading 0
		yStep 2
		view 0
		loop 0
		cel 0
		priority 0
		underBits 0
		signal $2000
		nsTop 0
		nsLeft 0
		nsBottom 0
		nsRight 0
		lsTop 0
		lsLeft 0
		lsBottom 0
		lsRight 0
		brTop 0
		brLeft 0
		brBottom 0
		brRight 0
		cycleSpeed 0
		script 0
		cycler 0
		timer 0
		illegalBits $8000
		xLast 0
		yLast 0
		xStep 3
		moveSpeed 0
		blocks 0
		baseSetter 0
		mover 0
		looper 0
		viewer 0
		avoider 0
		edgeHit 0
	)
)
/******************************************************************************/
(instance scoreSound of Sound
	(properties
		state 0
		number SCORE_SOUND
		priority 10
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theMusic  of Sound
	(properties
		state 0
		number 1
		priority 0
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theSoundFX  of Sound
	(properties
		state 0
		number 1
		priority 5
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theWindow  of SysWindow
	(properties)
	(method (open)
		(if(< Graph(grGET_COLOURS) 9)
			(if( (< color 7) or (== color 8) )
				= color 0
				= back  15
			)(else
				= color 15
				= back  0
			)
  		)
  		(super:open())
	)
)
/******************************************************************************/
(instance NormalBase of Code
	(properties)
	(method (doit)
		(var temp0)
		(if(== gRoomNumberExit 253)
		    = temp0 22
		)(else
  			= temp0 10
		)
		(send gEgo:
			brBottom(
				(+ (send gEgo:y) 1)
			)
		)
		(send gEgo:
			brTop(
				(- (send gEgo:brBottom) (send gEgo:yStep))
			)
		)
		(send gEgo:
			brLeft(
				(- (send gEgo:x) temp0)
			)
		)
		(send gEgo:
			brRight(
				(+ (send gEgo:x) temp0)
			)
		)
	)
)

/******************************************************************************
 * THE PUBLIC PROCEDURES
 ******************************************************************************/
(procedure public (SetUpEgo theLoop theView)
	PlayerControl()
	(send gEgo:edgeHit(EDGE_NONE))
	(switch(paramTotal)
		(case 0
			SetUpActor(gEgo (send gEgo:loop) gEgoView)
		)
  		(case 1
			SetUpActor(gEgo theLoop gEgoView)
		)
  		(case 2
		    SetUpActor(gEgo theLoop theView)
  		)
	)
)
/******************************************************************************/
(procedure public (SetUpActor pActor theLoop theView)
	(if(> paramTotal 1)
		(send pActor:loop(theLoop))
	)
	(if(> paramTotal 2)
		(send pActor:view(theView))
	)
	(send pActor:
		setLoop(-1)
		setPri(-1)
		setStep(3 2)
		setCycle(Walk)
		illegalBits($8000)
		cycleSpeed(0)
		moveSpeed(0)
		ignoreActors(0)
	)
)
/******************************************************************************/
(procedure public (ProgramControl)
	(User:
		canControl(FALSE)
		canInput(FALSE)
	)
	(send gEgo:setMotion(NULL))
)
/******************************************************************************/
(procedure public (PlayerControl)
	(User:
		canControl(TRUE)
		canInput(TRUE)
	)
	(send gEgo:setMotion(NULL))
)
/******************************************************************************/
(procedure public (DisposePrintDlg)
	(if(gPrintDlg)
		(send gPrintDlg:dispose())
	)
)
/******************************************************************************/
(procedure public (PrintOK)
	Print("O.K.")
)
/******************************************************************************/
(procedure public (PrintItIs)
	Print("It is.")
)
/******************************************************************************/
(procedure public (PrintYouAre)
	Print("You are.")
)
/******************************************************************************/
(procedure public (PrintGoodIdea)
	Print("Good idea. You might try that again later.")
)
/******************************************************************************/
(procedure public (PrintNotCloseEnough)
	Print("You're not close enough.")
)
/******************************************************************************/
(procedure public (PrintAlreadyTookIt)
	Print("You already took it.")
)
/******************************************************************************/
(procedure public (PrintDontHaveIt)
	Print("You don't have it.")
)
/******************************************************************************/
(procedure public (PrintCantDoThat mem)
	(if(> MemoryInfo(miLARGESTPTR) mem)
		return(TRUE)
	)(else
		Print("You can't do that here; at least, not now.")
		return(FALSE)
	)
)
/******************************************************************************/
(procedure public (AddViewToPic pView)
	(var hView)
	(if(pView)
		= hView (View:new())
		(send hView:
		  	view(send pView:view)
			loop(send pView:loop)
			cel(send pView:cel)
			priority(send pView:priority)
			posn( (send pView:x) (send pView:y) )
			addToPic()
		)
		(send pView:
			posn( (send pView:x) (+ 1000 (send pView:y)) )
		)
	)
)
/******************************************************************************/
(procedure public (SetInvIOwner index owner)
	(var hInvI)
	= hInvI (send gInv:at(index))
	(if(< paramTotal 2)
		(send hInvI:owner(gRoomNumberExit))
	)(else
		(send hInvI:owner(owner))
	)
)


/******************************************************************************
 * THE INVENTORY ITEMS                                                        *
 ******************************************************************************/
(instance Nothing  of Iitem
	(properties)
)
/******************************************************************************/


(instance CONTACTS of Iitem
	(properties
		said 'case'
		description
             "Plastic case for your Opticave 2X lens with Astigamtism-Control. For eyesight more strained than a bowl of pasta. (meh)"
		owner 0
		view 32
		loop 0
		cel 0
		script 0
	)
)
(instance CONTACTSEMPTY of Iitem
	(properties
		said 'lenses'
		description
             "Empty plastic case for your Opticave 2X lens with Astigamtism-Control. For eyesight more strained than a bowl of pasta. (meh)"
		owner 0
		view 32
		loop 0
		cel 0
		script 0
	)
)

(instance Slippers of Iitem
	(properties
		said 'slippers'
		description
             "Overstuffed, wooly Mello Panda slippers. They smell faintly of fish."
		owner 0
		view 13
		loop 0
		cel 0
		script 0
	)
)
(instance {Oven Mitts} of Iitem
	(properties
		said 'mitts'
		description
             "Thermally-impervious oven mitts. They come in red. Protects your grubby digits from the wrath of your casseroles. The mouths of your dinner guests are afforded no such protection."
		owner 0
		view 29
		loop 0
		cel 0
		script 0
	)
)
(instance SriSri of Iitem
	(properties
		said 'tree'
		description
             "A black-market DroneFone smartphone device. Functionality includes camera, GPS, midi player, and search modes."
		owner 0
		view 97
		loop 0
		cel 0
		script 0
	)
)

(instance Envelope of Iitem
	(properties
		said 'envelope'
		description
             "A manilla envelope containing your 1040, ready to ship. It has a small drool stain at the corner because of your insistence on licking the already-adhesive postage."
             owner 0
		view 98
		loop 0
		cel 0
		script 0
	)
)
(instance {Coral Snake} of Iitem
	(properties
		said 'snake'
		description
             "Your orphaned coral snake, Hisses. You are careful not to jostle her."
		owner 0
		view 34
		loop 0
		cel 0
		script 0
	)
)
(instance {Surgical Mask} of Iitem
	(properties
		said 'mask'
		description
             "The surgical mask from the bag of medical waste. A kind of diaper for your nose and mouth."
		owner 0
		view 35
		loop 0
		cel 0
		script 0
	)
)
(instance Catheter of Iitem
	(properties
		said 'catheter'
		description
             "A plastic catheter. Inserted up the yoohoo to facilitate wee-wee."
		owner 0
		view 183
		loop 0
		cel 0
		script 0
	)
)

(instance {Test Object} of Iitem
	(properties
		said 'object'
		description
             "This is a test object in your inventory."
		owner 0
		view 800
		loop 0
		cel 0
		script 0
	)
)
(instance SriSriOff of Iitem
	(properties
		said 'srisrioff'
		description
             "A black-market DroneFone smartphone device. Functionality includes camera, GPS, midi player, and search modes. Currently off."
		owner 0
		view 97
		loop 2
		cel 0
		script 0
	)
)
/******************************************************************************/



