/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
/******************************************************************************/
(local

	sleepist
	hWnd
	oldPort
	sleepum[20]
	happy
	mbPesult
	savecel
	saveloop
	knotup

	Nope = 50
	sleeptime
)


(instance public rm001 of Rm
	(properties
		picture 895
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
 		(method (init)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))

  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room

            (case east
            	(send gEgo:
            		posn(200 190)
            		loop(1)
				)
			)

  			(default
  				(send gEgo:
  					posn(165 162)
  					loop(0)
  				)
  			)
  		)

		// Set up the ego
		SetUpEgo()


	(send (View:new()):view((Slippers:view))loop(0)cel(0)posn((Slippers:x) (Slippers:y))setPri(6)ignoreActors()addToPic())
		(Kontacts:init())

	(send (View:new()):view((Plant:view))loop(0)cel(0)posn((Plant:x) (Plant:y))setPri(12)ignoreActors()addToPic())
		(Kontacts:setPri(3))
	

			(SleepKat:init())
(SleepKat:setCycle(Fwd))
(SleepKat:setPri(15))
        
        
        
        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
	(method (doit)
		(super:doit())

	)


	(method (handleEvent pEvent)
		(var dyingScript)
        (super:handleEvent(pEvent))
        (if(Said('(wake < up), awaken'))
        	(if(== sleepist 0)
        		(send gGame:changeScore(1))

        	= sleepist 1
        	= knotup 1

        	Print("You start from your heavy slumber to a slowly familiar room. The last tremors from your linebacker apnea die in the picture frames.")
        	Print("You have the sense of being suddenly cut free from a thing dragging you at speed, and a few vague snippets of dream, fading quickly.")
        	Print("There is cold sweat on the pillow.")
        	(SleepKat:setLoop(1))
       (send gRoom:newRoom(80))







			)

        	(else
        		Print("You pinch yourself hard enough to draw blood. No dice.")
			)
		)
        (if(== knotup 1)

        (if(Said('look >'))
        	(if(== contactsin 1)
        	        	(if(Said('look / tree'))
        	        		Print("Tis but a shrubbery.")
						)

						(if(Said('look / bed'))
							Print("Your filthy filthy bed. You may make it lie in it.")
						)
						(if(Said('look'))
							Print("Your room.")

						)
			)




        	        	(else

					Print("You see some kind of blobbish, hazy tableau. I dunno.")
						)

		)




        (if(Said('take/contacts'))
  (if((send gEgo:has(INV_CONTACTS)) and (== standyn 1))
    Print("You already have it!")
  )(else
    (if(<  GetDistance((send gEgo:x) (send gEgo:y) 106 117) 50)
      Print("O.K.")
      (send gEgo:get(INV_CONTACTS))
      = contactsin 0
      (Kontacts:hide())
    )(else
      Print("You're not close enough!")
    )
  )
		)
		(if( (Said('wear/contacts')) and (send gEgo:has(INV_CONTACTS)) and (== contactsin 0))
			Print("Gingerly, you sucker the lenses to your eyes, and the world appears in a hawk-like 320 x 200 resolution.")
			= contactsin 1
			(send gEgo:put(INV_CONTACTS))
			(send gEgo:get(INV_CONTACTSEMPTY))

		)

			(if( (Said('wear/contacts')) and not(send gEgo:has(INV_CONTACTS)))
			Print("Impossible, for one reason or another.")
		)

        (if( (Said('remove/contacts')) and (== contactsin 1))
        	Print("You pluck the lenses from your eyes and stow them in their case.")
        	(send gEgo:put(INV_CONTACTSEMPTY))
        	(send gEgo:get(INV_CONTACTS))
        	= contactsin 0
		)

        	(if( Said('remove/contacts') and (== contactsin 0))
        	Print("Impossible, for one reason or another.")
		)






	(if(Said('remember / dream'))


		(if(== sleeper 0)
			Print("You dreamt of daffodils.")
			)
			(else
				Print("The dream has faded from mind.")
			)
	)
	(if( Said('get / time') and (< Nope 10))
		Print("Under 10!")
	)
	(if(Said('get / time') and (> Nope 10))
		Print("Over 10!")
	)


	   (if(Said('stand'))
	   	(send gEgo:init())
        	(SleepKat:hide())
        	= standyn 1

	   )



(if((Said('get < up')) and (== standyn 0))
 		= dyingScript ScriptID(DYING_SCRIPT)
  Print("Sitting bolt upright, you lunge from the edge of the bed, only to be met with a muffled 'pop' from inside your skull, as the clot you've thrown lodges in your delicate frontal cortex.")
  Print("As the stroke takes hold, your last words, slurred out the left side of your mouth, are: 'Gofsh, thiff floor iff weely cohwd.'")
  (send dyingScript:
    caller(62)
    register("Hope you halved yourself a good time!")

 )
  (send gGame:setScript(dyingScript))
)





		)
		(else
			(if((== evSAID (send pEvent:type)) and (not (send pEvent:claimed)))
				Print("You're in no position to make commands.")
				(send pEvent:claimed(TRUE))
			)
		)
		)

(method (changeState newState)
		(= state newState)
		(switch (newState)
			(case 0







				// Handle state changes
			)



		)
)


	)


(instance SleepKat of Prop
	(properties
		x 203
		y 145
		view 5
		loop 0
	)

)
(instance Opendrawer of Prop
	(properties
		x 111
		y 136
		view 111
		loop 0
	)

)
(instance Froze of Prop
	(properties
		x 140
		y 169
		view 24
		loop 2
	)
)
(instance Slippers of Prop
	(properties
		x 145
		y 172
		view 13
		loop 0
	)

)
(instance Kontacts of Prop
	(properties
		x 106
		y 117
		view 19
		loop 0
	)

)
(instance Plant of Prop
	(properties
		x 250
		y 85
		view 23
		loop 0
	)

)

(instance Meter of Prop
	(properties
		x 235
		y 162
		view 64
		loop 0
	)

)
/******************************************************************************/

