/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 30)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
die
dying
)
/******************************************************************************/
(instance public rm030 of Rm
	(properties
		picture scriptNumber
		north 27
		east 0
		south 0
		west 31
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))
            (send gRoom:horizon(84))

		(switch(gPreviousRoomNumber)
			(case 27
				(send gEgo:
					posn(Xposn 85)
					loop(2)
				)
			)
   	(case 31
				(send gEgo:
					posn(4 Yposn)
					loop(0)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
   (method (handleEvent pEvent)
(super:handleEvent(pEvent))
 (if(Said('look>'))
(if(Said('/sky'))
Print("The sky has a very strange colour. Also you can see some clouds in the sky.")
)
(if(Said('/cloud'))
Print("These \"clouds\" look more like some dust.")
)
(if(Said('/sand,ground'))
Print("This ground looks dangerous. Better be careful.")
)
(if(Said('/mountain'))
Print("Aaah...what a great nature view.")
)
(if(Said('/view,panorama'))
Print("The view looks nice. You wish you had a view like that from your home window.")
)
(if(Said('/[ /* , !* ]'))
Print("Another boring screen of sand and stuff. Aaah....")
)
)
)
       (method (changeState newState)
         (var dyingScript)
  = state newState
  (switch (state)
    (case 0
= cycles 1


    )
    (case 1
    (send gGame:setSpeed(3))
        (send gEgo: hide())
       = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("You just sank into the sand. Be more careful!")
  )
  (send gGame:setScript(dyingScript))

   )
   )
   )
 (method(doit)
 (if(==(send gEgo: onControl()) ctlRED)
  (if(not(dying))
 = dying TRUE
 ProgramControl()
 (send gEgo: view(701) cycleSpeed(2) setCycle(End RoomScript))
 )
 )

 (if(==(send gEgo: onControl()) ctlNAVY)
  (if(not(dying))
 = dying TRUE
 ProgramControl()
 (send gEgo: view(701) cycleSpeed(2) setCycle(End RoomScript))
 )
 )
 
 )
)

/******************************************************************************/
