/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 104)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
over
yyy
)
/******************************************************************************/
(instance public rm104 of Rm
	(properties
		picture scriptNumber
		north 0
		east 108
		south 101
		west 102
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 101
				(send gEgo:
					posn(174 184)
					loop(3)
				)
			)
   (case 102
				(send gEgo:
					posn(5 145)
					loop(0)
				)
			)
    (case 108
				(send gEgo:
					posn(315 144)
					loop(1)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
   (if(not(send gEgo: has(INV_MAZE_MAP)))
 (aMap: init())
 )
  (if(not(send gEgo: has(INV_BOARD)))
    (aWood: init())
 )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
 (method (handleEvent pEvent)
(super:handleEvent(pEvent))
  (if(Said('take/board,(wooden<board),wood'))
   (if(< (send gEgo:distanceTo(aWood)) 40)
   (if(send gEgo: has(INV_BOARD))
   Print("You already took it.")
   return
   )
   Print("You pick up the wooden board.")
(send gEgo: get(INV_BOARD))
+ gScore 3
(aWood: dispose())
return
  )
   Print("You've got to move closer.")
   )
(if(Said('look>'))
(if(Said('/door,doorway'))
Print("It leads to another room.")
)
(if(Said('/floor'))
(if(send gEgo: has(INV_MAZE_MAP))
Print("It's just a stone floor.  A bit different than everywhere else. Just a bit.")
return
)
Print("It's just a stone floor. There's a paper, what looks like a map, on the ground.")
)
(if(Said('/marking,markings'))
Print("There is none in this room.")
)
(if(Said('/paper,map'))
(if(send gEgo: has(INV_MAZE_MAP))
Print("You have it in your inventory. Press TAB to see it.")
return
)
Print("Pick it up to have a closer look.")
)
(if(Said('/board,(wooden<board)'))
Print("There's not much interesting about it. Just pick it up.")
)
(if(Said('/wall'))
Print("On closer look you discover nothing special on the walls.")
  (if(not(send gEgo: has(INV_BOARD)))
  Print("A wooden board is placed against the wall.")
  )
)
(if(Said('/'))
(if(send gEgo: has(INV_MAZE_MAP))
Print("You're in one of the rooms of the maze. The walls contain lots of scratches and stuff.")
return
)
Print("You're in one of the rooms of the maze. The walls contain lots of scratches and stuff.")
Print("There's a paper, what looks like a map, on the ground.")
)
)


(if(Said('take/map,paper'))
(if(send gEgo: has(INV_MAZE_MAP))
Print("You already took it.")
return
)
Print("Ok")
(aMap: hide())
(send gEgo: get(INV_MAZE_MAP))
Print("To view your map, type 'use map'")
Print("This map is not essential to pass this maze. Try without the map first and when you're stuck, use it.")
return
)

)

 (method(changeState newState)
  (var dyingScript)
 = state newState
 (switch(state)
 (case 0
 )
 (case 1
    (send gEgo: hide())
   (aHole: setMotion(MoveTo (send gEgo: x) yyy RoomScript))
    )
    (case 2
   ShakeScreen(8 ssFULL_SHAKE)


   (send gEgo: hide())
      = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("You're flatter than a flat pancake.")
  )
  (send gGame:setScript(dyingScript))
 )
 )
 )
 (method(doit)
 (if(==(send gEgo: onControl()) ctlRED)
 (if(not(over))
 (aHole: ignoreControl(ctlWHITE))

  ProgramControl()
 = over TRUE
 = yyy (send gEgo: y)
 -= yyy 2
 (send gGame: setSpeed(0))
 (aHole: init() posn((send gEgo: x) 0) setMotion(MoveTo (send gEgo: x) yyy RoomScript))

 )
 )

 )
)
(instance aHole of Act
(properties
view 101
x 1
y 1
))
(instance aMap of Act
(properties
view 103
x 165
y 175
))
(instance aWood of Act
(properties
view 67
x 275
y 109
cel 2
))
/******************************************************************************/
