/*---------------------------------------------------------/
/ "Blackjack" game for Dr.Jummybummy's Space Adventure 2
/ Coded By Eigen Lenk
/----------------------------------------------------------/
/ Views used: view.167, view.168, view.169, view.170, view.171, view.104
/ Pics: pic.132
/ Needs a room 888 (used to restart the game). Just put (send gRoom: newRoom(132)) to that script(888)
/ Uses two global variables:  'money'  and  'bet'
/ I use them to show Cash: and Bet: on the top-menu.
/ It could use a little tweaking so that there wouldn't be two or more exact same cards on the playfield.
----------------------------------------------------------------------*/
(include "sci.sh")
(include "game.sh")
(script 132)
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
pCards //Player amount of cards
cCards //Computer amount of cards
pTotal //Player sum
cTotal //Computer sum
cCards2
pCards2

cAdd
pAdd

cType[6]
cCard[6]

pType[6]
pCard[6]

cStand = 0 //if set to 1, dealer stands/draws
pStand = 0 //same with player

gameOver2 = FALSE

value1 // two variables used in checking if dealer wishes to draw/stand
value2
)
(instance public rm132 of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
		(super:init())
		(self:setScript(Blackjack))
        (aB: init()) //init back button
        = gTimeSeconds 1
        = gTimeSeconds2 1
(if(not(== gPreviousRoomNumber 888))
//if game is restarted, don't start the music again, only when coming from casino room
        (send gTheMusic:
			prevSignal(0)
			stop()
			number(176)
			loop(-1)
			play()
		)
  )
= gTimeSeconds2 0
(if(> bet money)
= bet money
)
(if(> bet 50)
= bet 50
)
(SL: doit())
GetBet()
SaveSpeed(0)   // remove that line in your game, but set your game speed to 0 here
               //I have a function that saves the current speed, and sets a new one shown in the brackets.
               //Later, I can use RestoreSpeed to restore the speed saved earlier
ComputerFirstCard() //draw the first card of dealer

))
/******************************************************************************/
(instance Blackjack of Script
(properties)
(method(doit)
(if(== gTimeSeconds2 1)
Display("Take A Card" dsCOORD 60 170 dsFONT 900 dsCOLOR 1)
Display("Stand" dsCOORD 200 170 dsFONT 900 dsCOLOR 1)
Display("Take A Card" dsCOORD 59 169 dsFONT 900 dsCOLOR 9)
Display("Stand" dsCOORD 199 169 dsFONT 900 dsCOLOR 9)
= gTimeSeconds2 0
)
)
(method (handleEvent pEvent)
(if( not (super:handleEvent(pEvent)) )
  (if(not (& (send pEvent:modifiers) emRIGHT_BUTTON))
  // help text
 /*  Print("Your objective is to get the total value of your cards as close as possible to 21. But make sure you don't bust yourself. Once you think you have enough, click Stand. When dealer stands, take a few more cards, if needed, and click Stand too. You can bet within the range of your money. The maximum bet is 50." #title "Blackjack:")
  Print("Each card has a value:\n\nKing - 10\nQueen - 10\nAce - 1 or 11.\n\n The rest have value as shown on cards.")
   */
    (if(> (send pEvent:y) 0  and (if(< (send pEvent:y) 12)))   //   BACK
  (if(< (send pEvent:x) 45 and (if(> (send pEvent:x) 15)))
  (if(not(gameOver2))
     (if(== pCards 0)
     (send gRoom: newRoom(88)) //return to casino
   return
   )
Print("You have to wait until the end of current game.")
 return
 )
 RestoreSpeed()  //remove that line, it's my ego speed function
 (send gRoom: newRoom(88))

 ))
   (if(> (send pEvent:y) 77  and (if(< (send pEvent:y) 88)))   //   YES
   (if(< (send pEvent:x) 97 and (if(> (send pEvent:x) 84)))
   (if(gameOver2)
  RestoreSpeed() //remove that line, it's my ego speed function
  (send gRoom: newRoom(888))
   )
   )
   )
      (if(> (send pEvent:y) 77  and (if(< (send pEvent:y) 88)))   //   NO
   (if(< (send pEvent:x) 124 and (if(> (send pEvent:x) 105)))
   (if(gameOver2)
    (send gRoom: newRoom(88)) //return to casino
   return
   )
   )
   )
   (if(> (send pEvent:y) 170  and (if(< (send pEvent:y) 180)))   //   STAND
  (if(< (send pEvent:x) 240 and (if(> (send pEvent:x) 199)))
  (if(gameOver2) return )
   (if(>= cStand 1)
 (if(< cTotal pTotal)
 (if(> pTotal 21)
 DrawPic(132) Display("Player busted" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver3()
return
 )
  DrawPic(132) Display("Player wins" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver()
return
 )
 (if(> cTotal pTotal)
  (if(> cTotal 21)
 DrawPic(132) Display("Dealer busted" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver()
return
 )
 DrawPic(132) Display("Dealer wins" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver3()
return
 )
 (if(== cTotal pTotal)
= gameOver2 TRUE
(c1: view(cType[1]) cel(cCard[1]))
DrawPic(132) Display("No winner" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
Display("Again?  Yes  No" dsCOORD 25 80 dsFONT 900 dsCOLOR 2)
Display("Again?  Yes  No" dsCOORD 24 79 dsFONT 900 dsCOLOR 12)
return
 )

   )
   (if(== pStand 0)
  (if(>= pCards 1)    //player has to have at least 1 card
DrawPic(132) Display("Player stands" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
  = pStand 1
  (if(< cTotal pTotal) //dealer has less than pl, risks and takes another card
  (if(not(== cTotal 21))
  ComputerCard()
   )
  ) //if deal. has more, takes no card
  (if(> cTotal 21)
 DrawPic(132) DrawPic(132) Display("Dealer busted" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
 GameOver()
    return
  )
  DrawPic(132) DrawPic(132) Display("Dealer wins" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver3()

 ))))
 
  (if(> (send pEvent:y) 170  and (if(< (send pEvent:y) 180)))   //   take card
  (if(< (send pEvent:x) 150 and (if(> (send pEvent:x) 60)))
    (if(gameOver2) return )
  (if(<= gTimeSeconds 1) return )
    = gTimeSeconds 0
    += pCards 1
  (if(== pType[pCards] 0)
= pType[pCards] Random(167 170)
= pCard[pCards] Random(2 14)
= pAdd pCard[pCards]
(if(== pCard[pCards] 11) = pAdd 10 )
(if(== pCard[pCards] 12) = pAdd 10 )
(if(== pCard[pCards] 13) = pAdd 10 )
(if(== pCard[pCards] 14)
= pAdd Print("You got an ace. Do want it to have a value of 1 or 11?" #title "You got an ace card" #button "1" 1 #button "11" 11)
)
   //draw the next player card
  (if(== pCards 1) (p1: init() view(pType[pCards]) cel(pCard[pCards]) yStep(2) setMotion(MoveTo (p1: x) 140))  )
  (if(== pCards 2) (p2: init() view(pType[pCards]) cel(pCard[pCards]) yStep(2) setMotion(MoveTo (p2: x) 140))  )
  (if(== pCards 3) (p3: init() view(pType[pCards]) cel(pCard[pCards]) yStep(2) setMotion(MoveTo (p3: x) 140))  )
  (if(== pCards 4) (p4: init() view(pType[pCards]) cel(pCard[pCards]) yStep(2) setMotion(MoveTo (p4: x) 140))  )
  (if(== pCards 5) (p5: init() view(pType[pCards]) cel(pCard[pCards]) yStep(2) setMotion(MoveTo (p5: x) 140))  )
  (if(== pCards 6) (p6: init() view(pType[pCards]) cel(pCard[pCards]) yStep(2) setMotion(MoveTo (p6: x) 140))  )
  = cCards2 cCards
  += cCards2 1
  += pTotal pAdd  //adds to total card value of player (max 21)
  ComputerCard()
(if(== pTotal 21)
= cStand 1
DrawPic(132) DrawPic(132) Display("Player wins" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver()
)
(if(> pTotal 21)
= cStand 1
DrawPic(132) Display("Player busted" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver3()
ComputerCard(cCards2)
  return
 )
)))
)))

)
    //dealer card defines
 (instance c1 of Act
 (properties
 view 171
 x 50
 y 71
 ))
 (instance c2 of Act
 (properties
 view 171
 x 90
 y 0
 ))
 (instance c3 of Act
 (properties
 view 171
 x 130
 y 0
 ))
 (instance c4 of Act
 (properties
 view 171
 x 170
 y 0
 ))
  (instance c5 of Act
 (properties
 view 171
 x 210
 y 0
 ))
 (instance c6 of Act
 (properties
 view 171
 x 250
 y 0
 ))
 
 //player card defines, these are Act because I want to move them
 (instance p1 of Act
 (properties
 view 171
 x 50
 y 185
 ))
 (instance p2 of Act
 (properties
 view 171
 x 90
 y 185
 ))
 (instance p3 of Act
 (properties
 view 171
 x 130
 y 185
 ))
 (instance p4 of Act
 (properties
 view 171
 x 170
 y 185
 ))
 (instance p5 of Act
 (properties
 view 171
 x 210
 y 185
 ))
  (instance p6 of Act
 (properties
 view 171
 x 250
 y 185
 ))
 (instance aB of Prop //back button
 (properties
 view 104
 x 30
 y 12
 ))
 
(procedure public (ComputerFirstCard)
= cType[1] Random(167 170) //randomize the card type (aces, clubs etc)
= cCard[1] Random(2 14)
= cAdd cCard[1]
(if(== cCard[1] 11) = cAdd 10 )
(if(== cCard[1] 12) = cAdd 10 )
(if(== cCard[1] 13) = cAdd 10 )
(if(== cCard[1] 14) = cAdd 11 )
(c1: init() cel(Random(0 3))) //randomize the look of the back of the card
+= cTotal cAdd
+= cCards 1 //computer has now taken 1 card
)

(procedure public (ComputerCard cardNum)
(if(== cStand 0)
+= cCards 1 //adds to dealer's amount of cards
= cType[cCards] Random(167 170)
= cCard[cCards] Random(2 14)
= cAdd cCard[cCards]
(if(== cCard[cCards] 11) = cAdd 10 )
(if(== cCard[cCards] 12) = cAdd 10 )
(if(== cCard[cCards] 13) = cAdd 10 )
(if(== cCard[cCards] 14)
(if(<= cTotal 10) = cAdd 11)
(if(> cTotal 10) = cAdd 1)
)
//draw dealer next card
(if(== cCards 2) (c2:  init() view(cType[cCards]) cel(cCard[cCards]) yStep(2) setMotion(MoveTo (c2: x) 71)) )
(if(== cCards 3) (c3:  init() view(cType[cCards]) cel(cCard[cCards]) yStep(2) setMotion(MoveTo (c3: x) 71)) )
(if(== cCards 4) (c4:  init() view(cType[cCards]) cel(cCard[cCards]) yStep(2) setMotion(MoveTo (c4: x) 71)) )
(if(== cCards 5) (c5:  init() view(cType[cCards]) cel(cCard[cCards]) yStep(2) setMotion(MoveTo (c5: x) 71)) )
(if(== cCards 6) (c6:  init() view(cType[cCards]) cel(cCard[cCards]) yStep(2) setMotion(MoveTo (c6: x) 71)) )

+= cTotal cAdd
(if(> cTotal 21)
DrawPic(132) DrawPic(132) Display("Dealer busted" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver()
return
)
(if(== cTotal 21)
DrawPic(132) DrawPic(132) Display("Dealer wins" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
GameOver3()
return
)
(if(== cCards 2)
= value1 14
= value2 16
)
(if(== cCards 3)
= value1 15
= value2 17
)
(if(>= cCards 3)
= value1 15
= value2 18
)
(if(>= cTotal Random(value1 value2))
(if(== pStand 0)
DrawPic(132) DrawPic(132) Display("Dealer stands" dsCOORD 135 80 dsFONT 900 dsCOLOR 2)
= cStand 1
return
)
)
)
)

(procedure public (GameOver)   // called when dealer loses
(c1: view(cType[1]) cel(cCard[1]))     //make dealer's first card visible
= gameOver2 TRUE
+= money bet
= cStand 1
(SL: doit())
Display("Again?  Yes  No" dsCOORD 25 80 dsFONT 900 dsCOLOR 2)
Display("Again?  Yes  No" dsCOORD 24 79 dsFONT 900 dsCOLOR 12)
)
(procedure public (GameOver3)
(c1: view(cType[1]) cel(cCard[1]))  //make dealer's first card visible
= gameOver2 TRUE
-= money bet
(if(<= money 0)
= money 0
)
(SL: doit())
Display("Again?  Yes  No" dsCOORD 25 80 dsFONT 900 dsCOLOR 2)
Display("Again?  Yes  No" dsCOORD 24 79 dsFONT 900 dsCOLOR 12)
)

(procedure public(GetBet)
= bet GetNumber("What is your bet?\n\n")
(if(> bet money)
Print(" You can't bet more than you have. ")
GetBet()
)
(if(not(> bet 0))
 = bet money
)
(if(> bet 50)
Print(" The maximum bet is 50 ")
GetBet()
)
(SL: doit())
)
