
/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script LOGEVENT_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "obj")
(use "user")

(local
   // hFile
    token[51]
    strBuf[200]
)
/******************************************************************************/

(procedure public (ReplayLog)
     (var myEvent, keyNum, displayStr[100])

     Format(@displayStr "CurTicks = %d" GetTime())
     Display(@displayStr
             dsCOORD 0 0
             dsBACKGROUND clYELLOW
     )

     Format(@displayStr "NextEvent = %d" gEventTicks)
     Display(@displayStr
             dsCOORD 0 8
             dsBACKGROUND clYELLOW
     )

        (if (>= GetTime() gEventTicks)
           (= myEvent Event:new())

            (if (== gEventEvent EVENT_LEFTCLICK)
                (send myEvent:
                     type(evMOUSEBUTTON)
                     x(gEventX)
                     y(gEventY)
                     modifiers(512)    // 512 left click, 515 right click
                 )
                 (send gEgo:handleEvent(myEvent))
                 = gEventClaimed TRUE
            )
            
            (if (== gEventEvent  EVENT_RIGHTCLICK)
                (send myEvent:
                     type(evMOUSEBUTTON)
                     x(gEventX)
                     y(gEventY)
                     modifiers(515)    // 512 left click, 515 right click
                 )
                (send gEgo:handleEvent(myEvent))
                = gEventClaimed TRUE
            )
            
            (if (== gEventEvent EVENT_KEYMOVE)
               // FormatPrint("num = %d" gEventKey)
                 = keyNum gEventKey
                (send myEvent:
                     type(evKEYBOARD)
                     message(keyNum)
                )
               (User:handleEvent(myEvent))
               = gEventClaimed TRUE
            )


            (if (== gEventEvent EVENT_PARSEOPEN)
                 //FormatPrint("input msg = %s" @gEventMsg)

                (send myEvent:
                    type(evKEYBOARD)
                    message(KEY_SPACE)
                )
                (User:handleEvent(myEvent))
                
                // note that we do not clear the event, we've already
                // queued up another event on dispose of print
            )
            
            (if (== gEventEvent EVENT_GAMEKEY)
                 //FormatPrint("input msg = %s" @gEventMsg)
                (send myEvent:
                    type(evKEYBOARD)
                    message(@gEventMsg)
                    modifiers(999)
                )
                (send gGame:handleEvent(myEvent))
                = gEventClaimed TRUE
            )

            (if (== gEventEvent  EVENT_GAMELEFTCLICK)
                (send myEvent:
                     type(evMOUSEBUTTON)
                     x(gEventX)
                     y(gEventY)
                     modifiers(512)    // 512 left click, 515 right click
                 )
                (send gGame:handleEvent(myEvent))
                = gEventClaimed TRUE
            )

            (if (== gEventEvent  EVENT_GAMERIGHTCLICK)
                (send myEvent:
                     type(evMOUSEBUTTON)
                     x(gEventX)
                     y(gEventY)
                     modifiers(515)    // 512 left click, 515 right click
                 )
                (send gGame:handleEvent(myEvent))
                = gEventClaimed TRUE
            )
            QueueEvent()
        )
   return(TRUE)
)

(procedure public (LogEvent pEvent eventTrigger inputStr)
       (var val[50])

           Format(@val "Ticks: %08d " GetTime())
           FPuts(gLogFileHandle @val)

           (if(== STRINGS_EQUAL StrCmp(eventTrigger "ego") or == STRINGS_EQUAL StrCmp(eventTrigger "game"))
               (if (== (send pEvent:type) evMOUSEBUTTON)
               
                   // mouse events
                   (if (not(& (send pEvent:modifiers) emRIGHT_BUTTON))
                   	  (if (== STRINGS_EQUAL StrCmp(eventTrigger "ego"))
                         Format(@val "Event: %-10s " "leftClick")
					  )(else
					     Format(@val "Event: %-10s " "gameLClick")
					  )
                   )(else
                   	  (if (== STRINGS_EQUAL StrCmp(eventTrigger "ego"))
                         Format(@val "Event: %-10s " "rightClick")
					  )(else
       
					  	 Format(@val "Event: %-10s " "gameRClick")
					  )
                   )
                   FPuts(gLogFileHandle @val)
                   
                   Format(@val "X: %03d " (send pEvent:x))
                   FPuts(gLogFileHandle @val)
                   
                   Format(@val "Y: %03d " (send pEvent:y))
                   FPuts(gLogFileHandle @val)
                   
                   Format(@val "Key: %-5s " "")
                   FPuts(gLogFileHandle @val)
                   
               )(else
                   // keyboard movement event
                      Format(@val "Event: %-10s " "keyMove")
                      FPuts(gLogFileHandle @val)
                      
                      Format(@val "X: %-3s " "")
                      FPuts(gLogFileHandle @val)
                      
                      Format(@val "Y: %-3s " "")
                      FPuts(gLogFileHandle @val)

                      Format(@val "Key: $%04x " (send pEvent:message))
                      FPuts(gLogFileHandle @val)
               )
           )(else
               Format(@val "Event: %-10s " eventTrigger)
               FPuts(gLogFileHandle @val)
               Format(@val "X: %-3s " "")
               FPuts(gLogFileHandle @val)
               Format(@val "Y: %-3s " "")
               FPuts(gLogFileHandle @val)
               Format(@val "Key: %-5s " "")
               FPuts(gLogFileHandle @val)
           )


           (if(   == STRINGS_EQUAL StrCmp(eventTrigger "parseOpen")
               or == STRINGS_EQUAL StrCmp(eventTrigger "parseClose")
               or == STRINGS_EQUAL StrCmp(eventTrigger "openPrint"))
             //Format(@val "Msg: %-50s" inputStr)
             (if(> StrLen(inputStr) 50)
             	FPuts(gLogFileHandle "Msg: ")
             	StrCpy(@val inputStr 50)
			 )(else
			 	Format(@val "Msg: %-50s" inputStr)
			 )
           )(else
              Format(@val "Msg: %-50s" "")
           )
           FPuts(gLogFileHandle @val)

           FPuts(gLogFileHandle "\n")
)


(procedure public (QueueEvent)
        (var i, char, spaceCount)


           (if(== gEventClaimed FALSE)
              return(FALSE)
           )
           
           StrCpy(@token "")
           StrCpy(@gEventMsg "")
           StrCpy(@strBuf "")
           
           FGets(@strBuf gLogLineSize gLogFileHandle)

           // if we didn't get a whole line (out of log)
           (if (<> StrLen(@strBuf) (- gLogLineSize 2))
                // set to an undefined event
                = gEventEvent -1
                = gLogAction NO_LOG
                //  Print("End of Log")   // FIXME, doesn't work
           )
           
           = gEventClaimed FALSE

           // parse out the string into it's components
           (for (= i 0) (< i StrLen(@strBuf)) (++i)
               Format(char "%c" StrAt(@strBuf i))
                (if (== i 15)
                    = gEventTicks ReadNumber(@token)
                    StrCpy(@token "")
                )

                (if (== i 33)
                    
                    (if(== STRINGS_EQUAL StrCmp(@token "leftClick "))
                        = gEventEvent EVENT_LEFTCLICK
                    )

                    (if(== STRINGS_EQUAL StrCmp(@token "rightClick"))
                        = gEventEvent EVENT_RIGHTCLICK
                    )

                    (if(== STRINGS_EQUAL StrCmp(@token "keyMove   "))
                        = gEventEvent EVENT_KEYMOVE
                    )

                    (if(== STRINGS_EQUAL StrCmp(@token "parseOpen "))
                        = gEventEvent EVENT_PARSEOPEN
                    )

                    (if(== STRINGS_EQUAL StrCmp(@token "closePrint"))
                        = gEventEvent EVENT_CLOSEPRINT
                    )
                    
                    (if(== STRINGS_EQUAL StrCmp(@token "openPrint "))
                        = gEventEvent EVENT_OPENPRINT
                    )
                    
                    (if(== STRINGS_EQUAL StrCmp(@token "gameKey   "))
                        = gEventEvent EVENT_GAMEKEY
					)

                    (if(== STRINGS_EQUAL StrCmp(@token "gameLClick"))
                        = gEventEvent EVENT_GAMELEFTCLICK
					)

                    (if(== STRINGS_EQUAL StrCmp(@token "gameRClick"))
                        = gEventEvent EVENT_GAMERIGHTCLICK
					)
     
                    (if(== STRINGS_EQUAL StrCmp(@token "parseClose"))
                        = gEventEvent EVENT_PARSECLOSE
					)
                    StrCpy(@token "")
                )

                (if (== i 40)
                    = gEventX ReadNumber(@token)
                    StrCpy(@token "")
                )

                (if (== i 47)
                    = gEventY ReadNumber(@token)
                    StrCpy(@token "")
                )

                (if (== i 58)
                    = gEventKey ReadNumber(@token)
                    StrCpy(@token "")
                )

                // ticks
                (if (>= i 7 and <= i 14)
                   StrCat(@token char)
                )

                // event
                (if (>= i 23 and <= i 32)
                   StrCat(@token char)
                )

                // x
                (if (>= i 37 and <= i 39)
                   StrCat(@token char)
                )

                // y
                (if (>= i 44 and <= i 46)
                   StrCat(@token char)
                )

                // key
                (if (>= i 52 and <= i 57)
                   StrCat(@token char)
                )

                // message
                (if (>= i 63 and == gEventEvent EVENT_PARSECLOSE)
                   StrCat(@gEventMsg char)
                )
            )
    )

