/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 3)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
    sadup = 0
)
/******************************************************************************/
(instance public rm003 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
            (case 2 (send gEgo:posn(120 170)loop(3)))
            (default
				(send gEgo:
                    posn(120 170)
					loop(3)
				)
			)(case 15
                (send gEgo:posn(160 140)loop(0))
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (if (INCOSTUME)
            (send gEgo:view(11))
        )
        (sad:init())
        (bed:init())
        (if(not(RM3_GOTBOOK))
            (book:init())
        )
    )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState opening)
        (var dyingScript, button)
        =state opening
         (switch(state)
            (case 0= cycles 1
            )(case 2=cycles 1
                (ProgramControl())
            )(case 3=cycles 20
                (send gEgo:view(7)setCycle(End)cycleSpeed(2))
            )(case 4=cycles 15
                (send gEgo:view(0)setCycle(Walk)cycleSpeed(0)cel(0))
                (sad:loop(3)cel(0)setCycle(End))
                (PlayerControl())
            )(case 5
                Print("Ow. What did you do that for?"#title"Strong Sad says:")
            )(case 10=cycles 15
                (sad:loop(0)cel(1))
                (sad:setCycle(End)cycleSpeed(3))
            )(case 11=cycles 20
                (if(not(RM3_STRONGSAD))
                    (ProgramControl())
                    Print("Oh, hey Strong Bad."#title"Strong Sad says:")
                )
            )(case 12=cycles 20
                (sad:loop(1)cel(0))
                (sad:loop(1)setCycle(End)cycleSpeed(3))
            )(case 13=cycles 10
                (if(not(RM3_STRONGSAD))
                Print("Some wierd guy with glasses came in here and knocked over my bookshelf. He also stole all my stuff...so I've just been laying here for...oh I don't know...maybe an hour or so..."#title"Strong Sad says:")
                Print("Yeah yeah, that's cool. Hey man, have you seen the Cheat? That little guy owes me a favor."#title"You say")
                Print("Well um...I think he said he was going to Bubs...but he's always going off and..."#title"Strong Sad says:")
                Print("Yeah ok, cool man. See ya later."#title"You say:")
                = RM3_STRONGSAD 1
                (send gGame:changeScore(1))
                (PlayerControl())
                )
            )(case 15
            )
        )
    )
    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if(Said('kick,hit/sad'))
            (if(<=(send gEgo:distanceTo(sad))35)
                (RoomScript:changeState(2))
            )(else
                Print("You're not close enough.")
            )
        )
        (if(Said('look>'))
            (if(Said('/book'))
                (if(<=(send gEgo:distanceTo(book))25)
                    Print("It's a cookbook called 'I Wonder What She Cooks Like...Naked' by Jay Sherman.")
                )(else
                    Print("You'll have to go closer.")
                )
            )(if(Said('/poster,wall'))
                Print("What a lame poster. There's not even a guitar in it.")
            )(if(Said('/around'))
                Print("Looks like Strong Sad's place has been robbed. The bookshelf has been thrown down.")
            )(if(Said('[ /* , !* ]'))
                Print("There's nothing special about it.")
            )
        )(if(Said('take,pick/book'))
            (if(not(RM3_GOTBOOK))
                (if(<=(send gEgo:distanceTo(book))25)
                    Print("No probalo")
                    (send gEgo:get(2))//cookbook
                    = RM3_GOTBOOK 1
                    (send gGame:changeScore(1))
                    (book:hide()ignoreActors())
                )(else
                Print("You're not close enough.")
                )
            )(else
                Print("You've already got it.")
            )
        )(if(Said('talk/man,sad'))
            Print("You don't really want to.")
        )
    )
    (method (doit)
        (var button)
        (super:doit)
        (if(==(send gEgo:onControl())ctlSILVER)
            (if(sadup)
                (sad:loop(2)cel(0))
                (sad:setCycle(End)cycleSpeed(3))
                = sadup 0
            )
        )
        (if(==(send gEgo:onControl())ctlMAROON)
            (send gRoom:newRoom(2))
        )(if(<=(send gEgo:distanceTo(sad))40)
            (if(not(sadup))
            = sadup 1
            (RoomScript:changeState(10))
            )
        )
    )
)
(instance sad of Prop
    (properties
        x 230
        y 130
        view 3
    )
)
(instance bed of Prop
    (properties
        x 230
        y 170
        view 104
    )
)
(instance book of Prop
    (properties
        x 150
        y 140
        view 810
    )
)
(instance exit of Prop
    (properties
        x 18
        y 65
        view 100
    )
)
(instance extras of Prop
    (properties
        x 301
        y 65
        view 100
        loop 1
    )
)(instance gameroom of Prop
    (properties
        x 160
        y 48
        view 100
        loop 2
    )
)
(instance gate of Prop
    (properties
        x 282
        y 160
        view 200
    )
)
/******************************************************************************/
