/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 11)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")

(local
    looking = 0
    inroom = 0
    hitsilver = 0
    hitgrey = 0
    hitred = 0
    outtobubs = 0
    gotmayo = 0
    clockchanged = 0
)
/******************************************************************************/
(instance public rm011 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(150 130)
					loop(1)
				)
			)(case 10 (send gEgo:posn(160 175)loop(3))
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (clock:init())
        (if (INCOSTUME)
            (send gEgo:view(11))
        )
        (if(RM11_COMPLETE)
            (machine:init()setCycle(Fwd)cycleSpeed(5)loop(2))
            (homestar:init())
        )(else
            (if (RM6_KINGSQUEST)
                (machine:init()setCycle(Fwd)cycleSpeed(5)loop(1))
                (homestar:init())
            )(else
                (machine:init()setCycle(Fwd)cycleSpeed(5)loop(0))
                (homestar:init()hide())
            )
        )
        (if(not(RM11_CLOTHES))
            (stand:init()cel(1))
        )(else
            (stand:init()cel(0))
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState opening)
        (var dyingScript, button)
        =state opening
         (switch(state)
            (case 0= cycles 1
            )(case 1=cycles 10
                (if(RM6_KINGSQUEST)
                    = inroom 1
                )
            )(case 2=cycles 7
                (if (RM6_KINGSQUEST)
                    (if (RM11_MESSAGE1)
                        Print("Beep.")
                        Print("Hey Homestar, this is Marzipan. We're still on for our date later right? I'll see you at the Marshmallow place later. ok bye!"#title"-Answering machine-")
                    )
                )
            )(case 3=cycles 10
                (if (RM6_KINGSQUEST)
                    (if (RM11_MESSAGE1)
                        Print("Oh hey Strong Bad. What's goin' on?"#title"Homestar says:")
                        Print("Hey man do you have any of those marshmallows you're always eatin' anywhere around here?"#title"You ask:")
                        Print("No. But Marzipan is goin' to buy some for me later...but I'll probably eat all of those."#title"Homestar says:")
                        =RM11_MESSAGE1 0
                        (send gGame:changeScore(1))
                        //(homestar:loop(1)setCycle(Fwd)cycleSpeed(3))
                    )
                )
            )(case 4
                (RoomScript:changeState(10))
            )(case 10=cycles 10
                (homestar:loop(0)cel(1))
                = looking 1
            )(case 11=cycles 15
                (homestar:cel(0))
                = looking 0
            )(case 12=cycles 5
                (homestar:cel(1))
                = looking 1
            )(case 13=cycles 10
                (homestar:cel(0))
                = looking 0
            )(case 14=cycles 15
                (homestar:cel(0))
                = looking 1
            )(case 15
                (RoomScript:changeState(10))
            )(case 20=cycles 1
            )(case 21=cycles 10
                (homestar:setCycle(End)cycleSpeed(3))
                (clock:cel(0)loop(0))
                = outtobubs 1
                = RM11_LEFT 1
                = looking 0
            )(case 22=cycles 2
                Print("I'll give him one thing, he IS a terrific athlete.")
                Print("I better hurry up and tie up the loose ends before he gets back.")
            )(case 23=cycles 200
            )(case 24=cycles 200
            )(case 25
                Print("Time's up; he's back.")
                (homestar:loop(0)cel(1)posn(80 130))
                = outtobubs 0
            )
        )
    )
    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if(Said('take/hat,shirt,clothes'))
            (if(send gEgo:has(4))//clothes
                Print("There's nothing to take.")
            )(else
                (if(inroom)
                    (if(<=(send gEgo:distanceTo(stand))25)
                        (if(not(looking))
                            Print("You took his hat and shirt.")
                            (stand:cel(0))
                            (send gEgo:get(4))//clothes
                            = RM11_CLOTHES 1
                            (send gGame:changeScore(1))
                        )(else
                            Print("You got caught!")
                        )
                    )(else
                        Print("You're not close enough.")
                    )
                )(else
                    (if(outtobubs)
                        Print("You took his hat and shirt.")
                        (stand:cel(0))
                        (send gEgo:get(4))//clothes
                        = RM11_CLOTHES 1
                        (send gGame:changeScore(1))
                    )(else
                        Print("Why would you want that now?")
                    )
                )
            )
        )
        (if(Said('give,use,talk/watch,homestar'))
            (if(<= (send gEgo:distanceTo(homestar)) 20)
                (if(send gEgo:has(5))//watch
                    Print("Hey Homestar I bought you this cool watch man. It keeps great time."#title"You say:")
                    Print("Thanks Strong Bad. I think I'll get you something too. I'll be right back."#title"Homestar says:")
                    (send gEgo:put(5))
                    (homestar:cel(0)loop(3)posn(90 170))
                    (RoomScript:changeState(20))
                )(else
                    Print("There is no reason to do that now.")
                )
            )(else
                Print("You're not close enough.")
            )
        )
        (if(Said('use,dial,call/phone,homestar'))
            (if(==(send gEgo:onControl())ctlSILVER)
                (if(not(RM11_CALL))
                    (if (RM6_KINGSQUEST)
                        (if (outtobubs)
                            Print("Homestar, this is Marzipan...and uh, don't get mad at Strong Bad for taking some of your Marshmallow Mayonnaise. He is, um...going to make some marshmallow tofu salad for me, ok? bye."#title"You leave a message:")
                            (machine:loop(2)setCycle(Fwd)cycleSpeed(5))
                            = RM11_CALL 1
                            (send gGame:changeScore(1))
                        )(else
                            Print("You can't prank him while he's here.")
                        )
                    )(else
                        Print("You can't think of anything yet.")
                    )
                )(else
                    Print("You've already left a message.")
                )
            )(else
                Print("You're not close enough.")
            )
        )
        (if(Said('take,marshmallow,mayo'))
            (if(==(send gEgo:onControl())ctlGREY)
                (if(send gEgo:has(6))
                    Print("You don't need any more.")
                )(else
                    (if(RM6_KINGSQUEST)
                        (PrintOK)
                        = gotmayo 1
                        (send gEgo:get(6))//mayo
                        (send gGame:changeScore(1))
                    )(else
                        Print("Why would I want this?")
                    )
                )
            )(else
                Print("You're not close enough.")
            )
        )
        (if(Said('set,change,move/clock,time'))
            (if(<= (send gEgo:distanceTo(clock)) 45)
                (if (RM6_KINGSQUEST)
                    (if (outtobubs)
                        (PrintOK)
                        (clock:cel(1))
                        = clockchanged 1
                        (send gGame:changeScore(1))
                    )(else
                        Print("Homestar is right there; you can't.")
                    )
                )(else
                    ("You don't have any reason to do that.")
                )
            )(else
                Print("You're not close enough.")
            )
        )
        (if(Said('look>'))
            (if(Said('/clock'))
                Print("Look's like it's keeping good time. It looks easy to change.")
            )(if(Said('/machine'))
                Print("I will probably want to give Homestar a prank call later.")
            )(if(Said('/clothes,stand'))
                Print("Extra clothes of Homestars are hanging there. They're so stupid looking I bet no one would recognize me in them.")
            )(if(Said('/around'))
                Print("On the counter is Homestar's answering machine. There is a clock on the wall. There are two doors at the top of the stairs and one on the lower level.")
            )
        )
    )
    (method(doit)
        (var button)
        (super:doit)
        (if(==(send gEgo:onControl())ctlMAROON)
            (send gRoom:newRoom(10))
        )
        (if(==(send gEgo:onControl())ctlGREY)
            (if(not(hitgrey))
                (ShakeScreen(2))
                (if(RM6_KINGSQUEST)
                    Print("Man I struck gold! There's cases of Marshmallow Mayo in here!")
                )(else
                    Print("Ouch! What is all this crap? Marshmallow Mayo?")
                )
                = hitgrey 1
            )
        )
        (if(==(send gEgo:onControl())ctlSILVER)
            (if(not(hitsilver))
                Print("This looks like Homestar's bedroom. There's a phone in here.")
                = hitsilver 1
            )
        )
        (if(==(send gEgo:onControl())ctlRED)
            (if(not(hitred))
                Print("This is Homestar's bathroom. It gives me the jibblies just being in here.")
                = hitred 1
            )
        )
        (if(==(send gEgo:onControl())ctlBLUE)
            (if(not(RM11_COMPLETE))
                (if(RM11_LEFT)
                    (if(RM11_CALL)
                        (if(clockchanged)
                            = RM11_COMPLETE 1
                            Print("I got you a DVD Strong Bad."#title"Homestar says:")
                            (send gGame:changeScore(5))
                            (send gEgo:get(8))
                        )(else
                            Print("You missed something. Try again!"#title "You missed it that TIME.")
                            (send gEgo:posn(70 150))
                            (homestar:cel(0)loop(3)posn(90 170))
                            (machine:loop(1)setCycle(Fwd)cycleSpeed(5))
                            (send gGame:changeScore(-2))
                            = clockchanged 0 (clock:cel(0))
                            = RM11_CALL 0
                            = RM11_LEFT 0
                            (RoomScript:changeState(20))
                        )
                    )(else
                        (if(gotmayo)
                            Print("Hey yo. Gimme back my mayo before you leave. Try again!"#title"Good CALL Homestar.")
                            (send gEgo:put(6)posn(70 150))//mayo
                            (homestar:cel(0)loop(3)posn(90 170))
                            (machine:loop(1)setCycle(Fwd)cycleSpeed(5))
                            (send gGame:changeScore(-2))
                            = clockchanged 0
                            = RM11_CALL 0
                            = gotmayo 0
                            = RM11_LEFT 0
                            (RoomScript:changeState(20))
                        )(else
                            Print("This room cannot be completed as tried. Please check the rooms and try again.")
                            (send gEgo:put(6)posn(70 150))//mayo
                            (homestar:cel(0)loop(3)posn(90 170))
                            (machine:loop(1)setCycle(Fwd)cycleSpeed(5))
                            = clockchanged 0
                            = RM11_CALL 0
                            = gotmayo 0
                            = RM11_LEFT 0
                            (RoomScript:changeState(20))
                        )
                    )
                )
            )
            (if(gotmayo)
                (if(not(RM11_CALL))
                    Print("Hey yo. Gimme back my mayo before you leave.")
                    (send gEgo:put(6))//mayo
                    = gotmayo 0
                    (send gGame:changeScore(-1))
                )
            )
        )
    )
)
(instance machine of Prop
    (properties
        x 52
        y 118
        view 101
    )
)
(instance stand of Prop
    (properties
        x 145
        y 110
        view 102
    )
)
(instance homestar of Prop
    (properties
        x 80
        y 130
        view 9
    )
)
(instance clock of Prop
    (properties
        x 173
        y 72
        view 300
    )
)
/******************************************************************************/
