/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 400)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "rev")
/******************************************************************************/
(instance public rm400 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(150 130)
					loop(1)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init()hide())
        (logo:init()setCycle(Fwd)cycleSpeed(3))
        Display(
                    "COMING SOON"
                    dsCOORD 190 30
                    dsCOLOUR clBLACK
                    dsBACKGROUND clTRANSPARENT
                )
         (send gTheMusic:
			prevSignal(0)
			stop()
			number(1)
			loop()
			play()
		)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState opening)
        (var dyingScript, button)
        =state opening
         (switch(state)
            (case 0= cycles 1
            )(case 1=cycles 15
                (ProgramControl())
            )(case 2=cycles 30
                Display(
                    "Presents"
                    dsCOORD 100 60
                    dsCOLOUR clBLACK
                    dsBACKGROUND clTRANSPARENT
                )
            )(case 3=cycles 40
                Display(
                    "Doan's Quest"
                    dsCOORD 85 79
                    dsCOLOUR clNAVY
                    dsBACKGROUND clTRANSPARENT
                )
            )(case 4=cycles 30
                DrawPic(401 dpOPEN_INSTANTLY 1 0)
                (aDame:init()setCycle(End)cycleSpeed(1))
                (logo:hide())
            )(case 5= cycles 27
                Print("Encounter magical weapons")
                (aDame:setCycle(Rev))
            )(case 6= cycles 5
                DrawPic(402 dpOPEN_INSTANTLY 1 0)
                (aDame:hide())
                (TheEnemy:init())
                (ThePlayer:init())
            )(case 7= cycles 5
                (TheEnemy:cel(1))
                (ThePlayer:cel(1))
            )(case 8= cycles 3
                (ThePlayer:cel(2))
            )(case 9= cycles 15
                (TheEnemy:cel(2))
                (ThePlayer:cel(3))
            )(case 10= cycles 10
                Print("Fight deadly opponents")
            )(case 11=cycles 25
                (TheEnemy:hide())
                (ThePlayer:hide())
                (kip:init())
                (chest:init())
                DrawPic(403 dpOPEN_INSTANTLY 1 0)
                (send gEgo:show()view(405)loop(1)setCycle(End)cycleSpeed(3)posn(180 80))
            )(case 12= cycles 20
                (chest:setCycle(End)cycleSpeed(1))
                (send gEgo:view(2)loop(1)cel(0)setCycle(CT))
            )(case 13= cycles 15
                Print("Cast magic spells")
            )(case 14= cycles 10
                DrawPic(404 dpOPEN_INSTANTLY 1 0)
                (send gEgo:hide())
                (kip:hide())
                (chest:hide())
            )(case 15= cycles 15
                Display(
                    "Email at rayneslattery@yahoo.com"
                    dsCOORD 20 20
                    dsCOLOUR clBLUE
                    dsBACKGROUND clTRANSPARENT
                )
            )(case 16= cycles 20
                (PlayerControl())
                Display(
                    "Looking for help! email me"
                    dsCOORD 59 160
                    dsCOLOUR clRED
                    dsBACKGROUND clTRANSPARENT
                )
            )
        )
    )
)
(instance logo of Prop
    (properties
        x 90
        y 50
        view 998
    )
)
(instance aDame of Prop
    (properties
        y 190
        x 100
        view 400
    )
)
(instance TheEnemy of Prop
	(properties
		view 401
		loop 0
		cel 0
		x 170
		y 100
	)
)
(instance ThePlayer of Prop
	(properties
		view 402
		loop 0
		cel 0
		x 140
		y 120
	)
)
(instance kip of Prop
    (properties
        view 403
        x 125
        y 70
    )
)
(instance chest of Prop
    (properties
        view 404
        x 100
        y 70
    )
)
/******************************************************************************/
