(*---------------------------------------------------------------------------*)
(* PRACTICA 2: LA SERPIENTE!                                                 *)
(* Autor: Jose Antonio Lopez Suarez (Primero B).                             *)
(* Asignatura: Laboratorio de Programacin (Teleco Tecnica).                 *)
(* Fecha: Semana Santa 2000;   Tiempo de programacion: un par de dias        *)
(* ChangeLog (leer de abajo para arriba; cronologicamente):                  *)
(* --> Serpiente v1.0                                                        *)
(* Retoco un poco el codigo completo... y listo...                           *)
(* No veas que panz de escribir codigo; se me ha quedao en 2.000 Lineas...  *)
(* Bueno creo que ya esta...                                                 *)
(* Pues no estaba... habia un error de Out of Range, para una asignacion     *)
(* de las variables de tipo TCoord, las cuales son del tipo subrango         *)
(* [ICampo..FCampo] y estas tomaban valores de CARDINAL, lo cual es un       *)
(* descuido por mi parte... pero ya esta solucionado!                        *)
(* He arreglado la lectura de ficheros; ahora detecta el 80% de error.       *)
(* Estara ya?                                                               *)
(* --> Serpiente v0.9:                                                       *)
(* Agrupo todas las variables de configuracion del juego (antes como         *)
(* constantes), en un registro llamado TConfiguracion; los valores de este   *)
(* registro se generar de forma fija, dependiendo de cuatro parametros       *)
(* configurales por el usuario (desde el entorno); tamao de la serpiente,   *)
(* cantidad de muros, velocidad y tamao inicial de la cola.                 *)
(* He quitado las constantes configurables y he modificado todos los         *)
(* subprogramas para que las acepten como parametros en su cabecera.         *)
(* Las variables mas utilizadas son: LongMuro, AnchMuro, Cuadro y Radio.     *)
(* Si no fuera por los Efectos Laterales que me explicaron en Introduccin   *)
(* a los Computadores, entonces utilizaria ese conjunto de variables como    *)
(* globales... pero bueno... todo sea por un buen estilo de programacion,    *)
(* digo yo...                                                                *)
(* Despues de todo esto, creo que he conseguido un algo grado de             *)
(* globalizacion para los parametros de juego; admiten distintos rangos.     *)
(* Ya solo me queda aadir el Entorno de Menus (en modo Texto para poder     *)
(* utilizar las ventanas de la libreria Window y todo el rollo...) y         *)
(* con eso ya estara el juego terminado: Todo quedara ya en la v1.0 de       *)
(* La Serpiente!                                                             *)
(* El entorno de menus lo hago en modo texto, y lo que cojido completamente  *)
(* del juego que hice en modo texto; con algunas pequeas modificaciones en  *)
(* algunos subalgoritmos.                                                    *)
(* El conjunto de subprogramas para gestionar la lista de records, como      *)
(* leer del archivo, guardar, imprimir en ventana, pedir nuevo records, etc. *)
(* los he cojido exactamente como los hice para el juego en modo texto.      *)
(* Las instrucciones no las he cambiado mucho que digamos...                 *)
(* He decidido cambiar la forma de escribir el archivo de records. Antes era *)
(* de tipo texto, ahora voy ha crear y administrar uno en binario, con las   *)
(* funciones WrBin y RdBin. El resultado es mucho mas robusto y me gusta.    *)
(* --> Serpiente v0.8:                                                       *)
(* Dibujo el marcador de puntos en la parte superior de la pantalla.         *)
(* He creado un manejador de errores, el cual manda mensajes en la parte     *)
(* inferior de la pantalla; esta muy bien, si seor...                       *)
(* Utilizo algoritmo de la libreria Str, muy utiles para convertir numeros   *)
(* a cadena y asi poder utilizar OutText para actualizar la puntuacion.      *)
(* Me lo he currado para que la serpiente no tenga la cabeza cuadrada. Le    *)
(* he consegido poner una cabeza redonda, aunque queria ponerle unos ojitos  *)
(* pero se me ha complicado demasiado y lo he dejado, bastante tiene... La   *)
(* cola es cudrada porque es muy dificil hacer una con un grafico; no quiero *)
(* complicar las cosas inutilmente.                                          *)
(* Para el algoritmo GeneraMuros: He aadido la posibilidad de cancelar la   *)
(* generacion de muros. Esto es porque cuando el algoritmo no encontraba     *)
(* ya sitio para colocar un nuevo muro, entraba en un bucle infinito,        *)
(* dejando al jugador a dos velas y con las ganas de empezar la partida. Asi *)
(* que si llega a ese punto (que no queda ningun hueco para poner otro muro) *)
(* pulsando ESCAPE, se sale del bucle correctamente, cerrando la lista de    *)
(* punteros de muros y empieza a jugar.                                      *)
(* --> Serpiente v0.7:                                                       *)
(* Tiembla TopSpeed... ke voy a intentar hacer el algoritmo para los muros   *)
(* aleatorios!                                                               *)
(* Despues de un rato: No veas!, el algoritmo de generar muros aleatorios,   *)
(* se me ha quedao de muerte... incluso mejor que el que hice para generar   *)
(* muros en el juego de texto. Mola un mazo... Aki va el rollitto :)         *)
(* Pienso en una estructura de datos TMuros; con esto guardo posicion de la  *)
(* esquinita del muro y la orientacion del muro... a partir de estos dos     *)
(* parametros puedo desarollar el muro completamente sin problemas...        *)
(* He decidido esto porque as me ahorro mucha memoria para almacenarlos.    *)
(* Creo un algoritmo para dibujar un muro (los muros son como los del        *)
(* comecocos; o el pacman detolavia).                                        *)
(* Necesito un algoritmo para que me diga si un punto determinado esta o no  *)
(* en un muro... bueno pues lo hago.                                         *)
(* Y porfin, hago el algoritmo de generar muros aleatorios... este algoritmo *)
(* me ha salido un poco gordito de lineas... pero bueno... las condiciones   *)
(* de generar muros son las tipicas (igual que en modo texto).               *)
(* Por ahora la estructura del mapa de muros es un array de TMuros.          *)
(* Como no puede ser tanto array que no vale para nada... decido utilizar    *)
(* a mis amigitos los punteros que me he estudiado hace tres dias...        *)
(* y con esto todo queda muy bonito y mas mejor...                           *)
(* El mapa de puntos es una lista enlazada con puneteros de TMuros. Con esto *)
(* tambien creo un algoritmo para destruir la lista... y asi liberar la      *)
(* memoria ocupada cuando termine el juego... ups!... se me acaba de ocurrir *)
(* que eso tambien deberia hacerlo con la serpiente... bueno...              *)
(* Para la serpiente hago un algoritmo que libera la lista cuando termine el *)
(* juego...                                                                  *)
(* Hay mas cositas pero no tengo demasiadas ganas de escribir asin que kedan *)
(* ah abajo, muy bien detalladas y comentadas, (OK?)...                     *)
(* Eztoy penzando ponedle zonido... bueno voy a ver ke hay zobre ezo en      *)
(* laz libreriaz (y loz ejemploz) del Top-Ezpid...                           *)
(* Ya tiene sonido y tal: Cuando se come una bola y cuano choca; bastante    *)
(* tiene no?. Le podia poner la banda sonora de la peli The Matrix... pero  *)
(* no termino de decidirme, por ahora lo dejare asi...                       *)
(* He arreglado los bordes del campo de juego; ahora estan mucho mejor,      *)
(* porque hacen juego con los muros... osea que pijo...                      *)
(* --> Serpiente v0.6:                                                       *)
(* No dejo que haga un movimiento hacia atras; con esto el juego no se hace  *)
(* tan dificil ante un descuido del jugador si le da pa tras a la sepiente.  *)
(* Hago un algoritmo que me dice si un pixel de la pantalla pertenece o no   *)
(* a la serpiente; esto esta orientado para el algoritmo de colision.        *)
(* Realizo el algoritmo de colisin; registra puntos pertenecientes a la     *)
(* serpiente y puntos pertenecientes a los muros de los bordes.              *)
(* HecharComida; Algoritmo que calcula donde ser pude hechar la comdida y    *)
(* luego la hecha en la posicion buscada.                                    *)
(* Ya se puede comer la comida; aadimos un trozito mas a la serpiente.      *)
(* Pinto un bordecillo de pruebas... no se si sera el definitivo.            *)
(* --> Serpiente v0.5:                                                       *)
(* La serpiente es una lista enlazanada con punteros. No es una lista        *)
(* circular, porque todavia no tengo muy claro el trabajo con TADs. Por      *)
(* eso he utilizado una lineal. Aunque tampoco creo que sea tan cecesaria    *)
(* una circular aqui, ya que con una lineal, se trabaja estupendamente; con  *)
(* y los algoritmos de 'insertar' y 'eliminar' por supuesto.                 *)
(* Controlo los modos de video y restauro el modo texto al final del juego.  *)
(* Estoy globalizando todos los parametros de juego como constantes (por     *)
(* ahora) para que su modificacion sea rapida y facil; luego ya veremos.     *)
(* Controlo que la serpiente no se salga de la pantalla.                     *)
(* Aado la tecla ESC para salir del juego; entre otras teclas (ampliable).  *)
(* --> Serpiente v0.4:                                                       *)
(* La serpiente en modo texto es muy patatera y ademas estoy aburrido. Voy   *)
(* ha hacer algo productivo esta semana santa aparte de estudiar y salir de  *)
(* marcha. TACHAN!... empieza la fiesta...                                   *)
(* Empiezo el juego de la serpiente en modo grafico; hago pruebas y tal...   *)
(* Despues de haberme pegao una panz de jugar al juego de la serpiente con  *)
(* el movil de mi hermano... Tomo la decisin de hacer mi juego de la        *)
(* serpiente lo mas parecido al del movil Nokia, y con ello el redibujado,   *)
(* y todo lo que pueda, para que quede mas chuli.                            *)
(* Gracias a la modularizacin puedo utilizar la mayoria de algoritmos que   *)
(* hice para el otro juego de la serpiente en modo texto; que curioso.       *)
(*---------------------------------------------------------------------------*)
MODULE SERP2;
FROM IO IMPORT WrCard, WrLngCard, WrStr, WrChar, WrLn, RdKey, KeyPressed;
FROM Lib IMPORT Delay, RANDOMIZE, RANDOM, Speaker;
FROM Graph IMPORT SetVideoMode, ClearScreen, Cube, Disc, OutText, SetBkColor,
                  SetTextColor, SetTextPosition, Line, Arc, FloodFill,
                  GetTextPosition;
FROM Graph IMPORT _TEXTC80, _VRES16COLOR, _GCLEARSCREEN, TextCoords;
FROM Storage IMPORT ALLOCATE, DEALLOCATE; (* Para trabajar con punteros *)
FROM Str IMPORT CardToStr; (* Para imprimir numeros con OutText *)
FROM MATHLIB IMPORT Exp, Log; (* Para generar notas de sonido *)
FROM Window IMPORT Clear, CursorOff, CursorOn, GotoXY, WhereX, WhereY,
                   TextBackground, TextColor, SetWrap;
FROM Window IMPORT Black,     Blue,         Green,      Cyan,
                   Red,       Magenta,      Brown,      LightGray,
                   DarkGray,  LightBlue,    LightGreen, LightCyan,
                   LightRed,  LightMagenta, Yellow,     White;
FROM Window IMPORT WinDef, WinType, DoubleFrame, SingleFrame, TitleMode;
IMPORT Window;
FROM FIO IMPORT Exists, Size, WrBin, RdBin;
IMPORT FIO;

CONST
    (*----------------------------------------------------------------------*)
    (*.PARAMETROS GENERALES (Solo accesibles desde este codigo fuente)......*)
    (*.Colores del fondo (borrado) y de la serpiente (16 Colores)...........*)
    (* Negro-0; Azul-1; Verde-2; Cian-3; Rojo-4; Magenta-5; Marron-6;       *)
    (* GrisClaro-7; GrisOscuro-8; AzulClaro-9, VerdeClaro-10; CianClaro-11; *)
    (* RojoClaro-12; MagentaClaro-13; AmarilloClaro-14; Blanco-15           *)
       ColorFondo = 0;
       ColorSerp = 2;
       ColorComida = 14;
       ColorBorde = 1;
       ColorMuro = 1;
    (*.Anchura del borde del campo de juego.................................*)
       AnchBorde = 4;
    (*.Dimensiones del campo de juego: Modo de video 640x480................*)
       ICampoX = 4;    (* Minimo 4; para borde 4 *)
       FCampoX = 635;  (* Maximo 635; para borde 4 *)
       ICampoY = 20;   (* Minimo 4; para borde 4 *)
       FCampoY = 458;  (* Maximo 458; para borde 4 *)
    (*----------------------------------------------------------------------*)
       ArchRec = "SERP.DAT";  (* Nombre del archivo de Records *)

TYPE
   IndCad = [0..12];
   TCadena = ARRAY IndCad OF CHAR;
   TDirecc = (Arriba, Abajo, Izquierda, Derecha);
   TTecla = (ESC, Cursores, Otras);
   TCoord = RECORD
      x : [ICampoX..FCampoX];
      y : [ICampoY..FCampoY];
   END;
   (* Tipos para definir una serpiente *)
   TLista = POINTER TO TNodo;
   TNodo = RECORD
      dato : TCoord;
      sig : TLista;
   END;
   TSerpiente = RECORD
      ini: TLista;
      primero:TLista;
      ultimo:TLista;
   END;
   (* Tipos para definir un muro *)
   TOrienta = (Horizontal, Vertical);
   TMuro = RECORD
         orienta : TOrienta;
         pos : TCoord;
   END;
   (* Creo una lista enlazada para el mapa de muros *)
   TMapaMurosLista = POINTER TO TMapaMurosNodo;
   TMapaMurosNodo = RECORD
      dato : TMuro;
      sig : TMapaMurosLista;
   END;
   (* Tipos determinan la configuracion del juego *)
   TTamano = (Enana, Regular, Grande, Bestial);
   TNumMuros = (Ninguno, Pocos, Algunos, Muchos);
   TVelocidad = (Lenta, Normal, Rapida);
   TTamIniSerp = (Corta, Media, Larga);
   TParametros = RECORD
        Tamano : TTamano;
        NumMuros : TNumMuros;
        Velocidad : TVelocidad;
        IniCola : TTamIniSerp;
   END;
   TConfiguracion = RECORD
      Cuadro : CARDINAL;     (* Tamao de cada elemento de la serpiente *)
      IniSerp : CARDINAL;    (* Numero de elementos iniciales de la serpiente *)
      Radio : CARDINAL;      (* Tamao del radio del punto de la comida *)
      Retraso : CARDINAL;    (* Tiempo de retraso para el Delay *)
      LongMuro : CARDINAL;   (* Longitud de los muros *)
      AnchMuro : CARDINAL;   (* Anchura de los muros *)
      NumMuros : CARDINAL;   (* Numero de muros *)
      Puntuacion : LONGCARD; (* Incremento de puntuacion por cada punto *)
   END;
   (* Tipos para gestionar la lista de records *)
   TRecord = RECORD     (* Array para los records *)
       Nombre : TCadena;
       Puntos : LONGCARD;
   END;
   IndRec = [1..10];
   TRecords = ARRAY IndRec OF TRecord;   (* Lista de los 10 records *)


(*--------------------------------------------------------------------------*)
(* OTROS ALGORITMOS...                                                      *)
(*--------------------------------------------------------------------------*)

PROCEDURE DibujaMuroBordes();
(* Dibuja un muro en los los bordes del campo de juego *)
BEGIN
    (* Dibuja borde interior *)
    Line(ICampoX+AnchBorde, ICampoY, FCampoX-AnchBorde, ICampoY, ColorBorde);
    Line(ICampoX, ICampoY+AnchBorde, ICampoX, FCampoY-AnchBorde, ColorBorde);
    Line(ICampoX+AnchBorde, FCampoY, FCampoX-AnchBorde, FCampoY, ColorBorde);
    Line(FCampoX, ICampoY+AnchBorde, FCampoX, FCampoY-AnchBorde, ColorBorde);
    (* Dibuja borde exterior *)
    Line(ICampoX, ICampoY-AnchBorde, FCampoX, ICampoY-AnchBorde, ColorBorde);
    Line(ICampoX-AnchBorde, ICampoY, ICampoX-AnchBorde, FCampoY, ColorBorde);
    Line(ICampoX, FCampoY+AnchBorde, FCampoX, FCampoY+AnchBorde, ColorBorde);
    Line(FCampoX+AnchBorde, ICampoY, FCampoX+AnchBorde, FCampoY, ColorBorde);
    (* Dibuja los arcos de las esquinas de los bordes interiores *)
    Arc(ICampoX+AnchBorde, ICampoY+AnchBorde, AnchBorde, AnchBorde, ICampoX+AnchBorde, ICampoY, ICampoX, ICampoY+AnchBorde, ColorBorde);
    Arc(FCampoX-AnchBorde, ICampoY+AnchBorde, AnchBorde, AnchBorde, FCampoX, ICampoY+AnchBorde, FCampoX-AnchBorde, ICampoY, ColorBorde);
    Arc(ICampoX+AnchBorde, FCampoY-AnchBorde, AnchBorde, AnchBorde, ICampoX, FCampoY-AnchBorde, ICampoX+AnchBorde, FCampoY, ColorBorde);
    Arc(FCampoX-AnchBorde, FCampoY-AnchBorde, AnchBorde, AnchBorde, FCampoX-AnchBorde, FCampoY, FCampoX, FCampoY-AnchBorde, ColorBorde);
    (* Dibuja los arcos de las esquinas de los bordes exteriores *)
    Arc(ICampoX, ICampoY, AnchBorde, AnchBorde, ICampoX, ICampoY-AnchBorde, ICampoX-AnchBorde, ICampoY, ColorBorde);
    Arc(FCampoX, ICampoY, AnchBorde, AnchBorde, FCampoX+AnchBorde, ICampoY, FCampoX, ICampoY-AnchBorde, ColorBorde);
    Arc(ICampoX, FCampoY, AnchBorde, AnchBorde, ICampoX-AnchBorde, FCampoY, ICampoX, FCampoY+AnchBorde, ColorBorde);
    Arc(FCampoX, FCampoY, AnchBorde, AnchBorde, FCampoX, FCampoY+AnchBorde, FCampoX+AnchBorde, FCampoY, ColorBorde);
END DibujaMuroBordes;

PROCEDURE DibujaMarcador(puntos:LONGCARD);
(* Posiciona y dibuja el marcador de puntos *)
VAR
  co : TextCoords;
  bg : LONGCARD;
  fg : CARDINAL;
  PuntosTxt : TCadena;
  Correcto : BOOLEAN;
BEGIN
    co := SetTextPosition(1, 4);
    bg := SetBkColor(0);
    fg := SetTextColor(11); OutText(" ");
    fg := SetTextColor(3); OutText("Puntos:");
    fg := SetTextColor(11);
    (* Convierte el cardinal en cadena, para poder sacarlo por pantalla *)
    CardToStr(puntos, PuntosTxt, 10, Correcto);
    (* Pintamos la puntacion actual *)
    co := SetTextPosition(1, 14); OutText(PuntosTxt);
END DibujaMarcador;

PROCEDURE ActualizaMarcador(puntos : LONGCARD);
(* Actualiza la informacion del marcador de puntos *)
VAR
  co : TextCoords;
  bg : LONGCARD;
  fg : CARDINAL;
  PuntosTxt : TCadena;
  Correcto : BOOLEAN;
BEGIN
    bg := SetBkColor(0);
    fg := SetTextColor(11);
    (* Convierte el cardinal en cadena, para poder sacarlo por pantalla *)
    CardToStr(puntos, PuntosTxt, 10, Correcto);
    (* Limpiamos la zona donde estaba la anterior puntuacion *)
    co := SetTextPosition(1, 14); OutText("          ");
    (* Pintamos la puntacion actual *)
    co := SetTextPosition(1, 14); OutText(PuntosTxt);
END ActualizaMarcador;

PROCEDURE MsgErrorGrafico(cod : CARDINAL):BOOLEAN;
(* Manejador de errores para el modo grafico *)
VAR
  co : TextCoords;
  bg : LONGCARD;
  fg : CARDINAL;
  MPP : BOOLEAN;
BEGIN
    co := SetTextPosition(30, 1);
    fg := SetTextColor(4);
    (* Limpiamos la linea de mensajes *)
    Cube(FALSE, 0, 465, 639, 479, 0, 0, TRUE);
    (* CODIGOS PRINCIPALES:                         *)
    (* 0: Dejamos en blanco la linea de mensajes.   *)
    (* 1: Mensaje por defecto del juego             *)
    CASE cod OF
         0 : Cube(FALSE, 0, 465, 639, 479, 0, 0, TRUE);
       | 1 : co := SetTextPosition(30, 34);
             (* De colorines! *)
             fg := SetTextColor(9); OutText("L");
             fg := SetTextColor(2); OutText("A ");
             fg := SetTextColor(4); OutText("S");
             fg := SetTextColor(7); OutText("E");
             fg := SetTextColor(5); OutText("R");
             fg := SetTextColor(6); OutText("P");
             fg := SetTextColor(14); OutText("I");
             fg := SetTextColor(3); OutText("E");
             fg := SetTextColor(10); OutText("N");
             fg := SetTextColor(11); OutText("T");
             fg := SetTextColor(12); OutText("E");
       | 2 : co := SetTextPosition(30, 12); OutText("Porfavor espera... Colocando muros. ");
             fg := SetTextColor(12); OutText("Pulsa ESC si tarda mucho.");
       | 3 : co := SetTextPosition(30, 9);
             OutText("Para jugar utiliza los cursores (");
             fg := SetTextColor(12); OutText(CHAR(27)); OutText(" "); OutText(CHAR(26));
             OutText(" "); OutText(CHAR(24)); OutText(" "); OutText(CHAR(25));
             fg := SetTextColor(4); OutText(") o pulsa "); fg := SetTextColor(12);
             OutText("ESC"); fg := SetTextColor(4); OutText(" para salir");
       | 4 : co := SetTextPosition(30, 32); OutText("Juego cancelado!");
       | 5 : co := SetTextPosition(30, 18); OutText("Pulsa cualquier tecla para empezar a jugar!");
    ELSE
         co := SetTextPosition(30, 1); OutText("Mensaje desconocido");
    END; (* Fin del CASO *)
    (* A ver si ha pintado el mensaje principal; para no redibujarlo siempre *)
    IF cod = 1 THEN
       MPP := TRUE;
    ELSE
       MPP := FALSE;
    END;
    RETURN(MPP);
END MsgErrorGrafico;

PROCEDURE MsgErrorTexto(codigo: CARDINAL);
(* Manejador de errores en modo texto; saca una ventana indicando  *)
(* un mensaje de error codificado por el parametro "codigo".       *)
VAR
  DefVent : WinDef;
  TipoVent : WinType;
  tecla : CHAR;
BEGIN
    (* Abrimos la ventana de menasjes de errores *)
    WITH DefVent DO
         X1 := 19;
         X2 := 60;
         Y1 := 9;
         Y2 := 15;
         Background := Red;
         Foreground := White;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := LightGray;
         FrameBack := Red;
         Hidden := FALSE;
    END;
    TipoVent := Window.Open(DefVent); GotoXY(1, 1);
    Window.SetTitle(TipoVent, " AVISO ", CenterUpperTitle);
    CursorOff; GotoXY(1, 1);
    CASE codigo OF
         1 : WrStr("* Tecla Incorrecta. Pulsa un numero de  las opciones del menu.");
      |  2 : WrStr("* Solo se admiten letras para introducir nombre.");
      |  3 : WrStr("* Pulsa V para regresar al menu");
             GotoXY(1, 2); WrStr("* Pulsa C para configurar el juego.");
      |  4 : WrStr("* El modo grafico 640x480 16 Colores,");
             GotoXY(1, 2); WrStr("  no esta soportado por el sistema!");
             GotoXY(1, 3); WrStr("* No se puede jugar...");
      |  5 : WrStr("* Solo se admiten numeros dentro del    rango indicado.");
      |  8 : WrStr("* Edicin. De 0 a 12 letras.");
             GotoXY(1, 3); WrStr("* Aceptar el nombre. Pulsar ENTER");
             GotoXY(1, 2); WrStr("* Borrar una letra. Pulsar BORRAR.");
      |  9 : WrStr("* El archivo de RECORDS no existe.");
             GotoXY(1, 2); WrStr("* Se crear una lista nueva");
      | 10 : WrStr("* Elije el tamao de los graficos. ");
             GotoXY(1, 2); WrStr("* Pulsa la letra inicial de un tamao");
      | 11 : WrStr("* Elije el tamao inicial de la cola.");
             GotoXY(1, 2); WrStr("* Pulsa la letra inicial de un tamao");
      | 12 : WrStr("* Elije la cantidad de muros.");
             GotoXY(1, 2); WrStr("* Pulsa la letra inicial de la cantidad");
      | 13 : WrStr("* Elije la velocidad de la Serpiente.");
             GotoXY(1, 2); WrStr("* Pulsa la letra inicial de una veloc.");
      | 14 : WrStr("* El archivo de RECORDS es incorrecto.");
             GotoXY(1, 2); WrStr("* Se inicializara la lista de nuevo.");
    ELSE
       WrStr("* Error no registrado.");
    END;
    TextColor(LightRed); GotoXY(1, 5); WrStr(" Pulsa una tecla para continuar");
    tecla := RdKey();
    Window.Close(TipoVent);
END MsgErrorTexto;

(*---------------------------------------------------------------------------*)
(* SUBALGORITMOS DE ADMINISTRACION DE LA LISTA DE RECORDS                    *)
(*---------------------------------------------------------------------------*)
PROCEDURE InicializaRecords(VAR rec:TRecords);
(* Inicializa el registro de records desde el elemento MIN(IndRec) *)
VAR
  i : CARDINAL;
BEGIN
    (* Inicializamos la lista de records con este bucle *)
    FOR i := MIN(IndRec) TO MAX(IndRec) DO
        rec[i].Nombre := "Vacio";
        rec[i].Puntos := 0;
    END;
END InicializaRecords;

PROCEDURE LeeRecords(VAR rec:TRecords);
(* Lee la lista de records de un archivo *)
VAR
   i : CARDINAL;
   nbl : CARDINAL;
   Archivo : FIO.File;
BEGIN
    (* Si no existe el archivo damos informacion por defecto *)
    IF Exists(ArchRec) THEN
    (* Si ya existe el archivo, lo leemos; si esta mal creamos nueva lista *)
       (* Abre el archivo *)
       Archivo := FIO.Open(ArchRec);
       (* Si el tamao del archivo no corresponde con el tamao de la lista *)
       (* de records, entonces el archivo esta mal.                         *)
       IF Size(Archivo) = SIZE(rec) THEN
          (* Procedemos a la lectura de bits *)
          FOR i:= MIN(IndRec) TO MAX(IndRec) DO
              (* Leemos los bits para un nombre *)
              nbl := RdBin(Archivo, rec[i].Nombre, SIZE(rec[i].Nombre));
              (* Leemos los bits para unos puntos *)
              nbl := RdBin(Archivo, rec[i].Puntos , SIZE(rec[i].Puntos));
          END;
       ELSE
          (* El archivo esta mal; creamos una nueva *)
          MsgErrorTexto(14);
          InicializaRecords(rec);
       END;
       (* Cierra el fichero; este mal o bien *)
       FIO.Close(Archivo);
    ELSE
    (* Si no existe mandamos un mensaje de aviso y creamos una lista nueva *)
       MsgErrorTexto(9);
       InicializaRecords(rec);
    END;
END LeeRecords;

PROCEDURE GuardaRecords(rec:TRecords);
(* Escribe la lista de records en un archivo *)
VAR
  i : CARDINAL;
  Archivo : FIO.File;
BEGIN
    (* Abre un archivo y destruye su contenido. Si no existia lo crea *)
    Archivo := FIO.Create(ArchRec);
    (* Escribe los datos del archivo *)
    FOR i := MIN(IndRec) TO MAX(IndRec) DO
        (* Escribe el bloque de bits para un nombre *)
        WrBin(Archivo, rec[i].Nombre, SIZE(rec[i].Nombre));
        (* Escribe el bloque de bits para unos puntos *)
        WrBin(Archivo, rec[i].Puntos, SIZE(rec[i].Puntos));
    END;
    (* Cierra el fichero *)
    FIO.Close(Archivo);
END GuardaRecords;

PROCEDURE MostrarRecords(rec:TRecords);
(* Muestra la lista de records en una ventana por pantalla *)
VAR
  Tecla : CHAR;
  DefVent : WinDef;
  TipoVent : WinType;
  cont : CARDINAL;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH DefVent DO
         X1 := 21;
         X2 := 58;
         Y1 := 5;
         Y2 := MAX(IndRec)+8;
         Background := Blue;
         Foreground := White;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Yellow;
         FrameBack := Blue;
         Hidden := FALSE;
    END;
    (* Abre la ventana de instrucciones *)
    TipoVent := Window.Open(DefVent);
    (* Aade el titulo a la ventana de instrucciones *)
    Window.SetTitle(TipoVent, " Tabla de Records ", CenterUpperTitle);
    (* Dibuja la lista en la ventana; posiciones relativas a la ventana *)
    FOR cont := MIN(IndRec) TO MAX(IndRec) DO
        GotoXY(3, cont+1);
        TextColor(LightCyan); WrStr("  ");
        TextColor(White); WrCard(cont, 2); WrStr("  ");
        TextColor(Yellow); WrStr(rec[cont].Nombre);
        TextColor(LightGreen); GotoXY(27, cont+1); WrLngCard(rec[cont].Puntos, 0);
    END;
    (* Espera que se pulse una tecla *)
    CursorOff;
    Tecla := RdKey();
    (* Eliminamos la ventana *)
    Window.Close(TipoVent);
END MostrarRecords;

PROCEDURE InsertarRecord(puntos:LONGCARD; nombre:TCadena; VAR rec:TRecords);
(* Inserta un record, de forma ordenada en la lista de records *)
(* El criterio de ordenacin sigue la cantidad creciente de puntos *)
VAR
  indice : CARDINAL;
  cont : CARDINAL;
BEGIN
    indice := MIN(IndRec);
    WHILE (indice < MAX(IndRec)) AND (rec[indice].Puntos > puntos) DO
             indice := indice + 1;
    END;
    (* Desplazamos si no es la ultima posicion *)
    cont := MAX(IndRec);
    WHILE cont > indice DO
       rec[cont] := rec[cont-1];
       cont := cont-1;
    END;
    rec[indice].Nombre := nombre;
    rec[indice].Puntos := puntos;
END InsertarRecord;

PROCEDURE NuevoRecord(puntos:LONGCARD):TCadena;
(* Informa al jugador de que ha entrado en la lista de records,  *)
(* muestra su puntuacion y le pide su nombre.                    *)
VAR
  letra : CHAR;
  nombre : TCadena;
  Terminado : BOOLEAN;
  cursor : CARDINAL;
  DefVent : WinDef;
  TipoVent : WinType;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH DefVent DO
         X1 := 18;
         X2 := 59;
         Y1 := 7;
         Y2 := 12;
         Background := Blue;
         Foreground := White;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Yellow;
         FrameBack := Blue;
         Hidden := FALSE;
    END;
    (* Abre una ventana para introducir un nombre *)
    TipoVent := Window.Open(DefVent);
    (* Aade el titulo a la ventana *)
    Window.SetTitle(TipoVent, " Nuevo Record ", CenterUpperTitle);
    (* Dibuja los mensajes en la ventana; posiciones relativas a la ventana *)
    GotoXY(2, 1); TextColor(Yellow); WrChar(CHAR(4)); WrStr(" TUS PUNTOS ESTAN EN LOS 10 MEJORES "); WrChar(CHAR(4));
    TextColor(LightCyan); GotoXY(2, 3); WrStr(" Introduce tu nombre: ");
    (* Lee una cadena de letras; no se admiten ni , ni tildes *)
    CursorOn; TextColor(White);
    cursor := MIN(IndCad);
    Terminado := FALSE;
    REPEAT
         letra := RdKey();
         IF (CAP(letra) >= 'A') AND (CAP(letra) <='Z') AND (cursor < MAX(IndCad)) THEN
            WrChar(letra);
            nombre[cursor] := letra;
            cursor := cursor + 1;
         ELSIF (ORD(letra) = 32) AND (cursor < MAX(IndCad)) THEN
            WrChar(' ');
            nombre[cursor]:= ' ';
            cursor := cursor + 1;
         ELSIF (ORD(letra) = 8) AND (cursor > MIN(IndCad)) THEN
            GotoXY(WhereX()-1, WhereY());
            WrChar(' ');
            GotoXY(WhereX()-1, WhereY());
            cursor := cursor-1;
            nombre[cursor]:=CHR(0);
         ELSIF (ORD(letra) = 13) AND (cursor <= MAX(IndCad)) THEN
            nombre[cursor] := CHR(0);
            Terminado := TRUE;
         ELSE
            MsgErrorTexto(8);
         END;
    UNTIL Terminado;
    (* Eliminamos la ventana *)
    Window.Close(TipoVent);
    (* Devolvemos el nombre obtenido *)
    RETURN(nombre);
END NuevoRecord;

(*---------------------------------------------------------------------------*)
(* SUBALGORITMOS QUE SACA VENTANAS DE INFORMACION GENERALES                  *)
(*---------------------------------------------------------------------------*)
PROCEDURE Menu1():CHAR;
(* Saca el menu principal de opciones en una ventana por pantalla *)
VAR
  Opcion : CHAR;
  OK : BOOLEAN;
  DefVent : WinDef;
  TipoVent : WinType;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH DefVent DO
         X1 := 22;
         X2 := 56;
         Y1 := 3;
         Y2 := 15;
         Background := LightGray;
         Foreground := Black;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Blue;
         FrameBack := LightGray;
         Hidden := FALSE;
    END;
    (* Abre la ventana de menu *)
    TipoVent := Window.Open(DefVent);
    (* Aade el titulo a la ventana de menu *)
    Window.SetTitle(TipoVent, " Menu Principal ", CenterUpperTitle);
    (* Dibuja las opciones en la ventana; posiciones relativas a la ventana *)
    TextColor(Red);
    GotoXY(5, 2); WrStr("1");
    GotoXY(5, 4); WrStr("2");
    GotoXY(5, 6); WrStr("3");
    GotoXY(5, 8); WrStr("4");
    GotoXY(5, 10); WrStr("5");
    TextColor(Black);
    GotoXY(6, 2); WrStr(". Partida nueva");
    GotoXY(6, 4); WrStr(". Ver tabla de Records");
    GotoXY(6, 6); WrStr(". Configurar dificultad");
    GotoXY(6, 8); WrStr(". Instrucciones");
    GotoXY(6, 10); WrStr(". Salir");
    (* Inicia el bucle de lectura de la opcion deseada *)
    CursorOff;
    OK := FALSE;
    REPEAT
         Opcion := RdKey();
         IF (Opcion < '1') OR (Opcion > '5') THEN
            MsgErrorTexto(1);
         END;
    UNTIL (Opcion >= '1') AND (Opcion <= '5');
    (* Eliminamos la ventana *)
    Window.Close(TipoVent);
    (* Devolvemos la opcion leida *)
    RETURN(Opcion);
END Menu1;

PROCEDURE Instrucciones();
(* Muestra una ventana con las instrucciones del juego *)
VAR
  Tecla : CHAR;
  DefVent : WinDef;
  TipoVent : WinType;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH DefVent DO
         X1 := 8;
         X2 := 70;
         Y1 := 5;
         Y2 := 19;
         Background := Black;
         Foreground := Cyan;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Black;
         FrameBack := Green;
         Hidden := FALSE;
    END;
    (* Abre la ventana de instrucciones *)
    TipoVent := Window.Open(DefVent);
    (* Aade el titulo a la ventana de instrucciones *)
    Window.SetTitle(TipoVent, " Instrucciones ", CenterUpperTitle);
    (* Dibuja las opciones en la ventana; posiciones relativas a la ventana *)
    GotoXY(2, 2); TextColor(Red); WrChar(CHR(4)); TextColor(Green);
    WrStr(" Este es el clasico juego de la serpiente. En este juego"); WrLn;
    WrStr(" una serpiente se mueve por la pantalla y cada vez que se"); WrLn;
    WrStr(" come un punto le crece la cola."); WrLn;
    WrStr(" El objetivo del juego es aumentar la serpiente tanto como"); WrLn;
    WrStr(" se pueda."); WrLn;
    WrStr(" La partida terminara cuando la cabeza de la serpiente choca"); WrLn;
    WrStr(" con algun muro de los que hay por pantalla, de los bordes o"); WrLn;
    WrStr(" con su propia cola."); WrLn;
    WrStr(" La puntuacion de la serpiente depende de los parametros de"); WrLn;
    WrStr(" juego, de tal forma que contra ms dificil sea, ms puntos"); WrLn;
    WrStr(" obtendremos cuando nos comamos la comida."); WrLn;
    (* Espera que se pulse una tecla *)
    CursorOff;
    Tecla := RdKey();
    (* Eliminamos la ventana *)
    Window.Close(TipoVent);
END Instrucciones;

PROCEDURE AbreCreditos(VAR TipoVentCred : WinType; VAR DefVentCred : WinDef);
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH DefVentCred DO
         X1 := 10;
         X2 := 68;
         Y1 := 17;
         Y2 := 23;
         Background := Cyan;
         Foreground := Black;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Yellow;
         FrameBack := Cyan;
         WrapOn := FALSE;
         Hidden := FALSE;
    END;
    (* Abre la ventana de instrucciones *)
    TipoVentCred := Window.Open(DefVentCred);
    (* Aade el titulo a la ventana *)
    Window.SetTitle(TipoVentCred, " Creditos ", CenterUpperTitle);
    (* Apagamos el cursor en esta ventana *)
    CursorOff;
    (* Contenido de la ventana *)
    GotoXY(2, 1); WrStr("Autor: Jose Antonio Lopez Suarez. Curso 1999/2000");
    GotoXY(2, 2); WrStr("I.T.T. Esp. Sistemas de Telecomunicacion (Primero B)");
    GotoXY(2, 3); WrStr("PRACTICA 2. La Serpiente (Modo Grafico)");
    GotoXY(2, 4); WrStr("Laboratorio de Programacion. Universidad de Mlaga.");
    GotoXY(2, 5); WrStr("Departamento de Lenguajes y Ciencias de la Computacion");
END AbreCreditos;

PROCEDURE FinDeJuego(puntos:LONGCARD);
(* Muestra una ventana indicando que se ha terminado el juego *)
VAR
  Tecla : CHAR;
  DefVent : WinDef;
  TipoVent : WinType;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH DefVent DO
         X1 := 21;
         X2 := 57;
         Y1 := 7;
         Y2 := 13;
         Background := Blue;
         Foreground := Yellow;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Yellow;
         FrameBack := Blue;
         Hidden := FALSE;
    END;
    (* Abre la ventana *)
    TipoVent := Window.Open(DefVent);
    (* Aade el titulo a la ventana *)
    Window.SetTitle(TipoVent, " Fin de Juego ", CenterUpperTitle);
    (* Dibuja la informacion en la ventana *)
    GotoXY(5, 1); TextColor(Yellow); WrChar(CHR(4)); WrStr(" HA TERMINADO LA PARTIDA "); WrChar(CHR(4));
    GotoXY(3, 3); TextColor(White); WrChar(CHR(16)); WrChar(CHR(16)); TextColor(Yellow); WrStr(" Puntuacin: ");
    TextColor(LightGreen); WrLngCard(puntos, 0);
    GotoXY(2, 5); TextColor(LightCyan); WrStr(" Pulsa una ENTER para continuar ");
    (* Espera que se pulse una tecla *)
    CursorOff; REPEAT Tecla := RdKey(); UNTIL ORD(Tecla) = 13;
    (* Eliminamos la ventana *)
    Window.Close(TipoVent);
END FinDeJuego;

(*---------------------------------------------------------------------------*)
(* SUBALGORITMOS QUE CREAN EL ENTORNO DE MENUS; TITULO, BORDES, ETC...       *)
(*---------------------------------------------------------------------------*)
PROCEDURE DibujaFondo();
(* Dibuja el fondo de la pantalla de menus *)
VAR
  x, y : CARDINAL;
BEGIN
    (* Dibuja los muros superiores e inferiores *)
    TextBackground(Black); TextColor(Blue);
    FOR x := 1 TO 79 BY 5 DO
        FOR y := 1 TO 25 DO
           GotoXY(x, y); WrStr('');
        END;
    END;
END DibujaFondo;

PROCEDURE DibujaTitulo();
(* Posiciona y dibuja y colorea el titulo del juego *)
BEGIN
    (* Color de fondo *)
    TextBackground(Black);
    (* Contenido *)
    TextColor(Red);
    GotoXY(27, 2); WrStr("                       ");
    TextColor(LightGreen);
    GotoXY(30, 2); WrStr("JUEGO DE LA SERPIENTE");
END DibujaTitulo;

(*---------------------------------------------------------------------------*)
(* SUBALGORITMOS PARA CONFIGURAR LOS PARAMETROS DEL JUEGO                    *)
(*---------------------------------------------------------------------------*)
PROCEDURE CambiarParametros(VAR param:TParametros);
(* Muestra una ventana con el contenido de los parametros modificables *)
(* Va pidiendo datos para modificarlos *)
VAR
  Op, tecla : CHAR;
  Velocidad : CARDINAL;
  cursor : CARDINAL;
  Volver, Completo : BOOLEAN;
  Conf : WinDef;
  Vent : WinType;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH Conf DO
         X1 := 13;
         X2 := 62;
         Y1 := 3;
         Y2 := 21;
         Background := LightGray;
         Foreground := Black;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Blue;
         FrameBack := LightGray;
         WrapOn := FALSE;
         Hidden := FALSE;
    END;
    (* Abre la ventana de instrucciones *)
    Vent := Window.Open(Conf);
    (* Aade el titulo a la ventana *)
    Window.SetTitle(Vent, " Cambiar parametros ", CenterUpperTitle);
    (* Escribe la informacion por pantalla por pantalla *)
    Clear; TextBackground(LightGray); TextColor(Red);
    GotoXY(3, 2); WrStr(" Tamao de la serpiente: ");
    GotoXY(3, 6); WrStr(" Tamao inicial de la cola: ");
    GotoXY(3, 10); WrStr(" Cantidad de muros: ");
    GotoXY(3, 14); WrStr(" Nivel de velocidad: ");
    (* Opciones para el tamao de la serpiente *)
    TextBackground(Black); TextColor(Yellow);
    GotoXY(6, 4); WrStr(" Enana ");
    GotoXY(15, 4); WrStr(" Regular ");
    GotoXY(26, 4); WrStr(" Grande ");
    GotoXY(36, 4); WrStr(" Bestial ");
    TextColor(Red);
    GotoXY(7, 4); WrStr("E");
    GotoXY(16, 4); WrStr("R");
    GotoXY(27, 4); WrStr("G");
    GotoXY(37, 4); WrStr("B");
    (* Opciones para el tamao inicial de la serpiente*)
    TextBackground(Black); TextColor(Yellow);
    GotoXY(6, 8); WrStr(" Corta ");
    GotoXY(15, 8); WrStr(" Media ");
    GotoXY(24, 8); WrStr(" Larga ");
    TextColor(Red);
    GotoXY(7, 8); WrStr("C");
    GotoXY(16, 8); WrStr("M");
    GotoXY(25, 8); WrStr("L");
    (* Opciones para la cantidad de muros *)
    TextBackground(Black); TextColor(Yellow);
    GotoXY(6, 12); WrStr(" Ninguno ");
    GotoXY(17, 12); WrStr(" Pocos ");
    GotoXY(26, 12); WrStr(" Algunos ");
    GotoXY(37, 12); WrStr(" Muchos ");
    TextColor(Red);
    GotoXY(7, 12); WrStr("N");
    GotoXY(18, 12); WrStr("P");
    GotoXY(27, 12); WrStr("A");
    GotoXY(38, 12); WrStr("M");
    (* Opciones para la velocidad *)
    TextBackground(Black); TextColor(Yellow);
    GotoXY(6, 16); WrStr(" Lenta ");
    GotoXY(15, 16); WrStr(" Normal ");
    GotoXY(25, 16); WrStr(" Rapida ");
    TextColor(Red);
    GotoXY(7, 16); WrStr("L");
    GotoXY(16, 16); WrStr("N");
    GotoXY(26, 16); WrStr("R");
    (* Pide la configuracion del tamao de los graficos del juego *)
    CursorOff; TextBackground(Blue); TextColor(White);
    GotoXY(4, 2); WrStr(" Tamao de la serpiente:");
    (* Menu de opciones *)
    TextBackground(LightGray); TextColor(Blue); GotoXY(29, 2);
    REPEAT
         tecla := RdKey();
         CASE CAP(tecla) OF
              'E' :
                    param.Tamano := Enana;
                    WrStr("[Enana]");
            | 'R' :
                    param.Tamano := Regular;
                    WrStr("[Regular]");
            | 'G' :
                    param.Tamano := Grande;
                    WrStr("[Grande]");
            | 'B' :
                    param.Tamano := Bestial;
                    WrStr("[Bestial]");
         ELSE
            MsgErrorTexto(10);
         END;
    UNTIL (CAP(tecla)='E') OR (CAP(tecla)='R') OR
          (CAP(tecla)='G') OR (CAP(tecla)='B');
    TextBackground(LightGray); TextColor(Red);
    GotoXY(3, 2); WrStr(" Tamao de la serpiente:");
    (* Pide la configuracio para el tamao inicial de la cola *)
    CursorOff; TextBackground(Blue); TextColor(White);
    GotoXY(4, 6); WrStr(" Tamao inicial de la cola: ");
    (* Menu de opciones *)
    TextBackground(LightGray); TextColor(Blue); GotoXY(32, 6);
    REPEAT
         tecla := RdKey();
         CASE CAP(tecla) OF
              'C' :
                    param.IniCola := Corta;
                    WrStr("[Corta]");
            | 'M' :
                    param.IniCola := Media;
                    WrStr("[Media]");
            | 'L' :
                    param.IniCola := Larga;
                    WrStr("[Larga]");
         ELSE
            MsgErrorTexto(11);
         END;
    UNTIL (CAP(tecla)='C') OR (CAP(tecla)='M') OR
          (CAP(tecla)='L');
    TextBackground(LightGray); TextColor(Red);
    GotoXY(3, 6); WrStr(" Tamao inicial de la cola: ");
    (* Pide la configuracion la cantidad de muros *)
    CursorOff; TextBackground(Blue); TextColor(White);
    GotoXY(4, 10); WrStr(" Cantidad de muros:");
    (* Menu de opciones *)
    TextBackground(LightGray); TextColor(Blue); GotoXY(24, 10);
    REPEAT
         tecla := RdKey();
         CASE CAP(tecla) OF
              'N' :
                    param.NumMuros := Ninguno;
                    WrStr("[Ninguno]");
            | 'P' :
                    param.NumMuros := Pocos;
                    WrStr("[Pocos]");
            | 'A' :
                    param.NumMuros := Algunos;
                    WrStr("[Algunos]");
            | 'M' :
                    param.NumMuros := Muchos;
                    WrStr("[Muchos]");
         ELSE
            MsgErrorTexto(12);
         END;
    UNTIL (CAP(tecla)='N') OR (CAP(tecla)='P') OR
          (CAP(tecla)='A') OR (CAP(tecla)='M');
    TextBackground(LightGray); TextColor(Red);
    GotoXY(3, 10); WrStr(" Cantidad de muros: ");
    (* Pide la configuracion para el nivel de velocidad *)
    CursorOff; TextBackground(Blue); TextColor(White);
    GotoXY(4, 14); WrStr(" Nivel de velocidad: ");
    (* Menu de opciones *)
    TextBackground(LightGray); TextColor(Blue); GotoXY(25, 14);
    REPEAT
         tecla := RdKey();
         CASE CAP(tecla) OF
              'L' :
                    param.Velocidad := Lenta;
                    WrStr("[Lenta]");
            | 'N' :
                    param.Velocidad := Normal;
                    WrStr("[Normal]");
            | 'R' :
                    param.Velocidad := Rapida;
                    WrStr("[Rapida]");
         ELSE
            MsgErrorTexto(13);
         END;
    UNTIL (CAP(tecla)='L') OR (CAP(tecla)='N') OR
          (CAP(tecla)='R');
    TextBackground(LightGray); TextColor(Red);
    GotoXY(3, 14); WrStr(" Nivel de velocidad: ");
    (* Eliminamos la ventana y salimos del subprograma *)
    Window.Close(Vent);
END CambiarParametros;

PROCEDURE MostrarParametros(VAR param:TParametros);
(* Muestra una ventana con los parametros actuales de juego *)
(* Ofrece la opcion de modificarlos o no *)
VAR
  Op, tecla : CHAR;
  cursor : CARDINAL;
  Volver, Completo : BOOLEAN;
  ConfVent : WinDef;
  Vent : WinType;
BEGIN
    (* Define las caracteristicas iniciales de la ventana *)
    WITH ConfVent DO
         X1 := 19;
         X2 := 60;
         Y1 := 5;
         Y2 := 17;
         Background := Cyan;
         Foreground := Black;
         FrameOn := TRUE;
         FrameDef := DoubleFrame;
         FrameFore := Yellow;
         FrameBack := Cyan;
         Hidden := FALSE;
    END;
    (* Abre la ventana *)
    Vent := Window.Open(ConfVent);
    (* Aade el titulo a la ventana *)
    Window.SetTitle(Vent, " Configurar dificultad ", CenterUpperTitle);
    (* Dibuja la informacin en la ventana; posiciones relativas a la ventana *)
    CursorOff; TextBackground(Cyan); TextColor(Black);
    GotoXY(3, 2); WrStr(" Tamao de la serpiente: ");
    GotoXY(3, 4); WrStr(" Tamao inicial de la cola: ");
    GotoXY(3, 6); WrStr(" Cantidad de muros: ");
    GotoXY(3, 8); WrStr(" Nivel de velocidad: ");
    (* Botones de accion *)
    TextBackground(LightGray);
    TextColor(Black); GotoXY(9, 10); WrStr(" Volver ");
    TextColor(Black); GotoXY(24, 10); WrStr(" Cambiar ");
    TextColor(Red); GotoXY(10, 10); WrStr("V");
    TextColor(Red); GotoXY(25, 10); WrStr("C");
    (* Inicializa variables booleanas *)
    Volver := FALSE;
    Completo := FALSE;
    (* Inicia el bucle de opciones *)
    REPEAT
         (* Colores del texto y del fondo *)
         TextBackground(Cyan); TextColor(White);
         (* Actualiza los datos del tamao de la serpiente *)
         GotoXY(28, 2); WrStr("          "); GotoXY(28, 2);
         CASE param.Tamano OF
                Enana: WrStr("Enana");
             |  Regular: WrStr("Regular");
             |  Grande: WrStr("Grande");
             |  Bestial: WrStr("Bestial");
         ELSE
            WrStr("No se");
         END;
         (* Actualiza los datos del tamao inicial de la cola *)
         GotoXY(31, 4); WrStr("          "); GotoXY(31, 4);
         CASE param.IniCola OF
                Corta: WrStr("Corta");
             |  Media: WrStr("Media");
             |  Larga: WrStr("Larga");
         ELSE
            WrStr("No se");
         END;
         (* Actualiza los datos de la cantidad de muros *)
         GotoXY(23, 6); WrStr("          "); GotoXY(23, 6);
         CASE param.NumMuros OF
                Ninguno: WrStr("Ninguno");
             |  Pocos: WrStr("Pocos");
             |  Algunos: WrStr("Algunos");
             |  Muchos: WrStr("Muchos");
         ELSE
            WrStr("No se");
         END;
         (* Actualiza los datos de la velocidad de la serpiente *)
         GotoXY(24, 8); WrStr("          "); GotoXY(24, 8);
         CASE param.Velocidad OF
                Lenta: WrStr("Lenta");
             |  Normal: WrStr("Normal");
             |  Rapida: WrStr("Rapida");
         ELSE
            WrStr("No se");
         END;
         (* Pide una opcion *)
         Op := RdKey();
         CASE CAP(Op) OF
              'V': Volver := TRUE;
            | 'C': CambiarParametros(param);
         ELSE
            MsgErrorTexto(3);
         END;
    UNTIL Volver;
    (* Eliminamos la ventana *)
    Window.Close(Vent);
END MostrarParametros;

(*--------------------------------------------------------------------------*)
(* ALGORITMOS COMUNES PARA GENERAR LOS MUROS Y LA COMIDA                    *)
(*--------------------------------------------------------------------------*)
PROCEDURE GeneraPos(margen:CARDINAL): TCoord;
(* Algoritmo que calcula una posicin aleatoria dentro del campo    *)
(* de juego; con un marge dado (0 o mas)                            *)
VAR
  pos : TCoord;
  temp_x, temp_y : CARDINAL;    (* Variables temporales para calcula posicion *)
BEGIN
    (* Controla el valor de margen; evitamos Out of Range *)
    IF (margen > FCampoX) OR (margen > FCampoY) THEN
       margen := 0;
    END;
    (* Genera las posibles coordenadas en el campo de juego *)
    REPEAT
         (* Aqui habia un error *)
         temp_x := RANDOM(FCampoX-margen);
         temp_y := RANDOM(FCampoY-margen);
    UNTIL (temp_x > ICampoX+margen) AND (temp_y > ICampoY+margen);
    pos.x := temp_x;
    pos.y := temp_y;
    RETURN (pos);
END GeneraPos;

(*--------------------------------------------------------------------------*)
(* ALGORITMOS PARA GENERAR Y GESTIONAR LOS MUROS DEL JUEGO.                 *)
(*--------------------------------------------------------------------------*)
PROCEDURE DibujaMuro(LongMuro, AnchMuro:CARDINAL; muro:TMuro);
(* Algoritmo que dibuja un muro a partir de un tipo TMuro.                *)
(* Lo dibuja en azul porque asi queda mas guay.                           *)
(* Las longitudes y anchuras de los muros depende de las variables dadas. *)
(*    Longitud del muro: LongMuro; Anchura del muro: AnchMuro             *)
BEGIN
    CASE muro.orienta OF
         Horizontal: (* Dibuja un muro Horizontal *)
              WITH muro DO
                   (* Las lineas laterales *)
                   Line(pos.x+(AnchMuro DIV 2), pos.y, pos.x+LongMuro-(AnchMuro DIV 2), pos.y, ColorMuro);
                    Line(pos.x+(AnchMuro DIV 2), pos.y+AnchMuro, pos.x+LongMuro-(AnchMuro DIV 2), pos.y+AnchMuro, ColorMuro);
                   (* Los arcos de los extremos *)
                   Arc(pos.x+(AnchMuro DIV 2), pos.y+(AnchMuro DIV 2), AnchMuro DIV 2, AnchMuro DIV 2, pos.x+(AnchMuro DIV 2), pos.y, pos.x+(AnchMuro DIV 2), pos.y+AnchMuro, ColorMuro);
                   Arc(pos.x+LongMuro-(AnchMuro DIV 2), pos.y+(AnchMuro DIV 2),  AnchMuro DIV 2, AnchMuro DIV 2, pos.x+LongMuro-(AnchMuro DIV 2), pos.y+AnchMuro, pos.x+LongMuro-(AnchMuro DIV 2), pos.y,  ColorMuro);
              END; (* Fin del WITH *)
       | Vertical: (* Dibuja un muro Vertical *)
              WITH muro DO
                   (* Las lineas laterales *)
                   Line(pos.x, pos.y+(AnchMuro DIV 2), pos.x, pos.y+LongMuro-(AnchMuro DIV 2), ColorMuro);
                   Line(pos.x+AnchMuro, pos.y+(AnchMuro DIV 2), pos.x+AnchMuro, pos.y+LongMuro-(AnchMuro DIV 2), ColorMuro);
                   (* Los arcos de los extremos *)
                   Arc(pos.x+(AnchMuro DIV 2), pos.y+(AnchMuro DIV 2), AnchMuro DIV 2,AnchMuro DIV 2, pos.x+AnchMuro, pos.y+(AnchMuro DIV 2), pos.x, pos.y+(AnchMuro DIV 2), ColorMuro);
                   Arc(pos.x+(AnchMuro DIV 2), pos.y+LongMuro-(AnchMuro DIV 2), AnchMuro DIV 2,AnchMuro DIV 2, pos.x, pos.y+LongMuro-(AnchMuro DIV 2), pos.x+AnchMuro, pos.y+LongMuro-(AnchMuro DIV 2), ColorMuro);
              END; (* Fin del WITH *)
    END; (* Fin del CASO *)
END DibujaMuro;

PROCEDURE EstaEnMuro(LongMuro, AnchMuro:CARDINAL; pos: TCoord; muro:TMuro; Margen:CARDINAL): BOOLEAN;
(* Algoritmo que nos dice si el punto dado esta o no en el area de un muro *)
(* Hay posibilidad de utilizar un margen para el muro.                     *)
VAR
  Esta : BOOLEAN;    (* Si 'Esta' es VERDADERO; el punto esta en el muro *)
BEGIN
    CASE muro.orienta OF
         Vertical:  (* Comprueba el punto si se trata de un muro Vertical *)
             IF (pos.x >= muro.pos.x-Margen) AND (pos.x <= muro.pos.x+AnchMuro+Margen) AND
                (pos.y >= muro.pos.y-Margen) AND (pos.y <= muro.pos.y+LongMuro+Margen) THEN
                    Esta := TRUE;
             ELSE
                    Esta := FALSE;
             END;
       | Horizontal: (* Comprueba el punto dado para un muro Horizontal *)
             IF (pos.y >= muro.pos.y-Margen) AND (pos.y <= muro.pos.y+AnchMuro+Margen) AND
                (pos.x >= muro.pos.x-Margen) AND (pos.x <= muro.pos.x+LongMuro+Margen) THEN
                    Esta := TRUE;
             ELSE
                    Esta := FALSE;
             END;
    END;
    RETURN(Esta);
END EstaEnMuro;

PROCEDURE CabezaEnMapaMuros(LongMuro, AnchMuro, Cuadro: CARDINAL;
                            pos : TCoord; MapaMuros:TMapaMurosLista):BOOLEAN;
(* Comprueba si el cuadro generado a partir del punto (pos.x,pos.y), esta *)
(* en algun muro del mapa de muros.                                       *)
VAR
  Esta : BOOLEAN;
  pos_aux : TCoord;
  ptr_aux : TMapaMurosLista;
BEGIN
    (* Tomamos la premisa de que no esta en el mapa de muros *)
    Esta := FALSE;
    (* Recorremos la lista del mapa de muros y comprobamos para cada muro *)
    ptr_aux := MapaMuros;
    WHILE (ptr_aux <> NIL) AND NOT(Esta) DO
        (* Generamos el mapa de pixels de la cabeza de la serpiente *)
        pos_aux.x := pos.x;
        WHILE (pos_aux.x <= pos.x+Cuadro) AND NOT(Esta) DO
            pos_aux.y := pos.y;
            WHILE (pos_aux.y <= pos.y+Cuadro) AND NOT(Esta) DO
                (* Se hacen las comprobaciones *)
                Esta := EstaEnMuro(LongMuro, AnchMuro, pos_aux, ptr_aux^.dato, 0);
                pos_aux.y := pos_aux.y + 1;
            END; (* Fin del MIENTRAS *)
            pos_aux.x := pos_aux.x + 1;
        END; (* Fin del MIENTRAS *)
        (* Pasa al siguiente muro *)
        ptr_aux := ptr_aux^.sig;
    END; (* Fin del MIENTRAS *)
    RETURN(Esta);
END CabezaEnMapaMuros;

PROCEDURE GeneraMuros(LongMuro, AnchMuro, Cuadro:CARDINAL;
          muros, separa, ElemInic : CARDINAL; VAR MapaMuros : TMapaMurosLista);
(* Genera muros de forma inteligente en el campo de juego       *)
(* Este algoritmo es un poco extenso debido a la cantidad de    *)
(* condiciones impuestas para generar muros aleatorios.         *)
(* Parametros de este algoritmo:                                *)
(*   muros = numero de muros a generar                          *)
(*   separa = separacion entre los muros que se crearan         *)
(*   ElemInic = cuantos elementos iniciales tendra la serpiente *)
(*   MapaMuros = El mapa de muros en s                         *)
VAR
  PosVal : BOOLEAN;               (* Para ver si una posicion es valida *)
  pos : TCoord;                   (* Guarda la posicion actual *)
  cont : CARDINAL;                (* Para los bucles *)
  aux, aux1 : TCoord;             (* Posiciones temporales; para operar *)
  ptr, ptr_aux : TMapaMurosLista; (* Puntero auxiliar *)
  Cancelar : BOOLEAN;             (* Puede cancelar todo este algoritmo *)
BEGIN
    (* Inicializamos el generador de numeros aleatorios *)
    RANDOMIZE;
    (* Inicializa el puntero de la lista del mapa de muros *)
    MapaMuros := NIL;
    (* Inicializa variables Booleanas para los bucles de generacion *)
    PosVal := FALSE; Cancelar := FALSE;
    (* Genera los muros verticales *)
    cont := 1;
    WHILE (cont <= (muros DIV 2)) AND NOT(Cancelar) DO
        (* Comienza el bucle que buscara la posicion idonea para el muro *)
        REPEAT
              (* Genera una nueva posicin aleatoria en pantalla *)
              pos := GeneraPos(1);
              (* Tomamos como premisa que la posicion es valida con lo cual *)
              (* PosVal es CIERTA; y si esta mal situada entonces PosVal    *)
              (* tomara el valor de FALSO.                                  *)
              PosVal := TRUE;
              (* Comprueba el muro esta dentro de la pantalla bien situado *)
              (* con respecto al muro de los bordes                        *)
              IF (pos.x >= ICampoX+separa) AND (pos.x+AnchMuro <= FCampoX-separa) AND
                 (pos.y >= ICampoY+separa) AND (pos.y+LongMuro <= FCampoY-separa) THEN
                    PosVal := TRUE;
              ELSE
                    PosVal := FALSE;
              END;
              (* Comprueba que no esta en el area de inicio de juego    *)
              (* Comprueba que esta separado de otros muros ya creados *)
              aux.x := (FCampoX DIV 2);
              aux.y := (FCampoY DIV 2);
              aux1.y := pos.y;
              WHILE (aux1.y <= pos.y+LongMuro) AND PosVal DO
                    aux1.x := pos.x;
                    WHILE (aux1.x <= pos.x+AnchMuro) AND PosVal DO
                          (* Comprueba que no esta en el area de inicio de juego  *)
                          IF (aux1.x >= aux.x-(10*Cuadro)) AND (aux1.x <= aux.x+(ElemInic*Cuadro)+Cuadro) AND
                             (aux1.y >= aux.y-(2*Cuadro)) AND (aux1.y <= aux.y+(2*Cuadro)) THEN
                               PosVal := FALSE;
                          ELSE
                               PosVal := TRUE;
                          END;
                          (* Comprueba que esta separado de otros muros ya creados *)
                          ptr_aux := MapaMuros;
                          WHILE (ptr_aux <> NIL) AND PosVal DO
                              PosVal := NOT EstaEnMuro(LongMuro, AnchMuro, aux1, ptr_aux^.dato, separa);
                              ptr_aux := ptr_aux^.sig;
                          END; (* Fin del MIENTRAS *)
                          aux1.x := aux1.x + 1;
                    END; (* Fin del MIENTRAS *)
                    aux1.y := aux1.y + 1;
              END; (* Fin del MIENTRAS *)
              (* Controla la pulsacion de alguna tecla para no seguir *)
              IF KeyPressed() THEN
                 IF ORD(RdKey())=27 THEN Cancelar:=TRUE; PosVal:=FALSE; END;
              END;
        UNTIL PosVal OR Cancelar;
        (* Actualizamos la lista del mapa de muros si tenemos una posicion *)
        IF PosVal THEN
           IF MapaMuros <> NIL THEN
              (* Aado un elemento ms a la lista actual *)
              ALLOCATE(ptr^.sig, SIZE(TMapaMurosNodo));
              ptr := ptr^.sig;
           ELSE
              (* Inicializo la lista para el mapa de muros *)
              ALLOCATE(MapaMuros, SIZE(TMapaMurosNodo));
              ptr := MapaMuros;
           END;
           (* Dibuja el muro y guarda las coordenadas *)
           ptr^.dato.orienta := Vertical;
           ptr^.dato.pos := pos;
           DibujaMuro(LongMuro, AnchMuro, ptr^.dato);
           ptr^.sig := NIL; (* Cierro la lista actual por lo que pueda pasar *)
        END; (* Fin del SI *)
        cont := cont + 1;
    END; (* Fin del bucle MIENTRAS *)
    (* Genera los muros horizontales *)
    cont := 1;
    WHILE (cont <= (muros DIV 2)) AND NOT(Cancelar) DO
        (* Comienza el bucle que buscara la posicion idonea para el muro *)
        REPEAT
              (* Genera una nueva posicin aleatoria en pantalla *)
              pos := GeneraPos(1);
              (* Tomamos como premisa que la posicion es valida con lo cual *)
              (* PosVal es CIERTA; y si esta mal situada entonces PosVal    *)
              (* tomara el valor de FALSO.                                  *)
              PosVal := TRUE;
              (* Comprueba el muro esta dentro de la pantalla bien situado *)
              (* con respecto al muro de los bordes                        *)
              IF (pos.x >= ICampoX+separa) AND (pos.x+LongMuro <= FCampoX-separa) AND
                 (pos.y >= ICampoY+separa) AND (pos.y+AnchMuro <= FCampoY-separa) THEN
                    PosVal := TRUE;
              ELSE
                    PosVal := FALSE;
              END;
              (* Comprueba que no esta en el area de inicio de juego    *)
              (* Comprueba que esta separado de otros muros ya creados *)
              aux.x := (FCampoX DIV 2) - (Cuadro DIV 2);
              aux.y := (FCampoY DIV 2);
              aux1.y := pos.y;
              WHILE (aux1.y <= pos.y+AnchMuro) AND PosVal DO
                    aux1.x := pos.x;
                    WHILE (aux1.x <= pos.x+LongMuro) AND PosVal DO
                          (* Comprueba que no esta en el area de inicio de juego    *)
                          IF (aux1.x >= aux.x-(10*Cuadro)) AND (aux1.x <= aux.x+(ElemInic*Cuadro)+Cuadro) AND
                             (aux1.y >= aux.y-(2*Cuadro)) AND (aux1.y <= aux.y+(2*Cuadro)) THEN
                               PosVal := FALSE;
                          ELSE
                               PosVal := TRUE;
                          END;
                          (* Comprueba que esta separado de otros muros ya creados *)
                          ptr_aux := MapaMuros;
                          WHILE (ptr_aux <> NIL) AND PosVal DO
                              PosVal := NOT EstaEnMuro(LongMuro, AnchMuro, aux1, ptr_aux^.dato, separa);
                              ptr_aux := ptr_aux^.sig;
                          END; (* Fin del MIENTRAS *)
                          aux1.x := aux1.x + 1;
                    END; (* Fin del MIENTRAS *)
                    aux1.y := aux1.y + 1;
              END; (* Fin del MIENTRAS *)
              (* Controla la pulsacion de alguna tecla para no seguir *)
              IF KeyPressed() THEN
                 IF ORD(RdKey())=27 THEN Cancelar:=TRUE; PosVal:=FALSE; END;
              END;
        UNTIL PosVal OR Cancelar;
        (* Actualizo la lista del mapa de muros *)
        (* Aado un elemento ms a la lista actual *)
        IF PosVal THEN
           ALLOCATE(ptr^.sig, SIZE(TMapaMurosNodo));
           ptr := ptr^.sig;
           (* Dibuja el muro y guarda las coordenadas *)
           ptr^.dato.orienta := Horizontal;
           ptr^.dato.pos := pos;
           DibujaMuro(LongMuro, AnchMuro, ptr^.dato);
           ptr^.sig := NIL; (* Cierro la lista actual por lo que pueda pasar *)
        END; (* Fin del SI *)
        cont := cont + 1;
    END; (* Fin del bucle MIENTRAS *)
END GeneraMuros;

PROCEDURE DestruyeMapaMuros(VAR MapaMuros : TMapaMurosLista);
(* Libera la memoria ocupada por la lista del mapa de muros *)
VAR
  ptr : TMapaMurosLista;
BEGIN
    IF MapaMuros <> NIL THEN
       ptr := MapaMuros^.sig;
       DEALLOCATE(MapaMuros, SIZE(TMapaMurosLista));
       WHILE (ptr <> NIL) DO
           MapaMuros := ptr;
           ptr := MapaMuros^.sig;
           DEALLOCATE(MapaMuros, SIZE(TMapaMurosLista));
       END;
       MapaMuros := NIL;
    END;
END DestruyeMapaMuros;

(*--------------------------------------------------------------------------*)
(* ALGORITMOS PARA CREAR Y GESTIONAR LA SERPIENTE (inicio, colision, etc.)  *)
(*--------------------------------------------------------------------------*)
PROCEDURE CoordSerpiente(Cuadro:CARDINAL;punto : TCoord; serp: TSerpiente):BOOLEAN;
(* Procedimiento que evalua si el punto dado pertenece o no a la serpiente *)
(* CoordSerpiente = CIERTO; el punto si es de la serpiente                 *)
(* CoordSerpiente = FALSO; el punto no es de la serpiente                  *)
VAR
  ptr : TLista;
  cont : CARDINAL;
  Pertenece : BOOLEAN;
  coord : TCoord;
BEGIN
    (* Tomamos la premisa de que el punto no pertence a la serpiente *)
    Pertenece := FALSE;
    (* Inicializamos la variable para recorrer la lista *)
    (* Tenemos en cuenta que la lista ya esta inicializada por lo que *)
    (* seria imposible en este punto que serp.ini --> NIL            *)
    ptr := serp.ini;
    (* Comienza el bucle que recorre la lista *)
    WHILE (ptr <> NIL) AND NOT(Pertenece) DO
          (* Vemos si el punto dado esta o no en la serpiente *)
          coord.x := ptr^.dato.x;
          WHILE (coord.x <= ptr^.dato.x+Cuadro) AND NOT(Pertenece) DO
                coord.y := ptr^.dato.y;
                WHILE (coord.y <= ptr^.dato.y+Cuadro) AND NOT(Pertenece) DO
                      IF (punto = coord) THEN
                         Pertenece := TRUE;
                      END;
                      coord.y := coord.y + 1;
                END;
                coord.x := coord.x + 1;
          END;
          ptr := ptr^.sig;
    END;
    RETURN Pertenece;
END CoordSerpiente;

PROCEDURE Colision(LongMuro, AnchMuro, Cuadro:CARDINAL;pos:TCoord;
          MapaMuros:TMapaMurosLista; serpiente:TSerpiente): BOOLEAN;
(* Subalgoritmo que controla la colision con la cola o el muro de la   *)
(* pantalla: Colision = CIERTO, si la serpiente ha chocado.            *)
(*           Colision = FALSO, la serpiente no ha chocado.             *)
VAR
  Colision : BOOLEAN;
  temp : TCoord;
BEGIN
    (* Evaluamos cada una de las condiciones de choque, si se registra   *)
    (* un choque las siguientes condiciones de choque no seran evaluadas *)
    (* --> 'pos' es un punto que pertencece a la cabeza de la serpiente  *)
    IF (pos.x <= ICampoX) OR (pos.x+Cuadro+1 >= FCampoX) THEN
    (* Comprueba si choca con los bordes horizontales del campo de juego *)
       Colision := TRUE;
    ELSIF (pos.y <= ICampoY) OR (pos.y+Cuadro+1 >= FCampoY) THEN
    (* Comprueba si choca con los bordes verticales del campo de juego *)
       Colision := TRUE;
    ELSIF CabezaEnMapaMuros(LongMuro, AnchMuro, Cuadro, pos, MapaMuros) THEN
    (* Comprueba si choca con algun muro generado en el campo de juego *)
       Colision := TRUE;
    ELSE
       (* Comprueba si choca con su misma cola *)
       (* Primera esquina *)
       Colision := CoordSerpiente(Cuadro, pos, serpiente);
       IF NOT(Colision) THEN
       (* Segunda esquina *)
          temp.x := pos.x;
          temp.y := pos.y + Cuadro;
          Colision := CoordSerpiente(Cuadro, temp, serpiente);
       END;
       IF NOT(Colision) THEN
       (* Tercera esquina *)
          temp.x := pos.x + Cuadro;
          temp.y := pos.y;
          Colision := CoordSerpiente(Cuadro, temp, serpiente);
       END;
       IF NOT(Colision) THEN
       (* Cuarta esquina *)
          temp.x := pos.x + Cuadro;
          temp.y := pos.y + Cuadro;
          Colision := CoordSerpiente(Cuadro, temp, serpiente);
       END;
    END;
    RETURN Colision;
END Colision;

PROCEDURE SonidoColision();
(* Toca un sonido a traves del altavoz del ordenador, cada vez  *)
(* que se termina el juego chocando; se llama a este algoritmo. *)
VAR
  freq:LONGREAL;
BEGIN
  (* Toca la primera nota *)
  freq := 120.0 * Exp(LONGREAL(15) * (Log(2.0)/12.0));
  Speaker(CARDINAL(freq),100);
  (* Toca la segunda nota *)
  freq := 120.0 * Exp(LONGREAL(10) * (Log(2.0)/12.0));
  Speaker(CARDINAL(freq),100);
  freq := 120.0 * Exp(LONGREAL(5) * (Log(2.0)/12.0));
  Speaker(CARDINAL(freq),100);
  freq := 120.0 * Exp(LONGREAL(0) * (Log(2.0)/12.0));
  Speaker(CARDINAL(freq),100);
END SonidoColision;

PROCEDURE Insertar(Pos:TCoord; VAR Serpiente:TSerpiente);
(* Aade un elemento a la cabeza *)
BEGIN
    (* Insertamos un nuevo elemento a la cabeza *)
    IF (Serpiente.primero^.sig = NIL) THEN
       Serpiente.primero := Serpiente.ini;
    ELSE
       Serpiente.primero := Serpiente.primero^.sig;
    END;
    (* Actualizamos los nuevos datos *)
    Serpiente.primero^.dato := Pos;
END Insertar;

PROCEDURE Eliminar(VAR Serpiente:TSerpiente);
(* Extraer el ultimo elemento de la cola *)
BEGIN
    IF Serpiente.ultimo^.sig = NIL THEN
       Serpiente.ultimo := Serpiente.ini;
    ELSE
       Serpiente.ultimo := Serpiente.ultimo^.sig;
    END;
END Eliminar;

PROCEDURE LeeCursor(VAR Direccion : TDirecc): TTecla;
(* Algoritmo que lee una tecla de cursor y devulve TRUE y si no es *)
(* cursor devuleve FALSE.                                          *)
VAR
  tecla : TTecla;         (* Controla otras teclas leidas *)
  dir_ant : TDirecc;      (* Almacena la direccion del mov. anterior  *)
  cod1, cod2 : CHAR;      (* Almacena las teclas leidas *)
BEGIN
    (* Inicializa la variable de pulsacion de otras teclas *)
    tecla := Otras;
    (* Guardamos la direccion anterior *)
    dir_ant := Direccion;
    (* Lee el primer codigo de la tecla pulsada *)
    cod1 := RdKey();
    (* Si es una tecla extendida lee el segundo codigo, sino hay ERROR *)
    IF ORD(cod1) = 0 THEN
       (* Leemos el segundo codigo de una tecla extendida *)
       cod2 := RdKey();
       (* Actualizamos la direccion del cursor leido *)
       (* No dejamos que el la serpiente vaya hacia atras *)
       IF (ORD(cod2) = 75) AND (dir_ant <> Derecha) THEN
          Direccion := Izquierda; tecla := Cursores;
       ELSIF (ORD(cod2) = 77) AND (dir_ant <> Izquierda) THEN
          Direccion := Derecha; tecla := Cursores;
       ELSIF (ORD(cod2) = 72) AND (dir_ant <> Abajo) THEN
          Direccion := Arriba; tecla := Cursores;
       ELSIF (ORD(cod2) = 80) AND (dir_ant <> Arriba) THEN
          Direccion := Abajo; tecla := Cursores;
       ELSE
       (* Rectificamos si ha ocurrido lo mencionado anteriormente *)
          Direccion := dir_ant;
          tecla := Cursores;
       END;
    ELSIF ORD(cod1) = 27 THEN
       tecla := ESC;
    ELSE
       tecla := Otras;
    END;
    RETURN(tecla);
END LeeCursor;

PROCEDURE MoverPunto(Cuadro:CARDINAL;actual:TCoord; hacia:TDirecc): TCoord;
(* Devuelve la siguiente posicion en direccion "hacia". Controla que no  *)
(* se salga del campo de juego                                           *)
VAR
  sig : TCoord;
BEGIN
    (* Movemos la cabeza de la serpiente *)
    CASE hacia OF
           Izquierda:
                    IF actual.x <= ICampoX+Cuadro THEN
                       sig.x := ICampoX+1;
                    ELSE
                       sig.x := actual.x-Cuadro - 1;
                    END;
                    sig.y := actual.y
         | Derecha:
                    IF actual.x >= FCampoX-(2*Cuadro) THEN
                       sig.x := FCampoX-Cuadro;
                    ELSE
                       sig.x := actual.x+Cuadro+1;
                    END;
                    sig.y := actual.y
         | Arriba:
                    IF actual.y <= ICampoY+Cuadro THEN
                       sig.y := ICampoY;
                    ELSE
                       sig.y := actual.y-Cuadro - 1;
                    END;
                    sig.x := actual.x
         | Abajo:
                    IF actual.y >= FCampoY-(2*Cuadro) THEN
                       sig.y := FCampoY-Cuadro;
                    ELSE
                       sig.y := actual.y+Cuadro + 1;
                    END;
                    sig.x := actual.x
    END;
    RETURN sig;
END MoverPunto;

PROCEDURE Inicializar(Cuadro:CARDINAL;elem:CARDINAL; VAR serp:TSerpiente; VAR Direccion:TDirecc);
(* Inicializa y coloca las coordenadas correctamente, la lista enlazada     *)
(* por punteros para el cuerpo de la serpiente con los elementos indicados  *)
(* en la variable 'elem'.                                                   *)
VAR
  pos : TCoord;                 (* Variable de posicin auxualiar           *)
  ptr : TLista;                 (* Puntero auxiliar de operaciones          *)
  cont : CARDINAL;              (* Contador auxiliar para el bucle FOR      *)
BEGIN
    (* Controlamos el valor de 'elem'; hay que tenerlo muy en cuenta *)
    IF (elem <= 0) THEN
    (* No podemos inicializar una serpiente con cero elementos; minimo 1 *)
       elem := 1;
    ELSIF elem > (((FCampoX DIV 2) DIV Cuadro)-3) THEN
    (* Seria una serpiente inical muy grande; no cabe en el campo de juego *)
       elem := ((FCampoX DIV 2) DIV Cuadro)-3; (* Deja un huequeco de 3 elem *)
    END;
    (* Nos colocamos en el centro del campo de juego; la colocacin depende *)
    (* en parte del tamao del cuadro de la serpiente. La colocacion es     *)
    (* horizontal.                                                          *)
    pos.x := (FCampoX DIV 2) - (3*(Cuadro DIV 2)) + (elem*Cuadro);
    pos.y := (FCampoY DIV 2);
    (* Inicializamos la lista de la serpiente con el primer elemento *)
    ALLOCATE(serp.ini, SIZE(TNodo));
    serp.ini^.dato := pos;
    ptr := serp.ini;
    (* Inicializamos el bucle de creado de la lista; el resto de los elementos *)
    FOR cont := 1 TO elem-1 DO
        ALLOCATE(ptr^.sig, SIZE(TNodo));
        ptr := ptr^.sig;
        ptr^.dato.x := pos.x - (cont*Cuadro);
        ptr^.dato.y := pos.y;
    END;
    ptr^.sig := NIL; (* Cerramos el ultimo nodo de la serpiente *)
    (* Inicializamos los punteros de la cabeza y el culito (podr tener?) *)
    serp.primero := ptr;
    serp.ultimo := serp.ini;
    (* Dibujamos la serpiente por primera vez *)
    ptr := serp.ultimo;
    pos := ptr^.dato;
    Cube(TRUE, pos.x, pos.y, pos.x+Cuadro, pos.y+Cuadro, 0, ColorSerp, TRUE);
    WHILE (ptr^.sig <> NIL) DO
          ptr := ptr^.sig;
          pos := ptr^.dato;
          Cube(TRUE,pos.x, pos.y, pos.x+Cuadro, pos.y+Cuadro, 0, ColorSerp, TRUE);
    END;
    (* Establece una direccion inicial; es la direccion por defecto del       *)
    (* algoritmo de iniciacin de la serpiente; no modificar esto a menos     *)
    (* que se tenga en cuenta los cambios que hay que hacer en este algoritmo *)
    Direccion := Izquierda;
END Inicializar;

PROCEDURE MeterElem(pos:TCoord; VAR serp : TSerpiente);
(* Aade un elemento en medio de la lista; actualiza el primer elemento  *)
(* actual.                                                               *)
VAR
  ptr : TLista;                 (* Puntero auxiliar de operaciones *)
BEGIN
    ALLOCATE(ptr, SIZE(TNodo));
    ptr^.dato := pos;
    ptr^.sig := serp.primero^.sig;
    IF serp.ini^.sig <> NIL THEN
    (* Hay mas de un elemento *)
       serp.primero^.sig := ptr;
    ELSE
    (* La serpiente tiene solo un elemento *)
       serp.ini^.sig := ptr;
       serp.primero := ptr;
    END;
END MeterElem;

PROCEDURE DestruyeSerpiente (VAR serp : TSerpiente);
(* Libera la memoria ocupada por la lista de la serpiente *)
VAR
  ptr : TLista;
BEGIN
    ptr := serp.ini^.sig;
    DEALLOCATE(serp.ini, SIZE(TLista));
    WHILE (ptr <> NIL) DO
        serp.ini := ptr;
        ptr := serp.ini^.sig;
        DEALLOCATE(serp.ini, SIZE(TLista));
    END;
    serp.ini := NIL;
    serp.primero := NIL;
    serp.ultimo := NIL;
END DestruyeSerpiente;

(*--------------------------------------------------------------------------*)
(* ALGORITMOS PARA CREAR Y GESTIONAR LA COMIDA.                             *)
(*--------------------------------------------------------------------------*)
PROCEDURE HecharComida(LongMuro, AnchMuro, Cuadro, Radio:CARDINAL;
               serpiente:TSerpiente; MapaMuros : TMapaMurosLista) : TCoord;
(* Busca el sitio donde se puede poner la comida para la serpiente  *)
(* y la pone.                                                       *)
VAR
  comida : TCoord;
  temp : TCoord;
  CoordError : BOOLEAN;
  ptr_aux : TMapaMurosLista;
BEGIN
    RANDOMIZE;
    REPEAT
       (* Calcula una poicin valida aleatoria *)
       comida := GeneraPos(Radio+(Cuadro DIV 2));
       (* Comprobamos que no estemos encima de la serpiente *)
       (* Primera esquina *)
       temp.x := comida.x - Radio;
       temp.y := comida.y - Radio;
       CoordError := CoordSerpiente(Cuadro, temp, serpiente);
       IF NOT(CoordError) THEN
       (* Segunda esquina *)
          temp.x := comida.x - Radio;
          temp.y := comida.y + Radio;
          CoordError := CoordSerpiente(Cuadro, temp, serpiente);
       END;
       IF NOT(CoordError) THEN
       (* Tercera esquina *)
          temp.x := comida.x + Radio;
          temp.y := comida.y - Radio;
          CoordError := CoordSerpiente(Cuadro, temp, serpiente);
       END;
       IF NOT(CoordError) THEN
       (* Cuarta esquina *)
          temp.x := comida.x + Radio;
          temp.y := comida.y + Radio;
          CoordError := CoordSerpiente(Cuadro, temp, serpiente);
       END;
       (* Comprobamos que no estamos encima de ningun muro *)
       ptr_aux := MapaMuros;
       WHILE (ptr_aux <> NIL) AND NOT(CoordError) DO
             CoordError := EstaEnMuro(LongMuro, AnchMuro, comida, ptr_aux^.dato, 2*Radio);
             ptr_aux := ptr_aux^.sig;
       END; (* Fin del MIENTRAS *)
    UNTIL NOT(CoordError);
    (* Dibujamos en pantalla la comida (un huevo) *)
    Disc(comida.x, comida.y, Radio, ColorComida);
    RETURN(comida);
END HecharComida;

PROCEDURE SonidoComer();
(* Toca un sonido a traves del altavoz del ordenador, cada vez *)
(* que se come una ficha; se llama a este algoritmo.           *)
VAR
  freq:LONGREAL;
BEGIN
  (* Toca la primera nota *)
  freq := 130.0 * Exp(LONGREAL(30) * (Log(2.0)/12.0));
  Speaker(CARDINAL(freq),30);
  (* Toca la segunda nota *)
  freq := 130.0 * Exp(LONGREAL(25) * (Log(2.0)/12.0));
  Speaker(CARDINAL(freq),20);
END SonidoComer;

PROCEDURE CabezaEnComida(Cuadro, Radio:CARDINAL; pos, comida: TCoord):BOOLEAN;
(* Si CuadroEnComida vale CIERTO, entonces el cuadro generado          *)
(* a partir de la posicion dada tiene algun pixel en comun con el      *)
(* cuadro en el que se genera la comida.                               *)
VAR
  Come : BOOLEAN;
  x, y : CARDINAL;
BEGIN
    (* Tomamos la premisa de que no se come la comida *)
    Come := FALSE;
    (* Generamos el mapa de pixels de la cabeza de la serpiente *)
    x := pos.x;
    WHILE (x <= pos.x+Cuadro) AND NOT(Come) DO
        y := pos.y;
        WHILE (y <= pos.y+Cuadro) AND NOT(Come) DO
            IF (comida.x-Radio = x) AND (comida.y-Radio = y) THEN
                  Come := TRUE;
            ELSIF (comida.x-Radio = x) AND (comida.y+Radio = y) THEN
                  Come := TRUE;
            ELSIF (comida.x+Radio = x) AND (comida.y-Radio = y) THEN
                  Come := TRUE;
            ELSIF (comida.x+Radio = x) AND (comida.y+Radio = y) THEN
                  Come := TRUE;
            END;
            y := y + 1;
        END;
        x := x + 1;
    END;
    RETURN(Come);
END CabezaEnComida;

PROCEDURE DibujaCabeza(Cuadro:CARDINAL;pos : TCoord; dir : TDirecc);
(* Dibuja la cabeza de la serpiente con unos ojos *)
BEGIN
    CASE dir OF
         Izquierda:
              (* Limpia *)
              Cube(TRUE, pos.x, pos.y, pos.x+(2*Cuadro), pos.y+Cuadro, 0, 0, TRUE);
              Cube(TRUE, pos.x+Cuadro, pos.y, pos.x+(2*Cuadro)+1, pos.y+Cuadro, 0, ColorSerp, TRUE);
              (* Dibuja la cabeza *)
              Arc(pos.x+Cuadro, pos.y+(Cuadro DIV 2), Cuadro, Cuadro DIV 2, pos.x+Cuadro, pos.y, pos.x+Cuadro, pos.y+Cuadro, ColorSerp);
              FloodFill(pos.x+(Cuadro DIV 2), pos.y+(Cuadro DIV 2), ColorSerp, ColorSerp);
       | Derecha:
              (* Limpia *)
              Cube(TRUE, pos.x-Cuadro, pos.y, pos.x+Cuadro, pos.y+Cuadro, 0, 0, TRUE);
              Cube(TRUE, pos.x-Cuadro-1, pos.y, pos.x, pos.y+Cuadro, 0, ColorSerp, TRUE);
              (* Dibuja la cabeza *)
              Arc(pos.x, pos.y+(Cuadro DIV 2), Cuadro, Cuadro DIV 2, pos.x, pos.y+Cuadro, pos.x, pos.y, ColorSerp);
              FloodFill(pos.x+(Cuadro DIV 2), pos.y+(Cuadro DIV 2), ColorSerp, ColorSerp);
       | Arriba:
              (* Limpia *)
              Cube(TRUE, pos.x, pos.y, pos.x+Cuadro, pos.y+(2*Cuadro), 0, 0, TRUE);
              Cube(TRUE, pos.x, pos.y+Cuadro, pos.x+Cuadro, pos.y+(2*Cuadro)+1, 0, ColorSerp, TRUE);
              (* Dibuja la cabeza *)
              Arc(pos.x+(Cuadro DIV 2), pos.y+Cuadro, Cuadro DIV 2, Cuadro, pos.x+Cuadro, pos.y+Cuadro, pos.x, pos.y+Cuadro, ColorSerp);
              FloodFill(pos.x+(Cuadro DIV 2), pos.y+(Cuadro DIV 2), ColorSerp, ColorSerp);
       | Abajo:
              (* Limpia *)
              Cube(TRUE, pos.x, pos.y-Cuadro, pos.x+Cuadro, pos.y+Cuadro, 0, 0, TRUE);
              Cube(TRUE, pos.x, pos.y-Cuadro-1, pos.x+Cuadro, pos.y, 0, ColorSerp, TRUE);
              (* Dibuja la cabeza *)
              Arc(pos.x+(Cuadro DIV 2), pos.y, Cuadro DIV 2, Cuadro, pos.x, pos.y, pos.x+Cuadro, pos.y, ColorSerp);
              FloodFill(pos.x+(Cuadro DIV 2), pos.y+(Cuadro DIV 2), ColorSerp, ColorSerp);
    ELSE
       (* Si no, dibuja un cuadro normal *)
       Cube(TRUE,pos.x, pos.y, pos.x+Cuadro, pos.y+Cuadro, 0, ColorSerp, TRUE);
    END;
END DibujaCabeza;

(*--------------------------------------------------------------------------*)
(* ALGORITMO PARA CONFIGURAR TODOS LOS PARAMETROS DEL JUEGO.                *)
(*--------------------------------------------------------------------------*)
PROCEDURE ConfigurarJuego(param : TParametros; VAR config : TConfiguracion);
(* Calcula toda la configuracion de la partida, en base a los parametros  *)
(* configurables desde el menu de opciones.                               *)
BEGIN
    CASE param.Tamano OF
           Enana:
              config.Cuadro := 4;
              config.Radio := 2;
              config.LongMuro := 64;
              config.AnchMuro := 8;
              CASE param.IniCola OF
                  Corta:
                     config.IniSerp := 8;
                | Media:
                     config.IniSerp := 16;
                | Larga:
                     config.IniSerp := 32;
              END; (* Fin del CASO de IniCola. Tamao: Enana *)
              CASE param.NumMuros OF
                  Ninguno:
                     config.NumMuros := 0;
                | Pocos:
                     config.NumMuros := 10;
                | Algunos:
                     config.NumMuros := 18;
                | Muchos:
                     config.NumMuros := 50;
              END; (* Fin del CASO de NumMuros. Tamao: Enana *)

              CASE param.Velocidad OF
                  Lenta:
                     config.Retraso := 130;
                     config.Puntuacion := 5;
                | Normal:
                     config.Retraso := 95;
                     config.Puntuacion := 10;
                | Rapida:
                     config.Retraso := 50;
                     config.Puntuacion := 15;
              END; (* Fin del CASO de Velocidad. Tamao: Enana *)
         | Regular:
              config.Cuadro := 6;
              config.Radio := 3;
              config.LongMuro := 84;
              config.AnchMuro := 12;
              CASE param.IniCola OF
                  Corta:
                     config.IniSerp := 6;
                | Media:
                     config.IniSerp := 14;
                | Larga:
                     config.IniSerp := 22;
              END; (* Fin del CASO de IniCola. Tamao: Regular *)
              CASE param.NumMuros OF
                  Ninguno:
                     config.NumMuros := 0;
                | Pocos:
                     config.NumMuros := 8;
                | Algunos:
                     config.NumMuros := 14;
                | Muchos:
                     config.NumMuros := 26;
              END; (* Fin del CASO de NumMuros. Tamao: Regular *)
              CASE param.Velocidad OF
                  Lenta:
                     config.Retraso := 160;
                     config.Puntuacion := 5;
                | Normal:
                     config.Retraso := 110;
                     config.Puntuacion := 10;
                | Rapida:
                     config.Retraso := 60;
                     config.Puntuacion := 15;
              END; (* Fin del CASO de Velocidad. Tamao: Regular *)
         | Grande:
              config.Cuadro := 10;
              config.Radio := 5;
              config.LongMuro := 90;
              config.AnchMuro := 18;
              CASE param.IniCola OF
                  Corta:
                     config.IniSerp := 4;
                | Media:
                     config.IniSerp := 8;
                | Larga:
                     config.IniSerp := 12;
              END; (* Fin del CASO de IniCola. Tamao: Grande *)
              CASE param.Velocidad OF
                  Lenta:
                     config.Retraso := 160;
                     config.Puntuacion := 5;
                | Normal:
                     config.Retraso := 110;
                     config.Puntuacion := 10;
                | Rapida:
                     config.Retraso := 60;
                     config.Puntuacion := 15;
              END; (* Fin del CASO de Velocidad. Tamao: Grande *)
              CASE param.NumMuros OF
                  Ninguno:
                     config.NumMuros := 0;
                | Pocos:
                     config.NumMuros := 4;
                | Algunos:
                     config.NumMuros := 8;
                | Muchos:
                     config.NumMuros := 16;
              END; (* Fin del CASO de NumMuros. Tamao: Grande *)
         | Bestial:
              config.Cuadro := 14;
              config.Radio :=  6;
              config.LongMuro := 104;
              config.AnchMuro := 22;
              CASE param.IniCola OF
                  Corta:
                     config.IniSerp := 3;
                | Media:
                     config.IniSerp := 6;
                | Larga:
                     config.IniSerp := 9;
              END; (* Fin del CASO de IniCola. Tamao: Bestial *)
              CASE param.NumMuros OF
                  Ninguno:
                     config.NumMuros := 0;
                | Pocos:
                     config.NumMuros := 2;
                | Algunos:
                     config.NumMuros := 4;
                | Muchos:
                     config.NumMuros := 10;
              END; (* Fin del CASO de NumMuros. Tamao: Bestial *)
              CASE param.Velocidad OF
                  Lenta:
                     config.Retraso := 170;
                     config.Puntuacion := 5;
                | Normal:
                     config.Retraso := 110;
                     config.Puntuacion := 10;
                | Rapida:
                     config.Retraso := 70;
                     config.Puntuacion := 15;
              END; (* Fin del CASO de Velocidad. Tamao: Bestial *)
    END; (* Fin del CASO de Tamao *)
    (* Terminamos de calcular la puntuacion *)
    config.Puntuacion := LONGCARD(config.Cuadro * 2) + config.Puntuacion;
    config.Puntuacion := LONGCARD(config.IniSerp) + config.Puntuacion;
    config.Puntuacion := LONGCARD(config.NumMuros) + config.Puntuacion;
END ConfigurarJuego;

(*--------------------------------------------------------------------------*)
(* ALGORITMO QUE GESTIONA LA PARTIDA ACTUAL.                                *)
(*--------------------------------------------------------------------------*)
PROCEDURE Juego(Param : TParametros; VAR puntos:LONGCARD);
(* Comienza el algoritmo de juego *)
VAR
  pos : TCoord;                 (* Posiciones actuales de la serpiente      *)
  tecla : TTecla;               (* Controla la pulsacion de otras teclas    *)
  Direccion : TDirecc;          (* Direccion de movimiento de la serpiente  *)
  serpiente : TSerpiente;       (* La serpiente del juego                   *)
  Choque: BOOLEAN;              (* Indica cuando hemos chocado              *)
  ModoValido : BOOLEAN;         (* Para ver si modos de video son validos   *)
  comida : TCoord;              (* Posicion de la comida                    *)
  HayComida : BOOLEAN;          (* Indica si hay o no comida                *)
  MapaMuros : TMapaMurosLista;  (* Mapa de muros del juego                  *)
  MsgPpal: BOOLEAN;             (* Indica si esta pintado el msg principal  *)
  Config : TConfiguracion;      (* Registro que contiene la configuracion   *)
  pausa : CHAR;                 (* Variable para hacer pausa con RdKey      *)
BEGIN
    (* Inicia VideoMode *)
    ModoValido := SetVideoMode(_VRES16COLOR);
    IF ModoValido THEN
       (* Configuro la partida a partir de los parametros de juego *)
       ConfigurarJuego(Param, Config);
       (* Limpiamos la pantalla *)
       ClearScreen(_GCLEARSCREEN);
       (* Inicializamos puntuacion *)
       puntos := 0;
       (* Dibujamos un borde en la pantalla *)
       DibujaMuroBordes;
       DibujaMarcador(puntos);
       (* Generamos muros de forma aleatorio en el campo de juego *)
       MsgPpal := MsgErrorGrafico(2);
       GeneraMuros(Config.LongMuro, Config.AnchMuro, Config.Cuadro, Config.NumMuros, 4*Config.Cuadro, Config.IniSerp, MapaMuros);
       (* Espera pulsar una tecla para empezar a jugar *)
       MsgPpal := MsgErrorGrafico(5);
       pausa := RdKey();
       MsgPpal := MsgErrorGrafico(1);
       (* Inicializamos la lista de la serpiente y le aadimos a dems 5   *)
       (* elementos ms, para que sea una serpiente al empezar a jugar. Se *)
       (* establece una direccion inicial; Izquierda.                      *)
       Inicializar(Config.Cuadro, Config.IniSerp, serpiente, Direccion);
       (* Inicializamos variables de tecla y Choque para el bucle de juego *)
       tecla := Otras;
       HayComida := FALSE;
       Choque := FALSE;
       WHILE (tecla <> ESC) AND NOT(Choque) DO
       (* El bucle termina cuanso se pulsa la tecla 'escape' o cuando  *)
       (* se registra una colision; con el algoritmo de choque         *)
             (* Tiempo de retardo *)
             Delay(Config.Retraso);
             (* Borra el ultimo elemento de la cola de la serpiente; en pantalla *)
             pos := serpiente.ultimo^.dato;
             Cube(TRUE,pos.x, pos.y, pos.x+Config.Cuadro, pos.y+Config.Cuadro, 0, ColorFondo, TRUE);
             (* Borra el ultimo elemento de la cola de la serpiente; en el array *)
             Eliminar(serpiente);
             (* Actualiza a la siguiente posicion *)
             pos := MoverPunto(Config.Cuadro, serpiente.primero^.dato, Direccion);
             (* Evaluamos un posible choque, antes de procesar el nuevo punto *)
             Choque := Colision(Config.LongMuro, Config.AnchMuro, Config.Cuadro, pos, MapaMuros, serpiente);
             (* Dibuja la comida de la serpiente si no hay *)
             IF NOT(HayComida) THEN
                comida := HecharComida(Config.LongMuro, Config.AnchMuro, Config.Cuadro, Config.Radio, serpiente, MapaMuros);
                HayComida := TRUE;
             ELSIF CabezaEnComida(Config.Cuadro, Config.Radio, pos, comida) THEN
             (* Si la serpiente se ha comido la comida *)
               (* Borra la comida anterior *)
               Disc(comida.x, comida.y, Config.Radio, 0);
               (* Aadimos un nuevo elemento a la lista *)
               MeterElem(pos, serpiente);
               (* Aade la cabeza en la nueva posicion *)
               Insertar(pos, serpiente);
               DibujaCabeza(Config.Cuadro, pos, Direccion);
               (* Toca un sonido *)
               SonidoComer();
               (* Actualizamos el marcador *)
               puntos := puntos + Config.Puntuacion;
               ActualizaMarcador(puntos);
               (* Actualiza a la siguiente posicion *)
               pos := MoverPunto(Config.Cuadro, serpiente.primero^.dato, Direccion);
               (* Evaluamos un posible choque, antes de procesar el nuevo punto *)
               Choque := Colision(Config.LongMuro, Config.AnchMuro, Config.Cuadro, pos, MapaMuros, serpiente);
               (* Indicamos que falta comida *)
               HayComida := FALSE;
             END;
             (* Aade la cabeza en la nueva posicion (si no hay choque) *)
             Insertar(pos, serpiente);
             DibujaCabeza(Config.Cuadro, pos, Direccion);
             (* Si se ha pulsado una tecla se evalua *)
             IF KeyPressed() THEN
                tecla := LeeCursor(Direccion);
                IF tecla = Otras THEN
                   MsgPpal := MsgErrorGrafico(3);
                ELSIF tecla = ESC THEN
                   MsgPpal := MsgErrorGrafico(4);
                ELSE
                   IF NOT(MsgPpal) THEN MsgPpal := MsgErrorGrafico(1); END;
                END;
             END;
       END; (* Fin del MIENTRAS *)
       (* Nos toca una sonido si hemos chocado *)
       IF Choque THEN
          SonidoColision();
       END;
       (* Destruye la lista de la serpiente *)
       DestruyeSerpiente(serpiente);
       (* Destruye el mapa de muros *)
       DestruyeMapaMuros(MapaMuros);
       (* Restauramos el modo de video de texto (80x25) *)
       ModoValido := SetVideoMode(_TEXTC80);
    ELSE
       (* Mensaje para el manejador de errores; modo actual *)
       (* ERROR: El modo de video: 640x480 (16 colores) no esta soportado.*)
       MsgErrorTexto(4);
    END;
END Juego;

(*-----------------------------------------------------------------------*)
(* ALGORITMO QUE GESTIONA EL PROGRAMA                                    *)
(*-----------------------------------------------------------------------*)
(* Comienza el programa principal *)
VAR
  Op : CHAR;                    (* Opcion que se seleccione *)
  param : TParametros;          (* Guarda los parametros de juego *)
  rec : TRecords;               (* Guarda la lista de records *)
  jugada : TRecord;             (* Records de la ultima jugada *)
  nombre : TCadena;             (* Guarda el nombre del jugador *)
  puntos : LONGCARD;            (* Guarda la puntuacion de la jugada *)
  (* Para la ventana de creditos *)
  TipoVentCred : WinType;
  DefVentCred : WinDef;
BEGIN
    (* Limpiamos la pantalla *)
    TextColor(Black); Clear;
    (* Desactivamos el wrapping *)
    SetWrap(FALSE);
    (* Desactivamos el cursor *)
    CursorOff;
    (* Dibujamos el decorado de la pantalla de juego por primera vez *)
    DibujaFondo;
    DibujaTitulo;
    (* Leemos los records del archivo de records *)
    LeeRecords(rec);
    (* Inicializamos los parametros de juego *)
    param.Tamano := Regular;
    param.NumMuros := Algunos;
    param.Velocidad := Normal;
    param.IniCola := Media;
    (* Inicializamos el bucle de menu *)
    REPEAT
         (* Abrimos la ventana de creditos *)
         AbreCreditos(TipoVentCred, DefVentCred);
         (* Esperamos una opcion valida *)
         Op:=Menu1();
         (* Cerramos la ventana de creditos *)
         Window.Close(TipoVentCred);
         CASE Op OF
              '1': (* Va a empezar la partida *)
                   (* Inicializa entorno *)
                   Clear;
                   (* Aqui va el algoritmo de Juego en Modo Grafico *)
                   Juego(param, puntos);
                   (* Vuelve al entorno despues de jugar *)
                   DibujaFondo; DibujaTitulo;
                   (* Saca un mensaje de fin de juego *)
                   FinDeJuego(puntos);
                   (* Pide nombre si el jugador esta en la lista de records *)
                   IF puntos > rec[10].Puntos THEN
                      nombre := NuevoRecord(puntos);
                      InsertarRecord(puntos, nombre, rec);
                   END;
            | '2': (* Saca la ventana de records *)
                   MostrarRecords(rec);
            | '3': (* Muestra los parametros de juego con opcion a cambiarlos *)
                   MostrarParametros(param);
            | '4': (* Saca las instrucciones *)
                   Instrucciones;
         END;
    UNTIL (Op = "5");
    (* Restauramos el modo texto de MS-DOS (como el command.com) *)
    TextColor(LightGray); TextBackground(Black);
    CursorOn; SetWrap(TRUE); Clear();
    (* Grabamos los records; si hay algun error de escritura, nos *)
    (* saldra los mensajes del sistema operativo.                 *)
    GuardaRecords(rec);
END SERP2.
