/* Wordle Clone for DOS RealMode using those funny cryptic Interrupts  
 - built with watcom in C89, small memory model
 - APRIL HACKATON with Josef, Markus and Thorsten.
 - mail: marcedo@habmalnefrage.de (28.04.2025)
Licens: Free! Thank you for making FreeDos 
- WORDLE /? for help 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <dos.h>

#define WORD_LENGTH 5
#define MAX_GUESSES 6
#define MAX_WORDS 800 /* 64k (segments) should be enough for everyone !!! Hmmm. */

/* Not really a "rainbow Table" - but close :)*/
enum {ATTR_WHITE  = 0x0F, ATTR_GRAY = 0x07, ATTR_YELLOW = 0x0E, ATTR_GREEN = 0x0A };

static const char *kb_rows[3] = { "QWERTZUIOP", "ASDFGHJKL", "YXCVBNM" };

static char words[MAX_WORDS][WORD_LENGTH+1];
static int word_count;

char grid[MAX_GUESSES][WORD_LENGTH];
int grid_attr[MAX_GUESSES][WORD_LENGTH];
int key_attr[26];

/* thankfully - We got a lot of Help with this stuff. */
static unsigned char getch_bios()
{
    union REGS regs;
    regs.h.ah = 0x00;
    int86(0x16, &regs, &regs);
    return (unsigned char)regs.h.al;
}

static void putch_attr(ch, attr, x, y)
char ch;
unsigned char attr;
int x, y;
{
    union REGS regs;
    regs.h.ah = 0x02;
    regs.h.bh = 0x00;
    regs.h.dh = (unsigned char)y;
    regs.h.dl = (unsigned char)x;
    int86(0x10, &regs, &regs);

    regs.h.ah = 0x09;
    regs.h.al = (unsigned char)ch;
    regs.h.bh = 0x00;
    regs.h.bl = attr;
    regs.x.cx = 1;
    int86(0x10, &regs, &regs);
}

/* we initially used a loop but that confused Screen readers
*/
static void clear_screen()
{
    union REGS regs;
    regs.h.ah = 0x06; // Scroll up
    regs.h.al = 0;    // Clear entire window
    regs.h.bh = ATTR_WHITE;
    regs.h.ch = 0;    // upper left corner row
    regs.h.cl = 0;    // upper left corner col
    regs.h.dh = 24;   // lower right corner row
    regs.h.dl = 79;   // lower right corner col
    int86(0x10, &regs, &regs);
}

static void gotoxy(x, y)
int x, y;
{
    union REGS regs;
    regs.h.ah = 0x02;
    regs.h.bh = 0x00;
    regs.h.dh = (unsigned char)y;
    regs.h.dl = (unsigned char)x;
    int86(0x10, &regs, &regs);
}

static void set_40x25_text_mode()
{
    union REGS regs;
    regs.h.ah = 0x00;
    regs.h.al = 0x01;
    int86(0x10, &regs, &regs);
}

static void set_80x25_text_mode()
{
    union REGS regs;
    regs.h.ah = 0x00;
    regs.h.al = 0x03;
    int86(0x10, &regs, &regs);
}

void print_help() /* doin that one was fun. Everyone in the house took a line. */
{
    set_80x25_text_mode();
    printf("Wordle DOS Version - Optionen:\n");
    printf("/40            - 40x25 Textmodus (groesser)\n");
    printf("/w <datei>     - andere Wortliste verwenden\n");
    printf("/hard          - Hard Mode aktivieren (schwieriger)\n");
    printf("/h             - diese Hilfe anzeigen\n");
}

/*
 we are proud to announce We even have fckn Error handling.
 so no one even EVER Dares to put more than 8192 byte in our beloved little buffer OKAY.
*/
void load_words(fname)
const char *fname;
{
    FILE *f;
    char *p;
    static char buf[8192];
    size_t bytesRead;

    f = fopen(fname, "r");
    if (!f) {
        set_80x25_text_mode();
        fprintf(stderr, "Fehler: Wortliste '%s' konnte nicht geoeffnet werden.\n", fname);
        exit(1);
    }

    word_count = 0;
    bytesRead = fread(buf, 1, sizeof(buf)-1, f);
    fclose(f);

    if (bytesRead == 0) {
        set_80x25_text_mode();
        fprintf(stderr, "Fehler: Wortliste '%s' ist leer oder konnte nicht gelesen werden.\n", fname);
        exit(1);
    }

    buf[bytesRead] = '\0';
    p = buf;

    while (*p && word_count < MAX_WORDS) {
        while (*p && !isalpha((unsigned char)*p)) p++;
        if (!*p) break;

        {
            char word[WORD_LENGTH+1];
            int j;
            for (j = 0; j < WORD_LENGTH && p[j]; j++) {
                word[j] = toupper((unsigned char)p[j]);
                if (!isalpha((unsigned char)word[j])) break;
            }
            if (j == WORD_LENGTH) {
                word[WORD_LENGTH] = '\0';
                strcpy(words[word_count++], word);
            }
        }
        while (*p && *p != ',') p++;
        if (*p == ',') p++;
    }

    if (!word_count) {
        set_80x25_text_mode();
        fprintf(stderr, "Fehler: Keine gueltigen Woerter in '%s' gefunden.\n", fname);
        exit(1);
    }
}

/*
 Draw the grid!
*/
static void draw_grid(int cur_row, int cur_col)
{
    int r, c;
    char ch;
    unsigned char attr;

    for (r = 0; r < MAX_GUESSES; r++) {
        for (c = 0; c < WORD_LENGTH; c++) {
            // Zeichne entweder den Buchstaben oder '_'
            ch   = grid[r][c] ? grid[r][c] : '_';
            // wahle Attribut (Farbe) oder Weis als Default
            attr = grid_attr[r][c] ? grid_attr[r][c] : ATTR_WHITE;
            // putch_attr sorgt fur das Setzen von Cursor ]Position,
            // Zeichenausgabe und Farbattribute
            putch_attr(ch, attr, c * 2, r);
        }
    }

    // Setze den Cursor an die aktuelle Eingabeposition
    gotoxy(cur_col * 2, cur_row);
}

void draw_keyboard()
{
    int i, j, len, offset_x;
    int base_y;

    base_y = MAX_GUESSES + 2;
    for (i = 0; i < 3; i++) {
        len = strlen(kb_rows[i]);
        offset_x = (WORD_LENGTH*2 - len) / 2;
        for (j = 0; j < len; j++) {
            char ch;
            int idx;
            int attr;
            ch = kb_rows[i][j];
            idx = ch - 'A';
            attr = key_attr[idx] ? key_attr[idx] : ATTR_WHITE;
            putch_attr(ch, attr, offset_x + j, base_y + i);
        }
    }
}

/*
 This one was coded by a neighbour.
 He did code for selfmade Pizza!
*/
int check_guess(row, secret)
int row;
const char *secret;
{
    int used[WORD_LENGTH];
    int i, j, found;
    char g;

    for (i = 0; i < WORD_LENGTH; i++) {
        used[i] = 0;
    }

    for (i = 0; i < WORD_LENGTH; i++) {
        g = grid[row][i];
        if (g == secret[i]) {
            grid_attr[row][i] = ATTR_GREEN;
            key_attr[g - 'A'] = ATTR_GREEN;
            used[i] = 1;
        }
    }

    for (i = 0; i < WORD_LENGTH; i++) {
        if (grid_attr[row][i] == ATTR_GREEN) continue;
        g = grid[row][i];
        found = 0;
        for (j = 0; j < WORD_LENGTH; j++) {
            if (!used[j] && g == secret[j]) {
                found = 1;
                used[j] = 1;
                break;
            }
        }
        if (found) {
            grid_attr[row][i] = ATTR_YELLOW;
            if (key_attr[g - 'A'] != ATTR_GREEN) {
                key_attr[g - 'A'] = ATTR_YELLOW;
            }
        } else {
            grid_attr[row][i] = ATTR_GRAY;
            if (!key_attr[g - 'A']) {
                key_attr[g - 'A'] = ATTR_GRAY;
            }
        }
    }

    for (i = 0; i < WORD_LENGTH; i++) {
        if (grid_attr[row][i] != ATTR_GREEN) {
            return 0;
        }
    }
    return 1;
}

void print_char_status(char ch, const char *secret, int pos) {
    gotoxy(0, MAX_GUESSES + 10); // Move to the last line (adjust as needed)
    clear_screen();             // Clear the screen
    draw_grid(0, 0);            // Redraw the grid
    draw_keyboard();            // Redraw the keyboard
    gotoxy(0, MAX_GUESSES + 10); // Move back to the status line

    if (strchr(secret, ch) == NULL) {
        printf("Char %c not in secret\n", ch);
    } else if (secret[pos] == ch) {
        printf("Char %c correctly placed\n", ch);
    } else {
        printf("Char %c incorrectly placed\n", ch);
    }
}

/*
 other sources we seen used SIGINT handlers
 but we .... decided not to. Ă¤hm-  
*/
int main(argc, argv)
int argc;
char *argv[];
{
    const char *words_file;
    int use_40_mode;
    int hard_mode;
    int i;
    const char *secret;
    int row, col, won;

    words_file = "words.txt";
    use_40_mode = 0;
    hard_mode = 0;

    for (i = 1; i < argc; i++) {
        if (strcmp(argv[i], "/40") == 0) {
            use_40_mode = 1;
        } else if (strcmp(argv[i], "/w") == 0 && i + 1 < argc) {
            words_file = argv[++i];
        } else if (strcmp(argv[i], "/hard") == 0) {
            hard_mode = 1;
        } else if (strcmp(argv[i], "/h") == 0) {
            print_help();
            return 0;
        } else {
            set_80x25_text_mode();
            fprintf(stderr, "Unbekannter Parameter: %s\n", argv[i]);
            print_help();
            return 1;
        }
    }

    if (use_40_mode) {
        set_40x25_text_mode();
    } else {
        set_80x25_text_mode();
    }

    srand((unsigned)time(NULL));
    load_words(words_file);
    clear_screen();

    secret = words[rand() % word_count];
    memset(grid, 0, sizeof(grid));
    memset(grid_attr, 0, sizeof(grid_attr));
    memset(key_attr, 0, sizeof(key_attr));

    row = 0;
    col = 0;
    won = 0;
    draw_grid(row, col);
    draw_keyboard();

        
    if (hard_mode) {
        gotoxy(0, MAX_GUESSES+5);
        printf("Hard Mode aktiviert!\n");
    }

    while (row < MAX_GUESSES) {
        unsigned char ch;
        int valid;

        ch = getch_bios();

        if (ch == 0x08) { //Backspace
            if (col > 0) {
                col--;
                grid[row][col] = '\0';
            }
        } else if (isalpha(ch) && col < WORD_LENGTH) {
            grid[row][col] = toupper(ch); /* Everything back than was UPPERCASE. And so we made the Filename WORDLE_C89.C */

            print_char_status(grid[row][col], secret, col); // Print status of the entered character

            col++;

            if (col == WORD_LENGTH) {
                if (hard_mode) {        /* this was tough to implent too. */
                    valid = 1;
                    for (i = 0; i < WORD_LENGTH; i++) {
                        if (key_attr[grid[row-1][i] - 'A'] == ATTR_GREEN || key_attr[grid[row-1][i] - 'A'] == ATTR_YELLOW) {
                            int found = 0;
                            int j;
                            for (j = 0; j < WORD_LENGTH; j++) {
                                if (grid[row][j] == grid[row-1][i]) {
                                    found = 1;
                                    break;
                                }
                            }
                            if (!found) {
                                valid = 0;
                                break;
                            }
                        }
                    }
                    if (!valid) {
                        gotoxy(0, MAX_GUESSES+7);
                        printf("Hard Mode: Buchstaben aus letztem Versuch wiederverwenden!\n");
                        col = 0;
                        memset(grid[row], 0, sizeof(grid[row]));
                        continue;
                    }
                }

                if (check_guess(row, secret)) {
                    won = 1;
                    break;
                }
                row++;
                col = 0;
            }
        }

        draw_grid(row, col);
        draw_keyboard();
    }

    gotoxy(0, MAX_GUESSES + 8);
    printf("\nBeliebige Taste zum Beenden druecken...\n\n");
    if (won) {
        printf("Gewonnen! Wort: %s\n", secret);
    } else {
        printf("Verloren! Wort: %s\n", secret);
    }
    
    getch_bios();

    set_80x25_text_mode();
    return 0;
}

/**
Final Words: Why so many comments ? 
Coding for free is ART. Its a way to express ourself.
We wrote it while havin a good time and hope you had a good one reading compiling and playing too!
Thanks for FreeDOS!
Dedicated to kind people such as A. Röwekamp and J. Hunger. MissYa
**/